from collections.abc import Hashable
from typing import overload

import numpy as np
import pandas as pd
from pandas import Index
from pandas.core.indexes.accessors import PeriodIndexFieldOps
from pandas.core.indexes.base import _IndexGetitemMixin
from pandas.core.indexes.datetimelike import (
    DatetimeIndexOpsMixin as DatetimeIndexOpsMixin,
)
from pandas.core.indexes.timedeltas import TimedeltaIndex

from pandas._libs.tslibs import (
    BaseOffset,
    NaTType,
    Period,
)
from pandas._libs.tslibs.period import _PeriodAddSub

# type ignore needed because of __getitem__()
class PeriodIndex(  # type: ignore[misc]
    _IndexGetitemMixin[Period],
    DatetimeIndexOpsMixin,
    PeriodIndexFieldOps,
):
    def __new__(
        cls,
        data=...,
        ordinal=...,
        freq=...,
        tz=...,
        dtype=...,
        copy: bool = ...,
        name=...,
        **fields,
    ): ...
    @property
    def values(self): ...
    def __contains__(self, key) -> bool: ...
    @overload
    def __sub__(self, other: Period) -> Index: ...
    @overload
    def __sub__(self, other: PeriodIndex) -> Index: ...
    @overload
    def __sub__(self, other: _PeriodAddSub) -> PeriodIndex: ...
    @overload
    def __sub__(self, other: NaTType) -> NaTType: ...
    @overload
    def __sub__(self, other: TimedeltaIndex | pd.Timedelta) -> PeriodIndex: ...
    @overload  # type: ignore[override]
    def __rsub__(self, other: Period) -> Index: ...
    @overload
    def __rsub__(self, other: PeriodIndex) -> Index: ...
    @overload
    def __rsub__(self, other: NaTType) -> NaTType: ...
    def __array__(self, dtype=...) -> np.ndarray: ...
    def __array_wrap__(self, result, context=...): ...
    def asof_locs(self, where, mask): ...
    def astype(self, dtype, copy: bool = ..., how: str = ...): ...
    def searchsorted(self, value, side: str = ..., sorter=...): ...
    @property
    def is_full(self) -> bool: ...
    @property
    def inferred_type(self) -> str: ...
    def get_value(self, series, key): ...
    def get_indexer(self, target, method=..., limit=..., tolerance=...): ...
    def get_indexer_non_unique(self, target): ...
    def get_loc(self, key, tolerance=...): ...
    def insert(self, loc, item): ...
    def join(
        self,
        other,
        *,
        how: str = ...,
        level=...,
        return_indexers: bool = ...,
        sort: bool = ...,
    ): ...
    def intersection(self, other, sort: bool = ...): ...
    def difference(self, other, sort=...): ...
    def memory_usage(self, deep: bool = ...): ...
    @property
    def freqstr(self) -> str: ...

def period_range(
    start: str | pd.Period | None = ...,
    end: str | pd.Period | None = ...,
    periods: int | None = ...,
    freq: str | BaseOffset | None = ...,
    name: Hashable | None = ...,
) -> PeriodIndex: ...
