# Generated by Django 3.1.13 on 2021-09-10 20:12

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("nautobot_device_lifecycle_mgmt", "0002_softwarelcm"),
    ]

    operations = [
        migrations.CreateModel(
            name="ProviderLCM",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("physical_address", models.CharField(blank=True, max_length=200)),
                ("country", models.CharField(blank=True, max_length=3)),
                ("phone", models.CharField(blank=True, max_length=20)),
                ("email", models.EmailField(blank=True, max_length=254)),
                ("portal_url", models.URLField(blank=True)),
                ("comments", models.TextField(blank=True)),
            ],
            options={
                "verbose_name": "Contract Provider",
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="ContractLCM",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("number", models.CharField(blank=True, max_length=100, null=True)),
                ("start", models.DateField(blank=True, null=True)),
                ("end", models.DateField(blank=True, null=True)),
                ("cost", models.DecimalField(blank=True, decimal_places=2, max_digits=15, null=True)),
                ("support_level", models.CharField(blank=True, max_length=64, null=True)),
                ("currency", models.CharField(blank=True, max_length=4, null=True)),
                ("contract_type", models.CharField(blank=True, max_length=32, null=True)),
                ("comments", models.TextField(blank=True)),
                (
                    "provider",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="nautobot_device_lifecycle_mgmt.providerlcm",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "Contract",
                "ordering": ("name", "start"),
            },
        ),
        migrations.CreateModel(
            name="ContactLCM",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=80, null=True)),
                ("address", models.CharField(blank=True, max_length=200)),
                ("phone", models.CharField(blank=True, max_length=20)),
                ("email", models.EmailField(blank=True, max_length=254)),
                ("comments", models.TextField(blank=True)),
                ("priority", models.PositiveIntegerField(default=100)),
                ("type", models.CharField(default="Unassigned", max_length=50)),
                (
                    "contract",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="nautobot_device_lifecycle_mgmt.contractlcm",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "Contract POC",
                "ordering": ("contract", "priority", "name"),
                "unique_together": {("contract", "name")},
            },
        ),
    ]
