# Generated by Django 3.1.13 on 2021-12-01 10:56

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("dcim", "0005_device_local_context_schema"),
        ("extras", "0013_default_fallback_value_computedfield"),
        ("nautobot_device_lifecycle_mgmt", "0004_validated_software_m2m"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="providerlcm",
            options={"ordering": ("name",), "verbose_name": "Vendor"},
        ),
        migrations.CreateModel(
            name="InventoryItemSoftwareValidationResult",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("is_validated", models.BooleanField(blank=True, null=True)),
                ("last_run", models.DateTimeField(blank=True, null=True)),
                ("run_type", models.CharField(max_length=50)),
                (
                    "inventory_item",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="inventoryitem_software_validation",
                        to="dcim.inventoryitem",
                    ),
                ),
                (
                    "software",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="nautobot_device_lifecycle_mgmt.softwarelcm",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "Inventory Item Software Validation Report",
                "ordering": ("inventory_item",),
            },
        ),
        migrations.CreateModel(
            name="DeviceSoftwareValidationResult",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("is_validated", models.BooleanField(blank=True, null=True)),
                ("last_run", models.DateTimeField(blank=True, null=True)),
                ("run_type", models.CharField(max_length=50)),
                (
                    "device",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="device_software_validation",
                        to="dcim.device",
                    ),
                ),
                (
                    "software",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="nautobot_device_lifecycle_mgmt.softwarelcm",
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "verbose_name": "Device Software Validation Report",
                "ordering": ("device",),
            },
        ),
    ]
