# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nautobot_device_lifecycle_mgmt',
 'nautobot_device_lifecycle_mgmt.api',
 'nautobot_device_lifecycle_mgmt.graphql',
 'nautobot_device_lifecycle_mgmt.migrations',
 'nautobot_device_lifecycle_mgmt.tests']

package_data = \
{'': ['*'],
 'nautobot_device_lifecycle_mgmt': ['templates/nautobot_device_lifecycle_mgmt/*',
                                    'templates/nautobot_device_lifecycle_mgmt/inc/*']}

install_requires = \
['matplotlib>=3.3.4,<4.0.0', 'pycountry>=20.7.3,<21.0.0']

setup_kwargs = {
    'name': 'nautobot-device-lifecycle-mgmt',
    'version': '0.3.0',
    'description': 'Manages device lifecycles for platforms and software.',
    'long_description': '# Nautobot Plugin - Device Lifecycle Management\n\nA plugin for [Nautobot](https://github.com/nautobot/nautobot) to manage device lifecycles. This plugin works by making related associations to Devices, Device Types, and Inventory Items to help provide data about the hardware end of life notices, appropriate software versions to be running on the devices, and the maintenance contracts associated with devices. This will help with the various aspects of planning life cycle events, and provides quick access to ancillary data about the devices in Nautobot.\n\n## Installation\n\n### Installation\n\nThe plugin is available as a Python package in pypi and can be installed with pip\n\n```shell\npip install nautobot-device-lifecycle-mgmt\n```\n\n> The plugin is compatible with Nautobot 1.0.1 and higher\n\nTo ensure Nautobot Device Life Cycle Management plugin is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot-plugin-device-lifecycle-mgmt` package:\n\n```no-highlight\n# echo nautobot-device-lifecycle-mgmt >> local_requirements.txt\n```\n\n### Installation Continued\n\nOnce installed, the plugin needs to be enabled in your `configuration.py`\n\n```python\n# In your configuration.py, if following docs -> /opt/nautobot/nautobot_config.py\nPLUGINS = ["nautobot_device_lifecycle_mgmt"]\n```\n\n### Run Post Upgrade Steps\n\nOnce the configuration has been updated, run the post migration script as the Nautobot user\n\n```\nnautobot-server post_upgrade\n```\n\nThis should run migrations for the plugin to be ready for use.\n\n### Restart Nautobot Services\n\nAs a user account that has privileges to restart services, restart the Nautobot services\n\n```\nsudo systemctl restart nautobot nautobot-worker\n```\n\nIf you are on Nautobot >= 1.1.0 and have the RQ worker continuing on, also restart the RQ worker service.\n\n```\nsudo systemctl restart nautobot-rq-worker\n```\n\n## Documentation\n- [Software lifecycle](./docs/software_lifecycle.md)\n\n## Usage\n\n### Adding Information into the Plugin\n\nThe system currently has manual/API entry of data only. There are currently no connections to any particular vendor APIs that provide this data today. See [adding data docs](docs/add_information.md) for more info.\n### Hardware Lifecycle Management\n#### API\n![](docs/images/lcm_hardware_api_view.png)\n\n##### REST API Example 1\nGather hardware notices that will be end of support by the end of 2021\n```shell script\ncurl "http://$NBHOST/api/plugins/device-lifecycle/hardware/?end_of_support__lte=2021-12-31" \\\n-X GET \\\n-H  "accept: application/json" \\\n-H  "Authorization: Token $TOKEN" | json_pp\n````\n\n##### REST API Example 2\nGather hardware notices that are currently expired. \n> NOTE: `expired` flag will honor `end_of_support` if the field exist for the record. If the field does not exist, `end_of_sale` will be used as the expired field.\n```shell script\ncurl "http://$NBHOST/api/plugins/device-lifecycle/hardware/?expired=true" \\  \n-X GET \\\n-H  "accept: application/json" \\\n-H  "Authorization: Token $TOKEN" | json_pp\n```\n\n#### GraphQL Examples\n![](docs/images/lcm_hardware_graphql.png)\n\n## Contributing\n\nPull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of Nautobot through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code software development guideline and is leveraging:\n\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### CLI Helper Commands\n\nThe project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`. \n\nEach command can be executed with `invoke <command>`. All commands support the arguments `--nautobot-ver` and `--python-ver` if you want to manually define the version of Python and Nautobot to use. Each command also has its own help `invoke <command> --help`\n\n#### Local dev environment\n\n```no-highlight\n  build            Build all docker images.\n  debug            Start Nautobot and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  restart          Restart Nautobot and its dependencies.\n  start            Start Nautobot and its dependencies in detached mode.\n  stop             Stop Nautobot and its dependencies.\n```\n\n#### Utility\n\n```no-highlight\n  cli              Launch a bash shell inside the running Nautobot container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n```\n\n#### Testing\n\n```no-highlight\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  flake8           This will run flake8 for the specified name and Python version.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  pylint           Run pylint code analysis.\n  tests            Run all tests for this plugin.\n  unittest         Run Django unit tests for the plugin.\n```\n\n## Screenshots\n\n### Hardware: Device Life Cycle Management List View\n\nYou can view the list of Hardware/Software notices as well as filter the table.\n\n![](docs/images/lcm_hardware_list_view.png)\n\n\n### Hardware: Device Life Cycle Management Detail View\n\nYou can also click a Hardware/Software Notice and see the detail view. This view provides links to the devices that are part affected by this EoX notice due to their device type.\n\n![](docs/images/lcm_hardware_detail_view.png)\n\n### Device View\n\nYou can also view the associated Hardware notice from the device. If the device is end of life or end of support the notice will be red.\n\n![](docs/images/lcm_hardware_device_view.png)\n\n### Device Type View\n\nThis provides the same UI element as the device view, but within the specific device type\'s view.\n\n![](docs/images/lcm_hardware_device_type_view.png)\n\n### Contracts: Device Life Cycle Management Contract Detail View\n\nYou can view the details of a contract along with the primary and escalation contacts. This view will also give you an association to the devices under this contract.\n\n![](docs/images/lcm_contract_detail.png)\n\n\n### Contracts: Device Life Cycle Management Contract Provider View\n\nYou can view the details of a provider, along with a listing of the service contracts associated to the provider. Contracts that are expired will display in red.\n\n![](docs/images/lcm_contract_provider_detail.png)\n\n### Software: Software Life Cycle Management List View\n\nYou can view the list of Software versions as well as filter the table.\n\n![](docs/images/lcm_software_list_view.png)\n\n\n### Software: Software Life Cycle Detail View\n\nYou can also click a Software version and see the detail view. This view provides link to the list of devices and inventory items that are associated with this software object.\n\n![](docs/images/lcm_software_detail_view.png)\n\n### Software: Validated Software Life Cycle Management List View\n\nYou can view the list of Validated Software versions as well as filter the table.\n\n![](docs/images/lcm_validated_software_list_view.png)\n\n### Software: Validated Software Life Cycle Detail View\n\nYou can also click a Validated Software version and see the detail view. This view provides view of the device and inventory item attributes this validated software applies to.\n\n![](docs/images/lcm_validated_software_detail_view.png)\n\n### Software: Device View\n\nYou can also view the associated Software and Validated Software versions from the device. If the Software assigned to the device matches Validated Software for this device, the Software will be displayed in green. If it\'s invalid it will be displayed in red.\n\n**Valid software:**\n\n![](docs/images/lcm_software_device_view_valid.png)\n\n**Invalid software:**\n\n![](docs/images/lcm_software_device_view_invalid.png)',
    'author': 'Josh Silvas',
    'author_email': 'josh.silvas@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/networktocode-llc/nautobot-plugin-device-lifecycle-mgmt',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
