from os import PathLike
from typing import Any, Optional, Mapping, Union, List, Dict


class Configuration:
    host: str = ...
    refresh_api_key_hook: Any = ...
    username: Optional[str] = ...
    password: Optional[str] = ...
    discard_unknown_keys: Optional[bool] = ...
    verify_ssl: bool = ...
    ssl_ca_cert: Optional[str] = ...
    cert_file: Optional[str] = ...
    key_file: Optional[str] = ...
    assert_hostname: Optional[bool] = ...
    connection_pool_maxsize: int = ...
    proxy: Optional[str] = ...
    proxy_headers: Optional[Mapping[str, Any]] = ...
    safe_chars_for_path_param: str = ...
    client_side_validation: bool = ...

    def __init__(
        self,
        host: str = ...,
        api_key: Optional[dict] = ...,
        api_key_prefix: Optional[str] = ...,
        username: Optional[str] = ...,
        password: Optional[str] = ...,
        discard_unknown_keys: bool = ...,
    ) -> None: ...

    @property
    def logger_file(self) -> Optional[Union[str, PathLike[str]]]: ...

    @logger_file.setter
    def logger_file(self, value: Union[str, PathLike[str]]) -> None: ...
    @property

    def logger_format(self) -> Optional[str]: ...

    @logger_format.setter
    def logger_format(self, value: str) -> None: ...

    def get_api_key_with_prefix(self, identifier: str) -> Optional[str]: ...

    def get_basic_auth_token(self): ...

    def auth_settings(self): ...

    def get_host_settings(self) -> List[Dict[str, str]]: ...

    def get_host_from_settings(self, index: int, variables: Optional[Dict[str, str]] = ...) -> str: ...
