# coding: utf-8

"""
    Yagna Market API

     ## Yagna Market The Yagna Market is a core component of the Yagna Network, which enables computational Offers and Demands circulation. The Market is open for all entities willing to buy computations (Demands) or monetize computational resources (Offers). ## Yagna Market API The Yagna Market API is the entry to the Yagna Market through which Requestors and Providers can publish their Demands and Offers respectively, find matching counterparty, conduct negotiations and make an agreement.  This version of Market API conforms with capability level 1 of the <a href=\"https://docs.google.com/document/d/1Zny_vfgWV-hcsKS7P-Kdr3Fb0dwfl-6T_cYKVQ9mkNg\"> Market API specification</a>.  Market API contains two roles: Requestors and Providers which are symmetrical most of the time (excluding agreement phase).   # noqa: E501

    The version of the OpenAPI document: 1.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ya_market.configuration import Configuration


class PropertyQuery(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'issuer_properties': 'object',
        'query_id': 'str',
        'queried_properties': 'list[str]'
    }

    attribute_map = {
        'issuer_properties': 'issuerProperties',
        'query_id': 'queryId',
        'queried_properties': 'queriedProperties'
    }

    def __init__(self, issuer_properties=None, query_id=None, queried_properties=None, local_vars_configuration=None):  # noqa: E501
        """PropertyQuery - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._issuer_properties = None
        self._query_id = None
        self._queried_properties = None
        self.discriminator = None

        if issuer_properties is not None:
            self.issuer_properties = issuer_properties
        if query_id is not None:
            self.query_id = query_id
        if queried_properties is not None:
            self.queried_properties = queried_properties

    @property
    def issuer_properties(self):
        """Gets the issuer_properties of this PropertyQuery.  # noqa: E501


        :return: The issuer_properties of this PropertyQuery.  # noqa: E501
        :rtype: object
        """
        return self._issuer_properties

    @issuer_properties.setter
    def issuer_properties(self, issuer_properties):
        """Sets the issuer_properties of this PropertyQuery.


        :param issuer_properties: The issuer_properties of this PropertyQuery.  # noqa: E501
        :type: object
        """

        self._issuer_properties = issuer_properties

    @property
    def query_id(self):
        """Gets the query_id of this PropertyQuery.  # noqa: E501


        :return: The query_id of this PropertyQuery.  # noqa: E501
        :rtype: str
        """
        return self._query_id

    @query_id.setter
    def query_id(self, query_id):
        """Sets the query_id of this PropertyQuery.


        :param query_id: The query_id of this PropertyQuery.  # noqa: E501
        :type: str
        """

        self._query_id = query_id

    @property
    def queried_properties(self):
        """Gets the queried_properties of this PropertyQuery.  # noqa: E501


        :return: The queried_properties of this PropertyQuery.  # noqa: E501
        :rtype: list[str]
        """
        return self._queried_properties

    @queried_properties.setter
    def queried_properties(self, queried_properties):
        """Sets the queried_properties of this PropertyQuery.


        :param queried_properties: The queried_properties of this PropertyQuery.  # noqa: E501
        :type: list[str]
        """

        self._queried_properties = queried_properties

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PropertyQuery):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PropertyQuery):
            return True

        return self.to_dict() != other.to_dict()
