# coding: utf-8

"""
    Yagna Payment API

     Invoicing and Payments is a fundamental area of Yagna Ecosystem functionality. It includes aspects of communication between Requestor, Provider and a selected Payment Platform, which becomes crucial when Activities are executed in the context of negotiated Agreements. Yagna applications must be able to exercise various payment models, and the Invoicing/Payment-related communication is happening in parallel to Activity control communication. To define functional patterns of Requestor/Provider interaction in this area, Payment API is specified.  An important principle of the Yagna Payment API is that the actual payment transactions are hidden behind the Invoice flow. In other words, a Yagna Application on Requestor side isn’t expected to trigger actual payment transactions. Instead it is expected to receive and accept Invoices raised by the Provider - based on Application’s Invoice Accept notifications, the Payment API implementation orchestrates the payment via a configured Payment platform.  **NOTE: This specification is work-in-progress.**   # noqa: E501

    The version of the OpenAPI document: 1.2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ya_payment.api_client import ApiClient
from ya_payment.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ProviderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_debit_note(self, debit_node_id, **kwargs):  # noqa: E501
        """Cancel Debit Note.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Debit Note or timeout has passed. The Requestor may refuse to cancel the Debit Note if they have already paid it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_debit_note(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_debit_note_with_http_info(debit_node_id, **kwargs)  # noqa: E501

    def cancel_debit_note_with_http_info(self, debit_node_id, **kwargs):  # noqa: E501
        """Cancel Debit Note.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Debit Note or timeout has passed. The Requestor may refuse to cancel the Debit Note if they have already paid it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_debit_note_with_http_info(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_node_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_node_id' is set
        if self.api_client.client_side_validation and ('debit_node_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_node_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_node_id` when calling `cancel_debit_note`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `cancel_debit_note`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'debit_node_id' in local_var_params:
            path_params['debitNodeId'] = local_var_params['debit_node_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/debitNotes/{debitNodeId}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cancel_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Cancel Invoice.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Invoice or timeout has passed. The Requestor may refuse to cancel the Invoice if they have already paid it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def cancel_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Cancel Invoice.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Invoice or timeout has passed. The Requestor may refuse to cancel the Invoice if they have already paid it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `cancel_invoice`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `cancel_invoice`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/invoices/{invoiceId}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_incoming_payment(self, payment_id, **kwargs):  # noqa: E501
        """Get incoming Payment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incoming_payment(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str payment_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Allocation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_incoming_payment_with_http_info(payment_id, **kwargs)  # noqa: E501

    def get_incoming_payment_with_http_info(self, payment_id, **kwargs):  # noqa: E501
        """Get incoming Payment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incoming_payment_with_http_info(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str payment_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Allocation, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'payment_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_incoming_payment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'payment_id' is set
        if self.api_client.client_side_validation and ('payment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['payment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `payment_id` when calling `get_incoming_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in local_var_params:
            path_params['paymentId'] = local_var_params['payment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/payments/{paymentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Allocation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_incoming_payments(self, **kwargs):  # noqa: E501
        """Get incoming Payments.  # noqa: E501

        Payments can be treated as events and this method can be used to listen for new payments by long-polling.  If there are any payments the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `laterThan` parameter can be used in order to get just the 'new' payments. Setting the parameter value to the timestamp of the last processed payment ensures that no payments will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incoming_payments(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0 means it should return immediately if there are no events) 
        :param datetime later_than: Show only events later than specified timeout
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_incoming_payments_with_http_info(**kwargs)  # noqa: E501

    def get_incoming_payments_with_http_info(self, **kwargs):  # noqa: E501
        """Get incoming Payments.  # noqa: E501

        Payments can be treated as events and this method can be used to listen for new payments by long-polling.  If there are any payments the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `laterThan` parameter can be used in order to get just the 'new' payments. Setting the parameter value to the timestamp of the last processed payment ensures that no payments will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_incoming_payments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0 means it should return immediately if there are no events) 
        :param datetime later_than: Show only events later than specified timeout
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Payment], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'later_than'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_incoming_payments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `get_incoming_payments`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'later_than' in local_var_params and local_var_params['later_than'] is not None:  # noqa: E501
            query_params.append(('laterThan', local_var_params['later_than']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_issued_debit_note(self, debit_node_id, **kwargs):  # noqa: E501
        """Get Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_debit_note(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DebitNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_issued_debit_note_with_http_info(debit_node_id, **kwargs)  # noqa: E501

    def get_issued_debit_note_with_http_info(self, debit_node_id, **kwargs):  # noqa: E501
        """Get Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_debit_note_with_http_info(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DebitNote, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_node_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_issued_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_node_id' is set
        if self.api_client.client_side_validation and ('debit_node_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_node_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_node_id` when calling `get_issued_debit_note`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'debit_node_id' in local_var_params:
            path_params['debitNodeId'] = local_var_params['debit_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/debitNotes/{debitNodeId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebitNote',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_issued_debit_notes(self, **kwargs):  # noqa: E501
        """Get Debit Notes issued by this Provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_debit_notes(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DebitNote]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_issued_debit_notes_with_http_info(**kwargs)  # noqa: E501

    def get_issued_debit_notes_with_http_info(self, **kwargs):  # noqa: E501
        """Get Debit Notes issued by this Provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_debit_notes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DebitNote], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_issued_debit_notes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/debitNotes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DebitNote]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_issued_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Get Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_issued_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def get_issued_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Get Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Invoice, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_issued_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `get_issued_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/invoices/{invoiceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_issued_invoices(self, **kwargs):  # noqa: E501
        """Get Invoices issued by this Provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_invoices(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Invoice]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_issued_invoices_with_http_info(**kwargs)  # noqa: E501

    def get_issued_invoices_with_http_info(self, **kwargs):  # noqa: E501
        """Get Invoices issued by this Provider.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_issued_invoices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Invoice], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_issued_invoices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/invoices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Invoice]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments_for_issued_debit_note(self, debit_node_id, **kwargs):  # noqa: E501
        """Get Payments for Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_issued_debit_note(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_payments_for_issued_debit_note_with_http_info(debit_node_id, **kwargs)  # noqa: E501

    def get_payments_for_issued_debit_note_with_http_info(self, debit_node_id, **kwargs):  # noqa: E501
        """Get Payments for Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_issued_debit_note_with_http_info(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Payment], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_node_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments_for_issued_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_node_id' is set
        if self.api_client.client_side_validation and ('debit_node_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_node_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_node_id` when calling `get_payments_for_issued_debit_note`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'debit_node_id' in local_var_params:
            path_params['debitNodeId'] = local_var_params['debit_node_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/debitNotes/{debitNodeId}/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments_for_issued_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Get Payments for issued Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_issued_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_payments_for_issued_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def get_payments_for_issued_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Get Payments for issued Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_issued_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Payment], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments_for_issued_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `get_payments_for_issued_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/invoices/{invoiceId}/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_provider_debit_note_events(self, **kwargs):  # noqa: E501
        """Get Debit Note events.  # noqa: E501

        Listen for Debit Note-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `laterThan` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_provider_debit_note_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0 means it should return immediately if there are no events) 
        :param datetime later_than: Show only events later than specified timeout
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InvoiceEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_provider_debit_note_events_with_http_info(**kwargs)  # noqa: E501

    def get_provider_debit_note_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get Debit Note events.  # noqa: E501

        Listen for Debit Note-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `laterThan` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_provider_debit_note_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0 means it should return immediately if there are no events) 
        :param datetime later_than: Show only events later than specified timeout
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InvoiceEvent], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'later_than'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_provider_debit_note_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `get_provider_debit_note_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'later_than' in local_var_params and local_var_params['later_than'] is not None:  # noqa: E501
            query_params.append(('laterThan', local_var_params['later_than']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/debitNoteEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InvoiceEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_provider_invoice_events(self, **kwargs):  # noqa: E501
        """Get Invoice events.  # noqa: E501

        Listen for Invoice-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `laterThan` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_provider_invoice_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0 means it should return immediately if there are no events) 
        :param datetime later_than: Show only events later than specified timeout
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InvoiceEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_provider_invoice_events_with_http_info(**kwargs)  # noqa: E501

    def get_provider_invoice_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get Invoice events.  # noqa: E501

        Listen for Invoice-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `laterThan` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_provider_invoice_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: How many seconds server should wait for new events (0 means it should return immediately if there are no events) 
        :param datetime later_than: Show only events later than specified timeout
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InvoiceEvent], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'later_than'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_provider_invoice_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `get_provider_invoice_events`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'later_than' in local_var_params and local_var_params['later_than'] is not None:  # noqa: E501
            query_params.append(('laterThan', local_var_params['later_than']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/invoiceEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InvoiceEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issue_debit_note(self, debit_note, **kwargs):  # noqa: E501
        """Issue a Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_debit_note(debit_note, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DebitNote debit_note: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DebitNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.issue_debit_note_with_http_info(debit_note, **kwargs)  # noqa: E501

    def issue_debit_note_with_http_info(self, debit_note, **kwargs):  # noqa: E501
        """Issue a Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_debit_note_with_http_info(debit_note, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DebitNote debit_note: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DebitNote, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_note'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_note' is set
        if self.api_client.client_side_validation and ('debit_note' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_note'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_note` when calling `issue_debit_note`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'debit_note' in local_var_params:
            body_params = local_var_params['debit_note']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/debitNotes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebitNote',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issue_invoice(self, invoice, **kwargs):  # noqa: E501
        """Issue an Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_invoice(invoice, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Invoice invoice: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.issue_invoice_with_http_info(invoice, **kwargs)  # noqa: E501

    def issue_invoice_with_http_info(self, invoice, **kwargs):  # noqa: E501
        """Issue an Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_invoice_with_http_info(invoice, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Invoice invoice: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Invoice, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice' is set
        if self.api_client.client_side_validation and ('invoice' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice` when calling `issue_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice' in local_var_params:
            body_params = local_var_params['invoice']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/invoices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_debit_note(self, debit_node_id, **kwargs):  # noqa: E501
        """Send Debit Note to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Debit Note or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_debit_note(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_debit_note_with_http_info(debit_node_id, **kwargs)  # noqa: E501

    def send_debit_note_with_http_info(self, debit_node_id, **kwargs):  # noqa: E501
        """Send Debit Note to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Debit Note or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_debit_note_with_http_info(debit_node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_node_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_node_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_node_id' is set
        if self.api_client.client_side_validation and ('debit_node_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_node_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_node_id` when calling `send_debit_note`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `send_debit_note`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'debit_node_id' in local_var_params:
            path_params['debitNodeId'] = local_var_params['debit_node_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/debitNotes/{debitNodeId}/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Send Invoice to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Invoice or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def send_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Send Invoice to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Invoice or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: How many seconds server should wait for acknowledgement from the remote party (0 means forever) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `send_invoice`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `send_invoice`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/provider/invoices/{invoiceId}/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
