![Tests](https://github.com/SyntropyNet/syntropy-python-sdk/workflows/Tests/badge.svg)
![PyPi](https://github.com/SyntropyNet/syntropy-python-sdk/workflows/PyPi/badge.svg)

# Syntropy SDK
Syntropy SDK for Python allows you to manage Syntropy Networks using simple Python interface.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 0.1.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 3.6+

## Installation & Usage
### pip install

Install the SDK simply using pip:

```sh
pip install syntropy_sdk
```

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/SyntropyNet/syntropy-python-sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/SyntropyNet/syntropy-python-sdk.git`)

Then import the package:
```python
import syntropy_sdk 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import syntropy_sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then use the following as a reference:

```python
from __future__ import print_function
import time
import syntropy_sdk
from syntropy_sdk.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
code = 'code_example' # str | Account deletion code (received by mail).

try:
    api_response = api_instance.delete_account(code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->delete_account: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | Email verification code (received by mail).

try:
    api_response = api_instance.deprecated_verify_email(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->deprecated_verify_email: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
ip = 'ip_example' # str | 

try:
    api_response = api_instance.geo_ip(ip)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->geo_ip: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.local(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->local: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))

try:
    api_instance.logout()
except ApiException as e:
    print("Exception when calling AuthApi->logout: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.pair_latency_test_report(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->pair_latency_test_report: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = [syntropy_sdk.UserPairLatencyTestReportObject()] # list[UserPairLatencyTestReportObject] | 

try:
    api_response = api_instance.pair_latency_test_report_bulk(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->pair_latency_test_report_bulk: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.pair_speedtest_report(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->pair_speedtest_report: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.provider_attach(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_attach: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.provider_detach(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_detach: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.provider_login(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_login: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
attach = syntropy_sdk.AutoAttach() # AutoAttach |  (optional)

try:
    api_response = api_instance.provider_register(body, attach=attach)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->provider_register: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
refresh_token = 'refresh_token_example' # str | 

try:
    api_response = api_instance.refresh(refresh_token)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->refresh: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = syntropy_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.register(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->register: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.reset_password(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->reset_password: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
ref = syntropy_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.set_delete_account_code(ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->set_delete_account_code: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = syntropy_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.set_reset_password_code(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->set_reset_password_code: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = syntropy_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.set_verify_email_code(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->set_verify_email_code: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.speedtest_report(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->speedtest_report: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))

try:
    api_response = api_instance.user()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 
ref = syntropy_sdk.MailBodyTemplates() # MailBodyTemplates |  (optional)

try:
    api_response = api_instance.user_change_email(body, ref=ref)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_change_email: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_instance.user_change_password(body)
except ApiException as e:
    print("Exception when calling AuthApi->user_change_password: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_instance.user_destroy(body)
except ApiException as e:
    print("Exception when calling AuthApi->user_destroy: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
body = NULL # dict(str, object) | 

try:
    api_response = api_instance.user_hosts_create(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_hosts_create: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
id = 1.2 # float | 

try:
    api_response = api_instance.user_hosts_destroy(id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_hosts_destroy: %s\n" % e)

# Configure API key authorization: jwt
configuration = syntropy_sdk.Configuration()
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))

try:
    api_response = api_instance.user_hosts_index()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->user_hosts_index: %s\n" % e)

# create an instance of the API class
api_instance = syntropy_sdk.AuthApi(syntropy_sdk.ApiClient(configuration))
code = 'code_example' # str | Email verification code (received by mail).

try:
    api_response = api_instance.verify_email(code)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AuthApi->verify_email: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to */*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | [**delete_account**](docs/AuthApi.md#delete_account) | **GET** /api/auth/delete-account/{code} | 
*AuthApi* | [**deprecated_verify_email**](docs/AuthApi.md#deprecated_verify_email) | **POST** /api/auth/verify-email | 
*AuthApi* | [**geo_ip**](docs/AuthApi.md#geo_ip) | **GET** /api/auth/{ip}/geoip | 
*AuthApi* | [**local**](docs/AuthApi.md#local) | **POST** /api/auth/local/login | 
*AuthApi* | [**logout**](docs/AuthApi.md#logout) | **POST** /api/auth/logout | 
*AuthApi* | [**pair_latency_test_report**](docs/AuthApi.md#pair_latency_test_report) | **POST** /api/auth/pair-latency-test-report | 
*AuthApi* | [**pair_latency_test_report_bulk**](docs/AuthApi.md#pair_latency_test_report_bulk) | **POST** /api/auth/pair-latency-test-report/bulk | 
*AuthApi* | [**pair_speedtest_report**](docs/AuthApi.md#pair_speedtest_report) | **POST** /api/auth/pair-speedtest-report | 
*AuthApi* | [**provider_attach**](docs/AuthApi.md#provider_attach) | **POST** /api/auth/provider/attach | 
*AuthApi* | [**provider_detach**](docs/AuthApi.md#provider_detach) | **POST** /api/auth/provider/detach | 
*AuthApi* | [**provider_login**](docs/AuthApi.md#provider_login) | **POST** /api/auth/provider/login | 
*AuthApi* | [**provider_register**](docs/AuthApi.md#provider_register) | **POST** /api/auth/provider/register | 
*AuthApi* | [**refresh**](docs/AuthApi.md#refresh) | **POST** /api/auth/refresh-token | 
*AuthApi* | [**register**](docs/AuthApi.md#register) | **POST** /api/auth/register | 
*AuthApi* | [**reset_password**](docs/AuthApi.md#reset_password) | **POST** /api/auth/reset-password | 
*AuthApi* | [**set_delete_account_code**](docs/AuthApi.md#set_delete_account_code) | **POST** /api/auth/send-delete-account-link | 
*AuthApi* | [**set_reset_password_code**](docs/AuthApi.md#set_reset_password_code) | **POST** /api/auth/send-reset-password-link | 
*AuthApi* | [**set_verify_email_code**](docs/AuthApi.md#set_verify_email_code) | **POST** /api/auth/send-verify-email-link | 
*AuthApi* | [**speedtest_report**](docs/AuthApi.md#speedtest_report) | **POST** /api/auth/speedtest-report | 
*AuthApi* | [**user**](docs/AuthApi.md#user) | **GET** /api/auth/user | 
*AuthApi* | [**user_change_email**](docs/AuthApi.md#user_change_email) | **POST** /api/auth/user/change-email | 
*AuthApi* | [**user_change_password**](docs/AuthApi.md#user_change_password) | **POST** /api/auth/user/change-password | 
*AuthApi* | [**user_destroy**](docs/AuthApi.md#user_destroy) | **POST** /api/auth/user/delete | 
*AuthApi* | [**user_hosts_create**](docs/AuthApi.md#user_hosts_create) | **POST** /api/auth/user/hosts | 
*AuthApi* | [**user_hosts_destroy**](docs/AuthApi.md#user_hosts_destroy) | **DELETE** /api/auth/user/hosts/{id} | 
*AuthApi* | [**user_hosts_index**](docs/AuthApi.md#user_hosts_index) | **GET** /api/auth/user/hosts | 
*AuthApi* | [**verify_email**](docs/AuthApi.md#verify_email) | **GET** /api/auth/verify-email/{code} | 
*PlatformApi* | [**config**](docs/PlatformApi.md#config) | **GET** /api/platform/admin/agent/{agent_id}/config | 
*PlatformApi* | [**create_agent_group**](docs/PlatformApi.md#create_agent_group) | **POST** /api/platform/network/{network_id}/agent-groups/{group_name} | 
*PlatformApi* | [**create_api_key**](docs/PlatformApi.md#create_api_key) | **POST** /api/platform/api-keys | 
*PlatformApi* | [**create_connections**](docs/PlatformApi.md#create_connections) | **POST** /api/platform/connections | 
*PlatformApi* | [**create_network**](docs/PlatformApi.md#create_network) | **POST** /api/platform/networks | 
*PlatformApi* | [**create_network_agents**](docs/PlatformApi.md#create_network_agents) | **POST** /api/platform/network/{network_id}/agents | 
*PlatformApi* | [**delete_agents**](docs/PlatformApi.md#delete_agents) | **DELETE** /api/platform/agents/{agent_id} | 
*PlatformApi* | [**delete_api_key**](docs/PlatformApi.md#delete_api_key) | **DELETE** /api/platform/api-keys/{api_key_id} | 
*PlatformApi* | [**delete_connection**](docs/PlatformApi.md#delete_connection) | **DELETE** /api/platform/connections/{connection_id} | 
*PlatformApi* | [**delete_networks**](docs/PlatformApi.md#delete_networks) | **DELETE** /api/platform/networks/{network_id} | 
*PlatformApi* | [**delete_networks_agent**](docs/PlatformApi.md#delete_networks_agent) | **DELETE** /api/platform/networks/{network_id}/agents/{agent_id} | 
*PlatformApi* | [**find_all_name_id_pairs_by_user_id**](docs/PlatformApi.md#find_all_name_id_pairs_by_user_id) | **GET** /api/platform/agents/id-name-pairs | 
*PlatformApi* | [**get_agent_services_with_subnets**](docs/PlatformApi.md#get_agent_services_with_subnets) | **GET** /api/platform/agent-services | 
*PlatformApi* | [**get_agent_tags**](docs/PlatformApi.md#get_agent_tags) | **GET** /api/platform/agent-tags | 
*PlatformApi* | [**get_connection_services**](docs/PlatformApi.md#get_connection_services) | **GET** /api/platform/connection-services | 
*PlatformApi* | [**get_network_info**](docs/PlatformApi.md#get_network_info) | **GET** /api/platform/network/{network_id}/info | 
*PlatformApi* | [**index_agents**](docs/PlatformApi.md#index_agents) | **GET** /api/platform/agents | 
*PlatformApi* | [**index_api_key**](docs/PlatformApi.md#index_api_key) | **GET** /api/platform/api-keys | 
*PlatformApi* | [**index_connections**](docs/PlatformApi.md#index_connections) | **GET** /api/platform/connections | 
*PlatformApi* | [**index_networks**](docs/PlatformApi.md#index_networks) | **GET** /api/platform/networks | 
*PlatformApi* | [**patch_agents**](docs/PlatformApi.md#patch_agents) | **PATCH** /api/platform/agents/{agent_id} | 
*PlatformApi* | [**remove_agent_group**](docs/PlatformApi.md#remove_agent_group) | **DELETE** /api/platform/network/agent-groups/{group_id} | 
*PlatformApi* | [**remove_network_agents**](docs/PlatformApi.md#remove_network_agents) | **DELETE** /api/platform/network/{network_id}/agents | 
*PlatformApi* | [**save_logs_read_timestamp**](docs/PlatformApi.md#save_logs_read_timestamp) | **POST** /api/platform/logs-reads-timestamp | 
*PlatformApi* | [**topology_networks**](docs/PlatformApi.md#topology_networks) | **GET** /api/platform/networks/topology | 
*PlatformApi* | [**update_agent_group**](docs/PlatformApi.md#update_agent_group) | **PUT** /api/platform/network/agent-groups/{group_id} | 
*PlatformApi* | [**update_agent_services_subnets_status**](docs/PlatformApi.md#update_agent_services_subnets_status) | **POST** /api/platform/agent-services-subnets | 
*PlatformApi* | [**update_api_key**](docs/PlatformApi.md#update_api_key) | **PATCH** /api/platform/api-keys/{api_key_id} | 
*PlatformApi* | [**update_connection_services**](docs/PlatformApi.md#update_connection_services) | **POST** /api/platform/connection-services | 
*ProvidersApi* | [**create**](docs/ProvidersApi.md#create) | **POST** /api/providers | 
*ProvidersApi* | [**destroy**](docs/ProvidersApi.md#destroy) | **DELETE** /api/providers/{id} | 
*ProvidersApi* | [**index**](docs/ProvidersApi.md#index) | **GET** /api/providers | 
*ProvidersApi* | [**show**](docs/ProvidersApi.md#show) | **GET** /api/providers/{id} | 
*ProvidersApi* | [**update**](docs/ProvidersApi.md#update) | **PATCH** /api/providers/{id} | 

## Documentation For Models

 - [AdminAgentConfig](docs/AdminAgentConfig.md)
 - [AdminChangePasswordObject](docs/AdminChangePasswordObject.md)
 - [AgentConnectionObject](docs/AgentConnectionObject.md)
 - [AgentConnectionResponseConnectionPerformanceArrayArray_](docs/AgentConnectionResponseConnectionPerformanceArrayArray_.md)
 - [AgentConnectionStatus](docs/AgentConnectionStatus.md)
 - [AgentGroupObject](docs/AgentGroupObject.md)
 - [AgentInterfaceBwObject](docs/AgentInterfaceBwObject.md)
 - [AgentInterfaceObject](docs/AgentInterfaceObject.md)
 - [AgentLockedFields](docs/AgentLockedFields.md)
 - [AgentMessagePayload](docs/AgentMessagePayload.md)
 - [AgentMessageType](docs/AgentMessageType.md)
 - [AgentNameIdPair](docs/AgentNameIdPair.md)
 - [AgentNetworkObject](docs/AgentNetworkObject.md)
 - [AgentObject](docs/AgentObject.md)
 - [AgentPathObject](docs/AgentPathObject.md)
 - [AgentProviderObject](docs/AgentProviderObject.md)
 - [AgentServiceObject](docs/AgentServiceObject.md)
 - [AgentServiceTypes](docs/AgentServiceTypes.md)
 - [AgentServicesUpdateObject](docs/AgentServicesUpdateObject.md)
 - [AgentServicesUpdateObjectChanges](docs/AgentServicesUpdateObjectChanges.md)
 - [AgentSuccessResponse](docs/AgentSuccessResponse.md)
 - [AgentTagObject](docs/AgentTagObject.md)
 - [AnyOfAgentMessagePayload](docs/AnyOfAgentMessagePayload.md)
 - [AnyOfPlatformAgentMessagePayload](docs/AnyOfPlatformAgentMessagePayload.md)
 - [AnyOfPlatformAgentsHitObjectSourceSeverity](docs/AnyOfPlatformAgentsHitObjectSourceSeverity.md)
 - [AnyOfPlatformResponseErrorItemValue](docs/AnyOfPlatformResponseErrorItemValue.md)
 - [AnyOfSettingsTypes](docs/AnyOfSettingsTypes.md)
 - [AnyOfVppCallableObject](docs/AnyOfVppCallableObject.md)
 - [AnyOfWgCallableObject](docs/AnyOfWgCallableObject.md)
 - [AnyOfbodyCmd](docs/AnyOfbodyCmd.md)
 - [AnyOfinlineResponse204](docs/AnyOfinlineResponse204.md)
 - [ApiKeyObject](docs/ApiKeyObject.md)
 - [AppConnectConfigObject](docs/AppConnectConfigObject.md)
 - [AppConnectConfigObjectConfig](docs/AppConnectConfigObjectConfig.md)
 - [AppConnectConfigObjectConfigParams](docs/AppConnectConfigObjectConfigParams.md)
 - [AppConnectConfigObjectMetadata](docs/AppConnectConfigObjectMetadata.md)
 - [AppConnectObject](docs/AppConnectObject.md)
 - [AppDisconnectObject](docs/AppDisconnectObject.md)
 - [AppDisconnectToStatusTypes](docs/AppDisconnectToStatusTypes.md)
 - [AppObject](docs/AppObject.md)
 - [AppReconnect](docs/AppReconnect.md)
 - [AppRoutesObject](docs/AppRoutesObject.md)
 - [AppServerObject](docs/AppServerObject.md)
 - [AppShowRoutes](docs/AppShowRoutes.md)
 - [AppSkipSdn](docs/AppSkipSdn.md)
 - [AppStatus](docs/AppStatus.md)
 - [AppUserSrObject](docs/AppUserSrObject.md)
 - [AppUserSrObjectConstrains](docs/AppUserSrObjectConstrains.md)
 - [AppVersionObject](docs/AppVersionObject.md)
 - [AppVpnServerObject](docs/AppVpnServerObject.md)
 - [AppWaitConf](docs/AppWaitConf.md)
 - [AppWebSocketObject](docs/AppWebSocketObject.md)
 - [AppWsStatus](docs/AppWsStatus.md)
 - [AppsWebSocketsDisconnectObject](docs/AppsWebSocketsDisconnectObject.md)
 - [AuthInfo](docs/AuthInfo.md)
 - [AuthUserObject](docs/AuthUserObject.md)
 - [AutoAttach](docs/AutoAttach.md)
 - [AutoPingPayload](docs/AutoPingPayload.md)
 - [BehaviorType](docs/BehaviorType.md)
 - [BiStatistics](docs/BiStatistics.md)
 - [BiStatisticsEdgesPost](docs/BiStatisticsEdgesPost.md)
 - [Body](docs/Body.md)
 - [Body1](docs/Body1.md)
 - [Body2](docs/Body2.md)
 - [Body3](docs/Body3.md)
 - [Body4](docs/Body4.md)
 - [ChangeEmailObject](docs/ChangeEmailObject.md)
 - [ChangePasswordObject](docs/ChangePasswordObject.md)
 - [ChangePathObject](docs/ChangePathObject.md)
 - [ChangePathObjectData](docs/ChangePathObjectData.md)
 - [ChangePathObjectDataCosts](docs/ChangePathObjectDataCosts.md)
 - [ColorObject](docs/ColorObject.md)
 - [ConnectionCreationBody](docs/ConnectionCreationBody.md)
 - [ConnectionPerformance](docs/ConnectionPerformance.md)
 - [ConstraintEnum](docs/ConstraintEnum.md)
 - [ContainerInfo](docs/ContainerInfo.md)
 - [ContentObject](docs/ContentObject.md)
 - [ContextType](docs/ContextType.md)
 - [DeleteUserObject](docs/DeleteUserObject.md)
 - [GeoIpObject](docs/GeoIpObject.md)
 - [GetInfoData](docs/GetInfoData.md)
 - [HostGroupObject](docs/HostGroupObject.md)
 - [HostObject](docs/HostObject.md)
 - [InlineResponse204](docs/InlineResponse204.md)
 - [InterfaceObject](docs/InterfaceObject.md)
 - [InterfaceType](docs/InterfaceType.md)
 - [LanguageObject](docs/LanguageObject.md)
 - [LinkObject](docs/LinkObject.md)
 - [LinkTag](docs/LinkTag.md)
 - [LogsReadTimestampEntityTypes](docs/LogsReadTimestampEntityTypes.md)
 - [LogsReadTimestampObject](docs/LogsReadTimestampObject.md)
 - [MailBodyTemplates](docs/MailBodyTemplates.md)
 - [MetadataNetworkType](docs/MetadataNetworkType.md)
 - [NetworkAgentObject](docs/NetworkAgentObject.md)
 - [NetworkAgentPayload](docs/NetworkAgentPayload.md)
 - [NetworkGenesisType](docs/NetworkGenesisType.md)
 - [NetworkInfoData](docs/NetworkInfoData.md)
 - [NetworkInfoObject](docs/NetworkInfoObject.md)
 - [NetworkMetadata](docs/NetworkMetadata.md)
 - [NetworkObject](docs/NetworkObject.md)
 - [NetworkTopologyObject](docs/NetworkTopologyObject.md)
 - [NetworkType](docs/NetworkType.md)
 - [OoklaPairSpeedtestObject](docs/OoklaPairSpeedtestObject.md)
 - [OoklaSpeedtestObject](docs/OoklaSpeedtestObject.md)
 - [OrganizationObject](docs/OrganizationObject.md)
 - [PairLatencyTestObject](docs/PairLatencyTestObject.md)
 - [PairSpeedtestType](docs/PairSpeedtestType.md)
 - [PlatformAgentMessagePayload](docs/PlatformAgentMessagePayload.md)
 - [PlatformAgentMessagePayloadData](docs/PlatformAgentMessagePayloadData.md)
 - [PlatformAgentMessageType](docs/PlatformAgentMessageType.md)
 - [PlatformAgentStatus](docs/PlatformAgentStatus.md)
 - [PlatformAgentSuccessResponse](docs/PlatformAgentSuccessResponse.md)
 - [PlatformAgentsBodyObject](docs/PlatformAgentsBodyObject.md)
 - [PlatformAgentsErrorBody](docs/PlatformAgentsErrorBody.md)
 - [PlatformAgentsErrorResponse](docs/PlatformAgentsErrorResponse.md)
 - [PlatformAgentsErrorResponseHits](docs/PlatformAgentsErrorResponseHits.md)
 - [PlatformAgentsHitObject](docs/PlatformAgentsHitObject.md)
 - [PlatformAgentsHitObjectSource](docs/PlatformAgentsHitObjectSource.md)
 - [PlatformResponseAdminAgentConfig_](docs/PlatformResponseAdminAgentConfig_.md)
 - [PlatformResponseAgentConnectionObjectArray_](docs/PlatformResponseAgentConnectionObjectArray_.md)
 - [PlatformResponseAgentNameIdPairArray_](docs/PlatformResponseAgentNameIdPairArray_.md)
 - [PlatformResponseAgentObjectArray_](docs/PlatformResponseAgentObjectArray_.md)
 - [PlatformResponseAgentServiceObjectArray_](docs/PlatformResponseAgentServiceObjectArray_.md)
 - [PlatformResponseAgentSuccessResponse_](docs/PlatformResponseAgentSuccessResponse_.md)
 - [PlatformResponseAgentTagObjectArray_](docs/PlatformResponseAgentTagObjectArray_.md)
 - [PlatformResponseApiKeyObjectArray_](docs/PlatformResponseApiKeyObjectArray_.md)
 - [PlatformResponseApiKeyObject_](docs/PlatformResponseApiKeyObject_.md)
 - [PlatformResponseErrorItem](docs/PlatformResponseErrorItem.md)
 - [PlatformResponseNetworkInfoObject_](docs/PlatformResponseNetworkInfoObject_.md)
 - [PlatformResponseNetworkObjectArray_](docs/PlatformResponseNetworkObjectArray_.md)
 - [PlatformResponseNetworkObject_](docs/PlatformResponseNetworkObject_.md)
 - [PlatformResponseNetworkTopologyObjectArray_](docs/PlatformResponseNetworkTopologyObjectArray_.md)
 - [PlatformResponsePlatformAgentSuccessResponse_](docs/PlatformResponsePlatformAgentSuccessResponse_.md)
 - [PlatformResponseSuccessBoolean_](docs/PlatformResponseSuccessBoolean_.md)
 - [PlatformResponseSuccessbooleanData](docs/PlatformResponseSuccessbooleanData.md)
 - [PlatformResponseVoid_](docs/PlatformResponseVoid_.md)
 - [ProviderObject](docs/ProviderObject.md)
 - [PublicAppInfoObject](docs/PublicAppInfoObject.md)
 - [PublicLanguageObject](docs/PublicLanguageObject.md)
 - [PublicLanguagesObject](docs/PublicLanguagesObject.md)
 - [PublicLinkObject](docs/PublicLinkObject.md)
 - [PublicLinksLangCodeObject](docs/PublicLinksLangCodeObject.md)
 - [PublicLinksObject](docs/PublicLinksObject.md)
 - [PublicTranslationObject](docs/PublicTranslationObject.md)
 - [PublicTranslationsLangCodeObject](docs/PublicTranslationsLangCodeObject.md)
 - [PublicTranslationsObject](docs/PublicTranslationsObject.md)
 - [PublicVersionsObject](docs/PublicVersionsObject.md)
 - [RegionObject](docs/RegionObject.md)
 - [ResetPasswordObject](docs/ResetPasswordObject.md)
 - [ResetServerObject](docs/ResetServerObject.md)
 - [ResponseObject](docs/ResponseObject.md)
 - [RestartAgentObject](docs/RestartAgentObject.md)
 - [RouteObject](docs/RouteObject.md)
 - [S3ObjectListItem](docs/S3ObjectListItem.md)
 - [S3ObjectListItemOwner](docs/S3ObjectListItemOwner.md)
 - [S3SendData](docs/S3SendData.md)
 - [SendResetPasswordLinkObject](docs/SendResetPasswordLinkObject.md)
 - [SendVerifyEmailLinkObject](docs/SendVerifyEmailLinkObject.md)
 - [ServerAgentStatus](docs/ServerAgentStatus.md)
 - [ServerObject](docs/ServerObject.md)
 - [ServerSrSoftware](docs/ServerSrSoftware.md)
 - [SettingReadObject](docs/SettingReadObject.md)
 - [SettingWriteObject](docs/SettingWriteObject.md)
 - [SettingsTypes](docs/SettingsTypes.md)
 - [ShowSdnConnections](docs/ShowSdnConnections.md)
 - [SocialProviderObject](docs/SocialProviderObject.md)
 - [SocialProviderType](docs/SocialProviderType.md)
 - [SocialProviderTypeObject](docs/SocialProviderTypeObject.md)
 - [SocialProvidersIdsObject](docs/SocialProvidersIdsObject.md)
 - [SpeedtestVia](docs/SpeedtestVia.md)
 - [SrPathObject](docs/SrPathObject.md)
 - [SrPolicyObject](docs/SrPolicyObject.md)
 - [Status](docs/Status.md)
 - [TopologyObject](docs/TopologyObject.md)
 - [TranslationObject](docs/TranslationObject.md)
 - [TsoaPartialAgentConnectionObject_](docs/TsoaPartialAgentConnectionObject_.md)
 - [TsoaPartialAgentInterfaceBwObject_](docs/TsoaPartialAgentInterfaceBwObject_.md)
 - [TsoaPartialAgentInterfaceObject_](docs/TsoaPartialAgentInterfaceObject_.md)
 - [TsoaPartialAgentNetworkObject_](docs/TsoaPartialAgentNetworkObject_.md)
 - [TsoaPartialAgentObject_](docs/TsoaPartialAgentObject_.md)
 - [TsoaPartialAgentPathObject_](docs/TsoaPartialAgentPathObject_.md)
 - [TsoaPartialAgentProviderObject_](docs/TsoaPartialAgentProviderObject_.md)
 - [TsoaPartialApiKeyObject_](docs/TsoaPartialApiKeyObject_.md)
 - [TsoaPartialAppObject_](docs/TsoaPartialAppObject_.md)
 - [TsoaPartialAppVersionObject_](docs/TsoaPartialAppVersionObject_.md)
 - [TsoaPartialColorObject_](docs/TsoaPartialColorObject_.md)
 - [TsoaPartialContentObject_](docs/TsoaPartialContentObject_.md)
 - [TsoaPartialHostGroupObject_](docs/TsoaPartialHostGroupObject_.md)
 - [TsoaPartialHostObject_](docs/TsoaPartialHostObject_.md)
 - [TsoaPartialInterfaceObject_](docs/TsoaPartialInterfaceObject_.md)
 - [TsoaPartialLanguageObject_](docs/TsoaPartialLanguageObject_.md)
 - [TsoaPartialLinkObject_](docs/TsoaPartialLinkObject_.md)
 - [TsoaPartialNetworkObject_](docs/TsoaPartialNetworkObject_.md)
 - [TsoaPartialOoklaPairSpeedtestObject_](docs/TsoaPartialOoklaPairSpeedtestObject_.md)
 - [TsoaPartialOoklaSpeedtestObject_](docs/TsoaPartialOoklaSpeedtestObject_.md)
 - [TsoaPartialOrganizationObject_](docs/TsoaPartialOrganizationObject_.md)
 - [TsoaPartialPairLatencyTestObject_](docs/TsoaPartialPairLatencyTestObject_.md)
 - [TsoaPartialProviderObject_](docs/TsoaPartialProviderObject_.md)
 - [TsoaPartialRegionObject_](docs/TsoaPartialRegionObject_.md)
 - [TsoaPartialRouteObject_](docs/TsoaPartialRouteObject_.md)
 - [TsoaPartialServerObject_](docs/TsoaPartialServerObject_.md)
 - [TsoaPartialTopologyObject_](docs/TsoaPartialTopologyObject_.md)
 - [TsoaPartialTranslationObject_](docs/TsoaPartialTranslationObject_.md)
 - [TsoaPartialTunnelObject_](docs/TsoaPartialTunnelObject_.md)
 - [TsoaPartialUserAdminObject_](docs/TsoaPartialUserAdminObject_.md)
 - [TsoaPartialUserSrObject_](docs/TsoaPartialUserSrObject_.md)
 - [TsoaPartialVersionObject_](docs/TsoaPartialVersionObject_.md)
 - [TsoaPartialVpnObject_](docs/TsoaPartialVpnObject_.md)
 - [TunnelObject](docs/TunnelObject.md)
 - [UdpAndUtcPorts](docs/UdpAndUtcPorts.md)
 - [UpdateStatusBody](docs/UpdateStatusBody.md)
 - [UpdateStatusBodySubnetsToUpdate](docs/UpdateStatusBodySubnetsToUpdate.md)
 - [UpdateType](docs/UpdateType.md)
 - [UserAdminObject](docs/UserAdminObject.md)
 - [UserAgentPatchObject](docs/UserAgentPatchObject.md)
 - [UserApiKeyCreateObject](docs/UserApiKeyCreateObject.md)
 - [UserApiKeyUpdateObject](docs/UserApiKeyUpdateObject.md)
 - [UserHostCreateObject](docs/UserHostCreateObject.md)
 - [UserHostObject](docs/UserHostObject.md)
 - [UserLoginObject](docs/UserLoginObject.md)
 - [UserNetworkObject](docs/UserNetworkObject.md)
 - [UserPairLatencyTestReportObject](docs/UserPairLatencyTestReportObject.md)
 - [UserPairSpeedtestReportObject](docs/UserPairSpeedtestReportObject.md)
 - [UserRegisterObject](docs/UserRegisterObject.md)
 - [UserRegisterViaProviderObject](docs/UserRegisterViaProviderObject.md)
 - [UserSpeedtestReportObject](docs/UserSpeedtestReportObject.md)
 - [UserSrDirection](docs/UserSrDirection.md)
 - [UserSrObject](docs/UserSrObject.md)
 - [VerifyEmailObject](docs/VerifyEmailObject.md)
 - [VersionObject](docs/VersionObject.md)
 - [VersionType](docs/VersionType.md)
 - [VisibilityType](docs/VisibilityType.md)
 - [VpnObject](docs/VpnObject.md)
 - [VppCallableObject](docs/VppCallableObject.md)
 - [VppCallableObjectArgs](docs/VppCallableObjectArgs.md)
 - [VppCallableObjectArgs1](docs/VppCallableObjectArgs1.md)
 - [VppCallableObjectArgs10](docs/VppCallableObjectArgs10.md)
 - [VppCallableObjectArgs11](docs/VppCallableObjectArgs11.md)
 - [VppCallableObjectArgs12](docs/VppCallableObjectArgs12.md)
 - [VppCallableObjectArgs13](docs/VppCallableObjectArgs13.md)
 - [VppCallableObjectArgs14](docs/VppCallableObjectArgs14.md)
 - [VppCallableObjectArgs15](docs/VppCallableObjectArgs15.md)
 - [VppCallableObjectArgs16](docs/VppCallableObjectArgs16.md)
 - [VppCallableObjectArgs2](docs/VppCallableObjectArgs2.md)
 - [VppCallableObjectArgs3](docs/VppCallableObjectArgs3.md)
 - [VppCallableObjectArgs4](docs/VppCallableObjectArgs4.md)
 - [VppCallableObjectArgs5](docs/VppCallableObjectArgs5.md)
 - [VppCallableObjectArgs6](docs/VppCallableObjectArgs6.md)
 - [VppCallableObjectArgs7](docs/VppCallableObjectArgs7.md)
 - [VppCallableObjectArgs8](docs/VppCallableObjectArgs8.md)
 - [VppCallableObjectArgs9](docs/VppCallableObjectArgs9.md)
 - [WgAddPeer](docs/WgAddPeer.md)
 - [WgAddPeerArgs](docs/WgAddPeerArgs.md)
 - [WgAddPeerMetadata](docs/WgAddPeerMetadata.md)
 - [WgCallableObject](docs/WgCallableObject.md)
 - [WgCreateInterface](docs/WgCreateInterface.md)
 - [WgCreateInterfaceArgs](docs/WgCreateInterfaceArgs.md)
 - [WgCreateInterfaceMetadata](docs/WgCreateInterfaceMetadata.md)
 - [WgKeypairObject](docs/WgKeypairObject.md)
 - [WgRemoveInterface](docs/WgRemoveInterface.md)
 - [WgRemoveInterfaceArgs](docs/WgRemoveInterfaceArgs.md)
 - [WgRemovePeer](docs/WgRemovePeer.md)
 - [WgRemovePeerArgs](docs/WgRemovePeerArgs.md)

## Documentation For Authorization
In order to use this SDK you must have a valid API Authorization token.
This token can be obtained either by using `AuthApi.local` method or using the UI.
This token should be passed to the configuration object like so:

```Python
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
```

## jwt

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author


