# coding: utf-8

"""
    syntropy-controller

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from syntropy_sdk.api_client import ApiClient


class PlatformApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def config(self, agent_id, **kwargs):  # noqa: E501
        """config  # noqa: E501

        Returns agent configuration details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float agent_id: (required)
        :return: PlatformResponseAdminAgentConfig_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.config_with_http_info(agent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.config_with_http_info(agent_id, **kwargs)  # noqa: E501
            return data

    def config_with_http_info(self, agent_id, **kwargs):  # noqa: E501
        """config  # noqa: E501

        Returns agent configuration details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_with_http_info(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float agent_id: (required)
        :return: PlatformResponseAdminAgentConfig_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method config" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent_id' is set
        if "agent_id" not in params or params["agent_id"] is None:
            raise ValueError(
                "Missing the required parameter `agent_id` when calling `config`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agent_id" in params:
            path_params["agent_id"] = params["agent_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/admin/agent/{agent_id}/config",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAdminAgentConfig_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_agent_group(self, network_id, group_name, **kwargs):  # noqa: E501
        """create_agent_group  # noqa: E501

        Creates agent group relation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_agent_group(network_id, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :param str group_name: (required)
        :param list[float] body:
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_agent_group_with_http_info(
                network_id, group_name, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_agent_group_with_http_info(
                network_id, group_name, **kwargs
            )  # noqa: E501
            return data

    def create_agent_group_with_http_info(
        self, network_id, group_name, **kwargs
    ):  # noqa: E501
        """create_agent_group  # noqa: E501

        Creates agent group relation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_agent_group_with_http_info(network_id, group_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :param str group_name: (required)
        :param list[float] body:
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["network_id", "group_name", "body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_agent_group" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'network_id' is set
        if "network_id" not in params or params["network_id"] is None:
            raise ValueError(
                "Missing the required parameter `network_id` when calling `create_agent_group`"
            )  # noqa: E501
        # verify the required parameter 'group_name' is set
        if "group_name" not in params or params["group_name"] is None:
            raise ValueError(
                "Missing the required parameter `group_name` when calling `create_agent_group`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "network_id" in params:
            path_params["network_id"] = params["network_id"]  # noqa: E501
        if "group_name" in params:
            path_params["group_name"] = params["group_name"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/network/{network_id}/agent-groups/{group_name}",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_api_key(self, body, **kwargs):  # noqa: E501
        """create_api_key  # noqa: E501

        Creates API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_api_key(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: PlatformResponseApiKeyObject_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_api_key_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_api_key_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_api_key_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_api_key  # noqa: E501

        Creates API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_api_key_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: PlatformResponseApiKeyObject_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_api_key" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_api_key`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/api-keys",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseApiKeyObject_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_connections(self, body, **kwargs):  # noqa: E501
        """create_connections  # noqa: E501

        Creates agents connections. If connection type is POINT_TO_POINT, then agent_ids should contain pairs of ids, i.e.: [[1,2], [2,3], ...]. In other types of networks a flat array of ids should be passed, i.e.: [1, 2, 3, ...].  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_connections(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param ShowSdnConnections show_sdn_connections:
        :param UpdateType update_type:
        :param list[str] paths: Comma separated servers ids list for SDN path.
        :return: PlatformResponseAgentConnectionObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_connections_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_connections_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def create_connections_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_connections  # noqa: E501

        Creates agents connections. If connection type is POINT_TO_POINT, then agent_ids should contain pairs of ids, i.e.: [[1,2], [2,3], ...]. In other types of networks a flat array of ids should be passed, i.e.: [1, 2, 3, ...].  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_connections_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param ShowSdnConnections show_sdn_connections:
        :param UpdateType update_type:
        :param list[str] paths: Comma separated servers ids list for SDN path.
        :return: PlatformResponseAgentConnectionObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "body",
            "show_sdn_connections",
            "update_type",
            "paths",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_connections" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_connections`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "show_sdn_connections" in params:
            query_params.append(
                ("show-sdn-connections", params["show_sdn_connections"])
            )  # noqa: E501
        if "update_type" in params:
            query_params.append(("update-type", params["update_type"]))  # noqa: E501
        if "paths" in params:
            query_params.append(("paths", params["paths"]))  # noqa: E501
            collection_formats["paths"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/connections",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAgentConnectionObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_network(self, body, **kwargs):  # noqa: E501
        """create_network  # noqa: E501

        Creates network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: PlatformResponseNetworkObject_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_network_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_network_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_network_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_network  # noqa: E501

        Creates network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: PlatformResponseNetworkObject_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_network" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_network`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/networks",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseNetworkObject_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_network_agents(self, body, network_id, **kwargs):  # noqa: E501
        """create_network_agents  # noqa: E501

        Creates network agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network_agents(body, network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[NetworkAgentPayload] body: (required)
        :param float network_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_network_agents_with_http_info(
                body, network_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_network_agents_with_http_info(
                body, network_id, **kwargs
            )  # noqa: E501
            return data

    def create_network_agents_with_http_info(
        self, body, network_id, **kwargs
    ):  # noqa: E501
        """create_network_agents  # noqa: E501

        Creates network agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_network_agents_with_http_info(body, network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[NetworkAgentPayload] body: (required)
        :param float network_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "network_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_network_agents" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_network_agents`"
            )  # noqa: E501
        # verify the required parameter 'network_id' is set
        if "network_id" not in params or params["network_id"] is None:
            raise ValueError(
                "Missing the required parameter `network_id` when calling `create_network_agents`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "network_id" in params:
            path_params["network_id"] = params["network_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/network/{network_id}/agents",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_agents(self, agent_id, **kwargs):  # noqa: E501
        """delete_agents  # noqa: E501

        Deletes agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_agents(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float agent_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_agents_with_http_info(agent_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_agents_with_http_info(agent_id, **kwargs)  # noqa: E501
            return data

    def delete_agents_with_http_info(self, agent_id, **kwargs):  # noqa: E501
        """delete_agents  # noqa: E501

        Deletes agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_agents_with_http_info(agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float agent_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_agents" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent_id' is set
        if "agent_id" not in params or params["agent_id"] is None:
            raise ValueError(
                "Missing the required parameter `agent_id` when calling `delete_agents`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agent_id" in params:
            path_params["agent_id"] = params["agent_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/agents/{agent_id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_api_key(self, api_key_id, **kwargs):  # noqa: E501
        """delete_api_key  # noqa: E501

        Deletes API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_key(api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float api_key_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_api_key_with_http_info(
                api_key_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_api_key_with_http_info(
                api_key_id, **kwargs
            )  # noqa: E501
            return data

    def delete_api_key_with_http_info(self, api_key_id, **kwargs):  # noqa: E501
        """delete_api_key  # noqa: E501

        Deletes API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_api_key_with_http_info(api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float api_key_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["api_key_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_api_key" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'api_key_id' is set
        if "api_key_id" not in params or params["api_key_id"] is None:
            raise ValueError(
                "Missing the required parameter `api_key_id` when calling `delete_api_key`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "api_key_id" in params:
            path_params["api_key_id"] = params["api_key_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/api-keys/{api_key_id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_connection(self, connection_id, **kwargs):  # noqa: E501
        """delete_connection  # noqa: E501

        Finds and deletes all tags (PUBLIC, SDN{1,2,3}) same pair connections (agent1, agent2) in network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_connection(connection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float connection_id: (required)
        :param NetworkGenesisType network_updated_by:
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_connection_with_http_info(
                connection_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_connection_with_http_info(
                connection_id, **kwargs
            )  # noqa: E501
            return data

    def delete_connection_with_http_info(self, connection_id, **kwargs):  # noqa: E501
        """delete_connection  # noqa: E501

        Finds and deletes all tags (PUBLIC, SDN{1,2,3}) same pair connections (agent1, agent2) in network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_connection_with_http_info(connection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float connection_id: (required)
        :param NetworkGenesisType network_updated_by:
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["connection_id", "network_updated_by"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_connection" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'connection_id' is set
        if "connection_id" not in params or params["connection_id"] is None:
            raise ValueError(
                "Missing the required parameter `connection_id` when calling `delete_connection`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "connection_id" in params:
            path_params["connection_id"] = params["connection_id"]  # noqa: E501

        query_params = []
        if "network_updated_by" in params:
            query_params.append(
                ("network-updated-by", params["network_updated_by"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/connections/{connection_id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_networks(self, network_id, **kwargs):  # noqa: E501
        """delete_networks  # noqa: E501

        Deletes network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_networks(network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_networks_with_http_info(
                network_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_networks_with_http_info(
                network_id, **kwargs
            )  # noqa: E501
            return data

    def delete_networks_with_http_info(self, network_id, **kwargs):  # noqa: E501
        """delete_networks  # noqa: E501

        Deletes network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_networks_with_http_info(network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["network_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_networks" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'network_id' is set
        if "network_id" not in params or params["network_id"] is None:
            raise ValueError(
                "Missing the required parameter `network_id` when calling `delete_networks`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "network_id" in params:
            path_params["network_id"] = params["network_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/networks/{network_id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_networks_agent(self, network_id, agent_id, **kwargs):  # noqa: E501
        """delete_networks_agent  # noqa: E501

        Deletes agent from network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_networks_agent(network_id, agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :param float agent_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_networks_agent_with_http_info(
                network_id, agent_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_networks_agent_with_http_info(
                network_id, agent_id, **kwargs
            )  # noqa: E501
            return data

    def delete_networks_agent_with_http_info(
        self, network_id, agent_id, **kwargs
    ):  # noqa: E501
        """delete_networks_agent  # noqa: E501

        Deletes agent from network.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_networks_agent_with_http_info(network_id, agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :param float agent_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["network_id", "agent_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_networks_agent" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'network_id' is set
        if "network_id" not in params or params["network_id"] is None:
            raise ValueError(
                "Missing the required parameter `network_id` when calling `delete_networks_agent`"
            )  # noqa: E501
        # verify the required parameter 'agent_id' is set
        if "agent_id" not in params or params["agent_id"] is None:
            raise ValueError(
                "Missing the required parameter `agent_id` when calling `delete_networks_agent`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "network_id" in params:
            path_params["network_id"] = params["network_id"]  # noqa: E501
        if "agent_id" in params:
            path_params["agent_id"] = params["agent_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/networks/{network_id}/agents/{agent_id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_all_name_id_pairs_by_user_id(self, **kwargs):  # noqa: E501
        """find_all_name_id_pairs_by_user_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_all_name_id_pairs_by_user_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PlatformResponseAgentNameIdPairArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_all_name_id_pairs_by_user_id_with_http_info(
                **kwargs
            )  # noqa: E501
        else:
            (data) = self.find_all_name_id_pairs_by_user_id_with_http_info(
                **kwargs
            )  # noqa: E501
            return data

    def find_all_name_id_pairs_by_user_id_with_http_info(self, **kwargs):  # noqa: E501
        """find_all_name_id_pairs_by_user_id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_all_name_id_pairs_by_user_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PlatformResponseAgentNameIdPairArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_all_name_id_pairs_by_user_id" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/agents/id-name-pairs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAgentNameIdPairArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_agent_services_with_subnets(self, agent_ids, **kwargs):  # noqa: E501
        """get_agent_services_with_subnets  # noqa: E501

        Retrieves agent services.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_services_with_subnets(agent_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] agent_ids: (required)
        :return: PlatformResponseAgentServiceObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_agent_services_with_subnets_with_http_info(
                agent_ids, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_agent_services_with_subnets_with_http_info(
                agent_ids, **kwargs
            )  # noqa: E501
            return data

    def get_agent_services_with_subnets_with_http_info(
        self, agent_ids, **kwargs
    ):  # noqa: E501
        """get_agent_services_with_subnets  # noqa: E501

        Retrieves agent services.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_services_with_subnets_with_http_info(agent_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] agent_ids: (required)
        :return: PlatformResponseAgentServiceObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["agent_ids"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_services_with_subnets" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'agent_ids' is set
        if "agent_ids" not in params or params["agent_ids"] is None:
            raise ValueError(
                "Missing the required parameter `agent_ids` when calling `get_agent_services_with_subnets`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "agent_ids" in params:
            query_params.append(("agent-ids", params["agent_ids"]))  # noqa: E501
            collection_formats["agent-ids"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/agent-services",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAgentServiceObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_agent_tags(self, **kwargs):  # noqa: E501
        """get_agent_tags  # noqa: E501

        Get user agent tags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_tags(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PlatformResponseAgentTagObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_agent_tags_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_agent_tags_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_agent_tags_with_http_info(self, **kwargs):  # noqa: E501
        """get_agent_tags  # noqa: E501

        Get user agent tags.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_tags_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: PlatformResponseAgentTagObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_tags" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/agent-tags",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAgentTagObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_connection_services(self, connection_ids, **kwargs):  # noqa: E501
        """get_connection_services  # noqa: E501

        Retrieves connection services  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection_services(connection_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] connection_ids: (required)
        :return: PlatformResponseAgentConnectionObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_connection_services_with_http_info(
                connection_ids, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_connection_services_with_http_info(
                connection_ids, **kwargs
            )  # noqa: E501
            return data

    def get_connection_services_with_http_info(
        self, connection_ids, **kwargs
    ):  # noqa: E501
        """get_connection_services  # noqa: E501

        Retrieves connection services  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connection_services_with_http_info(connection_ids, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] connection_ids: (required)
        :return: PlatformResponseAgentConnectionObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["connection_ids"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connection_services" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'connection_ids' is set
        if "connection_ids" not in params or params["connection_ids"] is None:
            raise ValueError(
                "Missing the required parameter `connection_ids` when calling `get_connection_services`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if "connection_ids" in params:
            query_params.append(
                ("connection-ids", params["connection_ids"])
            )  # noqa: E501
            collection_formats["connection-ids"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/connection-services",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAgentConnectionObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_network_info(self, network_id, **kwargs):  # noqa: E501
        """get_network_info  # noqa: E501

        Get network info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_info(network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :return: PlatformResponseNetworkInfoObject_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_network_info_with_http_info(
                network_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_network_info_with_http_info(
                network_id, **kwargs
            )  # noqa: E501
            return data

    def get_network_info_with_http_info(self, network_id, **kwargs):  # noqa: E501
        """get_network_info  # noqa: E501

        Get network info.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_network_info_with_http_info(network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id: (required)
        :return: PlatformResponseNetworkInfoObject_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["network_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_network_info" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'network_id' is set
        if "network_id" not in params or params["network_id"] is None:
            raise ValueError(
                "Missing the required parameter `network_id` when calling `get_network_info`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "network_id" in params:
            path_params["network_id"] = params["network_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/network/{network_id}/info",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseNetworkInfoObject_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def index_agents(self, **kwargs):  # noqa: E501
        """index_agents  # noqa: E501

        Retrieves agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_agents(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: ids[]: array of agent ids, example: \"1;2;3\", id|name: agent id or agent name, example: \"name1\" or \"132\", name: exact agent name, example: \"name1\", statuses[]: one of: connected, connected_with_errors, disconnected, example: \"connected;connected_with_errors\", networks[]: array of network ids, example: \"1;2;3\", providers[]: array of providers ids, example: \"1;2;3\", tags[]: array of tags ids, example: \"1;2;3\", tags_names[]: array of tags name, example: \"name1;name2;name3\", networks_names[]: array of networks names, example: \"name1;name2;name3\",
        :param bool load_relations:
        :param bool show_logs_state:
        :return: PlatformResponseAgentObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.index_agents_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.index_agents_with_http_info(**kwargs)  # noqa: E501
            return data

    def index_agents_with_http_info(self, **kwargs):  # noqa: E501
        """index_agents  # noqa: E501

        Retrieves agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_agents_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: ids[]: array of agent ids, example: \"1;2;3\", id|name: agent id or agent name, example: \"name1\" or \"132\", name: exact agent name, example: \"name1\", statuses[]: one of: connected, connected_with_errors, disconnected, example: \"connected;connected_with_errors\", networks[]: array of network ids, example: \"1;2;3\", providers[]: array of providers ids, example: \"1;2;3\", tags[]: array of tags ids, example: \"1;2;3\", tags_names[]: array of tags name, example: \"name1;name2;name3\", networks_names[]: array of networks names, example: \"name1;name2;name3\",
        :param bool load_relations:
        :param bool show_logs_state:
        :return: PlatformResponseAgentObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "skip",
            "take",
            "order",
            "filter",
            "load_relations",
            "show_logs_state",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_agents" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "skip" in params:
            query_params.append(("skip", params["skip"]))  # noqa: E501
        if "take" in params:
            query_params.append(("take", params["take"]))  # noqa: E501
        if "order" in params:
            query_params.append(("order", params["order"]))  # noqa: E501
        if "filter" in params:
            query_params.append(("filter", params["filter"]))  # noqa: E501
        if "load_relations" in params:
            query_params.append(
                ("load-relations", params["load_relations"])
            )  # noqa: E501
        if "show_logs_state" in params:
            query_params.append(
                ("show-logs-state", params["show_logs_state"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/agents",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAgentObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def index_api_key(self, **kwargs):  # noqa: E501
        """index_api_key  # noqa: E501

        Get API keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_api_key(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: api_key_id: string, api_key_name: string
        :return: PlatformResponseApiKeyObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.index_api_key_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.index_api_key_with_http_info(**kwargs)  # noqa: E501
            return data

    def index_api_key_with_http_info(self, **kwargs):  # noqa: E501
        """index_api_key  # noqa: E501

        Get API keys.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_api_key_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: api_key_id: string, api_key_name: string
        :return: PlatformResponseApiKeyObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["skip", "take", "order", "filter"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_api_key" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "skip" in params:
            query_params.append(("skip", params["skip"]))  # noqa: E501
        if "take" in params:
            query_params.append(("take", params["take"]))  # noqa: E501
        if "order" in params:
            query_params.append(("order", params["order"]))  # noqa: E501
        if "filter" in params:
            query_params.append(("filter", params["filter"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/api-keys",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseApiKeyObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def index_connections(self, **kwargs):  # noqa: E501
        """index_connections  # noqa: E501

        Retrieves connections.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_connections(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: id|name: string, example: \"1\" or \"name\", name: exact agent name, example: \"name1\", agent_ids[]: array of agent ids, example: \"1;2;3\", statuses[]: array of statuses, one of PENDING, WARNING, ERROR, CONNECTED, OFFLINE, example: \"OFFLINE;ERROR;WARNING\", networks[]: array of networks ids, example: \"1;2;3\", providers[]: array of providers ids, example: \"1;2;3\",
        :param ShowSdnConnections show_sdn_connections:
        :param bool load_relations:
        :return: PlatformResponseAgentConnectionObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.index_connections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.index_connections_with_http_info(**kwargs)  # noqa: E501
            return data

    def index_connections_with_http_info(self, **kwargs):  # noqa: E501
        """index_connections  # noqa: E501

        Retrieves connections.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_connections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: id|name: string, example: \"1\" or \"name\", name: exact agent name, example: \"name1\", agent_ids[]: array of agent ids, example: \"1;2;3\", statuses[]: array of statuses, one of PENDING, WARNING, ERROR, CONNECTED, OFFLINE, example: \"OFFLINE;ERROR;WARNING\", networks[]: array of networks ids, example: \"1;2;3\", providers[]: array of providers ids, example: \"1;2;3\",
        :param ShowSdnConnections show_sdn_connections:
        :param bool load_relations:
        :return: PlatformResponseAgentConnectionObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = [
            "skip",
            "take",
            "order",
            "filter",
            "show_sdn_connections",
            "load_relations",
        ]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_connections" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "skip" in params:
            query_params.append(("skip", params["skip"]))  # noqa: E501
        if "take" in params:
            query_params.append(("take", params["take"]))  # noqa: E501
        if "order" in params:
            query_params.append(("order", params["order"]))  # noqa: E501
        if "filter" in params:
            query_params.append(("filter", params["filter"]))  # noqa: E501
        if "show_sdn_connections" in params:
            query_params.append(
                ("show-sdn-connections", params["show_sdn_connections"])
            )  # noqa: E501
        if "load_relations" in params:
            query_params.append(
                ("load-relations", params["load_relations"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/connections",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseAgentConnectionObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def index_networks(self, **kwargs):  # noqa: E501
        """index_networks  # noqa: E501

        Retrieves networks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_networks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: id|name: string, name: string,
        :return: PlatformResponseNetworkObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.index_networks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.index_networks_with_http_info(**kwargs)  # noqa: E501
            return data

    def index_networks_with_http_info(self, **kwargs):  # noqa: E501
        """index_networks  # noqa: E501

        Retrieves networks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.index_networks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float skip:
        :param float take:
        :param str order: string: \"ASC\" | \"DESC\"
        :param str filter: id|name: string, name: string,
        :return: PlatformResponseNetworkObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["skip", "take", "order", "filter"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method index_networks" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "skip" in params:
            query_params.append(("skip", params["skip"]))  # noqa: E501
        if "take" in params:
            query_params.append(("take", params["take"]))  # noqa: E501
        if "order" in params:
            query_params.append(("order", params["order"]))  # noqa: E501
        if "filter" in params:
            query_params.append(("filter", params["filter"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/networks",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseNetworkObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def patch_agents(self, body, agent_id, **kwargs):  # noqa: E501
        """patch_agents  # noqa: E501

        Patches agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_agents(body, agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param float agent_id: (required)
        :return: PlatformResponseSuccessBoolean_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.patch_agents_with_http_info(
                body, agent_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.patch_agents_with_http_info(
                body, agent_id, **kwargs
            )  # noqa: E501
            return data

    def patch_agents_with_http_info(self, body, agent_id, **kwargs):  # noqa: E501
        """patch_agents  # noqa: E501

        Patches agent.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_agents_with_http_info(body, agent_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param float agent_id: (required)
        :return: PlatformResponseSuccessBoolean_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "agent_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_agents" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `patch_agents`"
            )  # noqa: E501
        # verify the required parameter 'agent_id' is set
        if "agent_id" not in params or params["agent_id"] is None:
            raise ValueError(
                "Missing the required parameter `agent_id` when calling `patch_agents`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "agent_id" in params:
            path_params["agent_id"] = params["agent_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/agents/{agent_id}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseSuccessBoolean_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def remove_agent_group(self, group_id, **kwargs):  # noqa: E501
        """remove_agent_group  # noqa: E501

        Remove agent group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_agent_group(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float group_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.remove_agent_group_with_http_info(
                group_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.remove_agent_group_with_http_info(
                group_id, **kwargs
            )  # noqa: E501
            return data

    def remove_agent_group_with_http_info(self, group_id, **kwargs):  # noqa: E501
        """remove_agent_group  # noqa: E501

        Remove agent group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_agent_group_with_http_info(group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float group_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["group_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_agent_group" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `remove_agent_group`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["group_id"] = params["group_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/network/agent-groups/{group_id}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def remove_network_agents(self, body, network_id, **kwargs):  # noqa: E501
        """remove_network_agents  # noqa: E501

        Removes network agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_network_agents(body, network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] body: (required)
        :param float network_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.remove_network_agents_with_http_info(
                body, network_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.remove_network_agents_with_http_info(
                body, network_id, **kwargs
            )  # noqa: E501
            return data

    def remove_network_agents_with_http_info(
        self, body, network_id, **kwargs
    ):  # noqa: E501
        """remove_network_agents  # noqa: E501

        Removes network agents.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_network_agents_with_http_info(body, network_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] body: (required)
        :param float network_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "network_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_network_agents" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `remove_network_agents`"
            )  # noqa: E501
        # verify the required parameter 'network_id' is set
        if "network_id" not in params or params["network_id"] is None:
            raise ValueError(
                "Missing the required parameter `network_id` when calling `remove_network_agents`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "network_id" in params:
            path_params["network_id"] = params["network_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/network/{network_id}/agents",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def save_logs_read_timestamp(self, body, **kwargs):  # noqa: E501
        """save_logs_read_timestamp  # noqa: E501

        Save last logs read timestamp.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_logs_read_timestamp(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[LogsReadTimestampObject] body: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.save_logs_read_timestamp_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.save_logs_read_timestamp_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def save_logs_read_timestamp_with_http_info(self, body, **kwargs):  # noqa: E501
        """save_logs_read_timestamp  # noqa: E501

        Save last logs read timestamp.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.save_logs_read_timestamp_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[LogsReadTimestampObject] body: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method save_logs_read_timestamp" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `save_logs_read_timestamp`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/logs-reads-timestamp",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def topology_networks(self, **kwargs):  # noqa: E501
        """topology_networks  # noqa: E501

        Retrieves networks topology.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.topology_networks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id:
        :return: PlatformResponseNetworkTopologyObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.topology_networks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.topology_networks_with_http_info(**kwargs)  # noqa: E501
            return data

    def topology_networks_with_http_info(self, **kwargs):  # noqa: E501
        """topology_networks  # noqa: E501

        Retrieves networks topology.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.topology_networks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param float network_id:
        :return: PlatformResponseNetworkTopologyObjectArray_
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["network_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method topology_networks" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "network_id" in params:
            query_params.append(("network_id", params["network_id"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/networks/topology",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="PlatformResponseNetworkTopologyObjectArray_",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_agent_group(self, body, group_id, **kwargs):  # noqa: E501
        """update_agent_group  # noqa: E501

        Update network agents group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_agent_group(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] body: (required)
        :param float group_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_agent_group_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_agent_group_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
            return data

    def update_agent_group_with_http_info(self, body, group_id, **kwargs):  # noqa: E501
        """update_agent_group  # noqa: E501

        Update network agents group.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_agent_group_with_http_info(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[float] body: (required)
        :param float group_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_agent_group" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_agent_group`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `update_agent_group`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["group_id"] = params["group_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/network/agent-groups/{group_id}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_agent_services_subnets_status(self, body, **kwargs):  # noqa: E501
        """update_agent_services_subnets_status  # noqa: E501

        Updates agent services status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_agent_services_subnets_status(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_agent_services_subnets_status_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_agent_services_subnets_status_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def update_agent_services_subnets_status_with_http_info(
        self, body, **kwargs
    ):  # noqa: E501
        """update_agent_services_subnets_status  # noqa: E501

        Updates agent services status  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_agent_services_subnets_status_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_agent_services_subnets_status" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_agent_services_subnets_status`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/agent-services-subnets",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_api_key(self, body, api_key_id, **kwargs):  # noqa: E501
        """update_api_key  # noqa: E501

        Updates API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_api_key(body, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param float api_key_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_api_key_with_http_info(
                body, api_key_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_api_key_with_http_info(
                body, api_key_id, **kwargs
            )  # noqa: E501
            return data

    def update_api_key_with_http_info(self, body, api_key_id, **kwargs):  # noqa: E501
        """update_api_key  # noqa: E501

        Updates API key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_api_key_with_http_info(body, api_key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :param float api_key_id: (required)
        :return: InlineResponse204
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "api_key_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_api_key" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_api_key`"
            )  # noqa: E501
        # verify the required parameter 'api_key_id' is set
        if "api_key_id" not in params or params["api_key_id"] is None:
            raise ValueError(
                "Missing the required parameter `api_key_id` when calling `update_api_key`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "api_key_id" in params:
            path_params["api_key_id"] = params["api_key_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/api-keys/{api_key_id}",
            "PATCH",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="InlineResponse204",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_connection_services(self, body, **kwargs):  # noqa: E501
        """update_connection_services  # noqa: E501

        Updates agent connection services ips  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_connection_services(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_connection_services_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_connection_services_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def update_connection_services_with_http_info(self, body, **kwargs):  # noqa: E501
        """update_connection_services  # noqa: E501

        Updates agent connection services ips  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_connection_services_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param dict(str, object) body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_connection_services" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_connection_services`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["jwt"]  # noqa: E501

        return self.api_client.call_api(
            "/api/platform/connection-services",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
