# outsystems-pipeline

![Build Status](https://dev.azure.com/os-pipeline/OutSystems-Pipeline/_apis/build/status/OutSystems.outsystems-pipeline?branchName=master)

This project contains the source code of `outsystems-pipeline`, a Python package [distributed on PyPI.org](https://pypi.org/project/outsystems-pipeline/) maintained by [OutSystems](https://www.outsystems.com) to accelerate the creation of OutSystems CI/CD pipelines using your DevOps automation tool of choice. The project also includes example scripts and pipeline templates.

In the future we intend to open the project repository to accept your contributions by pull requests.

## Getting started

In the [Wiki](https://github.com/OutSystems/outsystems-pipeline/wiki), you will find all the information on how to use `outsystems-pipeline` and on setting up your OutSystems pipelines.

The following are step-by-step instructions on how to set up OutSystems CI/CD pipelines using `outsystems-pipeline`:

* [Building an OutSystems pipeline with Jenkins](https://github.com/OutSystems/outsystems-pipeline/wiki/Building-an-OutSystems-pipeline-with-Jenkins)
* [Building an OutSystems pipeline with Azure DevOps](https://github.com/OutSystems/outsystems-pipeline/wiki/Building-an-OutSystems-pipeline-with-Azure-DevOps)

We also provide [example scripts](https://github.com/OutSystems/outsystems-pipeline/tree/master/examples/other_pipelines) to help bootstrap your custom pipelines.

## Get in touch

Help us improve `outsystems-pipeline` by either:

* [Submitting an issue](https://github.com/OutSystems/outsystems-pipeline/issues) with detailed information about the problem you're having
* [Sending us an email](mailto:cicd.integrations@outsystems.com) with any feedback or questions that you may have

## Change log

See the [change log](CHANGELOG.md) to learn about the latest changes and improvements to `outsystems-pipeline`.

## License

OutSystems distributes the project `outsystem-pipeline` under the [Apache License](LICENSE) with no support. For more information, see the [notice file](NOTICE.md).
