/* Copyright 2020 Zhao HG

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. */
#include "unicode_data.h"

namespace unicode {

const DecompositionMappingTag NO_MAPPING = DecompositionMappingTag::NO_MAPPING;
const DecompositionMappingTag CANONICAL = DecompositionMappingTag::CANONICAL;
const DecompositionMappingTag CIRCLE = DecompositionMappingTag::CIRCLE;
const DecompositionMappingTag COMPAT = DecompositionMappingTag::COMPAT;
const DecompositionMappingTag FINAL = DecompositionMappingTag::FINAL;
const DecompositionMappingTag FONT = DecompositionMappingTag::FONT;
const DecompositionMappingTag FRACTION = DecompositionMappingTag::FRACTION;
const DecompositionMappingTag INITIAL = DecompositionMappingTag::INITIAL;
const DecompositionMappingTag ISOLATED = DecompositionMappingTag::ISOLATED;
const DecompositionMappingTag MEDIAL = DecompositionMappingTag::MEDIAL;
const DecompositionMappingTag NARROW = DecompositionMappingTag::NARROW;
const DecompositionMappingTag NOBREAK = DecompositionMappingTag::NOBREAK;
const DecompositionMappingTag SMALL = DecompositionMappingTag::SMALL;
const DecompositionMappingTag SQUARE = DecompositionMappingTag::SQUARE;
const DecompositionMappingTag SUB = DecompositionMappingTag::SUB;
const DecompositionMappingTag SUPER = DecompositionMappingTag::SUPER;
const DecompositionMappingTag VERTICAL = DecompositionMappingTag::VERTICAL;
const DecompositionMappingTag WIDE = DecompositionMappingTag::WIDE;

std::ostream& operator<<(std::ostream& os, DecompositionMappingTag tag) {
    switch (tag) {
    case NO_MAPPING: os << ""; break;
    case CANONICAL: os << "canonical"; break;
    case NOBREAK: os << "noBreak"; break;
    case COMPAT: os << "compat"; break;
    case SUPER: os << "super"; break;
    case FRACTION: os << "fraction"; break;
    case SUB: os << "sub"; break;
    case FONT: os << "font"; break;
    case CIRCLE: os << "circle"; break;
    case WIDE: os << "wide"; break;
    case VERTICAL: os << "vertical"; break;
    case SQUARE: os << "square"; break;
    case ISOLATED: os << "isolated"; break;
    case FINAL: os << "final"; break;
    case INITIAL: os << "initial"; break;
    case MEDIAL: os << "medial"; break;
    case SMALL: os << "small"; break;
    case NARROW: os << "narrow"; break;
    }
    return os;
}


const int32_t DECOMPOSITION_MAPPING_INDEX[] = {
    0x00A0, 0x00A8, 0x00AA, 0x00AF, 0x00B2, 0x00B3, 0x00B4, 0x00B5,
    0x00B8, 0x00B9, 0x00BA, 0x00BC, 0x00BD, 0x00BE, 0x00C0, 0x00C1,
    0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C7, 0x00C8, 0x00C9, 0x00CA,
    0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D1, 0x00D2, 0x00D3,
    0x00D4, 0x00D5, 0x00D6, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD,
    0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E7, 0x00E8,
    0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F1,
    0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F9, 0x00FA, 0x00FB,
    0x00FC, 0x00FD, 0x00FF, 0x0100, 0x0101, 0x0102, 0x0103, 0x0104,
    0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C,
    0x010D, 0x010E, 0x010F, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116,
    0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E,
    0x011F, 0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0128,
    0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 0x0130,
    0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0139, 0x013A,
    0x013B, 0x013C, 0x013D, 0x013E, 0x013F, 0x0140, 0x0143, 0x0144,
    0x0145, 0x0146, 0x0147, 0x0148, 0x0149, 0x014C, 0x014D, 0x014E,
    0x014F, 0x0150, 0x0151, 0x0154, 0x0155, 0x0156, 0x0157, 0x0158,
    0x0159, 0x015A, 0x015B, 0x015C, 0x015D, 0x015E, 0x015F, 0x0160,
    0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0168, 0x0169, 0x016A,
    0x016B, 0x016C, 0x016D, 0x016E, 0x016F, 0x0170, 0x0171, 0x0172,
    0x0173, 0x0174, 0x0175, 0x0176, 0x0177, 0x0178, 0x0179, 0x017A,
    0x017B, 0x017C, 0x017D, 0x017E, 0x017F, 0x01A0, 0x01A1, 0x01AF,
    0x01B0, 0x01C4, 0x01C5, 0x01C6, 0x01C7, 0x01C8, 0x01C9, 0x01CA,
    0x01CB, 0x01CC, 0x01CD, 0x01CE, 0x01CF, 0x01D0, 0x01D1, 0x01D2,
    0x01D3, 0x01D4, 0x01D5, 0x01D6, 0x01D7, 0x01D8, 0x01D9, 0x01DA,
    0x01DB, 0x01DC, 0x01DE, 0x01DF, 0x01E0, 0x01E1, 0x01E2, 0x01E3,
    0x01E6, 0x01E7, 0x01E8, 0x01E9, 0x01EA, 0x01EB, 0x01EC, 0x01ED,
    0x01EE, 0x01EF, 0x01F0, 0x01F1, 0x01F2, 0x01F3, 0x01F4, 0x01F5,
    0x01F8, 0x01F9, 0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF,
    0x0200, 0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207,
    0x0208, 0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F,
    0x0210, 0x0211, 0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217,
    0x0218, 0x0219, 0x021A, 0x021B, 0x021E, 0x021F, 0x0226, 0x0227,
    0x0228, 0x0229, 0x022A, 0x022B, 0x022C, 0x022D, 0x022E, 0x022F,
    0x0230, 0x0231, 0x0232, 0x0233, 0x02B0, 0x02B1, 0x02B2, 0x02B3,
    0x02B4, 0x02B5, 0x02B6, 0x02B7, 0x02B8, 0x02D8, 0x02D9, 0x02DA,
    0x02DB, 0x02DC, 0x02DD, 0x02E0, 0x02E1, 0x02E2, 0x02E3, 0x02E4,
    0x0340, 0x0341, 0x0343, 0x0344, 0x0374, 0x037A, 0x037E, 0x0384,
    0x0385, 0x0386, 0x0387, 0x0388, 0x0389, 0x038A, 0x038C, 0x038E,
    0x038F, 0x0390, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF,
    0x03B0, 0x03CA, 0x03CB, 0x03CC, 0x03CD, 0x03CE, 0x03D0, 0x03D1,
    0x03D2, 0x03D3, 0x03D4, 0x03D5, 0x03D6, 0x03F0, 0x03F1, 0x03F2,
    0x03F4, 0x03F5, 0x03F9, 0x0400, 0x0401, 0x0403, 0x0407, 0x040C,
    0x040D, 0x040E, 0x0419, 0x0439, 0x0450, 0x0451, 0x0453, 0x0457,
    0x045C, 0x045D, 0x045E, 0x0476, 0x0477, 0x04C1, 0x04C2, 0x04D0,
    0x04D1, 0x04D2, 0x04D3, 0x04D6, 0x04D7, 0x04DA, 0x04DB, 0x04DC,
    0x04DD, 0x04DE, 0x04DF, 0x04E2, 0x04E3, 0x04E4, 0x04E5, 0x04E6,
    0x04E7, 0x04EA, 0x04EB, 0x04EC, 0x04ED, 0x04EE, 0x04EF, 0x04F0,
    0x04F1, 0x04F2, 0x04F3, 0x04F4, 0x04F5, 0x04F8, 0x04F9, 0x0587,
    0x0622, 0x0623, 0x0624, 0x0625, 0x0626, 0x0675, 0x0676, 0x0677,
    0x0678, 0x06C0, 0x06C2, 0x06D3, 0x0929, 0x0931, 0x0934, 0x0958,
    0x0959, 0x095A, 0x095B, 0x095C, 0x095D, 0x095E, 0x095F, 0x09CB,
    0x09CC, 0x09DC, 0x09DD, 0x09DF, 0x0A33, 0x0A36, 0x0A59, 0x0A5A,
    0x0A5B, 0x0A5E, 0x0B48, 0x0B4B, 0x0B4C, 0x0B5C, 0x0B5D, 0x0B94,
    0x0BCA, 0x0BCB, 0x0BCC, 0x0C48, 0x0CC0, 0x0CC7, 0x0CC8, 0x0CCA,
    0x0CCB, 0x0D4A, 0x0D4B, 0x0D4C, 0x0DDA, 0x0DDC, 0x0DDD, 0x0DDE,
    0x0E33, 0x0EB3, 0x0EDC, 0x0EDD, 0x0F0C, 0x0F43, 0x0F4D, 0x0F52,
    0x0F57, 0x0F5C, 0x0F69, 0x0F73, 0x0F75, 0x0F76, 0x0F77, 0x0F78,
    0x0F79, 0x0F81, 0x0F93, 0x0F9D, 0x0FA2, 0x0FA7, 0x0FAC, 0x0FB9,
    0x1026, 0x10FC, 0x1B06, 0x1B08, 0x1B0A, 0x1B0C, 0x1B0E, 0x1B12,
    0x1B3B, 0x1B3D, 0x1B40, 0x1B41, 0x1B43, 0x1D2C, 0x1D2D, 0x1D2E,
    0x1D30, 0x1D31, 0x1D32, 0x1D33, 0x1D34, 0x1D35, 0x1D36, 0x1D37,
    0x1D38, 0x1D39, 0x1D3A, 0x1D3C, 0x1D3D, 0x1D3E, 0x1D3F, 0x1D40,
    0x1D41, 0x1D42, 0x1D43, 0x1D44, 0x1D45, 0x1D46, 0x1D47, 0x1D48,
    0x1D49, 0x1D4A, 0x1D4B, 0x1D4C, 0x1D4D, 0x1D4F, 0x1D50, 0x1D51,
    0x1D52, 0x1D53, 0x1D54, 0x1D55, 0x1D56, 0x1D57, 0x1D58, 0x1D59,
    0x1D5A, 0x1D5B, 0x1D5C, 0x1D5D, 0x1D5E, 0x1D5F, 0x1D60, 0x1D61,
    0x1D62, 0x1D63, 0x1D64, 0x1D65, 0x1D66, 0x1D67, 0x1D68, 0x1D69,
    0x1D6A, 0x1D78, 0x1D9B, 0x1D9C, 0x1D9D, 0x1D9E, 0x1D9F, 0x1DA0,
    0x1DA1, 0x1DA2, 0x1DA3, 0x1DA4, 0x1DA5, 0x1DA6, 0x1DA7, 0x1DA8,
    0x1DA9, 0x1DAA, 0x1DAB, 0x1DAC, 0x1DAD, 0x1DAE, 0x1DAF, 0x1DB0,
    0x1DB1, 0x1DB2, 0x1DB3, 0x1DB4, 0x1DB5, 0x1DB6, 0x1DB7, 0x1DB8,
    0x1DB9, 0x1DBA, 0x1DBB, 0x1DBC, 0x1DBD, 0x1DBE, 0x1DBF, 0x1E00,
    0x1E01, 0x1E02, 0x1E03, 0x1E04, 0x1E05, 0x1E06, 0x1E07, 0x1E08,
    0x1E09, 0x1E0A, 0x1E0B, 0x1E0C, 0x1E0D, 0x1E0E, 0x1E0F, 0x1E10,
    0x1E11, 0x1E12, 0x1E13, 0x1E14, 0x1E15, 0x1E16, 0x1E17, 0x1E18,
    0x1E19, 0x1E1A, 0x1E1B, 0x1E1C, 0x1E1D, 0x1E1E, 0x1E1F, 0x1E20,
    0x1E21, 0x1E22, 0x1E23, 0x1E24, 0x1E25, 0x1E26, 0x1E27, 0x1E28,
    0x1E29, 0x1E2A, 0x1E2B, 0x1E2C, 0x1E2D, 0x1E2E, 0x1E2F, 0x1E30,
    0x1E31, 0x1E32, 0x1E33, 0x1E34, 0x1E35, 0x1E36, 0x1E37, 0x1E38,
    0x1E39, 0x1E3A, 0x1E3B, 0x1E3C, 0x1E3D, 0x1E3E, 0x1E3F, 0x1E40,
    0x1E41, 0x1E42, 0x1E43, 0x1E44, 0x1E45, 0x1E46, 0x1E47, 0x1E48,
    0x1E49, 0x1E4A, 0x1E4B, 0x1E4C, 0x1E4D, 0x1E4E, 0x1E4F, 0x1E50,
    0x1E51, 0x1E52, 0x1E53, 0x1E54, 0x1E55, 0x1E56, 0x1E57, 0x1E58,
    0x1E59, 0x1E5A, 0x1E5B, 0x1E5C, 0x1E5D, 0x1E5E, 0x1E5F, 0x1E60,
    0x1E61, 0x1E62, 0x1E63, 0x1E64, 0x1E65, 0x1E66, 0x1E67, 0x1E68,
    0x1E69, 0x1E6A, 0x1E6B, 0x1E6C, 0x1E6D, 0x1E6E, 0x1E6F, 0x1E70,
    0x1E71, 0x1E72, 0x1E73, 0x1E74, 0x1E75, 0x1E76, 0x1E77, 0x1E78,
    0x1E79, 0x1E7A, 0x1E7B, 0x1E7C, 0x1E7D, 0x1E7E, 0x1E7F, 0x1E80,
    0x1E81, 0x1E82, 0x1E83, 0x1E84, 0x1E85, 0x1E86, 0x1E87, 0x1E88,
    0x1E89, 0x1E8A, 0x1E8B, 0x1E8C, 0x1E8D, 0x1E8E, 0x1E8F, 0x1E90,
    0x1E91, 0x1E92, 0x1E93, 0x1E94, 0x1E95, 0x1E96, 0x1E97, 0x1E98,
    0x1E99, 0x1E9A, 0x1E9B, 0x1EA0, 0x1EA1, 0x1EA2, 0x1EA3, 0x1EA4,
    0x1EA5, 0x1EA6, 0x1EA7, 0x1EA8, 0x1EA9, 0x1EAA, 0x1EAB, 0x1EAC,
    0x1EAD, 0x1EAE, 0x1EAF, 0x1EB0, 0x1EB1, 0x1EB2, 0x1EB3, 0x1EB4,
    0x1EB5, 0x1EB6, 0x1EB7, 0x1EB8, 0x1EB9, 0x1EBA, 0x1EBB, 0x1EBC,
    0x1EBD, 0x1EBE, 0x1EBF, 0x1EC0, 0x1EC1, 0x1EC2, 0x1EC3, 0x1EC4,
    0x1EC5, 0x1EC6, 0x1EC7, 0x1EC8, 0x1EC9, 0x1ECA, 0x1ECB, 0x1ECC,
    0x1ECD, 0x1ECE, 0x1ECF, 0x1ED0, 0x1ED1, 0x1ED2, 0x1ED3, 0x1ED4,
    0x1ED5, 0x1ED6, 0x1ED7, 0x1ED8, 0x1ED9, 0x1EDA, 0x1EDB, 0x1EDC,
    0x1EDD, 0x1EDE, 0x1EDF, 0x1EE0, 0x1EE1, 0x1EE2, 0x1EE3, 0x1EE4,
    0x1EE5, 0x1EE6, 0x1EE7, 0x1EE8, 0x1EE9, 0x1EEA, 0x1EEB, 0x1EEC,
    0x1EED, 0x1EEE, 0x1EEF, 0x1EF0, 0x1EF1, 0x1EF2, 0x1EF3, 0x1EF4,
    0x1EF5, 0x1EF6, 0x1EF7, 0x1EF8, 0x1EF9, 0x1F00, 0x1F01, 0x1F02,
    0x1F03, 0x1F04, 0x1F05, 0x1F06, 0x1F07, 0x1F08, 0x1F09, 0x1F0A,
    0x1F0B, 0x1F0C, 0x1F0D, 0x1F0E, 0x1F0F, 0x1F10, 0x1F11, 0x1F12,
    0x1F13, 0x1F14, 0x1F15, 0x1F18, 0x1F19, 0x1F1A, 0x1F1B, 0x1F1C,
    0x1F1D, 0x1F20, 0x1F21, 0x1F22, 0x1F23, 0x1F24, 0x1F25, 0x1F26,
    0x1F27, 0x1F28, 0x1F29, 0x1F2A, 0x1F2B, 0x1F2C, 0x1F2D, 0x1F2E,
    0x1F2F, 0x1F30, 0x1F31, 0x1F32, 0x1F33, 0x1F34, 0x1F35, 0x1F36,
    0x1F37, 0x1F38, 0x1F39, 0x1F3A, 0x1F3B, 0x1F3C, 0x1F3D, 0x1F3E,
    0x1F3F, 0x1F40, 0x1F41, 0x1F42, 0x1F43, 0x1F44, 0x1F45, 0x1F48,
    0x1F49, 0x1F4A, 0x1F4B, 0x1F4C, 0x1F4D, 0x1F50, 0x1F51, 0x1F52,
    0x1F53, 0x1F54, 0x1F55, 0x1F56, 0x1F57, 0x1F59, 0x1F5B, 0x1F5D,
    0x1F5F, 0x1F60, 0x1F61, 0x1F62, 0x1F63, 0x1F64, 0x1F65, 0x1F66,
    0x1F67, 0x1F68, 0x1F69, 0x1F6A, 0x1F6B, 0x1F6C, 0x1F6D, 0x1F6E,
    0x1F6F, 0x1F70, 0x1F71, 0x1F72, 0x1F73, 0x1F74, 0x1F75, 0x1F76,
    0x1F77, 0x1F78, 0x1F79, 0x1F7A, 0x1F7B, 0x1F7C, 0x1F7D, 0x1F80,
    0x1F81, 0x1F82, 0x1F83, 0x1F84, 0x1F85, 0x1F86, 0x1F87, 0x1F88,
    0x1F89, 0x1F8A, 0x1F8B, 0x1F8C, 0x1F8D, 0x1F8E, 0x1F8F, 0x1F90,
    0x1F91, 0x1F92, 0x1F93, 0x1F94, 0x1F95, 0x1F96, 0x1F97, 0x1F98,
    0x1F99, 0x1F9A, 0x1F9B, 0x1F9C, 0x1F9D, 0x1F9E, 0x1F9F, 0x1FA0,
    0x1FA1, 0x1FA2, 0x1FA3, 0x1FA4, 0x1FA5, 0x1FA6, 0x1FA7, 0x1FA8,
    0x1FA9, 0x1FAA, 0x1FAB, 0x1FAC, 0x1FAD, 0x1FAE, 0x1FAF, 0x1FB0,
    0x1FB1, 0x1FB2, 0x1FB3, 0x1FB4, 0x1FB6, 0x1FB7, 0x1FB8, 0x1FB9,
    0x1FBA, 0x1FBB, 0x1FBC, 0x1FBD, 0x1FBE, 0x1FBF, 0x1FC0, 0x1FC1,
    0x1FC2, 0x1FC3, 0x1FC4, 0x1FC6, 0x1FC7, 0x1FC8, 0x1FC9, 0x1FCA,
    0x1FCB, 0x1FCC, 0x1FCD, 0x1FCE, 0x1FCF, 0x1FD0, 0x1FD1, 0x1FD2,
    0x1FD3, 0x1FD6, 0x1FD7, 0x1FD8, 0x1FD9, 0x1FDA, 0x1FDB, 0x1FDD,
    0x1FDE, 0x1FDF, 0x1FE0, 0x1FE1, 0x1FE2, 0x1FE3, 0x1FE4, 0x1FE5,
    0x1FE6, 0x1FE7, 0x1FE8, 0x1FE9, 0x1FEA, 0x1FEB, 0x1FEC, 0x1FED,
    0x1FEE, 0x1FEF, 0x1FF2, 0x1FF3, 0x1FF4, 0x1FF6, 0x1FF7, 0x1FF8,
    0x1FF9, 0x1FFA, 0x1FFB, 0x1FFC, 0x1FFD, 0x1FFE, 0x2000, 0x2001,
    0x2002, 0x2003, 0x2004, 0x2005, 0x2006, 0x2007, 0x2008, 0x2009,
    0x200A, 0x2011, 0x2017, 0x2024, 0x2025, 0x2026, 0x202F, 0x2033,
    0x2034, 0x2036, 0x2037, 0x203C, 0x203E, 0x2047, 0x2048, 0x2049,
    0x2057, 0x205F, 0x2070, 0x2071, 0x2074, 0x2075, 0x2076, 0x2077,
    0x2078, 0x2079, 0x207A, 0x207B, 0x207C, 0x207D, 0x207E, 0x207F,
    0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086, 0x2087,
    0x2088, 0x2089, 0x208A, 0x208B, 0x208C, 0x208D, 0x208E, 0x2090,
    0x2091, 0x2092, 0x2093, 0x2094, 0x2095, 0x2096, 0x2097, 0x2098,
    0x2099, 0x209A, 0x209B, 0x209C, 0x20A8, 0x2100, 0x2101, 0x2102,
    0x2103, 0x2105, 0x2106, 0x2107, 0x2109, 0x210A, 0x210B, 0x210C,
    0x210D, 0x210E, 0x210F, 0x2110, 0x2111, 0x2112, 0x2113, 0x2115,
    0x2116, 0x2119, 0x211A, 0x211B, 0x211C, 0x211D, 0x2120, 0x2121,
    0x2122, 0x2124, 0x2126, 0x2128, 0x212A, 0x212B, 0x212C, 0x212D,
    0x212F, 0x2130, 0x2131, 0x2133, 0x2134, 0x2135, 0x2136, 0x2137,
    0x2138, 0x2139, 0x213B, 0x213C, 0x213D, 0x213E, 0x213F, 0x2140,
    0x2145, 0x2146, 0x2147, 0x2148, 0x2149, 0x2150, 0x2151, 0x2152,
    0x2153, 0x2154, 0x2155, 0x2156, 0x2157, 0x2158, 0x2159, 0x215A,
    0x215B, 0x215C, 0x215D, 0x215E, 0x215F, 0x2160, 0x2161, 0x2162,
    0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0x216A,
    0x216B, 0x216C, 0x216D, 0x216E, 0x216F, 0x2170, 0x2171, 0x2172,
    0x2173, 0x2174, 0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x217A,
    0x217B, 0x217C, 0x217D, 0x217E, 0x217F, 0x2189, 0x219A, 0x219B,
    0x21AE, 0x21CD, 0x21CE, 0x21CF, 0x2204, 0x2209, 0x220C, 0x2224,
    0x2226, 0x222C, 0x222D, 0x222F, 0x2230, 0x2241, 0x2244, 0x2247,
    0x2249, 0x2260, 0x2262, 0x226D, 0x226E, 0x226F, 0x2270, 0x2271,
    0x2274, 0x2275, 0x2278, 0x2279, 0x2280, 0x2281, 0x2284, 0x2285,
    0x2288, 0x2289, 0x22AC, 0x22AD, 0x22AE, 0x22AF, 0x22E0, 0x22E1,
    0x22E2, 0x22E3, 0x22EA, 0x22EB, 0x22EC, 0x22ED, 0x2329, 0x232A,
    0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467,
    0x2468, 0x2469, 0x246A, 0x246B, 0x246C, 0x246D, 0x246E, 0x246F,
    0x2470, 0x2471, 0x2472, 0x2473, 0x2474, 0x2475, 0x2476, 0x2477,
    0x2478, 0x2479, 0x247A, 0x247B, 0x247C, 0x247D, 0x247E, 0x247F,
    0x2480, 0x2481, 0x2482, 0x2483, 0x2484, 0x2485, 0x2486, 0x2487,
    0x2488, 0x2489, 0x248A, 0x248B, 0x248C, 0x248D, 0x248E, 0x248F,
    0x2490, 0x2491, 0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 0x2497,
    0x2498, 0x2499, 0x249A, 0x249B, 0x249C, 0x249D, 0x249E, 0x249F,
    0x24A0, 0x24A1, 0x24A2, 0x24A3, 0x24A4, 0x24A5, 0x24A6, 0x24A7,
    0x24A8, 0x24A9, 0x24AA, 0x24AB, 0x24AC, 0x24AD, 0x24AE, 0x24AF,
    0x24B0, 0x24B1, 0x24B2, 0x24B3, 0x24B4, 0x24B5, 0x24B6, 0x24B7,
    0x24B8, 0x24B9, 0x24BA, 0x24BB, 0x24BC, 0x24BD, 0x24BE, 0x24BF,
    0x24C0, 0x24C1, 0x24C2, 0x24C3, 0x24C4, 0x24C5, 0x24C6, 0x24C7,
    0x24C8, 0x24C9, 0x24CA, 0x24CB, 0x24CC, 0x24CD, 0x24CE, 0x24CF,
    0x24D0, 0x24D1, 0x24D2, 0x24D3, 0x24D4, 0x24D5, 0x24D6, 0x24D7,
    0x24D8, 0x24D9, 0x24DA, 0x24DB, 0x24DC, 0x24DD, 0x24DE, 0x24DF,
    0x24E0, 0x24E1, 0x24E2, 0x24E3, 0x24E4, 0x24E5, 0x24E6, 0x24E7,
    0x24E8, 0x24E9, 0x24EA, 0x2A0C, 0x2A74, 0x2A75, 0x2A76, 0x2ADC,
    0x2C7C, 0x2C7D, 0x2D6F, 0x2E9F, 0x2EF3, 0x2F00, 0x2F01, 0x2F02,
    0x2F03, 0x2F04, 0x2F05, 0x2F06, 0x2F07, 0x2F08, 0x2F09, 0x2F0A,
    0x2F0B, 0x2F0C, 0x2F0D, 0x2F0E, 0x2F0F, 0x2F10, 0x2F11, 0x2F12,
    0x2F13, 0x2F14, 0x2F15, 0x2F16, 0x2F17, 0x2F18, 0x2F19, 0x2F1A,
    0x2F1B, 0x2F1C, 0x2F1D, 0x2F1E, 0x2F1F, 0x2F20, 0x2F21, 0x2F22,
    0x2F23, 0x2F24, 0x2F25, 0x2F26, 0x2F27, 0x2F28, 0x2F29, 0x2F2A,
    0x2F2B, 0x2F2C, 0x2F2D, 0x2F2E, 0x2F2F, 0x2F30, 0x2F31, 0x2F32,
    0x2F33, 0x2F34, 0x2F35, 0x2F36, 0x2F37, 0x2F38, 0x2F39, 0x2F3A,
    0x2F3B, 0x2F3C, 0x2F3D, 0x2F3E, 0x2F3F, 0x2F40, 0x2F41, 0x2F42,
    0x2F43, 0x2F44, 0x2F45, 0x2F46, 0x2F47, 0x2F48, 0x2F49, 0x2F4A,
    0x2F4B, 0x2F4C, 0x2F4D, 0x2F4E, 0x2F4F, 0x2F50, 0x2F51, 0x2F52,
    0x2F53, 0x2F54, 0x2F55, 0x2F56, 0x2F57, 0x2F58, 0x2F59, 0x2F5A,
    0x2F5B, 0x2F5C, 0x2F5D, 0x2F5E, 0x2F5F, 0x2F60, 0x2F61, 0x2F62,
    0x2F63, 0x2F64, 0x2F65, 0x2F66, 0x2F67, 0x2F68, 0x2F69, 0x2F6A,
    0x2F6B, 0x2F6C, 0x2F6D, 0x2F6E, 0x2F6F, 0x2F70, 0x2F71, 0x2F72,
    0x2F73, 0x2F74, 0x2F75, 0x2F76, 0x2F77, 0x2F78, 0x2F79, 0x2F7A,
    0x2F7B, 0x2F7C, 0x2F7D, 0x2F7E, 0x2F7F, 0x2F80, 0x2F81, 0x2F82,
    0x2F83, 0x2F84, 0x2F85, 0x2F86, 0x2F87, 0x2F88, 0x2F89, 0x2F8A,
    0x2F8B, 0x2F8C, 0x2F8D, 0x2F8E, 0x2F8F, 0x2F90, 0x2F91, 0x2F92,
    0x2F93, 0x2F94, 0x2F95, 0x2F96, 0x2F97, 0x2F98, 0x2F99, 0x2F9A,
    0x2F9B, 0x2F9C, 0x2F9D, 0x2F9E, 0x2F9F, 0x2FA0, 0x2FA1, 0x2FA2,
    0x2FA3, 0x2FA4, 0x2FA5, 0x2FA6, 0x2FA7, 0x2FA8, 0x2FA9, 0x2FAA,
    0x2FAB, 0x2FAC, 0x2FAD, 0x2FAE, 0x2FAF, 0x2FB0, 0x2FB1, 0x2FB2,
    0x2FB3, 0x2FB4, 0x2FB5, 0x2FB6, 0x2FB7, 0x2FB8, 0x2FB9, 0x2FBA,
    0x2FBB, 0x2FBC, 0x2FBD, 0x2FBE, 0x2FBF, 0x2FC0, 0x2FC1, 0x2FC2,
    0x2FC3, 0x2FC4, 0x2FC5, 0x2FC6, 0x2FC7, 0x2FC8, 0x2FC9, 0x2FCA,
    0x2FCB, 0x2FCC, 0x2FCD, 0x2FCE, 0x2FCF, 0x2FD0, 0x2FD1, 0x2FD2,
    0x2FD3, 0x2FD4, 0x2FD5, 0x3000, 0x3036, 0x3038, 0x3039, 0x303A,
    0x304C, 0x304E, 0x3050, 0x3052, 0x3054, 0x3056, 0x3058, 0x305A,
    0x305C, 0x305E, 0x3060, 0x3062, 0x3065, 0x3067, 0x3069, 0x3070,
    0x3071, 0x3073, 0x3074, 0x3076, 0x3077, 0x3079, 0x307A, 0x307C,
    0x307D, 0x3094, 0x309B, 0x309C, 0x309E, 0x309F, 0x30AC, 0x30AE,
    0x30B0, 0x30B2, 0x30B4, 0x30B6, 0x30B8, 0x30BA, 0x30BC, 0x30BE,
    0x30C0, 0x30C2, 0x30C5, 0x30C7, 0x30C9, 0x30D0, 0x30D1, 0x30D3,
    0x30D4, 0x30D6, 0x30D7, 0x30D9, 0x30DA, 0x30DC, 0x30DD, 0x30F4,
    0x30F7, 0x30F8, 0x30F9, 0x30FA, 0x30FE, 0x30FF, 0x3131, 0x3132,
    0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 0x3138, 0x3139, 0x313A,
    0x313B, 0x313C, 0x313D, 0x313E, 0x313F, 0x3140, 0x3141, 0x3142,
    0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148, 0x3149, 0x314A,
    0x314B, 0x314C, 0x314D, 0x314E, 0x314F, 0x3150, 0x3151, 0x3152,
    0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158, 0x3159, 0x315A,
    0x315B, 0x315C, 0x315D, 0x315E, 0x315F, 0x3160, 0x3161, 0x3162,
    0x3163, 0x3164, 0x3165, 0x3166, 0x3167, 0x3168, 0x3169, 0x316A,
    0x316B, 0x316C, 0x316D, 0x316E, 0x316F, 0x3170, 0x3171, 0x3172,
    0x3173, 0x3174, 0x3175, 0x3176, 0x3177, 0x3178, 0x3179, 0x317A,
    0x317B, 0x317C, 0x317D, 0x317E, 0x317F, 0x3180, 0x3181, 0x3182,
    0x3183, 0x3184, 0x3185, 0x3186, 0x3187, 0x3188, 0x3189, 0x318A,
    0x318B, 0x318C, 0x318D, 0x318E, 0x3192, 0x3193, 0x3194, 0x3195,
    0x3196, 0x3197, 0x3198, 0x3199, 0x319A, 0x319B, 0x319C, 0x319D,
    0x319E, 0x319F, 0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205,
    0x3206, 0x3207, 0x3208, 0x3209, 0x320A, 0x320B, 0x320C, 0x320D,
    0x320E, 0x320F, 0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x3215,
    0x3216, 0x3217, 0x3218, 0x3219, 0x321A, 0x321B, 0x321C, 0x321D,
    0x321E, 0x3220, 0x3221, 0x3222, 0x3223, 0x3224, 0x3225, 0x3226,
    0x3227, 0x3228, 0x3229, 0x322A, 0x322B, 0x322C, 0x322D, 0x322E,
    0x322F, 0x3230, 0x3231, 0x3232, 0x3233, 0x3234, 0x3235, 0x3236,
    0x3237, 0x3238, 0x3239, 0x323A, 0x323B, 0x323C, 0x323D, 0x323E,
    0x323F, 0x3240, 0x3241, 0x3242, 0x3243, 0x3244, 0x3245, 0x3246,
    0x3247, 0x3250, 0x3251, 0x3252, 0x3253, 0x3254, 0x3255, 0x3256,
    0x3257, 0x3258, 0x3259, 0x325A, 0x325B, 0x325C, 0x325D, 0x325E,
    0x325F, 0x3260, 0x3261, 0x3262, 0x3263, 0x3264, 0x3265, 0x3266,
    0x3267, 0x3268, 0x3269, 0x326A, 0x326B, 0x326C, 0x326D, 0x326E,
    0x326F, 0x3270, 0x3271, 0x3272, 0x3273, 0x3274, 0x3275, 0x3276,
    0x3277, 0x3278, 0x3279, 0x327A, 0x327B, 0x327C, 0x327D, 0x327E,
    0x3280, 0x3281, 0x3282, 0x3283, 0x3284, 0x3285, 0x3286, 0x3287,
    0x3288, 0x3289, 0x328A, 0x328B, 0x328C, 0x328D, 0x328E, 0x328F,
    0x3290, 0x3291, 0x3292, 0x3293, 0x3294, 0x3295, 0x3296, 0x3297,
    0x3298, 0x3299, 0x329A, 0x329B, 0x329C, 0x329D, 0x329E, 0x329F,
    0x32A0, 0x32A1, 0x32A2, 0x32A3, 0x32A4, 0x32A5, 0x32A6, 0x32A7,
    0x32A8, 0x32A9, 0x32AA, 0x32AB, 0x32AC, 0x32AD, 0x32AE, 0x32AF,
    0x32B0, 0x32B1, 0x32B2, 0x32B3, 0x32B4, 0x32B5, 0x32B6, 0x32B7,
    0x32B8, 0x32B9, 0x32BA, 0x32BB, 0x32BC, 0x32BD, 0x32BE, 0x32BF,
    0x32C0, 0x32C1, 0x32C2, 0x32C3, 0x32C4, 0x32C5, 0x32C6, 0x32C7,
    0x32C8, 0x32C9, 0x32CA, 0x32CB, 0x32CC, 0x32CD, 0x32CE, 0x32CF,
    0x32D0, 0x32D1, 0x32D2, 0x32D3, 0x32D4, 0x32D5, 0x32D6, 0x32D7,
    0x32D8, 0x32D9, 0x32DA, 0x32DB, 0x32DC, 0x32DD, 0x32DE, 0x32DF,
    0x32E0, 0x32E1, 0x32E2, 0x32E3, 0x32E4, 0x32E5, 0x32E6, 0x32E7,
    0x32E8, 0x32E9, 0x32EA, 0x32EB, 0x32EC, 0x32ED, 0x32EE, 0x32EF,
    0x32F0, 0x32F1, 0x32F2, 0x32F3, 0x32F4, 0x32F5, 0x32F6, 0x32F7,
    0x32F8, 0x32F9, 0x32FA, 0x32FB, 0x32FC, 0x32FD, 0x32FE, 0x32FF,
    0x3300, 0x3301, 0x3302, 0x3303, 0x3304, 0x3305, 0x3306, 0x3307,
    0x3308, 0x3309, 0x330A, 0x330B, 0x330C, 0x330D, 0x330E, 0x330F,
    0x3310, 0x3311, 0x3312, 0x3313, 0x3314, 0x3315, 0x3316, 0x3317,
    0x3318, 0x3319, 0x331A, 0x331B, 0x331C, 0x331D, 0x331E, 0x331F,
    0x3320, 0x3321, 0x3322, 0x3323, 0x3324, 0x3325, 0x3326, 0x3327,
    0x3328, 0x3329, 0x332A, 0x332B, 0x332C, 0x332D, 0x332E, 0x332F,
    0x3330, 0x3331, 0x3332, 0x3333, 0x3334, 0x3335, 0x3336, 0x3337,
    0x3338, 0x3339, 0x333A, 0x333B, 0x333C, 0x333D, 0x333E, 0x333F,
    0x3340, 0x3341, 0x3342, 0x3343, 0x3344, 0x3345, 0x3346, 0x3347,
    0x3348, 0x3349, 0x334A, 0x334B, 0x334C, 0x334D, 0x334E, 0x334F,
    0x3350, 0x3351, 0x3352, 0x3353, 0x3354, 0x3355, 0x3356, 0x3357,
    0x3358, 0x3359, 0x335A, 0x335B, 0x335C, 0x335D, 0x335E, 0x335F,
    0x3360, 0x3361, 0x3362, 0x3363, 0x3364, 0x3365, 0x3366, 0x3367,
    0x3368, 0x3369, 0x336A, 0x336B, 0x336C, 0x336D, 0x336E, 0x336F,
    0x3370, 0x3371, 0x3372, 0x3373, 0x3374, 0x3375, 0x3376, 0x3377,
    0x3378, 0x3379, 0x337A, 0x337B, 0x337C, 0x337D, 0x337E, 0x337F,
    0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x3385, 0x3386, 0x3387,
    0x3388, 0x3389, 0x338A, 0x338B, 0x338C, 0x338D, 0x338E, 0x338F,
    0x3390, 0x3391, 0x3392, 0x3393, 0x3394, 0x3395, 0x3396, 0x3397,
    0x3398, 0x3399, 0x339A, 0x339B, 0x339C, 0x339D, 0x339E, 0x339F,
    0x33A0, 0x33A1, 0x33A2, 0x33A3, 0x33A4, 0x33A5, 0x33A6, 0x33A7,
    0x33A8, 0x33A9, 0x33AA, 0x33AB, 0x33AC, 0x33AD, 0x33AE, 0x33AF,
    0x33B0, 0x33B1, 0x33B2, 0x33B3, 0x33B4, 0x33B5, 0x33B6, 0x33B7,
    0x33B8, 0x33B9, 0x33BA, 0x33BB, 0x33BC, 0x33BD, 0x33BE, 0x33BF,
    0x33C0, 0x33C1, 0x33C2, 0x33C3, 0x33C4, 0x33C5, 0x33C6, 0x33C7,
    0x33C8, 0x33C9, 0x33CA, 0x33CB, 0x33CC, 0x33CD, 0x33CE, 0x33CF,
    0x33D0, 0x33D1, 0x33D2, 0x33D3, 0x33D4, 0x33D5, 0x33D6, 0x33D7,
    0x33D8, 0x33D9, 0x33DA, 0x33DB, 0x33DC, 0x33DD, 0x33DE, 0x33DF,
    0x33E0, 0x33E1, 0x33E2, 0x33E3, 0x33E4, 0x33E5, 0x33E6, 0x33E7,
    0x33E8, 0x33E9, 0x33EA, 0x33EB, 0x33EC, 0x33ED, 0x33EE, 0x33EF,
    0x33F0, 0x33F1, 0x33F2, 0x33F3, 0x33F4, 0x33F5, 0x33F6, 0x33F7,
    0x33F8, 0x33F9, 0x33FA, 0x33FB, 0x33FC, 0x33FD, 0x33FE, 0x33FF,
    0xA69C, 0xA69D, 0xA770, 0xA7F8, 0xA7F9, 0xAB5C, 0xAB5D, 0xAB5E,
    0xAB5F, 0xAB69, 0xF900, 0xF901, 0xF902, 0xF903, 0xF904, 0xF905,
    0xF906, 0xF907, 0xF908, 0xF909, 0xF90A, 0xF90B, 0xF90C, 0xF90D,
    0xF90E, 0xF90F, 0xF910, 0xF911, 0xF912, 0xF913, 0xF914, 0xF915,
    0xF916, 0xF917, 0xF918, 0xF919, 0xF91A, 0xF91B, 0xF91C, 0xF91D,
    0xF91E, 0xF91F, 0xF920, 0xF921, 0xF922, 0xF923, 0xF924, 0xF925,
    0xF926, 0xF927, 0xF928, 0xF929, 0xF92A, 0xF92B, 0xF92C, 0xF92D,
    0xF92E, 0xF92F, 0xF930, 0xF931, 0xF932, 0xF933, 0xF934, 0xF935,
    0xF936, 0xF937, 0xF938, 0xF939, 0xF93A, 0xF93B, 0xF93C, 0xF93D,
    0xF93E, 0xF93F, 0xF940, 0xF941, 0xF942, 0xF943, 0xF944, 0xF945,
    0xF946, 0xF947, 0xF948, 0xF949, 0xF94A, 0xF94B, 0xF94C, 0xF94D,
    0xF94E, 0xF94F, 0xF950, 0xF951, 0xF952, 0xF953, 0xF954, 0xF955,
    0xF956, 0xF957, 0xF958, 0xF959, 0xF95A, 0xF95B, 0xF95C, 0xF95D,
    0xF95E, 0xF95F, 0xF960, 0xF961, 0xF962, 0xF963, 0xF964, 0xF965,
    0xF966, 0xF967, 0xF968, 0xF969, 0xF96A, 0xF96B, 0xF96C, 0xF96D,
    0xF96E, 0xF96F, 0xF970, 0xF971, 0xF972, 0xF973, 0xF974, 0xF975,
    0xF976, 0xF977, 0xF978, 0xF979, 0xF97A, 0xF97B, 0xF97C, 0xF97D,
    0xF97E, 0xF97F, 0xF980, 0xF981, 0xF982, 0xF983, 0xF984, 0xF985,
    0xF986, 0xF987, 0xF988, 0xF989, 0xF98A, 0xF98B, 0xF98C, 0xF98D,
    0xF98E, 0xF98F, 0xF990, 0xF991, 0xF992, 0xF993, 0xF994, 0xF995,
    0xF996, 0xF997, 0xF998, 0xF999, 0xF99A, 0xF99B, 0xF99C, 0xF99D,
    0xF99E, 0xF99F, 0xF9A0, 0xF9A1, 0xF9A2, 0xF9A3, 0xF9A4, 0xF9A5,
    0xF9A6, 0xF9A7, 0xF9A8, 0xF9A9, 0xF9AA, 0xF9AB, 0xF9AC, 0xF9AD,
    0xF9AE, 0xF9AF, 0xF9B0, 0xF9B1, 0xF9B2, 0xF9B3, 0xF9B4, 0xF9B5,
    0xF9B6, 0xF9B7, 0xF9B8, 0xF9B9, 0xF9BA, 0xF9BB, 0xF9BC, 0xF9BD,
    0xF9BE, 0xF9BF, 0xF9C0, 0xF9C1, 0xF9C2, 0xF9C3, 0xF9C4, 0xF9C5,
    0xF9C6, 0xF9C7, 0xF9C8, 0xF9C9, 0xF9CA, 0xF9CB, 0xF9CC, 0xF9CD,
    0xF9CE, 0xF9CF, 0xF9D0, 0xF9D1, 0xF9D2, 0xF9D3, 0xF9D4, 0xF9D5,
    0xF9D6, 0xF9D7, 0xF9D8, 0xF9D9, 0xF9DA, 0xF9DB, 0xF9DC, 0xF9DD,
    0xF9DE, 0xF9DF, 0xF9E0, 0xF9E1, 0xF9E2, 0xF9E3, 0xF9E4, 0xF9E5,
    0xF9E6, 0xF9E7, 0xF9E8, 0xF9E9, 0xF9EA, 0xF9EB, 0xF9EC, 0xF9ED,
    0xF9EE, 0xF9EF, 0xF9F0, 0xF9F1, 0xF9F2, 0xF9F3, 0xF9F4, 0xF9F5,
    0xF9F6, 0xF9F7, 0xF9F8, 0xF9F9, 0xF9FA, 0xF9FB, 0xF9FC, 0xF9FD,
    0xF9FE, 0xF9FF, 0xFA00, 0xFA01, 0xFA02, 0xFA03, 0xFA04, 0xFA05,
    0xFA06, 0xFA07, 0xFA08, 0xFA09, 0xFA0A, 0xFA0B, 0xFA0C, 0xFA0D,
    0xFA10, 0xFA12, 0xFA15, 0xFA16, 0xFA17, 0xFA18, 0xFA19, 0xFA1A,
    0xFA1B, 0xFA1C, 0xFA1D, 0xFA1E, 0xFA20, 0xFA22, 0xFA25, 0xFA26,
    0xFA2A, 0xFA2B, 0xFA2C, 0xFA2D, 0xFA2E, 0xFA2F, 0xFA30, 0xFA31,
    0xFA32, 0xFA33, 0xFA34, 0xFA35, 0xFA36, 0xFA37, 0xFA38, 0xFA39,
    0xFA3A, 0xFA3B, 0xFA3C, 0xFA3D, 0xFA3E, 0xFA3F, 0xFA40, 0xFA41,
    0xFA42, 0xFA43, 0xFA44, 0xFA45, 0xFA46, 0xFA47, 0xFA48, 0xFA49,
    0xFA4A, 0xFA4B, 0xFA4C, 0xFA4D, 0xFA4E, 0xFA4F, 0xFA50, 0xFA51,
    0xFA52, 0xFA53, 0xFA54, 0xFA55, 0xFA56, 0xFA57, 0xFA58, 0xFA59,
    0xFA5A, 0xFA5B, 0xFA5C, 0xFA5D, 0xFA5E, 0xFA5F, 0xFA60, 0xFA61,
    0xFA62, 0xFA63, 0xFA64, 0xFA65, 0xFA66, 0xFA67, 0xFA68, 0xFA69,
    0xFA6A, 0xFA6B, 0xFA6C, 0xFA6D, 0xFA70, 0xFA71, 0xFA72, 0xFA73,
    0xFA74, 0xFA75, 0xFA76, 0xFA77, 0xFA78, 0xFA79, 0xFA7A, 0xFA7B,
    0xFA7C, 0xFA7D, 0xFA7E, 0xFA7F, 0xFA80, 0xFA81, 0xFA82, 0xFA83,
    0xFA84, 0xFA85, 0xFA86, 0xFA87, 0xFA88, 0xFA89, 0xFA8A, 0xFA8B,
    0xFA8C, 0xFA8D, 0xFA8E, 0xFA8F, 0xFA90, 0xFA91, 0xFA92, 0xFA93,
    0xFA94, 0xFA95, 0xFA96, 0xFA97, 0xFA98, 0xFA99, 0xFA9A, 0xFA9B,
    0xFA9C, 0xFA9D, 0xFA9E, 0xFA9F, 0xFAA0, 0xFAA1, 0xFAA2, 0xFAA3,
    0xFAA4, 0xFAA5, 0xFAA6, 0xFAA7, 0xFAA8, 0xFAA9, 0xFAAA, 0xFAAB,
    0xFAAC, 0xFAAD, 0xFAAE, 0xFAAF, 0xFAB0, 0xFAB1, 0xFAB2, 0xFAB3,
    0xFAB4, 0xFAB5, 0xFAB6, 0xFAB7, 0xFAB8, 0xFAB9, 0xFABA, 0xFABB,
    0xFABC, 0xFABD, 0xFABE, 0xFABF, 0xFAC0, 0xFAC1, 0xFAC2, 0xFAC3,
    0xFAC4, 0xFAC5, 0xFAC6, 0xFAC7, 0xFAC8, 0xFAC9, 0xFACA, 0xFACB,
    0xFACC, 0xFACD, 0xFACE, 0xFACF, 0xFAD0, 0xFAD1, 0xFAD2, 0xFAD3,
    0xFAD4, 0xFAD5, 0xFAD6, 0xFAD7, 0xFAD8, 0xFAD9, 0xFB00, 0xFB01,
    0xFB02, 0xFB03, 0xFB04, 0xFB05, 0xFB06, 0xFB13, 0xFB14, 0xFB15,
    0xFB16, 0xFB17, 0xFB1D, 0xFB1F, 0xFB20, 0xFB21, 0xFB22, 0xFB23,
    0xFB24, 0xFB25, 0xFB26, 0xFB27, 0xFB28, 0xFB29, 0xFB2A, 0xFB2B,
    0xFB2C, 0xFB2D, 0xFB2E, 0xFB2F, 0xFB30, 0xFB31, 0xFB32, 0xFB33,
    0xFB34, 0xFB35, 0xFB36, 0xFB38, 0xFB39, 0xFB3A, 0xFB3B, 0xFB3C,
    0xFB3E, 0xFB40, 0xFB41, 0xFB43, 0xFB44, 0xFB46, 0xFB47, 0xFB48,
    0xFB49, 0xFB4A, 0xFB4B, 0xFB4C, 0xFB4D, 0xFB4E, 0xFB4F, 0xFB50,
    0xFB51, 0xFB52, 0xFB53, 0xFB54, 0xFB55, 0xFB56, 0xFB57, 0xFB58,
    0xFB59, 0xFB5A, 0xFB5B, 0xFB5C, 0xFB5D, 0xFB5E, 0xFB5F, 0xFB60,
    0xFB61, 0xFB62, 0xFB63, 0xFB64, 0xFB65, 0xFB66, 0xFB67, 0xFB68,
    0xFB69, 0xFB6A, 0xFB6B, 0xFB6C, 0xFB6D, 0xFB6E, 0xFB6F, 0xFB70,
    0xFB71, 0xFB72, 0xFB73, 0xFB74, 0xFB75, 0xFB76, 0xFB77, 0xFB78,
    0xFB79, 0xFB7A, 0xFB7B, 0xFB7C, 0xFB7D, 0xFB7E, 0xFB7F, 0xFB80,
    0xFB81, 0xFB82, 0xFB83, 0xFB84, 0xFB85, 0xFB86, 0xFB87, 0xFB88,
    0xFB89, 0xFB8A, 0xFB8B, 0xFB8C, 0xFB8D, 0xFB8E, 0xFB8F, 0xFB90,
    0xFB91, 0xFB92, 0xFB93, 0xFB94, 0xFB95, 0xFB96, 0xFB97, 0xFB98,
    0xFB99, 0xFB9A, 0xFB9B, 0xFB9C, 0xFB9D, 0xFB9E, 0xFB9F, 0xFBA0,
    0xFBA1, 0xFBA2, 0xFBA3, 0xFBA4, 0xFBA5, 0xFBA6, 0xFBA7, 0xFBA8,
    0xFBA9, 0xFBAA, 0xFBAB, 0xFBAC, 0xFBAD, 0xFBAE, 0xFBAF, 0xFBB0,
    0xFBB1, 0xFBD3, 0xFBD4, 0xFBD5, 0xFBD6, 0xFBD7, 0xFBD8, 0xFBD9,
    0xFBDA, 0xFBDB, 0xFBDC, 0xFBDD, 0xFBDE, 0xFBDF, 0xFBE0, 0xFBE1,
    0xFBE2, 0xFBE3, 0xFBE4, 0xFBE5, 0xFBE6, 0xFBE7, 0xFBE8, 0xFBE9,
    0xFBEA, 0xFBEB, 0xFBEC, 0xFBED, 0xFBEE, 0xFBEF, 0xFBF0, 0xFBF1,
    0xFBF2, 0xFBF3, 0xFBF4, 0xFBF5, 0xFBF6, 0xFBF7, 0xFBF8, 0xFBF9,
    0xFBFA, 0xFBFB, 0xFBFC, 0xFBFD, 0xFBFE, 0xFBFF, 0xFC00, 0xFC01,
    0xFC02, 0xFC03, 0xFC04, 0xFC05, 0xFC06, 0xFC07, 0xFC08, 0xFC09,
    0xFC0A, 0xFC0B, 0xFC0C, 0xFC0D, 0xFC0E, 0xFC0F, 0xFC10, 0xFC11,
    0xFC12, 0xFC13, 0xFC14, 0xFC15, 0xFC16, 0xFC17, 0xFC18, 0xFC19,
    0xFC1A, 0xFC1B, 0xFC1C, 0xFC1D, 0xFC1E, 0xFC1F, 0xFC20, 0xFC21,
    0xFC22, 0xFC23, 0xFC24, 0xFC25, 0xFC26, 0xFC27, 0xFC28, 0xFC29,
    0xFC2A, 0xFC2B, 0xFC2C, 0xFC2D, 0xFC2E, 0xFC2F, 0xFC30, 0xFC31,
    0xFC32, 0xFC33, 0xFC34, 0xFC35, 0xFC36, 0xFC37, 0xFC38, 0xFC39,
    0xFC3A, 0xFC3B, 0xFC3C, 0xFC3D, 0xFC3E, 0xFC3F, 0xFC40, 0xFC41,
    0xFC42, 0xFC43, 0xFC44, 0xFC45, 0xFC46, 0xFC47, 0xFC48, 0xFC49,
    0xFC4A, 0xFC4B, 0xFC4C, 0xFC4D, 0xFC4E, 0xFC4F, 0xFC50, 0xFC51,
    0xFC52, 0xFC53, 0xFC54, 0xFC55, 0xFC56, 0xFC57, 0xFC58, 0xFC59,
    0xFC5A, 0xFC5B, 0xFC5C, 0xFC5D, 0xFC5E, 0xFC5F, 0xFC60, 0xFC61,
    0xFC62, 0xFC63, 0xFC64, 0xFC65, 0xFC66, 0xFC67, 0xFC68, 0xFC69,
    0xFC6A, 0xFC6B, 0xFC6C, 0xFC6D, 0xFC6E, 0xFC6F, 0xFC70, 0xFC71,
    0xFC72, 0xFC73, 0xFC74, 0xFC75, 0xFC76, 0xFC77, 0xFC78, 0xFC79,
    0xFC7A, 0xFC7B, 0xFC7C, 0xFC7D, 0xFC7E, 0xFC7F, 0xFC80, 0xFC81,
    0xFC82, 0xFC83, 0xFC84, 0xFC85, 0xFC86, 0xFC87, 0xFC88, 0xFC89,
    0xFC8A, 0xFC8B, 0xFC8C, 0xFC8D, 0xFC8E, 0xFC8F, 0xFC90, 0xFC91,
    0xFC92, 0xFC93, 0xFC94, 0xFC95, 0xFC96, 0xFC97, 0xFC98, 0xFC99,
    0xFC9A, 0xFC9B, 0xFC9C, 0xFC9D, 0xFC9E, 0xFC9F, 0xFCA0, 0xFCA1,
    0xFCA2, 0xFCA3, 0xFCA4, 0xFCA5, 0xFCA6, 0xFCA7, 0xFCA8, 0xFCA9,
    0xFCAA, 0xFCAB, 0xFCAC, 0xFCAD, 0xFCAE, 0xFCAF, 0xFCB0, 0xFCB1,
    0xFCB2, 0xFCB3, 0xFCB4, 0xFCB5, 0xFCB6, 0xFCB7, 0xFCB8, 0xFCB9,
    0xFCBA, 0xFCBB, 0xFCBC, 0xFCBD, 0xFCBE, 0xFCBF, 0xFCC0, 0xFCC1,
    0xFCC2, 0xFCC3, 0xFCC4, 0xFCC5, 0xFCC6, 0xFCC7, 0xFCC8, 0xFCC9,
    0xFCCA, 0xFCCB, 0xFCCC, 0xFCCD, 0xFCCE, 0xFCCF, 0xFCD0, 0xFCD1,
    0xFCD2, 0xFCD3, 0xFCD4, 0xFCD5, 0xFCD6, 0xFCD7, 0xFCD8, 0xFCD9,
    0xFCDA, 0xFCDB, 0xFCDC, 0xFCDD, 0xFCDE, 0xFCDF, 0xFCE0, 0xFCE1,
    0xFCE2, 0xFCE3, 0xFCE4, 0xFCE5, 0xFCE6, 0xFCE7, 0xFCE8, 0xFCE9,
    0xFCEA, 0xFCEB, 0xFCEC, 0xFCED, 0xFCEE, 0xFCEF, 0xFCF0, 0xFCF1,
    0xFCF2, 0xFCF3, 0xFCF4, 0xFCF5, 0xFCF6, 0xFCF7, 0xFCF8, 0xFCF9,
    0xFCFA, 0xFCFB, 0xFCFC, 0xFCFD, 0xFCFE, 0xFCFF, 0xFD00, 0xFD01,
    0xFD02, 0xFD03, 0xFD04, 0xFD05, 0xFD06, 0xFD07, 0xFD08, 0xFD09,
    0xFD0A, 0xFD0B, 0xFD0C, 0xFD0D, 0xFD0E, 0xFD0F, 0xFD10, 0xFD11,
    0xFD12, 0xFD13, 0xFD14, 0xFD15, 0xFD16, 0xFD17, 0xFD18, 0xFD19,
    0xFD1A, 0xFD1B, 0xFD1C, 0xFD1D, 0xFD1E, 0xFD1F, 0xFD20, 0xFD21,
    0xFD22, 0xFD23, 0xFD24, 0xFD25, 0xFD26, 0xFD27, 0xFD28, 0xFD29,
    0xFD2A, 0xFD2B, 0xFD2C, 0xFD2D, 0xFD2E, 0xFD2F, 0xFD30, 0xFD31,
    0xFD32, 0xFD33, 0xFD34, 0xFD35, 0xFD36, 0xFD37, 0xFD38, 0xFD39,
    0xFD3A, 0xFD3B, 0xFD3C, 0xFD3D, 0xFD50, 0xFD51, 0xFD52, 0xFD53,
    0xFD54, 0xFD55, 0xFD56, 0xFD57, 0xFD58, 0xFD59, 0xFD5A, 0xFD5B,
    0xFD5C, 0xFD5D, 0xFD5E, 0xFD5F, 0xFD60, 0xFD61, 0xFD62, 0xFD63,
    0xFD64, 0xFD65, 0xFD66, 0xFD67, 0xFD68, 0xFD69, 0xFD6A, 0xFD6B,
    0xFD6C, 0xFD6D, 0xFD6E, 0xFD6F, 0xFD70, 0xFD71, 0xFD72, 0xFD73,
    0xFD74, 0xFD75, 0xFD76, 0xFD77, 0xFD78, 0xFD79, 0xFD7A, 0xFD7B,
    0xFD7C, 0xFD7D, 0xFD7E, 0xFD7F, 0xFD80, 0xFD81, 0xFD82, 0xFD83,
    0xFD84, 0xFD85, 0xFD86, 0xFD87, 0xFD88, 0xFD89, 0xFD8A, 0xFD8B,
    0xFD8C, 0xFD8D, 0xFD8E, 0xFD8F, 0xFD92, 0xFD93, 0xFD94, 0xFD95,
    0xFD96, 0xFD97, 0xFD98, 0xFD99, 0xFD9A, 0xFD9B, 0xFD9C, 0xFD9D,
    0xFD9E, 0xFD9F, 0xFDA0, 0xFDA1, 0xFDA2, 0xFDA3, 0xFDA4, 0xFDA5,
    0xFDA6, 0xFDA7, 0xFDA8, 0xFDA9, 0xFDAA, 0xFDAB, 0xFDAC, 0xFDAD,
    0xFDAE, 0xFDAF, 0xFDB0, 0xFDB1, 0xFDB2, 0xFDB3, 0xFDB4, 0xFDB5,
    0xFDB6, 0xFDB7, 0xFDB8, 0xFDB9, 0xFDBA, 0xFDBB, 0xFDBC, 0xFDBD,
    0xFDBE, 0xFDBF, 0xFDC0, 0xFDC1, 0xFDC2, 0xFDC3, 0xFDC4, 0xFDC5,
    0xFDC6, 0xFDC7, 0xFDF0, 0xFDF1, 0xFDF2, 0xFDF3, 0xFDF4, 0xFDF5,
    0xFDF6, 0xFDF7, 0xFDF8, 0xFDF9, 0xFDFA, 0xFDFB, 0xFDFC, 0xFE10,
    0xFE11, 0xFE12, 0xFE13, 0xFE14, 0xFE15, 0xFE16, 0xFE17, 0xFE18,
    0xFE19, 0xFE30, 0xFE31, 0xFE32, 0xFE33, 0xFE34, 0xFE35, 0xFE36,
    0xFE37, 0xFE38, 0xFE39, 0xFE3A, 0xFE3B, 0xFE3C, 0xFE3D, 0xFE3E,
    0xFE3F, 0xFE40, 0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE47, 0xFE48,
    0xFE49, 0xFE4A, 0xFE4B, 0xFE4C, 0xFE4D, 0xFE4E, 0xFE4F, 0xFE50,
    0xFE51, 0xFE52, 0xFE54, 0xFE55, 0xFE56, 0xFE57, 0xFE58, 0xFE59,
    0xFE5A, 0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE5F, 0xFE60, 0xFE61,
    0xFE62, 0xFE63, 0xFE64, 0xFE65, 0xFE66, 0xFE68, 0xFE69, 0xFE6A,
    0xFE6B, 0xFE70, 0xFE71, 0xFE72, 0xFE74, 0xFE76, 0xFE77, 0xFE78,
    0xFE79, 0xFE7A, 0xFE7B, 0xFE7C, 0xFE7D, 0xFE7E, 0xFE7F, 0xFE80,
    0xFE81, 0xFE82, 0xFE83, 0xFE84, 0xFE85, 0xFE86, 0xFE87, 0xFE88,
    0xFE89, 0xFE8A, 0xFE8B, 0xFE8C, 0xFE8D, 0xFE8E, 0xFE8F, 0xFE90,
    0xFE91, 0xFE92, 0xFE93, 0xFE94, 0xFE95, 0xFE96, 0xFE97, 0xFE98,
    0xFE99, 0xFE9A, 0xFE9B, 0xFE9C, 0xFE9D, 0xFE9E, 0xFE9F, 0xFEA0,
    0xFEA1, 0xFEA2, 0xFEA3, 0xFEA4, 0xFEA5, 0xFEA6, 0xFEA7, 0xFEA8,
    0xFEA9, 0xFEAA, 0xFEAB, 0xFEAC, 0xFEAD, 0xFEAE, 0xFEAF, 0xFEB0,
    0xFEB1, 0xFEB2, 0xFEB3, 0xFEB4, 0xFEB5, 0xFEB6, 0xFEB7, 0xFEB8,
    0xFEB9, 0xFEBA, 0xFEBB, 0xFEBC, 0xFEBD, 0xFEBE, 0xFEBF, 0xFEC0,
    0xFEC1, 0xFEC2, 0xFEC3, 0xFEC4, 0xFEC5, 0xFEC6, 0xFEC7, 0xFEC8,
    0xFEC9, 0xFECA, 0xFECB, 0xFECC, 0xFECD, 0xFECE, 0xFECF, 0xFED0,
    0xFED1, 0xFED2, 0xFED3, 0xFED4, 0xFED5, 0xFED6, 0xFED7, 0xFED8,
    0xFED9, 0xFEDA, 0xFEDB, 0xFEDC, 0xFEDD, 0xFEDE, 0xFEDF, 0xFEE0,
    0xFEE1, 0xFEE2, 0xFEE3, 0xFEE4, 0xFEE5, 0xFEE6, 0xFEE7, 0xFEE8,
    0xFEE9, 0xFEEA, 0xFEEB, 0xFEEC, 0xFEED, 0xFEEE, 0xFEEF, 0xFEF0,
    0xFEF1, 0xFEF2, 0xFEF3, 0xFEF4, 0xFEF5, 0xFEF6, 0xFEF7, 0xFEF8,
    0xFEF9, 0xFEFA, 0xFEFB, 0xFEFC, 0xFF01, 0xFF02, 0xFF03, 0xFF04,
    0xFF05, 0xFF06, 0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0B, 0xFF0C,
    0xFF0D, 0xFF0E, 0xFF0F, 0xFF10, 0xFF11, 0xFF12, 0xFF13, 0xFF14,
    0xFF15, 0xFF16, 0xFF17, 0xFF18, 0xFF19, 0xFF1A, 0xFF1B, 0xFF1C,
    0xFF1D, 0xFF1E, 0xFF1F, 0xFF20, 0xFF21, 0xFF22, 0xFF23, 0xFF24,
    0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C,
    0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34,
    0xFF35, 0xFF36, 0xFF37, 0xFF38, 0xFF39, 0xFF3A, 0xFF3B, 0xFF3C,
    0xFF3D, 0xFF3E, 0xFF3F, 0xFF40, 0xFF41, 0xFF42, 0xFF43, 0xFF44,
    0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C,
    0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54,
    0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 0xFF5B, 0xFF5C,
    0xFF5D, 0xFF5E, 0xFF5F, 0xFF60, 0xFF61, 0xFF62, 0xFF63, 0xFF64,
    0xFF65, 0xFF66, 0xFF67, 0xFF68, 0xFF69, 0xFF6A, 0xFF6B, 0xFF6C,
    0xFF6D, 0xFF6E, 0xFF6F, 0xFF70, 0xFF71, 0xFF72, 0xFF73, 0xFF74,
    0xFF75, 0xFF76, 0xFF77, 0xFF78, 0xFF79, 0xFF7A, 0xFF7B, 0xFF7C,
    0xFF7D, 0xFF7E, 0xFF7F, 0xFF80, 0xFF81, 0xFF82, 0xFF83, 0xFF84,
    0xFF85, 0xFF86, 0xFF87, 0xFF88, 0xFF89, 0xFF8A, 0xFF8B, 0xFF8C,
    0xFF8D, 0xFF8E, 0xFF8F, 0xFF90, 0xFF91, 0xFF92, 0xFF93, 0xFF94,
    0xFF95, 0xFF96, 0xFF97, 0xFF98, 0xFF99, 0xFF9A, 0xFF9B, 0xFF9C,
    0xFF9D, 0xFF9E, 0xFF9F, 0xFFA0, 0xFFA1, 0xFFA2, 0xFFA3, 0xFFA4,
    0xFFA5, 0xFFA6, 0xFFA7, 0xFFA8, 0xFFA9, 0xFFAA, 0xFFAB, 0xFFAC,
    0xFFAD, 0xFFAE, 0xFFAF, 0xFFB0, 0xFFB1, 0xFFB2, 0xFFB3, 0xFFB4,
    0xFFB5, 0xFFB6, 0xFFB7, 0xFFB8, 0xFFB9, 0xFFBA, 0xFFBB, 0xFFBC,
    0xFFBD, 0xFFBE, 0xFFC2, 0xFFC3, 0xFFC4, 0xFFC5, 0xFFC6, 0xFFC7,
    0xFFCA, 0xFFCB, 0xFFCC, 0xFFCD, 0xFFCE, 0xFFCF, 0xFFD2, 0xFFD3,
    0xFFD4, 0xFFD5, 0xFFD6, 0xFFD7, 0xFFDA, 0xFFDB, 0xFFDC, 0xFFE0,
    0xFFE1, 0xFFE2, 0xFFE3, 0xFFE4, 0xFFE5, 0xFFE6, 0xFFE8, 0xFFE9,
    0xFFEA, 0xFFEB, 0xFFEC, 0xFFED, 0xFFEE, 0x1109A, 0x1109C, 0x110AB,
    0x1112E, 0x1112F, 0x1134B, 0x1134C, 0x114BB, 0x114BC, 0x114BE, 0x115BA,
    0x115BB, 0x11938, 0x1D15E, 0x1D15F, 0x1D160, 0x1D161, 0x1D162, 0x1D163,
    0x1D164, 0x1D1BB, 0x1D1BC, 0x1D1BD, 0x1D1BE, 0x1D1BF, 0x1D1C0, 0x1D400,
    0x1D401, 0x1D402, 0x1D403, 0x1D404, 0x1D405, 0x1D406, 0x1D407, 0x1D408,
    0x1D409, 0x1D40A, 0x1D40B, 0x1D40C, 0x1D40D, 0x1D40E, 0x1D40F, 0x1D410,
    0x1D411, 0x1D412, 0x1D413, 0x1D414, 0x1D415, 0x1D416, 0x1D417, 0x1D418,
    0x1D419, 0x1D41A, 0x1D41B, 0x1D41C, 0x1D41D, 0x1D41E, 0x1D41F, 0x1D420,
    0x1D421, 0x1D422, 0x1D423, 0x1D424, 0x1D425, 0x1D426, 0x1D427, 0x1D428,
    0x1D429, 0x1D42A, 0x1D42B, 0x1D42C, 0x1D42D, 0x1D42E, 0x1D42F, 0x1D430,
    0x1D431, 0x1D432, 0x1D433, 0x1D434, 0x1D435, 0x1D436, 0x1D437, 0x1D438,
    0x1D439, 0x1D43A, 0x1D43B, 0x1D43C, 0x1D43D, 0x1D43E, 0x1D43F, 0x1D440,
    0x1D441, 0x1D442, 0x1D443, 0x1D444, 0x1D445, 0x1D446, 0x1D447, 0x1D448,
    0x1D449, 0x1D44A, 0x1D44B, 0x1D44C, 0x1D44D, 0x1D44E, 0x1D44F, 0x1D450,
    0x1D451, 0x1D452, 0x1D453, 0x1D454, 0x1D456, 0x1D457, 0x1D458, 0x1D459,
    0x1D45A, 0x1D45B, 0x1D45C, 0x1D45D, 0x1D45E, 0x1D45F, 0x1D460, 0x1D461,
    0x1D462, 0x1D463, 0x1D464, 0x1D465, 0x1D466, 0x1D467, 0x1D468, 0x1D469,
    0x1D46A, 0x1D46B, 0x1D46C, 0x1D46D, 0x1D46E, 0x1D46F, 0x1D470, 0x1D471,
    0x1D472, 0x1D473, 0x1D474, 0x1D475, 0x1D476, 0x1D477, 0x1D478, 0x1D479,
    0x1D47A, 0x1D47B, 0x1D47C, 0x1D47D, 0x1D47E, 0x1D47F, 0x1D480, 0x1D481,
    0x1D482, 0x1D483, 0x1D484, 0x1D485, 0x1D486, 0x1D487, 0x1D488, 0x1D489,
    0x1D48A, 0x1D48B, 0x1D48C, 0x1D48D, 0x1D48E, 0x1D48F, 0x1D490, 0x1D491,
    0x1D492, 0x1D493, 0x1D494, 0x1D495, 0x1D496, 0x1D497, 0x1D498, 0x1D499,
    0x1D49A, 0x1D49B, 0x1D49C, 0x1D49E, 0x1D49F, 0x1D4A2, 0x1D4A5, 0x1D4A6,
    0x1D4A9, 0x1D4AA, 0x1D4AB, 0x1D4AC, 0x1D4AE, 0x1D4AF, 0x1D4B0, 0x1D4B1,
    0x1D4B2, 0x1D4B3, 0x1D4B4, 0x1D4B5, 0x1D4B6, 0x1D4B7, 0x1D4B8, 0x1D4B9,
    0x1D4BB, 0x1D4BD, 0x1D4BE, 0x1D4BF, 0x1D4C0, 0x1D4C1, 0x1D4C2, 0x1D4C3,
    0x1D4C5, 0x1D4C6, 0x1D4C7, 0x1D4C8, 0x1D4C9, 0x1D4CA, 0x1D4CB, 0x1D4CC,
    0x1D4CD, 0x1D4CE, 0x1D4CF, 0x1D4D0, 0x1D4D1, 0x1D4D2, 0x1D4D3, 0x1D4D4,
    0x1D4D5, 0x1D4D6, 0x1D4D7, 0x1D4D8, 0x1D4D9, 0x1D4DA, 0x1D4DB, 0x1D4DC,
    0x1D4DD, 0x1D4DE, 0x1D4DF, 0x1D4E0, 0x1D4E1, 0x1D4E2, 0x1D4E3, 0x1D4E4,
    0x1D4E5, 0x1D4E6, 0x1D4E7, 0x1D4E8, 0x1D4E9, 0x1D4EA, 0x1D4EB, 0x1D4EC,
    0x1D4ED, 0x1D4EE, 0x1D4EF, 0x1D4F0, 0x1D4F1, 0x1D4F2, 0x1D4F3, 0x1D4F4,
    0x1D4F5, 0x1D4F6, 0x1D4F7, 0x1D4F8, 0x1D4F9, 0x1D4FA, 0x1D4FB, 0x1D4FC,
    0x1D4FD, 0x1D4FE, 0x1D4FF, 0x1D500, 0x1D501, 0x1D502, 0x1D503, 0x1D504,
    0x1D505, 0x1D507, 0x1D508, 0x1D509, 0x1D50A, 0x1D50D, 0x1D50E, 0x1D50F,
    0x1D510, 0x1D511, 0x1D512, 0x1D513, 0x1D514, 0x1D516, 0x1D517, 0x1D518,
    0x1D519, 0x1D51A, 0x1D51B, 0x1D51C, 0x1D51E, 0x1D51F, 0x1D520, 0x1D521,
    0x1D522, 0x1D523, 0x1D524, 0x1D525, 0x1D526, 0x1D527, 0x1D528, 0x1D529,
    0x1D52A, 0x1D52B, 0x1D52C, 0x1D52D, 0x1D52E, 0x1D52F, 0x1D530, 0x1D531,
    0x1D532, 0x1D533, 0x1D534, 0x1D535, 0x1D536, 0x1D537, 0x1D538, 0x1D539,
    0x1D53B, 0x1D53C, 0x1D53D, 0x1D53E, 0x1D540, 0x1D541, 0x1D542, 0x1D543,
    0x1D544, 0x1D546, 0x1D54A, 0x1D54B, 0x1D54C, 0x1D54D, 0x1D54E, 0x1D54F,
    0x1D550, 0x1D552, 0x1D553, 0x1D554, 0x1D555, 0x1D556, 0x1D557, 0x1D558,
    0x1D559, 0x1D55A, 0x1D55B, 0x1D55C, 0x1D55D, 0x1D55E, 0x1D55F, 0x1D560,
    0x1D561, 0x1D562, 0x1D563, 0x1D564, 0x1D565, 0x1D566, 0x1D567, 0x1D568,
    0x1D569, 0x1D56A, 0x1D56B, 0x1D56C, 0x1D56D, 0x1D56E, 0x1D56F, 0x1D570,
    0x1D571, 0x1D572, 0x1D573, 0x1D574, 0x1D575, 0x1D576, 0x1D577, 0x1D578,
    0x1D579, 0x1D57A, 0x1D57B, 0x1D57C, 0x1D57D, 0x1D57E, 0x1D57F, 0x1D580,
    0x1D581, 0x1D582, 0x1D583, 0x1D584, 0x1D585, 0x1D586, 0x1D587, 0x1D588,
    0x1D589, 0x1D58A, 0x1D58B, 0x1D58C, 0x1D58D, 0x1D58E, 0x1D58F, 0x1D590,
    0x1D591, 0x1D592, 0x1D593, 0x1D594, 0x1D595, 0x1D596, 0x1D597, 0x1D598,
    0x1D599, 0x1D59A, 0x1D59B, 0x1D59C, 0x1D59D, 0x1D59E, 0x1D59F, 0x1D5A0,
    0x1D5A1, 0x1D5A2, 0x1D5A3, 0x1D5A4, 0x1D5A5, 0x1D5A6, 0x1D5A7, 0x1D5A8,
    0x1D5A9, 0x1D5AA, 0x1D5AB, 0x1D5AC, 0x1D5AD, 0x1D5AE, 0x1D5AF, 0x1D5B0,
    0x1D5B1, 0x1D5B2, 0x1D5B3, 0x1D5B4, 0x1D5B5, 0x1D5B6, 0x1D5B7, 0x1D5B8,
    0x1D5B9, 0x1D5BA, 0x1D5BB, 0x1D5BC, 0x1D5BD, 0x1D5BE, 0x1D5BF, 0x1D5C0,
    0x1D5C1, 0x1D5C2, 0x1D5C3, 0x1D5C4, 0x1D5C5, 0x1D5C6, 0x1D5C7, 0x1D5C8,
    0x1D5C9, 0x1D5CA, 0x1D5CB, 0x1D5CC, 0x1D5CD, 0x1D5CE, 0x1D5CF, 0x1D5D0,
    0x1D5D1, 0x1D5D2, 0x1D5D3, 0x1D5D4, 0x1D5D5, 0x1D5D6, 0x1D5D7, 0x1D5D8,
    0x1D5D9, 0x1D5DA, 0x1D5DB, 0x1D5DC, 0x1D5DD, 0x1D5DE, 0x1D5DF, 0x1D5E0,
    0x1D5E1, 0x1D5E2, 0x1D5E3, 0x1D5E4, 0x1D5E5, 0x1D5E6, 0x1D5E7, 0x1D5E8,
    0x1D5E9, 0x1D5EA, 0x1D5EB, 0x1D5EC, 0x1D5ED, 0x1D5EE, 0x1D5EF, 0x1D5F0,
    0x1D5F1, 0x1D5F2, 0x1D5F3, 0x1D5F4, 0x1D5F5, 0x1D5F6, 0x1D5F7, 0x1D5F8,
    0x1D5F9, 0x1D5FA, 0x1D5FB, 0x1D5FC, 0x1D5FD, 0x1D5FE, 0x1D5FF, 0x1D600,
    0x1D601, 0x1D602, 0x1D603, 0x1D604, 0x1D605, 0x1D606, 0x1D607, 0x1D608,
    0x1D609, 0x1D60A, 0x1D60B, 0x1D60C, 0x1D60D, 0x1D60E, 0x1D60F, 0x1D610,
    0x1D611, 0x1D612, 0x1D613, 0x1D614, 0x1D615, 0x1D616, 0x1D617, 0x1D618,
    0x1D619, 0x1D61A, 0x1D61B, 0x1D61C, 0x1D61D, 0x1D61E, 0x1D61F, 0x1D620,
    0x1D621, 0x1D622, 0x1D623, 0x1D624, 0x1D625, 0x1D626, 0x1D627, 0x1D628,
    0x1D629, 0x1D62A, 0x1D62B, 0x1D62C, 0x1D62D, 0x1D62E, 0x1D62F, 0x1D630,
    0x1D631, 0x1D632, 0x1D633, 0x1D634, 0x1D635, 0x1D636, 0x1D637, 0x1D638,
    0x1D639, 0x1D63A, 0x1D63B, 0x1D63C, 0x1D63D, 0x1D63E, 0x1D63F, 0x1D640,
    0x1D641, 0x1D642, 0x1D643, 0x1D644, 0x1D645, 0x1D646, 0x1D647, 0x1D648,
    0x1D649, 0x1D64A, 0x1D64B, 0x1D64C, 0x1D64D, 0x1D64E, 0x1D64F, 0x1D650,
    0x1D651, 0x1D652, 0x1D653, 0x1D654, 0x1D655, 0x1D656, 0x1D657, 0x1D658,
    0x1D659, 0x1D65A, 0x1D65B, 0x1D65C, 0x1D65D, 0x1D65E, 0x1D65F, 0x1D660,
    0x1D661, 0x1D662, 0x1D663, 0x1D664, 0x1D665, 0x1D666, 0x1D667, 0x1D668,
    0x1D669, 0x1D66A, 0x1D66B, 0x1D66C, 0x1D66D, 0x1D66E, 0x1D66F, 0x1D670,
    0x1D671, 0x1D672, 0x1D673, 0x1D674, 0x1D675, 0x1D676, 0x1D677, 0x1D678,
    0x1D679, 0x1D67A, 0x1D67B, 0x1D67C, 0x1D67D, 0x1D67E, 0x1D67F, 0x1D680,
    0x1D681, 0x1D682, 0x1D683, 0x1D684, 0x1D685, 0x1D686, 0x1D687, 0x1D688,
    0x1D689, 0x1D68A, 0x1D68B, 0x1D68C, 0x1D68D, 0x1D68E, 0x1D68F, 0x1D690,
    0x1D691, 0x1D692, 0x1D693, 0x1D694, 0x1D695, 0x1D696, 0x1D697, 0x1D698,
    0x1D699, 0x1D69A, 0x1D69B, 0x1D69C, 0x1D69D, 0x1D69E, 0x1D69F, 0x1D6A0,
    0x1D6A1, 0x1D6A2, 0x1D6A3, 0x1D6A4, 0x1D6A5, 0x1D6A8, 0x1D6A9, 0x1D6AA,
    0x1D6AB, 0x1D6AC, 0x1D6AD, 0x1D6AE, 0x1D6AF, 0x1D6B0, 0x1D6B1, 0x1D6B2,
    0x1D6B3, 0x1D6B4, 0x1D6B5, 0x1D6B6, 0x1D6B7, 0x1D6B8, 0x1D6B9, 0x1D6BA,
    0x1D6BB, 0x1D6BC, 0x1D6BD, 0x1D6BE, 0x1D6BF, 0x1D6C0, 0x1D6C1, 0x1D6C2,
    0x1D6C3, 0x1D6C4, 0x1D6C5, 0x1D6C6, 0x1D6C7, 0x1D6C8, 0x1D6C9, 0x1D6CA,
    0x1D6CB, 0x1D6CC, 0x1D6CD, 0x1D6CE, 0x1D6CF, 0x1D6D0, 0x1D6D1, 0x1D6D2,
    0x1D6D3, 0x1D6D4, 0x1D6D5, 0x1D6D6, 0x1D6D7, 0x1D6D8, 0x1D6D9, 0x1D6DA,
    0x1D6DB, 0x1D6DC, 0x1D6DD, 0x1D6DE, 0x1D6DF, 0x1D6E0, 0x1D6E1, 0x1D6E2,
    0x1D6E3, 0x1D6E4, 0x1D6E5, 0x1D6E6, 0x1D6E7, 0x1D6E8, 0x1D6E9, 0x1D6EA,
    0x1D6EB, 0x1D6EC, 0x1D6ED, 0x1D6EE, 0x1D6EF, 0x1D6F0, 0x1D6F1, 0x1D6F2,
    0x1D6F3, 0x1D6F4, 0x1D6F5, 0x1D6F6, 0x1D6F7, 0x1D6F8, 0x1D6F9, 0x1D6FA,
    0x1D6FB, 0x1D6FC, 0x1D6FD, 0x1D6FE, 0x1D6FF, 0x1D700, 0x1D701, 0x1D702,
    0x1D703, 0x1D704, 0x1D705, 0x1D706, 0x1D707, 0x1D708, 0x1D709, 0x1D70A,
    0x1D70B, 0x1D70C, 0x1D70D, 0x1D70E, 0x1D70F, 0x1D710, 0x1D711, 0x1D712,
    0x1D713, 0x1D714, 0x1D715, 0x1D716, 0x1D717, 0x1D718, 0x1D719, 0x1D71A,
    0x1D71B, 0x1D71C, 0x1D71D, 0x1D71E, 0x1D71F, 0x1D720, 0x1D721, 0x1D722,
    0x1D723, 0x1D724, 0x1D725, 0x1D726, 0x1D727, 0x1D728, 0x1D729, 0x1D72A,
    0x1D72B, 0x1D72C, 0x1D72D, 0x1D72E, 0x1D72F, 0x1D730, 0x1D731, 0x1D732,
    0x1D733, 0x1D734, 0x1D735, 0x1D736, 0x1D737, 0x1D738, 0x1D739, 0x1D73A,
    0x1D73B, 0x1D73C, 0x1D73D, 0x1D73E, 0x1D73F, 0x1D740, 0x1D741, 0x1D742,
    0x1D743, 0x1D744, 0x1D745, 0x1D746, 0x1D747, 0x1D748, 0x1D749, 0x1D74A,
    0x1D74B, 0x1D74C, 0x1D74D, 0x1D74E, 0x1D74F, 0x1D750, 0x1D751, 0x1D752,
    0x1D753, 0x1D754, 0x1D755, 0x1D756, 0x1D757, 0x1D758, 0x1D759, 0x1D75A,
    0x1D75B, 0x1D75C, 0x1D75D, 0x1D75E, 0x1D75F, 0x1D760, 0x1D761, 0x1D762,
    0x1D763, 0x1D764, 0x1D765, 0x1D766, 0x1D767, 0x1D768, 0x1D769, 0x1D76A,
    0x1D76B, 0x1D76C, 0x1D76D, 0x1D76E, 0x1D76F, 0x1D770, 0x1D771, 0x1D772,
    0x1D773, 0x1D774, 0x1D775, 0x1D776, 0x1D777, 0x1D778, 0x1D779, 0x1D77A,
    0x1D77B, 0x1D77C, 0x1D77D, 0x1D77E, 0x1D77F, 0x1D780, 0x1D781, 0x1D782,
    0x1D783, 0x1D784, 0x1D785, 0x1D786, 0x1D787, 0x1D788, 0x1D789, 0x1D78A,
    0x1D78B, 0x1D78C, 0x1D78D, 0x1D78E, 0x1D78F, 0x1D790, 0x1D791, 0x1D792,
    0x1D793, 0x1D794, 0x1D795, 0x1D796, 0x1D797, 0x1D798, 0x1D799, 0x1D79A,
    0x1D79B, 0x1D79C, 0x1D79D, 0x1D79E, 0x1D79F, 0x1D7A0, 0x1D7A1, 0x1D7A2,
    0x1D7A3, 0x1D7A4, 0x1D7A5, 0x1D7A6, 0x1D7A7, 0x1D7A8, 0x1D7A9, 0x1D7AA,
    0x1D7AB, 0x1D7AC, 0x1D7AD, 0x1D7AE, 0x1D7AF, 0x1D7B0, 0x1D7B1, 0x1D7B2,
    0x1D7B3, 0x1D7B4, 0x1D7B5, 0x1D7B6, 0x1D7B7, 0x1D7B8, 0x1D7B9, 0x1D7BA,
    0x1D7BB, 0x1D7BC, 0x1D7BD, 0x1D7BE, 0x1D7BF, 0x1D7C0, 0x1D7C1, 0x1D7C2,
    0x1D7C3, 0x1D7C4, 0x1D7C5, 0x1D7C6, 0x1D7C7, 0x1D7C8, 0x1D7C9, 0x1D7CA,
    0x1D7CB, 0x1D7CE, 0x1D7CF, 0x1D7D0, 0x1D7D1, 0x1D7D2, 0x1D7D3, 0x1D7D4,
    0x1D7D5, 0x1D7D6, 0x1D7D7, 0x1D7D8, 0x1D7D9, 0x1D7DA, 0x1D7DB, 0x1D7DC,
    0x1D7DD, 0x1D7DE, 0x1D7DF, 0x1D7E0, 0x1D7E1, 0x1D7E2, 0x1D7E3, 0x1D7E4,
    0x1D7E5, 0x1D7E6, 0x1D7E7, 0x1D7E8, 0x1D7E9, 0x1D7EA, 0x1D7EB, 0x1D7EC,
    0x1D7ED, 0x1D7EE, 0x1D7EF, 0x1D7F0, 0x1D7F1, 0x1D7F2, 0x1D7F3, 0x1D7F4,
    0x1D7F5, 0x1D7F6, 0x1D7F7, 0x1D7F8, 0x1D7F9, 0x1D7FA, 0x1D7FB, 0x1D7FC,
    0x1D7FD, 0x1D7FE, 0x1D7FF, 0x1EE00, 0x1EE01, 0x1EE02, 0x1EE03, 0x1EE05,
    0x1EE06, 0x1EE07, 0x1EE08, 0x1EE09, 0x1EE0A, 0x1EE0B, 0x1EE0C, 0x1EE0D,
    0x1EE0E, 0x1EE0F, 0x1EE10, 0x1EE11, 0x1EE12, 0x1EE13, 0x1EE14, 0x1EE15,
    0x1EE16, 0x1EE17, 0x1EE18, 0x1EE19, 0x1EE1A, 0x1EE1B, 0x1EE1C, 0x1EE1D,
    0x1EE1E, 0x1EE1F, 0x1EE21, 0x1EE22, 0x1EE24, 0x1EE27, 0x1EE29, 0x1EE2A,
    0x1EE2B, 0x1EE2C, 0x1EE2D, 0x1EE2E, 0x1EE2F, 0x1EE30, 0x1EE31, 0x1EE32,
    0x1EE34, 0x1EE35, 0x1EE36, 0x1EE37, 0x1EE39, 0x1EE3B, 0x1EE42, 0x1EE47,
    0x1EE49, 0x1EE4B, 0x1EE4D, 0x1EE4E, 0x1EE4F, 0x1EE51, 0x1EE52, 0x1EE54,
    0x1EE57, 0x1EE59, 0x1EE5B, 0x1EE5D, 0x1EE5F, 0x1EE61, 0x1EE62, 0x1EE64,
    0x1EE67, 0x1EE68, 0x1EE69, 0x1EE6A, 0x1EE6C, 0x1EE6D, 0x1EE6E, 0x1EE6F,
    0x1EE70, 0x1EE71, 0x1EE72, 0x1EE74, 0x1EE75, 0x1EE76, 0x1EE77, 0x1EE79,
    0x1EE7A, 0x1EE7B, 0x1EE7C, 0x1EE7E, 0x1EE80, 0x1EE81, 0x1EE82, 0x1EE83,
    0x1EE84, 0x1EE85, 0x1EE86, 0x1EE87, 0x1EE88, 0x1EE89, 0x1EE8B, 0x1EE8C,
    0x1EE8D, 0x1EE8E, 0x1EE8F, 0x1EE90, 0x1EE91, 0x1EE92, 0x1EE93, 0x1EE94,
    0x1EE95, 0x1EE96, 0x1EE97, 0x1EE98, 0x1EE99, 0x1EE9A, 0x1EE9B, 0x1EEA1,
    0x1EEA2, 0x1EEA3, 0x1EEA5, 0x1EEA6, 0x1EEA7, 0x1EEA8, 0x1EEA9, 0x1EEAB,
    0x1EEAC, 0x1EEAD, 0x1EEAE, 0x1EEAF, 0x1EEB0, 0x1EEB1, 0x1EEB2, 0x1EEB3,
    0x1EEB4, 0x1EEB5, 0x1EEB6, 0x1EEB7, 0x1EEB8, 0x1EEB9, 0x1EEBA, 0x1EEBB,
    0x1F100, 0x1F101, 0x1F102, 0x1F103, 0x1F104, 0x1F105, 0x1F106, 0x1F107,
    0x1F108, 0x1F109, 0x1F10A, 0x1F110, 0x1F111, 0x1F112, 0x1F113, 0x1F114,
    0x1F115, 0x1F116, 0x1F117, 0x1F118, 0x1F119, 0x1F11A, 0x1F11B, 0x1F11C,
    0x1F11D, 0x1F11E, 0x1F11F, 0x1F120, 0x1F121, 0x1F122, 0x1F123, 0x1F124,
    0x1F125, 0x1F126, 0x1F127, 0x1F128, 0x1F129, 0x1F12A, 0x1F12B, 0x1F12C,
    0x1F12D, 0x1F12E, 0x1F130, 0x1F131, 0x1F132, 0x1F133, 0x1F134, 0x1F135,
    0x1F136, 0x1F137, 0x1F138, 0x1F139, 0x1F13A, 0x1F13B, 0x1F13C, 0x1F13D,
    0x1F13E, 0x1F13F, 0x1F140, 0x1F141, 0x1F142, 0x1F143, 0x1F144, 0x1F145,
    0x1F146, 0x1F147, 0x1F148, 0x1F149, 0x1F14A, 0x1F14B, 0x1F14C, 0x1F14D,
    0x1F14E, 0x1F14F, 0x1F16A, 0x1F16B, 0x1F16C, 0x1F190, 0x1F200, 0x1F201,
    0x1F202, 0x1F210, 0x1F211, 0x1F212, 0x1F213, 0x1F214, 0x1F215, 0x1F216,
    0x1F217, 0x1F218, 0x1F219, 0x1F21A, 0x1F21B, 0x1F21C, 0x1F21D, 0x1F21E,
    0x1F21F, 0x1F220, 0x1F221, 0x1F222, 0x1F223, 0x1F224, 0x1F225, 0x1F226,
    0x1F227, 0x1F228, 0x1F229, 0x1F22A, 0x1F22B, 0x1F22C, 0x1F22D, 0x1F22E,
    0x1F22F, 0x1F230, 0x1F231, 0x1F232, 0x1F233, 0x1F234, 0x1F235, 0x1F236,
    0x1F237, 0x1F238, 0x1F239, 0x1F23A, 0x1F23B, 0x1F240, 0x1F241, 0x1F242,
    0x1F243, 0x1F244, 0x1F245, 0x1F246, 0x1F247, 0x1F248, 0x1F250, 0x1F251,
    0x1FBF0, 0x1FBF1, 0x1FBF2, 0x1FBF3, 0x1FBF4, 0x1FBF5, 0x1FBF6, 0x1FBF7,
    0x1FBF8, 0x1FBF9, 0x2F800, 0x2F801, 0x2F802, 0x2F803, 0x2F804, 0x2F805,
    0x2F806, 0x2F807, 0x2F808, 0x2F809, 0x2F80A, 0x2F80B, 0x2F80C, 0x2F80D,
    0x2F80E, 0x2F80F, 0x2F810, 0x2F811, 0x2F812, 0x2F813, 0x2F814, 0x2F815,
    0x2F816, 0x2F817, 0x2F818, 0x2F819, 0x2F81A, 0x2F81B, 0x2F81C, 0x2F81D,
    0x2F81E, 0x2F81F, 0x2F820, 0x2F821, 0x2F822, 0x2F823, 0x2F824, 0x2F825,
    0x2F826, 0x2F827, 0x2F828, 0x2F829, 0x2F82A, 0x2F82B, 0x2F82C, 0x2F82D,
    0x2F82E, 0x2F82F, 0x2F830, 0x2F831, 0x2F832, 0x2F833, 0x2F834, 0x2F835,
    0x2F836, 0x2F837, 0x2F838, 0x2F839, 0x2F83A, 0x2F83B, 0x2F83C, 0x2F83D,
    0x2F83E, 0x2F83F, 0x2F840, 0x2F841, 0x2F842, 0x2F843, 0x2F844, 0x2F845,
    0x2F846, 0x2F847, 0x2F848, 0x2F849, 0x2F84A, 0x2F84B, 0x2F84C, 0x2F84D,
    0x2F84E, 0x2F84F, 0x2F850, 0x2F851, 0x2F852, 0x2F853, 0x2F854, 0x2F855,
    0x2F856, 0x2F857, 0x2F858, 0x2F859, 0x2F85A, 0x2F85B, 0x2F85C, 0x2F85D,
    0x2F85E, 0x2F85F, 0x2F860, 0x2F861, 0x2F862, 0x2F863, 0x2F864, 0x2F865,
    0x2F866, 0x2F867, 0x2F868, 0x2F869, 0x2F86A, 0x2F86B, 0x2F86C, 0x2F86D,
    0x2F86E, 0x2F86F, 0x2F870, 0x2F871, 0x2F872, 0x2F873, 0x2F874, 0x2F875,
    0x2F876, 0x2F877, 0x2F878, 0x2F879, 0x2F87A, 0x2F87B, 0x2F87C, 0x2F87D,
    0x2F87E, 0x2F87F, 0x2F880, 0x2F881, 0x2F882, 0x2F883, 0x2F884, 0x2F885,
    0x2F886, 0x2F887, 0x2F888, 0x2F889, 0x2F88A, 0x2F88B, 0x2F88C, 0x2F88D,
    0x2F88E, 0x2F88F, 0x2F890, 0x2F891, 0x2F892, 0x2F893, 0x2F894, 0x2F895,
    0x2F896, 0x2F897, 0x2F898, 0x2F899, 0x2F89A, 0x2F89B, 0x2F89C, 0x2F89D,
    0x2F89E, 0x2F89F, 0x2F8A0, 0x2F8A1, 0x2F8A2, 0x2F8A3, 0x2F8A4, 0x2F8A5,
    0x2F8A6, 0x2F8A7, 0x2F8A8, 0x2F8A9, 0x2F8AA, 0x2F8AB, 0x2F8AC, 0x2F8AD,
    0x2F8AE, 0x2F8AF, 0x2F8B0, 0x2F8B1, 0x2F8B2, 0x2F8B3, 0x2F8B4, 0x2F8B5,
    0x2F8B6, 0x2F8B7, 0x2F8B8, 0x2F8B9, 0x2F8BA, 0x2F8BB, 0x2F8BC, 0x2F8BD,
    0x2F8BE, 0x2F8BF, 0x2F8C0, 0x2F8C1, 0x2F8C2, 0x2F8C3, 0x2F8C4, 0x2F8C5,
    0x2F8C6, 0x2F8C7, 0x2F8C8, 0x2F8C9, 0x2F8CA, 0x2F8CB, 0x2F8CC, 0x2F8CD,
    0x2F8CE, 0x2F8CF, 0x2F8D0, 0x2F8D1, 0x2F8D2, 0x2F8D3, 0x2F8D4, 0x2F8D5,
    0x2F8D6, 0x2F8D7, 0x2F8D8, 0x2F8D9, 0x2F8DA, 0x2F8DB, 0x2F8DC, 0x2F8DD,
    0x2F8DE, 0x2F8DF, 0x2F8E0, 0x2F8E1, 0x2F8E2, 0x2F8E3, 0x2F8E4, 0x2F8E5,
    0x2F8E6, 0x2F8E7, 0x2F8E8, 0x2F8E9, 0x2F8EA, 0x2F8EB, 0x2F8EC, 0x2F8ED,
    0x2F8EE, 0x2F8EF, 0x2F8F0, 0x2F8F1, 0x2F8F2, 0x2F8F3, 0x2F8F4, 0x2F8F5,
    0x2F8F6, 0x2F8F7, 0x2F8F8, 0x2F8F9, 0x2F8FA, 0x2F8FB, 0x2F8FC, 0x2F8FD,
    0x2F8FE, 0x2F8FF, 0x2F900, 0x2F901, 0x2F902, 0x2F903, 0x2F904, 0x2F905,
    0x2F906, 0x2F907, 0x2F908, 0x2F909, 0x2F90A, 0x2F90B, 0x2F90C, 0x2F90D,
    0x2F90E, 0x2F90F, 0x2F910, 0x2F911, 0x2F912, 0x2F913, 0x2F914, 0x2F915,
    0x2F916, 0x2F917, 0x2F918, 0x2F919, 0x2F91A, 0x2F91B, 0x2F91C, 0x2F91D,
    0x2F91E, 0x2F91F, 0x2F920, 0x2F921, 0x2F922, 0x2F923, 0x2F924, 0x2F925,
    0x2F926, 0x2F927, 0x2F928, 0x2F929, 0x2F92A, 0x2F92B, 0x2F92C, 0x2F92D,
    0x2F92E, 0x2F92F, 0x2F930, 0x2F931, 0x2F932, 0x2F933, 0x2F934, 0x2F935,
    0x2F936, 0x2F937, 0x2F938, 0x2F939, 0x2F93A, 0x2F93B, 0x2F93C, 0x2F93D,
    0x2F93E, 0x2F93F, 0x2F940, 0x2F941, 0x2F942, 0x2F943, 0x2F944, 0x2F945,
    0x2F946, 0x2F947, 0x2F948, 0x2F949, 0x2F94A, 0x2F94B, 0x2F94C, 0x2F94D,
    0x2F94E, 0x2F94F, 0x2F950, 0x2F951, 0x2F952, 0x2F953, 0x2F954, 0x2F955,
    0x2F956, 0x2F957, 0x2F958, 0x2F959, 0x2F95A, 0x2F95B, 0x2F95C, 0x2F95D,
    0x2F95E, 0x2F95F, 0x2F960, 0x2F961, 0x2F962, 0x2F963, 0x2F964, 0x2F965,
    0x2F966, 0x2F967, 0x2F968, 0x2F969, 0x2F96A, 0x2F96B, 0x2F96C, 0x2F96D,
    0x2F96E, 0x2F96F, 0x2F970, 0x2F971, 0x2F972, 0x2F973, 0x2F974, 0x2F975,
    0x2F976, 0x2F977, 0x2F978, 0x2F979, 0x2F97A, 0x2F97B, 0x2F97C, 0x2F97D,
    0x2F97E, 0x2F97F, 0x2F980, 0x2F981, 0x2F982, 0x2F983, 0x2F984, 0x2F985,
    0x2F986, 0x2F987, 0x2F988, 0x2F989, 0x2F98A, 0x2F98B, 0x2F98C, 0x2F98D,
    0x2F98E, 0x2F98F, 0x2F990, 0x2F991, 0x2F992, 0x2F993, 0x2F994, 0x2F995,
    0x2F996, 0x2F997, 0x2F998, 0x2F999, 0x2F99A, 0x2F99B, 0x2F99C, 0x2F99D,
    0x2F99E, 0x2F99F, 0x2F9A0, 0x2F9A1, 0x2F9A2, 0x2F9A3, 0x2F9A4, 0x2F9A5,
    0x2F9A6, 0x2F9A7, 0x2F9A8, 0x2F9A9, 0x2F9AA, 0x2F9AB, 0x2F9AC, 0x2F9AD,
    0x2F9AE, 0x2F9AF, 0x2F9B0, 0x2F9B1, 0x2F9B2, 0x2F9B3, 0x2F9B4, 0x2F9B5,
    0x2F9B6, 0x2F9B7, 0x2F9B8, 0x2F9B9, 0x2F9BA, 0x2F9BB, 0x2F9BC, 0x2F9BD,
    0x2F9BE, 0x2F9BF, 0x2F9C0, 0x2F9C1, 0x2F9C2, 0x2F9C3, 0x2F9C4, 0x2F9C5,
    0x2F9C6, 0x2F9C7, 0x2F9C8, 0x2F9C9, 0x2F9CA, 0x2F9CB, 0x2F9CC, 0x2F9CD,
    0x2F9CE, 0x2F9CF, 0x2F9D0, 0x2F9D1, 0x2F9D2, 0x2F9D3, 0x2F9D4, 0x2F9D5,
    0x2F9D6, 0x2F9D7, 0x2F9D8, 0x2F9D9, 0x2F9DA, 0x2F9DB, 0x2F9DC, 0x2F9DD,
    0x2F9DE, 0x2F9DF, 0x2F9E0, 0x2F9E1, 0x2F9E2, 0x2F9E3, 0x2F9E4, 0x2F9E5,
    0x2F9E6, 0x2F9E7, 0x2F9E8, 0x2F9E9, 0x2F9EA, 0x2F9EB, 0x2F9EC, 0x2F9ED,
    0x2F9EE, 0x2F9EF, 0x2F9F0, 0x2F9F1, 0x2F9F2, 0x2F9F3, 0x2F9F4, 0x2F9F5,
    0x2F9F6, 0x2F9F7, 0x2F9F8, 0x2F9F9, 0x2F9FA, 0x2F9FB, 0x2F9FC, 0x2F9FD,
    0x2F9FE, 0x2F9FF, 0x2FA00, 0x2FA01, 0x2FA02, 0x2FA03, 0x2FA04, 0x2FA05,
    0x2FA06, 0x2FA07, 0x2FA08, 0x2FA09, 0x2FA0A, 0x2FA0B, 0x2FA0C, 0x2FA0D,
    0x2FA0E, 0x2FA0F, 0x2FA10, 0x2FA11, 0x2FA12, 0x2FA13, 0x2FA14, 0x2FA15,
    0x2FA16, 0x2FA17, 0x2FA18, 0x2FA19, 0x2FA1A, 0x2FA1B, 0x2FA1C, 0x2FA1D
};

const DecompositionMappingTag DECOMPOSITION_MAPPING_TAG[] = {
    NOBREAK, COMPAT, SUPER, COMPAT, SUPER,
    SUPER, COMPAT, COMPAT, COMPAT, SUPER,
    SUPER, FRACTION, FRACTION, FRACTION, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, COMPAT, COMPAT, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, COMPAT,
    COMPAT, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, COMPAT, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    COMPAT, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, COMPAT, COMPAT, COMPAT,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, SUPER,
    SUPER, SUPER, SUPER, SUPER, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, COMPAT,
    CANONICAL, COMPAT, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, COMPAT,
    COMPAT, COMPAT, CANONICAL, CANONICAL, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, COMPAT,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    COMPAT, COMPAT, COMPAT, COMPAT, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, COMPAT, COMPAT, COMPAT, COMPAT,
    NOBREAK, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    COMPAT, CANONICAL, COMPAT, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, SUPER, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUB,
    SUB, SUB, SUB, SUB, SUB,
    SUB, SUB, SUB, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    COMPAT, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, COMPAT, CANONICAL, COMPAT, COMPAT,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, COMPAT,
    CANONICAL, CANONICAL, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, NOBREAK, COMPAT, COMPAT,
    COMPAT, NOBREAK, COMPAT, COMPAT, COMPAT,
    COMPAT, NOBREAK, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUB, SUB, SUB,
    SUB, SUB, SUB, SUB, SUB,
    SUB, SUB, SUB, SUB, SUB,
    SUB, SUB, SUB, SUB, SUB,
    SUB, SUB, SUB, SUB, SUB,
    SUB, SUB, SUB, SUB, SUB,
    COMPAT, COMPAT, COMPAT, FONT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    COMPAT, FONT, FONT, FONT, FONT,
    FONT, SUPER, COMPAT, SUPER, FONT,
    CANONICAL, FONT, CANONICAL, CANONICAL, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, COMPAT, COMPAT, COMPAT, COMPAT,
    FONT, COMPAT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FRACTION, FRACTION, FRACTION,
    FRACTION, FRACTION, FRACTION, FRACTION, FRACTION,
    FRACTION, FRACTION, FRACTION, FRACTION, FRACTION,
    FRACTION, FRACTION, FRACTION, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    FRACTION, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, COMPAT, COMPAT, COMPAT,
    COMPAT, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    COMPAT, COMPAT, COMPAT, COMPAT, CANONICAL,
    SUB, SUPER, SUPER, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, WIDE,
    COMPAT, COMPAT, COMPAT, COMPAT, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    COMPAT, COMPAT, CANONICAL, VERTICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    VERTICAL, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    SQUARE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, SQUARE, SQUARE,
    SQUARE, SQUARE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    CIRCLE, CIRCLE, CIRCLE, CIRCLE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    SQUARE, SUPER, SUPER, SUPER, SUPER,
    SUPER, SUPER, SUPER, SUPER, SUPER,
    SUPER, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, CANONICAL, CANONICAL,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, COMPAT, ISOLATED, FINAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, FINAL, INITIAL, MEDIAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, FINAL, INITIAL, MEDIAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    ISOLATED, FINAL, ISOLATED, FINAL, ISOLATED,
    FINAL, ISOLATED, FINAL, ISOLATED, FINAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, FINAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, ISOLATED,
    FINAL, ISOLATED, FINAL, INITIAL, MEDIAL,
    ISOLATED, FINAL, ISOLATED, FINAL, ISOLATED,
    FINAL, ISOLATED, ISOLATED, FINAL, ISOLATED,
    FINAL, ISOLATED, FINAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, ISOLATED, FINAL, ISOLATED, FINAL,
    ISOLATED, FINAL, ISOLATED, FINAL, ISOLATED,
    FINAL, ISOLATED, FINAL, INITIAL, ISOLATED,
    FINAL, INITIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, MEDIAL,
    MEDIAL, MEDIAL, MEDIAL, MEDIAL, MEDIAL,
    MEDIAL, MEDIAL, MEDIAL, MEDIAL, MEDIAL,
    MEDIAL, MEDIAL, MEDIAL, MEDIAL, MEDIAL,
    MEDIAL, MEDIAL, MEDIAL, MEDIAL, MEDIAL,
    MEDIAL, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, MEDIAL,
    MEDIAL, MEDIAL, MEDIAL, MEDIAL, MEDIAL,
    MEDIAL, MEDIAL, FINAL, ISOLATED, INITIAL,
    FINAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, FINAL, INITIAL, FINAL,
    FINAL, INITIAL, INITIAL, FINAL, FINAL,
    INITIAL, INITIAL, FINAL, INITIAL, FINAL,
    INITIAL, FINAL, FINAL, INITIAL, FINAL,
    FINAL, INITIAL, FINAL, INITIAL, FINAL,
    FINAL, INITIAL, FINAL, INITIAL, INITIAL,
    FINAL, FINAL, FINAL, INITIAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, INITIAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    INITIAL, FINAL, FINAL, INITIAL, FINAL,
    INITIAL, INITIAL, INITIAL, FINAL, INITIAL,
    INITIAL, INITIAL, INITIAL, INITIAL, INITIAL,
    INITIAL, INITIAL, FINAL, FINAL, INITIAL,
    FINAL, FINAL, FINAL, FINAL, INITIAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, INITIAL, INITIAL, FINAL,
    FINAL, INITIAL, FINAL, INITIAL, FINAL,
    FINAL, FINAL, FINAL, FINAL, FINAL,
    FINAL, FINAL, INITIAL, INITIAL, INITIAL,
    FINAL, FINAL, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    ISOLATED, ISOLATED, ISOLATED, ISOLATED, ISOLATED,
    VERTICAL, VERTICAL, VERTICAL, VERTICAL, VERTICAL,
    VERTICAL, VERTICAL, VERTICAL, VERTICAL, VERTICAL,
    VERTICAL, VERTICAL, VERTICAL, VERTICAL, VERTICAL,
    VERTICAL, VERTICAL, VERTICAL, VERTICAL, VERTICAL,
    VERTICAL, VERTICAL, VERTICAL, VERTICAL, VERTICAL,
    VERTICAL, VERTICAL, VERTICAL, VERTICAL, VERTICAL,
    VERTICAL, VERTICAL, VERTICAL, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    SMALL, SMALL, SMALL, SMALL, SMALL,
    SMALL, SMALL, SMALL, SMALL, SMALL,
    SMALL, SMALL, SMALL, SMALL, SMALL,
    SMALL, SMALL, SMALL, SMALL, SMALL,
    SMALL, SMALL, SMALL, SMALL, SMALL,
    SMALL, ISOLATED, MEDIAL, ISOLATED, ISOLATED,
    ISOLATED, MEDIAL, ISOLATED, MEDIAL, ISOLATED,
    MEDIAL, ISOLATED, MEDIAL, ISOLATED, MEDIAL,
    ISOLATED, ISOLATED, FINAL, ISOLATED, FINAL,
    ISOLATED, FINAL, ISOLATED, FINAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, ISOLATED, FINAL, INITIAL, MEDIAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, FINAL, ISOLATED, FINAL,
    ISOLATED, FINAL, ISOLATED, FINAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, FINAL, INITIAL, MEDIAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, FINAL, INITIAL, MEDIAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, INITIAL, MEDIAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, INITIAL,
    MEDIAL, ISOLATED, FINAL, INITIAL, MEDIAL,
    ISOLATED, FINAL, INITIAL, MEDIAL, ISOLATED,
    FINAL, ISOLATED, FINAL, ISOLATED, FINAL,
    INITIAL, MEDIAL, ISOLATED, FINAL, ISOLATED,
    FINAL, ISOLATED, FINAL, ISOLATED, FINAL,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, WIDE, WIDE,
    WIDE, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    NARROW, WIDE, WIDE, WIDE, WIDE,
    WIDE, WIDE, WIDE, NARROW, NARROW,
    NARROW, NARROW, NARROW, NARROW, NARROW,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, CIRCLE, CIRCLE, CIRCLE, CIRCLE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SUPER, SUPER, SUPER,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, SQUARE, SQUARE,
    SQUARE, SQUARE, SQUARE, COMPAT, COMPAT,
    COMPAT, COMPAT, COMPAT, COMPAT, COMPAT,
    COMPAT, COMPAT, CIRCLE, CIRCLE, FONT,
    FONT, FONT, FONT, FONT, FONT,
    FONT, FONT, FONT, FONT, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL, CANONICAL, CANONICAL, CANONICAL, CANONICAL,
    CANONICAL
};

const int32_t DECOMPOSITION_MAPPING_OFFSET[] = {
    0, 1, 3, 4, 6, 7, 8, 10, 11, 13,
    14, 15, 18, 21, 24, 26, 28, 30, 32, 34,
    36, 38, 40, 42, 44, 46, 48, 50, 52, 54,
    56, 58, 60, 62, 64, 66, 68, 70, 72, 74,
    76, 78, 80, 82, 84, 86, 88, 90, 92, 94,
    96, 98, 100, 102, 104, 106, 108, 110, 112, 114,
    116, 118, 120, 122, 124, 126, 128, 130, 132, 134,
    136, 138, 140, 142, 144, 146, 148, 150, 152, 154,
    156, 158, 160, 162, 164, 166, 168, 170, 172, 174,
    176, 178, 180, 182, 184, 186, 188, 190, 192, 194,
    196, 198, 200, 202, 204, 206, 208, 210, 212, 214,
    216, 218, 220, 222, 224, 226, 228, 230, 232, 234,
    236, 238, 240, 242, 244, 246, 248, 250, 252, 254,
    256, 258, 260, 262, 264, 266, 268, 270, 272, 274,
    276, 278, 280, 282, 284, 286, 288, 290, 292, 294,
    296, 298, 300, 302, 304, 306, 308, 310, 312, 314,
    316, 318, 320, 322, 324, 326, 328, 330, 332, 334,
    336, 338, 340, 342, 344, 346, 348, 350, 352, 354,
    356, 357, 359, 361, 363, 365, 367, 369, 371, 373,
    375, 377, 379, 381, 383, 385, 387, 389, 391, 393,
    395, 397, 399, 401, 403, 405, 407, 409, 411, 413,
    415, 417, 419, 421, 423, 425, 427, 429, 431, 433,
    435, 437, 439, 441, 443, 445, 447, 449, 451, 453,
    455, 457, 459, 461, 463, 465, 467, 469, 471, 473,
    475, 477, 479, 481, 483, 485, 487, 489, 491, 493,
    495, 497, 499, 501, 503, 505, 507, 509, 511, 513,
    515, 517, 519, 521, 523, 525, 527, 529, 531, 533,
    535, 537, 539, 541, 543, 545, 547, 549, 551, 553,
    555, 557, 559, 561, 563, 564, 565, 566, 567, 568,
    569, 570, 571, 572, 574, 576, 578, 580, 582, 584,
    585, 586, 587, 588, 589, 590, 591, 592, 594, 595,
    597, 598, 600, 602, 604, 605, 607, 609, 611, 613,
    615, 617, 619, 621, 623, 625, 627, 629, 631, 633,
    635, 637, 639, 641, 643, 644, 645, 646, 648, 650,
    651, 652, 653, 654, 655, 656, 657, 658, 660, 662,
    664, 666, 668, 670, 672, 674, 676, 678, 680, 682,
    684, 686, 688, 690, 692, 694, 696, 698, 700, 702,
    704, 706, 708, 710, 712, 714, 716, 718, 720, 722,
    724, 726, 728, 730, 732, 734, 736, 738, 740, 742,
    744, 746, 748, 750, 752, 754, 756, 758, 760, 762,
    764, 766, 768, 770, 772, 774, 776, 778, 780, 782,
    784, 786, 788, 790, 792, 794, 796, 798, 800, 802,
    804, 806, 808, 810, 812, 814, 816, 818, 820, 822,
    824, 826, 828, 830, 832, 834, 836, 838, 840, 842,
    844, 846, 848, 850, 852, 854, 856, 858, 860, 862,
    864, 866, 868, 870, 872, 874, 876, 878, 880, 882,
    884, 885, 887, 889, 891, 893, 895, 897, 899, 901,
    903, 905, 907, 909, 911, 913, 915, 917, 919, 921,
    923, 925, 926, 928, 930, 932, 934, 936, 938, 940,
    942, 944, 946, 948, 949, 950, 951, 952, 953, 954,
    955, 956, 957, 958, 959, 960, 961, 962, 963, 964,
    965, 966, 967, 968, 969, 970, 971, 972, 973, 974,
    975, 976, 977, 978, 979, 980, 981, 982, 983, 984,
    985, 986, 987, 988, 989, 990, 991, 992, 993, 994,
    995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004,
    1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014,
    1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024,
    1025, 1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034,
    1035, 1036, 1037, 1038, 1039, 1040, 1041, 1042, 1043, 1044,
    1045, 1046, 1048, 1050, 1052, 1054, 1056, 1058, 1060, 1062,
    1064, 1066, 1068, 1070, 1072, 1074, 1076, 1078, 1080, 1082,
    1084, 1086, 1088, 1090, 1092, 1094, 1096, 1098, 1100, 1102,
    1104, 1106, 1108, 1110, 1112, 1114, 1116, 1118, 1120, 1122,
    1124, 1126, 1128, 1130, 1132, 1134, 1136, 1138, 1140, 1142,
    1144, 1146, 1148, 1150, 1152, 1154, 1156, 1158, 1160, 1162,
    1164, 1166, 1168, 1170, 1172, 1174, 1176, 1178, 1180, 1182,
    1184, 1186, 1188, 1190, 1192, 1194, 1196, 1198, 1200, 1202,
    1204, 1206, 1208, 1210, 1212, 1214, 1216, 1218, 1220, 1222,
    1224, 1226, 1228, 1230, 1232, 1234, 1236, 1238, 1240, 1242,
    1244, 1246, 1248, 1250, 1252, 1254, 1256, 1258, 1260, 1262,
    1264, 1266, 1268, 1270, 1272, 1274, 1276, 1278, 1280, 1282,
    1284, 1286, 1288, 1290, 1292, 1294, 1296, 1298, 1300, 1302,
    1304, 1306, 1308, 1310, 1312, 1314, 1316, 1318, 1320, 1322,
    1324, 1326, 1328, 1330, 1332, 1334, 1336, 1338, 1340, 1342,
    1344, 1346, 1348, 1350, 1352, 1354, 1356, 1358, 1360, 1362,
    1364, 1366, 1368, 1370, 1372, 1374, 1376, 1378, 1380, 1382,
    1384, 1386, 1388, 1390, 1392, 1394, 1396, 1398, 1400, 1402,
    1404, 1406, 1408, 1410, 1412, 1414, 1416, 1418, 1420, 1422,
    1424, 1426, 1428, 1430, 1432, 1434, 1436, 1438, 1440, 1442,
    1444, 1446, 1448, 1450, 1452, 1454, 1456, 1458, 1460, 1462,
    1464, 1466, 1468, 1470, 1472, 1474, 1476, 1478, 1480, 1482,
    1484, 1486, 1488, 1490, 1492, 1494, 1496, 1498, 1500, 1502,
    1504, 1506, 1508, 1510, 1512, 1514, 1516, 1518, 1520, 1522,
    1524, 1526, 1528, 1530, 1532, 1534, 1536, 1538, 1540, 1542,
    1544, 1546, 1548, 1550, 1552, 1554, 1556, 1558, 1560, 1562,
    1564, 1566, 1568, 1570, 1572, 1574, 1576, 1578, 1580, 1582,
    1584, 1586, 1588, 1590, 1592, 1594, 1596, 1598, 1600, 1602,
    1604, 1606, 1608, 1610, 1612, 1614, 1616, 1618, 1620, 1622,
    1624, 1626, 1628, 1630, 1632, 1634, 1636, 1638, 1640, 1642,
    1644, 1646, 1648, 1650, 1652, 1654, 1656, 1658, 1660, 1662,
    1664, 1666, 1668, 1670, 1672, 1674, 1676, 1678, 1680, 1682,
    1684, 1686, 1688, 1690, 1692, 1694, 1696, 1698, 1700, 1702,
    1704, 1706, 1708, 1710, 1712, 1714, 1716, 1718, 1720, 1722,
    1724, 1726, 1728, 1730, 1732, 1734, 1736, 1738, 1740, 1741,
    1743, 1744, 1746, 1747, 1749, 1750, 1752, 1753, 1755, 1756,
    1758, 1759, 1761, 1763, 1765, 1767, 1769, 1771, 1773, 1775,
    1777, 1779, 1781, 1783, 1785, 1787, 1789, 1791, 1793, 1795,
    1797, 1799, 1801, 1803, 1805, 1807, 1809, 1811, 1813, 1815,
    1817, 1819, 1821, 1823, 1825, 1827, 1829, 1831, 1833, 1835,
    1837, 1839, 1841, 1843, 1845, 1847, 1849, 1851, 1853, 1855,
    1857, 1859, 1861, 1863, 1865, 1867, 1869, 1871, 1873, 1875,
    1876, 1878, 1880, 1881, 1883, 1885, 1887, 1889, 1891, 1893,
    1895, 1897, 1899, 1900, 1902, 1903, 1905, 1907, 1909, 1911,
    1913, 1915, 1917, 1918, 1920, 1922, 1924, 1926, 1928, 1929,
    1931, 1933, 1935, 1937, 1939, 1941, 1942, 1944, 1946, 1948,
    1950, 1952, 1954, 1956, 1957, 1959, 1961, 1962, 1963, 1965,
    1967, 1969, 1971, 1973, 1975, 1976, 1978, 1979, 1981, 1982,
    1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993,
    1994, 1995, 1996, 1998, 1999, 2001, 2004, 2005, 2007, 2010,
    2012, 2015, 2017, 2019, 2021, 2023, 2025, 2029, 2030, 2031,
    2032, 2033, 2034, 2035, 2036, 2037, 2038, 2039, 2040, 2041,
    2042, 2043, 2044, 2045, 2046, 2047, 2048, 2049, 2050, 2051,
    2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059, 2060, 2061,
    2062, 2063, 2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071,
    2072, 2074, 2077, 2080, 2081, 2083, 2086, 2089, 2090, 2092,
    2093, 2094, 2095, 2096, 2097, 2098, 2099, 2100, 2101, 2102,
    2103, 2105, 2106, 2107, 2108, 2109, 2110, 2112, 2115, 2117,
    2118, 2119, 2120, 2121, 2122, 2123, 2124, 2125, 2126, 2127,
    2128, 2129, 2130, 2131, 2132, 2133, 2134, 2137, 2138, 2139,
    2140, 2141, 2142, 2143, 2144, 2145, 2146, 2147, 2150, 2153,
    2157, 2160, 2163, 2166, 2169, 2172, 2175, 2178, 2181, 2184,
    2187, 2190, 2193, 2195, 2196, 2198, 2201, 2203, 2204, 2206,
    2209, 2213, 2215, 2216, 2218, 2221, 2222, 2223, 2224, 2225,
    2226, 2228, 2231, 2233, 2234, 2236, 2239, 2243, 2245, 2246,
    2248, 2251, 2252, 2253, 2254, 2255, 2258, 2260, 2262, 2264,
    2266, 2268, 2270, 2272, 2274, 2276, 2278, 2280, 2282, 2285,
    2287, 2290, 2292, 2294, 2296, 2298, 2300, 2302, 2304, 2306,
    2308, 2310, 2312, 2314, 2316, 2318, 2320, 2322, 2324, 2326,
    2328, 2330, 2332, 2334, 2336, 2338, 2340, 2342, 2344, 2346,
    2348, 2350, 2352, 2354, 2356, 2357, 2358, 2359, 2360, 2361,
    2362, 2363, 2364, 2365, 2366, 2367, 2369, 2371, 2373, 2375,
    2377, 2379, 2381, 2383, 2385, 2387, 2389, 2392, 2395, 2398,
    2401, 2404, 2407, 2410, 2413, 2416, 2420, 2424, 2428, 2432,
    2436, 2440, 2444, 2448, 2452, 2456, 2460, 2462, 2464, 2466,
    2468, 2470, 2472, 2474, 2476, 2478, 2481, 2484, 2487, 2490,
    2493, 2496, 2499, 2502, 2505, 2508, 2511, 2514, 2517, 2520,
    2523, 2526, 2529, 2532, 2535, 2538, 2541, 2544, 2547, 2550,
    2553, 2556, 2559, 2562, 2565, 2568, 2571, 2574, 2577, 2580,
    2583, 2586, 2589, 2590, 2591, 2592, 2593, 2594, 2595, 2596,
    2597, 2598, 2599, 2600, 2601, 2602, 2603, 2604, 2605, 2606,
    2607, 2608, 2609, 2610, 2611, 2612, 2613, 2614, 2615, 2616,
    2617, 2618, 2619, 2620, 2621, 2622, 2623, 2624, 2625, 2626,
    2627, 2628, 2629, 2630, 2631, 2632, 2633, 2634, 2635, 2636,
    2637, 2638, 2639, 2640, 2641, 2642, 2646, 2649, 2651, 2654,
    2656, 2657, 2658, 2659, 2660, 2661, 2662, 2663, 2664, 2665,
    2666, 2667, 2668, 2669, 2670, 2671, 2672, 2673, 2674, 2675,
    2676, 2677, 2678, 2679, 2680, 2681, 2682, 2683, 2684, 2685,
    2686, 2687, 2688, 2689, 2690, 2691, 2692, 2693, 2694, 2695,
    2696, 2697, 2698, 2699, 2700, 2701, 2702, 2703, 2704, 2705,
    2706, 2707, 2708, 2709, 2710, 2711, 2712, 2713, 2714, 2715,
    2716, 2717, 2718, 2719, 2720, 2721, 2722, 2723, 2724, 2725,
    2726, 2727, 2728, 2729, 2730, 2731, 2732, 2733, 2734, 2735,
    2736, 2737, 2738, 2739, 2740, 2741, 2742, 2743, 2744, 2745,
    2746, 2747, 2748, 2749, 2750, 2751, 2752, 2753, 2754, 2755,
    2756, 2757, 2758, 2759, 2760, 2761, 2762, 2763, 2764, 2765,
    2766, 2767, 2768, 2769, 2770, 2771, 2772, 2773, 2774, 2775,
    2776, 2777, 2778, 2779, 2780, 2781, 2782, 2783, 2784, 2785,
    2786, 2787, 2788, 2789, 2790, 2791, 2792, 2793, 2794, 2795,
    2796, 2797, 2798, 2799, 2800, 2801, 2802, 2803, 2804, 2805,
    2806, 2807, 2808, 2809, 2810, 2811, 2812, 2813, 2814, 2815,
    2816, 2817, 2818, 2819, 2820, 2821, 2822, 2823, 2824, 2825,
    2826, 2827, 2828, 2829, 2830, 2831, 2832, 2833, 2834, 2835,
    2836, 2837, 2838, 2839, 2840, 2841, 2842, 2843, 2844, 2845,
    2846, 2847, 2848, 2849, 2850, 2851, 2852, 2853, 2854, 2855,
    2856, 2857, 2858, 2859, 2860, 2861, 2862, 2863, 2864, 2865,
    2866, 2867, 2868, 2869, 2870, 2871, 2872, 2873, 2874, 2875,
    2876, 2877, 2878, 2879, 2880, 2882, 2884, 2886, 2888, 2890,
    2892, 2894, 2896, 2898, 2900, 2902, 2904, 2906, 2908, 2910,
    2912, 2914, 2916, 2918, 2920, 2922, 2924, 2926, 2928, 2930,
    2932, 2934, 2936, 2938, 2940, 2942, 2944, 2946, 2948, 2950,
    2952, 2954, 2956, 2958, 2960, 2962, 2964, 2966, 2968, 2970,
    2972, 2974, 2976, 2978, 2980, 2982, 2984, 2986, 2988, 2990,
    2992, 2994, 2996, 2998, 3000, 3002, 3004, 3005, 3006, 3007,
    3008, 3009, 3010, 3011, 3012, 3013, 3014, 3015, 3016, 3017,
    3018, 3019, 3020, 3021, 3022, 3023, 3024, 3025, 3026, 3027,
    3028, 3029, 3030, 3031, 3032, 3033, 3034, 3035, 3036, 3037,
    3038, 3039, 3040, 3041, 3042, 3043, 3044, 3045, 3046, 3047,
    3048, 3049, 3050, 3051, 3052, 3053, 3054, 3055, 3056, 3057,
    3058, 3059, 3060, 3061, 3062, 3063, 3064, 3065, 3066, 3067,
    3068, 3069, 3070, 3071, 3072, 3073, 3074, 3075, 3076, 3077,
    3078, 3079, 3080, 3081, 3082, 3083, 3084, 3085, 3086, 3087,
    3088, 3089, 3090, 3091, 3092, 3093, 3094, 3095, 3096, 3097,
    3098, 3099, 3100, 3101, 3102, 3103, 3104, 3105, 3106, 3107,
    3108, 3109, 3110, 3111, 3112, 3115, 3118, 3121, 3124, 3127,
    3130, 3133, 3136, 3139, 3142, 3145, 3148, 3151, 3154, 3158,
    3162, 3166, 3170, 3174, 3178, 3182, 3186, 3190, 3194, 3198,
    3202, 3206, 3210, 3214, 3221, 3227, 3230, 3233, 3236, 3239,
    3242, 3245, 3248, 3251, 3254, 3257, 3260, 3263, 3266, 3269,
    3272, 3275, 3278, 3281, 3284, 3287, 3290, 3293, 3296, 3299,
    3302, 3305, 3308, 3311, 3314, 3317, 3320, 3323, 3326, 3329,
    3332, 3335, 3336, 3337, 3338, 3339, 3342, 3344, 3346, 3348,
    3350, 3352, 3354, 3356, 3358, 3360, 3362, 3364, 3366, 3368,
    3370, 3372, 3373, 3374, 3375, 3376, 3377, 3378, 3379, 3380,
    3381, 3382, 3383, 3384, 3385, 3386, 3388, 3390, 3392, 3394,
    3396, 3398, 3400, 3402, 3404, 3406, 3408, 3410, 3412, 3414,
    3419, 3423, 3425, 3426, 3427, 3428, 3429, 3430, 3431, 3432,
    3433, 3434, 3435, 3436, 3437, 3438, 3439, 3440, 3441, 3442,
    3443, 3444, 3445, 3446, 3447, 3448, 3449, 3450, 3451, 3452,
    3453, 3454, 3455, 3456, 3457, 3458, 3459, 3460, 3461, 3462,
    3463, 3464, 3465, 3466, 3467, 3468, 3469, 3470, 3471, 3472,
    3473, 3474, 3476, 3478, 3480, 3482, 3484, 3486, 3488, 3490,
    3492, 3494, 3496, 3498, 3500, 3502, 3504, 3506, 3508, 3510,
    3512, 3514, 3516, 3518, 3520, 3522, 3525, 3528, 3531, 3533,
    3536, 3538, 3541, 3542, 3543, 3544, 3545, 3546, 3547, 3548,
    3549, 3550, 3551, 3552, 3553, 3554, 3555, 3556, 3557, 3558,
    3559, 3560, 3561, 3562, 3563, 3564, 3565, 3566, 3567, 3568,
    3569, 3570, 3571, 3572, 3573, 3574, 3575, 3576, 3577, 3578,
    3579, 3580, 3581, 3582, 3583, 3584, 3585, 3586, 3587, 3588,
    3590, 3594, 3598, 3602, 3605, 3609, 3612, 3615, 3620, 3624,
    3627, 3630, 3633, 3637, 3641, 3644, 3647, 3649, 3652, 3656,
    3660, 3662, 3667, 3673, 3678, 3681, 3686, 3691, 3695, 3698,
    3701, 3704, 3708, 3713, 3717, 3720, 3723, 3726, 3728, 3730,
    3732, 3734, 3737, 3740, 3745, 3748, 3752, 3757, 3760, 3762,
    3764, 3769, 3773, 3778, 3781, 3786, 3788, 3791, 3794, 3797,
    3800, 3803, 3807, 3810, 3812, 3815, 3818, 3821, 3825, 3828,
    3831, 3834, 3839, 3843, 3845, 3850, 3852, 3856, 3860, 3863,
    3866, 3869, 3873, 3875, 3878, 3882, 3884, 3889, 3892, 3894,
    3896, 3898, 3900, 3902, 3904, 3906, 3908, 3910, 3912, 3915,
    3918, 3921, 3924, 3927, 3930, 3933, 3936, 3939, 3942, 3945,
    3948, 3951, 3954, 3957, 3960, 3962, 3964, 3967, 3969, 3971,
    3973, 3976, 3979, 3981, 3983, 3985, 3987, 3989, 3993, 3995,
    3997, 3999, 4001, 4003, 4005, 4007, 4009, 4012, 4016, 4018,
    4020, 4022, 4024, 4026, 4028, 4030, 4033, 4036, 4039, 4042,
    4044, 4046, 4048, 4050, 4052, 4054, 4056, 4058, 4060, 4062,
    4065, 4068, 4070, 4073, 4076, 4079, 4081, 4084, 4087, 4091,
    4093, 4096, 4099, 4102, 4105, 4110, 4116, 4118, 4120, 4122,
    4124, 4126, 4128, 4130, 4132, 4134, 4136, 4138, 4140, 4142,
    4144, 4146, 4148, 4150, 4152, 4156, 4158, 4160, 4162, 4166,
    4169, 4171, 4173, 4175, 4177, 4179, 4181, 4183, 4185, 4187,
    4189, 4192, 4194, 4196, 4199, 4202, 4204, 4208, 4211, 4213,
    4215, 4217, 4219, 4222, 4225, 4227, 4229, 4231, 4233, 4235,
    4237, 4239, 4241, 4243, 4246, 4249, 4252, 4255, 4258, 4261,
    4264, 4267, 4270, 4273, 4276, 4279, 4282, 4285, 4288, 4291,
    4294, 4297, 4300, 4303, 4306, 4309, 4312, 4313, 4314, 4315,
    4316, 4317, 4318, 4319, 4320, 4321, 4322, 4323, 4324, 4325,
    4326, 4327, 4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335,
    4336, 4337, 4338, 4339, 4340, 4341, 4342, 4343, 4344, 4345,
    4346, 4347, 4348, 4349, 4350, 4351, 4352, 4353, 4354, 4355,
    4356, 4357, 4358, 4359, 4360, 4361, 4362, 4363, 4364, 4365,
    4366, 4367, 4368, 4369, 4370, 4371, 4372, 4373, 4374, 4375,
    4376, 4377, 4378, 4379, 4380, 4381, 4382, 4383, 4384, 4385,
    4386, 4387, 4388, 4389, 4390, 4391, 4392, 4393, 4394, 4395,
    4396, 4397, 4398, 4399, 4400, 4401, 4402, 4403, 4404, 4405,
    4406, 4407, 4408, 4409, 4410, 4411, 4412, 4413, 4414, 4415,
    4416, 4417, 4418, 4419, 4420, 4421, 4422, 4423, 4424, 4425,
    4426, 4427, 4428, 4429, 4430, 4431, 4432, 4433, 4434, 4435,
    4436, 4437, 4438, 4439, 4440, 4441, 4442, 4443, 4444, 4445,
    4446, 4447, 4448, 4449, 4450, 4451, 4452, 4453, 4454, 4455,
    4456, 4457, 4458, 4459, 4460, 4461, 4462, 4463, 4464, 4465,
    4466, 4467, 4468, 4469, 4470, 4471, 4472, 4473, 4474, 4475,
    4476, 4477, 4478, 4479, 4480, 4481, 4482, 4483, 4484, 4485,
    4486, 4487, 4488, 4489, 4490, 4491, 4492, 4493, 4494, 4495,
    4496, 4497, 4498, 4499, 4500, 4501, 4502, 4503, 4504, 4505,
    4506, 4507, 4508, 4509, 4510, 4511, 4512, 4513, 4514, 4515,
    4516, 4517, 4518, 4519, 4520, 4521, 4522, 4523, 4524, 4525,
    4526, 4527, 4528, 4529, 4530, 4531, 4532, 4533, 4534, 4535,
    4536, 4537, 4538, 4539, 4540, 4541, 4542, 4543, 4544, 4545,
    4546, 4547, 4548, 4549, 4550, 4551, 4552, 4553, 4554, 4555,
    4556, 4557, 4558, 4559, 4560, 4561, 4562, 4563, 4564, 4565,
    4566, 4567, 4568, 4569, 4570, 4571, 4572, 4573, 4574, 4575,
    4576, 4577, 4578, 4579, 4580, 4581, 4582, 4583, 4584, 4585,
    4586, 4587, 4588, 4589, 4590, 4591, 4592, 4593, 4594, 4595,
    4596, 4597, 4598, 4599, 4600, 4601, 4602, 4603, 4604, 4605,
    4606, 4607, 4608, 4609, 4610, 4611, 4612, 4613, 4614, 4615,
    4616, 4617, 4618, 4619, 4620, 4621, 4622, 4623, 4624, 4625,
    4626, 4627, 4628, 4629, 4630, 4631, 4632, 4633, 4634, 4635,
    4636, 4637, 4638, 4639, 4640, 4641, 4642, 4643, 4644, 4645,
    4646, 4647, 4648, 4649, 4650, 4651, 4652, 4653, 4654, 4655,
    4656, 4657, 4658, 4659, 4660, 4661, 4662, 4663, 4664, 4665,
    4666, 4667, 4668, 4669, 4670, 4671, 4672, 4673, 4674, 4675,
    4676, 4677, 4678, 4679, 4680, 4681, 4682, 4683, 4684, 4685,
    4686, 4687, 4688, 4689, 4690, 4691, 4692, 4693, 4694, 4695,
    4696, 4697, 4698, 4699, 4700, 4701, 4702, 4703, 4704, 4705,
    4706, 4707, 4708, 4709, 4710, 4711, 4712, 4713, 4714, 4715,
    4716, 4717, 4718, 4719, 4720, 4721, 4722, 4723, 4724, 4725,
    4726, 4727, 4728, 4729, 4730, 4731, 4732, 4733, 4734, 4735,
    4736, 4737, 4738, 4739, 4740, 4741, 4742, 4743, 4744, 4745,
    4746, 4747, 4748, 4749, 4750, 4751, 4752, 4753, 4754, 4755,
    4756, 4757, 4758, 4759, 4760, 4761, 4762, 4763, 4764, 4765,
    4766, 4767, 4768, 4769, 4770, 4771, 4772, 4773, 4774, 4775,
    4776, 4777, 4778, 4779, 4780, 4781, 4782, 4784, 4786, 4788,
    4791, 4794, 4796, 4798, 4800, 4802, 4804, 4806, 4808, 4810,
    4812, 4813, 4814, 4815, 4816, 4817, 4818, 4819, 4820, 4821,
    4822, 4824, 4826, 4828, 4830, 4832, 4834, 4836, 4838, 4840,
    4842, 4844, 4846, 4848, 4850, 4852, 4854, 4856, 4858, 4860,
    4862, 4864, 4866, 4868, 4870, 4872, 4874, 4876, 4878, 4880,
    4882, 4884, 4886, 4888, 4889, 4890, 4891, 4892, 4893, 4894,
    4895, 4896, 4897, 4898, 4899, 4900, 4901, 4902, 4903, 4904,
    4905, 4906, 4907, 4908, 4909, 4910, 4911, 4912, 4913, 4914,
    4915, 4916, 4917, 4918, 4919, 4920, 4921, 4922, 4923, 4924,
    4925, 4926, 4927, 4928, 4929, 4930, 4931, 4932, 4933, 4934,
    4935, 4936, 4937, 4938, 4939, 4940, 4941, 4942, 4943, 4944,
    4945, 4946, 4947, 4948, 4949, 4950, 4951, 4952, 4953, 4954,
    4955, 4956, 4957, 4958, 4959, 4960, 4961, 4962, 4963, 4964,
    4965, 4966, 4967, 4968, 4969, 4970, 4971, 4972, 4973, 4974,
    4975, 4976, 4977, 4978, 4979, 4980, 4981, 4982, 4983, 4984,
    4985, 4986, 4987, 4988, 4989, 4990, 4991, 4992, 4993, 4994,
    4995, 4996, 4997, 4998, 4999, 5000, 5001, 5002, 5003, 5004,
    5005, 5006, 5007, 5008, 5009, 5011, 5013, 5015, 5017, 5019,
    5021, 5023, 5025, 5027, 5029, 5031, 5033, 5035, 5037, 5039,
    5041, 5043, 5045, 5046, 5047, 5048, 5049, 5051, 5053, 5055,
    5057, 5059, 5061, 5063, 5065, 5067, 5069, 5071, 5073, 5075,
    5077, 5079, 5081, 5083, 5085, 5087, 5089, 5091, 5093, 5095,
    5097, 5099, 5101, 5103, 5105, 5107, 5109, 5111, 5113, 5115,
    5117, 5119, 5121, 5123, 5125, 5127, 5129, 5131, 5133, 5135,
    5137, 5139, 5141, 5143, 5145, 5147, 5149, 5151, 5153, 5155,
    5157, 5159, 5161, 5163, 5165, 5167, 5169, 5171, 5173, 5175,
    5177, 5179, 5181, 5183, 5185, 5187, 5189, 5191, 5193, 5195,
    5197, 5199, 5201, 5203, 5205, 5207, 5209, 5211, 5213, 5215,
    5217, 5219, 5221, 5223, 5225, 5227, 5229, 5231, 5233, 5235,
    5237, 5240, 5243, 5246, 5249, 5252, 5255, 5257, 5259, 5261,
    5263, 5265, 5267, 5269, 5271, 5273, 5275, 5277, 5279, 5281,
    5283, 5285, 5287, 5289, 5291, 5293, 5295, 5297, 5299, 5301,
    5303, 5305, 5307, 5309, 5311, 5313, 5315, 5317, 5319, 5321,
    5323, 5325, 5327, 5329, 5331, 5333, 5335, 5337, 5339, 5341,
    5343, 5345, 5347, 5349, 5351, 5353, 5355, 5357, 5359, 5361,
    5363, 5365, 5367, 5369, 5371, 5373, 5375, 5377, 5379, 5381,
    5383, 5385, 5387, 5389, 5391, 5393, 5395, 5397, 5399, 5401,
    5403, 5405, 5407, 5409, 5411, 5413, 5415, 5417, 5419, 5421,
    5423, 5425, 5427, 5429, 5431, 5433, 5435, 5437, 5439, 5441,
    5443, 5445, 5447, 5449, 5451, 5453, 5455, 5457, 5459, 5461,
    5463, 5465, 5467, 5469, 5471, 5473, 5475, 5477, 5479, 5481,
    5483, 5485, 5487, 5489, 5491, 5493, 5495, 5497, 5499, 5501,
    5503, 5505, 5507, 5509, 5511, 5513, 5515, 5517, 5519, 5521,
    5523, 5525, 5527, 5529, 5531, 5533, 5535, 5537, 5539, 5542,
    5545, 5548, 5550, 5552, 5554, 5556, 5558, 5560, 5562, 5564,
    5566, 5568, 5570, 5572, 5574, 5576, 5578, 5580, 5582, 5584,
    5586, 5588, 5590, 5592, 5594, 5596, 5598, 5600, 5602, 5604,
    5606, 5608, 5610, 5612, 5614, 5616, 5618, 5620, 5622, 5624,
    5626, 5628, 5630, 5632, 5634, 5636, 5638, 5640, 5642, 5644,
    5646, 5648, 5650, 5652, 5654, 5656, 5658, 5660, 5662, 5664,
    5666, 5668, 5670, 5672, 5674, 5676, 5678, 5680, 5682, 5684,
    5686, 5688, 5690, 5692, 5694, 5697, 5700, 5703, 5706, 5709,
    5712, 5715, 5718, 5721, 5724, 5727, 5730, 5733, 5736, 5739,
    5742, 5745, 5748, 5751, 5754, 5757, 5760, 5763, 5766, 5769,
    5772, 5775, 5778, 5781, 5784, 5787, 5790, 5793, 5796, 5799,
    5802, 5805, 5808, 5811, 5814, 5817, 5820, 5823, 5826, 5829,
    5832, 5835, 5838, 5841, 5844, 5847, 5850, 5853, 5856, 5859,
    5862, 5865, 5868, 5871, 5874, 5877, 5880, 5883, 5886, 5889,
    5892, 5895, 5898, 5901, 5904, 5907, 5910, 5913, 5916, 5919,
    5922, 5925, 5928, 5931, 5934, 5937, 5940, 5943, 5946, 5949,
    5952, 5955, 5958, 5961, 5964, 5967, 5970, 5973, 5976, 5979,
    5982, 5985, 5988, 5991, 5994, 5997, 6000, 6003, 6006, 6009,
    6012, 6015, 6018, 6021, 6024, 6027, 6030, 6033, 6036, 6039,
    6042, 6045, 6048, 6051, 6054, 6058, 6062, 6066, 6070, 6074,
    6078, 6082, 6085, 6103, 6111, 6115, 6116, 6117, 6118, 6119,
    6120, 6121, 6122, 6123, 6124, 6125, 6126, 6127, 6128, 6129,
    6130, 6131, 6132, 6133, 6134, 6135, 6136, 6137, 6138, 6139,
    6140, 6141, 6142, 6143, 6144, 6145, 6146, 6147, 6148, 6149,
    6150, 6151, 6152, 6153, 6154, 6155, 6156, 6157, 6158, 6159,
    6160, 6161, 6162, 6163, 6164, 6165, 6166, 6167, 6168, 6169,
    6170, 6171, 6172, 6173, 6174, 6175, 6176, 6177, 6178, 6179,
    6180, 6181, 6183, 6185, 6187, 6189, 6191, 6193, 6195, 6197,
    6199, 6201, 6203, 6205, 6207, 6209, 6210, 6211, 6212, 6213,
    6214, 6215, 6216, 6217, 6218, 6219, 6220, 6221, 6222, 6223,
    6224, 6225, 6226, 6227, 6228, 6229, 6230, 6231, 6232, 6233,
    6234, 6235, 6236, 6237, 6238, 6239, 6240, 6241, 6242, 6243,
    6244, 6245, 6246, 6247, 6248, 6249, 6250, 6251, 6252, 6253,
    6254, 6255, 6256, 6257, 6258, 6259, 6260, 6261, 6262, 6263,
    6264, 6265, 6266, 6267, 6268, 6269, 6270, 6271, 6272, 6273,
    6274, 6275, 6276, 6277, 6278, 6279, 6280, 6281, 6282, 6283,
    6284, 6285, 6286, 6287, 6288, 6289, 6290, 6291, 6292, 6293,
    6294, 6295, 6296, 6297, 6298, 6299, 6300, 6301, 6302, 6303,
    6304, 6305, 6306, 6307, 6308, 6309, 6310, 6311, 6312, 6313,
    6314, 6315, 6316, 6317, 6318, 6319, 6320, 6321, 6322, 6323,
    6324, 6325, 6326, 6328, 6330, 6332, 6334, 6336, 6338, 6340,
    6342, 6343, 6344, 6345, 6346, 6347, 6348, 6349, 6350, 6351,
    6352, 6353, 6354, 6355, 6356, 6357, 6358, 6359, 6360, 6361,
    6362, 6363, 6364, 6365, 6366, 6367, 6368, 6369, 6370, 6371,
    6372, 6373, 6374, 6375, 6376, 6377, 6378, 6379, 6380, 6381,
    6382, 6383, 6384, 6385, 6386, 6387, 6388, 6389, 6390, 6391,
    6392, 6393, 6394, 6395, 6396, 6397, 6398, 6399, 6400, 6401,
    6402, 6403, 6404, 6405, 6406, 6407, 6408, 6409, 6410, 6411,
    6412, 6413, 6414, 6415, 6416, 6417, 6418, 6419, 6420, 6421,
    6422, 6423, 6424, 6425, 6426, 6427, 6428, 6429, 6430, 6431,
    6432, 6433, 6434, 6435, 6436, 6437, 6438, 6439, 6440, 6441,
    6442, 6443, 6444, 6445, 6446, 6447, 6448, 6449, 6450, 6451,
    6452, 6453, 6454, 6455, 6456, 6457, 6458, 6459, 6460, 6461,
    6462, 6463, 6464, 6465, 6466, 6467, 6468, 6469, 6470, 6471,
    6472, 6473, 6474, 6475, 6476, 6477, 6478, 6479, 6480, 6481,
    6482, 6483, 6484, 6485, 6486, 6487, 6488, 6489, 6490, 6491,
    6492, 6493, 6494, 6495, 6496, 6497, 6498, 6499, 6500, 6501,
    6502, 6503, 6504, 6505, 6506, 6507, 6508, 6509, 6510, 6511,
    6512, 6513, 6514, 6515, 6516, 6517, 6518, 6519, 6520, 6521,
    6522, 6523, 6524, 6525, 6526, 6527, 6528, 6529, 6530, 6531,
    6532, 6533, 6534, 6535, 6536, 6537, 6538, 6539, 6540, 6541,
    6542, 6543, 6544, 6545, 6546, 6547, 6548, 6549, 6550, 6551,
    6552, 6553, 6554, 6555, 6556, 6557, 6558, 6559, 6560, 6561,
    6562, 6563, 6564, 6565, 6566, 6567, 6569, 6571, 6573, 6575,
    6577, 6579, 6581, 6583, 6585, 6587, 6589, 6591, 6593, 6595,
    6597, 6599, 6601, 6603, 6605, 6607, 6609, 6611, 6613, 6615,
    6617, 6619, 6620, 6621, 6622, 6623, 6624, 6625, 6626, 6627,
    6628, 6629, 6630, 6631, 6632, 6633, 6634, 6635, 6636, 6637,
    6638, 6639, 6640, 6641, 6642, 6643, 6644, 6645, 6646, 6647,
    6648, 6649, 6650, 6651, 6652, 6653, 6654, 6655, 6656, 6657,
    6658, 6659, 6660, 6661, 6662, 6663, 6664, 6665, 6666, 6667,
    6668, 6669, 6670, 6671, 6672, 6673, 6674, 6675, 6676, 6677,
    6678, 6679, 6680, 6681, 6682, 6683, 6684, 6685, 6686, 6687,
    6688, 6689, 6690, 6691, 6692, 6693, 6694, 6695, 6696, 6697,
    6698, 6699, 6700, 6701, 6702, 6703, 6704, 6705, 6706, 6707,
    6708, 6709, 6710, 6711, 6712, 6713, 6714, 6715, 6716, 6717,
    6718, 6719, 6720, 6721, 6722, 6723, 6724, 6725, 6726, 6727,
    6728, 6729, 6730, 6731, 6732, 6733, 6734, 6735, 6736, 6737,
    6738, 6739, 6740, 6741, 6742, 6743, 6744, 6745, 6746, 6747,
    6748, 6749, 6750, 6751, 6752, 6753, 6754, 6755, 6756, 6757,
    6758, 6759, 6760, 6761, 6762, 6763, 6764, 6765, 6766, 6767,
    6768, 6769, 6770, 6771, 6772, 6773, 6774, 6775, 6776, 6777,
    6778, 6779, 6780, 6781, 6782, 6783, 6784, 6785, 6786, 6787,
    6788, 6789, 6790, 6791, 6792, 6793, 6794, 6795, 6796, 6797,
    6798, 6799, 6800, 6801, 6802, 6803, 6804, 6805, 6806, 6807,
    6808, 6809, 6810, 6811, 6812, 6813, 6814, 6815, 6816, 6817,
    6818, 6819, 6820, 6821, 6822, 6823, 6824, 6825, 6826, 6827,
    6828, 6829, 6830, 6831, 6832, 6833, 6834, 6835, 6836, 6837,
    6838, 6839, 6840, 6841, 6842, 6843, 6844, 6845, 6846, 6847,
    6848, 6849, 6850, 6851, 6852, 6853, 6854, 6855, 6856, 6857,
    6858, 6859, 6860, 6861, 6862, 6863, 6864, 6865, 6866, 6867,
    6868, 6869, 6870, 6871, 6872, 6873, 6874, 6875, 6876, 6877,
    6878, 6879, 6880, 6881, 6882, 6883, 6884, 6885, 6886, 6887,
    6888, 6889, 6890, 6891, 6892, 6893, 6894, 6895, 6896, 6897,
    6898, 6899, 6900, 6901, 6902, 6903, 6904, 6905, 6906, 6907,
    6908, 6909, 6910, 6911, 6912, 6913, 6914, 6915, 6916, 6917,
    6918, 6919, 6920, 6921, 6922, 6923, 6924, 6925, 6926, 6927,
    6928, 6929, 6930, 6931, 6932, 6933, 6934, 6935, 6936, 6937,
    6938, 6939, 6940, 6941, 6942, 6943, 6944, 6945, 6946, 6947,
    6948, 6949, 6950, 6951, 6952, 6953, 6954, 6955, 6956, 6957,
    6958, 6959, 6960, 6961, 6962, 6963, 6964, 6965, 6966, 6967,
    6968, 6969, 6970, 6971, 6972, 6973, 6974, 6975, 6976, 6977,
    6978, 6979, 6980, 6981, 6982, 6983, 6984, 6985, 6986, 6987,
    6988, 6989, 6990, 6991, 6992, 6993, 6994, 6995, 6996, 6997,
    6998, 6999, 7000, 7001, 7002, 7003, 7004, 7005, 7006, 7007,
    7008, 7009, 7010, 7011, 7012, 7013, 7014, 7015, 7016, 7017,
    7018, 7019, 7020, 7021, 7022, 7023, 7024, 7025, 7026, 7027,
    7028, 7029, 7030, 7031, 7032, 7033, 7034, 7035, 7036, 7037,
    7038, 7039, 7040, 7041, 7042, 7043, 7044, 7045, 7046, 7047,
    7048, 7049, 7050, 7051, 7052, 7053, 7054, 7055, 7056, 7057,
    7058, 7059, 7060, 7061, 7062, 7063, 7064, 7065, 7066, 7067,
    7068, 7069, 7070, 7071, 7072, 7073, 7074, 7075, 7076, 7077,
    7078, 7079, 7080, 7081, 7082, 7083, 7084, 7085, 7086, 7087,
    7088, 7089, 7090, 7091, 7092, 7093, 7094, 7095, 7096, 7097,
    7098, 7099, 7100, 7101, 7102, 7103, 7104, 7105, 7106, 7107,
    7108, 7109, 7110, 7111, 7112, 7113, 7114, 7115, 7116, 7117,
    7118, 7119, 7120, 7121, 7122, 7123, 7124, 7125, 7126, 7127,
    7128, 7129, 7130, 7131, 7132, 7133, 7134, 7135, 7136, 7137,
    7138, 7139, 7140, 7141, 7142, 7143, 7144, 7145, 7146, 7147,
    7148, 7149, 7150, 7151, 7152, 7153, 7154, 7155, 7156, 7157,
    7158, 7159, 7160, 7161, 7162, 7163, 7164, 7165, 7166, 7167,
    7168, 7169, 7170, 7171, 7172, 7173, 7174, 7175, 7176, 7177,
    7178, 7179, 7180, 7181, 7182, 7183, 7184, 7185, 7186, 7187,
    7188, 7189, 7190, 7191, 7192, 7193, 7194, 7195, 7196, 7197,
    7198, 7199, 7200, 7201, 7202, 7203, 7204, 7205, 7206, 7207,
    7208, 7209, 7210, 7211, 7212, 7213, 7214, 7215, 7216, 7217,
    7218, 7219, 7220, 7221, 7222, 7223, 7224, 7225, 7226, 7227,
    7228, 7229, 7230, 7231, 7232, 7233, 7234, 7235, 7236, 7237,
    7238, 7239, 7240, 7241, 7242, 7243, 7244, 7245, 7246, 7247,
    7248, 7249, 7250, 7251, 7252, 7253, 7254, 7255, 7256, 7257,
    7258, 7259, 7260, 7261, 7262, 7263, 7264, 7265, 7266, 7267,
    7268, 7269, 7270, 7271, 7272, 7273, 7274, 7275, 7276, 7277,
    7278, 7279, 7280, 7281, 7282, 7283, 7284, 7285, 7286, 7287,
    7288, 7289, 7290, 7291, 7292, 7293, 7294, 7295, 7296, 7297,
    7298, 7299, 7300, 7301, 7302, 7303, 7304, 7305, 7306, 7307,
    7308, 7309, 7310, 7311, 7312, 7313, 7314, 7315, 7316, 7317,
    7318, 7319, 7320, 7321, 7322, 7323, 7324, 7325, 7326, 7327,
    7328, 7329, 7330, 7331, 7332, 7333, 7334, 7335, 7336, 7337,
    7338, 7339, 7340, 7341, 7342, 7343, 7344, 7345, 7346, 7347,
    7348, 7349, 7350, 7351, 7352, 7353, 7354, 7355, 7356, 7357,
    7358, 7359, 7360, 7361, 7362, 7363, 7364, 7365, 7366, 7367,
    7368, 7369, 7370, 7371, 7372, 7373, 7374, 7375, 7376, 7377,
    7378, 7379, 7380, 7381, 7382, 7383, 7384, 7385, 7386, 7387,
    7388, 7389, 7390, 7391, 7392, 7393, 7394, 7395, 7396, 7397,
    7398, 7399, 7400, 7401, 7402, 7403, 7404, 7405, 7406, 7407,
    7408, 7409, 7410, 7411, 7412, 7413, 7414, 7415, 7416, 7417,
    7418, 7419, 7420, 7421, 7422, 7423, 7424, 7425, 7426, 7427,
    7428, 7429, 7430, 7431, 7432, 7433, 7434, 7435, 7436, 7437,
    7438, 7439, 7440, 7441, 7442, 7443, 7444, 7445, 7446, 7447,
    7448, 7449, 7450, 7451, 7452, 7453, 7454, 7455, 7456, 7457,
    7458, 7459, 7460, 7461, 7462, 7463, 7464, 7465, 7466, 7467,
    7468, 7469, 7470, 7471, 7472, 7473, 7474, 7475, 7476, 7477,
    7478, 7479, 7480, 7481, 7482, 7483, 7484, 7485, 7486, 7487,
    7488, 7489, 7490, 7491, 7492, 7493, 7494, 7495, 7496, 7497,
    7498, 7499, 7500, 7501, 7502, 7503, 7504, 7505, 7506, 7507,
    7508, 7509, 7510, 7511, 7512, 7513, 7514, 7515, 7516, 7517,
    7518, 7519, 7520, 7521, 7522, 7523, 7524, 7525, 7526, 7527,
    7528, 7529, 7530, 7531, 7532, 7533, 7534, 7535, 7536, 7537,
    7538, 7539, 7540, 7541, 7542, 7543, 7544, 7545, 7546, 7547,
    7548, 7549, 7550, 7551, 7552, 7553, 7554, 7555, 7556, 7557,
    7558, 7559, 7560, 7561, 7562, 7563, 7564, 7565, 7566, 7567,
    7568, 7569, 7570, 7571, 7572, 7573, 7574, 7575, 7576, 7577,
    7578, 7579, 7580, 7581, 7582, 7583, 7584, 7585, 7586, 7587,
    7588, 7589, 7590, 7591, 7592, 7593, 7594, 7595, 7596, 7597,
    7598, 7599, 7600, 7601, 7602, 7603, 7604, 7605, 7606, 7607,
    7608, 7609, 7610, 7611, 7612, 7613, 7614, 7615, 7616, 7617,
    7618, 7619, 7620, 7621, 7622, 7623, 7624, 7625, 7626, 7627,
    7628, 7629, 7630, 7631, 7632, 7633, 7634, 7635, 7636, 7637,
    7638, 7639, 7640, 7641, 7642, 7643, 7644, 7645, 7646, 7647,
    7648, 7649, 7650, 7651, 7652, 7653, 7654, 7655, 7656, 7657,
    7658, 7659, 7660, 7661, 7662, 7663, 7664, 7665, 7666, 7667,
    7668, 7669, 7670, 7671, 7672, 7673, 7674, 7675, 7676, 7677,
    7678, 7679, 7680, 7681, 7682, 7683, 7684, 7685, 7686, 7687,
    7688, 7689, 7690, 7691, 7692, 7693, 7694, 7695, 7696, 7697,
    7698, 7699, 7700, 7701, 7702, 7703, 7704, 7705, 7706, 7707,
    7708, 7709, 7710, 7711, 7712, 7713, 7714, 7715, 7716, 7717,
    7718, 7719, 7720, 7721, 7722, 7723, 7724, 7725, 7726, 7727,
    7728, 7729, 7730, 7731, 7732, 7733, 7734, 7735, 7736, 7737,
    7738, 7739, 7740, 7741, 7742, 7743, 7744, 7745, 7746, 7747,
    7748, 7749, 7750, 7751, 7752, 7753, 7754, 7755, 7756, 7758,
    7760, 7762, 7764, 7766, 7768, 7770, 7772, 7774, 7776, 7778,
    7781, 7784, 7787, 7790, 7793, 7796, 7799, 7802, 7805, 7808,
    7811, 7814, 7817, 7820, 7823, 7826, 7829, 7832, 7835, 7838,
    7841, 7844, 7847, 7850, 7853, 7856, 7859, 7860, 7861, 7863,
    7865, 7866, 7867, 7868, 7869, 7870, 7871, 7872, 7873, 7874,
    7875, 7876, 7877, 7878, 7879, 7880, 7881, 7882, 7883, 7884,
    7885, 7886, 7887, 7888, 7889, 7890, 7891, 7893, 7895, 7897,
    7899, 7902, 7904, 7906, 7908, 7910, 7912, 7914, 7916, 7917,
    7918, 7919, 7920, 7921, 7922, 7923, 7924, 7925, 7926, 7927,
    7928, 7929, 7930, 7931, 7932, 7933, 7934, 7935, 7936, 7937,
    7938, 7939, 7940, 7941, 7942, 7943, 7944, 7945, 7946, 7947,
    7948, 7949, 7950, 7951, 7952, 7953, 7954, 7955, 7956, 7957,
    7958, 7959, 7960, 7961, 7964, 7967, 7970, 7973, 7976, 7979,
    7982, 7985, 7988, 7989, 7990, 7991, 7992, 7993, 7994, 7995,
    7996, 7997, 7998, 7999, 8000, 8001, 8002, 8003, 8004, 8005,
    8006, 8007, 8008, 8009, 8010, 8011, 8012, 8013, 8014, 8015,
    8016, 8017, 8018, 8019, 8020, 8021, 8022, 8023, 8024, 8025,
    8026, 8027, 8028, 8029, 8030, 8031, 8032, 8033, 8034, 8035,
    8036, 8037, 8038, 8039, 8040, 8041, 8042, 8043, 8044, 8045,
    8046, 8047, 8048, 8049, 8050, 8051, 8052, 8053, 8054, 8055,
    8056, 8057, 8058, 8059, 8060, 8061, 8062, 8063, 8064, 8065,
    8066, 8067, 8068, 8069, 8070, 8071, 8072, 8073, 8074, 8075,
    8076, 8077, 8078, 8079, 8080, 8081, 8082, 8083, 8084, 8085,
    8086, 8087, 8088, 8089, 8090, 8091, 8092, 8093, 8094, 8095,
    8096, 8097, 8098, 8099, 8100, 8101, 8102, 8103, 8104, 8105,
    8106, 8107, 8108, 8109, 8110, 8111, 8112, 8113, 8114, 8115,
    8116, 8117, 8118, 8119, 8120, 8121, 8122, 8123, 8124, 8125,
    8126, 8127, 8128, 8129, 8130, 8131, 8132, 8133, 8134, 8135,
    8136, 8137, 8138, 8139, 8140, 8141, 8142, 8143, 8144, 8145,
    8146, 8147, 8148, 8149, 8150, 8151, 8152, 8153, 8154, 8155,
    8156, 8157, 8158, 8159, 8160, 8161, 8162, 8163, 8164, 8165,
    8166, 8167, 8168, 8169, 8170, 8171, 8172, 8173, 8174, 8175,
    8176, 8177, 8178, 8179, 8180, 8181, 8182, 8183, 8184, 8185,
    8186, 8187, 8188, 8189, 8190, 8191, 8192, 8193, 8194, 8195,
    8196, 8197, 8198, 8199, 8200, 8201, 8202, 8203, 8204, 8205,
    8206, 8207, 8208, 8209, 8210, 8211, 8212, 8213, 8214, 8215,
    8216, 8217, 8218, 8219, 8220, 8221, 8222, 8223, 8224, 8225,
    8226, 8227, 8228, 8229, 8230, 8231, 8232, 8233, 8234, 8235,
    8236, 8237, 8238, 8239, 8240, 8241, 8242, 8243, 8244, 8245,
    8246, 8247, 8248, 8249, 8250, 8251, 8252, 8253, 8254, 8255,
    8256, 8257, 8258, 8259, 8260, 8261, 8262, 8263, 8264, 8265,
    8266, 8267, 8268, 8269, 8270, 8271, 8272, 8273, 8274, 8275,
    8276, 8277, 8278, 8279, 8280, 8281, 8282, 8283, 8284, 8285,
    8286, 8287, 8288, 8289, 8290, 8291, 8292, 8293, 8294, 8295,
    8296, 8297, 8298, 8299, 8300, 8301, 8302, 8303, 8304, 8305,
    8306, 8307, 8308, 8309, 8310, 8311, 8312, 8313, 8314, 8315,
    8316, 8317, 8318, 8319, 8320, 8321, 8322, 8323, 8324, 8325,
    8326, 8327, 8328, 8329, 8330, 8331, 8332, 8333, 8334, 8335,
    8336, 8337, 8338, 8339, 8340, 8341, 8342, 8343, 8344, 8345,
    8346, 8347, 8348, 8349, 8350, 8351, 8352, 8353, 8354, 8355,
    8356, 8357, 8358, 8359, 8360, 8361, 8362, 8363, 8364, 8365,
    8366, 8367, 8368, 8369, 8370, 8371, 8372, 8373, 8374, 8375,
    8376, 8377, 8378, 8379, 8380, 8381, 8382, 8383, 8384, 8385,
    8386, 8387, 8388, 8389, 8390, 8391, 8392, 8393, 8394, 8395,
    8396, 8397, 8398, 8399, 8400, 8401, 8402, 8403, 8404, 8405,
    8406, 8407, 8408, 8409, 8410, 8411, 8412, 8413, 8414, 8415,
    8416, 8417, 8418, 8419, 8420, 8421, 8422, 8423, 8424, 8425,
    8426, 8427, 8428, 8429, 8430, 8431, 8432, 8433, 8434, 8435,
    8436, 8437, 8438, 8439, 8440, 8441, 8442, 8443, 8444, 8445,
    8446, 8447, 8448, 8449, 8450, 8451, 8452, 8453, 8454, 8455,
    8456, 8457, 8458, 8459, 8460, 8461, 8462, 8463, 8464, 8465,
    8466, 8467, 8468, 8469, 8470, 8471, 8472, 8473, 8474, 8475,
    8476, 8477, 8478, 8479, 8480, 8481, 8482, 8483, 8484, 8485,
    8486, 8487, 8488, 8489, 8490, 8491, 8492, 8493, 8494, 8495,
    8496, 8497, 8498, 8499, 8500, 8501, 8502, 8503, 8504, 8505,
    8506, 8507, 8508, 8509, 8510, 8511, 8512, 8513, 8514, 8515,
    8516, 8517, 8518, 8519, 8520, 8521, 8522, 8523, 8524, 8525,
    8526, 8527, 8528, 8529, 8530, 8531, 8532, 8533, 8534, 8535,
    8536, 8537, 8538, 8539, 8540, 8541, 8542
};

const int32_t DECOMPOSITION_MAPPING_CHARS[] = {
    0x0020, 0x0020, 0x0308, 0x0061, 0x0020, 0x0304, 0x0032, 0x0033,
    0x0020, 0x0301, 0x03BC, 0x0020, 0x0327, 0x0031, 0x006F, 0x0031,
    0x2044, 0x0034, 0x0031, 0x2044, 0x0032, 0x0033, 0x2044, 0x0034,
    0x0041, 0x0300, 0x0041, 0x0301, 0x0041, 0x0302, 0x0041, 0x0303,
    0x0041, 0x0308, 0x0041, 0x030A, 0x0043, 0x0327, 0x0045, 0x0300,
    0x0045, 0x0301, 0x0045, 0x0302, 0x0045, 0x0308, 0x0049, 0x0300,
    0x0049, 0x0301, 0x0049, 0x0302, 0x0049, 0x0308, 0x004E, 0x0303,
    0x004F, 0x0300, 0x004F, 0x0301, 0x004F, 0x0302, 0x004F, 0x0303,
    0x004F, 0x0308, 0x0055, 0x0300, 0x0055, 0x0301, 0x0055, 0x0302,
    0x0055, 0x0308, 0x0059, 0x0301, 0x0061, 0x0300, 0x0061, 0x0301,
    0x0061, 0x0302, 0x0061, 0x0303, 0x0061, 0x0308, 0x0061, 0x030A,
    0x0063, 0x0327, 0x0065, 0x0300, 0x0065, 0x0301, 0x0065, 0x0302,
    0x0065, 0x0308, 0x0069, 0x0300, 0x0069, 0x0301, 0x0069, 0x0302,
    0x0069, 0x0308, 0x006E, 0x0303, 0x006F, 0x0300, 0x006F, 0x0301,
    0x006F, 0x0302, 0x006F, 0x0303, 0x006F, 0x0308, 0x0075, 0x0300,
    0x0075, 0x0301, 0x0075, 0x0302, 0x0075, 0x0308, 0x0079, 0x0301,
    0x0079, 0x0308, 0x0041, 0x0304, 0x0061, 0x0304, 0x0041, 0x0306,
    0x0061, 0x0306, 0x0041, 0x0328, 0x0061, 0x0328, 0x0043, 0x0301,
    0x0063, 0x0301, 0x0043, 0x0302, 0x0063, 0x0302, 0x0043, 0x0307,
    0x0063, 0x0307, 0x0043, 0x030C, 0x0063, 0x030C, 0x0044, 0x030C,
    0x0064, 0x030C, 0x0045, 0x0304, 0x0065, 0x0304, 0x0045, 0x0306,
    0x0065, 0x0306, 0x0045, 0x0307, 0x0065, 0x0307, 0x0045, 0x0328,
    0x0065, 0x0328, 0x0045, 0x030C, 0x0065, 0x030C, 0x0047, 0x0302,
    0x0067, 0x0302, 0x0047, 0x0306, 0x0067, 0x0306, 0x0047, 0x0307,
    0x0067, 0x0307, 0x0047, 0x0327, 0x0067, 0x0327, 0x0048, 0x0302,
    0x0068, 0x0302, 0x0049, 0x0303, 0x0069, 0x0303, 0x0049, 0x0304,
    0x0069, 0x0304, 0x0049, 0x0306, 0x0069, 0x0306, 0x0049, 0x0328,
    0x0069, 0x0328, 0x0049, 0x0307, 0x0049, 0x004A, 0x0069, 0x006A,
    0x004A, 0x0302, 0x006A, 0x0302, 0x004B, 0x0327, 0x006B, 0x0327,
    0x004C, 0x0301, 0x006C, 0x0301, 0x004C, 0x0327, 0x006C, 0x0327,
    0x004C, 0x030C, 0x006C, 0x030C, 0x004C, 0x00B7, 0x006C, 0x00B7,
    0x004E, 0x0301, 0x006E, 0x0301, 0x004E, 0x0327, 0x006E, 0x0327,
    0x004E, 0x030C, 0x006E, 0x030C, 0x02BC, 0x006E, 0x004F, 0x0304,
    0x006F, 0x0304, 0x004F, 0x0306, 0x006F, 0x0306, 0x004F, 0x030B,
    0x006F, 0x030B, 0x0052, 0x0301, 0x0072, 0x0301, 0x0052, 0x0327,
    0x0072, 0x0327, 0x0052, 0x030C, 0x0072, 0x030C, 0x0053, 0x0301,
    0x0073, 0x0301, 0x0053, 0x0302, 0x0073, 0x0302, 0x0053, 0x0327,
    0x0073, 0x0327, 0x0053, 0x030C, 0x0073, 0x030C, 0x0054, 0x0327,
    0x0074, 0x0327, 0x0054, 0x030C, 0x0074, 0x030C, 0x0055, 0x0303,
    0x0075, 0x0303, 0x0055, 0x0304, 0x0075, 0x0304, 0x0055, 0x0306,
    0x0075, 0x0306, 0x0055, 0x030A, 0x0075, 0x030A, 0x0055, 0x030B,
    0x0075, 0x030B, 0x0055, 0x0328, 0x0075, 0x0328, 0x0057, 0x0302,
    0x0077, 0x0302, 0x0059, 0x0302, 0x0079, 0x0302, 0x0059, 0x0308,
    0x005A, 0x0301, 0x007A, 0x0301, 0x005A, 0x0307, 0x007A, 0x0307,
    0x005A, 0x030C, 0x007A, 0x030C, 0x0073, 0x004F, 0x031B, 0x006F,
    0x031B, 0x0055, 0x031B, 0x0075, 0x031B, 0x0044, 0x017D, 0x0044,
    0x017E, 0x0064, 0x017E, 0x004C, 0x004A, 0x004C, 0x006A, 0x006C,
    0x006A, 0x004E, 0x004A, 0x004E, 0x006A, 0x006E, 0x006A, 0x0041,
    0x030C, 0x0061, 0x030C, 0x0049, 0x030C, 0x0069, 0x030C, 0x004F,
    0x030C, 0x006F, 0x030C, 0x0055, 0x030C, 0x0075, 0x030C, 0x00DC,
    0x0304, 0x00FC, 0x0304, 0x00DC, 0x0301, 0x00FC, 0x0301, 0x00DC,
    0x030C, 0x00FC, 0x030C, 0x00DC, 0x0300, 0x00FC, 0x0300, 0x00C4,
    0x0304, 0x00E4, 0x0304, 0x0226, 0x0304, 0x0227, 0x0304, 0x00C6,
    0x0304, 0x00E6, 0x0304, 0x0047, 0x030C, 0x0067, 0x030C, 0x004B,
    0x030C, 0x006B, 0x030C, 0x004F, 0x0328, 0x006F, 0x0328, 0x01EA,
    0x0304, 0x01EB, 0x0304, 0x01B7, 0x030C, 0x0292, 0x030C, 0x006A,
    0x030C, 0x0044, 0x005A, 0x0044, 0x007A, 0x0064, 0x007A, 0x0047,
    0x0301, 0x0067, 0x0301, 0x004E, 0x0300, 0x006E, 0x0300, 0x00C5,
    0x0301, 0x00E5, 0x0301, 0x00C6, 0x0301, 0x00E6, 0x0301, 0x00D8,
    0x0301, 0x00F8, 0x0301, 0x0041, 0x030F, 0x0061, 0x030F, 0x0041,
    0x0311, 0x0061, 0x0311, 0x0045, 0x030F, 0x0065, 0x030F, 0x0045,
    0x0311, 0x0065, 0x0311, 0x0049, 0x030F, 0x0069, 0x030F, 0x0049,
    0x0311, 0x0069, 0x0311, 0x004F, 0x030F, 0x006F, 0x030F, 0x004F,
    0x0311, 0x006F, 0x0311, 0x0052, 0x030F, 0x0072, 0x030F, 0x0052,
    0x0311, 0x0072, 0x0311, 0x0055, 0x030F, 0x0075, 0x030F, 0x0055,
    0x0311, 0x0075, 0x0311, 0x0053, 0x0326, 0x0073, 0x0326, 0x0054,
    0x0326, 0x0074, 0x0326, 0x0048, 0x030C, 0x0068, 0x030C, 0x0041,
    0x0307, 0x0061, 0x0307, 0x0045, 0x0327, 0x0065, 0x0327, 0x00D6,
    0x0304, 0x00F6, 0x0304, 0x00D5, 0x0304, 0x00F5, 0x0304, 0x004F,
    0x0307, 0x006F, 0x0307, 0x022E, 0x0304, 0x022F, 0x0304, 0x0059,
    0x0304, 0x0079, 0x0304, 0x0068, 0x0266, 0x006A, 0x0072, 0x0279,
    0x027B, 0x0281, 0x0077, 0x0079, 0x0020, 0x0306, 0x0020, 0x0307,
    0x0020, 0x030A, 0x0020, 0x0328, 0x0020, 0x0303, 0x0020, 0x030B,
    0x0263, 0x006C, 0x0073, 0x0078, 0x0295, 0x0300, 0x0301, 0x0313,
    0x0308, 0x0301, 0x02B9, 0x0020, 0x0345, 0x003B, 0x0020, 0x0301,
    0x00A8, 0x0301, 0x0391, 0x0301, 0x00B7, 0x0395, 0x0301, 0x0397,
    0x0301, 0x0399, 0x0301, 0x039F, 0x0301, 0x03A5, 0x0301, 0x03A9,
    0x0301, 0x03CA, 0x0301, 0x0399, 0x0308, 0x03A5, 0x0308, 0x03B1,
    0x0301, 0x03B5, 0x0301, 0x03B7, 0x0301, 0x03B9, 0x0301, 0x03CB,
    0x0301, 0x03B9, 0x0308, 0x03C5, 0x0308, 0x03BF, 0x0301, 0x03C5,
    0x0301, 0x03C9, 0x0301, 0x03B2, 0x03B8, 0x03A5, 0x03D2, 0x0301,
    0x03D2, 0x0308, 0x03C6, 0x03C0, 0x03BA, 0x03C1, 0x03C2, 0x0398,
    0x03B5, 0x03A3, 0x0415, 0x0300, 0x0415, 0x0308, 0x0413, 0x0301,
    0x0406, 0x0308, 0x041A, 0x0301, 0x0418, 0x0300, 0x0423, 0x0306,
    0x0418, 0x0306, 0x0438, 0x0306, 0x0435, 0x0300, 0x0435, 0x0308,
    0x0433, 0x0301, 0x0456, 0x0308, 0x043A, 0x0301, 0x0438, 0x0300,
    0x0443, 0x0306, 0x0474, 0x030F, 0x0475, 0x030F, 0x0416, 0x0306,
    0x0436, 0x0306, 0x0410, 0x0306, 0x0430, 0x0306, 0x0410, 0x0308,
    0x0430, 0x0308, 0x0415, 0x0306, 0x0435, 0x0306, 0x04D8, 0x0308,
    0x04D9, 0x0308, 0x0416, 0x0308, 0x0436, 0x0308, 0x0417, 0x0308,
    0x0437, 0x0308, 0x0418, 0x0304, 0x0438, 0x0304, 0x0418, 0x0308,
    0x0438, 0x0308, 0x041E, 0x0308, 0x043E, 0x0308, 0x04E8, 0x0308,
    0x04E9, 0x0308, 0x042D, 0x0308, 0x044D, 0x0308, 0x0423, 0x0304,
    0x0443, 0x0304, 0x0423, 0x0308, 0x0443, 0x0308, 0x0423, 0x030B,
    0x0443, 0x030B, 0x0427, 0x0308, 0x0447, 0x0308, 0x042B, 0x0308,
    0x044B, 0x0308, 0x0565, 0x0582, 0x0627, 0x0653, 0x0627, 0x0654,
    0x0648, 0x0654, 0x0627, 0x0655, 0x064A, 0x0654, 0x0627, 0x0674,
    0x0648, 0x0674, 0x06C7, 0x0674, 0x064A, 0x0674, 0x06D5, 0x0654,
    0x06C1, 0x0654, 0x06D2, 0x0654, 0x0928, 0x093C, 0x0930, 0x093C,
    0x0933, 0x093C, 0x0915, 0x093C, 0x0916, 0x093C, 0x0917, 0x093C,
    0x091C, 0x093C, 0x0921, 0x093C, 0x0922, 0x093C, 0x092B, 0x093C,
    0x092F, 0x093C, 0x09C7, 0x09BE, 0x09C7, 0x09D7, 0x09A1, 0x09BC,
    0x09A2, 0x09BC, 0x09AF, 0x09BC, 0x0A32, 0x0A3C, 0x0A38, 0x0A3C,
    0x0A16, 0x0A3C, 0x0A17, 0x0A3C, 0x0A1C, 0x0A3C, 0x0A2B, 0x0A3C,
    0x0B47, 0x0B56, 0x0B47, 0x0B3E, 0x0B47, 0x0B57, 0x0B21, 0x0B3C,
    0x0B22, 0x0B3C, 0x0B92, 0x0BD7, 0x0BC6, 0x0BBE, 0x0BC7, 0x0BBE,
    0x0BC6, 0x0BD7, 0x0C46, 0x0C56, 0x0CBF, 0x0CD5, 0x0CC6, 0x0CD5,
    0x0CC6, 0x0CD6, 0x0CC6, 0x0CC2, 0x0CCA, 0x0CD5, 0x0D46, 0x0D3E,
    0x0D47, 0x0D3E, 0x0D46, 0x0D57, 0x0DD9, 0x0DCA, 0x0DD9, 0x0DCF,
    0x0DDC, 0x0DCA, 0x0DD9, 0x0DDF, 0x0E4D, 0x0E32, 0x0ECD, 0x0EB2,
    0x0EAB, 0x0E99, 0x0EAB, 0x0EA1, 0x0F0B, 0x0F42, 0x0FB7, 0x0F4C,
    0x0FB7, 0x0F51, 0x0FB7, 0x0F56, 0x0FB7, 0x0F5B, 0x0FB7, 0x0F40,
    0x0FB5, 0x0F71, 0x0F72, 0x0F71, 0x0F74, 0x0FB2, 0x0F80, 0x0FB2,
    0x0F81, 0x0FB3, 0x0F80, 0x0FB3, 0x0F81, 0x0F71, 0x0F80, 0x0F92,
    0x0FB7, 0x0F9C, 0x0FB7, 0x0FA1, 0x0FB7, 0x0FA6, 0x0FB7, 0x0FAB,
    0x0FB7, 0x0F90, 0x0FB5, 0x1025, 0x102E, 0x10DC, 0x1B05, 0x1B35,
    0x1B07, 0x1B35, 0x1B09, 0x1B35, 0x1B0B, 0x1B35, 0x1B0D, 0x1B35,
    0x1B11, 0x1B35, 0x1B3A, 0x1B35, 0x1B3C, 0x1B35, 0x1B3E, 0x1B35,
    0x1B3F, 0x1B35, 0x1B42, 0x1B35, 0x0041, 0x00C6, 0x0042, 0x0044,
    0x0045, 0x018E, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C,
    0x004D, 0x004E, 0x004F, 0x0222, 0x0050, 0x0052, 0x0054, 0x0055,
    0x0057, 0x0061, 0x0250, 0x0251, 0x1D02, 0x0062, 0x0064, 0x0065,
    0x0259, 0x025B, 0x025C, 0x0067, 0x006B, 0x006D, 0x014B, 0x006F,
    0x0254, 0x1D16, 0x1D17, 0x0070, 0x0074, 0x0075, 0x1D1D, 0x026F,
    0x0076, 0x1D25, 0x03B2, 0x03B3, 0x03B4, 0x03C6, 0x03C7, 0x0069,
    0x0072, 0x0075, 0x0076, 0x03B2, 0x03B3, 0x03C1, 0x03C6, 0x03C7,
    0x043D, 0x0252, 0x0063, 0x0255, 0x00F0, 0x025C, 0x0066, 0x025F,
    0x0261, 0x0265, 0x0268, 0x0269, 0x026A, 0x1D7B, 0x029D, 0x026D,
    0x1D85, 0x029F, 0x0271, 0x0270, 0x0272, 0x0273, 0x0274, 0x0275,
    0x0278, 0x0282, 0x0283, 0x01AB, 0x0289, 0x028A, 0x1D1C, 0x028B,
    0x028C, 0x007A, 0x0290, 0x0291, 0x0292, 0x03B8, 0x0041, 0x0325,
    0x0061, 0x0325, 0x0042, 0x0307, 0x0062, 0x0307, 0x0042, 0x0323,
    0x0062, 0x0323, 0x0042, 0x0331, 0x0062, 0x0331, 0x00C7, 0x0301,
    0x00E7, 0x0301, 0x0044, 0x0307, 0x0064, 0x0307, 0x0044, 0x0323,
    0x0064, 0x0323, 0x0044, 0x0331, 0x0064, 0x0331, 0x0044, 0x0327,
    0x0064, 0x0327, 0x0044, 0x032D, 0x0064, 0x032D, 0x0112, 0x0300,
    0x0113, 0x0300, 0x0112, 0x0301, 0x0113, 0x0301, 0x0045, 0x032D,
    0x0065, 0x032D, 0x0045, 0x0330, 0x0065, 0x0330, 0x0228, 0x0306,
    0x0229, 0x0306, 0x0046, 0x0307, 0x0066, 0x0307, 0x0047, 0x0304,
    0x0067, 0x0304, 0x0048, 0x0307, 0x0068, 0x0307, 0x0048, 0x0323,
    0x0068, 0x0323, 0x0048, 0x0308, 0x0068, 0x0308, 0x0048, 0x0327,
    0x0068, 0x0327, 0x0048, 0x032E, 0x0068, 0x032E, 0x0049, 0x0330,
    0x0069, 0x0330, 0x00CF, 0x0301, 0x00EF, 0x0301, 0x004B, 0x0301,
    0x006B, 0x0301, 0x004B, 0x0323, 0x006B, 0x0323, 0x004B, 0x0331,
    0x006B, 0x0331, 0x004C, 0x0323, 0x006C, 0x0323, 0x1E36, 0x0304,
    0x1E37, 0x0304, 0x004C, 0x0331, 0x006C, 0x0331, 0x004C, 0x032D,
    0x006C, 0x032D, 0x004D, 0x0301, 0x006D, 0x0301, 0x004D, 0x0307,
    0x006D, 0x0307, 0x004D, 0x0323, 0x006D, 0x0323, 0x004E, 0x0307,
    0x006E, 0x0307, 0x004E, 0x0323, 0x006E, 0x0323, 0x004E, 0x0331,
    0x006E, 0x0331, 0x004E, 0x032D, 0x006E, 0x032D, 0x00D5, 0x0301,
    0x00F5, 0x0301, 0x00D5, 0x0308, 0x00F5, 0x0308, 0x014C, 0x0300,
    0x014D, 0x0300, 0x014C, 0x0301, 0x014D, 0x0301, 0x0050, 0x0301,
    0x0070, 0x0301, 0x0050, 0x0307, 0x0070, 0x0307, 0x0052, 0x0307,
    0x0072, 0x0307, 0x0052, 0x0323, 0x0072, 0x0323, 0x1E5A, 0x0304,
    0x1E5B, 0x0304, 0x0052, 0x0331, 0x0072, 0x0331, 0x0053, 0x0307,
    0x0073, 0x0307, 0x0053, 0x0323, 0x0073, 0x0323, 0x015A, 0x0307,
    0x015B, 0x0307, 0x0160, 0x0307, 0x0161, 0x0307, 0x1E62, 0x0307,
    0x1E63, 0x0307, 0x0054, 0x0307, 0x0074, 0x0307, 0x0054, 0x0323,
    0x0074, 0x0323, 0x0054, 0x0331, 0x0074, 0x0331, 0x0054, 0x032D,
    0x0074, 0x032D, 0x0055, 0x0324, 0x0075, 0x0324, 0x0055, 0x0330,
    0x0075, 0x0330, 0x0055, 0x032D, 0x0075, 0x032D, 0x0168, 0x0301,
    0x0169, 0x0301, 0x016A, 0x0308, 0x016B, 0x0308, 0x0056, 0x0303,
    0x0076, 0x0303, 0x0056, 0x0323, 0x0076, 0x0323, 0x0057, 0x0300,
    0x0077, 0x0300, 0x0057, 0x0301, 0x0077, 0x0301, 0x0057, 0x0308,
    0x0077, 0x0308, 0x0057, 0x0307, 0x0077, 0x0307, 0x0057, 0x0323,
    0x0077, 0x0323, 0x0058, 0x0307, 0x0078, 0x0307, 0x0058, 0x0308,
    0x0078, 0x0308, 0x0059, 0x0307, 0x0079, 0x0307, 0x005A, 0x0302,
    0x007A, 0x0302, 0x005A, 0x0323, 0x007A, 0x0323, 0x005A, 0x0331,
    0x007A, 0x0331, 0x0068, 0x0331, 0x0074, 0x0308, 0x0077, 0x030A,
    0x0079, 0x030A, 0x0061, 0x02BE, 0x017F, 0x0307, 0x0041, 0x0323,
    0x0061, 0x0323, 0x0041, 0x0309, 0x0061, 0x0309, 0x00C2, 0x0301,
    0x00E2, 0x0301, 0x00C2, 0x0300, 0x00E2, 0x0300, 0x00C2, 0x0309,
    0x00E2, 0x0309, 0x00C2, 0x0303, 0x00E2, 0x0303, 0x1EA0, 0x0302,
    0x1EA1, 0x0302, 0x0102, 0x0301, 0x0103, 0x0301, 0x0102, 0x0300,
    0x0103, 0x0300, 0x0102, 0x0309, 0x0103, 0x0309, 0x0102, 0x0303,
    0x0103, 0x0303, 0x1EA0, 0x0306, 0x1EA1, 0x0306, 0x0045, 0x0323,
    0x0065, 0x0323, 0x0045, 0x0309, 0x0065, 0x0309, 0x0045, 0x0303,
    0x0065, 0x0303, 0x00CA, 0x0301, 0x00EA, 0x0301, 0x00CA, 0x0300,
    0x00EA, 0x0300, 0x00CA, 0x0309, 0x00EA, 0x0309, 0x00CA, 0x0303,
    0x00EA, 0x0303, 0x1EB8, 0x0302, 0x1EB9, 0x0302, 0x0049, 0x0309,
    0x0069, 0x0309, 0x0049, 0x0323, 0x0069, 0x0323, 0x004F, 0x0323,
    0x006F, 0x0323, 0x004F, 0x0309, 0x006F, 0x0309, 0x00D4, 0x0301,
    0x00F4, 0x0301, 0x00D4, 0x0300, 0x00F4, 0x0300, 0x00D4, 0x0309,
    0x00F4, 0x0309, 0x00D4, 0x0303, 0x00F4, 0x0303, 0x1ECC, 0x0302,
    0x1ECD, 0x0302, 0x01A0, 0x0301, 0x01A1, 0x0301, 0x01A0, 0x0300,
    0x01A1, 0x0300, 0x01A0, 0x0309, 0x01A1, 0x0309, 0x01A0, 0x0303,
    0x01A1, 0x0303, 0x01A0, 0x0323, 0x01A1, 0x0323, 0x0055, 0x0323,
    0x0075, 0x0323, 0x0055, 0x0309, 0x0075, 0x0309, 0x01AF, 0x0301,
    0x01B0, 0x0301, 0x01AF, 0x0300, 0x01B0, 0x0300, 0x01AF, 0x0309,
    0x01B0, 0x0309, 0x01AF, 0x0303, 0x01B0, 0x0303, 0x01AF, 0x0323,
    0x01B0, 0x0323, 0x0059, 0x0300, 0x0079, 0x0300, 0x0059, 0x0323,
    0x0079, 0x0323, 0x0059, 0x0309, 0x0079, 0x0309, 0x0059, 0x0303,
    0x0079, 0x0303, 0x03B1, 0x0313, 0x03B1, 0x0314, 0x1F00, 0x0300,
    0x1F01, 0x0300, 0x1F00, 0x0301, 0x1F01, 0x0301, 0x1F00, 0x0342,
    0x1F01, 0x0342, 0x0391, 0x0313, 0x0391, 0x0314, 0x1F08, 0x0300,
    0x1F09, 0x0300, 0x1F08, 0x0301, 0x1F09, 0x0301, 0x1F08, 0x0342,
    0x1F09, 0x0342, 0x03B5, 0x0313, 0x03B5, 0x0314, 0x1F10, 0x0300,
    0x1F11, 0x0300, 0x1F10, 0x0301, 0x1F11, 0x0301, 0x0395, 0x0313,
    0x0395, 0x0314, 0x1F18, 0x0300, 0x1F19, 0x0300, 0x1F18, 0x0301,
    0x1F19, 0x0301, 0x03B7, 0x0313, 0x03B7, 0x0314, 0x1F20, 0x0300,
    0x1F21, 0x0300, 0x1F20, 0x0301, 0x1F21, 0x0301, 0x1F20, 0x0342,
    0x1F21, 0x0342, 0x0397, 0x0313, 0x0397, 0x0314, 0x1F28, 0x0300,
    0x1F29, 0x0300, 0x1F28, 0x0301, 0x1F29, 0x0301, 0x1F28, 0x0342,
    0x1F29, 0x0342, 0x03B9, 0x0313, 0x03B9, 0x0314, 0x1F30, 0x0300,
    0x1F31, 0x0300, 0x1F30, 0x0301, 0x1F31, 0x0301, 0x1F30, 0x0342,
    0x1F31, 0x0342, 0x0399, 0x0313, 0x0399, 0x0314, 0x1F38, 0x0300,
    0x1F39, 0x0300, 0x1F38, 0x0301, 0x1F39, 0x0301, 0x1F38, 0x0342,
    0x1F39, 0x0342, 0x03BF, 0x0313, 0x03BF, 0x0314, 0x1F40, 0x0300,
    0x1F41, 0x0300, 0x1F40, 0x0301, 0x1F41, 0x0301, 0x039F, 0x0313,
    0x039F, 0x0314, 0x1F48, 0x0300, 0x1F49, 0x0300, 0x1F48, 0x0301,
    0x1F49, 0x0301, 0x03C5, 0x0313, 0x03C5, 0x0314, 0x1F50, 0x0300,
    0x1F51, 0x0300, 0x1F50, 0x0301, 0x1F51, 0x0301, 0x1F50, 0x0342,
    0x1F51, 0x0342, 0x03A5, 0x0314, 0x1F59, 0x0300, 0x1F59, 0x0301,
    0x1F59, 0x0342, 0x03C9, 0x0313, 0x03C9, 0x0314, 0x1F60, 0x0300,
    0x1F61, 0x0300, 0x1F60, 0x0301, 0x1F61, 0x0301, 0x1F60, 0x0342,
    0x1F61, 0x0342, 0x03A9, 0x0313, 0x03A9, 0x0314, 0x1F68, 0x0300,
    0x1F69, 0x0300, 0x1F68, 0x0301, 0x1F69, 0x0301, 0x1F68, 0x0342,
    0x1F69, 0x0342, 0x03B1, 0x0300, 0x03AC, 0x03B5, 0x0300, 0x03AD,
    0x03B7, 0x0300, 0x03AE, 0x03B9, 0x0300, 0x03AF, 0x03BF, 0x0300,
    0x03CC, 0x03C5, 0x0300, 0x03CD, 0x03C9, 0x0300, 0x03CE, 0x1F00,
    0x0345, 0x1F01, 0x0345, 0x1F02, 0x0345, 0x1F03, 0x0345, 0x1F04,
    0x0345, 0x1F05, 0x0345, 0x1F06, 0x0345, 0x1F07, 0x0345, 0x1F08,
    0x0345, 0x1F09, 0x0345, 0x1F0A, 0x0345, 0x1F0B, 0x0345, 0x1F0C,
    0x0345, 0x1F0D, 0x0345, 0x1F0E, 0x0345, 0x1F0F, 0x0345, 0x1F20,
    0x0345, 0x1F21, 0x0345, 0x1F22, 0x0345, 0x1F23, 0x0345, 0x1F24,
    0x0345, 0x1F25, 0x0345, 0x1F26, 0x0345, 0x1F27, 0x0345, 0x1F28,
    0x0345, 0x1F29, 0x0345, 0x1F2A, 0x0345, 0x1F2B, 0x0345, 0x1F2C,
    0x0345, 0x1F2D, 0x0345, 0x1F2E, 0x0345, 0x1F2F, 0x0345, 0x1F60,
    0x0345, 0x1F61, 0x0345, 0x1F62, 0x0345, 0x1F63, 0x0345, 0x1F64,
    0x0345, 0x1F65, 0x0345, 0x1F66, 0x0345, 0x1F67, 0x0345, 0x1F68,
    0x0345, 0x1F69, 0x0345, 0x1F6A, 0x0345, 0x1F6B, 0x0345, 0x1F6C,
    0x0345, 0x1F6D, 0x0345, 0x1F6E, 0x0345, 0x1F6F, 0x0345, 0x03B1,
    0x0306, 0x03B1, 0x0304, 0x1F70, 0x0345, 0x03B1, 0x0345, 0x03AC,
    0x0345, 0x03B1, 0x0342, 0x1FB6, 0x0345, 0x0391, 0x0306, 0x0391,
    0x0304, 0x0391, 0x0300, 0x0386, 0x0391, 0x0345, 0x0020, 0x0313,
    0x03B9, 0x0020, 0x0313, 0x0020, 0x0342, 0x00A8, 0x0342, 0x1F74,
    0x0345, 0x03B7, 0x0345, 0x03AE, 0x0345, 0x03B7, 0x0342, 0x1FC6,
    0x0345, 0x0395, 0x0300, 0x0388, 0x0397, 0x0300, 0x0389, 0x0397,
    0x0345, 0x1FBF, 0x0300, 0x1FBF, 0x0301, 0x1FBF, 0x0342, 0x03B9,
    0x0306, 0x03B9, 0x0304, 0x03CA, 0x0300, 0x0390, 0x03B9, 0x0342,
    0x03CA, 0x0342, 0x0399, 0x0306, 0x0399, 0x0304, 0x0399, 0x0300,
    0x038A, 0x1FFE, 0x0300, 0x1FFE, 0x0301, 0x1FFE, 0x0342, 0x03C5,
    0x0306, 0x03C5, 0x0304, 0x03CB, 0x0300, 0x03B0, 0x03C1, 0x0313,
    0x03C1, 0x0314, 0x03C5, 0x0342, 0x03CB, 0x0342, 0x03A5, 0x0306,
    0x03A5, 0x0304, 0x03A5, 0x0300, 0x038E, 0x03A1, 0x0314, 0x00A8,
    0x0300, 0x0385, 0x0060, 0x1F7C, 0x0345, 0x03C9, 0x0345, 0x03CE,
    0x0345, 0x03C9, 0x0342, 0x1FF6, 0x0345, 0x039F, 0x0300, 0x038C,
    0x03A9, 0x0300, 0x038F, 0x03A9, 0x0345, 0x00B4, 0x0020, 0x0314,
    0x2002, 0x2003, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020, 0x0020,
    0x0020, 0x0020, 0x0020, 0x2010, 0x0020, 0x0333, 0x002E, 0x002E,
    0x002E, 0x002E, 0x002E, 0x002E, 0x0020, 0x2032, 0x2032, 0x2032,
    0x2032, 0x2032, 0x2035, 0x2035, 0x2035, 0x2035, 0x2035, 0x0021,
    0x0021, 0x0020, 0x0305, 0x003F, 0x003F, 0x003F, 0x0021, 0x0021,
    0x003F, 0x2032, 0x2032, 0x2032, 0x2032, 0x0020, 0x0030, 0x0069,
    0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x002B, 0x2212,
    0x003D, 0x0028, 0x0029, 0x006E, 0x0030, 0x0031, 0x0032, 0x0033,
    0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x002B, 0x2212,
    0x003D, 0x0028, 0x0029, 0x0061, 0x0065, 0x006F, 0x0078, 0x0259,
    0x0068, 0x006B, 0x006C, 0x006D, 0x006E, 0x0070, 0x0073, 0x0074,
    0x0052, 0x0073, 0x0061, 0x002F, 0x0063, 0x0061, 0x002F, 0x0073,
    0x0043, 0x00B0, 0x0043, 0x0063, 0x002F, 0x006F, 0x0063, 0x002F,
    0x0075, 0x0190, 0x00B0, 0x0046, 0x0067, 0x0048, 0x0048, 0x0048,
    0x0068, 0x0127, 0x0049, 0x0049, 0x004C, 0x006C, 0x004E, 0x004E,
    0x006F, 0x0050, 0x0051, 0x0052, 0x0052, 0x0052, 0x0053, 0x004D,
    0x0054, 0x0045, 0x004C, 0x0054, 0x004D, 0x005A, 0x03A9, 0x005A,
    0x004B, 0x00C5, 0x0042, 0x0043, 0x0065, 0x0045, 0x0046, 0x004D,
    0x006F, 0x05D0, 0x05D1, 0x05D2, 0x05D3, 0x0069, 0x0046, 0x0041,
    0x0058, 0x03C0, 0x03B3, 0x0393, 0x03A0, 0x2211, 0x0044, 0x0064,
    0x0065, 0x0069, 0x006A, 0x0031, 0x2044, 0x0037, 0x0031, 0x2044,
    0x0039, 0x0031, 0x2044, 0x0031, 0x0030, 0x0031, 0x2044, 0x0033,
    0x0032, 0x2044, 0x0033, 0x0031, 0x2044, 0x0035, 0x0032, 0x2044,
    0x0035, 0x0033, 0x2044, 0x0035, 0x0034, 0x2044, 0x0035, 0x0031,
    0x2044, 0x0036, 0x0035, 0x2044, 0x0036, 0x0031, 0x2044, 0x0038,
    0x0033, 0x2044, 0x0038, 0x0035, 0x2044, 0x0038, 0x0037, 0x2044,
    0x0038, 0x0031, 0x2044, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0056, 0x0056, 0x0056, 0x0049, 0x0056, 0x0049,
    0x0049, 0x0056, 0x0049, 0x0049, 0x0049, 0x0049, 0x0058, 0x0058,
    0x0058, 0x0049, 0x0058, 0x0049, 0x0049, 0x004C, 0x0043, 0x0044,
    0x004D, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0069,
    0x0076, 0x0076, 0x0076, 0x0069, 0x0076, 0x0069, 0x0069, 0x0076,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0078, 0x0078, 0x0078, 0x0069,
    0x0078, 0x0069, 0x0069, 0x006C, 0x0063, 0x0064, 0x006D, 0x0030,
    0x2044, 0x0033, 0x2190, 0x0338, 0x2192, 0x0338, 0x2194, 0x0338,
    0x21D0, 0x0338, 0x21D4, 0x0338, 0x21D2, 0x0338, 0x2203, 0x0338,
    0x2208, 0x0338, 0x220B, 0x0338, 0x2223, 0x0338, 0x2225, 0x0338,
    0x222B, 0x222B, 0x222B, 0x222B, 0x222B, 0x222E, 0x222E, 0x222E,
    0x222E, 0x222E, 0x223C, 0x0338, 0x2243, 0x0338, 0x2245, 0x0338,
    0x2248, 0x0338, 0x003D, 0x0338, 0x2261, 0x0338, 0x224D, 0x0338,
    0x003C, 0x0338, 0x003E, 0x0338, 0x2264, 0x0338, 0x2265, 0x0338,
    0x2272, 0x0338, 0x2273, 0x0338, 0x2276, 0x0338, 0x2277, 0x0338,
    0x227A, 0x0338, 0x227B, 0x0338, 0x2282, 0x0338, 0x2283, 0x0338,
    0x2286, 0x0338, 0x2287, 0x0338, 0x22A2, 0x0338, 0x22A8, 0x0338,
    0x22A9, 0x0338, 0x22AB, 0x0338, 0x227C, 0x0338, 0x227D, 0x0338,
    0x2291, 0x0338, 0x2292, 0x0338, 0x22B2, 0x0338, 0x22B3, 0x0338,
    0x22B4, 0x0338, 0x22B5, 0x0338, 0x3008, 0x3009, 0x0031, 0x0032,
    0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x0031,
    0x0030, 0x0031, 0x0031, 0x0031, 0x0032, 0x0031, 0x0033, 0x0031,
    0x0034, 0x0031, 0x0035, 0x0031, 0x0036, 0x0031, 0x0037, 0x0031,
    0x0038, 0x0031, 0x0039, 0x0032, 0x0030, 0x0028, 0x0031, 0x0029,
    0x0028, 0x0032, 0x0029, 0x0028, 0x0033, 0x0029, 0x0028, 0x0034,
    0x0029, 0x0028, 0x0035, 0x0029, 0x0028, 0x0036, 0x0029, 0x0028,
    0x0037, 0x0029, 0x0028, 0x0038, 0x0029, 0x0028, 0x0039, 0x0029,
    0x0028, 0x0031, 0x0030, 0x0029, 0x0028, 0x0031, 0x0031, 0x0029,
    0x0028, 0x0031, 0x0032, 0x0029, 0x0028, 0x0031, 0x0033, 0x0029,
    0x0028, 0x0031, 0x0034, 0x0029, 0x0028, 0x0031, 0x0035, 0x0029,
    0x0028, 0x0031, 0x0036, 0x0029, 0x0028, 0x0031, 0x0037, 0x0029,
    0x0028, 0x0031, 0x0038, 0x0029, 0x0028, 0x0031, 0x0039, 0x0029,
    0x0028, 0x0032, 0x0030, 0x0029, 0x0031, 0x002E, 0x0032, 0x002E,
    0x0033, 0x002E, 0x0034, 0x002E, 0x0035, 0x002E, 0x0036, 0x002E,
    0x0037, 0x002E, 0x0038, 0x002E, 0x0039, 0x002E, 0x0031, 0x0030,
    0x002E, 0x0031, 0x0031, 0x002E, 0x0031, 0x0032, 0x002E, 0x0031,
    0x0033, 0x002E, 0x0031, 0x0034, 0x002E, 0x0031, 0x0035, 0x002E,
    0x0031, 0x0036, 0x002E, 0x0031, 0x0037, 0x002E, 0x0031, 0x0038,
    0x002E, 0x0031, 0x0039, 0x002E, 0x0032, 0x0030, 0x002E, 0x0028,
    0x0061, 0x0029, 0x0028, 0x0062, 0x0029, 0x0028, 0x0063, 0x0029,
    0x0028, 0x0064, 0x0029, 0x0028, 0x0065, 0x0029, 0x0028, 0x0066,
    0x0029, 0x0028, 0x0067, 0x0029, 0x0028, 0x0068, 0x0029, 0x0028,
    0x0069, 0x0029, 0x0028, 0x006A, 0x0029, 0x0028, 0x006B, 0x0029,
    0x0028, 0x006C, 0x0029, 0x0028, 0x006D, 0x0029, 0x0028, 0x006E,
    0x0029, 0x0028, 0x006F, 0x0029, 0x0028, 0x0070, 0x0029, 0x0028,
    0x0071, 0x0029, 0x0028, 0x0072, 0x0029, 0x0028, 0x0073, 0x0029,
    0x0028, 0x0074, 0x0029, 0x0028, 0x0075, 0x0029, 0x0028, 0x0076,
    0x0029, 0x0028, 0x0077, 0x0029, 0x0028, 0x0078, 0x0029, 0x0028,
    0x0079, 0x0029, 0x0028, 0x007A, 0x0029, 0x0041, 0x0042, 0x0043,
    0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B,
    0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053,
    0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x0061,
    0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069,
    0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071,
    0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079,
    0x007A, 0x0030, 0x222B, 0x222B, 0x222B, 0x222B, 0x003A, 0x003A,
    0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x003D, 0x2ADD, 0x0338,
    0x006A, 0x0056, 0x2D61, 0x6BCD, 0x9F9F, 0x4E00, 0x4E28, 0x4E36,
    0x4E3F, 0x4E59, 0x4E85, 0x4E8C, 0x4EA0, 0x4EBA, 0x513F, 0x5165,
    0x516B, 0x5182, 0x5196, 0x51AB, 0x51E0, 0x51F5, 0x5200, 0x529B,
    0x52F9, 0x5315, 0x531A, 0x5338, 0x5341, 0x535C, 0x5369, 0x5382,
    0x53B6, 0x53C8, 0x53E3, 0x56D7, 0x571F, 0x58EB, 0x5902, 0x590A,
    0x5915, 0x5927, 0x5973, 0x5B50, 0x5B80, 0x5BF8, 0x5C0F, 0x5C22,
    0x5C38, 0x5C6E, 0x5C71, 0x5DDB, 0x5DE5, 0x5DF1, 0x5DFE, 0x5E72,
    0x5E7A, 0x5E7F, 0x5EF4, 0x5EFE, 0x5F0B, 0x5F13, 0x5F50, 0x5F61,
    0x5F73, 0x5FC3, 0x6208, 0x6236, 0x624B, 0x652F, 0x6534, 0x6587,
    0x6597, 0x65A4, 0x65B9, 0x65E0, 0x65E5, 0x66F0, 0x6708, 0x6728,
    0x6B20, 0x6B62, 0x6B79, 0x6BB3, 0x6BCB, 0x6BD4, 0x6BDB, 0x6C0F,
    0x6C14, 0x6C34, 0x706B, 0x722A, 0x7236, 0x723B, 0x723F, 0x7247,
    0x7259, 0x725B, 0x72AC, 0x7384, 0x7389, 0x74DC, 0x74E6, 0x7518,
    0x751F, 0x7528, 0x7530, 0x758B, 0x7592, 0x7676, 0x767D, 0x76AE,
    0x76BF, 0x76EE, 0x77DB, 0x77E2, 0x77F3, 0x793A, 0x79B8, 0x79BE,
    0x7A74, 0x7ACB, 0x7AF9, 0x7C73, 0x7CF8, 0x7F36, 0x7F51, 0x7F8A,
    0x7FBD, 0x8001, 0x800C, 0x8012, 0x8033, 0x807F, 0x8089, 0x81E3,
    0x81EA, 0x81F3, 0x81FC, 0x820C, 0x821B, 0x821F, 0x826E, 0x8272,
    0x8278, 0x864D, 0x866B, 0x8840, 0x884C, 0x8863, 0x897E, 0x898B,
    0x89D2, 0x8A00, 0x8C37, 0x8C46, 0x8C55, 0x8C78, 0x8C9D, 0x8D64,
    0x8D70, 0x8DB3, 0x8EAB, 0x8ECA, 0x8F9B, 0x8FB0, 0x8FB5, 0x9091,
    0x9149, 0x91C6, 0x91CC, 0x91D1, 0x9577, 0x9580, 0x961C, 0x96B6,
    0x96B9, 0x96E8, 0x9751, 0x975E, 0x9762, 0x9769, 0x97CB, 0x97ED,
    0x97F3, 0x9801, 0x98A8, 0x98DB, 0x98DF, 0x9996, 0x9999, 0x99AC,
    0x9AA8, 0x9AD8, 0x9ADF, 0x9B25, 0x9B2F, 0x9B32, 0x9B3C, 0x9B5A,
    0x9CE5, 0x9E75, 0x9E7F, 0x9EA5, 0x9EBB, 0x9EC3, 0x9ECD, 0x9ED1,
    0x9EF9, 0x9EFD, 0x9F0E, 0x9F13, 0x9F20, 0x9F3B, 0x9F4A, 0x9F52,
    0x9F8D, 0x9F9C, 0x9FA0, 0x0020, 0x3012, 0x5341, 0x5344, 0x5345,
    0x304B, 0x3099, 0x304D, 0x3099, 0x304F, 0x3099, 0x3051, 0x3099,
    0x3053, 0x3099, 0x3055, 0x3099, 0x3057, 0x3099, 0x3059, 0x3099,
    0x305B, 0x3099, 0x305D, 0x3099, 0x305F, 0x3099, 0x3061, 0x3099,
    0x3064, 0x3099, 0x3066, 0x3099, 0x3068, 0x3099, 0x306F, 0x3099,
    0x306F, 0x309A, 0x3072, 0x3099, 0x3072, 0x309A, 0x3075, 0x3099,
    0x3075, 0x309A, 0x3078, 0x3099, 0x3078, 0x309A, 0x307B, 0x3099,
    0x307B, 0x309A, 0x3046, 0x3099, 0x0020, 0x3099, 0x0020, 0x309A,
    0x309D, 0x3099, 0x3088, 0x308A, 0x30AB, 0x3099, 0x30AD, 0x3099,
    0x30AF, 0x3099, 0x30B1, 0x3099, 0x30B3, 0x3099, 0x30B5, 0x3099,
    0x30B7, 0x3099, 0x30B9, 0x3099, 0x30BB, 0x3099, 0x30BD, 0x3099,
    0x30BF, 0x3099, 0x30C1, 0x3099, 0x30C4, 0x3099, 0x30C6, 0x3099,
    0x30C8, 0x3099, 0x30CF, 0x3099, 0x30CF, 0x309A, 0x30D2, 0x3099,
    0x30D2, 0x309A, 0x30D5, 0x3099, 0x30D5, 0x309A, 0x30D8, 0x3099,
    0x30D8, 0x309A, 0x30DB, 0x3099, 0x30DB, 0x309A, 0x30A6, 0x3099,
    0x30EF, 0x3099, 0x30F0, 0x3099, 0x30F1, 0x3099, 0x30F2, 0x3099,
    0x30FD, 0x3099, 0x30B3, 0x30C8, 0x1100, 0x1101, 0x11AA, 0x1102,
    0x11AC, 0x11AD, 0x1103, 0x1104, 0x1105, 0x11B0, 0x11B1, 0x11B2,
    0x11B3, 0x11B4, 0x11B5, 0x111A, 0x1106, 0x1107, 0x1108, 0x1121,
    0x1109, 0x110A, 0x110B, 0x110C, 0x110D, 0x110E, 0x110F, 0x1110,
    0x1111, 0x1112, 0x1161, 0x1162, 0x1163, 0x1164, 0x1165, 0x1166,
    0x1167, 0x1168, 0x1169, 0x116A, 0x116B, 0x116C, 0x116D, 0x116E,
    0x116F, 0x1170, 0x1171, 0x1172, 0x1173, 0x1174, 0x1175, 0x1160,
    0x1114, 0x1115, 0x11C7, 0x11C8, 0x11CC, 0x11CE, 0x11D3, 0x11D7,
    0x11D9, 0x111C, 0x11DD, 0x11DF, 0x111D, 0x111E, 0x1120, 0x1122,
    0x1123, 0x1127, 0x1129, 0x112B, 0x112C, 0x112D, 0x112E, 0x112F,
    0x1132, 0x1136, 0x1140, 0x1147, 0x114C, 0x11F1, 0x11F2, 0x1157,
    0x1158, 0x1159, 0x1184, 0x1185, 0x1188, 0x1191, 0x1192, 0x1194,
    0x119E, 0x11A1, 0x4E00, 0x4E8C, 0x4E09, 0x56DB, 0x4E0A, 0x4E2D,
    0x4E0B, 0x7532, 0x4E59, 0x4E19, 0x4E01, 0x5929, 0x5730, 0x4EBA,
    0x0028, 0x1100, 0x0029, 0x0028, 0x1102, 0x0029, 0x0028, 0x1103,
    0x0029, 0x0028, 0x1105, 0x0029, 0x0028, 0x1106, 0x0029, 0x0028,
    0x1107, 0x0029, 0x0028, 0x1109, 0x0029, 0x0028, 0x110B, 0x0029,
    0x0028, 0x110C, 0x0029, 0x0028, 0x110E, 0x0029, 0x0028, 0x110F,
    0x0029, 0x0028, 0x1110, 0x0029, 0x0028, 0x1111, 0x0029, 0x0028,
    0x1112, 0x0029, 0x0028, 0x1100, 0x1161, 0x0029, 0x0028, 0x1102,
    0x1161, 0x0029, 0x0028, 0x1103, 0x1161, 0x0029, 0x0028, 0x1105,
    0x1161, 0x0029, 0x0028, 0x1106, 0x1161, 0x0029, 0x0028, 0x1107,
    0x1161, 0x0029, 0x0028, 0x1109, 0x1161, 0x0029, 0x0028, 0x110B,
    0x1161, 0x0029, 0x0028, 0x110C, 0x1161, 0x0029, 0x0028, 0x110E,
    0x1161, 0x0029, 0x0028, 0x110F, 0x1161, 0x0029, 0x0028, 0x1110,
    0x1161, 0x0029, 0x0028, 0x1111, 0x1161, 0x0029, 0x0028, 0x1112,
    0x1161, 0x0029, 0x0028, 0x110C, 0x116E, 0x0029, 0x0028, 0x110B,
    0x1169, 0x110C, 0x1165, 0x11AB, 0x0029, 0x0028, 0x110B, 0x1169,
    0x1112, 0x116E, 0x0029, 0x0028, 0x4E00, 0x0029, 0x0028, 0x4E8C,
    0x0029, 0x0028, 0x4E09, 0x0029, 0x0028, 0x56DB, 0x0029, 0x0028,
    0x4E94, 0x0029, 0x0028, 0x516D, 0x0029, 0x0028, 0x4E03, 0x0029,
    0x0028, 0x516B, 0x0029, 0x0028, 0x4E5D, 0x0029, 0x0028, 0x5341,
    0x0029, 0x0028, 0x6708, 0x0029, 0x0028, 0x706B, 0x0029, 0x0028,
    0x6C34, 0x0029, 0x0028, 0x6728, 0x0029, 0x0028, 0x91D1, 0x0029,
    0x0028, 0x571F, 0x0029, 0x0028, 0x65E5, 0x0029, 0x0028, 0x682A,
    0x0029, 0x0028, 0x6709, 0x0029, 0x0028, 0x793E, 0x0029, 0x0028,
    0x540D, 0x0029, 0x0028, 0x7279, 0x0029, 0x0028, 0x8CA1, 0x0029,
    0x0028, 0x795D, 0x0029, 0x0028, 0x52B4, 0x0029, 0x0028, 0x4EE3,
    0x0029, 0x0028, 0x547C, 0x0029, 0x0028, 0x5B66, 0x0029, 0x0028,
    0x76E3, 0x0029, 0x0028, 0x4F01, 0x0029, 0x0028, 0x8CC7, 0x0029,
    0x0028, 0x5354, 0x0029, 0x0028, 0x796D, 0x0029, 0x0028, 0x4F11,
    0x0029, 0x0028, 0x81EA, 0x0029, 0x0028, 0x81F3, 0x0029, 0x554F,
    0x5E7C, 0x6587, 0x7B8F, 0x0050, 0x0054, 0x0045, 0x0032, 0x0031,
    0x0032, 0x0032, 0x0032, 0x0033, 0x0032, 0x0034, 0x0032, 0x0035,
    0x0032, 0x0036, 0x0032, 0x0037, 0x0032, 0x0038, 0x0032, 0x0039,
    0x0033, 0x0030, 0x0033, 0x0031, 0x0033, 0x0032, 0x0033, 0x0033,
    0x0033, 0x0034, 0x0033, 0x0035, 0x1100, 0x1102, 0x1103, 0x1105,
    0x1106, 0x1107, 0x1109, 0x110B, 0x110C, 0x110E, 0x110F, 0x1110,
    0x1111, 0x1112, 0x1100, 0x1161, 0x1102, 0x1161, 0x1103, 0x1161,
    0x1105, 0x1161, 0x1106, 0x1161, 0x1107, 0x1161, 0x1109, 0x1161,
    0x110B, 0x1161, 0x110C, 0x1161, 0x110E, 0x1161, 0x110F, 0x1161,
    0x1110, 0x1161, 0x1111, 0x1161, 0x1112, 0x1161, 0x110E, 0x1161,
    0x11B7, 0x1100, 0x1169, 0x110C, 0x116E, 0x110B, 0x1174, 0x110B,
    0x116E, 0x4E00, 0x4E8C, 0x4E09, 0x56DB, 0x4E94, 0x516D, 0x4E03,
    0x516B, 0x4E5D, 0x5341, 0x6708, 0x706B, 0x6C34, 0x6728, 0x91D1,
    0x571F, 0x65E5, 0x682A, 0x6709, 0x793E, 0x540D, 0x7279, 0x8CA1,
    0x795D, 0x52B4, 0x79D8, 0x7537, 0x5973, 0x9069, 0x512A, 0x5370,
    0x6CE8, 0x9805, 0x4F11, 0x5199, 0x6B63, 0x4E0A, 0x4E2D, 0x4E0B,
    0x5DE6, 0x53F3, 0x533B, 0x5B97, 0x5B66, 0x76E3, 0x4F01, 0x8CC7,
    0x5354, 0x591C, 0x0033, 0x0036, 0x0033, 0x0037, 0x0033, 0x0038,
    0x0033, 0x0039, 0x0034, 0x0030, 0x0034, 0x0031, 0x0034, 0x0032,
    0x0034, 0x0033, 0x0034, 0x0034, 0x0034, 0x0035, 0x0034, 0x0036,
    0x0034, 0x0037, 0x0034, 0x0038, 0x0034, 0x0039, 0x0035, 0x0030,
    0x0031, 0x6708, 0x0032, 0x6708, 0x0033, 0x6708, 0x0034, 0x6708,
    0x0035, 0x6708, 0x0036, 0x6708, 0x0037, 0x6708, 0x0038, 0x6708,
    0x0039, 0x6708, 0x0031, 0x0030, 0x6708, 0x0031, 0x0031, 0x6708,
    0x0031, 0x0032, 0x6708, 0x0048, 0x0067, 0x0065, 0x0072, 0x0067,
    0x0065, 0x0056, 0x004C, 0x0054, 0x0044, 0x30A2, 0x30A4, 0x30A6,
    0x30A8, 0x30AA, 0x30AB, 0x30AD, 0x30AF, 0x30B1, 0x30B3, 0x30B5,
    0x30B7, 0x30B9, 0x30BB, 0x30BD, 0x30BF, 0x30C1, 0x30C4, 0x30C6,
    0x30C8, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D2,
    0x30D5, 0x30D8, 0x30DB, 0x30DE, 0x30DF, 0x30E0, 0x30E1, 0x30E2,
    0x30E4, 0x30E6, 0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED,
    0x30EF, 0x30F0, 0x30F1, 0x30F2, 0x4EE4, 0x548C, 0x30A2, 0x30D1,
    0x30FC, 0x30C8, 0x30A2, 0x30EB, 0x30D5, 0x30A1, 0x30A2, 0x30F3,
    0x30DA, 0x30A2, 0x30A2, 0x30FC, 0x30EB, 0x30A4, 0x30CB, 0x30F3,
    0x30B0, 0x30A4, 0x30F3, 0x30C1, 0x30A6, 0x30A9, 0x30F3, 0x30A8,
    0x30B9, 0x30AF, 0x30FC, 0x30C9, 0x30A8, 0x30FC, 0x30AB, 0x30FC,
    0x30AA, 0x30F3, 0x30B9, 0x30AA, 0x30FC, 0x30E0, 0x30AB, 0x30A4,
    0x30EA, 0x30AB, 0x30E9, 0x30C3, 0x30C8, 0x30AB, 0x30ED, 0x30EA,
    0x30FC, 0x30AC, 0x30ED, 0x30F3, 0x30AC, 0x30F3, 0x30DE, 0x30AE,
    0x30AC, 0x30AE, 0x30CB, 0x30FC, 0x30AD, 0x30E5, 0x30EA, 0x30FC,
    0x30AE, 0x30EB, 0x30C0, 0x30FC, 0x30AD, 0x30ED, 0x30AD, 0x30ED,
    0x30B0, 0x30E9, 0x30E0, 0x30AD, 0x30ED, 0x30E1, 0x30FC, 0x30C8,
    0x30EB, 0x30AD, 0x30ED, 0x30EF, 0x30C3, 0x30C8, 0x30B0, 0x30E9,
    0x30E0, 0x30B0, 0x30E9, 0x30E0, 0x30C8, 0x30F3, 0x30AF, 0x30EB,
    0x30BC, 0x30A4, 0x30ED, 0x30AF, 0x30ED, 0x30FC, 0x30CD, 0x30B1,
    0x30FC, 0x30B9, 0x30B3, 0x30EB, 0x30CA, 0x30B3, 0x30FC, 0x30DD,
    0x30B5, 0x30A4, 0x30AF, 0x30EB, 0x30B5, 0x30F3, 0x30C1, 0x30FC,
    0x30E0, 0x30B7, 0x30EA, 0x30F3, 0x30B0, 0x30BB, 0x30F3, 0x30C1,
    0x30BB, 0x30F3, 0x30C8, 0x30C0, 0x30FC, 0x30B9, 0x30C7, 0x30B7,
    0x30C9, 0x30EB, 0x30C8, 0x30F3, 0x30CA, 0x30CE, 0x30CE, 0x30C3,
    0x30C8, 0x30CF, 0x30A4, 0x30C4, 0x30D1, 0x30FC, 0x30BB, 0x30F3,
    0x30C8, 0x30D1, 0x30FC, 0x30C4, 0x30D0, 0x30FC, 0x30EC, 0x30EB,
    0x30D4, 0x30A2, 0x30B9, 0x30C8, 0x30EB, 0x30D4, 0x30AF, 0x30EB,
    0x30D4, 0x30B3, 0x30D3, 0x30EB, 0x30D5, 0x30A1, 0x30E9, 0x30C3,
    0x30C9, 0x30D5, 0x30A3, 0x30FC, 0x30C8, 0x30D6, 0x30C3, 0x30B7,
    0x30A7, 0x30EB, 0x30D5, 0x30E9, 0x30F3, 0x30D8, 0x30AF, 0x30BF,
    0x30FC, 0x30EB, 0x30DA, 0x30BD, 0x30DA, 0x30CB, 0x30D2, 0x30D8,
    0x30EB, 0x30C4, 0x30DA, 0x30F3, 0x30B9, 0x30DA, 0x30FC, 0x30B8,
    0x30D9, 0x30FC, 0x30BF, 0x30DD, 0x30A4, 0x30F3, 0x30C8, 0x30DC,
    0x30EB, 0x30C8, 0x30DB, 0x30F3, 0x30DD, 0x30F3, 0x30C9, 0x30DB,
    0x30FC, 0x30EB, 0x30DB, 0x30FC, 0x30F3, 0x30DE, 0x30A4, 0x30AF,
    0x30ED, 0x30DE, 0x30A4, 0x30EB, 0x30DE, 0x30C3, 0x30CF, 0x30DE,
    0x30EB, 0x30AF, 0x30DE, 0x30F3, 0x30B7, 0x30E7, 0x30F3, 0x30DF,
    0x30AF, 0x30ED, 0x30F3, 0x30DF, 0x30EA, 0x30DF, 0x30EA, 0x30D0,
    0x30FC, 0x30EB, 0x30E1, 0x30AC, 0x30E1, 0x30AC, 0x30C8, 0x30F3,
    0x30E1, 0x30FC, 0x30C8, 0x30EB, 0x30E4, 0x30FC, 0x30C9, 0x30E4,
    0x30FC, 0x30EB, 0x30E6, 0x30A2, 0x30F3, 0x30EA, 0x30C3, 0x30C8,
    0x30EB, 0x30EA, 0x30E9, 0x30EB, 0x30D4, 0x30FC, 0x30EB, 0x30FC,
    0x30D6, 0x30EB, 0x30EC, 0x30E0, 0x30EC, 0x30F3, 0x30C8, 0x30B2,
    0x30F3, 0x30EF, 0x30C3, 0x30C8, 0x0030, 0x70B9, 0x0031, 0x70B9,
    0x0032, 0x70B9, 0x0033, 0x70B9, 0x0034, 0x70B9, 0x0035, 0x70B9,
    0x0036, 0x70B9, 0x0037, 0x70B9, 0x0038, 0x70B9, 0x0039, 0x70B9,
    0x0031, 0x0030, 0x70B9, 0x0031, 0x0031, 0x70B9, 0x0031, 0x0032,
    0x70B9, 0x0031, 0x0033, 0x70B9, 0x0031, 0x0034, 0x70B9, 0x0031,
    0x0035, 0x70B9, 0x0031, 0x0036, 0x70B9, 0x0031, 0x0037, 0x70B9,
    0x0031, 0x0038, 0x70B9, 0x0031, 0x0039, 0x70B9, 0x0032, 0x0030,
    0x70B9, 0x0032, 0x0031, 0x70B9, 0x0032, 0x0032, 0x70B9, 0x0032,
    0x0033, 0x70B9, 0x0032, 0x0034, 0x70B9, 0x0068, 0x0050, 0x0061,
    0x0064, 0x0061, 0x0041, 0x0055, 0x0062, 0x0061, 0x0072, 0x006F,
    0x0056, 0x0070, 0x0063, 0x0064, 0x006D, 0x0064, 0x006D, 0x00B2,
    0x0064, 0x006D, 0x00B3, 0x0049, 0x0055, 0x5E73, 0x6210, 0x662D,
    0x548C, 0x5927, 0x6B63, 0x660E, 0x6CBB, 0x682A, 0x5F0F, 0x4F1A,
    0x793E, 0x0070, 0x0041, 0x006E, 0x0041, 0x03BC, 0x0041, 0x006D,
    0x0041, 0x006B, 0x0041, 0x004B, 0x0042, 0x004D, 0x0042, 0x0047,
    0x0042, 0x0063, 0x0061, 0x006C, 0x006B, 0x0063, 0x0061, 0x006C,
    0x0070, 0x0046, 0x006E, 0x0046, 0x03BC, 0x0046, 0x03BC, 0x0067,
    0x006D, 0x0067, 0x006B, 0x0067, 0x0048, 0x007A, 0x006B, 0x0048,
    0x007A, 0x004D, 0x0048, 0x007A, 0x0047, 0x0048, 0x007A, 0x0054,
    0x0048, 0x007A, 0x03BC, 0x2113, 0x006D, 0x2113, 0x0064, 0x2113,
    0x006B, 0x2113, 0x0066, 0x006D, 0x006E, 0x006D, 0x03BC, 0x006D,
    0x006D, 0x006D, 0x0063, 0x006D, 0x006B, 0x006D, 0x006D, 0x006D,
    0x00B2, 0x0063, 0x006D, 0x00B2, 0x006D, 0x00B2, 0x006B, 0x006D,
    0x00B2, 0x006D, 0x006D, 0x00B3, 0x0063, 0x006D, 0x00B3, 0x006D,
    0x00B3, 0x006B, 0x006D, 0x00B3, 0x006D, 0x2215, 0x0073, 0x006D,
    0x2215, 0x0073, 0x00B2, 0x0050, 0x0061, 0x006B, 0x0050, 0x0061,
    0x004D, 0x0050, 0x0061, 0x0047, 0x0050, 0x0061, 0x0072, 0x0061,
    0x0064, 0x0072, 0x0061, 0x0064, 0x2215, 0x0073, 0x0072, 0x0061,
    0x0064, 0x2215, 0x0073, 0x00B2, 0x0070, 0x0073, 0x006E, 0x0073,
    0x03BC, 0x0073, 0x006D, 0x0073, 0x0070, 0x0056, 0x006E, 0x0056,
    0x03BC, 0x0056, 0x006D, 0x0056, 0x006B, 0x0056, 0x004D, 0x0056,
    0x0070, 0x0057, 0x006E, 0x0057, 0x03BC, 0x0057, 0x006D, 0x0057,
    0x006B, 0x0057, 0x004D, 0x0057, 0x006B, 0x03A9, 0x004D, 0x03A9,
    0x0061, 0x002E, 0x006D, 0x002E, 0x0042, 0x0071, 0x0063, 0x0063,
    0x0063, 0x0064, 0x0043, 0x2215, 0x006B, 0x0067, 0x0043, 0x006F,
    0x002E, 0x0064, 0x0042, 0x0047, 0x0079, 0x0068, 0x0061, 0x0048,
    0x0050, 0x0069, 0x006E, 0x004B, 0x004B, 0x004B, 0x004D, 0x006B,
    0x0074, 0x006C, 0x006D, 0x006C, 0x006E, 0x006C, 0x006F, 0x0067,
    0x006C, 0x0078, 0x006D, 0x0062, 0x006D, 0x0069, 0x006C, 0x006D,
    0x006F, 0x006C, 0x0050, 0x0048, 0x0070, 0x002E, 0x006D, 0x002E,
    0x0050, 0x0050, 0x004D, 0x0050, 0x0052, 0x0073, 0x0072, 0x0053,
    0x0076, 0x0057, 0x0062, 0x0056, 0x2215, 0x006D, 0x0041, 0x2215,
    0x006D, 0x0031, 0x65E5, 0x0032, 0x65E5, 0x0033, 0x65E5, 0x0034,
    0x65E5, 0x0035, 0x65E5, 0x0036, 0x65E5, 0x0037, 0x65E5, 0x0038,
    0x65E5, 0x0039, 0x65E5, 0x0031, 0x0030, 0x65E5, 0x0031, 0x0031,
    0x65E5, 0x0031, 0x0032, 0x65E5, 0x0031, 0x0033, 0x65E5, 0x0031,
    0x0034, 0x65E5, 0x0031, 0x0035, 0x65E5, 0x0031, 0x0036, 0x65E5,
    0x0031, 0x0037, 0x65E5, 0x0031, 0x0038, 0x65E5, 0x0031, 0x0039,
    0x65E5, 0x0032, 0x0030, 0x65E5, 0x0032, 0x0031, 0x65E5, 0x0032,
    0x0032, 0x65E5, 0x0032, 0x0033, 0x65E5, 0x0032, 0x0034, 0x65E5,
    0x0032, 0x0035, 0x65E5, 0x0032, 0x0036, 0x65E5, 0x0032, 0x0037,
    0x65E5, 0x0032, 0x0038, 0x65E5, 0x0032, 0x0039, 0x65E5, 0x0033,
    0x0030, 0x65E5, 0x0033, 0x0031, 0x65E5, 0x0067, 0x0061, 0x006C,
    0x044A, 0x044C, 0xA76F, 0x0126, 0x0153, 0xA727, 0xAB37, 0x026B,
    0xAB52, 0x028D, 0x8C48, 0x66F4, 0x8ECA, 0x8CC8, 0x6ED1, 0x4E32,
    0x53E5, 0x9F9C, 0x9F9C, 0x5951, 0x91D1, 0x5587, 0x5948, 0x61F6,
    0x7669, 0x7F85, 0x863F, 0x87BA, 0x88F8, 0x908F, 0x6A02, 0x6D1B,
    0x70D9, 0x73DE, 0x843D, 0x916A, 0x99F1, 0x4E82, 0x5375, 0x6B04,
    0x721B, 0x862D, 0x9E1E, 0x5D50, 0x6FEB, 0x85CD, 0x8964, 0x62C9,
    0x81D8, 0x881F, 0x5ECA, 0x6717, 0x6D6A, 0x72FC, 0x90CE, 0x4F86,
    0x51B7, 0x52DE, 0x64C4, 0x6AD3, 0x7210, 0x76E7, 0x8001, 0x8606,
    0x865C, 0x8DEF, 0x9732, 0x9B6F, 0x9DFA, 0x788C, 0x797F, 0x7DA0,
    0x83C9, 0x9304, 0x9E7F, 0x8AD6, 0x58DF, 0x5F04, 0x7C60, 0x807E,
    0x7262, 0x78CA, 0x8CC2, 0x96F7, 0x58D8, 0x5C62, 0x6A13, 0x6DDA,
    0x6F0F, 0x7D2F, 0x7E37, 0x964B, 0x52D2, 0x808B, 0x51DC, 0x51CC,
    0x7A1C, 0x7DBE, 0x83F1, 0x9675, 0x8B80, 0x62CF, 0x6A02, 0x8AFE,
    0x4E39, 0x5BE7, 0x6012, 0x7387, 0x7570, 0x5317, 0x78FB, 0x4FBF,
    0x5FA9, 0x4E0D, 0x6CCC, 0x6578, 0x7D22, 0x53C3, 0x585E, 0x7701,
    0x8449, 0x8AAA, 0x6BBA, 0x8FB0, 0x6C88, 0x62FE, 0x82E5, 0x63A0,
    0x7565, 0x4EAE, 0x5169, 0x51C9, 0x6881, 0x7CE7, 0x826F, 0x8AD2,
    0x91CF, 0x52F5, 0x5442, 0x5973, 0x5EEC, 0x65C5, 0x6FFE, 0x792A,
    0x95AD, 0x9A6A, 0x9E97, 0x9ECE, 0x529B, 0x66C6, 0x6B77, 0x8F62,
    0x5E74, 0x6190, 0x6200, 0x649A, 0x6F23, 0x7149, 0x7489, 0x79CA,
    0x7DF4, 0x806F, 0x8F26, 0x84EE, 0x9023, 0x934A, 0x5217, 0x52A3,
    0x54BD, 0x70C8, 0x88C2, 0x8AAA, 0x5EC9, 0x5FF5, 0x637B, 0x6BAE,
    0x7C3E, 0x7375, 0x4EE4, 0x56F9, 0x5BE7, 0x5DBA, 0x601C, 0x73B2,
    0x7469, 0x7F9A, 0x8046, 0x9234, 0x96F6, 0x9748, 0x9818, 0x4F8B,
    0x79AE, 0x91B4, 0x96B8, 0x60E1, 0x4E86, 0x50DA, 0x5BEE, 0x5C3F,
    0x6599, 0x6A02, 0x71CE, 0x7642, 0x84FC, 0x907C, 0x9F8D, 0x6688,
    0x962E, 0x5289, 0x677B, 0x67F3, 0x6D41, 0x6E9C, 0x7409, 0x7559,
    0x786B, 0x7D10, 0x985E, 0x516D, 0x622E, 0x9678, 0x502B, 0x5D19,
    0x6DEA, 0x8F2A, 0x5F8B, 0x6144, 0x6817, 0x7387, 0x9686, 0x5229,
    0x540F, 0x5C65, 0x6613, 0x674E, 0x68A8, 0x6CE5, 0x7406, 0x75E2,
    0x7F79, 0x88CF, 0x88E1, 0x91CC, 0x96E2, 0x533F, 0x6EBA, 0x541D,
    0x71D0, 0x7498, 0x85FA, 0x96A3, 0x9C57, 0x9E9F, 0x6797, 0x6DCB,
    0x81E8, 0x7ACB, 0x7B20, 0x7C92, 0x72C0, 0x7099, 0x8B58, 0x4EC0,
    0x8336, 0x523A, 0x5207, 0x5EA6, 0x62D3, 0x7CD6, 0x5B85, 0x6D1E,
    0x66B4, 0x8F3B, 0x884C, 0x964D, 0x898B, 0x5ED3, 0x5140, 0x55C0,
    0x585A, 0x6674, 0x51DE, 0x732A, 0x76CA, 0x793C, 0x795E, 0x7965,
    0x798F, 0x9756, 0x7CBE, 0x7FBD, 0x8612, 0x8AF8, 0x9038, 0x90FD,
    0x98EF, 0x98FC, 0x9928, 0x9DB4, 0x90DE, 0x96B7, 0x4FAE, 0x50E7,
    0x514D, 0x52C9, 0x52E4, 0x5351, 0x559D, 0x5606, 0x5668, 0x5840,
    0x58A8, 0x5C64, 0x5C6E, 0x6094, 0x6168, 0x618E, 0x61F2, 0x654F,
    0x65E2, 0x6691, 0x6885, 0x6D77, 0x6E1A, 0x6F22, 0x716E, 0x722B,
    0x7422, 0x7891, 0x793E, 0x7949, 0x7948, 0x7950, 0x7956, 0x795D,
    0x798D, 0x798E, 0x7A40, 0x7A81, 0x7BC0, 0x7DF4, 0x7E09, 0x7E41,
    0x7F72, 0x8005, 0x81ED, 0x8279, 0x8279, 0x8457, 0x8910, 0x8996,
    0x8B01, 0x8B39, 0x8CD3, 0x8D08, 0x8FB6, 0x9038, 0x96E3, 0x97FF,
    0x983B, 0x6075, 0x242EE, 0x8218, 0x4E26, 0x51B5, 0x5168, 0x4F80,
    0x5145, 0x5180, 0x52C7, 0x52FA, 0x559D, 0x5555, 0x5599, 0x55E2,
    0x585A, 0x58B3, 0x5944, 0x5954, 0x5A62, 0x5B28, 0x5ED2, 0x5ED9,
    0x5F69, 0x5FAD, 0x60D8, 0x614E, 0x6108, 0x618E, 0x6160, 0x61F2,
    0x6234, 0x63C4, 0x641C, 0x6452, 0x6556, 0x6674, 0x6717, 0x671B,
    0x6756, 0x6B79, 0x6BBA, 0x6D41, 0x6EDB, 0x6ECB, 0x6F22, 0x701E,
    0x716E, 0x77A7, 0x7235, 0x72AF, 0x732A, 0x7471, 0x7506, 0x753B,
    0x761D, 0x761F, 0x76CA, 0x76DB, 0x76F4, 0x774A, 0x7740, 0x78CC,
    0x7AB1, 0x7BC0, 0x7C7B, 0x7D5B, 0x7DF4, 0x7F3E, 0x8005, 0x8352,
    0x83EF, 0x8779, 0x8941, 0x8986, 0x8996, 0x8ABF, 0x8AF8, 0x8ACB,
    0x8B01, 0x8AFE, 0x8AED, 0x8B39, 0x8B8A, 0x8D08, 0x8F38, 0x9072,
    0x9199, 0x9276, 0x967C, 0x96E3, 0x9756, 0x97DB, 0x97FF, 0x980B,
    0x983B, 0x9B12, 0x9F9C, 0x2284A, 0x22844, 0x233D5, 0x3B9D, 0x4018,
    0x4039, 0x25249, 0x25CD0, 0x27ED3, 0x9F43, 0x9F8E, 0x0066, 0x0066,
    0x0066, 0x0069, 0x0066, 0x006C, 0x0066, 0x0066, 0x0069, 0x0066,
    0x0066, 0x006C, 0x017F, 0x0074, 0x0073, 0x0074, 0x0574, 0x0576,
    0x0574, 0x0565, 0x0574, 0x056B, 0x057E, 0x0576, 0x0574, 0x056D,
    0x05D9, 0x05B4, 0x05F2, 0x05B7, 0x05E2, 0x05D0, 0x05D3, 0x05D4,
    0x05DB, 0x05DC, 0x05DD, 0x05E8, 0x05EA, 0x002B, 0x05E9, 0x05C1,
    0x05E9, 0x05C2, 0xFB49, 0x05C1, 0xFB49, 0x05C2, 0x05D0, 0x05B7,
    0x05D0, 0x05B8, 0x05D0, 0x05BC, 0x05D1, 0x05BC, 0x05D2, 0x05BC,
    0x05D3, 0x05BC, 0x05D4, 0x05BC, 0x05D5, 0x05BC, 0x05D6, 0x05BC,
    0x05D8, 0x05BC, 0x05D9, 0x05BC, 0x05DA, 0x05BC, 0x05DB, 0x05BC,
    0x05DC, 0x05BC, 0x05DE, 0x05BC, 0x05E0, 0x05BC, 0x05E1, 0x05BC,
    0x05E3, 0x05BC, 0x05E4, 0x05BC, 0x05E6, 0x05BC, 0x05E7, 0x05BC,
    0x05E8, 0x05BC, 0x05E9, 0x05BC, 0x05EA, 0x05BC, 0x05D5, 0x05B9,
    0x05D1, 0x05BF, 0x05DB, 0x05BF, 0x05E4, 0x05BF, 0x05D0, 0x05DC,
    0x0671, 0x0671, 0x067B, 0x067B, 0x067B, 0x067B, 0x067E, 0x067E,
    0x067E, 0x067E, 0x0680, 0x0680, 0x0680, 0x0680, 0x067A, 0x067A,
    0x067A, 0x067A, 0x067F, 0x067F, 0x067F, 0x067F, 0x0679, 0x0679,
    0x0679, 0x0679, 0x06A4, 0x06A4, 0x06A4, 0x06A4, 0x06A6, 0x06A6,
    0x06A6, 0x06A6, 0x0684, 0x0684, 0x0684, 0x0684, 0x0683, 0x0683,
    0x0683, 0x0683, 0x0686, 0x0686, 0x0686, 0x0686, 0x0687, 0x0687,
    0x0687, 0x0687, 0x068D, 0x068D, 0x068C, 0x068C, 0x068E, 0x068E,
    0x0688, 0x0688, 0x0698, 0x0698, 0x0691, 0x0691, 0x06A9, 0x06A9,
    0x06A9, 0x06A9, 0x06AF, 0x06AF, 0x06AF, 0x06AF, 0x06B3, 0x06B3,
    0x06B3, 0x06B3, 0x06B1, 0x06B1, 0x06B1, 0x06B1, 0x06BA, 0x06BA,
    0x06BB, 0x06BB, 0x06BB, 0x06BB, 0x06C0, 0x06C0, 0x06C1, 0x06C1,
    0x06C1, 0x06C1, 0x06BE, 0x06BE, 0x06BE, 0x06BE, 0x06D2, 0x06D2,
    0x06D3, 0x06D3, 0x06AD, 0x06AD, 0x06AD, 0x06AD, 0x06C7, 0x06C7,
    0x06C6, 0x06C6, 0x06C8, 0x06C8, 0x0677, 0x06CB, 0x06CB, 0x06C5,
    0x06C5, 0x06C9, 0x06C9, 0x06D0, 0x06D0, 0x06D0, 0x06D0, 0x0649,
    0x0649, 0x0626, 0x0627, 0x0626, 0x0627, 0x0626, 0x06D5, 0x0626,
    0x06D5, 0x0626, 0x0648, 0x0626, 0x0648, 0x0626, 0x06C7, 0x0626,
    0x06C7, 0x0626, 0x06C6, 0x0626, 0x06C6, 0x0626, 0x06C8, 0x0626,
    0x06C8, 0x0626, 0x06D0, 0x0626, 0x06D0, 0x0626, 0x06D0, 0x0626,
    0x0649, 0x0626, 0x0649, 0x0626, 0x0649, 0x06CC, 0x06CC, 0x06CC,
    0x06CC, 0x0626, 0x062C, 0x0626, 0x062D, 0x0626, 0x0645, 0x0626,
    0x0649, 0x0626, 0x064A, 0x0628, 0x062C, 0x0628, 0x062D, 0x0628,
    0x062E, 0x0628, 0x0645, 0x0628, 0x0649, 0x0628, 0x064A, 0x062A,
    0x062C, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A, 0x0645, 0x062A,
    0x0649, 0x062A, 0x064A, 0x062B, 0x062C, 0x062B, 0x0645, 0x062B,
    0x0649, 0x062B, 0x064A, 0x062C, 0x062D, 0x062C, 0x0645, 0x062D,
    0x062C, 0x062D, 0x0645, 0x062E, 0x062C, 0x062E, 0x062D, 0x062E,
    0x0645, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633,
    0x0645, 0x0635, 0x062D, 0x0635, 0x0645, 0x0636, 0x062C, 0x0636,
    0x062D, 0x0636, 0x062E, 0x0636, 0x0645, 0x0637, 0x062D, 0x0637,
    0x0645, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639, 0x0645, 0x063A,
    0x062C, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062D, 0x0641,
    0x062E, 0x0641, 0x0645, 0x0641, 0x0649, 0x0641, 0x064A, 0x0642,
    0x062D, 0x0642, 0x0645, 0x0642, 0x0649, 0x0642, 0x064A, 0x0643,
    0x0627, 0x0643, 0x062C, 0x0643, 0x062D, 0x0643, 0x062E, 0x0643,
    0x0644, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643, 0x064A, 0x0644,
    0x062C, 0x0644, 0x062D, 0x0644, 0x062E, 0x0644, 0x0645, 0x0644,
    0x0649, 0x0644, 0x064A, 0x0645, 0x062C, 0x0645, 0x062D, 0x0645,
    0x062E, 0x0645, 0x0645, 0x0645, 0x0649, 0x0645, 0x064A, 0x0646,
    0x062C, 0x0646, 0x062D, 0x0646, 0x062E, 0x0646, 0x0645, 0x0646,
    0x0649, 0x0646, 0x064A, 0x0647, 0x062C, 0x0647, 0x0645, 0x0647,
    0x0649, 0x0647, 0x064A, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A,
    0x062E, 0x064A, 0x0645, 0x064A, 0x0649, 0x064A, 0x064A, 0x0630,
    0x0670, 0x0631, 0x0670, 0x0649, 0x0670, 0x0020, 0x064C, 0x0651,
    0x0020, 0x064D, 0x0651, 0x0020, 0x064E, 0x0651, 0x0020, 0x064F,
    0x0651, 0x0020, 0x0650, 0x0651, 0x0020, 0x0651, 0x0670, 0x0626,
    0x0631, 0x0626, 0x0632, 0x0626, 0x0645, 0x0626, 0x0646, 0x0626,
    0x0649, 0x0626, 0x064A, 0x0628, 0x0631, 0x0628, 0x0632, 0x0628,
    0x0645, 0x0628, 0x0646, 0x0628, 0x0649, 0x0628, 0x064A, 0x062A,
    0x0631, 0x062A, 0x0632, 0x062A, 0x0645, 0x062A, 0x0646, 0x062A,
    0x0649, 0x062A, 0x064A, 0x062B, 0x0631, 0x062B, 0x0632, 0x062B,
    0x0645, 0x062B, 0x0646, 0x062B, 0x0649, 0x062B, 0x064A, 0x0641,
    0x0649, 0x0641, 0x064A, 0x0642, 0x0649, 0x0642, 0x064A, 0x0643,
    0x0627, 0x0643, 0x0644, 0x0643, 0x0645, 0x0643, 0x0649, 0x0643,
    0x064A, 0x0644, 0x0645, 0x0644, 0x0649, 0x0644, 0x064A, 0x0645,
    0x0627, 0x0645, 0x0645, 0x0646, 0x0631, 0x0646, 0x0632, 0x0646,
    0x0645, 0x0646, 0x0646, 0x0646, 0x0649, 0x0646, 0x064A, 0x0649,
    0x0670, 0x064A, 0x0631, 0x064A, 0x0632, 0x064A, 0x0645, 0x064A,
    0x0646, 0x064A, 0x0649, 0x064A, 0x064A, 0x0626, 0x062C, 0x0626,
    0x062D, 0x0626, 0x062E, 0x0626, 0x0645, 0x0626, 0x0647, 0x0628,
    0x062C, 0x0628, 0x062D, 0x0628, 0x062E, 0x0628, 0x0645, 0x0628,
    0x0647, 0x062A, 0x062C, 0x062A, 0x062D, 0x062A, 0x062E, 0x062A,
    0x0645, 0x062A, 0x0647, 0x062B, 0x0645, 0x062C, 0x062D, 0x062C,
    0x0645, 0x062D, 0x062C, 0x062D, 0x0645, 0x062E, 0x062C, 0x062E,
    0x0645, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062E, 0x0633,
    0x0645, 0x0635, 0x062D, 0x0635, 0x062E, 0x0635, 0x0645, 0x0636,
    0x062C, 0x0636, 0x062D, 0x0636, 0x062E, 0x0636, 0x0645, 0x0637,
    0x062D, 0x0638, 0x0645, 0x0639, 0x062C, 0x0639, 0x0645, 0x063A,
    0x062C, 0x063A, 0x0645, 0x0641, 0x062C, 0x0641, 0x062D, 0x0641,
    0x062E, 0x0641, 0x0645, 0x0642, 0x062D, 0x0642, 0x0645, 0x0643,
    0x062C, 0x0643, 0x062D, 0x0643, 0x062E, 0x0643, 0x0644, 0x0643,
    0x0645, 0x0644, 0x062C, 0x0644, 0x062D, 0x0644, 0x062E, 0x0644,
    0x0645, 0x0644, 0x0647, 0x0645, 0x062C, 0x0645, 0x062D, 0x0645,
    0x062E, 0x0645, 0x0645, 0x0646, 0x062C, 0x0646, 0x062D, 0x0646,
    0x062E, 0x0646, 0x0645, 0x0646, 0x0647, 0x0647, 0x062C, 0x0647,
    0x0645, 0x0647, 0x0670, 0x064A, 0x062C, 0x064A, 0x062D, 0x064A,
    0x062E, 0x064A, 0x0645, 0x064A, 0x0647, 0x0626, 0x0645, 0x0626,
    0x0647, 0x0628, 0x0645, 0x0628, 0x0647, 0x062A, 0x0645, 0x062A,
    0x0647, 0x062B, 0x0645, 0x062B, 0x0647, 0x0633, 0x0645, 0x0633,
    0x0647, 0x0634, 0x0645, 0x0634, 0x0647, 0x0643, 0x0644, 0x0643,
    0x0645, 0x0644, 0x0645, 0x0646, 0x0645, 0x0646, 0x0647, 0x064A,
    0x0645, 0x064A, 0x0647, 0x0640, 0x064E, 0x0651, 0x0640, 0x064F,
    0x0651, 0x0640, 0x0650, 0x0651, 0x0637, 0x0649, 0x0637, 0x064A,
    0x0639, 0x0649, 0x0639, 0x064A, 0x063A, 0x0649, 0x063A, 0x064A,
    0x0633, 0x0649, 0x0633, 0x064A, 0x0634, 0x0649, 0x0634, 0x064A,
    0x062D, 0x0649, 0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x064A,
    0x062E, 0x0649, 0x062E, 0x064A, 0x0635, 0x0649, 0x0635, 0x064A,
    0x0636, 0x0649, 0x0636, 0x064A, 0x0634, 0x062C, 0x0634, 0x062D,
    0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0631, 0x0633, 0x0631,
    0x0635, 0x0631, 0x0636, 0x0631, 0x0637, 0x0649, 0x0637, 0x064A,
    0x0639, 0x0649, 0x0639, 0x064A, 0x063A, 0x0649, 0x063A, 0x064A,
    0x0633, 0x0649, 0x0633, 0x064A, 0x0634, 0x0649, 0x0634, 0x064A,
    0x062D, 0x0649, 0x062D, 0x064A, 0x062C, 0x0649, 0x062C, 0x064A,
    0x062E, 0x0649, 0x062E, 0x064A, 0x0635, 0x0649, 0x0635, 0x064A,
    0x0636, 0x0649, 0x0636, 0x064A, 0x0634, 0x062C, 0x0634, 0x062D,
    0x0634, 0x062E, 0x0634, 0x0645, 0x0634, 0x0631, 0x0633, 0x0631,
    0x0635, 0x0631, 0x0636, 0x0631, 0x0634, 0x062C, 0x0634, 0x062D,
    0x0634, 0x062E, 0x0634, 0x0645, 0x0633, 0x0647, 0x0634, 0x0647,
    0x0637, 0x0645, 0x0633, 0x062C, 0x0633, 0x062D, 0x0633, 0x062E,
    0x0634, 0x062C, 0x0634, 0x062D, 0x0634, 0x062E, 0x0637, 0x0645,
    0x0638, 0x0645, 0x0627, 0x064B, 0x0627, 0x064B, 0x062A, 0x062C,
    0x0645, 0x062A, 0x062D, 0x062C, 0x062A, 0x062D, 0x062C, 0x062A,
    0x062D, 0x0645, 0x062A, 0x062E, 0x0645, 0x062A, 0x0645, 0x062C,
    0x062A, 0x0645, 0x062D, 0x062A, 0x0645, 0x062E, 0x062C, 0x0645,
    0x062D, 0x062C, 0x0645, 0x062D, 0x062D, 0x0645, 0x064A, 0x062D,
    0x0645, 0x0649, 0x0633, 0x062D, 0x062C, 0x0633, 0x062C, 0x062D,
    0x0633, 0x062C, 0x0649, 0x0633, 0x0645, 0x062D, 0x0633, 0x0645,
    0x062D, 0x0633, 0x0645, 0x062C, 0x0633, 0x0645, 0x0645, 0x0633,
    0x0645, 0x0645, 0x0635, 0x062D, 0x062D, 0x0635, 0x062D, 0x062D,
    0x0635, 0x0645, 0x0645, 0x0634, 0x062D, 0x0645, 0x0634, 0x062D,
    0x0645, 0x0634, 0x062C, 0x064A, 0x0634, 0x0645, 0x062E, 0x0634,
    0x0645, 0x062E, 0x0634, 0x0645, 0x0645, 0x0634, 0x0645, 0x0645,
    0x0636, 0x062D, 0x0649, 0x0636, 0x062E, 0x0645, 0x0636, 0x062E,
    0x0645, 0x0637, 0x0645, 0x062D, 0x0637, 0x0645, 0x062D, 0x0637,
    0x0645, 0x0645, 0x0637, 0x0645, 0x064A, 0x0639, 0x062C, 0x0645,
    0x0639, 0x0645, 0x0645, 0x0639, 0x0645, 0x0645, 0x0639, 0x0645,
    0x0649, 0x063A, 0x0645, 0x0645, 0x063A, 0x0645, 0x064A, 0x063A,
    0x0645, 0x0649, 0x0641, 0x062E, 0x0645, 0x0641, 0x062E, 0x0645,
    0x0642, 0x0645, 0x062D, 0x0642, 0x0645, 0x0645, 0x0644, 0x062D,
    0x0645, 0x0644, 0x062D, 0x064A, 0x0644, 0x062D, 0x0649, 0x0644,
    0x062C, 0x062C, 0x0644, 0x062C, 0x062C, 0x0644, 0x062E, 0x0645,
    0x0644, 0x062E, 0x0645, 0x0644, 0x0645, 0x062D, 0x0644, 0x0645,
    0x062D, 0x0645, 0x062D, 0x062C, 0x0645, 0x062D, 0x0645, 0x0645,
    0x062D, 0x064A, 0x0645, 0x062C, 0x062D, 0x0645, 0x062C, 0x0645,
    0x0645, 0x062E, 0x062C, 0x0645, 0x062E, 0x0645, 0x0645, 0x062C,
    0x062E, 0x0647, 0x0645, 0x062C, 0x0647, 0x0645, 0x0645, 0x0646,
    0x062D, 0x0645, 0x0646, 0x062D, 0x0649, 0x0646, 0x062C, 0x0645,
    0x0646, 0x062C, 0x0645, 0x0646, 0x062C, 0x0649, 0x0646, 0x0645,
    0x064A, 0x0646, 0x0645, 0x0649, 0x064A, 0x0645, 0x0645, 0x064A,
    0x0645, 0x0645, 0x0628, 0x062E, 0x064A, 0x062A, 0x062C, 0x064A,
    0x062A, 0x062C, 0x0649, 0x062A, 0x062E, 0x064A, 0x062A, 0x062E,
    0x0649, 0x062A, 0x0645, 0x064A, 0x062A, 0x0645, 0x0649, 0x062C,
    0x0645, 0x064A, 0x062C, 0x062D, 0x0649, 0x062C, 0x0645, 0x0649,
    0x0633, 0x062E, 0x0649, 0x0635, 0x062D, 0x064A, 0x0634, 0x062D,
    0x064A, 0x0636, 0x062D, 0x064A, 0x0644, 0x062C, 0x064A, 0x0644,
    0x0645, 0x064A, 0x064A, 0x062D, 0x064A, 0x064A, 0x062C, 0x064A,
    0x064A, 0x0645, 0x064A, 0x0645, 0x0645, 0x064A, 0x0642, 0x0645,
    0x064A, 0x0646, 0x062D, 0x064A, 0x0642, 0x0645, 0x062D, 0x0644,
    0x062D, 0x0645, 0x0639, 0x0645, 0x064A, 0x0643, 0x0645, 0x064A,
    0x0646, 0x062C, 0x062D, 0x0645, 0x062E, 0x064A, 0x0644, 0x062C,
    0x0645, 0x0643, 0x0645, 0x0645, 0x0644, 0x062C, 0x0645, 0x0646,
    0x062C, 0x062D, 0x062C, 0x062D, 0x064A, 0x062D, 0x062C, 0x064A,
    0x0645, 0x062C, 0x064A, 0x0641, 0x0645, 0x064A, 0x0628, 0x062D,
    0x064A, 0x0643, 0x0645, 0x0645, 0x0639, 0x062C, 0x0645, 0x0635,
    0x0645, 0x0645, 0x0633, 0x062E, 0x064A, 0x0646, 0x062C, 0x064A,
    0x0635, 0x0644, 0x06D2, 0x0642, 0x0644, 0x06D2, 0x0627, 0x0644,
    0x0644, 0x0647, 0x0627, 0x0643, 0x0628, 0x0631, 0x0645, 0x062D,
    0x0645, 0x062F, 0x0635, 0x0644, 0x0639, 0x0645, 0x0631, 0x0633,
    0x0648, 0x0644, 0x0639, 0x0644, 0x064A, 0x0647, 0x0648, 0x0633,
    0x0644, 0x0645, 0x0635, 0x0644, 0x0649, 0x0635, 0x0644, 0x0649,
    0x0020, 0x0627, 0x0644, 0x0644, 0x0647, 0x0020, 0x0639, 0x0644,
    0x064A, 0x0647, 0x0020, 0x0648, 0x0633, 0x0644, 0x0645, 0x062C,
    0x0644, 0x0020, 0x062C, 0x0644, 0x0627, 0x0644, 0x0647, 0x0631,
    0x06CC, 0x0627, 0x0644, 0x002C, 0x3001, 0x3002, 0x003A, 0x003B,
    0x0021, 0x003F, 0x3016, 0x3017, 0x2026, 0x2025, 0x2014, 0x2013,
    0x005F, 0x005F, 0x0028, 0x0029, 0x007B, 0x007D, 0x3014, 0x3015,
    0x3010, 0x3011, 0x300A, 0x300B, 0x3008, 0x3009, 0x300C, 0x300D,
    0x300E, 0x300F, 0x005B, 0x005D, 0x203E, 0x203E, 0x203E, 0x203E,
    0x005F, 0x005F, 0x005F, 0x002C, 0x3001, 0x002E, 0x003B, 0x003A,
    0x003F, 0x0021, 0x2014, 0x0028, 0x0029, 0x007B, 0x007D, 0x3014,
    0x3015, 0x0023, 0x0026, 0x002A, 0x002B, 0x002D, 0x003C, 0x003E,
    0x003D, 0x005C, 0x0024, 0x0025, 0x0040, 0x0020, 0x064B, 0x0640,
    0x064B, 0x0020, 0x064C, 0x0020, 0x064D, 0x0020, 0x064E, 0x0640,
    0x064E, 0x0020, 0x064F, 0x0640, 0x064F, 0x0020, 0x0650, 0x0640,
    0x0650, 0x0020, 0x0651, 0x0640, 0x0651, 0x0020, 0x0652, 0x0640,
    0x0652, 0x0621, 0x0622, 0x0622, 0x0623, 0x0623, 0x0624, 0x0624,
    0x0625, 0x0625, 0x0626, 0x0626, 0x0626, 0x0626, 0x0627, 0x0627,
    0x0628, 0x0628, 0x0628, 0x0628, 0x0629, 0x0629, 0x062A, 0x062A,
    0x062A, 0x062A, 0x062B, 0x062B, 0x062B, 0x062B, 0x062C, 0x062C,
    0x062C, 0x062C, 0x062D, 0x062D, 0x062D, 0x062D, 0x062E, 0x062E,
    0x062E, 0x062E, 0x062F, 0x062F, 0x0630, 0x0630, 0x0631, 0x0631,
    0x0632, 0x0632, 0x0633, 0x0633, 0x0633, 0x0633, 0x0634, 0x0634,
    0x0634, 0x0634, 0x0635, 0x0635, 0x0635, 0x0635, 0x0636, 0x0636,
    0x0636, 0x0636, 0x0637, 0x0637, 0x0637, 0x0637, 0x0638, 0x0638,
    0x0638, 0x0638, 0x0639, 0x0639, 0x0639, 0x0639, 0x063A, 0x063A,
    0x063A, 0x063A, 0x0641, 0x0641, 0x0641, 0x0641, 0x0642, 0x0642,
    0x0642, 0x0642, 0x0643, 0x0643, 0x0643, 0x0643, 0x0644, 0x0644,
    0x0644, 0x0644, 0x0645, 0x0645, 0x0645, 0x0645, 0x0646, 0x0646,
    0x0646, 0x0646, 0x0647, 0x0647, 0x0647, 0x0647, 0x0648, 0x0648,
    0x0649, 0x0649, 0x064A, 0x064A, 0x064A, 0x064A, 0x0644, 0x0622,
    0x0644, 0x0622, 0x0644, 0x0623, 0x0644, 0x0623, 0x0644, 0x0625,
    0x0644, 0x0625, 0x0644, 0x0627, 0x0644, 0x0627, 0x0021, 0x0022,
    0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A,
    0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 0x0030, 0x0031, 0x0032,
    0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x003A,
    0x003B, 0x003C, 0x003D, 0x003E, 0x003F, 0x0040, 0x0041, 0x0042,
    0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A,
    0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051, 0x0052,
    0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005A,
    0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060, 0x0061, 0x0062,
    0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A,
    0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072,
    0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A,
    0x007B, 0x007C, 0x007D, 0x007E, 0x2985, 0x2986, 0x3002, 0x300C,
    0x300D, 0x3001, 0x30FB, 0x30F2, 0x30A1, 0x30A3, 0x30A5, 0x30A7,
    0x30A9, 0x30E3, 0x30E5, 0x30E7, 0x30C3, 0x30FC, 0x30A2, 0x30A4,
    0x30A6, 0x30A8, 0x30AA, 0x30AB, 0x30AD, 0x30AF, 0x30B1, 0x30B3,
    0x30B5, 0x30B7, 0x30B9, 0x30BB, 0x30BD, 0x30BF, 0x30C1, 0x30C4,
    0x30C6, 0x30C8, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF,
    0x30D2, 0x30D5, 0x30D8, 0x30DB, 0x30DE, 0x30DF, 0x30E0, 0x30E1,
    0x30E2, 0x30E4, 0x30E6, 0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC,
    0x30ED, 0x30EF, 0x30F3, 0x3099, 0x309A, 0x3164, 0x3131, 0x3132,
    0x3133, 0x3134, 0x3135, 0x3136, 0x3137, 0x3138, 0x3139, 0x313A,
    0x313B, 0x313C, 0x313D, 0x313E, 0x313F, 0x3140, 0x3141, 0x3142,
    0x3143, 0x3144, 0x3145, 0x3146, 0x3147, 0x3148, 0x3149, 0x314A,
    0x314B, 0x314C, 0x314D, 0x314E, 0x314F, 0x3150, 0x3151, 0x3152,
    0x3153, 0x3154, 0x3155, 0x3156, 0x3157, 0x3158, 0x3159, 0x315A,
    0x315B, 0x315C, 0x315D, 0x315E, 0x315F, 0x3160, 0x3161, 0x3162,
    0x3163, 0x00A2, 0x00A3, 0x00AC, 0x00AF, 0x00A6, 0x00A5, 0x20A9,
    0x2502, 0x2190, 0x2191, 0x2192, 0x2193, 0x25A0, 0x25CB, 0x11099,
    0x110BA, 0x1109B, 0x110BA, 0x110A5, 0x110BA, 0x11131, 0x11127, 0x11132,
    0x11127, 0x11347, 0x1133E, 0x11347, 0x11357, 0x114B9, 0x114BA, 0x114B9,
    0x114B0, 0x114B9, 0x114BD, 0x115B8, 0x115AF, 0x115B9, 0x115AF, 0x11935,
    0x11930, 0x1D157, 0x1D165, 0x1D158, 0x1D165, 0x1D15F, 0x1D16E, 0x1D15F,
    0x1D16F, 0x1D15F, 0x1D170, 0x1D15F, 0x1D171, 0x1D15F, 0x1D172, 0x1D1B9,
    0x1D165, 0x1D1BA, 0x1D165, 0x1D1BB, 0x1D16E, 0x1D1BC, 0x1D16E, 0x1D1BB,
    0x1D16F, 0x1D1BC, 0x1D16F, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045,
    0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D,
    0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055,
    0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x0061, 0x0062, 0x0063,
    0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073,
    0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0041,
    0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049,
    0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051,
    0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070,
    0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
    0x0079, 0x007A, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046,
    0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E,
    0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056,
    0x0057, 0x0058, 0x0059, 0x005A, 0x0061, 0x0062, 0x0063, 0x0064,
    0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C,
    0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073, 0x0074,
    0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0041, 0x0043,
    0x0044, 0x0047, 0x004A, 0x004B, 0x004E, 0x004F, 0x0050, 0x0051,
    0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005A,
    0x0061, 0x0062, 0x0063, 0x0064, 0x0066, 0x0068, 0x0069, 0x006A,
    0x006B, 0x006C, 0x006D, 0x006E, 0x0070, 0x0071, 0x0072, 0x0073,
    0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0041,
    0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049,
    0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051,
    0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x0041, 0x0042, 0x0044, 0x0045, 0x0046,
    0x0047, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
    0x0051, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068,
    0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070,
    0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078,
    0x0079, 0x007A, 0x0041, 0x0042, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004F, 0x0053, 0x0054,
    0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x0061, 0x0062, 0x0063,
    0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073,
    0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0041,
    0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049,
    0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051,
    0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045,
    0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D,
    0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055,
    0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x0061, 0x0062, 0x0063,
    0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073,
    0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0041,
    0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049,
    0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051,
    0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045,
    0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D,
    0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055,
    0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x0061, 0x0062, 0x0063,
    0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073,
    0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0041,
    0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049,
    0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050, 0x0051,
    0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059,
    0x005A, 0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067,
    0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F,
    0x0070, 0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077,
    0x0078, 0x0079, 0x007A, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045,
    0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D,
    0x004E, 0x004F, 0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055,
    0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x0061, 0x0062, 0x0063,
    0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B,
    0x006C, 0x006D, 0x006E, 0x006F, 0x0070, 0x0071, 0x0072, 0x0073,
    0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x0131,
    0x0237, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F,
    0x03A0, 0x03A1, 0x03F4, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7,
    0x03A8, 0x03A9, 0x2207, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5,
    0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD,
    0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5,
    0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x2202, 0x03F5, 0x03D1, 0x03F0,
    0x03D5, 0x03F1, 0x03D6, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395,
    0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03F4, 0x03A3, 0x03A4, 0x03A5,
    0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x2207, 0x03B1, 0x03B2, 0x03B3,
    0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB,
    0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C2, 0x03C3,
    0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x2202, 0x03F5,
    0x03D1, 0x03F0, 0x03D5, 0x03F1, 0x03D6, 0x0391, 0x0392, 0x0393,
    0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B,
    0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03F4, 0x03A3,
    0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0x2207, 0x03B1,
    0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9,
    0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1,
    0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9,
    0x2202, 0x03F5, 0x03D1, 0x03F0, 0x03D5, 0x03F1, 0x03D6, 0x0391,
    0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399,
    0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1,
    0x03F4, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9,
    0x2207, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7,
    0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF,
    0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7,
    0x03C8, 0x03C9, 0x2202, 0x03F5, 0x03D1, 0x03F0, 0x03D5, 0x03F1,
    0x03D6, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
    0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F,
    0x03A0, 0x03A1, 0x03F4, 0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7,
    0x03A8, 0x03A9, 0x2207, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5,
    0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD,
    0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C2, 0x03C3, 0x03C4, 0x03C5,
    0x03C6, 0x03C7, 0x03C8, 0x03C9, 0x2202, 0x03F5, 0x03D1, 0x03F0,
    0x03D5, 0x03F1, 0x03D6, 0x03DC, 0x03DD, 0x0030, 0x0031, 0x0032,
    0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x0030,
    0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038,
    0x0039, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036,
    0x0037, 0x0038, 0x0039, 0x0030, 0x0031, 0x0032, 0x0033, 0x0034,
    0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x0030, 0x0031, 0x0032,
    0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x0627,
    0x0628, 0x062C, 0x062F, 0x0648, 0x0632, 0x062D, 0x0637, 0x064A,
    0x0643, 0x0644, 0x0645, 0x0646, 0x0633, 0x0639, 0x0641, 0x0635,
    0x0642, 0x0631, 0x0634, 0x062A, 0x062B, 0x062E, 0x0630, 0x0636,
    0x0638, 0x063A, 0x066E, 0x06BA, 0x06A1, 0x066F, 0x0628, 0x062C,
    0x0647, 0x062D, 0x064A, 0x0643, 0x0644, 0x0645, 0x0646, 0x0633,
    0x0639, 0x0641, 0x0635, 0x0642, 0x0634, 0x062A, 0x062B, 0x062E,
    0x0636, 0x063A, 0x062C, 0x062D, 0x064A, 0x0644, 0x0646, 0x0633,
    0x0639, 0x0635, 0x0642, 0x0634, 0x062E, 0x0636, 0x063A, 0x06BA,
    0x066F, 0x0628, 0x062C, 0x0647, 0x062D, 0x0637, 0x064A, 0x0643,
    0x0645, 0x0646, 0x0633, 0x0639, 0x0641, 0x0635, 0x0642, 0x0634,
    0x062A, 0x062B, 0x062E, 0x0636, 0x0638, 0x063A, 0x066E, 0x06A1,
    0x0627, 0x0628, 0x062C, 0x062F, 0x0647, 0x0648, 0x0632, 0x062D,
    0x0637, 0x064A, 0x0644, 0x0645, 0x0646, 0x0633, 0x0639, 0x0641,
    0x0635, 0x0642, 0x0631, 0x0634, 0x062A, 0x062B, 0x062E, 0x0630,
    0x0636, 0x0638, 0x063A, 0x0628, 0x062C, 0x062F, 0x0648, 0x0632,
    0x062D, 0x0637, 0x064A, 0x0644, 0x0645, 0x0646, 0x0633, 0x0639,
    0x0641, 0x0635, 0x0642, 0x0631, 0x0634, 0x062A, 0x062B, 0x062E,
    0x0630, 0x0636, 0x0638, 0x063A, 0x0030, 0x002E, 0x0030, 0x002C,
    0x0031, 0x002C, 0x0032, 0x002C, 0x0033, 0x002C, 0x0034, 0x002C,
    0x0035, 0x002C, 0x0036, 0x002C, 0x0037, 0x002C, 0x0038, 0x002C,
    0x0039, 0x002C, 0x0028, 0x0041, 0x0029, 0x0028, 0x0042, 0x0029,
    0x0028, 0x0043, 0x0029, 0x0028, 0x0044, 0x0029, 0x0028, 0x0045,
    0x0029, 0x0028, 0x0046, 0x0029, 0x0028, 0x0047, 0x0029, 0x0028,
    0x0048, 0x0029, 0x0028, 0x0049, 0x0029, 0x0028, 0x004A, 0x0029,
    0x0028, 0x004B, 0x0029, 0x0028, 0x004C, 0x0029, 0x0028, 0x004D,
    0x0029, 0x0028, 0x004E, 0x0029, 0x0028, 0x004F, 0x0029, 0x0028,
    0x0050, 0x0029, 0x0028, 0x0051, 0x0029, 0x0028, 0x0052, 0x0029,
    0x0028, 0x0053, 0x0029, 0x0028, 0x0054, 0x0029, 0x0028, 0x0055,
    0x0029, 0x0028, 0x0056, 0x0029, 0x0028, 0x0057, 0x0029, 0x0028,
    0x0058, 0x0029, 0x0028, 0x0059, 0x0029, 0x0028, 0x005A, 0x0029,
    0x3014, 0x0053, 0x3015, 0x0043, 0x0052, 0x0043, 0x0044, 0x0057,
    0x005A, 0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047,
    0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F,
    0x0050, 0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057,
    0x0058, 0x0059, 0x005A, 0x0048, 0x0056, 0x004D, 0x0056, 0x0053,
    0x0044, 0x0053, 0x0053, 0x0050, 0x0050, 0x0056, 0x0057, 0x0043,
    0x004D, 0x0043, 0x004D, 0x0044, 0x004D, 0x0052, 0x0044, 0x004A,
    0x307B, 0x304B, 0x30B3, 0x30B3, 0x30B5, 0x624B, 0x5B57, 0x53CC,
    0x30C7, 0x4E8C, 0x591A, 0x89E3, 0x5929, 0x4EA4, 0x6620, 0x7121,
    0x6599, 0x524D, 0x5F8C, 0x518D, 0x65B0, 0x521D, 0x7D42, 0x751F,
    0x8CA9, 0x58F0, 0x5439, 0x6F14, 0x6295, 0x6355, 0x4E00, 0x4E09,
    0x904A, 0x5DE6, 0x4E2D, 0x53F3, 0x6307, 0x8D70, 0x6253, 0x7981,
    0x7A7A, 0x5408, 0x6E80, 0x6709, 0x6708, 0x7533, 0x5272, 0x55B6,
    0x914D, 0x3014, 0x672C, 0x3015, 0x3014, 0x4E09, 0x3015, 0x3014,
    0x4E8C, 0x3015, 0x3014, 0x5B89, 0x3015, 0x3014, 0x70B9, 0x3015,
    0x3014, 0x6253, 0x3015, 0x3014, 0x76D7, 0x3015, 0x3014, 0x52DD,
    0x3015, 0x3014, 0x6557, 0x3015, 0x5F97, 0x53EF, 0x0030, 0x0031,
    0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039,
    0x4E3D, 0x4E38, 0x4E41, 0x20122, 0x4F60, 0x4FAE, 0x4FBB, 0x5002,
    0x507A, 0x5099, 0x50E7, 0x50CF, 0x349E, 0x2063A, 0x514D, 0x5154,
    0x5164, 0x5177, 0x2051C, 0x34B9, 0x5167, 0x518D, 0x2054B, 0x5197,
    0x51A4, 0x4ECC, 0x51AC, 0x51B5, 0x291DF, 0x51F5, 0x5203, 0x34DF,
    0x523B, 0x5246, 0x5272, 0x5277, 0x3515, 0x52C7, 0x52C9, 0x52E4,
    0x52FA, 0x5305, 0x5306, 0x5317, 0x5349, 0x5351, 0x535A, 0x5373,
    0x537D, 0x537F, 0x537F, 0x537F, 0x20A2C, 0x7070, 0x53CA, 0x53DF,
    0x20B63, 0x53EB, 0x53F1, 0x5406, 0x549E, 0x5438, 0x5448, 0x5468,
    0x54A2, 0x54F6, 0x5510, 0x5553, 0x5563, 0x5584, 0x5584, 0x5599,
    0x55AB, 0x55B3, 0x55C2, 0x5716, 0x5606, 0x5717, 0x5651, 0x5674,
    0x5207, 0x58EE, 0x57CE, 0x57F4, 0x580D, 0x578B, 0x5832, 0x5831,
    0x58AC, 0x214E4, 0x58F2, 0x58F7, 0x5906, 0x591A, 0x5922, 0x5962,
    0x216A8, 0x216EA, 0x59EC, 0x5A1B, 0x5A27, 0x59D8, 0x5A66, 0x36EE,
    0x36FC, 0x5B08, 0x5B3E, 0x5B3E, 0x219C8, 0x5BC3, 0x5BD8, 0x5BE7,
    0x5BF3, 0x21B18, 0x5BFF, 0x5C06, 0x5F53, 0x5C22, 0x3781, 0x5C60,
    0x5C6E, 0x5CC0, 0x5C8D, 0x21DE4, 0x5D43, 0x21DE6, 0x5D6E, 0x5D6B,
    0x5D7C, 0x5DE1, 0x5DE2, 0x382F, 0x5DFD, 0x5E28, 0x5E3D, 0x5E69,
    0x3862, 0x22183, 0x387C, 0x5EB0, 0x5EB3, 0x5EB6, 0x5ECA, 0x2A392,
    0x5EFE, 0x22331, 0x22331, 0x8201, 0x5F22, 0x5F22, 0x38C7, 0x232B8,
    0x261DA, 0x5F62, 0x5F6B, 0x38E3, 0x5F9A, 0x5FCD, 0x5FD7, 0x5FF9,
    0x6081, 0x393A, 0x391C, 0x6094, 0x226D4, 0x60C7, 0x6148, 0x614C,
    0x614E, 0x614C, 0x617A, 0x618E, 0x61B2, 0x61A4, 0x61AF, 0x61DE,
    0x61F2, 0x61F6, 0x6210, 0x621B, 0x625D, 0x62B1, 0x62D4, 0x6350,
    0x22B0C, 0x633D, 0x62FC, 0x6368, 0x6383, 0x63E4, 0x22BF1, 0x6422,
    0x63C5, 0x63A9, 0x3A2E, 0x6469, 0x647E, 0x649D, 0x6477, 0x3A6C,
    0x654F, 0x656C, 0x2300A, 0x65E3, 0x66F8, 0x6649, 0x3B19, 0x6691,
    0x3B08, 0x3AE4, 0x5192, 0x5195, 0x6700, 0x669C, 0x80AD, 0x43D9,
    0x6717, 0x671B, 0x6721, 0x675E, 0x6753, 0x233C3, 0x3B49, 0x67FA,
    0x6785, 0x6852, 0x6885, 0x2346D, 0x688E, 0x681F, 0x6914, 0x3B9D,
    0x6942, 0x69A3, 0x69EA, 0x6AA8, 0x236A3, 0x6ADB, 0x3C18, 0x6B21,
    0x238A7, 0x6B54, 0x3C4E, 0x6B72, 0x6B9F, 0x6BBA, 0x6BBB, 0x23A8D,
    0x21D0B, 0x23AFA, 0x6C4E, 0x23CBC, 0x6CBF, 0x6CCD, 0x6C67, 0x6D16,
    0x6D3E, 0x6D77, 0x6D41, 0x6D69, 0x6D78, 0x6D85, 0x23D1E, 0x6D34,
    0x6E2F, 0x6E6E, 0x3D33, 0x6ECB, 0x6EC7, 0x23ED1, 0x6DF9, 0x6F6E,
    0x23F5E, 0x23F8E, 0x6FC6, 0x7039, 0x701E, 0x701B, 0x3D96, 0x704A,
    0x707D, 0x7077, 0x70AD, 0x20525, 0x7145, 0x24263, 0x719C, 0x243AB,
    0x7228, 0x7235, 0x7250, 0x24608, 0x7280, 0x7295, 0x24735, 0x24814,
    0x737A, 0x738B, 0x3EAC, 0x73A5, 0x3EB8, 0x3EB8, 0x7447, 0x745C,
    0x7471, 0x7485, 0x74CA, 0x3F1B, 0x7524, 0x24C36, 0x753E, 0x24C92,
    0x7570, 0x2219F, 0x7610, 0x24FA1, 0x24FB8, 0x25044, 0x3FFC, 0x4008,
    0x76F4, 0x250F3, 0x250F2, 0x25119, 0x25133, 0x771E, 0x771F, 0x771F,
    0x774A, 0x4039, 0x778B, 0x4046, 0x4096, 0x2541D, 0x784E, 0x788C,
    0x78CC, 0x40E3, 0x25626, 0x7956, 0x2569A, 0x256C5, 0x798F, 0x79EB,
    0x412F, 0x7A40, 0x7A4A, 0x7A4F, 0x2597C, 0x25AA7, 0x25AA7, 0x7AEE,
    0x4202, 0x25BAB, 0x7BC6, 0x7BC9, 0x4227, 0x25C80, 0x7CD2, 0x42A0,
    0x7CE8, 0x7CE3, 0x7D00, 0x25F86, 0x7D63, 0x4301, 0x7DC7, 0x7E02,
    0x7E45, 0x4334, 0x26228, 0x26247, 0x4359, 0x262D9, 0x7F7A, 0x2633E,
    0x7F95, 0x7FFA, 0x8005, 0x264DA, 0x26523, 0x8060, 0x265A8, 0x8070,
    0x2335F, 0x43D5, 0x80B2, 0x8103, 0x440B, 0x813E, 0x5AB5, 0x267A7,
    0x267B5, 0x23393, 0x2339C, 0x8201, 0x8204, 0x8F9E, 0x446B, 0x8291,
    0x828B, 0x829D, 0x52B3, 0x82B1, 0x82B3, 0x82BD, 0x82E6, 0x26B3C,
    0x82E5, 0x831D, 0x8363, 0x83AD, 0x8323, 0x83BD, 0x83E7, 0x8457,
    0x8353, 0x83CA, 0x83CC, 0x83DC, 0x26C36, 0x26D6B, 0x26CD5, 0x452B,
    0x84F1, 0x84F3, 0x8516, 0x273CA, 0x8564, 0x26F2C, 0x455D, 0x4561,
    0x26FB1, 0x270D2, 0x456B, 0x8650, 0x865C, 0x8667, 0x8669, 0x86A9,
    0x8688, 0x870E, 0x86E2, 0x8779, 0x8728, 0x876B, 0x8786, 0x45D7,
    0x87E1, 0x8801, 0x45F9, 0x8860, 0x8863, 0x27667, 0x88D7, 0x88DE,
    0x4635, 0x88FA, 0x34BB, 0x278AE, 0x27966, 0x46BE, 0x46C7, 0x8AA0,
    0x8AED, 0x8B8A, 0x8C55, 0x27CA8, 0x8CAB, 0x8CC1, 0x8D1B, 0x8D77,
    0x27F2F, 0x20804, 0x8DCB, 0x8DBC, 0x8DF0, 0x208DE, 0x8ED4, 0x8F38,
    0x285D2, 0x285ED, 0x9094, 0x90F1, 0x9111, 0x2872E, 0x911B, 0x9238,
    0x92D7, 0x92D8, 0x927C, 0x93F9, 0x9415, 0x28BFA, 0x958B, 0x4995,
    0x95B7, 0x28D77, 0x49E6, 0x96C3, 0x5DB2, 0x9723, 0x29145, 0x2921A,
    0x4A6E, 0x4A76, 0x97E0, 0x2940A, 0x4AB2, 0x29496, 0x980B, 0x980B,
    0x9829, 0x295B6, 0x98E2, 0x4B33, 0x9929, 0x99A7, 0x99C2, 0x99FE,
    0x4BCE, 0x29B30, 0x9B12, 0x9C40, 0x9CFD, 0x4CCE, 0x4CED, 0x9D67,
    0x2A0CE, 0x4CF8, 0x2A105, 0x2A20E, 0x2A291, 0x9EBB, 0x4D56, 0x9EF9,
    0x9EFE, 0x9F05, 0x9F0F, 0x9F16, 0x9F3B, 0x2A600
};

}  // namespace unicode
