/* Copyright 2020 Zhao HG

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. */
#include "unicode_data.h"

namespace unicode {


const int32_t NUMERICS_INDEX[] = {
    0x0030, 0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037,
    0x0038, 0x0039, 0x00B2, 0x00B3, 0x00B9, 0x00BC, 0x00BD, 0x00BE,
    0x0660, 0x0661, 0x0662, 0x0663, 0x0664, 0x0665, 0x0666, 0x0667,
    0x0668, 0x0669, 0x06F0, 0x06F1, 0x06F2, 0x06F3, 0x06F4, 0x06F5,
    0x06F6, 0x06F7, 0x06F8, 0x06F9, 0x07C0, 0x07C1, 0x07C2, 0x07C3,
    0x07C4, 0x07C5, 0x07C6, 0x07C7, 0x07C8, 0x07C9, 0x0966, 0x0967,
    0x0968, 0x0969, 0x096A, 0x096B, 0x096C, 0x096D, 0x096E, 0x096F,
    0x09E6, 0x09E7, 0x09E8, 0x09E9, 0x09EA, 0x09EB, 0x09EC, 0x09ED,
    0x09EE, 0x09EF, 0x09F4, 0x09F5, 0x09F6, 0x09F7, 0x09F8, 0x09F9,
    0x0A66, 0x0A67, 0x0A68, 0x0A69, 0x0A6A, 0x0A6B, 0x0A6C, 0x0A6D,
    0x0A6E, 0x0A6F, 0x0AE6, 0x0AE7, 0x0AE8, 0x0AE9, 0x0AEA, 0x0AEB,
    0x0AEC, 0x0AED, 0x0AEE, 0x0AEF, 0x0B66, 0x0B67, 0x0B68, 0x0B69,
    0x0B6A, 0x0B6B, 0x0B6C, 0x0B6D, 0x0B6E, 0x0B6F, 0x0B72, 0x0B73,
    0x0B74, 0x0B75, 0x0B76, 0x0B77, 0x0BE6, 0x0BE7, 0x0BE8, 0x0BE9,
    0x0BEA, 0x0BEB, 0x0BEC, 0x0BED, 0x0BEE, 0x0BEF, 0x0BF0, 0x0BF1,
    0x0BF2, 0x0C66, 0x0C67, 0x0C68, 0x0C69, 0x0C6A, 0x0C6B, 0x0C6C,
    0x0C6D, 0x0C6E, 0x0C6F, 0x0C78, 0x0C79, 0x0C7A, 0x0C7B, 0x0C7C,
    0x0C7D, 0x0C7E, 0x0CE6, 0x0CE7, 0x0CE8, 0x0CE9, 0x0CEA, 0x0CEB,
    0x0CEC, 0x0CED, 0x0CEE, 0x0CEF, 0x0D58, 0x0D59, 0x0D5A, 0x0D5B,
    0x0D5C, 0x0D5D, 0x0D5E, 0x0D66, 0x0D67, 0x0D68, 0x0D69, 0x0D6A,
    0x0D6B, 0x0D6C, 0x0D6D, 0x0D6E, 0x0D6F, 0x0D70, 0x0D71, 0x0D72,
    0x0D73, 0x0D74, 0x0D75, 0x0D76, 0x0D77, 0x0D78, 0x0DE6, 0x0DE7,
    0x0DE8, 0x0DE9, 0x0DEA, 0x0DEB, 0x0DEC, 0x0DED, 0x0DEE, 0x0DEF,
    0x0E50, 0x0E51, 0x0E52, 0x0E53, 0x0E54, 0x0E55, 0x0E56, 0x0E57,
    0x0E58, 0x0E59, 0x0ED0, 0x0ED1, 0x0ED2, 0x0ED3, 0x0ED4, 0x0ED5,
    0x0ED6, 0x0ED7, 0x0ED8, 0x0ED9, 0x0F20, 0x0F21, 0x0F22, 0x0F23,
    0x0F24, 0x0F25, 0x0F26, 0x0F27, 0x0F28, 0x0F29, 0x0F2A, 0x0F2B,
    0x0F2C, 0x0F2D, 0x0F2E, 0x0F2F, 0x0F30, 0x0F31, 0x0F32, 0x0F33,
    0x1040, 0x1041, 0x1042, 0x1043, 0x1044, 0x1045, 0x1046, 0x1047,
    0x1048, 0x1049, 0x1090, 0x1091, 0x1092, 0x1093, 0x1094, 0x1095,
    0x1096, 0x1097, 0x1098, 0x1099, 0x1369, 0x136A, 0x136B, 0x136C,
    0x136D, 0x136E, 0x136F, 0x1370, 0x1371, 0x1372, 0x1373, 0x1374,
    0x1375, 0x1376, 0x1377, 0x1378, 0x1379, 0x137A, 0x137B, 0x137C,
    0x16EE, 0x16EF, 0x16F0, 0x17E0, 0x17E1, 0x17E2, 0x17E3, 0x17E4,
    0x17E5, 0x17E6, 0x17E7, 0x17E8, 0x17E9, 0x17F0, 0x17F1, 0x17F2,
    0x17F3, 0x17F4, 0x17F5, 0x17F6, 0x17F7, 0x17F8, 0x17F9, 0x1810,
    0x1811, 0x1812, 0x1813, 0x1814, 0x1815, 0x1816, 0x1817, 0x1818,
    0x1819, 0x1946, 0x1947, 0x1948, 0x1949, 0x194A, 0x194B, 0x194C,
    0x194D, 0x194E, 0x194F, 0x19D0, 0x19D1, 0x19D2, 0x19D3, 0x19D4,
    0x19D5, 0x19D6, 0x19D7, 0x19D8, 0x19D9, 0x19DA, 0x1A80, 0x1A81,
    0x1A82, 0x1A83, 0x1A84, 0x1A85, 0x1A86, 0x1A87, 0x1A88, 0x1A89,
    0x1A90, 0x1A91, 0x1A92, 0x1A93, 0x1A94, 0x1A95, 0x1A96, 0x1A97,
    0x1A98, 0x1A99, 0x1B50, 0x1B51, 0x1B52, 0x1B53, 0x1B54, 0x1B55,
    0x1B56, 0x1B57, 0x1B58, 0x1B59, 0x1BB0, 0x1BB1, 0x1BB2, 0x1BB3,
    0x1BB4, 0x1BB5, 0x1BB6, 0x1BB7, 0x1BB8, 0x1BB9, 0x1C40, 0x1C41,
    0x1C42, 0x1C43, 0x1C44, 0x1C45, 0x1C46, 0x1C47, 0x1C48, 0x1C49,
    0x1C50, 0x1C51, 0x1C52, 0x1C53, 0x1C54, 0x1C55, 0x1C56, 0x1C57,
    0x1C58, 0x1C59, 0x2070, 0x2074, 0x2075, 0x2076, 0x2077, 0x2078,
    0x2079, 0x2080, 0x2081, 0x2082, 0x2083, 0x2084, 0x2085, 0x2086,
    0x2087, 0x2088, 0x2089, 0x2150, 0x2151, 0x2152, 0x2153, 0x2154,
    0x2155, 0x2156, 0x2157, 0x2158, 0x2159, 0x215A, 0x215B, 0x215C,
    0x215D, 0x215E, 0x215F, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164,
    0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 0x216A, 0x216B, 0x216C,
    0x216D, 0x216E, 0x216F, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174,
    0x2175, 0x2176, 0x2177, 0x2178, 0x2179, 0x217A, 0x217B, 0x217C,
    0x217D, 0x217E, 0x217F, 0x2180, 0x2181, 0x2182, 0x2185, 0x2186,
    0x2187, 0x2188, 0x2189, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464,
    0x2465, 0x2466, 0x2467, 0x2468, 0x2469, 0x246A, 0x246B, 0x246C,
    0x246D, 0x246E, 0x246F, 0x2470, 0x2471, 0x2472, 0x2473, 0x2474,
    0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247A, 0x247B, 0x247C,
    0x247D, 0x247E, 0x247F, 0x2480, 0x2481, 0x2482, 0x2483, 0x2484,
    0x2485, 0x2486, 0x2487, 0x2488, 0x2489, 0x248A, 0x248B, 0x248C,
    0x248D, 0x248E, 0x248F, 0x2490, 0x2491, 0x2492, 0x2493, 0x2494,
    0x2495, 0x2496, 0x2497, 0x2498, 0x2499, 0x249A, 0x249B, 0x24EA,
    0x24EB, 0x24EC, 0x24ED, 0x24EE, 0x24EF, 0x24F0, 0x24F1, 0x24F2,
    0x24F3, 0x24F4, 0x24F5, 0x24F6, 0x24F7, 0x24F8, 0x24F9, 0x24FA,
    0x24FB, 0x24FC, 0x24FD, 0x24FE, 0x24FF, 0x2776, 0x2777, 0x2778,
    0x2779, 0x277A, 0x277B, 0x277C, 0x277D, 0x277E, 0x277F, 0x2780,
    0x2781, 0x2782, 0x2783, 0x2784, 0x2785, 0x2786, 0x2787, 0x2788,
    0x2789, 0x278A, 0x278B, 0x278C, 0x278D, 0x278E, 0x278F, 0x2790,
    0x2791, 0x2792, 0x2793, 0x2CFD, 0x3007, 0x3021, 0x3022, 0x3023,
    0x3024, 0x3025, 0x3026, 0x3027, 0x3028, 0x3029, 0x3038, 0x3039,
    0x303A, 0x3192, 0x3193, 0x3194, 0x3195, 0x3220, 0x3221, 0x3222,
    0x3223, 0x3224, 0x3225, 0x3226, 0x3227, 0x3228, 0x3229, 0x3248,
    0x3249, 0x324A, 0x324B, 0x324C, 0x324D, 0x324E, 0x324F, 0x3251,
    0x3252, 0x3253, 0x3254, 0x3255, 0x3256, 0x3257, 0x3258, 0x3259,
    0x325A, 0x325B, 0x325C, 0x325D, 0x325E, 0x325F, 0x3280, 0x3281,
    0x3282, 0x3283, 0x3284, 0x3285, 0x3286, 0x3287, 0x3288, 0x3289,
    0x32B1, 0x32B2, 0x32B3, 0x32B4, 0x32B5, 0x32B6, 0x32B7, 0x32B8,
    0x32B9, 0x32BA, 0x32BB, 0x32BC, 0x32BD, 0x32BE, 0x32BF, 0xA620,
    0xA621, 0xA622, 0xA623, 0xA624, 0xA625, 0xA626, 0xA627, 0xA628,
    0xA629, 0xA6E6, 0xA6E7, 0xA6E8, 0xA6E9, 0xA6EA, 0xA6EB, 0xA6EC,
    0xA6ED, 0xA6EE, 0xA6EF, 0xA830, 0xA831, 0xA832, 0xA833, 0xA834,
    0xA835, 0xA8D0, 0xA8D1, 0xA8D2, 0xA8D3, 0xA8D4, 0xA8D5, 0xA8D6,
    0xA8D7, 0xA8D8, 0xA8D9, 0xA900, 0xA901, 0xA902, 0xA903, 0xA904,
    0xA905, 0xA906, 0xA907, 0xA908, 0xA909, 0xA9D0, 0xA9D1, 0xA9D2,
    0xA9D3, 0xA9D4, 0xA9D5, 0xA9D6, 0xA9D7, 0xA9D8, 0xA9D9, 0xA9F0,
    0xA9F1, 0xA9F2, 0xA9F3, 0xA9F4, 0xA9F5, 0xA9F6, 0xA9F7, 0xA9F8,
    0xA9F9, 0xAA50, 0xAA51, 0xAA52, 0xAA53, 0xAA54, 0xAA55, 0xAA56,
    0xAA57, 0xAA58, 0xAA59, 0xABF0, 0xABF1, 0xABF2, 0xABF3, 0xABF4,
    0xABF5, 0xABF6, 0xABF7, 0xABF8, 0xABF9, 0xF96B, 0xF973, 0xF978,
    0xF9B2, 0xF9D1, 0xF9D3, 0xF9FD, 0xFF10, 0xFF11, 0xFF12, 0xFF13,
    0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18, 0xFF19, 0x10107, 0x10108,
    0x10109, 0x1010A, 0x1010B, 0x1010C, 0x1010D, 0x1010E, 0x1010F, 0x10110,
    0x10111, 0x10112, 0x10113, 0x10114, 0x10115, 0x10116, 0x10117, 0x10118,
    0x10119, 0x1011A, 0x1011B, 0x1011C, 0x1011D, 0x1011E, 0x1011F, 0x10120,
    0x10121, 0x10122, 0x10123, 0x10124, 0x10125, 0x10126, 0x10127, 0x10128,
    0x10129, 0x1012A, 0x1012B, 0x1012C, 0x1012D, 0x1012E, 0x1012F, 0x10130,
    0x10131, 0x10132, 0x10133, 0x10140, 0x10141, 0x10142, 0x10143, 0x10144,
    0x10145, 0x10146, 0x10147, 0x10148, 0x10149, 0x1014A, 0x1014B, 0x1014C,
    0x1014D, 0x1014E, 0x1014F, 0x10150, 0x10151, 0x10152, 0x10153, 0x10154,
    0x10155, 0x10156, 0x10157, 0x10158, 0x10159, 0x1015A, 0x1015B, 0x1015C,
    0x1015D, 0x1015E, 0x1015F, 0x10160, 0x10161, 0x10162, 0x10163, 0x10164,
    0x10165, 0x10166, 0x10167, 0x10168, 0x10169, 0x1016A, 0x1016B, 0x1016C,
    0x1016D, 0x1016E, 0x1016F, 0x10170, 0x10171, 0x10172, 0x10173, 0x10174,
    0x10175, 0x10176, 0x10177, 0x10178, 0x1018A, 0x1018B, 0x102E1, 0x102E2,
    0x102E3, 0x102E4, 0x102E5, 0x102E6, 0x102E7, 0x102E8, 0x102E9, 0x102EA,
    0x102EB, 0x102EC, 0x102ED, 0x102EE, 0x102EF, 0x102F0, 0x102F1, 0x102F2,
    0x102F3, 0x102F4, 0x102F5, 0x102F6, 0x102F7, 0x102F8, 0x102F9, 0x102FA,
    0x102FB, 0x10320, 0x10321, 0x10322, 0x10323, 0x10341, 0x1034A, 0x103D1,
    0x103D2, 0x103D3, 0x103D4, 0x103D5, 0x104A0, 0x104A1, 0x104A2, 0x104A3,
    0x104A4, 0x104A5, 0x104A6, 0x104A7, 0x104A8, 0x104A9, 0x10858, 0x10859,
    0x1085A, 0x1085B, 0x1085C, 0x1085D, 0x1085E, 0x1085F, 0x10879, 0x1087A,
    0x1087B, 0x1087C, 0x1087D, 0x1087E, 0x1087F, 0x108A7, 0x108A8, 0x108A9,
    0x108AA, 0x108AB, 0x108AC, 0x108AD, 0x108AE, 0x108AF, 0x108FB, 0x108FC,
    0x108FD, 0x108FE, 0x108FF, 0x10916, 0x10917, 0x10918, 0x10919, 0x1091A,
    0x1091B, 0x109BC, 0x109BD, 0x109C0, 0x109C1, 0x109C2, 0x109C3, 0x109C4,
    0x109C5, 0x109C6, 0x109C7, 0x109C8, 0x109C9, 0x109CA, 0x109CB, 0x109CC,
    0x109CD, 0x109CE, 0x109CF, 0x109D2, 0x109D3, 0x109D4, 0x109D5, 0x109D6,
    0x109D7, 0x109D8, 0x109D9, 0x109DA, 0x109DB, 0x109DC, 0x109DD, 0x109DE,
    0x109DF, 0x109E0, 0x109E1, 0x109E2, 0x109E3, 0x109E4, 0x109E5, 0x109E6,
    0x109E7, 0x109E8, 0x109E9, 0x109EA, 0x109EB, 0x109EC, 0x109ED, 0x109EE,
    0x109EF, 0x109F0, 0x109F1, 0x109F2, 0x109F3, 0x109F4, 0x109F5, 0x109F6,
    0x109F7, 0x109F8, 0x109F9, 0x109FA, 0x109FB, 0x109FC, 0x109FD, 0x109FE,
    0x109FF, 0x10A40, 0x10A41, 0x10A42, 0x10A43, 0x10A44, 0x10A45, 0x10A46,
    0x10A47, 0x10A48, 0x10A7D, 0x10A7E, 0x10A9D, 0x10A9E, 0x10A9F, 0x10AEB,
    0x10AEC, 0x10AED, 0x10AEE, 0x10AEF, 0x10B58, 0x10B59, 0x10B5A, 0x10B5B,
    0x10B5C, 0x10B5D, 0x10B5E, 0x10B5F, 0x10B78, 0x10B79, 0x10B7A, 0x10B7B,
    0x10B7C, 0x10B7D, 0x10B7E, 0x10B7F, 0x10BA9, 0x10BAA, 0x10BAB, 0x10BAC,
    0x10BAD, 0x10BAE, 0x10BAF, 0x10CFA, 0x10CFB, 0x10CFC, 0x10CFD, 0x10CFE,
    0x10CFF, 0x10D30, 0x10D31, 0x10D32, 0x10D33, 0x10D34, 0x10D35, 0x10D36,
    0x10D37, 0x10D38, 0x10D39, 0x10E60, 0x10E61, 0x10E62, 0x10E63, 0x10E64,
    0x10E65, 0x10E66, 0x10E67, 0x10E68, 0x10E69, 0x10E6A, 0x10E6B, 0x10E6C,
    0x10E6D, 0x10E6E, 0x10E6F, 0x10E70, 0x10E71, 0x10E72, 0x10E73, 0x10E74,
    0x10E75, 0x10E76, 0x10E77, 0x10E78, 0x10E79, 0x10E7A, 0x10E7B, 0x10E7C,
    0x10E7D, 0x10E7E, 0x10F1D, 0x10F1E, 0x10F1F, 0x10F20, 0x10F21, 0x10F22,
    0x10F23, 0x10F24, 0x10F25, 0x10F26, 0x10F51, 0x10F52, 0x10F53, 0x10F54,
    0x10FC5, 0x10FC6, 0x10FC7, 0x10FC8, 0x10FC9, 0x10FCA, 0x10FCB, 0x11052,
    0x11053, 0x11054, 0x11055, 0x11056, 0x11057, 0x11058, 0x11059, 0x1105A,
    0x1105B, 0x1105C, 0x1105D, 0x1105E, 0x1105F, 0x11060, 0x11061, 0x11062,
    0x11063, 0x11064, 0x11065, 0x11066, 0x11067, 0x11068, 0x11069, 0x1106A,
    0x1106B, 0x1106C, 0x1106D, 0x1106E, 0x1106F, 0x110F0, 0x110F1, 0x110F2,
    0x110F3, 0x110F4, 0x110F5, 0x110F6, 0x110F7, 0x110F8, 0x110F9, 0x11136,
    0x11137, 0x11138, 0x11139, 0x1113A, 0x1113B, 0x1113C, 0x1113D, 0x1113E,
    0x1113F, 0x111D0, 0x111D1, 0x111D2, 0x111D3, 0x111D4, 0x111D5, 0x111D6,
    0x111D7, 0x111D8, 0x111D9, 0x111E1, 0x111E2, 0x111E3, 0x111E4, 0x111E5,
    0x111E6, 0x111E7, 0x111E8, 0x111E9, 0x111EA, 0x111EB, 0x111EC, 0x111ED,
    0x111EE, 0x111EF, 0x111F0, 0x111F1, 0x111F2, 0x111F3, 0x111F4, 0x112F0,
    0x112F1, 0x112F2, 0x112F3, 0x112F4, 0x112F5, 0x112F6, 0x112F7, 0x112F8,
    0x112F9, 0x11450, 0x11451, 0x11452, 0x11453, 0x11454, 0x11455, 0x11456,
    0x11457, 0x11458, 0x11459, 0x114D0, 0x114D1, 0x114D2, 0x114D3, 0x114D4,
    0x114D5, 0x114D6, 0x114D7, 0x114D8, 0x114D9, 0x11650, 0x11651, 0x11652,
    0x11653, 0x11654, 0x11655, 0x11656, 0x11657, 0x11658, 0x11659, 0x116C0,
    0x116C1, 0x116C2, 0x116C3, 0x116C4, 0x116C5, 0x116C6, 0x116C7, 0x116C8,
    0x116C9, 0x11730, 0x11731, 0x11732, 0x11733, 0x11734, 0x11735, 0x11736,
    0x11737, 0x11738, 0x11739, 0x1173A, 0x1173B, 0x118E0, 0x118E1, 0x118E2,
    0x118E3, 0x118E4, 0x118E5, 0x118E6, 0x118E7, 0x118E8, 0x118E9, 0x118EA,
    0x118EB, 0x118EC, 0x118ED, 0x118EE, 0x118EF, 0x118F0, 0x118F1, 0x118F2,
    0x11950, 0x11951, 0x11952, 0x11953, 0x11954, 0x11955, 0x11956, 0x11957,
    0x11958, 0x11959, 0x11C50, 0x11C51, 0x11C52, 0x11C53, 0x11C54, 0x11C55,
    0x11C56, 0x11C57, 0x11C58, 0x11C59, 0x11C5A, 0x11C5B, 0x11C5C, 0x11C5D,
    0x11C5E, 0x11C5F, 0x11C60, 0x11C61, 0x11C62, 0x11C63, 0x11C64, 0x11C65,
    0x11C66, 0x11C67, 0x11C68, 0x11C69, 0x11C6A, 0x11C6B, 0x11C6C, 0x11D50,
    0x11D51, 0x11D52, 0x11D53, 0x11D54, 0x11D55, 0x11D56, 0x11D57, 0x11D58,
    0x11D59, 0x11DA0, 0x11DA1, 0x11DA2, 0x11DA3, 0x11DA4, 0x11DA5, 0x11DA6,
    0x11DA7, 0x11DA8, 0x11DA9, 0x11FC0, 0x11FC1, 0x11FC2, 0x11FC3, 0x11FC4,
    0x11FC5, 0x11FC6, 0x11FC7, 0x11FC8, 0x11FC9, 0x11FCA, 0x11FCB, 0x11FCC,
    0x11FCD, 0x11FCE, 0x11FCF, 0x11FD0, 0x11FD1, 0x11FD2, 0x11FD3, 0x11FD4,
    0x12400, 0x12401, 0x12402, 0x12403, 0x12404, 0x12405, 0x12406, 0x12407,
    0x12408, 0x12409, 0x1240A, 0x1240B, 0x1240C, 0x1240D, 0x1240E, 0x1240F,
    0x12410, 0x12411, 0x12412, 0x12413, 0x12414, 0x12415, 0x12416, 0x12417,
    0x12418, 0x12419, 0x1241A, 0x1241B, 0x1241C, 0x1241D, 0x1241E, 0x1241F,
    0x12420, 0x12421, 0x12422, 0x12423, 0x12424, 0x12425, 0x12426, 0x12427,
    0x12428, 0x12429, 0x1242A, 0x1242B, 0x1242C, 0x1242D, 0x1242E, 0x1242F,
    0x12430, 0x12431, 0x12432, 0x12433, 0x12434, 0x12435, 0x12436, 0x12437,
    0x12438, 0x12439, 0x1243A, 0x1243B, 0x1243C, 0x1243D, 0x1243E, 0x1243F,
    0x12440, 0x12441, 0x12442, 0x12443, 0x12444, 0x12445, 0x12446, 0x12447,
    0x12448, 0x12449, 0x1244A, 0x1244B, 0x1244C, 0x1244D, 0x1244E, 0x1244F,
    0x12450, 0x12451, 0x12452, 0x12453, 0x12454, 0x12455, 0x12456, 0x12457,
    0x12458, 0x12459, 0x1245A, 0x1245B, 0x1245C, 0x1245D, 0x1245E, 0x1245F,
    0x12460, 0x12461, 0x12462, 0x12463, 0x12464, 0x12465, 0x12466, 0x12467,
    0x12468, 0x12469, 0x1246A, 0x1246B, 0x1246C, 0x1246D, 0x1246E, 0x16A60,
    0x16A61, 0x16A62, 0x16A63, 0x16A64, 0x16A65, 0x16A66, 0x16A67, 0x16A68,
    0x16A69, 0x16B50, 0x16B51, 0x16B52, 0x16B53, 0x16B54, 0x16B55, 0x16B56,
    0x16B57, 0x16B58, 0x16B59, 0x16B5B, 0x16B5C, 0x16B5D, 0x16B5E, 0x16B5F,
    0x16B60, 0x16B61, 0x16E80, 0x16E81, 0x16E82, 0x16E83, 0x16E84, 0x16E85,
    0x16E86, 0x16E87, 0x16E88, 0x16E89, 0x16E8A, 0x16E8B, 0x16E8C, 0x16E8D,
    0x16E8E, 0x16E8F, 0x16E90, 0x16E91, 0x16E92, 0x16E93, 0x16E94, 0x16E95,
    0x16E96, 0x1D2E0, 0x1D2E1, 0x1D2E2, 0x1D2E3, 0x1D2E4, 0x1D2E5, 0x1D2E6,
    0x1D2E7, 0x1D2E8, 0x1D2E9, 0x1D2EA, 0x1D2EB, 0x1D2EC, 0x1D2ED, 0x1D2EE,
    0x1D2EF, 0x1D2F0, 0x1D2F1, 0x1D2F2, 0x1D2F3, 0x1D360, 0x1D361, 0x1D362,
    0x1D363, 0x1D364, 0x1D365, 0x1D366, 0x1D367, 0x1D368, 0x1D369, 0x1D36A,
    0x1D36B, 0x1D36C, 0x1D36D, 0x1D36E, 0x1D36F, 0x1D370, 0x1D371, 0x1D372,
    0x1D373, 0x1D374, 0x1D375, 0x1D376, 0x1D377, 0x1D378, 0x1D7CE, 0x1D7CF,
    0x1D7D0, 0x1D7D1, 0x1D7D2, 0x1D7D3, 0x1D7D4, 0x1D7D5, 0x1D7D6, 0x1D7D7,
    0x1D7D8, 0x1D7D9, 0x1D7DA, 0x1D7DB, 0x1D7DC, 0x1D7DD, 0x1D7DE, 0x1D7DF,
    0x1D7E0, 0x1D7E1, 0x1D7E2, 0x1D7E3, 0x1D7E4, 0x1D7E5, 0x1D7E6, 0x1D7E7,
    0x1D7E8, 0x1D7E9, 0x1D7EA, 0x1D7EB, 0x1D7EC, 0x1D7ED, 0x1D7EE, 0x1D7EF,
    0x1D7F0, 0x1D7F1, 0x1D7F2, 0x1D7F3, 0x1D7F4, 0x1D7F5, 0x1D7F6, 0x1D7F7,
    0x1D7F8, 0x1D7F9, 0x1D7FA, 0x1D7FB, 0x1D7FC, 0x1D7FD, 0x1D7FE, 0x1D7FF,
    0x1E140, 0x1E141, 0x1E142, 0x1E143, 0x1E144, 0x1E145, 0x1E146, 0x1E147,
    0x1E148, 0x1E149, 0x1E2F0, 0x1E2F1, 0x1E2F2, 0x1E2F3, 0x1E2F4, 0x1E2F5,
    0x1E2F6, 0x1E2F7, 0x1E2F8, 0x1E2F9, 0x1E8C7, 0x1E8C8, 0x1E8C9, 0x1E8CA,
    0x1E8CB, 0x1E8CC, 0x1E8CD, 0x1E8CE, 0x1E8CF, 0x1E950, 0x1E951, 0x1E952,
    0x1E953, 0x1E954, 0x1E955, 0x1E956, 0x1E957, 0x1E958, 0x1E959, 0x1EC71,
    0x1EC72, 0x1EC73, 0x1EC74, 0x1EC75, 0x1EC76, 0x1EC77, 0x1EC78, 0x1EC79,
    0x1EC7A, 0x1EC7B, 0x1EC7C, 0x1EC7D, 0x1EC7E, 0x1EC7F, 0x1EC80, 0x1EC81,
    0x1EC82, 0x1EC83, 0x1EC84, 0x1EC85, 0x1EC86, 0x1EC87, 0x1EC88, 0x1EC89,
    0x1EC8A, 0x1EC8B, 0x1EC8C, 0x1EC8D, 0x1EC8E, 0x1EC8F, 0x1EC90, 0x1EC91,
    0x1EC92, 0x1EC93, 0x1EC94, 0x1EC95, 0x1EC96, 0x1EC97, 0x1EC98, 0x1EC99,
    0x1EC9A, 0x1EC9B, 0x1EC9C, 0x1EC9D, 0x1EC9E, 0x1EC9F, 0x1ECA0, 0x1ECA1,
    0x1ECA2, 0x1ECA3, 0x1ECA4, 0x1ECA5, 0x1ECA6, 0x1ECA7, 0x1ECA8, 0x1ECA9,
    0x1ECAA, 0x1ECAB, 0x1ECAD, 0x1ECAE, 0x1ECAF, 0x1ECB1, 0x1ECB2, 0x1ECB3,
    0x1ECB4, 0x1ED01, 0x1ED02, 0x1ED03, 0x1ED04, 0x1ED05, 0x1ED06, 0x1ED07,
    0x1ED08, 0x1ED09, 0x1ED0A, 0x1ED0B, 0x1ED0C, 0x1ED0D, 0x1ED0E, 0x1ED0F,
    0x1ED10, 0x1ED11, 0x1ED12, 0x1ED13, 0x1ED14, 0x1ED15, 0x1ED16, 0x1ED17,
    0x1ED18, 0x1ED19, 0x1ED1A, 0x1ED1B, 0x1ED1C, 0x1ED1D, 0x1ED1E, 0x1ED1F,
    0x1ED20, 0x1ED21, 0x1ED22, 0x1ED23, 0x1ED24, 0x1ED25, 0x1ED26, 0x1ED27,
    0x1ED28, 0x1ED29, 0x1ED2A, 0x1ED2B, 0x1ED2C, 0x1ED2D, 0x1ED2F, 0x1ED30,
    0x1ED31, 0x1ED32, 0x1ED33, 0x1ED34, 0x1ED35, 0x1ED36, 0x1ED37, 0x1ED38,
    0x1ED39, 0x1ED3A, 0x1ED3B, 0x1ED3C, 0x1ED3D, 0x1F100, 0x1F101, 0x1F102,
    0x1F103, 0x1F104, 0x1F105, 0x1F106, 0x1F107, 0x1F108, 0x1F109, 0x1F10A,
    0x1F10B, 0x1F10C, 0x1FBF0, 0x1FBF1, 0x1FBF2, 0x1FBF3, 0x1FBF4, 0x1FBF5,
    0x1FBF6, 0x1FBF7, 0x1FBF8, 0x1FBF9, 0x2F890
};

const int32_t NUMERICS_DECIMAL[] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, -1, -1, -1, -1,
    -1, -1, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    -1, -1, -1, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    1, 2, 3, 4, 5, 6, 7, 8, 9, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    1, 2, 3, 4, 5, 6, 7, 8, 9, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, -1
};

const int32_t NUMERICS_DIGIT[] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    2, 3, 1, -1, -1, -1, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, -1, -1, -1, -1,
    -1, -1, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, -1, -1, -1, -1, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, -1, -1,
    -1, -1, -1, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, 0, 1, 2,
    3, 4, 5, 6, 7, 8, 9, 1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, 0, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 1, 2, 3, 4, 5, 6, 7, 8,
    9, -1, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    1, 2, 3, 4, 5, 6, 7, 8, 9, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, 0, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 1, 2, 3, 4, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8,
    9, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 1, 2, 3, 4, 5, 6, 7,
    8, 9, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, 0, 1, 2, 3, 4, 5,
    6, 7, 8, 9, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, 0, 1, 2, 3, 4,
    5, 6, 7, 8, 9, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    1, 2, 3, 4, 5, 6, 7, 8, 9, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, 0, 0, 1, 2, 3,
    4, 5, 6, 7, 8, 9, -1, -1, 0, 1,
    2, 3, 4, 5, 6, 7, 8, 9, -1
};

const int64_t NUMERICS_NUMERATOR[] = {
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    2LL, 3LL, 1LL, 1LL, 1LL, 3LL, 0LL, 1LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 1LL, 1LL, 3LL, 1LL,
    3LL, 16LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 1LL, 1LL, 3LL, 1LL, 1LL, 3LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 100LL,
    1000LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL,
    9LL, 0LL, 1LL, 2LL, 3LL, 1LL, 2LL, 3LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 1LL, 1LL,
    3LL, 1LL, 1LL, 3LL, 1LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 100LL, 1000LL, 1LL, 1LL,
    3LL, 1LL, 1LL, 3LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 1LL, 3LL, 5LL, 7LL, 9LL, 11LL,
    13LL, 15LL, 17LL, -1LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL,
    80LL, 90LL, 100LL, 10000LL, 17LL, 18LL, 19LL, 0LL, 1LL, 2LL,
    3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL,
    3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL,
    3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL,
    3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL,
    3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 1LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 1LL, 1LL, 1LL, 1LL, 2LL,
    1LL, 2LL, 3LL, 4LL, 1LL, 5LL, 1LL, 3LL, 5LL, 7LL,
    1LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    10LL, 11LL, 12LL, 50LL, 100LL, 500LL, 1000LL, 1LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 11LL, 12LL, 50LL,
    100LL, 500LL, 1000LL, 1000LL, 5000LL, 10000LL, 6LL, 50LL, 50000LL, 100000LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    10LL, 11LL, 12LL, 13LL, 14LL, 15LL, 16LL, 17LL, 18LL, 19LL,
    20LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    10LL, 11LL, 12LL, 13LL, 14LL, 15LL, 16LL, 17LL, 18LL, 19LL,
    20LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    10LL, 11LL, 12LL, 13LL, 14LL, 15LL, 16LL, 17LL, 18LL, 19LL,
    20LL, 0LL, 11LL, 12LL, 13LL, 14LL, 15LL, 16LL, 17LL, 18LL,
    19LL, 20LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL,
    9LL, 10LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 10LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 10LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 10LL, 1LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 10LL, 20LL, 30LL, 1LL, 2LL, 3LL,
    4LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    10LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL, 80LL, 21LL,
    22LL, 23LL, 24LL, 25LL, 26LL, 27LL, 28LL, 29LL, 30LL, 31LL,
    32LL, 33LL, 34LL, 35LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 10LL, 36LL, 37LL, 38LL, 39LL, 40LL, 41LL,
    42LL, 43LL, 44LL, 45LL, 46LL, 47LL, 48LL, 49LL, 50LL, 0LL,
    1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL,
    1LL, 3LL, 1LL, 1LL, 3LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 3LL, 10LL, 2LL, 0LL, 6LL,
    6LL, 10LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL,
    9LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL, 80LL, 90LL,
    100LL, 200LL, 300LL, 400LL, 500LL, 600LL, 700LL, 800LL, 900LL, 1000LL,
    2000LL, 3000LL, 4000LL, 5000LL, 6000LL, 7000LL, 8000LL, 9000LL, 10000LL, 20000LL,
    30000LL, 40000LL, 50000LL, 60000LL, 70000LL, 80000LL, 90000LL, 1LL, 1LL, 1LL,
    5LL, 50LL, 500LL, 5000LL, 50000LL, 5LL, 10LL, 50LL, 100LL, 500LL,
    1000LL, 5000LL, 5LL, 10LL, 50LL, 100LL, 500LL, 1000LL, 10000LL, 50000LL,
    10LL, 1LL, 1LL, 1LL, 2LL, 2LL, 2LL, 2LL, 5LL, 10LL,
    10LL, 10LL, 10LL, 10LL, 30LL, 50LL, 50LL, 50LL, 50LL, 100LL,
    300LL, 500LL, 500LL, 500LL, 500LL, 500LL, 1000LL, 5000LL, 5LL, 50LL,
    1LL, 1LL, 2LL, 3LL, 0LL, 1LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL,
    60LL, 70LL, 80LL, 90LL, 100LL, 200LL, 300LL, 400LL, 500LL, 600LL,
    700LL, 800LL, 900LL, 1LL, 5LL, 10LL, 50LL, 90LL, 900LL, 1LL,
    2LL, 10LL, 20LL, 100LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 1LL, 2LL, 3LL, 10LL, 20LL, 100LL,
    1000LL, 10000LL, 1LL, 2LL, 3LL, 4LL, 5LL, 10LL, 20LL, 1LL,
    2LL, 3LL, 4LL, 4LL, 5LL, 10LL, 20LL, 100LL, 1LL, 5LL,
    10LL, 20LL, 100LL, 1LL, 10LL, 20LL, 100LL, 2LL, 3LL, 11LL,
    1LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL, 100LL, 200LL, 300LL,
    400LL, 500LL, 600LL, 700LL, 800LL, 900LL, 1000LL, 2000LL, 3000LL, 4000LL,
    5000LL, 6000LL, 7000LL, 8000LL, 9000LL, 10000LL, 20000LL, 30000LL, 40000LL, 50000LL,
    60000LL, 70000LL, 80000LL, 90000LL, 100000LL, 200000LL, 300000LL, 400000LL, 500000LL, 600000LL,
    700000LL, 800000LL, 900000LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 10LL, 1LL, 2LL, 3LL, 4LL, 10LL, 20LL, 100LL,
    1000LL, 1LL, 1LL, 50LL, 1LL, 10LL, 20LL, 1LL, 5LL, 10LL,
    20LL, 100LL, 1LL, 2LL, 3LL, 4LL, 10LL, 20LL, 100LL, 1000LL,
    1LL, 2LL, 3LL, 4LL, 10LL, 20LL, 100LL, 1000LL, 1LL, 2LL,
    3LL, 4LL, 10LL, 20LL, 100LL, 1LL, 5LL, 10LL, 50LL, 100LL,
    1000LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL,
    9LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL, 80LL, 90LL, 100LL,
    200LL, 300LL, 400LL, 500LL, 600LL, 700LL, 800LL, 900LL, 1LL, 1LL,
    1LL, 2LL, 1LL, 2LL, 3LL, 4LL, 5LL, 10LL, 20LL, 30LL,
    100LL, 1LL, 1LL, 10LL, 20LL, 100LL, 1LL, 2LL, 3LL, 4LL,
    10LL, 20LL, 100LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL, 80LL,
    90LL, 100LL, 1000LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL, 80LL,
    90LL, 100LL, 1000LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 10LL, 20LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL,
    60LL, 70LL, 80LL, 90LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL, 70LL,
    80LL, 90LL, 100LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL,
    7LL, 8LL, 9LL, 1LL, 1LL, 1LL, 1LL, 1LL, 1LL, 3LL,
    3LL, 1LL, 1LL, 1LL, 1LL, 1LL, 3LL, 3LL, 1LL, 1LL,
    1LL, 1LL, 3LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 1LL, 2LL, 3LL, 4LL, 5LL, 2LL,
    3LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 1LL, 2LL,
    3LL, 3LL, 4LL, 5LL, 216000LL, 432000LL, 1LL, 2LL, 3LL, 3LL,
    4LL, 5LL, 3LL, 3LL, 4LL, 4LL, 4LL, 4LL, 6LL, 7LL,
    7LL, 7LL, 8LL, 8LL, 9LL, 9LL, 9LL, 9LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 1LL, 2LL, 3LL, 4LL, 4LL, 5LL, 5LL,
    2LL, 3LL, 1LL, 2LL, 1LL, 2LL, 5LL, 1LL, 2LL, 1LL,
    1LL, 1LL, 1LL, 1LL, 1LL, 1LL, 2LL, 40LL, 50LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 100LL, 10000LL, 1000000LL, 100000000LL,
    10000000000LL, 1000000000000LL, 0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL,
    8LL, 9LL, 10LL, 11LL, 12LL, 13LL, 14LL, 15LL, 16LL, 17LL,
    18LL, 19LL, 1LL, 2LL, 3LL, 0LL, 1LL, 2LL, 3LL, 4LL,
    5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 11LL, 12LL, 13LL, 14LL,
    15LL, 16LL, 17LL, 18LL, 19LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL,
    70LL, 80LL, 90LL, 1LL, 2LL, 3LL, 4LL, 5LL, 1LL, 5LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    0LL, 1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL,
    1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL,
    1LL, 2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 20LL,
    30LL, 40LL, 50LL, 60LL, 70LL, 80LL, 90LL, 100LL, 200LL, 300LL,
    400LL, 500LL, 600LL, 700LL, 800LL, 900LL, 1000LL, 2000LL, 3000LL, 4000LL,
    5000LL, 6000LL, 7000LL, 8000LL, 9000LL, 10000LL, 20000LL, 30000LL, 40000LL, 50000LL,
    60000LL, 70000LL, 80000LL, 90000LL, 100000LL, 200000LL, 100000LL, 10000000LL, 20000000LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 1LL, 1LL,
    3LL, 1LL, 2LL, 10000LL, 100000LL, 1LL, 2LL, 3LL, 4LL, 5LL,
    6LL, 7LL, 8LL, 9LL, 10LL, 20LL, 30LL, 40LL, 50LL, 60LL,
    70LL, 80LL, 90LL, 100LL, 200LL, 300LL, 400LL, 500LL, 600LL, 700LL,
    800LL, 900LL, 1000LL, 2000LL, 3000LL, 4000LL, 5000LL, 6000LL, 7000LL, 8000LL,
    9000LL, 10000LL, 20000LL, 30000LL, 40000LL, 50000LL, 60000LL, 70000LL, 80000LL, 90000LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 10LL, 400LL,
    600LL, 2000LL, 10000LL, 1LL, 1LL, 0LL, 0LL, 1LL, 2LL, 3LL,
    4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 0LL, 0LL, 0LL, 1LL,
    2LL, 3LL, 4LL, 5LL, 6LL, 7LL, 8LL, 9LL, 9LL
};

const int32_t NUMERICS_DENOMINATOR[] = {
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 4, 2, 4, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 16, 8, 16, 4,
    4, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 4, 2, 4, 16, 8, 16, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 160, 40,
    80, 20, 10, 20, 5, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 4, 2,
    4, 16, 8, 16, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 2, 2, 2, 2, 2, 2,
    2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 7, 9, 10, 3, 3,
    5, 5, 5, 5, 6, 6, 8, 8, 8, 8,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 2, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 4,
    2, 4, 16, 8, 16, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 4, 2, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    2, 2, 3, 4, 1, 4, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 12,
    2, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 2, 4,
    3, 3, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 2, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 320, 160, 80, 64, 40, 32, 80,
    64, 20, 16, 16, 10, 8, 20, 16, 5, 4,
    2, 2, 4, 320, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 3, 3, 6, 3, 3, 8,
    4, 6, 4, 4, 2, 3, 3, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 4, 2,
    4, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 2, 6, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1
};

}  // namespace unicode
