import { IResource } from '@aws-cdk/core';
/**
 * Imported or created hosted zone.
 *
 * @stability stable
 */
export interface IHostedZone extends IResource {
    /**
     * ID of this hosted zone, such as "Z23ABC4XYZL05B".
     *
     * @stability stable
     * @attribute true
     */
    readonly hostedZoneId: string;
    /**
     * FQDN of this hosted zone.
     *
     * @stability stable
     */
    readonly zoneName: string;
    /**
     * ARN of this hosted zone, such as arn:${Partition}:route53:::hostedzone/${Id}.
     *
     * @stability stable
     * @attribute true
     */
    readonly hostedZoneArn: string;
    /**
     * Returns the set of name servers for the specific hosted zone. For example: ns1.example.com.
     *
     * This attribute will be undefined for private hosted zones or hosted zones imported from another stack.
     *
     * @stability stable
     * @attribute true
     */
    readonly hostedZoneNameServers?: string[];
}
/**
 * Reference to a hosted zone.
 *
 * @stability stable
 */
export interface HostedZoneAttributes {
    /**
     * Identifier of the hosted zone.
     *
     * @stability stable
     */
    readonly hostedZoneId: string;
    /**
     * Name of the hosted zone.
     *
     * @stability stable
     */
    readonly zoneName: string;
}
