# topdesk

An API client for [TOPdesk](https://topdesk.com) in Python, using `requests`.

## Installation

`topdesk` can be obtained through pip:

```
pip install topdesk
```

## Usage

All requests are encapsulated in a `Topdesk` object. To construct this object, you
need to supply it with a URL and username/token pair:

```python
from topdesk import Topdesk

topdesk = Topdesk("<topdesk url>" app_creds=("<username>", "<token>"))
```

Then you can start requesting. Let’s get the API version!

```python
print(topdesk.version())
```

This will return a dictionary representing the JSON body of the response. If it
fails it will throw an exception that inherits from `topdesk.HttpException`, for
instance `topdesk.NotFound` for `404 Not Found` errors.

If you don’t have a token, you can also login as a person or operator. I
wholeheartedly recommend tokens, though.

```python
topdesk.login_person("<username>", "<password>")
# or alternatively
topdesk.login_operator("<username>", "<password>")
```

Then we can try and request some information! Let’s get a list of incidents that
are not resolved, and order them by their target date!

```python
print(topdesk.incidents({'order_by': "target_date+ASC", 'resolved': False}))
```

The API is somewhat well documented. You can explore it from your REPL through
the `help` function or look at the [autogenerated documentation](/build/html/index.html).

## Caveats

The Knowledge Base API is currently not supported, because it uses GraphQL
whereas the rest of the API uses REST. If you have experience with and/or
interest in GraphQL, I invite you to submit a patch!

The Supporting Files API is not yet supported. It’s a large swath of useful
API functions that we do not wrap until now. If you need to use any of the
endpoints, you’ll have to fall back to the lower-level `get`, `put`, `patch`,
`post`, and `delete` methods.

<hr/>

Have fun!
