from sqlalchemy import Column, Integer, String, ForeignKey
from sqlalchemy.orm import relationship

from ..base import Base


class MetaData(Base):
    __tablename__ = "novel_metadata"

    id = Column(Integer, primary_key=True)
    name = Column(String, nullable=False)
    value = Column(String, nullable=False)
    namespace = Column(String)
    others = Column(String)

    novel_id = Column(Integer, ForeignKey("novels.id"))
    novel = relationship("Novel", back_populates="novel_metadata")
