"""initial

Revision ID: e5c4fb5600ea
Revises:
Create Date: 2021-08-24 11:30:55.605615

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "e5c4fb5600ea"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    asset_types = op.create_table(
        "asset_types",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=16), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "novels",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("author", sa.String(), nullable=True),
        sa.Column("synopsis", sa.String(), nullable=True),
        sa.Column("lang", sa.String(), nullable=True),
        sa.Column("thumbnail_url", sa.String(), nullable=True),
        sa.Column("thumbnail_path", sa.String(), nullable=True),
        sa.Column(
            "last_updated",
            sa.TIMESTAMP(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=True,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "assets",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("url", sa.String(), nullable=True),
        sa.Column("path", sa.String(), nullable=True),
        sa.Column("type_id", sa.Integer(), nullable=False),
        sa.Column("novel_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["novel_id"],
            ["novels.id"],
        ),
        sa.ForeignKeyConstraint(
            ["type_id"],
            ["asset_types.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("novel_id", "url"),
    )
    op.create_table(
        "novel_metadata",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("value", sa.String(), nullable=False),
        sa.Column("namespace", sa.String(), nullable=True),
        sa.Column("others", sa.String(), nullable=True),
        sa.Column("novel_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["novel_id"],
            ["novels.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "novel_urls",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("url", sa.String(), nullable=False),
        sa.Column("novel_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["novel_id"],
            ["novels.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "volumes",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("novel_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["novel_id"],
            ["novels.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("novel_id", "index"),
    )
    op.create_table(
        "chapters",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("index", sa.Integer(), nullable=False),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("url", sa.String(), nullable=False),
        sa.Column("content", sa.String(), nullable=True),
        sa.Column("volume_id", sa.Integer(), nullable=False),
        sa.Column(
            "last_updated",
            sa.TIMESTAMP(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["volume_id"],
            ["volumes.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("volume_id", "index"),
    )
    # ### end Alembic commands ###

    op.bulk_insert(asset_types, [{"id": 1, "name": "image"}])


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("chapters")
    op.drop_table("volumes")
    op.drop_table("novel_urls")
    op.drop_table("novel_metadata")
    op.drop_table("assets")
    op.drop_table("novels")
    op.drop_table("asset_types")
    # ### end Alembic commands ###
