export const modelParameters = [
    {
        name: "Logistic Regression",
        value: "Logistic Regression",
        parameters: [
            {
                name: "penalty",
                type: "select",
                options: ['l1', 'l2', 'elasticnet', 'none'],
                default: 'l2',
                render: true,
                optional: true,
            },
            {
                name: "fit_intercept",
                type: "bool",
                options: [true, false],
                default: true,
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "solver",
                type: "select",
                options: ['newton-cg', 'lbfgs', 'liblinear', 'sag', 'saga'],
                default: 'lbfgs',
                render: true,
                optional: true,

                // ‘newton-cg’ - [‘l2’, ‘none’]
                // ‘lbfgs’ - [‘l2’, ‘none’]
                // ‘liblinear’ - [‘l1’, ‘l2’]
                // ‘sag’ - [‘l2’, ‘none’]
                // ‘saga’ - [‘elasticnet’, ‘l1’, ‘l2’, ‘none’]
            },
            {
                name: "max_iter",
                type: "int",
                default: 100,
                render: true,
                optional: true,
            },
            {
                name: "multi_class",
                type: "select",
                options: ['auto', 'ovr', 'multinomial'],
                default: 'auto',
                render: true,
                optional: true,
            },
            {
                name: "tol",
                type: "float",
                default: 1e-4,
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "SVM (SVC)",
        value: "SVM (SVC)",
        parameters: [
            {
                name: "C",
                type: "float",
                default: 1.0,
                render: true,
                optional: true,
            },
            {
                name: "kernel",
                type: "select",
                options: ['linear', 'poly', 'rbf', 'sigmoid', 'precomputed'],
                default: 'rbf',
                render: true,
                optional: true,
            },
            {
                name: "probability",
                type: "bool",
                options: [true, false],
                default: false,
                render: true,
                optional: true,
            },
            {
                name: "tol",
                type: "float",
                default: 1e-3,
                render: true,
                optional: true,
            },
            {
                name: "max_iter",
                type: "int",
                default: -1,
                render: true,
                optional: true,
            },
            {
                name: "decision_function_shape",
                type: "select",
                options: ['ovo', 'ovr'],
                default: 'ovr',
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "Gaussian Naive Bayes",
        value: "Gaussian Naive Bayes",
        parameters: [
            {
                name: "priors",
                type: "array",
                render: true,
                optional: true,
            },
            {
                name: "var_smoothing",
                type: "float",
                default: 1e-9,
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "Multinomial Naive Bayes",
        value: "Multinomial Naive Bayes",
        parameters: [
            {
                name: "class_prior",
                type: "array",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "alpha",
                type: "float",
                default: 1.0,
                render: true,
                optional: true,
            },
            {
                name: "fit_prior",
                type: "bool",
                options: [true, false],
                default: true,
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "Stochastic Gradient Descent Classifier",
        value: "Stochastic Gradient Descent Classifier",
        parameters: [
            {
                name: "loss",
                type: "select",
                options: ['hinge', 'log_loss', 'log', 'modified_huber', 'squared_hinge', 'perceptron', 
                        'squared_error', 'huber', 'epsilon_insensitive', 'squared_epsilon_insensitive'],
                default: 'hinge',
                render: true,
                optional: true,
            },
            {
                name: "penalty",
                type: "select",
                options: ['l2', 'l1', 'elasticnet'],
                default: 'l2',
                render: true,
                optional: true,
            },
            {
                name: "fit_intercept",
                type: "bool",
                options: [true, false],
                default: true,
                render: true,
                optional: true,
            },
            {
                name: "alpha",
                type: "float",
                default: 0.0001,
                render: true,
                optional: true,
            },
            {
                name: "max_iter",
                type: "int",
                default: 1000,
                render: true,
                optional: true,
            },
            {
                name: "tol",
                type: "float",
                default: 1e-3,
                render: true,
                optional: true,
            },
            {
                name: "shuffle",
                type: "bool",
                options: [true, false],
                default: true,
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "learning_rate",
                type: "select",
                options: ['constant','optimal','invscaling','adaptive'],
                default: 'optimal',
                render: true,
                optional: true,
            },
            {
                name: "initial_learning_rate",    //for constant, invscaling, adaptive
                type: "float",
                default: 0.0,
                render: true,
                optional: true,
            },
            {
                name: "early_stopping",
                type: "bool",
                options: [true, false],
                default: false,
                render: true,
                optional: true,
            },
            {
                name: "validation_fraction",   //only for early_stopping == true
                type: "float",
                default: 1.0,
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "KNN",
        value: "KNN",
        parameters: [
            {
                name: "n_neighbors",
                type: "int",
                default: 5,
                render: true,
                optional: true,
            },
            {
                name: "weights",
                type: "select",
                options: ['uniform', 'distance'], //or callable (user-defined function)
                default: 'uniform',
                render: true,
                optional: true,
            },
            {
                name: "algorithm",
                type: "select",
                options: ['auto', 'ball_tree', 'kd_tree', 'brute'],
                default: 'auto',
                render: true,
                optional: true,
            },
            {
                name: "metric",
                type: "string",
                default: 'minkowski',
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "Decision Tree Classifier",
        value: "Decision Tree Classifier",
        parameters: [
            {
                name: "criterion",
                type: "select",
                options: ['gini', 'entropy', 'log_loss'],
                default: 'gini',
                render: true,
                optional: true,
            },
            {
                name: "splitter",
                type: "select",
                options: ['best', 'random'],
                default: 'best',
                render: true,
                optional: true,
            },
            {
                name: "max_depth",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "max_leaf_nodes",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "Random Forest Classifier",
        value: "Random Forest Classifier",
        parameters: [
            {
                name: "n_estimators",
                type: "int",
                default: 100,
                render: true,
                optional: true,
            },
            {
                name: "criterion",
                type: "select",
                options: ['gini', 'entropy', 'log_loss'],
                default: 'gini',
                render: true,
                optional: true,
            },
            {
                name: "max_depth",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "max_leaf_nodes",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "Gradient Boosting Classifier",
        value: "Gradient Boosting Classifier",
        parameters: [
            {
                name: "loss",
                type: "select",
                options: ['log_loss', 'deviance', 'exponential'],
                default: 'log_loss',
                render: true,
                optional: true,
            },
            {
                name: "learning_rate",
                type: "float",
                default: 1.0,
                render: true,
                optional: true,
            },
            {
                name: "n_estimators",
                type: "int",
                default: 100,
                render: true,
                optional: true,
            },
            {
                name: "subsample",  //(0.0, 1.0]
                type: "float",
                default: 1.0,
                render: true,
                optional: true,
            },
            {
                name: "criterion",
                type: "select",
                options: ['friedman_mse', 'squared_error', 'mse'],
                default: 'mse',
                render: true,
                optional: true,
            },
            {
                name: "max_depth",
                type: "int",
                default: 3,
                render: true,
                optional: true,
            },
            {
                name: "max_leaf_nodes",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
            {
                name: "tol",
                type: "float",
                default: 1e-4,
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "LGBM Classifier",
        value: "LGBM Classifier",
        parameters: [
            {
                name: "boosting_type",
                type: "select",
                options: ['gbdt', 'dart', 'goss','rf'],
                default: 'gbdt',
                render: true,
                optional: true,
            },
            {
                name: "num_leaves",
                type: "int",
                default: 31,
                render: true,
                optional: true,
            },
            {
                name: "learning_rate",
                type: "float",
                default: 0.1,
                render: true,
                optional: true,
            },
            {
                name: "n_estimators",
                type: "int",
                default: 100,
                render: true,
                optional: true,
            },
            {
                name: "max_depth",
                type: "int",
                default: -1,
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 'None',
                render: true,
                optional: true,
            },
          ],
    },
    {
        name: "XGBoost Classifier",
        value: "XGBoost Classifier",
        parameters: [
            {
                name: "learning_rate",
                type: "float",
                default: 0.1,
                render: true,
                optional: true,
            },
            {
                name: "n_estimators",
                type: "int",
                default: 100,
                render: true,
                optional: true,
            },
            {
                name: "max_depth",
                type: "int",
                default: 3,
                render: true,
                optional: true,
            },
            {
                name: "random_state",
                type: "int",
                default: 0,
                render: true,
                optional: true,
            },
          ],
    },
]