/**
 * What kind of addresses to allocate to the load balancer.
 *
 * @stability stable
 */
export declare enum IpAddressType {
    /**
     * Allocate IPv4 addresses.
     *
     * @stability stable
     */
    IPV4 = "ipv4",
    /**
     * Allocate both IPv4 and IPv6 addresses.
     *
     * @stability stable
     */
    DUAL_STACK = "dualstack"
}
/**
 * Backend protocol for network load balancers and health checks.
 *
 * @stability stable
 */
export declare enum Protocol {
    /**
     * HTTP (ALB health checks and NLB health checks).
     *
     * @stability stable
     */
    HTTP = "HTTP",
    /**
     * HTTPS (ALB health checks and NLB health checks).
     *
     * @stability stable
     */
    HTTPS = "HTTPS",
    /**
     * TCP (NLB, NLB health checks).
     *
     * @stability stable
     */
    TCP = "TCP",
    /**
     * TLS (NLB).
     *
     * @stability stable
     */
    TLS = "TLS",
    /**
     * UDP (NLB).
     *
     * @stability stable
     */
    UDP = "UDP",
    /**
     * Listen to both TCP and UDP on the same port (NLB).
     *
     * @stability stable
     */
    TCP_UDP = "TCP_UDP"
}
/**
 * Load balancing protocol for application load balancers.
 *
 * @stability stable
 */
export declare enum ApplicationProtocol {
    /**
     * HTTP.
     *
     * @stability stable
     */
    HTTP = "HTTP",
    /**
     * HTTPS.
     *
     * @stability stable
     */
    HTTPS = "HTTPS"
}
/**
 * Load balancing protocol version for application load balancers.
 *
 * @stability stable
 */
export declare enum ApplicationProtocolVersion {
    /**
     * GRPC.
     *
     * @stability stable
     */
    GRPC = "GRPC",
    /**
     * HTTP1.
     *
     * @stability stable
     */
    HTTP1 = "HTTP1",
    /**
     * HTTP2.
     *
     * @stability stable
     */
    HTTP2 = "HTTP2"
}
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers.
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 * @stability stable
 */
export declare enum SslPolicy {
    /**
     * The recommended security policy.
     *
     * @stability stable
     */
    RECOMMENDED = "ELBSecurityPolicy-2016-08",
    /**
     * Strong foward secrecy ciphers and TLV1.2 only (2020 edition). Same as FORWARD_SECRECY_TLS12_RES, but only supports GCM versions of the TLS ciphers.
     *
     * @stability stable
     */
    FORWARD_SECRECY_TLS12_RES_GCM = "ELBSecurityPolicy-FS-1-2-Res-2020-10",
    /**
     * Strong forward secrecy ciphers and TLS1.2 only.
     *
     * @stability stable
     */
    FORWARD_SECRECY_TLS12_RES = "ELBSecurityPolicy-FS-1-2-Res-2019-08",
    /**
     * Forward secrecy ciphers and TLS1.2 only.
     *
     * @stability stable
     */
    FORWARD_SECRECY_TLS12 = "ELBSecurityPolicy-FS-1-2-2019-08",
    /**
     * Forward secrecy ciphers only with TLS1.1 and higher.
     *
     * @stability stable
     */
    FORWARD_SECRECY_TLS11 = "ELBSecurityPolicy-FS-1-1-2019-08",
    /**
     * Forward secrecy ciphers only.
     *
     * @stability stable
     */
    FORWARD_SECRECY = "ELBSecurityPolicy-FS-2018-06",
    /**
     * TLS1.2 only and no SHA ciphers.
     *
     * @stability stable
     */
    TLS12 = "ELBSecurityPolicy-TLS-1-2-2017-01",
    /**
     * TLS1.2 only with all ciphers.
     *
     * @stability stable
     */
    TLS12_EXT = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06",
    /**
     * TLS1.1 and higher with all ciphers.
     *
     * @stability stable
     */
    TLS11 = "ELBSecurityPolicy-TLS-1-1-2017-01",
    /**
     * Support for DES-CBC3-SHA.
     *
     * Do not use this security policy unless you must support a legacy client
     * that requires the DES-CBC3-SHA cipher, which is a weak cipher.
     *
     * @stability stable
     */
    LEGACY = "ELBSecurityPolicy-TLS-1-0-2015-04"
}
/**
 * How to interpret the load balancing target identifiers.
 *
 * @stability stable
 */
export declare enum TargetType {
    /**
     * Targets identified by instance ID.
     *
     * @stability stable
     */
    INSTANCE = "instance",
    /**
     * Targets identified by IP address.
     *
     * @stability stable
     */
    IP = "ip",
    /**
     * Target is a single Lambda Function.
     *
     * @stability stable
     */
    LAMBDA = "lambda"
}
/**
 * Application-Layer Protocol Negotiation Policies for network load balancers.
 *
 * Which protocols should be used over a secure connection.
 *
 * @stability stable
 */
export declare enum AlpnPolicy {
    /**
     * Negotiate only HTTP/1.*. The ALPN preference list is http/1.1, http/1.0.
     *
     * @stability stable
     */
    HTTP1_ONLY = "HTTP1Only",
    /**
     * Negotiate only HTTP/2.
     *
     * The ALPN preference list is h2
     *
     * @stability stable
     */
    HTTP2_ONLY = "HTTP2Only",
    /**
     * Prefer HTTP/1.* over HTTP/2 (which can be useful for HTTP/2 testing). The ALPN preference list is http/1.1, http/1.0, h2.
     *
     * @stability stable
     */
    HTTP2_OPTIONAL = "HTTP2Optional",
    /**
     * Prefer HTTP/2 over HTTP/1.*. The ALPN preference list is h2, http/1.1, http/1.0.
     *
     * @stability stable
     */
    HTTP2_PREFERRED = "HTTP2Preferred",
    /**
     * Do not negotiate ALPN.
     *
     * @stability stable
     */
    NONE = "None"
}
/**
 * Load balancing algorithmm type for target groups.
 *
 * @stability stable
 */
export declare enum TargetGroupLoadBalancingAlgorithmType {
    /**
     * round_robin.
     *
     * @stability stable
     */
    ROUND_ROBIN = "round_robin",
    /**
     * least_outstanding_requests.
     *
     * @stability stable
     */
    LEAST_OUTSTANDING_REQUESTS = "least_outstanding_requests"
}
