"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetGroupLoadBalancingAlgorithmType = exports.AlpnPolicy = exports.TargetType = exports.SslPolicy = exports.ApplicationProtocolVersion = exports.ApplicationProtocol = exports.Protocol = exports.IpAddressType = void 0;
/**
 * What kind of addresses to allocate to the load balancer.
 *
 * @stability stable
 */
var IpAddressType;
(function (IpAddressType) {
    IpAddressType["IPV4"] = "ipv4";
    IpAddressType["DUAL_STACK"] = "dualstack";
})(IpAddressType = exports.IpAddressType || (exports.IpAddressType = {}));
/**
 * Backend protocol for network load balancers and health checks.
 *
 * @stability stable
 */
var Protocol;
(function (Protocol) {
    Protocol["HTTP"] = "HTTP";
    Protocol["HTTPS"] = "HTTPS";
    Protocol["TCP"] = "TCP";
    Protocol["TLS"] = "TLS";
    Protocol["UDP"] = "UDP";
    Protocol["TCP_UDP"] = "TCP_UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
/**
 * Load balancing protocol for application load balancers.
 *
 * @stability stable
 */
var ApplicationProtocol;
(function (ApplicationProtocol) {
    ApplicationProtocol["HTTP"] = "HTTP";
    ApplicationProtocol["HTTPS"] = "HTTPS";
})(ApplicationProtocol = exports.ApplicationProtocol || (exports.ApplicationProtocol = {}));
/**
 * Load balancing protocol version for application load balancers.
 *
 * @stability stable
 */
var ApplicationProtocolVersion;
(function (ApplicationProtocolVersion) {
    ApplicationProtocolVersion["GRPC"] = "GRPC";
    ApplicationProtocolVersion["HTTP1"] = "HTTP1";
    ApplicationProtocolVersion["HTTP2"] = "HTTP2";
})(ApplicationProtocolVersion = exports.ApplicationProtocolVersion || (exports.ApplicationProtocolVersion = {}));
/**
 * Elastic Load Balancing provides the following security policies for Application Load Balancers.
 *
 * We recommend the Recommended policy for general use. You can
 * use the ForwardSecrecy policy if you require Forward Secrecy
 * (FS).
 *
 * You can use one of the TLS policies to meet compliance and security
 * standards that require disabling certain TLS protocol versions, or to
 * support legacy clients that require deprecated ciphers.
 *
 * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html
 * @stability stable
 */
var SslPolicy;
(function (SslPolicy) {
    SslPolicy["RECOMMENDED"] = "ELBSecurityPolicy-2016-08";
    SslPolicy["FORWARD_SECRECY_TLS12_RES_GCM"] = "ELBSecurityPolicy-FS-1-2-Res-2020-10";
    SslPolicy["FORWARD_SECRECY_TLS12_RES"] = "ELBSecurityPolicy-FS-1-2-Res-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS12"] = "ELBSecurityPolicy-FS-1-2-2019-08";
    SslPolicy["FORWARD_SECRECY_TLS11"] = "ELBSecurityPolicy-FS-1-1-2019-08";
    SslPolicy["FORWARD_SECRECY"] = "ELBSecurityPolicy-FS-2018-06";
    SslPolicy["TLS12"] = "ELBSecurityPolicy-TLS-1-2-2017-01";
    SslPolicy["TLS12_EXT"] = "ELBSecurityPolicy-TLS-1-2-Ext-2018-06";
    SslPolicy["TLS11"] = "ELBSecurityPolicy-TLS-1-1-2017-01";
    SslPolicy["LEGACY"] = "ELBSecurityPolicy-TLS-1-0-2015-04";
})(SslPolicy = exports.SslPolicy || (exports.SslPolicy = {}));
/**
 * How to interpret the load balancing target identifiers.
 *
 * @stability stable
 */
var TargetType;
(function (TargetType) {
    TargetType["INSTANCE"] = "instance";
    TargetType["IP"] = "ip";
    TargetType["LAMBDA"] = "lambda";
})(TargetType = exports.TargetType || (exports.TargetType = {}));
/**
 * Application-Layer Protocol Negotiation Policies for network load balancers.
 *
 * Which protocols should be used over a secure connection.
 *
 * @stability stable
 */
var AlpnPolicy;
(function (AlpnPolicy) {
    AlpnPolicy["HTTP1_ONLY"] = "HTTP1Only";
    AlpnPolicy["HTTP2_ONLY"] = "HTTP2Only";
    AlpnPolicy["HTTP2_OPTIONAL"] = "HTTP2Optional";
    AlpnPolicy["HTTP2_PREFERRED"] = "HTTP2Preferred";
    AlpnPolicy["NONE"] = "None";
})(AlpnPolicy = exports.AlpnPolicy || (exports.AlpnPolicy = {}));
/**
 * Load balancing algorithmm type for target groups.
 *
 * @stability stable
 */
var TargetGroupLoadBalancingAlgorithmType;
(function (TargetGroupLoadBalancingAlgorithmType) {
    TargetGroupLoadBalancingAlgorithmType["ROUND_ROBIN"] = "round_robin";
    TargetGroupLoadBalancingAlgorithmType["LEAST_OUTSTANDING_REQUESTS"] = "least_outstanding_requests";
})(TargetGroupLoadBalancingAlgorithmType = exports.TargetGroupLoadBalancingAlgorithmType || (exports.TargetGroupLoadBalancingAlgorithmType = {}));
//# sourceMappingURL=data:application/json;base64,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