"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var JsonSchemaVersion;
(function (JsonSchemaVersion) {
    /**
     * In API Gateway models are defined using the JSON schema draft 4.
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     */
    JsonSchemaVersion["DRAFT4"] = "http://json-schema.org/draft-04/schema#";
    JsonSchemaVersion["DRAFT7"] = "http://json-schema.org/draft-07/schema#";
})(JsonSchemaVersion = exports.JsonSchemaVersion || (exports.JsonSchemaVersion = {}));
var JsonSchemaType;
(function (JsonSchemaType) {
    JsonSchemaType["NULL"] = "null";
    JsonSchemaType["BOOLEAN"] = "boolean";
    JsonSchemaType["OBJECT"] = "object";
    JsonSchemaType["ARRAY"] = "array";
    JsonSchemaType["NUMBER"] = "number";
    JsonSchemaType["INTEGER"] = "integer";
    JsonSchemaType["STRING"] = "string";
})(JsonSchemaType = exports.JsonSchemaType || (exports.JsonSchemaType = {}));
//# sourceMappingURL=data:application/json;base64,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