"use strict";
/// !cdk-integ *
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const apig = require("../lib");
class FirstStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.firstLambda = new lambda.Function(this, 'firstLambda', {
            functionName: 'FirstLambda',
            code: lambda.Code.fromInline(`exports.handler = async function(event) {
          return  {
            'headers': { 'Content-Type': 'text/plain' },
            'statusCode': 200
          }
        }`),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_10_X,
        });
    }
}
class SecondStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const api = new apig.RestApi(this, 'BooksApi', {
            restApiName: 'SecondRestAPI'
        });
        api.root.addMethod('ANY');
        const booksApi = api.root.addResource('books');
        const lambdaIntegration = new apig.LambdaIntegration(props.lambda);
        booksApi.addMethod('GET', lambdaIntegration);
    }
}
const app = new cdk.App();
const first = new FirstStack(app, 'FirstStack');
new SecondStack(app, 'SecondStack', { lambda: first.firstLambda });
app.synth();
//# sourceMappingURL=data:application/json;base64,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