# Copyright (c) OpenMMLab. All rights reserved.
from ..builder import ROTATED_DETECTORS
from .two_stage import RotatedTwoStageDetector


@ROTATED_DETECTORS.register_module()
class ReDet(RotatedTwoStageDetector):
    """Implementation of `ReDet: A Rotation-equivariant Detector for Aerial
    Object Detection.

    <https://openaccess.thecvf.com/content/CVPR2021/papers/
    Han_ReDet_A_Rotation-Equivariant_Detector_for_Aerial_Object_
    Detection_CVPR_2021_paper.pdf>`_
    """

    def __init__(self,
                 backbone,
                 rpn_head,
                 roi_head,
                 train_cfg,
                 test_cfg,
                 neck=None,
                 pretrained=None,
                 init_cfg=None):
        super(ReDet, self).__init__(
            backbone=backbone,
            neck=neck,
            rpn_head=rpn_head,
            roi_head=roi_head,
            train_cfg=train_cfg,
            test_cfg=test_cfg,
            pretrained=pretrained,
            init_cfg=init_cfg)
