import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ConsulSecretBackendRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The path of the Consul Secret Backend the role belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#backend ConsulSecretBackendRole#backend}
    */
    readonly backend?: string;
    /**
    * The Consul namespace that the token will be created in. Applicable for Vault 1.10+ and Consul 1.7+
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#consul_namespace ConsulSecretBackendRole#consul_namespace}
    */
    readonly consulNamespace?: string;
    /**
    * Set of Consul roles to attach to the token. Applicable for Vault 1.10+ with Consul 1.5+
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#consul_roles ConsulSecretBackendRole#consul_roles}
    */
    readonly consulRoles?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#id ConsulSecretBackendRole#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Indicates that the token should not be replicated globally and instead be local to the current datacenter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#local ConsulSecretBackendRole#local}
    */
    readonly local?: boolean | cdktf.IResolvable;
    /**
    * Maximum TTL for leases associated with this role, in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#max_ttl ConsulSecretBackendRole#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * The name of an existing role against which to create this Consul credential
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#name ConsulSecretBackendRole#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#namespace ConsulSecretBackendRole#namespace}
    */
    readonly namespace?: string;
    /**
    * The Consul admin partition that the token will be created in. Applicable for Vault 1.10+ and Consul 1.11+
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#partition ConsulSecretBackendRole#partition}
    */
    readonly partition?: string;
    /**
    * List of Consul policies to associate with this role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#policies ConsulSecretBackendRole#policies}
    */
    readonly policies?: string[];
    /**
    * Specifies the type of token to create when using this role. Valid values are "client" or "management".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#token_type ConsulSecretBackendRole#token_type}
    */
    readonly tokenType?: string;
    /**
    * Specifies the TTL for this role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role#ttl ConsulSecretBackendRole#ttl}
    */
    readonly ttl?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role vault_consul_secret_backend_role}
*/
export declare class ConsulSecretBackendRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_consul_secret_backend_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/consul_secret_backend_role vault_consul_secret_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ConsulSecretBackendRoleConfig
    */
    constructor(scope: Construct, id: string, config: ConsulSecretBackendRoleConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _consulNamespace?;
    get consulNamespace(): string;
    set consulNamespace(value: string);
    resetConsulNamespace(): void;
    get consulNamespaceInput(): string | undefined;
    private _consulRoles?;
    get consulRoles(): string[];
    set consulRoles(value: string[]);
    resetConsulRoles(): void;
    get consulRolesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _local?;
    get local(): boolean | cdktf.IResolvable;
    set local(value: boolean | cdktf.IResolvable);
    resetLocal(): void;
    get localInput(): boolean | cdktf.IResolvable | undefined;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _partition?;
    get partition(): string;
    set partition(value: string);
    resetPartition(): void;
    get partitionInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    private _tokenType?;
    get tokenType(): string;
    set tokenType(value: string);
    resetTokenType(): void;
    get tokenTypeInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
