# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.iconfig_search import iConfigSearch
from bs_fura.db.tables.config import tConfig

class dConfigSearch:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iConfigSearch()
        self.orec     = tConfig()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  criteria: str) -> "dConfigSearch":
        """
        Execute the query by setting all the inputs.

        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.criteria = criteria

        return self.exec()

    def exec(self, irec: iConfigSearch = None) -> "dConfigSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("ConfigSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  c.*
from
  fura.config c
where
  (1=1)
  [criteria]""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_out("id", str, 256)
        self._dbstmnt.bind_out("descr", str, 256)
        self._dbstmnt.bind_out("value", str, 4096)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.descr = self._dbstmnt.result[1]
        self.orec.value = self._dbstmnt.result[2]
        self.orec.modified_by = self._dbstmnt.result[3]
        self.orec.tm_stamp = self._dbstmnt.result[4]

        return True

    def fetch_all(self, outList: tConfig.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

