# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.eatok import tEatok

class dEatokUpdate:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tEatok()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int,
                  tok: str,
                  site_id: int,
                  usr_id: str,
                  func_id: str,
                  grant_usr_id: str,
                  created: datetime.datetime,
                  expires: datetime.datetime,
                  max_usages: int,
                  usages: int) -> "dEatokUpdate":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param tok: str
        :param site_id: int
        :param usr_id: str
        :param func_id: str
        :param grant_usr_id: str
        :param created: datetime.datetime
        :param expires: datetime.datetime
        :param max_usages: int
        :param usages: int
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.tok = tok
        self.irec.site_id = site_id
        self.irec.usr_id = usr_id
        self.irec.func_id = func_id
        self.irec.grant_usr_id = grant_usr_id
        self.irec.created = created
        self.irec.expires = expires
        self.irec.max_usages = max_usages
        self.irec.usages = usages

        return self.exec()

    def exec(self, irec: tEatok = None) -> "dEatokUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("EatokUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  fura.Eatok
set
  tok = :tok,
  site_id = :site_id,
  usr_id = :usr_id,
  func_id = :func_id,
  grant_usr_id = :grant_usr_id,
  created = :created,
  expires = :expires,
  max_usages = :max_usages,
  usages = :usages
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)
        self._dbstmnt.bind_in("tok", self.irec.tok, str, 256)
        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)
        self._dbstmnt.bind_in("func_id", self.irec.func_id, str, 128)
        self._dbstmnt.bind_in("grant_usr_id", self.irec.grant_usr_id, str, 128)
        self._dbstmnt.bind_in("created", self.irec.created, datetime.datetime)
        self._dbstmnt.bind_in("expires", self.irec.expires, datetime.datetime)
        self._dbstmnt.bind_in("max_usages", self.irec.max_usages, int, 4)
        self._dbstmnt.bind_in("usages", self.irec.usages, int, 4)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

