# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.irole_func_rel_by_role import iRoleFuncRelByRole
from bs_fura.db.tables.role_func_rel import tRoleFuncRel

class dRoleFuncRelByRole:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iRoleFuncRelByRole()
        self.orec     = tRoleFuncRel()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  role_id: str) -> "dRoleFuncRelByRole":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param role_id: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.role_id = role_id

        return self.exec()

    def exec(self, irec: iRoleFuncRelByRole = None) -> "dRoleFuncRelByRole":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("RoleFuncRelByRole", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  *
from
  fura.rolefuncrel r
where
  r.site_id = :siteId and
  r.role_id = :roleId""")

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("roleId", self.irec.role_id, str, 128)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("role_id", str, 128)
        self._dbstmnt.bind_out("func_id", str, 128)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.role_id = self._dbstmnt.result[1]
        self.orec.func_id = self._dbstmnt.result[2]
        self.orec.modified_by = self._dbstmnt.result[3]
        self.orec.tm_stamp = self._dbstmnt.result[4]

        return True

    def fetch_all(self, outList: tRoleFuncRel.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

