# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.token_sentry_key import tTokenSentryKey
from bs_fura.db.tables.token_sentry import tTokenSentry

class dTokenSentrySelectOne:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tTokenSentryKey()
        self.orec     = tTokenSentry()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int) -> "dTokenSentrySelectOne":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :return: Self for convenience.
        """
        self.irec.site_id = site_id

        return self.exec()

    def exec(self, irec: tTokenSentryKey = None) -> "dTokenSentrySelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("TokenSentrySelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  site_id,
  token_cnt,
  last_poll
from
  fura.TokenSentry
where
  site_id = :site_id""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("token_cnt", int, 8)
        self._dbstmnt.bind_out("last_poll", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.token_cnt = self._dbstmnt.result[1]
        self.orec.last_poll = self._dbstmnt.result[2]

        return True

    def fetch_all(self, outList: tTokenSentry.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

