# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.ula import tUla

class dUlaInsert:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tUla()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  site_code: str,
                  tm_stamp: datetime.datetime,
                  usr_id: str,
                  err_code: int,
                  state: str,
                  action: str,
                  auth_type: str,
                  auth_ip: str,
                  auth_geo: str) -> "dUlaInsert":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param site_code: str
        :param tm_stamp: datetime.datetime
        :param usr_id: str
        :param err_code: int
        :param state: str
        :param action: str
        :param auth_type: str
        :param auth_ip: str
        :param auth_geo: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.site_code = site_code
        self.irec.tm_stamp = tm_stamp
        self.irec.usr_id = usr_id
        self.irec.err_code = err_code
        self.irec.state = state
        self.irec.action = action
        self.irec.auth_type = auth_type
        self.irec.auth_ip = auth_ip
        self.irec.auth_geo = auth_geo

        return self.exec()

    def exec(self, irec: tUla = None) -> "dUlaInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("UlaInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into fura.Ula (
  site_id,
  site_code,
  tm_stamp,
  usr_id,
  err_code,
  state,
  action,
  auth_type,
  auth_ip,
  auth_geo
) values (
  :site_id,
  :site_code,
  :tm_stamp,
  :usr_id,
  :err_code,
  :state,
  :action,
  :auth_type,
  :auth_ip,
  :auth_geo
)""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("site_code", self.irec.site_code, str, 32)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)
        self._dbstmnt.bind_in("err_code", self.irec.err_code, int, 4)
        self._dbstmnt.bind_in("state", self.irec.state, str, 1)
        self._dbstmnt.bind_in("action", self.irec.action, str, 1)
        self._dbstmnt.bind_in("auth_type", self.irec.auth_type, str, 1)
        self._dbstmnt.bind_in("auth_ip", self.irec.auth_ip, str, 32)
        self._dbstmnt.bind_in("auth_geo", self.irec.auth_geo, str, 64)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

