# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr_auth import tUsrAuth

class dUsrAuthUpdate:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tUsrAuth()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  usr_id: str,
                  auth_type: str,
                  auth_data: str,
                  fail_cnt: int,
                  salt: str,
                  last_ip: str,
                  last_geo: str,
                  last_succ: datetime.datetime,
                  last_fail: datetime.datetime,
                  modified_by: str) -> "dUsrAuthUpdate":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param usr_id: str
        :param auth_type: str
        :param auth_data: str
        :param fail_cnt: int
        :param salt: str
        :param last_ip: str
        :param last_geo: str
        :param last_succ: datetime.datetime
        :param last_fail: datetime.datetime
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.usr_id = usr_id
        self.irec.auth_type = auth_type
        self.irec.auth_data = auth_data
        self.irec.fail_cnt = fail_cnt
        self.irec.salt = salt
        self.irec.last_ip = last_ip
        self.irec.last_geo = last_geo
        self.irec.last_succ = last_succ
        self.irec.last_fail = last_fail
        self.irec.modified_by = modified_by

        return self.exec()

    def exec(self, irec: tUsrAuth = None) -> "dUsrAuthUpdate":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("UsrAuthUpdate", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""update
  fura.UsrAuth
set
  auth_data = :auth_data,
  fail_cnt = :fail_cnt,
  salt = :salt,
  last_ip = :last_ip,
  last_geo = :last_geo,
  last_succ = :last_succ,
  last_fail = :last_fail,
  modified_by = :modified_by,
  tm_stamp = :tm_stamp
where
  site_id = :site_id and
  usr_id = :usr_id and
  auth_type = :auth_type""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)
        self._dbstmnt.bind_in("auth_type", self.irec.auth_type, str, 1)
        self._dbstmnt.bind_in("auth_data", self.irec.auth_data, str, 4096)
        self._dbstmnt.bind_in("fail_cnt", self.irec.fail_cnt, int, 4)
        self._dbstmnt.bind_in("salt", self.irec.salt, str, 128)
        self._dbstmnt.bind_in("last_ip", self.irec.last_ip, str, 32)
        self._dbstmnt.bind_in("last_geo", self.irec.last_geo, str, 64)
        self._dbstmnt.bind_in("last_succ", self.irec.last_succ, datetime.datetime)
        self._dbstmnt.bind_in("last_fail", self.irec.last_fail, datetime.datetime)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

