# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr_otp import tUsrOtp

class dUsrOtpInsert:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tUsrOtp()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  site_id: int,
                  usr_id: str,
                  otp_method: str,
                  otp: str,
                  expire: datetime.datetime,
                  used: bool,
                  target: str,
                  fail_cnt: int,
                  meta_data: dict,
                  tm_stamp: datetime.datetime) -> "dUsrOtpInsert":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param usr_id: str
        :param otp_method: str
        :param otp: str
        :param expire: datetime.datetime
        :param used: bool
        :param target: str
        :param fail_cnt: int
        :param meta_data: dict
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.usr_id = usr_id
        self.irec.otp_method = otp_method
        self.irec.otp = otp
        self.irec.expire = expire
        self.irec.used = used
        self.irec.target = target
        self.irec.fail_cnt = fail_cnt
        self.irec.meta_data = meta_data
        self.irec.tm_stamp = tm_stamp

        return self.exec()

    def exec(self, irec: tUsrOtp = None) -> "dUsrOtpInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("UsrOtpInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into fura.UsrOtp (
  site_id,
  usr_id,
  otp_method,
  otp,
  expire,
  used,
  target,
  fail_cnt,
  meta_data,
  tm_stamp
) values (
  :site_id,
  :usr_id,
  :otp_method,
  :otp,
  :expire,
  :used,
  :target,
  :fail_cnt,
  :meta_data,
  :tm_stamp
)""")

        self.irec.tm_stamp = self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)
        self._dbstmnt.bind_in("otp_method", self.irec.otp_method, str, 1)
        self._dbstmnt.bind_in("otp", self.irec.otp, str, 128)
        self._dbstmnt.bind_in("expire", self.irec.expire, datetime.datetime)
        self._dbstmnt.bind_in("used", self.irec.used, bool)
        self._dbstmnt.bind_in("target", self.irec.target, str, 64)
        self._dbstmnt.bind_in("fail_cnt", self.irec.fail_cnt, int, 4)
        self._dbstmnt.bind_in("meta_data", self.irec.meta_data, dict)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

