# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.ada import tAda

class dAdaInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tAda()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        site_code: str,
                        tm_stamp: datetime.datetime,
                        usr_id: str,
                        eausr_id: str,
                        role_id: str,
                        func_id: str,
                        action: str,
                        src: str,
                        reason: str) -> "dAdaInsert":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param site_code: str
        :param tm_stamp: datetime.datetime
        :param usr_id: str
        :param eausr_id: str
        :param role_id: str
        :param func_id: str
        :param action: str
        :param src: str
        :param reason: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.site_code = site_code
        self.irec.tm_stamp = tm_stamp
        self.irec.usr_id = usr_id
        self.irec.eausr_id = eausr_id
        self.irec.role_id = role_id
        self.irec.func_id = func_id
        self.irec.action = action
        self.irec.src = src
        self.irec.reason = reason

        return await self.exec()

    async def exec(self, irec: tAda = None) -> "dAdaInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("AdaInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into fura.Ada (
  site_id,
  site_code,
  tm_stamp,
  usr_id,
  eausr_id,
  role_id,
  func_id,
  action,
  src,
  reason
) values (
  :site_id,
  :site_code,
  :tm_stamp,
  :usr_id,
  :eausr_id,
  :role_id,
  :func_id,
  :action,
  :src,
  :reason
)""")

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("site_code", self.irec.site_code, str, 32)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)
        self._dbstmnt.bind_in("usr_id", self.irec.usr_id, str, 128)
        self._dbstmnt.bind_in("eausr_id", self.irec.eausr_id, str, 128)
        self._dbstmnt.bind_in("role_id", self.irec.role_id, str, 128)
        self._dbstmnt.bind_in("func_id", self.irec.func_id, str, 128)
        self._dbstmnt.bind_in("action", self.irec.action, str, 1)
        self._dbstmnt.bind_in("src", self.irec.src, str, 128)
        self._dbstmnt.bind_in("reason", self.irec.reason, str, 128)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

