# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.role_func_rel import tRoleFuncRel

class dRoleFuncRelInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tRoleFuncRel()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        role_id: str,
                        func_id: str,
                        modified_by: str,
                        tm_stamp: datetime.datetime) -> "dRoleFuncRelInsert":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param role_id: str
        :param func_id: str
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.role_id = role_id
        self.irec.func_id = func_id
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return await self.exec()

    async def exec(self, irec: tRoleFuncRel = None) -> "dRoleFuncRelInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("RoleFuncRelInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into fura.RoleFuncRel (
  site_id,
  role_id,
  func_id,
  modified_by,
  tm_stamp
) values (
  :site_id,
  :role_id,
  :func_id,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("site_id", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("role_id", self.irec.role_id, str, 128)
        self._dbstmnt.bind_in("func_id", self.irec.func_id, str, 128)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

