# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.isite_id_by_code import iSiteIdByCode
from bs_fura.db.tables.osite_id_by_code import oSiteIdByCode

class dSiteIdByCode:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iSiteIdByCode()
        self.orec     = oSiteIdByCode()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        code: str) -> "dSiteIdByCode":
        """
        Execute the query by setting all the inputs.

        :param code: str
        :return: Self for convenience.
        """
        self.irec.code = code

        return await self.exec()

    async def exec(self, irec: iSiteIdByCode = None) -> "dSiteIdByCode":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("SiteIdByCode", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  s.id
from
  fura.site s
where
  s.code = :code""")

        self._dbstmnt.bind_in("code", self.irec.code, str)

        self._dbstmnt.bind_out("siteId", int, 4)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]

        return True

    async def fetch_all(self, outList: oSiteIdByCode.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

