# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.iula_search import iUlaSearch
from bs_fura.db.tables.ula import tUla

class dUlaSearch:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iUlaSearch()
        self.orec     = tUla()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        site_id: int,
                        date_from: datetime.datetime,
                        date_to: datetime.datetime,
                        criteria: str) -> "dUlaSearch":
        """
        Execute the query by setting all the inputs.

        :param site_id: int
        :param date_from: datetime.datetime
        :param date_to: datetime.datetime
        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.site_id = site_id
        self.irec.date_from = date_from
        self.irec.date_to = date_to
        self.irec.criteria = criteria

        return await self.exec()

    async def exec(self, irec: iUlaSearch = None) -> "dUlaSearch":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("UlaSearch", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  u.*
from
  fura.ula u
where
  u.site_id   = :siteId   and
  u.tm_stamp >= :dateFrom and
  u.tm_stamp <= :dateTo
  [criteria]
order by
  u.id desc""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("siteId", self.irec.site_id, int, 4)
        self._dbstmnt.bind_in("dateFrom", self.irec.date_from, datetime.datetime)
        self._dbstmnt.bind_in("dateTo", self.irec.date_to, datetime.datetime)

        self._dbstmnt.bind_out("site_id", int, 4)
        self._dbstmnt.bind_out("site_code", str, 32)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)
        self._dbstmnt.bind_out("usr_id", str, 128)
        self._dbstmnt.bind_out("err_code", int, 4)
        self._dbstmnt.bind_out("state", str, 1)
        self._dbstmnt.bind_out("action", str, 1)
        self._dbstmnt.bind_out("auth_type", str, 1)
        self._dbstmnt.bind_out("auth_ip", str, 32)
        self._dbstmnt.bind_out("auth_geo", str, 64)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.site_code = self._dbstmnt.result[1]
        self.orec.tm_stamp = self._dbstmnt.result[2]
        self.orec.usr_id = self._dbstmnt.result[3]
        self.orec.err_code = self._dbstmnt.result[4]
        self.orec.state = self._dbstmnt.result[5]
        self.orec.action = self._dbstmnt.result[6]
        self.orec.auth_type = self._dbstmnt.result[7]
        self.orec.auth_ip = self._dbstmnt.result[8]
        self.orec.auth_geo = self._dbstmnt.result[9]

        return True

    async def fetch_all(self, outList: tUla.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

