# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr_otp import tUsrOtp

class dUsrOtpSelectAll:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.orec     = tUsrOtp()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.usr_id = self._dbstmnt.result[1]
        self.orec.otp_method = self._dbstmnt.result[2]
        self.orec.otp = self._dbstmnt.result[3]
        self.orec.expire = self._dbstmnt.result[4]
        self.orec.used = self._dbstmnt.result[5]
        self.orec.target = self._dbstmnt.result[6]
        self.orec.fail_cnt = self._dbstmnt.result[7]
        self.orec.meta_data = self._dbstmnt.result[8]
        self.orec.tm_stamp = self._dbstmnt.result[9]

        return True

    async def fetch_all(self, outList: tUsrOtp.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

