# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_fura.db.tables.usr import tUsr

class dUsrSelectAll:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.orec     = tUsr()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.site_id = self._dbstmnt.result[0]
        self.orec.id = self._dbstmnt.result[1]
        self.orec.role_id = self._dbstmnt.result[2]
        self.orec.status = self._dbstmnt.result[3]
        self.orec.name_first = self._dbstmnt.result[4]
        self.orec.name_last = self._dbstmnt.result[5]
        self.orec.title = self._dbstmnt.result[6]
        self.orec.date_activate = self._dbstmnt.result[7]
        self.orec.date_expire = self._dbstmnt.result[8]
        self.orec.email1 = self._dbstmnt.result[9]
        self.orec.email2 = self._dbstmnt.result[10]
        self.orec.cellno1 = self._dbstmnt.result[11]
        self.orec.cellno2 = self._dbstmnt.result[12]
        self.orec.modified_by = self._dbstmnt.result[13]
        self.orec.tm_stamp = self._dbstmnt.result[14]
        self.orec.usrtype_id = self._dbstmnt.result[15]
        self.orec.email1_conf = self._dbstmnt.result[16]
        self.orec.email2_conf = self._dbstmnt.result[17]
        self.orec.cellno1_conf = self._dbstmnt.result[18]
        self.orec.cellno2_conf = self._dbstmnt.result[19]
        self.orec.opt_system = self._dbstmnt.result[20]
        self.orec.opt_market = self._dbstmnt.result[21]
        self.orec.opt_fail_login = self._dbstmnt.result[22]

        return True

    async def fetch_all(self, outList: tUsr.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

