# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .eatok_key import tEatokKey

class tEatok(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: int = 0,
                 tok: str = '',
                 site_id: int = 0,
                 usr_id: str = '',
                 func_id: str = '',
                 grant_usr_id: str = '',
                 created: datetime.datetime = datetime.datetime.min,
                 expires: datetime.datetime = datetime.datetime.min,
                 max_usages: int = 0,
                 usages: int = 0):
        """
        Constructor.

        :param id: int
        :param tok: str
        :param site_id: int
        :param usr_id: str
        :param func_id: str
        :param grant_usr_id: str
        :param created: datetime.datetime
        :param expires: datetime.datetime
        :param max_usages: int
        :param usages: int
        """
        self.id = id
        self.tok = tok
        self.site_id = site_id
        self.usr_id = usr_id
        self.func_id = func_id
        self.grant_usr_id = grant_usr_id
        self.created = created
        self.expires = expires
        self.max_usages = max_usages
        self.usages = usages

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = 0
        self.tok = ''
        self.site_id = 0
        self.usr_id = ''
        self.func_id = ''
        self.grant_usr_id = ''
        self.created = datetime.datetime.min
        self.expires = datetime.datetime.min
        self.max_usages = 0
        self.usages = 0

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tEatok'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("id", self.id)
        _w.write_string("tok", self.tok)
        _w.write_int32("site_id", self.site_id)
        _w.write_string("usr_id", self.usr_id)
        _w.write_string("func_id", self.func_id)
        _w.write_string("grant_usr_id", self.grant_usr_id)
        _w.write_datetime("created", self.created)
        _w.write_datetime("expires", self.expires)
        _w.write_int32("max_usages", self.max_usages)
        _w.write_int32("usages", self.usages)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_int64("id")
        self.tok = _r.read_string("tok")
        self.site_id = _r.read_int32("site_id")
        self.usr_id = _r.read_string("usr_id")
        self.func_id = _r.read_string("func_id")
        self.grant_usr_id = _r.read_string("grant_usr_id")
        self.created = _r.read_datetime("created")
        self.expires = _r.read_datetime("expires")
        self.max_usages = _r.read_int32("max_usages")
        self.usages = _r.read_int32("usages")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tEatok"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.tok = rec.tok
        self.site_id = rec.site_id
        self.usr_id = rec.usr_id
        self.func_id = rec.func_id
        self.grant_usr_id = rec.grant_usr_id
        self.created = rec.created
        self.expires = rec.expires
        self.max_usages = rec.max_usages
        self.usages = rec.usages

    def _write_pk(self, _key: "tEatok"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tEatok"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tEatokKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tEatokKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        if not for_ins:
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        if key_only:
            return dvc

        dvc.add_targ("tok", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("tok", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        dvc.add_targ("site_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("func_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("func_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("grant_usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("grant_usr_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        dvc.add_targ("created", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("expires", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("max_usages", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("usages", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tEatok._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tEatokKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tEatokKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.id - y.id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<Eatok [id:%r, tok:%.32s, site_id:%r, usr_id:%.32s, func_id:%.32s, grant_usr_id:%.32s, created:%s, expires:%s, max_usages:%r, usages:%r]>' % (
            self.id, self.tok, self.site_id, self.usr_id, self.func_id, self.grant_usr_id, self.created, self.expires, self.max_usages, self.usages)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tEatok.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tEatok()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tEatok.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tEatok._cache_davs(dvc, for_ins, key_only)

