# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Mon Feb 15 23:21:07 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .role_key import tRoleKey

class tRole(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 site_id: int = 0,
                 id: str = '',
                 descr: str = '',
                 status: str = '',
                 level: int = 0,
                 sess_timeout: int = 0,
                 modified_by: str = ''):
        """
        Constructor.

        :param site_id: int
        :param id: str
        :param descr: str
        :param status: str
        :param level: int
        :param sess_timeout: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.site_id = site_id
        self.id = id
        self.descr = descr
        self.status = status
        self.level = level
        self.sess_timeout = sess_timeout
        self.modified_by = modified_by
        self.tm_stamp = datetime.datetime.min

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.site_id = 0
        self.id = ''
        self.descr = ''
        self.status = ''
        self.level = 0
        self.sess_timeout = 0
        self.modified_by = ''
        self.tm_stamp = datetime.datetime.min

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tRole'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int32("site_id", self.site_id)
        _w.write_string("id", self.id)
        _w.write_string("descr", self.descr)
        _w.write_char("status", self.status)
        _w.write_int32("level", self.level)
        _w.write_int32("sess_timeout", self.sess_timeout)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.site_id = _r.read_int32("site_id")
        self.id = _r.read_string("id")
        self.descr = _r.read_string("descr")
        self.status = _r.read_char("status")
        self.level = _r.read_int32("level")
        self.sess_timeout = _r.read_int32("sess_timeout")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tRole"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.site_id = rec.site_id
        self.id = rec.id
        self.descr = rec.descr
        self.status = rec.status
        self.level = rec.level
        self.sess_timeout = rec.sess_timeout
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tRole"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tRole"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tRoleKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tRoleKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("site_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        if key_only:
            return dvc

        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['A','D','S']))
        dvc.add_targ("level", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("level", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 20))
        dvc.add_targ("level", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("sess_timeout", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tRole._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tRoleKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.site_id = self.site_id
        _key.id = self.id

    def _read_key(self, _key: tRoleKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.site_id = _key.site_id
        self.id = _key.id

    class Status_Couplet(dict):
        key_active = "A"
        key_disabled = "D"
        key_super_user = "S"

        value_active = "Active"
        value_disabled = "Disabled"
        value_super_user = "Super User"

        def __init__(self):
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled
            self[self.key_super_user] = self.value_super_user

        @staticmethod
        def get_value(key):
            if key == tRole.Status_Couplet.key_active:
                return tRole.Status_Couplet.value_active

            if key == tRole.Status_Couplet.key_disabled:
                return tRole.Status_Couplet.value_disabled

            if key == tRole.Status_Couplet.key_super_user:
                return tRole.Status_Couplet.value_super_user

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = x.site_id - y.site_id

        if rc != 0:
            return rc

        rc = (x.id > y.id) - (x.id < y.id)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<Role [site_id:%r, id:%.32s, descr:%.32s, status:%.32s, level:%r, sess_timeout:%r, modified_by:%.32s, tm_stamp:%s]>' % (
            self.site_id, self.id, self.descr, self.status, self.level, self.sess_timeout, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tRole.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tRole()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tRole.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tRole._cache_davs(dvc, for_ins, key_only)

