# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_iam_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.iam.v4.authn.CertRevocationInfo import CertRevocationInfo  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class CertAuthProvider(ExternalizableAbstractModel):
    """CertAuthProvider - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'name': 'str',
        'client_ca_chain': 'str',
        'cert_auth_enabled': 'bool',
        'cac_enabled': 'bool',
        'dir_svc_ext_i_d': 'str',
        'ca_cert_file_name': 'str',
        'cert_revocation_info': 'iam.v4.authn.CertRevocationInfo',
        'created_time': 'datetime',
        'last_updated_time': 'datetime',
        'created_by': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'name': 'name',
        'client_ca_chain': 'clientCaChain',
        'cert_auth_enabled': 'certAuthEnabled',
        'cac_enabled': 'cacEnabled',
        'dir_svc_ext_i_d': 'dirSvcExtID',
        'ca_cert_file_name': 'caCertFileName',
        'cert_revocation_info': 'certRevocationInfo',
        'created_time': 'createdTime',
        'last_updated_time': 'lastUpdatedTime',
        'created_by': 'createdBy',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, name=None, client_ca_chain=None, cert_auth_enabled=None, cac_enabled=None, dir_svc_ext_i_d=None, ca_cert_file_name=None, cert_revocation_info=None, created_time=None, last_updated_time=None, created_by=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """CertAuthProvider - a model defined in Swagger
            \nA certificate based authentication provider
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__name = None
        self.__client_ca_chain = None
        self.__cert_auth_enabled = None
        self.__cac_enabled = None
        self.__dir_svc_ext_i_d = None
        self.__ca_cert_file_name = None
        self.__cert_revocation_info = None
        self.__created_time = None
        self.__last_updated_time = None
        self.__created_by = None
        self.discriminator = None
        self.__name = name
        self.__client_ca_chain = client_ca_chain
        self.__cert_auth_enabled = cert_auth_enabled
        self.__cac_enabled = cac_enabled
        if dir_svc_ext_i_d is not None:
            self.__dir_svc_ext_i_d = dir_svc_ext_i_d
        self.__ca_cert_file_name = ca_cert_file_name
        if cert_revocation_info is not None:
            self.__cert_revocation_info = cert_revocation_info
        if created_time is not None:
            self.__created_time = created_time
        if last_updated_time is not None:
            self.__last_updated_time = last_updated_time
        if created_by is not None:
            self.__created_by = created_by

    def _initialize_object_type(self):
        return 'iam.v4.authn.CertAuthProvider'

    def _initialize_fq_object_type(self):
        return 'iam.v4.r0.a1.authn.CertAuthProvider'


    @property
    def name(self):
        """`{ str }`
            \nUnique name of the certificate based authentication provider.
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self.__name = name

    @property
    def client_ca_chain(self):
        """`{ str }`
            \nCA chain file
        """ # noqa: E501
        return self.__client_ca_chain

    @client_ca_chain.setter
    def client_ca_chain(self, client_ca_chain):
        if client_ca_chain is None:
            raise ValueError("Invalid value for `client_ca_chain`, must not be `None`")  # noqa: E501
        if client_ca_chain is not None and len(client_ca_chain) < 64:
            raise ValueError("Invalid value for `client_ca_chain`, length must be greater than or equal to `64`")  # noqa: E501

        self.__client_ca_chain = client_ca_chain

    @property
    def cert_auth_enabled(self):
        """`{ bool }`
            \nFlag to enable/disable CAC for the current certificate based authentication provider.
        """ # noqa: E501
        return self.__cert_auth_enabled

    @cert_auth_enabled.setter
    def cert_auth_enabled(self, cert_auth_enabled):
        if cert_auth_enabled is None:
            raise ValueError("Invalid value for `cert_auth_enabled`, must not be `None`")  # noqa: E501

        self.__cert_auth_enabled = cert_auth_enabled

    @property
    def cac_enabled(self):
        """`{ bool }`
            \nFlag to enable/disable Cert Auth for the current certificate based authentication provider.
        """ # noqa: E501
        return self.__cac_enabled

    @cac_enabled.setter
    def cac_enabled(self, cac_enabled):
        if cac_enabled is None:
            raise ValueError("Invalid value for `cac_enabled`, must not be `None`")  # noqa: E501

        self.__cac_enabled = cac_enabled

    @property
    def dir_svc_ext_i_d(self):
        """`{ str }`
            \nUUID of an existing directory service
        """ # noqa: E501
        return self.__dir_svc_ext_i_d

    @dir_svc_ext_i_d.setter
    def dir_svc_ext_i_d(self, dir_svc_ext_i_d):
        if dir_svc_ext_i_d is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', dir_svc_ext_i_d):  # noqa: E501
            raise ValueError(r"Invalid value for `dir_svc_ext_i_d`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__dir_svc_ext_i_d = dir_svc_ext_i_d

    @property
    def ca_cert_file_name(self):
        """`{ str }`
            \nName of the uploaded CA chain file
        """ # noqa: E501
        return self.__ca_cert_file_name

    @ca_cert_file_name.setter
    def ca_cert_file_name(self, ca_cert_file_name):
        if ca_cert_file_name is None:
            raise ValueError("Invalid value for `ca_cert_file_name`, must not be `None`")  # noqa: E501
        if ca_cert_file_name is not None and len(ca_cert_file_name) > 255:
            raise ValueError("Invalid value for `ca_cert_file_name`, length must be less than or equal to `255`")  # noqa: E501
        if ca_cert_file_name is not None and len(ca_cert_file_name) < 1:
            raise ValueError("Invalid value for `ca_cert_file_name`, length must be greater than or equal to `1`")  # noqa: E501

        self.__ca_cert_file_name = ca_cert_file_name

    @property
    def cert_revocation_info(self):
        """`{ iam.v4.authn.CertRevocationInfo }`
            
        """ # noqa: E501
        return self.__cert_revocation_info

    @cert_revocation_info.setter
    def cert_revocation_info(self, cert_revocation_info):

        self.__cert_revocation_info = cert_revocation_info

    @property
    def created_time(self):
        """`{ datetime }`
            \nCreation time of the certificate based authentication provider
        """ # noqa: E501
        return self.__created_time

    @created_time.setter
    def created_time(self, created_time):

        self.__created_time = created_time

    @property
    def last_updated_time(self):
        """`{ datetime }`
            \nLast updated time of the certificate based authentication provider
        """ # noqa: E501
        return self.__last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):

        self.__last_updated_time = last_updated_time

    @property
    def created_by(self):
        """`{ str }`
            \nUser or service who created the CertAuthProvider
        """ # noqa: E501
        return self.__created_by

    @created_by.setter
    def created_by(self, created_by):

        self.__created_by = created_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CertAuthProvider, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CertAuthProvider):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

