# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class CertRevocationInfo(object):
    """CertRevocationInfo - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'ocsp_enabled': 'bool',
        'ocsp_responder': 'str',
        'crl_enabled': 'bool',
        'crl_dps': 'list[str]',
        'global_crl_refresh_interval': 'int',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'ocsp_enabled': 'ocspEnabled',
        'ocsp_responder': 'ocspResponder',
        'crl_enabled': 'crlEnabled',
        'crl_dps': 'crlDps',
        'global_crl_refresh_interval': 'globalCrlRefreshInterval',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, ocsp_enabled=None, ocsp_responder=None, crl_enabled=None, crl_dps=None, global_crl_refresh_interval=None, *args, **kwargs):  # noqa: E501
        """CertRevocationInfo - a model defined in Swagger
            \nConfiguration details used for determining if the client certificate is revoked.
        """
        self.__ocsp_enabled = None
        self.__ocsp_responder = None
        self.__crl_enabled = None
        self.__crl_dps = None
        self.__global_crl_refresh_interval = None
        self.discriminator = None
        if ocsp_enabled is not None:
            self.__ocsp_enabled = ocsp_enabled
        if ocsp_responder is not None:
            self.__ocsp_responder = ocsp_responder
        if crl_enabled is not None:
            self.__crl_enabled = crl_enabled
        if crl_dps is not None:
            self.__crl_dps = crl_dps
        if global_crl_refresh_interval is not None:
            self.__global_crl_refresh_interval = global_crl_refresh_interval
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'iam.v4.authn.CertRevocationInfo'

    def _initialize_fq_object_type(self):
        return 'iam.v4.r0.a1.authn.CertRevocationInfo'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def ocsp_enabled(self):
        """`{ bool }`
            \nFlag to enable/disable OCSP revocation check
        """ # noqa: E501
        return self.__ocsp_enabled

    @ocsp_enabled.setter
    def ocsp_enabled(self, ocsp_enabled):

        self.__ocsp_enabled = ocsp_enabled

    @property
    def ocsp_responder(self):
        """`{ str }`
            \nURL of the OCSP responder used to override the URL from AIA extension
        """ # noqa: E501
        return self.__ocsp_responder

    @ocsp_responder.setter
    def ocsp_responder(self, ocsp_responder):
        if ocsp_responder is not None and not re.search('^((http[s]?):\/)?\/?([^:\/\\s]*)((\/\\w+)*(:[0-9]+)*?\/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$', ocsp_responder):  # noqa: E501
            raise ValueError(r"Invalid value for `ocsp_responder`, must be a follow pattern or equal to `/^((http[s]?):\/)?\/?([^:\/\\s]*)((\/\\w+)*(:[0-9]+)*?\/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$/`")  # noqa: E501

        self.__ocsp_responder = ocsp_responder

    @property
    def crl_enabled(self):
        """`{ bool }`
            \nFlag to enable/disable CRL revocation check
        """ # noqa: E501
        return self.__crl_enabled

    @crl_enabled.setter
    def crl_enabled(self, crl_enabled):

        self.__crl_enabled = crl_enabled

    @property
    def crl_dps(self):
        """`{ list[str] }`
            \nList of the CRL distribution points which will be used to fetch the CRLs
        """ # noqa: E501
        return self.__crl_dps

    @crl_dps.setter
    def crl_dps(self, crl_dps):

        self.__crl_dps = crl_dps

    @property
    def global_crl_refresh_interval(self):
        """`{ int }`
            \nInterval in seconds at which the CRL should be fetched from the CRLDP, default = 86400 seconds(1 day)
        """ # noqa: E501
        return self.__global_crl_refresh_interval

    @global_crl_refresh_interval.setter
    def global_crl_refresh_interval(self, global_crl_refresh_interval):

        self.__global_crl_refresh_interval = global_crl_refresh_interval

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CertRevocationInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CertRevocationInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

