# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class DirectoryServiceSearchQuery(object):
    """DirectoryServiceSearchQuery - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'query': 'str',
        'searched_attributes': 'list[str]',
        'returned_attributes': 'list[str]',
        'is_wildcard_search': 'bool',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'query': 'query',
        'searched_attributes': 'searchedAttributes',
        'returned_attributes': 'returnedAttributes',
        'is_wildcard_search': 'isWildcardSearch',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, query=None, searched_attributes=None, returned_attributes=None, is_wildcard_search=True, *args, **kwargs):  # noqa: E501
        """DirectoryServiceSearchQuery - a model defined in Swagger
            \nInformation for directory search query
        """
        self.__query = None
        self.__searched_attributes = None
        self.__returned_attributes = None
        self.__is_wildcard_search = None
        self.discriminator = None
        self.__query = query
        if searched_attributes is not None:
            self.__searched_attributes = searched_attributes
        if returned_attributes is not None:
            self.__returned_attributes = returned_attributes
        if is_wildcard_search is not None:
            self.__is_wildcard_search = is_wildcard_search
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'iam.v4.authn.DirectoryServiceSearchQuery'

    def _initialize_fq_object_type(self):
        return 'iam.v4.r0.a1.authn.DirectoryServiceSearchQuery'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def query(self):
        """`{ str }`
            \nQuery string for directory service search
        """ # noqa: E501
        return self.__query

    @query.setter
    def query(self, query):
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")  # noqa: E501
        if query is not None and len(query) > 2000:
            raise ValueError("Invalid value for `query`, length must be less than or equal to `2000`")  # noqa: E501

        self.__query = query

    @property
    def searched_attributes(self):
        """`{ list[str] }`
            \nAttributes for search operation. By default search will be performed with common name
        """ # noqa: E501
        return self.__searched_attributes

    @searched_attributes.setter
    def searched_attributes(self, searched_attributes):

        self.__searched_attributes = searched_attributes

    @property
    def returned_attributes(self):
        """`{ list[str] }`
            \nAttributes the search operation returns
        """ # noqa: E501
        return self.__returned_attributes

    @returned_attributes.setter
    def returned_attributes(self, returned_attributes):

        self.__returned_attributes = returned_attributes

    @property
    def is_wildcard_search(self):
        """`{ bool }`
            \nFlag indicating whether the search should be a wildcard search or not
        """ # noqa: E501
        return self.__is_wildcard_search

    @is_wildcard_search.setter
    def is_wildcard_search(self, is_wildcard_search):

        self.__is_wildcard_search = is_wildcard_search

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DirectoryServiceSearchQuery, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DirectoryServiceSearchQuery):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

