# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_iam_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.iam.v4.authn.IdpProperties import IdpProperties  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class SamlIdentityProvider(ExternalizableAbstractModel):
    """SamlIdentityProvider - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'idp_metadata_url': 'str',
        'idp_metadata': 'str',
        'idp_properties': 'iam.v4.authn.IdpProperties',
        'name': 'str',
        'username_attr': 'str',
        'email_attr': 'str',
        'groups_attr': 'str',
        'groups_delim': 'str',
        'custom_attr': 'list[str]',
        'entity_issuer': 'str',
        'enable_signed_authn_req': 'bool',
        'created_time': 'datetime',
        'last_updated_time': 'datetime',
        'created_by': 'str',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'idp_metadata_url': 'idpMetadataUrl',
        'idp_metadata': 'idpMetadata',
        'idp_properties': 'idpProperties',
        'name': 'name',
        'username_attr': 'usernameAttr',
        'email_attr': 'emailAttr',
        'groups_attr': 'groupsAttr',
        'groups_delim': 'groupsDelim',
        'custom_attr': 'customAttr',
        'entity_issuer': 'entityIssuer',
        'enable_signed_authn_req': 'enableSignedAuthnReq',
        'created_time': 'createdTime',
        'last_updated_time': 'lastUpdatedTime',
        'created_by': 'createdBy',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, idp_metadata_url=None, idp_metadata=None, idp_properties=None, name=None, username_attr='name', email_attr='email', groups_attr=None, groups_delim=None, custom_attr=None, entity_issuer=None, enable_signed_authn_req=None, created_time=None, last_updated_time=None, created_by=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """SamlIdentityProvider - a model defined in Swagger
            \nInformation of SAML IDP
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__idp_metadata_url = None
        self.__idp_metadata = None
        self.__idp_properties = None
        self.__name = None
        self.__username_attr = None
        self.__email_attr = None
        self.__groups_attr = None
        self.__groups_delim = None
        self.__custom_attr = None
        self.__entity_issuer = None
        self.__enable_signed_authn_req = None
        self.__created_time = None
        self.__last_updated_time = None
        self.__created_by = None
        self.discriminator = None
        if idp_metadata_url is not None:
            self.__idp_metadata_url = idp_metadata_url
        if idp_metadata is not None:
            self.__idp_metadata = idp_metadata
        if idp_properties is not None:
            self.__idp_properties = idp_properties
        self.__name = name
        self.__username_attr = username_attr
        self.__email_attr = email_attr
        if groups_attr is not None:
            self.__groups_attr = groups_attr
        if groups_delim is not None:
            self.__groups_delim = groups_delim
        if custom_attr is not None:
            self.__custom_attr = custom_attr
        if entity_issuer is not None:
            self.__entity_issuer = entity_issuer
        if enable_signed_authn_req is not None:
            self.__enable_signed_authn_req = enable_signed_authn_req
        if created_time is not None:
            self.__created_time = created_time
        if last_updated_time is not None:
            self.__last_updated_time = last_updated_time
        if created_by is not None:
            self.__created_by = created_by

    def _initialize_object_type(self):
        return 'iam.v4.authn.SamlIdentityProvider'

    def _initialize_fq_object_type(self):
        return 'iam.v4.r0.a1.authn.SamlIdentityProvider'


    @property
    def idp_metadata_url(self):
        """`{ str }`
            \nMetadata URL that provides IDP details
        """ # noqa: E501
        return self.__idp_metadata_url

    @idp_metadata_url.setter
    def idp_metadata_url(self, idp_metadata_url):
        if idp_metadata_url is not None and len(idp_metadata_url) > 2000:
            raise ValueError("Invalid value for `idp_metadata_url`, length must be less than or equal to `2000`")  # noqa: E501
        if idp_metadata_url is not None and len(idp_metadata_url) < 3:
            raise ValueError("Invalid value for `idp_metadata_url`, length must be greater than or equal to `3`")  # noqa: E501
        if idp_metadata_url is not None and not re.search('^((http[s]?):\/)?\/?([^:\/\\s]*)((\/\\w+)*(:[0-9]+)*?\/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$', idp_metadata_url):  # noqa: E501
            raise ValueError(r"Invalid value for `idp_metadata_url`, must be a follow pattern or equal to `/^((http[s]?):\/)?\/?([^:\/\\s]*)((\/\\w+)*(:[0-9]+)*?\/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$/`")  # noqa: E501

        self.__idp_metadata_url = idp_metadata_url

    @property
    def idp_metadata(self):
        """`{ str }`
            \nBase64 encoded metadata in xml format with IDP details
        """ # noqa: E501
        return self.__idp_metadata

    @idp_metadata.setter
    def idp_metadata(self, idp_metadata):
        if idp_metadata is not None and len(idp_metadata) < 3:
            raise ValueError("Invalid value for `idp_metadata`, length must be greater than or equal to `3`")  # noqa: E501

        self.__idp_metadata = idp_metadata

    @property
    def idp_properties(self):
        """`{ iam.v4.authn.IdpProperties }`
            
        """ # noqa: E501
        return self.__idp_properties

    @idp_properties.setter
    def idp_properties(self, idp_properties):

        self.__idp_properties = idp_properties

    @property
    def name(self):
        """`{ str }`
            \nUnique name of the IDP
        """ # noqa: E501
        return self.__name

    @name.setter
    def name(self, name):
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self.__name = name

    @property
    def username_attr(self):
        """`{ str }`
            \nSAML assertion username attribute element
        """ # noqa: E501
        return self.__username_attr

    @username_attr.setter
    def username_attr(self, username_attr):
        if username_attr is None:
            raise ValueError("Invalid value for `username_attr`, must not be `None`")  # noqa: E501
        if username_attr is not None and len(username_attr) > 256:
            raise ValueError("Invalid value for `username_attr`, length must be less than or equal to `256`")  # noqa: E501
        if username_attr is not None and len(username_attr) < 1:
            raise ValueError("Invalid value for `username_attr`, length must be greater than or equal to `1`")  # noqa: E501

        self.__username_attr = username_attr

    @property
    def email_attr(self):
        """`{ str }`
            \nSAML assertion email attribute element
        """ # noqa: E501
        return self.__email_attr

    @email_attr.setter
    def email_attr(self, email_attr):
        if email_attr is None:
            raise ValueError("Invalid value for `email_attr`, must not be `None`")  # noqa: E501
        if email_attr is not None and len(email_attr) > 256:
            raise ValueError("Invalid value for `email_attr`, length must be less than or equal to `256`")  # noqa: E501
        if email_attr is not None and len(email_attr) < 3:
            raise ValueError("Invalid value for `email_attr`, length must be greater than or equal to `3`")  # noqa: E501

        self.__email_attr = email_attr

    @property
    def groups_attr(self):
        """`{ str }`
            \nSAML assertion groups attribute element
        """ # noqa: E501
        return self.__groups_attr

    @groups_attr.setter
    def groups_attr(self, groups_attr):
        if groups_attr is not None and len(groups_attr) > 256:
            raise ValueError("Invalid value for `groups_attr`, length must be less than or equal to `256`")  # noqa: E501
        if groups_attr is not None and len(groups_attr) < 3:
            raise ValueError("Invalid value for `groups_attr`, length must be greater than or equal to `3`")  # noqa: E501

        self.__groups_attr = groups_attr

    @property
    def groups_delim(self):
        """`{ str }`
            \nDelimiter is used to split the value of attribute into multiple groups
        """ # noqa: E501
        return self.__groups_delim

    @groups_delim.setter
    def groups_delim(self, groups_delim):
        if groups_delim is not None and len(groups_delim) > 3:
            raise ValueError("Invalid value for `groups_delim`, length must be less than or equal to `3`")  # noqa: E501
        if groups_delim is not None and len(groups_delim) < 1:
            raise ValueError("Invalid value for `groups_delim`, length must be greater than or equal to `1`")  # noqa: E501

        self.__groups_delim = groups_delim

    @property
    def custom_attr(self):
        """`{ list[str] }`
            \nSAML assertions for list of custom attribute elements
        """ # noqa: E501
        return self.__custom_attr

    @custom_attr.setter
    def custom_attr(self, custom_attr):

        self.__custom_attr = custom_attr

    @property
    def entity_issuer(self):
        """`{ str }`
            \nIt will be used as issuer in SAML authentication request
        """ # noqa: E501
        return self.__entity_issuer

    @entity_issuer.setter
    def entity_issuer(self, entity_issuer):
        if entity_issuer is not None and len(entity_issuer) > 2000:
            raise ValueError("Invalid value for `entity_issuer`, length must be less than or equal to `2000`")  # noqa: E501
        if entity_issuer is not None and len(entity_issuer) < 3:
            raise ValueError("Invalid value for `entity_issuer`, length must be greater than or equal to `3`")  # noqa: E501

        self.__entity_issuer = entity_issuer

    @property
    def enable_signed_authn_req(self):
        """`{ bool }`
            \nFlag indicating signing of SAML authentication requests
        """ # noqa: E501
        return self.__enable_signed_authn_req

    @enable_signed_authn_req.setter
    def enable_signed_authn_req(self, enable_signed_authn_req):

        self.__enable_signed_authn_req = enable_signed_authn_req

    @property
    def created_time(self):
        """`{ datetime }`
            \nCreation time of the SAML Identity Provider
        """ # noqa: E501
        return self.__created_time

    @created_time.setter
    def created_time(self, created_time):

        self.__created_time = created_time

    @property
    def last_updated_time(self):
        """`{ datetime }`
            \nLast updated time of the SAML Identity Provider
        """ # noqa: E501
        return self.__last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):

        self.__last_updated_time = last_updated_time

    @property
    def created_by(self):
        """`{ str }`
            \nUser or service who created the SAML Identity Provider
        """ # noqa: E501
        return self.__created_by

    @created_by.setter
    def created_by(self, created_by):

        self.__created_by = created_by

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SamlIdentityProvider, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SamlIdentityProvider):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

