# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_iam_py_client.Ntnx.common.v1.response.ApiLink import ApiLink  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.common.v1.response.ExternalizableAbstractModel import ExternalizableAbstractModel  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.iam.v4.authz.AccessPolicyType import AccessPolicyType  # noqa: F401,E501
from ntnx_iam_py_client.Ntnx.iam.v4.authz.Filter import Filter  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class AccessPolicy(ExternalizableAbstractModel):
    """AccessPolicy - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'display_name': 'str',
        'description': 'str',
        'client_name': 'str',
        'identities': 'list[iam.v4.authz.Filter]',
        'objects': 'list[iam.v4.authz.Filter]',
        'role': 'str',
        'created_time': 'datetime',
        'last_updated_time': 'datetime',
        'created_by': 'str',
        'is_system_defined': 'bool',
        'access_policy_type': 'iam.v4.authz.AccessPolicyType',
        'ext_id': 'str',
        'links': 'list[common.v1.response.ApiLink]',
        'tenant_id': 'str',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'display_name': 'displayName',
        'description': 'description',
        'client_name': 'clientName',
        'identities': 'identities',
        'objects': 'objects',
        'role': 'role',
        'created_time': 'createdTime',
        'last_updated_time': 'lastUpdatedTime',
        'created_by': 'createdBy',
        'is_system_defined': 'isSystemDefined',
        'access_policy_type': 'accessPolicyType',
        'ext_id': 'extId',
        'links': 'links',
        'tenant_id': 'tenantId',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, display_name=None, description=None, client_name=None, identities=None, objects=None, role=None, created_time=None, last_updated_time=None, created_by=None, is_system_defined=True, access_policy_type=None, ext_id=None, links=None, tenant_id=None, *args, **kwargs):  # noqa: E501
        """AccessPolicy - a model defined in Swagger
            \nAn access policy to define who can perform what operation on which object
        """
        ExternalizableAbstractModel.__init__(self, ext_id, links, tenant_id, *args, **kwargs)
        self.__display_name = None
        self.__description = None
        self.__client_name = None
        self.__identities = None
        self.__objects = None
        self.__role = None
        self.__created_time = None
        self.__last_updated_time = None
        self.__created_by = None
        self.__is_system_defined = None
        self.__access_policy_type = None
        self.discriminator = None
        if display_name is not None:
            self.__display_name = display_name
        if description is not None:
            self.__description = description
        if client_name is not None:
            self.__client_name = client_name
        if identities is not None:
            self.__identities = identities
        if objects is not None:
            self.__objects = objects
        if role is not None:
            self.__role = role
        if created_time is not None:
            self.__created_time = created_time
        if last_updated_time is not None:
            self.__last_updated_time = last_updated_time
        if created_by is not None:
            self.__created_by = created_by
        if is_system_defined is not None:
            self.__is_system_defined = is_system_defined
        if access_policy_type is not None:
            self.__access_policy_type = access_policy_type

    def _initialize_object_type(self):
        return 'iam.v4.authz.AccessPolicy'

    def _initialize_fq_object_type(self):
        return 'iam.v4.r0.a1.authz.AccessPolicy'


    @property
    def display_name(self):
        """`{ str }`
            \nThe display name for the access policy
        """ # noqa: E501
        return self.__display_name

    @display_name.setter
    def display_name(self, display_name):
        if display_name is not None and len(display_name) > 255:
            raise ValueError("Invalid value for `display_name`, length must be less than or equal to `255`")  # noqa: E501
        if display_name is not None and len(display_name) < 1:
            raise ValueError("Invalid value for `display_name`, length must be greater than or equal to `1`")  # noqa: E501
        if display_name is not None and not re.search('^[^\\\"]*$', display_name):  # noqa: E501
            raise ValueError(r"Invalid value for `display_name`, must be a follow pattern or equal to `/^[^\\\"]*$/`")  # noqa: E501

        self.__display_name = display_name

    @property
    def description(self):
        """`{ str }`
            \nDescription of the access policy
        """ # noqa: E501
        return self.__description

    @description.setter
    def description(self, description):
        if description is not None and len(description) > 1000:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `1000`")  # noqa: E501

        self.__description = description

    @property
    def client_name(self):
        """`{ str }`
            \nClient that created the access policy
        """ # noqa: E501
        return self.__client_name

    @client_name.setter
    def client_name(self, client_name):
        if client_name is not None and len(client_name) > 255:
            raise ValueError("Invalid value for `client_name`, length must be less than or equal to `255`")  # noqa: E501

        self.__client_name = client_name

    @property
    def identities(self):
        """`{ list[iam.v4.authz.Filter] }`
            \nThe identities for which the access policy is created
        """ # noqa: E501
        return self.__identities

    @identities.setter
    def identities(self, identities):

        self.__identities = identities

    @property
    def objects(self):
        """`{ list[iam.v4.authz.Filter] }`
            \nThe objects being qualified by the access policy
        """ # noqa: E501
        return self.__objects

    @objects.setter
    def objects(self, objects):

        self.__objects = objects

    @property
    def role(self):
        """`{ str }`
            \nThe role associated with the access policy
        """ # noqa: E501
        return self.__role

    @role.setter
    def role(self, role):
        if role is not None and len(role) > 255:
            raise ValueError("Invalid value for `role`, length must be less than or equal to `255`")  # noqa: E501
        if role is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', role):  # noqa: E501
            raise ValueError(r"Invalid value for `role`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__role = role

    @property
    def created_time(self):
        """`{ datetime }`
            \nThe creation time of the access policy
        """ # noqa: E501
        return self.__created_time

    @created_time.setter
    def created_time(self, created_time):

        self.__created_time = created_time

    @property
    def last_updated_time(self):
        """`{ datetime }`
            \nThe time when the access policy was last updated
        """ # noqa: E501
        return self.__last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):

        self.__last_updated_time = last_updated_time

    @property
    def created_by(self):
        """`{ str }`
            \nUser or service name that created the access policy
        """ # noqa: E501
        return self.__created_by

    @created_by.setter
    def created_by(self, created_by):

        self.__created_by = created_by

    @property
    def is_system_defined(self):
        """`{ bool }`
            \nFlag identifying if the access policy is system defined or not
        """ # noqa: E501
        return self.__is_system_defined

    @is_system_defined.setter
    def is_system_defined(self, is_system_defined):

        self.__is_system_defined = is_system_defined

    @property
    def access_policy_type(self):
        """`{ iam.v4.authz.AccessPolicyType }`
            
        """ # noqa: E501
        return self.__access_policy_type

    @access_policy_type.setter
    def access_policy_type(self, access_policy_type):

        self.__access_policy_type = access_policy_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AccessPolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccessPolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

