# coding: utf-8


"""
IGNORE:
    Nutanix Iam Versioned APIs

    Identity and Access Management in Nutanix cluster.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_iam_py_client.api_client import ApiClient


class CertAuthProviderApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def handle_create_cert_auth_provider(self, clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, **kwargs):  # noqa: E501
        """Create certificate based authentication provider
        Create a certificate based authentication provider

        >>> response = api.handle_create_cert_auth_provider(clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, (optional) dirSvcExtID, (optional) certRevocationInfo, (optional) createdBy, (optional) tenantId, (optional) createdTime, (optional) links, (optional) lastUpdatedTime, (optional) extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_create_cert_auth_provider(clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, async_req=True)
        >>> result = thread.get()

        :param str clientCaChain: (required)
        :param bool certAuthEnabled: (required)
        :param bool cacEnabled: (required)
        :param str caCertFileName: (required)
        :param str name: (required)
        :param str dirSvcExtID:
        :param iam.v4.authn.CertRevocationInfo certRevocationInfo:
        :param str createdBy:
        :param str tenantId:
        :param datetime createdTime:
        :param list[common.v1.response.ApiLink] links:
        :param datetime lastUpdatedTime:
        :param str extId:
        :param bool async_req:
        :return: iam.v4.authn.CreateCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_create_cert_auth_provider_with_http_info(clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, **kwargs)  # noqa: E501
        else:
            (data) = self.handle_create_cert_auth_provider_with_http_info(clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, **kwargs)  # noqa: E501
            return data

    def handle_create_cert_auth_provider_with_http_info(self, clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, **kwargs):  # noqa: E501
        """Create certificate based authentication provider
        Create a certificate based authentication provider

        >>> response = api.handle_create_cert_auth_provider(clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, (optional) dirSvcExtID, (optional) certRevocationInfo, (optional) createdBy, (optional) tenantId, (optional) createdTime, (optional) links, (optional) lastUpdatedTime, (optional) extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_create_cert_auth_provider_with_http_info(clientCaChain, certAuthEnabled, cacEnabled, caCertFileName, name, async_req=True)
        >>> result = thread.get()

        :param str clientCaChain: (required)
        :param bool certAuthEnabled: (required)
        :param bool cacEnabled: (required)
        :param str caCertFileName: (required)
        :param str name: (required)
        :param str dirSvcExtID:
        :param iam.v4.authn.CertRevocationInfo certRevocationInfo:
        :param str createdBy:
        :param str tenantId:
        :param datetime createdTime:
        :param list[common.v1.response.ApiLink] links:
        :param datetime lastUpdatedTime:
        :param str extId:
        :param bool async_req:
        :return: iam.v4.authn.CreateCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clientCaChain', 'certAuthEnabled', 'cacEnabled', 'caCertFileName', 'name', 'dirSvcExtID', 'certRevocationInfo', 'createdBy', 'tenantId', 'createdTime', 'links', 'lastUpdatedTime', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_create_cert_auth_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'clientCaChain' is set
        if ('clientCaChain' not in params or
                params['clientCaChain'] is None):
            raise ValueError("Missing the required parameter `clientCaChain` when calling `handle_create_cert_auth_provider`")  # noqa: E501
        # verify the required parameter 'certAuthEnabled' is set
        if ('certAuthEnabled' not in params or
                params['certAuthEnabled'] is None):
            raise ValueError("Missing the required parameter `certAuthEnabled` when calling `handle_create_cert_auth_provider`")  # noqa: E501
        # verify the required parameter 'cacEnabled' is set
        if ('cacEnabled' not in params or
                params['cacEnabled'] is None):
            raise ValueError("Missing the required parameter `cacEnabled` when calling `handle_create_cert_auth_provider`")  # noqa: E501
        # verify the required parameter 'caCertFileName' is set
        if ('caCertFileName' not in params or
                params['caCertFileName'] is None):
            raise ValueError("Missing the required parameter `caCertFileName` when calling `handle_create_cert_auth_provider`")  # noqa: E501
        # verify the required parameter 'name' is set
        if ('name' not in params or
                params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `handle_create_cert_auth_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'clientCaChain' in params:
            form_params.append(('clientCaChain', params['clientCaChain']))  # noqa: E501
        if 'dirSvcExtID' in params:
            form_params.append(('dirSvcExtID', params['dirSvcExtID']))  # noqa: E501
        if 'certAuthEnabled' in params:
            form_params.append(('certAuthEnabled', params['certAuthEnabled']))  # noqa: E501
        if 'cacEnabled' in params:
            form_params.append(('cacEnabled', params['cacEnabled']))  # noqa: E501
        if 'certRevocationInfo' in params:
            form_params.append(('certRevocationInfo', params['certRevocationInfo']))  # noqa: E501
        if 'caCertFileName' in params:
            form_params.append(('caCertFileName', params['caCertFileName']))  # noqa: E501
        if 'createdBy' in params:
            form_params.append(('createdBy', params['createdBy']))  # noqa: E501
        if 'tenantId' in params:
            form_params.append(('tenantId', params['tenantId']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'createdTime' in params:
            form_params.append(('createdTime', params['createdTime']))  # noqa: E501
        if 'links' in params:
            form_params.append(('links', params['links']))  # noqa: E501
            collection_formats['links'] = 'multi'  # noqa: E501
        if 'lastUpdatedTime' in params:
            form_params.append(('lastUpdatedTime', params['lastUpdatedTime']))  # noqa: E501
        if 'extId' in params:
            form_params.append(('extId', params['extId']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/iam/v4.0.a1/authn/cert-auth-providers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='iam.v4.authn.CreateCertAuthProviderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_get_cert_auth_provider(self, extId, **kwargs):  # noqa: E501
        """Get certificate based authentication provider
        Get a certificate based authentication provider by its UUID

        >>> response = api.handle_get_cert_auth_provider(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_get_cert_auth_provider(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: External identifier of the certificate based authentication provider (required)
        :param bool async_req:
        :return: iam.v4.authn.GetCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_get_cert_auth_provider_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.handle_get_cert_auth_provider_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def handle_get_cert_auth_provider_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Get certificate based authentication provider
        Get a certificate based authentication provider by its UUID

        >>> response = api.handle_get_cert_auth_provider(extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_get_cert_auth_provider_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str extId: External identifier of the certificate based authentication provider (required)
        :param bool async_req:
        :return: iam.v4.authn.GetCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_get_cert_auth_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `handle_get_cert_auth_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/iam/v4.0.a1/authn/cert-auth-providers/{extId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='iam.v4.authn.GetCertAuthProviderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_list_cert_auth_providers(self, **kwargs):  # noqa: E501
        """List certificate based authentication provider(s)
        Get a list of all configured certificate based authentication providers

        >>> response = api.handle_list_cert_auth_providers((optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_list_cert_auth_providers(async_req=True)
        >>> result = thread.get()

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - createdBy
        - extId
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - createdTime
        - lastUpdatedTime
        - name
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- caCertFileName
- cacEnabled
- certAuthEnabled
- certRevocationInfo
- clientCaChain
- createdBy
- createdTime
- dirSvcExtID
- extId
- lastUpdatedTime
- links
- name
- tenantId

        :param bool async_req:
        :return: iam.v4.authn.ListCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_list_cert_auth_providers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.handle_list_cert_auth_providers_with_http_info(**kwargs)  # noqa: E501
            return data

    def handle_list_cert_auth_providers_with_http_info(self, **kwargs):  # noqa: E501
        """List certificate based authentication provider(s)
        Get a list of all configured certificate based authentication providers

        >>> response = api.handle_list_cert_auth_providers((optional) _filter, (optional) _orderby, (optional) _select)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_list_cert_auth_providers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param str _filter: A URL query parameter that allows clients to filter a collection of resources. The expression specified with $filter is evaluated for each resource in the collection, and only items where the expression evaluates to true are included in the response. Expression specified with the $filter must conform to the OData V4.01 URL conventions.
        The filter can be applied on the following fields:
        
        - createdBy
        - extId
        - name
        
        :param str _orderby: A URL query parameter that allows clients to specify the sort criteria for the returned list of objects. Resources can be sorted in ascending order using asc or descending order using desc. If asc or desc are not specified the resources will be sorted in ascending order by default. For example, 'orderby=templateName desc' would get all templates sorted by templateName in desc order.
        The orderby can be applied to the following fields:
        
        - createdTime
        - lastUpdatedTime
        - name
        
        :param str _select: A URL query parameter that allows clients to request a specific set of properties for each entity or complex type. Expression specified with the $select must conform to the OData V4.01 URL conventions. If a $select expression consists of a single select item that is an asterisk (i.e. *), then all properties on the matching resource will be returned.
- caCertFileName
- cacEnabled
- certAuthEnabled
- certRevocationInfo
- clientCaChain
- createdBy
- createdTime
- dirSvcExtID
- extId
- lastUpdatedTime
- links
- name
- tenantId

        :param bool async_req:
        :return: iam.v4.authn.ListCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['_filter', '_orderby', '_select']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_list_cert_auth_providers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_filter' in params:
            query_params.append(('$filter', params['_filter']))  # noqa: E501
        if '_orderby' in params:
            query_params.append(('$orderby', params['_orderby']))  # noqa: E501
        if '_select' in params:
            query_params.append(('$select', params['_select']))  # noqa: E501

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/iam/v4.0.a1/authn/cert-auth-providers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='iam.v4.authn.ListCertAuthProviderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_update_cert_auth_provider(self, extId, **kwargs):  # noqa: E501
        """Update certificate based authentication provider
        Update a certificate based authentication provider configuration

        >>> response = api.handle_update_cert_auth_provider((optional) clientCaChain, (optional) dirSvcExtID, (optional) certAuthEnabled, (optional) cacEnabled, (optional) certRevocationInfo, (optional) caCertFileName, (optional) createdBy, (optional) tenantId, (optional) name, (optional) createdTime, (optional) links, (optional) lastUpdatedTime, (optional) extId2, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_update_cert_auth_provider(extId, async_req=True)
        >>> result = thread.get()

        :param str clientCaChain:
        :param str dirSvcExtID:
        :param bool certAuthEnabled:
        :param bool cacEnabled:
        :param iam.v4.authn.CertRevocationInfo certRevocationInfo:
        :param str caCertFileName:
        :param str createdBy:
        :param str tenantId:
        :param str name:
        :param datetime createdTime:
        :param list[common.v1.response.ApiLink] links:
        :param datetime lastUpdatedTime:
        :param str extId2:
        :param str extId: External identifier of the certificate based authentication provider (required)
        :param bool async_req:
        :return: iam.v4.authn.UpdateCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_update_cert_auth_provider_with_http_info(extId, **kwargs)  # noqa: E501
        else:
            (data) = self.handle_update_cert_auth_provider_with_http_info(extId, **kwargs)  # noqa: E501
            return data

    def handle_update_cert_auth_provider_with_http_info(self, extId, **kwargs):  # noqa: E501
        """Update certificate based authentication provider
        Update a certificate based authentication provider configuration

        >>> response = api.handle_update_cert_auth_provider((optional) clientCaChain, (optional) dirSvcExtID, (optional) certAuthEnabled, (optional) cacEnabled, (optional) certRevocationInfo, (optional) caCertFileName, (optional) createdBy, (optional) tenantId, (optional) name, (optional) createdTime, (optional) links, (optional) lastUpdatedTime, (optional) extId2, extId)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.handle_update_cert_auth_provider_with_http_info(extId, async_req=True)
        >>> result = thread.get()

        :param str clientCaChain:
        :param str dirSvcExtID:
        :param bool certAuthEnabled:
        :param bool cacEnabled:
        :param iam.v4.authn.CertRevocationInfo certRevocationInfo:
        :param str caCertFileName:
        :param str createdBy:
        :param str tenantId:
        :param str name:
        :param datetime createdTime:
        :param list[common.v1.response.ApiLink] links:
        :param datetime lastUpdatedTime:
        :param str extId2:
        :param str extId: External identifier of the certificate based authentication provider (required)
        :param bool async_req:
        :return: iam.v4.authn.UpdateCertAuthProviderApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['clientCaChain', 'dirSvcExtID', 'certAuthEnabled', 'cacEnabled', 'certRevocationInfo', 'caCertFileName', 'createdBy', 'tenantId', 'name', 'createdTime', 'links', 'lastUpdatedTime', 'extId2', 'extId']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_update_cert_auth_provider" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'extId' is set
        if ('extId' not in params or
                params['extId'] is None):
            raise ValueError("Missing the required parameter `extId` when calling `handle_update_cert_auth_provider`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'extId' in params:
            path_params['extId'] = params['extId']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}
        if 'clientCaChain' in params:
            form_params.append(('clientCaChain', params['clientCaChain']))  # noqa: E501
        if 'dirSvcExtID' in params:
            form_params.append(('dirSvcExtID', params['dirSvcExtID']))  # noqa: E501
        if 'certAuthEnabled' in params:
            form_params.append(('certAuthEnabled', params['certAuthEnabled']))  # noqa: E501
        if 'cacEnabled' in params:
            form_params.append(('cacEnabled', params['cacEnabled']))  # noqa: E501
        if 'certRevocationInfo' in params:
            form_params.append(('certRevocationInfo', params['certRevocationInfo']))  # noqa: E501
        if 'caCertFileName' in params:
            form_params.append(('caCertFileName', params['caCertFileName']))  # noqa: E501
        if 'createdBy' in params:
            form_params.append(('createdBy', params['createdBy']))  # noqa: E501
        if 'tenantId' in params:
            form_params.append(('tenantId', params['tenantId']))  # noqa: E501
        if 'name' in params:
            form_params.append(('name', params['name']))  # noqa: E501
        if 'createdTime' in params:
            form_params.append(('createdTime', params['createdTime']))  # noqa: E501
        if 'links' in params:
            form_params.append(('links', params['links']))  # noqa: E501
            collection_formats['links'] = 'multi'  # noqa: E501
        if 'lastUpdatedTime' in params:
            form_params.append(('lastUpdatedTime', params['lastUpdatedTime']))  # noqa: E501
        if 'extId2' in params:
            form_params.append(('extId', params['extId2']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/iam/v4.0.a1/authn/cert-auth-providers/{extId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='iam.v4.authn.UpdateCertAuthProviderApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
