# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
import itertools
from typing import Callable, List, Optional, Tuple, TypeVar


T = TypeVar("T")


def partition(
    items: List[T], predicate: Callable[[T], bool]
) -> Tuple[List[T], List[T]]:
    """Partitions provided list into 2 based on the value of the predicate, where:
        - First element is the list of elements for which value of the predicate is truthful
        - Second element are remaining elements
    """
    first = []
    second = []
    for i in items:
        if predicate(i):
            first.append(i)
        else:
            second.append(i)

    return first, second


def flatten(*lists: List[T]) -> List[T]:
    return list(itertools.chain(*lists))


def as_list(o: Optional[T]) -> List[T]:
    """Converts "container" holding optional value into a list"""
    return [o] if o else []
