# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### ApplicationSettings <a name="ApplicationSettings" id="@cdktf/provider-gitlab.ApplicationSettings"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/application_settings gitlab_application_settings}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.ApplicationSettings.Initializer"></a>

```typescript
import { ApplicationSettings } from '@cdktf/provider-gitlab'

new ApplicationSettings(scope: Construct, id: string, config?: ApplicationSettingsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.ApplicationSettingsConfig">ApplicationSettingsConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.ApplicationSettings.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.ApplicationSettings.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.ApplicationSettings.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.ApplicationSettingsConfig">ApplicationSettingsConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAbuseNotificationEmail">resetAbuseNotificationEmail</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAdminMode">resetAdminMode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAfterSignOutPath">resetAfterSignOutPath</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAfterSignUpText">resetAfterSignUpText</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAkismetApiKey">resetAkismetApiKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAkismetEnabled">resetAkismetEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAllowGroupOwnersToManageLdap">resetAllowGroupOwnersToManageLdap</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAllowLocalRequestsFromSystemHooks">resetAllowLocalRequestsFromSystemHooks</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAllowLocalRequestsFromWebHooksAndServices">resetAllowLocalRequestsFromWebHooksAndServices</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetArchiveBuildsInHumanReadable">resetArchiveBuildsInHumanReadable</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxyAllowlist">resetAssetProxyAllowlist</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxyEnabled">resetAssetProxyEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxySecretKey">resetAssetProxySecretKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxyUrl">resetAssetProxyUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAuthorizedKeysEnabled">resetAuthorizedKeysEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAutoDevopsDomain">resetAutoDevopsDomain</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAutoDevopsEnabled">resetAutoDevopsEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetAutomaticPurchasedStorageAllocation">resetAutomaticPurchasedStorageAllocation</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetCheckNamespacePlan">resetCheckNamespacePlan</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetCommitEmailHostname">resetCommitEmailHostname</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetContainerExpirationPoliciesEnableHistoricEntries">resetContainerExpirationPoliciesEnableHistoricEntries</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryCleanupTagsServiceMaxListSize">resetContainerRegistryCleanupTagsServiceMaxListSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryDeleteTagsServiceTimeout">resetContainerRegistryDeleteTagsServiceTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryExpirationPoliciesCaching">resetContainerRegistryExpirationPoliciesCaching</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryExpirationPoliciesWorkerCapacity">resetContainerRegistryExpirationPoliciesWorkerCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryTokenExpireDelay">resetContainerRegistryTokenExpireDelay</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDeactivateDormantUsers">resetDeactivateDormantUsers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultArtifactsExpireIn">resetDefaultArtifactsExpireIn</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultBranchName">resetDefaultBranchName</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultBranchProtection">resetDefaultBranchProtection</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultCiConfigPath">resetDefaultCiConfigPath</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultGroupVisibility">resetDefaultGroupVisibility</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultProjectCreation">resetDefaultProjectCreation</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultProjectsLimit">resetDefaultProjectsLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultProjectVisibility">resetDefaultProjectVisibility</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDefaultSnippetVisibility">resetDefaultSnippetVisibility</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDelayedGroupDeletion">resetDelayedGroupDeletion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDelayedProjectDeletion">resetDelayedProjectDeletion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDeleteInactiveProjects">resetDeleteInactiveProjects</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDeletionAdjournedPeriod">resetDeletionAdjournedPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDiffMaxFiles">resetDiffMaxFiles</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDiffMaxLines">resetDiffMaxLines</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDiffMaxPatchBytes">resetDiffMaxPatchBytes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDisabledOauthSignInSources">resetDisabledOauthSignInSources</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDisableFeedToken">resetDisableFeedToken</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDnsRebindingProtectionEnabled">resetDnsRebindingProtectionEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDomainAllowlist">resetDomainAllowlist</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDomainDenylist">resetDomainDenylist</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDomainDenylistEnabled">resetDomainDenylistEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetDsaKeyRestriction">resetDsaKeyRestriction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEcdsaKeyRestriction">resetEcdsaKeyRestriction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEcdsaSkKeyRestriction">resetEcdsaSkKeyRestriction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEd25519KeyRestriction">resetEd25519KeyRestriction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEd25519SkKeyRestriction">resetEd25519SkKeyRestriction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEksAccessKeyId">resetEksAccessKeyId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEksAccountId">resetEksAccountId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEksIntegrationEnabled">resetEksIntegrationEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEksSecretAccessKey">resetEksSecretAccessKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAws">resetElasticsearchAws</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAwsAccessKey">resetElasticsearchAwsAccessKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAwsRegion">resetElasticsearchAwsRegion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAwsSecretAccessKey">resetElasticsearchAwsSecretAccessKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchIndexedFieldLengthLimit">resetElasticsearchIndexedFieldLengthLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchIndexedFileSizeLimitKb">resetElasticsearchIndexedFileSizeLimitKb</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchIndexing">resetElasticsearchIndexing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchLimitIndexing">resetElasticsearchLimitIndexing</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchMaxBulkConcurrency">resetElasticsearchMaxBulkConcurrency</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchMaxBulkSizeMb">resetElasticsearchMaxBulkSizeMb</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchNamespaceIds">resetElasticsearchNamespaceIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchPassword">resetElasticsearchPassword</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchProjectIds">resetElasticsearchProjectIds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchSearch">resetElasticsearchSearch</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchUrl">resetElasticsearchUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchUsername">resetElasticsearchUsername</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEmailAdditionalText">resetEmailAdditionalText</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEmailAuthorInBody">resetEmailAuthorInBody</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEnabledGitAccessProtocol">resetEnabledGitAccessProtocol</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEnforceNamespaceStorageLimit">resetEnforceNamespaceStorageLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetEnforceTerms">resetEnforceTerms</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthClientCert">resetExternalAuthClientCert</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthClientKey">resetExternalAuthClientKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthClientKeyPass">resetExternalAuthClientKeyPass</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceDefaultLabel">resetExternalAuthorizationServiceDefaultLabel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceEnabled">resetExternalAuthorizationServiceEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceTimeout">resetExternalAuthorizationServiceTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceUrl">resetExternalAuthorizationServiceUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalPipelineValidationServiceTimeout">resetExternalPipelineValidationServiceTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalPipelineValidationServiceToken">resetExternalPipelineValidationServiceToken</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetExternalPipelineValidationServiceUrl">resetExternalPipelineValidationServiceUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetFileTemplateProjectId">resetFileTemplateProjectId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetFirstDayOfWeek">resetFirstDayOfWeek</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGeoNodeAllowedIps">resetGeoNodeAllowedIps</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGeoStatusTimeout">resetGeoStatusTimeout</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGitalyTimeoutDefault">resetGitalyTimeoutDefault</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGitalyTimeoutFast">resetGitalyTimeoutFast</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGitalyTimeoutMedium">resetGitalyTimeoutMedium</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGitRateLimitUsersAllowlist">resetGitRateLimitUsersAllowlist</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGitTwoFactorSessionExpiry">resetGitTwoFactorSessionExpiry</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGrafanaEnabled">resetGrafanaEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGrafanaUrl">resetGrafanaUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetGravatarEnabled">resetGravatarEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHashedStorageEnabled">resetHashedStorageEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHelpPageHideCommercialContent">resetHelpPageHideCommercialContent</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHelpPageSupportUrl">resetHelpPageSupportUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHelpPageText">resetHelpPageText</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHelpText">resetHelpText</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHideThirdPartyOffers">resetHideThirdPartyOffers</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHomePageUrl">resetHomePageUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingEnabled">resetHousekeepingEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingFullRepackPeriod">resetHousekeepingFullRepackPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingGcPeriod">resetHousekeepingGcPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingIncrementalRepackPeriod">resetHousekeepingIncrementalRepackPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetHtmlEmailsEnabled">resetHtmlEmailsEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetImportSources">resetImportSources</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetInactiveProjectsDeleteAfterMonths">resetInactiveProjectsDeleteAfterMonths</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetInactiveProjectsMinSizeMb">resetInactiveProjectsMinSizeMb</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetInactiveProjectsSendWarningEmailAfterMonths">resetInactiveProjectsSendWarningEmailAfterMonths</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetInProductMarketingEmailsEnabled">resetInProductMarketingEmailsEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetInvisibleCaptchaEnabled">resetInvisibleCaptchaEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetIssuesCreateLimit">resetIssuesCreateLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetKeepLatestArtifact">resetKeepLatestArtifact</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetLocalMarkdownVersion">resetLocalMarkdownVersion</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMailgunEventsEnabled">resetMailgunEventsEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMailgunSigningKey">resetMailgunSigningKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaintenanceMode">resetMaintenanceMode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaintenanceModeMessage">resetMaintenanceModeMessage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxArtifactsSize">resetMaxArtifactsSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxAttachmentSize">resetMaxAttachmentSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxExportSize">resetMaxExportSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxImportSize">resetMaxImportSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxNumberOfRepositoryDownloads">resetMaxNumberOfRepositoryDownloads</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxNumberOfRepositoryDownloadsWithinTimePeriod">resetMaxNumberOfRepositoryDownloadsWithinTimePeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxPagesSize">resetMaxPagesSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxPersonalAccessTokenLifetime">resetMaxPersonalAccessTokenLifetime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMaxSshKeyLifetime">resetMaxSshKeyLifetime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMetricsMethodCallThreshold">resetMetricsMethodCallThreshold</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMirrorAvailable">resetMirrorAvailable</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMirrorCapacityThreshold">resetMirrorCapacityThreshold</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMirrorMaxCapacity">resetMirrorMaxCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetMirrorMaxDelay">resetMirrorMaxDelay</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetNpmPackageRequestsForwarding">resetNpmPackageRequestsForwarding</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetOutboundLocalRequestsWhitelist">resetOutboundLocalRequestsWhitelist</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPackageRegistryCleanupPoliciesWorkerCapacity">resetPackageRegistryCleanupPoliciesWorkerCapacity</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPagesDomainVerificationEnabled">resetPagesDomainVerificationEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPasswordAuthenticationEnabledForGit">resetPasswordAuthenticationEnabledForGit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPasswordAuthenticationEnabledForWeb">resetPasswordAuthenticationEnabledForWeb</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPasswordLowercaseRequired">resetPasswordLowercaseRequired</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPasswordNumberRequired">resetPasswordNumberRequired</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPasswordSymbolRequired">resetPasswordSymbolRequired</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPasswordUppercaseRequired">resetPasswordUppercaseRequired</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPerformanceBarAllowedGroupPath">resetPerformanceBarAllowedGroupPath</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPersonalAccessTokenPrefix">resetPersonalAccessTokenPrefix</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPipelineLimitPerProjectUserSha">resetPipelineLimitPerProjectUserSha</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPlantumlEnabled">resetPlantumlEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPlantumlUrl">resetPlantumlUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPollingIntervalMultiplier">resetPollingIntervalMultiplier</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetProjectExportEnabled">resetProjectExportEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPrometheusMetricsEnabled">resetPrometheusMetricsEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetProtectedCiVariables">resetProtectedCiVariables</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPushEventActivitiesLimit">resetPushEventActivitiesLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPushEventHooksLimit">resetPushEventHooksLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetPypiPackageRequestsForwarding">resetPypiPackageRequestsForwarding</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRateLimitingResponseText">resetRateLimitingResponseText</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRawBlobRequestLimit">resetRawBlobRequestLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRecaptchaEnabled">resetRecaptchaEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRecaptchaPrivateKey">resetRecaptchaPrivateKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRecaptchaSiteKey">resetRecaptchaSiteKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetReceiveMaxInputSize">resetReceiveMaxInputSize</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRepositoryChecksEnabled">resetRepositoryChecksEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRepositorySizeLimit">resetRepositorySizeLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRepositoryStorages">resetRepositoryStorages</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRepositoryStoragesWeighted">resetRepositoryStoragesWeighted</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRequireAdminApprovalAfterUserSignup">resetRequireAdminApprovalAfterUserSignup</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRequireTwoFactorAuthentication">resetRequireTwoFactorAuthentication</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRestrictedVisibilityLevels">resetRestrictedVisibilityLevels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetRsaKeyRestriction">resetRsaKeyRestriction</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSearchRateLimit">resetSearchRateLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSearchRateLimitUnauthenticated">resetSearchRateLimitUnauthenticated</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSendUserConfirmationEmail">resetSendUserConfirmationEmail</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSessionExpireDelay">resetSessionExpireDelay</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSharedRunnersEnabled">resetSharedRunnersEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSharedRunnersMinutes">resetSharedRunnersMinutes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSharedRunnersText">resetSharedRunnersText</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSidekiqJobLimiterCompressionThresholdBytes">resetSidekiqJobLimiterCompressionThresholdBytes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSidekiqJobLimiterLimitBytes">resetSidekiqJobLimiterLimitBytes</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSidekiqJobLimiterMode">resetSidekiqJobLimiterMode</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSignInText">resetSignInText</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSignupEnabled">resetSignupEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppEnabled">resetSlackAppEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppId">resetSlackAppId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppSecret">resetSlackAppSecret</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppSigningSecret">resetSlackAppSigningSecret</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppVerificationToken">resetSlackAppVerificationToken</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSnippetSizeLimit">resetSnippetSizeLimit</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowAppId">resetSnowplowAppId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowCollectorHostname">resetSnowplowCollectorHostname</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowCookieDomain">resetSnowplowCookieDomain</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowEnabled">resetSnowplowEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSourcegraphEnabled">resetSourcegraphEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSourcegraphPublicOnly">resetSourcegraphPublicOnly</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSourcegraphUrl">resetSourcegraphUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSpamCheckApiKey">resetSpamCheckApiKey</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSpamCheckEndpointEnabled">resetSpamCheckEndpointEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSpamCheckEndpointUrl">resetSpamCheckEndpointUrl</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetSuggestPipelineEnabled">resetSuggestPipelineEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetTerminalMaxSessionTime">resetTerminalMaxSessionTime</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetTerms">resetTerms</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedApiEnabled">resetThrottleAuthenticatedApiEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedApiPeriodInSeconds">resetThrottleAuthenticatedApiPeriodInSeconds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedApiRequestsPerPeriod">resetThrottleAuthenticatedApiRequestsPerPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedPackagesApiEnabled">resetThrottleAuthenticatedPackagesApiEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedPackagesApiPeriodInSeconds">resetThrottleAuthenticatedPackagesApiPeriodInSeconds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedPackagesApiRequestsPerPeriod">resetThrottleAuthenticatedPackagesApiRequestsPerPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedWebEnabled">resetThrottleAuthenticatedWebEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedWebPeriodInSeconds">resetThrottleAuthenticatedWebPeriodInSeconds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedWebRequestsPerPeriod">resetThrottleAuthenticatedWebRequestsPerPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedApiEnabled">resetThrottleUnauthenticatedApiEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedApiPeriodInSeconds">resetThrottleUnauthenticatedApiPeriodInSeconds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedApiRequestsPerPeriod">resetThrottleUnauthenticatedApiRequestsPerPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedPackagesApiEnabled">resetThrottleUnauthenticatedPackagesApiEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedPackagesApiPeriodInSeconds">resetThrottleUnauthenticatedPackagesApiPeriodInSeconds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod">resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedWebEnabled">resetThrottleUnauthenticatedWebEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedWebPeriodInSeconds">resetThrottleUnauthenticatedWebPeriodInSeconds</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedWebRequestsPerPeriod">resetThrottleUnauthenticatedWebRequestsPerPeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetTimeTrackingLimitToHours">resetTimeTrackingLimitToHours</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetTwoFactorGracePeriod">resetTwoFactorGracePeriod</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUniqueIpsLimitEnabled">resetUniqueIpsLimitEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUniqueIpsLimitPerUser">resetUniqueIpsLimitPerUser</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUniqueIpsLimitTimeWindow">resetUniqueIpsLimitTimeWindow</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUsagePingEnabled">resetUsagePingEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUserDeactivationEmailsEnabled">resetUserDeactivationEmailsEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUserDefaultExternal">resetUserDefaultExternal</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUserDefaultInternalRegex">resetUserDefaultInternalRegex</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUserOauthApplications">resetUserOauthApplications</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetUserShowAddSshKeyMessage">resetUserShowAddSshKeyMessage</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetVersionCheckEnabled">resetVersionCheckEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetWebIdeClientsidePreviewEnabled">resetWebIdeClientsidePreviewEnabled</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetWhatsNewVariant">resetWhatsNewVariant</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.resetWikiPageMaxContentBytes">resetWikiPageMaxContentBytes</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.ApplicationSettings.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.ApplicationSettings.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.ApplicationSettings.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.ApplicationSettings.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.ApplicationSettings.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.ApplicationSettings.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.ApplicationSettings.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.ApplicationSettings.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.ApplicationSettings.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ApplicationSettings.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetAbuseNotificationEmail` <a name="resetAbuseNotificationEmail" id="@cdktf/provider-gitlab.ApplicationSettings.resetAbuseNotificationEmail"></a>

```typescript
public resetAbuseNotificationEmail(): void
```

##### `resetAdminMode` <a name="resetAdminMode" id="@cdktf/provider-gitlab.ApplicationSettings.resetAdminMode"></a>

```typescript
public resetAdminMode(): void
```

##### `resetAfterSignOutPath` <a name="resetAfterSignOutPath" id="@cdktf/provider-gitlab.ApplicationSettings.resetAfterSignOutPath"></a>

```typescript
public resetAfterSignOutPath(): void
```

##### `resetAfterSignUpText` <a name="resetAfterSignUpText" id="@cdktf/provider-gitlab.ApplicationSettings.resetAfterSignUpText"></a>

```typescript
public resetAfterSignUpText(): void
```

##### `resetAkismetApiKey` <a name="resetAkismetApiKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetAkismetApiKey"></a>

```typescript
public resetAkismetApiKey(): void
```

##### `resetAkismetEnabled` <a name="resetAkismetEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetAkismetEnabled"></a>

```typescript
public resetAkismetEnabled(): void
```

##### `resetAllowGroupOwnersToManageLdap` <a name="resetAllowGroupOwnersToManageLdap" id="@cdktf/provider-gitlab.ApplicationSettings.resetAllowGroupOwnersToManageLdap"></a>

```typescript
public resetAllowGroupOwnersToManageLdap(): void
```

##### `resetAllowLocalRequestsFromSystemHooks` <a name="resetAllowLocalRequestsFromSystemHooks" id="@cdktf/provider-gitlab.ApplicationSettings.resetAllowLocalRequestsFromSystemHooks"></a>

```typescript
public resetAllowLocalRequestsFromSystemHooks(): void
```

##### `resetAllowLocalRequestsFromWebHooksAndServices` <a name="resetAllowLocalRequestsFromWebHooksAndServices" id="@cdktf/provider-gitlab.ApplicationSettings.resetAllowLocalRequestsFromWebHooksAndServices"></a>

```typescript
public resetAllowLocalRequestsFromWebHooksAndServices(): void
```

##### `resetArchiveBuildsInHumanReadable` <a name="resetArchiveBuildsInHumanReadable" id="@cdktf/provider-gitlab.ApplicationSettings.resetArchiveBuildsInHumanReadable"></a>

```typescript
public resetArchiveBuildsInHumanReadable(): void
```

##### `resetAssetProxyAllowlist` <a name="resetAssetProxyAllowlist" id="@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxyAllowlist"></a>

```typescript
public resetAssetProxyAllowlist(): void
```

##### `resetAssetProxyEnabled` <a name="resetAssetProxyEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxyEnabled"></a>

```typescript
public resetAssetProxyEnabled(): void
```

##### `resetAssetProxySecretKey` <a name="resetAssetProxySecretKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxySecretKey"></a>

```typescript
public resetAssetProxySecretKey(): void
```

##### `resetAssetProxyUrl` <a name="resetAssetProxyUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetAssetProxyUrl"></a>

```typescript
public resetAssetProxyUrl(): void
```

##### `resetAuthorizedKeysEnabled` <a name="resetAuthorizedKeysEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetAuthorizedKeysEnabled"></a>

```typescript
public resetAuthorizedKeysEnabled(): void
```

##### `resetAutoDevopsDomain` <a name="resetAutoDevopsDomain" id="@cdktf/provider-gitlab.ApplicationSettings.resetAutoDevopsDomain"></a>

```typescript
public resetAutoDevopsDomain(): void
```

##### `resetAutoDevopsEnabled` <a name="resetAutoDevopsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetAutoDevopsEnabled"></a>

```typescript
public resetAutoDevopsEnabled(): void
```

##### `resetAutomaticPurchasedStorageAllocation` <a name="resetAutomaticPurchasedStorageAllocation" id="@cdktf/provider-gitlab.ApplicationSettings.resetAutomaticPurchasedStorageAllocation"></a>

```typescript
public resetAutomaticPurchasedStorageAllocation(): void
```

##### `resetCheckNamespacePlan` <a name="resetCheckNamespacePlan" id="@cdktf/provider-gitlab.ApplicationSettings.resetCheckNamespacePlan"></a>

```typescript
public resetCheckNamespacePlan(): void
```

##### `resetCommitEmailHostname` <a name="resetCommitEmailHostname" id="@cdktf/provider-gitlab.ApplicationSettings.resetCommitEmailHostname"></a>

```typescript
public resetCommitEmailHostname(): void
```

##### `resetContainerExpirationPoliciesEnableHistoricEntries` <a name="resetContainerExpirationPoliciesEnableHistoricEntries" id="@cdktf/provider-gitlab.ApplicationSettings.resetContainerExpirationPoliciesEnableHistoricEntries"></a>

```typescript
public resetContainerExpirationPoliciesEnableHistoricEntries(): void
```

##### `resetContainerRegistryCleanupTagsServiceMaxListSize` <a name="resetContainerRegistryCleanupTagsServiceMaxListSize" id="@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryCleanupTagsServiceMaxListSize"></a>

```typescript
public resetContainerRegistryCleanupTagsServiceMaxListSize(): void
```

##### `resetContainerRegistryDeleteTagsServiceTimeout` <a name="resetContainerRegistryDeleteTagsServiceTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryDeleteTagsServiceTimeout"></a>

```typescript
public resetContainerRegistryDeleteTagsServiceTimeout(): void
```

##### `resetContainerRegistryExpirationPoliciesCaching` <a name="resetContainerRegistryExpirationPoliciesCaching" id="@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryExpirationPoliciesCaching"></a>

```typescript
public resetContainerRegistryExpirationPoliciesCaching(): void
```

##### `resetContainerRegistryExpirationPoliciesWorkerCapacity` <a name="resetContainerRegistryExpirationPoliciesWorkerCapacity" id="@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryExpirationPoliciesWorkerCapacity"></a>

```typescript
public resetContainerRegistryExpirationPoliciesWorkerCapacity(): void
```

##### `resetContainerRegistryTokenExpireDelay` <a name="resetContainerRegistryTokenExpireDelay" id="@cdktf/provider-gitlab.ApplicationSettings.resetContainerRegistryTokenExpireDelay"></a>

```typescript
public resetContainerRegistryTokenExpireDelay(): void
```

##### `resetDeactivateDormantUsers` <a name="resetDeactivateDormantUsers" id="@cdktf/provider-gitlab.ApplicationSettings.resetDeactivateDormantUsers"></a>

```typescript
public resetDeactivateDormantUsers(): void
```

##### `resetDefaultArtifactsExpireIn` <a name="resetDefaultArtifactsExpireIn" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultArtifactsExpireIn"></a>

```typescript
public resetDefaultArtifactsExpireIn(): void
```

##### `resetDefaultBranchName` <a name="resetDefaultBranchName" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultBranchName"></a>

```typescript
public resetDefaultBranchName(): void
```

##### `resetDefaultBranchProtection` <a name="resetDefaultBranchProtection" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultBranchProtection"></a>

```typescript
public resetDefaultBranchProtection(): void
```

##### `resetDefaultCiConfigPath` <a name="resetDefaultCiConfigPath" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultCiConfigPath"></a>

```typescript
public resetDefaultCiConfigPath(): void
```

##### `resetDefaultGroupVisibility` <a name="resetDefaultGroupVisibility" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultGroupVisibility"></a>

```typescript
public resetDefaultGroupVisibility(): void
```

##### `resetDefaultProjectCreation` <a name="resetDefaultProjectCreation" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultProjectCreation"></a>

```typescript
public resetDefaultProjectCreation(): void
```

##### `resetDefaultProjectsLimit` <a name="resetDefaultProjectsLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultProjectsLimit"></a>

```typescript
public resetDefaultProjectsLimit(): void
```

##### `resetDefaultProjectVisibility` <a name="resetDefaultProjectVisibility" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultProjectVisibility"></a>

```typescript
public resetDefaultProjectVisibility(): void
```

##### `resetDefaultSnippetVisibility` <a name="resetDefaultSnippetVisibility" id="@cdktf/provider-gitlab.ApplicationSettings.resetDefaultSnippetVisibility"></a>

```typescript
public resetDefaultSnippetVisibility(): void
```

##### `resetDelayedGroupDeletion` <a name="resetDelayedGroupDeletion" id="@cdktf/provider-gitlab.ApplicationSettings.resetDelayedGroupDeletion"></a>

```typescript
public resetDelayedGroupDeletion(): void
```

##### `resetDelayedProjectDeletion` <a name="resetDelayedProjectDeletion" id="@cdktf/provider-gitlab.ApplicationSettings.resetDelayedProjectDeletion"></a>

```typescript
public resetDelayedProjectDeletion(): void
```

##### `resetDeleteInactiveProjects` <a name="resetDeleteInactiveProjects" id="@cdktf/provider-gitlab.ApplicationSettings.resetDeleteInactiveProjects"></a>

```typescript
public resetDeleteInactiveProjects(): void
```

##### `resetDeletionAdjournedPeriod` <a name="resetDeletionAdjournedPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetDeletionAdjournedPeriod"></a>

```typescript
public resetDeletionAdjournedPeriod(): void
```

##### `resetDiffMaxFiles` <a name="resetDiffMaxFiles" id="@cdktf/provider-gitlab.ApplicationSettings.resetDiffMaxFiles"></a>

```typescript
public resetDiffMaxFiles(): void
```

##### `resetDiffMaxLines` <a name="resetDiffMaxLines" id="@cdktf/provider-gitlab.ApplicationSettings.resetDiffMaxLines"></a>

```typescript
public resetDiffMaxLines(): void
```

##### `resetDiffMaxPatchBytes` <a name="resetDiffMaxPatchBytes" id="@cdktf/provider-gitlab.ApplicationSettings.resetDiffMaxPatchBytes"></a>

```typescript
public resetDiffMaxPatchBytes(): void
```

##### `resetDisabledOauthSignInSources` <a name="resetDisabledOauthSignInSources" id="@cdktf/provider-gitlab.ApplicationSettings.resetDisabledOauthSignInSources"></a>

```typescript
public resetDisabledOauthSignInSources(): void
```

##### `resetDisableFeedToken` <a name="resetDisableFeedToken" id="@cdktf/provider-gitlab.ApplicationSettings.resetDisableFeedToken"></a>

```typescript
public resetDisableFeedToken(): void
```

##### `resetDnsRebindingProtectionEnabled` <a name="resetDnsRebindingProtectionEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetDnsRebindingProtectionEnabled"></a>

```typescript
public resetDnsRebindingProtectionEnabled(): void
```

##### `resetDomainAllowlist` <a name="resetDomainAllowlist" id="@cdktf/provider-gitlab.ApplicationSettings.resetDomainAllowlist"></a>

```typescript
public resetDomainAllowlist(): void
```

##### `resetDomainDenylist` <a name="resetDomainDenylist" id="@cdktf/provider-gitlab.ApplicationSettings.resetDomainDenylist"></a>

```typescript
public resetDomainDenylist(): void
```

##### `resetDomainDenylistEnabled` <a name="resetDomainDenylistEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetDomainDenylistEnabled"></a>

```typescript
public resetDomainDenylistEnabled(): void
```

##### `resetDsaKeyRestriction` <a name="resetDsaKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.resetDsaKeyRestriction"></a>

```typescript
public resetDsaKeyRestriction(): void
```

##### `resetEcdsaKeyRestriction` <a name="resetEcdsaKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.resetEcdsaKeyRestriction"></a>

```typescript
public resetEcdsaKeyRestriction(): void
```

##### `resetEcdsaSkKeyRestriction` <a name="resetEcdsaSkKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.resetEcdsaSkKeyRestriction"></a>

```typescript
public resetEcdsaSkKeyRestriction(): void
```

##### `resetEd25519KeyRestriction` <a name="resetEd25519KeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.resetEd25519KeyRestriction"></a>

```typescript
public resetEd25519KeyRestriction(): void
```

##### `resetEd25519SkKeyRestriction` <a name="resetEd25519SkKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.resetEd25519SkKeyRestriction"></a>

```typescript
public resetEd25519SkKeyRestriction(): void
```

##### `resetEksAccessKeyId` <a name="resetEksAccessKeyId" id="@cdktf/provider-gitlab.ApplicationSettings.resetEksAccessKeyId"></a>

```typescript
public resetEksAccessKeyId(): void
```

##### `resetEksAccountId` <a name="resetEksAccountId" id="@cdktf/provider-gitlab.ApplicationSettings.resetEksAccountId"></a>

```typescript
public resetEksAccountId(): void
```

##### `resetEksIntegrationEnabled` <a name="resetEksIntegrationEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetEksIntegrationEnabled"></a>

```typescript
public resetEksIntegrationEnabled(): void
```

##### `resetEksSecretAccessKey` <a name="resetEksSecretAccessKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetEksSecretAccessKey"></a>

```typescript
public resetEksSecretAccessKey(): void
```

##### `resetElasticsearchAws` <a name="resetElasticsearchAws" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAws"></a>

```typescript
public resetElasticsearchAws(): void
```

##### `resetElasticsearchAwsAccessKey` <a name="resetElasticsearchAwsAccessKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAwsAccessKey"></a>

```typescript
public resetElasticsearchAwsAccessKey(): void
```

##### `resetElasticsearchAwsRegion` <a name="resetElasticsearchAwsRegion" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAwsRegion"></a>

```typescript
public resetElasticsearchAwsRegion(): void
```

##### `resetElasticsearchAwsSecretAccessKey` <a name="resetElasticsearchAwsSecretAccessKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchAwsSecretAccessKey"></a>

```typescript
public resetElasticsearchAwsSecretAccessKey(): void
```

##### `resetElasticsearchIndexedFieldLengthLimit` <a name="resetElasticsearchIndexedFieldLengthLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchIndexedFieldLengthLimit"></a>

```typescript
public resetElasticsearchIndexedFieldLengthLimit(): void
```

##### `resetElasticsearchIndexedFileSizeLimitKb` <a name="resetElasticsearchIndexedFileSizeLimitKb" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchIndexedFileSizeLimitKb"></a>

```typescript
public resetElasticsearchIndexedFileSizeLimitKb(): void
```

##### `resetElasticsearchIndexing` <a name="resetElasticsearchIndexing" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchIndexing"></a>

```typescript
public resetElasticsearchIndexing(): void
```

##### `resetElasticsearchLimitIndexing` <a name="resetElasticsearchLimitIndexing" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchLimitIndexing"></a>

```typescript
public resetElasticsearchLimitIndexing(): void
```

##### `resetElasticsearchMaxBulkConcurrency` <a name="resetElasticsearchMaxBulkConcurrency" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchMaxBulkConcurrency"></a>

```typescript
public resetElasticsearchMaxBulkConcurrency(): void
```

##### `resetElasticsearchMaxBulkSizeMb` <a name="resetElasticsearchMaxBulkSizeMb" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchMaxBulkSizeMb"></a>

```typescript
public resetElasticsearchMaxBulkSizeMb(): void
```

##### `resetElasticsearchNamespaceIds` <a name="resetElasticsearchNamespaceIds" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchNamespaceIds"></a>

```typescript
public resetElasticsearchNamespaceIds(): void
```

##### `resetElasticsearchPassword` <a name="resetElasticsearchPassword" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchPassword"></a>

```typescript
public resetElasticsearchPassword(): void
```

##### `resetElasticsearchProjectIds` <a name="resetElasticsearchProjectIds" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchProjectIds"></a>

```typescript
public resetElasticsearchProjectIds(): void
```

##### `resetElasticsearchSearch` <a name="resetElasticsearchSearch" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchSearch"></a>

```typescript
public resetElasticsearchSearch(): void
```

##### `resetElasticsearchUrl` <a name="resetElasticsearchUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchUrl"></a>

```typescript
public resetElasticsearchUrl(): void
```

##### `resetElasticsearchUsername` <a name="resetElasticsearchUsername" id="@cdktf/provider-gitlab.ApplicationSettings.resetElasticsearchUsername"></a>

```typescript
public resetElasticsearchUsername(): void
```

##### `resetEmailAdditionalText` <a name="resetEmailAdditionalText" id="@cdktf/provider-gitlab.ApplicationSettings.resetEmailAdditionalText"></a>

```typescript
public resetEmailAdditionalText(): void
```

##### `resetEmailAuthorInBody` <a name="resetEmailAuthorInBody" id="@cdktf/provider-gitlab.ApplicationSettings.resetEmailAuthorInBody"></a>

```typescript
public resetEmailAuthorInBody(): void
```

##### `resetEnabledGitAccessProtocol` <a name="resetEnabledGitAccessProtocol" id="@cdktf/provider-gitlab.ApplicationSettings.resetEnabledGitAccessProtocol"></a>

```typescript
public resetEnabledGitAccessProtocol(): void
```

##### `resetEnforceNamespaceStorageLimit` <a name="resetEnforceNamespaceStorageLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetEnforceNamespaceStorageLimit"></a>

```typescript
public resetEnforceNamespaceStorageLimit(): void
```

##### `resetEnforceTerms` <a name="resetEnforceTerms" id="@cdktf/provider-gitlab.ApplicationSettings.resetEnforceTerms"></a>

```typescript
public resetEnforceTerms(): void
```

##### `resetExternalAuthClientCert` <a name="resetExternalAuthClientCert" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthClientCert"></a>

```typescript
public resetExternalAuthClientCert(): void
```

##### `resetExternalAuthClientKey` <a name="resetExternalAuthClientKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthClientKey"></a>

```typescript
public resetExternalAuthClientKey(): void
```

##### `resetExternalAuthClientKeyPass` <a name="resetExternalAuthClientKeyPass" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthClientKeyPass"></a>

```typescript
public resetExternalAuthClientKeyPass(): void
```

##### `resetExternalAuthorizationServiceDefaultLabel` <a name="resetExternalAuthorizationServiceDefaultLabel" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceDefaultLabel"></a>

```typescript
public resetExternalAuthorizationServiceDefaultLabel(): void
```

##### `resetExternalAuthorizationServiceEnabled` <a name="resetExternalAuthorizationServiceEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceEnabled"></a>

```typescript
public resetExternalAuthorizationServiceEnabled(): void
```

##### `resetExternalAuthorizationServiceTimeout` <a name="resetExternalAuthorizationServiceTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceTimeout"></a>

```typescript
public resetExternalAuthorizationServiceTimeout(): void
```

##### `resetExternalAuthorizationServiceUrl` <a name="resetExternalAuthorizationServiceUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalAuthorizationServiceUrl"></a>

```typescript
public resetExternalAuthorizationServiceUrl(): void
```

##### `resetExternalPipelineValidationServiceTimeout` <a name="resetExternalPipelineValidationServiceTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalPipelineValidationServiceTimeout"></a>

```typescript
public resetExternalPipelineValidationServiceTimeout(): void
```

##### `resetExternalPipelineValidationServiceToken` <a name="resetExternalPipelineValidationServiceToken" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalPipelineValidationServiceToken"></a>

```typescript
public resetExternalPipelineValidationServiceToken(): void
```

##### `resetExternalPipelineValidationServiceUrl` <a name="resetExternalPipelineValidationServiceUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetExternalPipelineValidationServiceUrl"></a>

```typescript
public resetExternalPipelineValidationServiceUrl(): void
```

##### `resetFileTemplateProjectId` <a name="resetFileTemplateProjectId" id="@cdktf/provider-gitlab.ApplicationSettings.resetFileTemplateProjectId"></a>

```typescript
public resetFileTemplateProjectId(): void
```

##### `resetFirstDayOfWeek` <a name="resetFirstDayOfWeek" id="@cdktf/provider-gitlab.ApplicationSettings.resetFirstDayOfWeek"></a>

```typescript
public resetFirstDayOfWeek(): void
```

##### `resetGeoNodeAllowedIps` <a name="resetGeoNodeAllowedIps" id="@cdktf/provider-gitlab.ApplicationSettings.resetGeoNodeAllowedIps"></a>

```typescript
public resetGeoNodeAllowedIps(): void
```

##### `resetGeoStatusTimeout` <a name="resetGeoStatusTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.resetGeoStatusTimeout"></a>

```typescript
public resetGeoStatusTimeout(): void
```

##### `resetGitalyTimeoutDefault` <a name="resetGitalyTimeoutDefault" id="@cdktf/provider-gitlab.ApplicationSettings.resetGitalyTimeoutDefault"></a>

```typescript
public resetGitalyTimeoutDefault(): void
```

##### `resetGitalyTimeoutFast` <a name="resetGitalyTimeoutFast" id="@cdktf/provider-gitlab.ApplicationSettings.resetGitalyTimeoutFast"></a>

```typescript
public resetGitalyTimeoutFast(): void
```

##### `resetGitalyTimeoutMedium` <a name="resetGitalyTimeoutMedium" id="@cdktf/provider-gitlab.ApplicationSettings.resetGitalyTimeoutMedium"></a>

```typescript
public resetGitalyTimeoutMedium(): void
```

##### `resetGitRateLimitUsersAllowlist` <a name="resetGitRateLimitUsersAllowlist" id="@cdktf/provider-gitlab.ApplicationSettings.resetGitRateLimitUsersAllowlist"></a>

```typescript
public resetGitRateLimitUsersAllowlist(): void
```

##### `resetGitTwoFactorSessionExpiry` <a name="resetGitTwoFactorSessionExpiry" id="@cdktf/provider-gitlab.ApplicationSettings.resetGitTwoFactorSessionExpiry"></a>

```typescript
public resetGitTwoFactorSessionExpiry(): void
```

##### `resetGrafanaEnabled` <a name="resetGrafanaEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetGrafanaEnabled"></a>

```typescript
public resetGrafanaEnabled(): void
```

##### `resetGrafanaUrl` <a name="resetGrafanaUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetGrafanaUrl"></a>

```typescript
public resetGrafanaUrl(): void
```

##### `resetGravatarEnabled` <a name="resetGravatarEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetGravatarEnabled"></a>

```typescript
public resetGravatarEnabled(): void
```

##### `resetHashedStorageEnabled` <a name="resetHashedStorageEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetHashedStorageEnabled"></a>

```typescript
public resetHashedStorageEnabled(): void
```

##### `resetHelpPageHideCommercialContent` <a name="resetHelpPageHideCommercialContent" id="@cdktf/provider-gitlab.ApplicationSettings.resetHelpPageHideCommercialContent"></a>

```typescript
public resetHelpPageHideCommercialContent(): void
```

##### `resetHelpPageSupportUrl` <a name="resetHelpPageSupportUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetHelpPageSupportUrl"></a>

```typescript
public resetHelpPageSupportUrl(): void
```

##### `resetHelpPageText` <a name="resetHelpPageText" id="@cdktf/provider-gitlab.ApplicationSettings.resetHelpPageText"></a>

```typescript
public resetHelpPageText(): void
```

##### `resetHelpText` <a name="resetHelpText" id="@cdktf/provider-gitlab.ApplicationSettings.resetHelpText"></a>

```typescript
public resetHelpText(): void
```

##### `resetHideThirdPartyOffers` <a name="resetHideThirdPartyOffers" id="@cdktf/provider-gitlab.ApplicationSettings.resetHideThirdPartyOffers"></a>

```typescript
public resetHideThirdPartyOffers(): void
```

##### `resetHomePageUrl` <a name="resetHomePageUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetHomePageUrl"></a>

```typescript
public resetHomePageUrl(): void
```

##### `resetHousekeepingEnabled` <a name="resetHousekeepingEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingEnabled"></a>

```typescript
public resetHousekeepingEnabled(): void
```

##### `resetHousekeepingFullRepackPeriod` <a name="resetHousekeepingFullRepackPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingFullRepackPeriod"></a>

```typescript
public resetHousekeepingFullRepackPeriod(): void
```

##### `resetHousekeepingGcPeriod` <a name="resetHousekeepingGcPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingGcPeriod"></a>

```typescript
public resetHousekeepingGcPeriod(): void
```

##### `resetHousekeepingIncrementalRepackPeriod` <a name="resetHousekeepingIncrementalRepackPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetHousekeepingIncrementalRepackPeriod"></a>

```typescript
public resetHousekeepingIncrementalRepackPeriod(): void
```

##### `resetHtmlEmailsEnabled` <a name="resetHtmlEmailsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetHtmlEmailsEnabled"></a>

```typescript
public resetHtmlEmailsEnabled(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.ApplicationSettings.resetId"></a>

```typescript
public resetId(): void
```

##### `resetImportSources` <a name="resetImportSources" id="@cdktf/provider-gitlab.ApplicationSettings.resetImportSources"></a>

```typescript
public resetImportSources(): void
```

##### `resetInactiveProjectsDeleteAfterMonths` <a name="resetInactiveProjectsDeleteAfterMonths" id="@cdktf/provider-gitlab.ApplicationSettings.resetInactiveProjectsDeleteAfterMonths"></a>

```typescript
public resetInactiveProjectsDeleteAfterMonths(): void
```

##### `resetInactiveProjectsMinSizeMb` <a name="resetInactiveProjectsMinSizeMb" id="@cdktf/provider-gitlab.ApplicationSettings.resetInactiveProjectsMinSizeMb"></a>

```typescript
public resetInactiveProjectsMinSizeMb(): void
```

##### `resetInactiveProjectsSendWarningEmailAfterMonths` <a name="resetInactiveProjectsSendWarningEmailAfterMonths" id="@cdktf/provider-gitlab.ApplicationSettings.resetInactiveProjectsSendWarningEmailAfterMonths"></a>

```typescript
public resetInactiveProjectsSendWarningEmailAfterMonths(): void
```

##### `resetInProductMarketingEmailsEnabled` <a name="resetInProductMarketingEmailsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetInProductMarketingEmailsEnabled"></a>

```typescript
public resetInProductMarketingEmailsEnabled(): void
```

##### `resetInvisibleCaptchaEnabled` <a name="resetInvisibleCaptchaEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetInvisibleCaptchaEnabled"></a>

```typescript
public resetInvisibleCaptchaEnabled(): void
```

##### `resetIssuesCreateLimit` <a name="resetIssuesCreateLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetIssuesCreateLimit"></a>

```typescript
public resetIssuesCreateLimit(): void
```

##### `resetKeepLatestArtifact` <a name="resetKeepLatestArtifact" id="@cdktf/provider-gitlab.ApplicationSettings.resetKeepLatestArtifact"></a>

```typescript
public resetKeepLatestArtifact(): void
```

##### `resetLocalMarkdownVersion` <a name="resetLocalMarkdownVersion" id="@cdktf/provider-gitlab.ApplicationSettings.resetLocalMarkdownVersion"></a>

```typescript
public resetLocalMarkdownVersion(): void
```

##### `resetMailgunEventsEnabled` <a name="resetMailgunEventsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetMailgunEventsEnabled"></a>

```typescript
public resetMailgunEventsEnabled(): void
```

##### `resetMailgunSigningKey` <a name="resetMailgunSigningKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetMailgunSigningKey"></a>

```typescript
public resetMailgunSigningKey(): void
```

##### `resetMaintenanceMode` <a name="resetMaintenanceMode" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaintenanceMode"></a>

```typescript
public resetMaintenanceMode(): void
```

##### `resetMaintenanceModeMessage` <a name="resetMaintenanceModeMessage" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaintenanceModeMessage"></a>

```typescript
public resetMaintenanceModeMessage(): void
```

##### `resetMaxArtifactsSize` <a name="resetMaxArtifactsSize" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxArtifactsSize"></a>

```typescript
public resetMaxArtifactsSize(): void
```

##### `resetMaxAttachmentSize` <a name="resetMaxAttachmentSize" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxAttachmentSize"></a>

```typescript
public resetMaxAttachmentSize(): void
```

##### `resetMaxExportSize` <a name="resetMaxExportSize" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxExportSize"></a>

```typescript
public resetMaxExportSize(): void
```

##### `resetMaxImportSize` <a name="resetMaxImportSize" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxImportSize"></a>

```typescript
public resetMaxImportSize(): void
```

##### `resetMaxNumberOfRepositoryDownloads` <a name="resetMaxNumberOfRepositoryDownloads" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxNumberOfRepositoryDownloads"></a>

```typescript
public resetMaxNumberOfRepositoryDownloads(): void
```

##### `resetMaxNumberOfRepositoryDownloadsWithinTimePeriod` <a name="resetMaxNumberOfRepositoryDownloadsWithinTimePeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxNumberOfRepositoryDownloadsWithinTimePeriod"></a>

```typescript
public resetMaxNumberOfRepositoryDownloadsWithinTimePeriod(): void
```

##### `resetMaxPagesSize` <a name="resetMaxPagesSize" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxPagesSize"></a>

```typescript
public resetMaxPagesSize(): void
```

##### `resetMaxPersonalAccessTokenLifetime` <a name="resetMaxPersonalAccessTokenLifetime" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxPersonalAccessTokenLifetime"></a>

```typescript
public resetMaxPersonalAccessTokenLifetime(): void
```

##### `resetMaxSshKeyLifetime` <a name="resetMaxSshKeyLifetime" id="@cdktf/provider-gitlab.ApplicationSettings.resetMaxSshKeyLifetime"></a>

```typescript
public resetMaxSshKeyLifetime(): void
```

##### `resetMetricsMethodCallThreshold` <a name="resetMetricsMethodCallThreshold" id="@cdktf/provider-gitlab.ApplicationSettings.resetMetricsMethodCallThreshold"></a>

```typescript
public resetMetricsMethodCallThreshold(): void
```

##### `resetMirrorAvailable` <a name="resetMirrorAvailable" id="@cdktf/provider-gitlab.ApplicationSettings.resetMirrorAvailable"></a>

```typescript
public resetMirrorAvailable(): void
```

##### `resetMirrorCapacityThreshold` <a name="resetMirrorCapacityThreshold" id="@cdktf/provider-gitlab.ApplicationSettings.resetMirrorCapacityThreshold"></a>

```typescript
public resetMirrorCapacityThreshold(): void
```

##### `resetMirrorMaxCapacity` <a name="resetMirrorMaxCapacity" id="@cdktf/provider-gitlab.ApplicationSettings.resetMirrorMaxCapacity"></a>

```typescript
public resetMirrorMaxCapacity(): void
```

##### `resetMirrorMaxDelay` <a name="resetMirrorMaxDelay" id="@cdktf/provider-gitlab.ApplicationSettings.resetMirrorMaxDelay"></a>

```typescript
public resetMirrorMaxDelay(): void
```

##### `resetNpmPackageRequestsForwarding` <a name="resetNpmPackageRequestsForwarding" id="@cdktf/provider-gitlab.ApplicationSettings.resetNpmPackageRequestsForwarding"></a>

```typescript
public resetNpmPackageRequestsForwarding(): void
```

##### `resetOutboundLocalRequestsWhitelist` <a name="resetOutboundLocalRequestsWhitelist" id="@cdktf/provider-gitlab.ApplicationSettings.resetOutboundLocalRequestsWhitelist"></a>

```typescript
public resetOutboundLocalRequestsWhitelist(): void
```

##### `resetPackageRegistryCleanupPoliciesWorkerCapacity` <a name="resetPackageRegistryCleanupPoliciesWorkerCapacity" id="@cdktf/provider-gitlab.ApplicationSettings.resetPackageRegistryCleanupPoliciesWorkerCapacity"></a>

```typescript
public resetPackageRegistryCleanupPoliciesWorkerCapacity(): void
```

##### `resetPagesDomainVerificationEnabled` <a name="resetPagesDomainVerificationEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetPagesDomainVerificationEnabled"></a>

```typescript
public resetPagesDomainVerificationEnabled(): void
```

##### `resetPasswordAuthenticationEnabledForGit` <a name="resetPasswordAuthenticationEnabledForGit" id="@cdktf/provider-gitlab.ApplicationSettings.resetPasswordAuthenticationEnabledForGit"></a>

```typescript
public resetPasswordAuthenticationEnabledForGit(): void
```

##### `resetPasswordAuthenticationEnabledForWeb` <a name="resetPasswordAuthenticationEnabledForWeb" id="@cdktf/provider-gitlab.ApplicationSettings.resetPasswordAuthenticationEnabledForWeb"></a>

```typescript
public resetPasswordAuthenticationEnabledForWeb(): void
```

##### `resetPasswordLowercaseRequired` <a name="resetPasswordLowercaseRequired" id="@cdktf/provider-gitlab.ApplicationSettings.resetPasswordLowercaseRequired"></a>

```typescript
public resetPasswordLowercaseRequired(): void
```

##### `resetPasswordNumberRequired` <a name="resetPasswordNumberRequired" id="@cdktf/provider-gitlab.ApplicationSettings.resetPasswordNumberRequired"></a>

```typescript
public resetPasswordNumberRequired(): void
```

##### `resetPasswordSymbolRequired` <a name="resetPasswordSymbolRequired" id="@cdktf/provider-gitlab.ApplicationSettings.resetPasswordSymbolRequired"></a>

```typescript
public resetPasswordSymbolRequired(): void
```

##### `resetPasswordUppercaseRequired` <a name="resetPasswordUppercaseRequired" id="@cdktf/provider-gitlab.ApplicationSettings.resetPasswordUppercaseRequired"></a>

```typescript
public resetPasswordUppercaseRequired(): void
```

##### `resetPerformanceBarAllowedGroupPath` <a name="resetPerformanceBarAllowedGroupPath" id="@cdktf/provider-gitlab.ApplicationSettings.resetPerformanceBarAllowedGroupPath"></a>

```typescript
public resetPerformanceBarAllowedGroupPath(): void
```

##### `resetPersonalAccessTokenPrefix` <a name="resetPersonalAccessTokenPrefix" id="@cdktf/provider-gitlab.ApplicationSettings.resetPersonalAccessTokenPrefix"></a>

```typescript
public resetPersonalAccessTokenPrefix(): void
```

##### `resetPipelineLimitPerProjectUserSha` <a name="resetPipelineLimitPerProjectUserSha" id="@cdktf/provider-gitlab.ApplicationSettings.resetPipelineLimitPerProjectUserSha"></a>

```typescript
public resetPipelineLimitPerProjectUserSha(): void
```

##### `resetPlantumlEnabled` <a name="resetPlantumlEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetPlantumlEnabled"></a>

```typescript
public resetPlantumlEnabled(): void
```

##### `resetPlantumlUrl` <a name="resetPlantumlUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetPlantumlUrl"></a>

```typescript
public resetPlantumlUrl(): void
```

##### `resetPollingIntervalMultiplier` <a name="resetPollingIntervalMultiplier" id="@cdktf/provider-gitlab.ApplicationSettings.resetPollingIntervalMultiplier"></a>

```typescript
public resetPollingIntervalMultiplier(): void
```

##### `resetProjectExportEnabled` <a name="resetProjectExportEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetProjectExportEnabled"></a>

```typescript
public resetProjectExportEnabled(): void
```

##### `resetPrometheusMetricsEnabled` <a name="resetPrometheusMetricsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetPrometheusMetricsEnabled"></a>

```typescript
public resetPrometheusMetricsEnabled(): void
```

##### `resetProtectedCiVariables` <a name="resetProtectedCiVariables" id="@cdktf/provider-gitlab.ApplicationSettings.resetProtectedCiVariables"></a>

```typescript
public resetProtectedCiVariables(): void
```

##### `resetPushEventActivitiesLimit` <a name="resetPushEventActivitiesLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetPushEventActivitiesLimit"></a>

```typescript
public resetPushEventActivitiesLimit(): void
```

##### `resetPushEventHooksLimit` <a name="resetPushEventHooksLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetPushEventHooksLimit"></a>

```typescript
public resetPushEventHooksLimit(): void
```

##### `resetPypiPackageRequestsForwarding` <a name="resetPypiPackageRequestsForwarding" id="@cdktf/provider-gitlab.ApplicationSettings.resetPypiPackageRequestsForwarding"></a>

```typescript
public resetPypiPackageRequestsForwarding(): void
```

##### `resetRateLimitingResponseText` <a name="resetRateLimitingResponseText" id="@cdktf/provider-gitlab.ApplicationSettings.resetRateLimitingResponseText"></a>

```typescript
public resetRateLimitingResponseText(): void
```

##### `resetRawBlobRequestLimit` <a name="resetRawBlobRequestLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetRawBlobRequestLimit"></a>

```typescript
public resetRawBlobRequestLimit(): void
```

##### `resetRecaptchaEnabled` <a name="resetRecaptchaEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetRecaptchaEnabled"></a>

```typescript
public resetRecaptchaEnabled(): void
```

##### `resetRecaptchaPrivateKey` <a name="resetRecaptchaPrivateKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetRecaptchaPrivateKey"></a>

```typescript
public resetRecaptchaPrivateKey(): void
```

##### `resetRecaptchaSiteKey` <a name="resetRecaptchaSiteKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetRecaptchaSiteKey"></a>

```typescript
public resetRecaptchaSiteKey(): void
```

##### `resetReceiveMaxInputSize` <a name="resetReceiveMaxInputSize" id="@cdktf/provider-gitlab.ApplicationSettings.resetReceiveMaxInputSize"></a>

```typescript
public resetReceiveMaxInputSize(): void
```

##### `resetRepositoryChecksEnabled` <a name="resetRepositoryChecksEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetRepositoryChecksEnabled"></a>

```typescript
public resetRepositoryChecksEnabled(): void
```

##### `resetRepositorySizeLimit` <a name="resetRepositorySizeLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetRepositorySizeLimit"></a>

```typescript
public resetRepositorySizeLimit(): void
```

##### `resetRepositoryStorages` <a name="resetRepositoryStorages" id="@cdktf/provider-gitlab.ApplicationSettings.resetRepositoryStorages"></a>

```typescript
public resetRepositoryStorages(): void
```

##### `resetRepositoryStoragesWeighted` <a name="resetRepositoryStoragesWeighted" id="@cdktf/provider-gitlab.ApplicationSettings.resetRepositoryStoragesWeighted"></a>

```typescript
public resetRepositoryStoragesWeighted(): void
```

##### `resetRequireAdminApprovalAfterUserSignup` <a name="resetRequireAdminApprovalAfterUserSignup" id="@cdktf/provider-gitlab.ApplicationSettings.resetRequireAdminApprovalAfterUserSignup"></a>

```typescript
public resetRequireAdminApprovalAfterUserSignup(): void
```

##### `resetRequireTwoFactorAuthentication` <a name="resetRequireTwoFactorAuthentication" id="@cdktf/provider-gitlab.ApplicationSettings.resetRequireTwoFactorAuthentication"></a>

```typescript
public resetRequireTwoFactorAuthentication(): void
```

##### `resetRestrictedVisibilityLevels` <a name="resetRestrictedVisibilityLevels" id="@cdktf/provider-gitlab.ApplicationSettings.resetRestrictedVisibilityLevels"></a>

```typescript
public resetRestrictedVisibilityLevels(): void
```

##### `resetRsaKeyRestriction` <a name="resetRsaKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.resetRsaKeyRestriction"></a>

```typescript
public resetRsaKeyRestriction(): void
```

##### `resetSearchRateLimit` <a name="resetSearchRateLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetSearchRateLimit"></a>

```typescript
public resetSearchRateLimit(): void
```

##### `resetSearchRateLimitUnauthenticated` <a name="resetSearchRateLimitUnauthenticated" id="@cdktf/provider-gitlab.ApplicationSettings.resetSearchRateLimitUnauthenticated"></a>

```typescript
public resetSearchRateLimitUnauthenticated(): void
```

##### `resetSendUserConfirmationEmail` <a name="resetSendUserConfirmationEmail" id="@cdktf/provider-gitlab.ApplicationSettings.resetSendUserConfirmationEmail"></a>

```typescript
public resetSendUserConfirmationEmail(): void
```

##### `resetSessionExpireDelay` <a name="resetSessionExpireDelay" id="@cdktf/provider-gitlab.ApplicationSettings.resetSessionExpireDelay"></a>

```typescript
public resetSessionExpireDelay(): void
```

##### `resetSharedRunnersEnabled` <a name="resetSharedRunnersEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetSharedRunnersEnabled"></a>

```typescript
public resetSharedRunnersEnabled(): void
```

##### `resetSharedRunnersMinutes` <a name="resetSharedRunnersMinutes" id="@cdktf/provider-gitlab.ApplicationSettings.resetSharedRunnersMinutes"></a>

```typescript
public resetSharedRunnersMinutes(): void
```

##### `resetSharedRunnersText` <a name="resetSharedRunnersText" id="@cdktf/provider-gitlab.ApplicationSettings.resetSharedRunnersText"></a>

```typescript
public resetSharedRunnersText(): void
```

##### `resetSidekiqJobLimiterCompressionThresholdBytes` <a name="resetSidekiqJobLimiterCompressionThresholdBytes" id="@cdktf/provider-gitlab.ApplicationSettings.resetSidekiqJobLimiterCompressionThresholdBytes"></a>

```typescript
public resetSidekiqJobLimiterCompressionThresholdBytes(): void
```

##### `resetSidekiqJobLimiterLimitBytes` <a name="resetSidekiqJobLimiterLimitBytes" id="@cdktf/provider-gitlab.ApplicationSettings.resetSidekiqJobLimiterLimitBytes"></a>

```typescript
public resetSidekiqJobLimiterLimitBytes(): void
```

##### `resetSidekiqJobLimiterMode` <a name="resetSidekiqJobLimiterMode" id="@cdktf/provider-gitlab.ApplicationSettings.resetSidekiqJobLimiterMode"></a>

```typescript
public resetSidekiqJobLimiterMode(): void
```

##### `resetSignInText` <a name="resetSignInText" id="@cdktf/provider-gitlab.ApplicationSettings.resetSignInText"></a>

```typescript
public resetSignInText(): void
```

##### `resetSignupEnabled` <a name="resetSignupEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetSignupEnabled"></a>

```typescript
public resetSignupEnabled(): void
```

##### `resetSlackAppEnabled` <a name="resetSlackAppEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppEnabled"></a>

```typescript
public resetSlackAppEnabled(): void
```

##### `resetSlackAppId` <a name="resetSlackAppId" id="@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppId"></a>

```typescript
public resetSlackAppId(): void
```

##### `resetSlackAppSecret` <a name="resetSlackAppSecret" id="@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppSecret"></a>

```typescript
public resetSlackAppSecret(): void
```

##### `resetSlackAppSigningSecret` <a name="resetSlackAppSigningSecret" id="@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppSigningSecret"></a>

```typescript
public resetSlackAppSigningSecret(): void
```

##### `resetSlackAppVerificationToken` <a name="resetSlackAppVerificationToken" id="@cdktf/provider-gitlab.ApplicationSettings.resetSlackAppVerificationToken"></a>

```typescript
public resetSlackAppVerificationToken(): void
```

##### `resetSnippetSizeLimit` <a name="resetSnippetSizeLimit" id="@cdktf/provider-gitlab.ApplicationSettings.resetSnippetSizeLimit"></a>

```typescript
public resetSnippetSizeLimit(): void
```

##### `resetSnowplowAppId` <a name="resetSnowplowAppId" id="@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowAppId"></a>

```typescript
public resetSnowplowAppId(): void
```

##### `resetSnowplowCollectorHostname` <a name="resetSnowplowCollectorHostname" id="@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowCollectorHostname"></a>

```typescript
public resetSnowplowCollectorHostname(): void
```

##### `resetSnowplowCookieDomain` <a name="resetSnowplowCookieDomain" id="@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowCookieDomain"></a>

```typescript
public resetSnowplowCookieDomain(): void
```

##### `resetSnowplowEnabled` <a name="resetSnowplowEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetSnowplowEnabled"></a>

```typescript
public resetSnowplowEnabled(): void
```

##### `resetSourcegraphEnabled` <a name="resetSourcegraphEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetSourcegraphEnabled"></a>

```typescript
public resetSourcegraphEnabled(): void
```

##### `resetSourcegraphPublicOnly` <a name="resetSourcegraphPublicOnly" id="@cdktf/provider-gitlab.ApplicationSettings.resetSourcegraphPublicOnly"></a>

```typescript
public resetSourcegraphPublicOnly(): void
```

##### `resetSourcegraphUrl` <a name="resetSourcegraphUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetSourcegraphUrl"></a>

```typescript
public resetSourcegraphUrl(): void
```

##### `resetSpamCheckApiKey` <a name="resetSpamCheckApiKey" id="@cdktf/provider-gitlab.ApplicationSettings.resetSpamCheckApiKey"></a>

```typescript
public resetSpamCheckApiKey(): void
```

##### `resetSpamCheckEndpointEnabled` <a name="resetSpamCheckEndpointEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetSpamCheckEndpointEnabled"></a>

```typescript
public resetSpamCheckEndpointEnabled(): void
```

##### `resetSpamCheckEndpointUrl` <a name="resetSpamCheckEndpointUrl" id="@cdktf/provider-gitlab.ApplicationSettings.resetSpamCheckEndpointUrl"></a>

```typescript
public resetSpamCheckEndpointUrl(): void
```

##### `resetSuggestPipelineEnabled` <a name="resetSuggestPipelineEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetSuggestPipelineEnabled"></a>

```typescript
public resetSuggestPipelineEnabled(): void
```

##### `resetTerminalMaxSessionTime` <a name="resetTerminalMaxSessionTime" id="@cdktf/provider-gitlab.ApplicationSettings.resetTerminalMaxSessionTime"></a>

```typescript
public resetTerminalMaxSessionTime(): void
```

##### `resetTerms` <a name="resetTerms" id="@cdktf/provider-gitlab.ApplicationSettings.resetTerms"></a>

```typescript
public resetTerms(): void
```

##### `resetThrottleAuthenticatedApiEnabled` <a name="resetThrottleAuthenticatedApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedApiEnabled"></a>

```typescript
public resetThrottleAuthenticatedApiEnabled(): void
```

##### `resetThrottleAuthenticatedApiPeriodInSeconds` <a name="resetThrottleAuthenticatedApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedApiPeriodInSeconds"></a>

```typescript
public resetThrottleAuthenticatedApiPeriodInSeconds(): void
```

##### `resetThrottleAuthenticatedApiRequestsPerPeriod` <a name="resetThrottleAuthenticatedApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedApiRequestsPerPeriod"></a>

```typescript
public resetThrottleAuthenticatedApiRequestsPerPeriod(): void
```

##### `resetThrottleAuthenticatedPackagesApiEnabled` <a name="resetThrottleAuthenticatedPackagesApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedPackagesApiEnabled"></a>

```typescript
public resetThrottleAuthenticatedPackagesApiEnabled(): void
```

##### `resetThrottleAuthenticatedPackagesApiPeriodInSeconds` <a name="resetThrottleAuthenticatedPackagesApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedPackagesApiPeriodInSeconds"></a>

```typescript
public resetThrottleAuthenticatedPackagesApiPeriodInSeconds(): void
```

##### `resetThrottleAuthenticatedPackagesApiRequestsPerPeriod` <a name="resetThrottleAuthenticatedPackagesApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedPackagesApiRequestsPerPeriod"></a>

```typescript
public resetThrottleAuthenticatedPackagesApiRequestsPerPeriod(): void
```

##### `resetThrottleAuthenticatedWebEnabled` <a name="resetThrottleAuthenticatedWebEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedWebEnabled"></a>

```typescript
public resetThrottleAuthenticatedWebEnabled(): void
```

##### `resetThrottleAuthenticatedWebPeriodInSeconds` <a name="resetThrottleAuthenticatedWebPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedWebPeriodInSeconds"></a>

```typescript
public resetThrottleAuthenticatedWebPeriodInSeconds(): void
```

##### `resetThrottleAuthenticatedWebRequestsPerPeriod` <a name="resetThrottleAuthenticatedWebRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleAuthenticatedWebRequestsPerPeriod"></a>

```typescript
public resetThrottleAuthenticatedWebRequestsPerPeriod(): void
```

##### `resetThrottleUnauthenticatedApiEnabled` <a name="resetThrottleUnauthenticatedApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedApiEnabled"></a>

```typescript
public resetThrottleUnauthenticatedApiEnabled(): void
```

##### `resetThrottleUnauthenticatedApiPeriodInSeconds` <a name="resetThrottleUnauthenticatedApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedApiPeriodInSeconds"></a>

```typescript
public resetThrottleUnauthenticatedApiPeriodInSeconds(): void
```

##### `resetThrottleUnauthenticatedApiRequestsPerPeriod` <a name="resetThrottleUnauthenticatedApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedApiRequestsPerPeriod"></a>

```typescript
public resetThrottleUnauthenticatedApiRequestsPerPeriod(): void
```

##### `resetThrottleUnauthenticatedPackagesApiEnabled` <a name="resetThrottleUnauthenticatedPackagesApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedPackagesApiEnabled"></a>

```typescript
public resetThrottleUnauthenticatedPackagesApiEnabled(): void
```

##### `resetThrottleUnauthenticatedPackagesApiPeriodInSeconds` <a name="resetThrottleUnauthenticatedPackagesApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedPackagesApiPeriodInSeconds"></a>

```typescript
public resetThrottleUnauthenticatedPackagesApiPeriodInSeconds(): void
```

##### `resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod` <a name="resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod"></a>

```typescript
public resetThrottleUnauthenticatedPackagesApiRequestsPerPeriod(): void
```

##### `resetThrottleUnauthenticatedWebEnabled` <a name="resetThrottleUnauthenticatedWebEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedWebEnabled"></a>

```typescript
public resetThrottleUnauthenticatedWebEnabled(): void
```

##### `resetThrottleUnauthenticatedWebPeriodInSeconds` <a name="resetThrottleUnauthenticatedWebPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedWebPeriodInSeconds"></a>

```typescript
public resetThrottleUnauthenticatedWebPeriodInSeconds(): void
```

##### `resetThrottleUnauthenticatedWebRequestsPerPeriod` <a name="resetThrottleUnauthenticatedWebRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetThrottleUnauthenticatedWebRequestsPerPeriod"></a>

```typescript
public resetThrottleUnauthenticatedWebRequestsPerPeriod(): void
```

##### `resetTimeTrackingLimitToHours` <a name="resetTimeTrackingLimitToHours" id="@cdktf/provider-gitlab.ApplicationSettings.resetTimeTrackingLimitToHours"></a>

```typescript
public resetTimeTrackingLimitToHours(): void
```

##### `resetTwoFactorGracePeriod` <a name="resetTwoFactorGracePeriod" id="@cdktf/provider-gitlab.ApplicationSettings.resetTwoFactorGracePeriod"></a>

```typescript
public resetTwoFactorGracePeriod(): void
```

##### `resetUniqueIpsLimitEnabled` <a name="resetUniqueIpsLimitEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetUniqueIpsLimitEnabled"></a>

```typescript
public resetUniqueIpsLimitEnabled(): void
```

##### `resetUniqueIpsLimitPerUser` <a name="resetUniqueIpsLimitPerUser" id="@cdktf/provider-gitlab.ApplicationSettings.resetUniqueIpsLimitPerUser"></a>

```typescript
public resetUniqueIpsLimitPerUser(): void
```

##### `resetUniqueIpsLimitTimeWindow` <a name="resetUniqueIpsLimitTimeWindow" id="@cdktf/provider-gitlab.ApplicationSettings.resetUniqueIpsLimitTimeWindow"></a>

```typescript
public resetUniqueIpsLimitTimeWindow(): void
```

##### `resetUsagePingEnabled` <a name="resetUsagePingEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetUsagePingEnabled"></a>

```typescript
public resetUsagePingEnabled(): void
```

##### `resetUserDeactivationEmailsEnabled` <a name="resetUserDeactivationEmailsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetUserDeactivationEmailsEnabled"></a>

```typescript
public resetUserDeactivationEmailsEnabled(): void
```

##### `resetUserDefaultExternal` <a name="resetUserDefaultExternal" id="@cdktf/provider-gitlab.ApplicationSettings.resetUserDefaultExternal"></a>

```typescript
public resetUserDefaultExternal(): void
```

##### `resetUserDefaultInternalRegex` <a name="resetUserDefaultInternalRegex" id="@cdktf/provider-gitlab.ApplicationSettings.resetUserDefaultInternalRegex"></a>

```typescript
public resetUserDefaultInternalRegex(): void
```

##### `resetUserOauthApplications` <a name="resetUserOauthApplications" id="@cdktf/provider-gitlab.ApplicationSettings.resetUserOauthApplications"></a>

```typescript
public resetUserOauthApplications(): void
```

##### `resetUserShowAddSshKeyMessage` <a name="resetUserShowAddSshKeyMessage" id="@cdktf/provider-gitlab.ApplicationSettings.resetUserShowAddSshKeyMessage"></a>

```typescript
public resetUserShowAddSshKeyMessage(): void
```

##### `resetVersionCheckEnabled` <a name="resetVersionCheckEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetVersionCheckEnabled"></a>

```typescript
public resetVersionCheckEnabled(): void
```

##### `resetWebIdeClientsidePreviewEnabled` <a name="resetWebIdeClientsidePreviewEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.resetWebIdeClientsidePreviewEnabled"></a>

```typescript
public resetWebIdeClientsidePreviewEnabled(): void
```

##### `resetWhatsNewVariant` <a name="resetWhatsNewVariant" id="@cdktf/provider-gitlab.ApplicationSettings.resetWhatsNewVariant"></a>

```typescript
public resetWhatsNewVariant(): void
```

##### `resetWikiPageMaxContentBytes` <a name="resetWikiPageMaxContentBytes" id="@cdktf/provider-gitlab.ApplicationSettings.resetWikiPageMaxContentBytes"></a>

```typescript
public resetWikiPageMaxContentBytes(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.ApplicationSettings.isConstruct"></a>

```typescript
import { ApplicationSettings } from '@cdktf/provider-gitlab'

ApplicationSettings.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.ApplicationSettings.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.connection">connection</a></code> | <code>cdktf.SSHProvisionerConnection \| cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.provisioners">provisioners</a></code> | <code>cdktf.FileProvisioner \| cdktf.LocalExecProvisioner \| cdktf.RemoteExecProvisioner[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.abuseNotificationEmailInput">abuseNotificationEmailInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.adminModeInput">adminModeInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.afterSignOutPathInput">afterSignOutPathInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.afterSignUpTextInput">afterSignUpTextInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.akismetApiKeyInput">akismetApiKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.akismetEnabledInput">akismetEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.allowGroupOwnersToManageLdapInput">allowGroupOwnersToManageLdapInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromSystemHooksInput">allowLocalRequestsFromSystemHooksInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromWebHooksAndServicesInput">allowLocalRequestsFromWebHooksAndServicesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.archiveBuildsInHumanReadableInput">archiveBuildsInHumanReadableInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyAllowlistInput">assetProxyAllowlistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyEnabledInput">assetProxyEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxySecretKeyInput">assetProxySecretKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyUrlInput">assetProxyUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.authorizedKeysEnabledInput">authorizedKeysEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsDomainInput">autoDevopsDomainInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsEnabledInput">autoDevopsEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.automaticPurchasedStorageAllocationInput">automaticPurchasedStorageAllocationInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.checkNamespacePlanInput">checkNamespacePlanInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.commitEmailHostnameInput">commitEmailHostnameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerExpirationPoliciesEnableHistoricEntriesInput">containerExpirationPoliciesEnableHistoricEntriesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryCleanupTagsServiceMaxListSizeInput">containerRegistryCleanupTagsServiceMaxListSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryDeleteTagsServiceTimeoutInput">containerRegistryDeleteTagsServiceTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesCachingInput">containerRegistryExpirationPoliciesCachingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesWorkerCapacityInput">containerRegistryExpirationPoliciesWorkerCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryTokenExpireDelayInput">containerRegistryTokenExpireDelayInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.deactivateDormantUsersInput">deactivateDormantUsersInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultArtifactsExpireInInput">defaultArtifactsExpireInInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchNameInput">defaultBranchNameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchProtectionInput">defaultBranchProtectionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultCiConfigPathInput">defaultCiConfigPathInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultGroupVisibilityInput">defaultGroupVisibilityInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectCreationInput">defaultProjectCreationInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectsLimitInput">defaultProjectsLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectVisibilityInput">defaultProjectVisibilityInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultSnippetVisibilityInput">defaultSnippetVisibilityInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.delayedGroupDeletionInput">delayedGroupDeletionInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.delayedProjectDeletionInput">delayedProjectDeletionInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.deleteInactiveProjectsInput">deleteInactiveProjectsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.deletionAdjournedPeriodInput">deletionAdjournedPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxFilesInput">diffMaxFilesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxLinesInput">diffMaxLinesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxPatchBytesInput">diffMaxPatchBytesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.disabledOauthSignInSourcesInput">disabledOauthSignInSourcesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.disableFeedTokenInput">disableFeedTokenInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.dnsRebindingProtectionEnabledInput">dnsRebindingProtectionEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.domainAllowlistInput">domainAllowlistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylistEnabledInput">domainDenylistEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylistInput">domainDenylistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.dsaKeyRestrictionInput">dsaKeyRestrictionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaKeyRestrictionInput">ecdsaKeyRestrictionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaSkKeyRestrictionInput">ecdsaSkKeyRestrictionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ed25519KeyRestrictionInput">ed25519KeyRestrictionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ed25519SkKeyRestrictionInput">ed25519SkKeyRestrictionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksAccessKeyIdInput">eksAccessKeyIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksAccountIdInput">eksAccountIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksIntegrationEnabledInput">eksIntegrationEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksSecretAccessKeyInput">eksSecretAccessKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsAccessKeyInput">elasticsearchAwsAccessKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsInput">elasticsearchAwsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsRegionInput">elasticsearchAwsRegionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsSecretAccessKeyInput">elasticsearchAwsSecretAccessKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFieldLengthLimitInput">elasticsearchIndexedFieldLengthLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFileSizeLimitKbInput">elasticsearchIndexedFileSizeLimitKbInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexingInput">elasticsearchIndexingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchLimitIndexingInput">elasticsearchLimitIndexingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkConcurrencyInput">elasticsearchMaxBulkConcurrencyInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkSizeMbInput">elasticsearchMaxBulkSizeMbInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchNamespaceIdsInput">elasticsearchNamespaceIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchPasswordInput">elasticsearchPasswordInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchProjectIdsInput">elasticsearchProjectIdsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchSearchInput">elasticsearchSearchInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUrlInput">elasticsearchUrlInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUsernameInput">elasticsearchUsernameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.emailAdditionalTextInput">emailAdditionalTextInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.emailAuthorInBodyInput">emailAuthorInBodyInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.enabledGitAccessProtocolInput">enabledGitAccessProtocolInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.enforceNamespaceStorageLimitInput">enforceNamespaceStorageLimitInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.enforceTermsInput">enforceTermsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientCertInput">externalAuthClientCertInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKeyInput">externalAuthClientKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKeyPassInput">externalAuthClientKeyPassInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceDefaultLabelInput">externalAuthorizationServiceDefaultLabelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceEnabledInput">externalAuthorizationServiceEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceTimeoutInput">externalAuthorizationServiceTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceUrlInput">externalAuthorizationServiceUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceTimeoutInput">externalPipelineValidationServiceTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceTokenInput">externalPipelineValidationServiceTokenInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceUrlInput">externalPipelineValidationServiceUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.fileTemplateProjectIdInput">fileTemplateProjectIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.firstDayOfWeekInput">firstDayOfWeekInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.geoNodeAllowedIpsInput">geoNodeAllowedIpsInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.geoStatusTimeoutInput">geoStatusTimeoutInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutDefaultInput">gitalyTimeoutDefaultInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutFastInput">gitalyTimeoutFastInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutMediumInput">gitalyTimeoutMediumInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitRateLimitUsersAllowlistInput">gitRateLimitUsersAllowlistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitTwoFactorSessionExpiryInput">gitTwoFactorSessionExpiryInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.grafanaEnabledInput">grafanaEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.grafanaUrlInput">grafanaUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gravatarEnabledInput">gravatarEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.hashedStorageEnabledInput">hashedStorageEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpPageHideCommercialContentInput">helpPageHideCommercialContentInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpPageSupportUrlInput">helpPageSupportUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpPageTextInput">helpPageTextInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpTextInput">helpTextInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.hideThirdPartyOffersInput">hideThirdPartyOffersInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.homePageUrlInput">homePageUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingEnabledInput">housekeepingEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingFullRepackPeriodInput">housekeepingFullRepackPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingGcPeriodInput">housekeepingGcPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingIncrementalRepackPeriodInput">housekeepingIncrementalRepackPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.htmlEmailsEnabledInput">htmlEmailsEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.importSourcesInput">importSourcesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsDeleteAfterMonthsInput">inactiveProjectsDeleteAfterMonthsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsMinSizeMbInput">inactiveProjectsMinSizeMbInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsSendWarningEmailAfterMonthsInput">inactiveProjectsSendWarningEmailAfterMonthsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inProductMarketingEmailsEnabledInput">inProductMarketingEmailsEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.invisibleCaptchaEnabledInput">invisibleCaptchaEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.issuesCreateLimitInput">issuesCreateLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.keepLatestArtifactInput">keepLatestArtifactInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.localMarkdownVersionInput">localMarkdownVersionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mailgunEventsEnabledInput">mailgunEventsEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mailgunSigningKeyInput">mailgunSigningKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceModeInput">maintenanceModeInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceModeMessageInput">maintenanceModeMessageInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxArtifactsSizeInput">maxArtifactsSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxAttachmentSizeInput">maxAttachmentSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxExportSizeInput">maxExportSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxImportSizeInput">maxImportSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloadsInput">maxNumberOfRepositoryDownloadsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloadsWithinTimePeriodInput">maxNumberOfRepositoryDownloadsWithinTimePeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxPagesSizeInput">maxPagesSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxPersonalAccessTokenLifetimeInput">maxPersonalAccessTokenLifetimeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxSshKeyLifetimeInput">maxSshKeyLifetimeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.metricsMethodCallThresholdInput">metricsMethodCallThresholdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorAvailableInput">mirrorAvailableInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorCapacityThresholdInput">mirrorCapacityThresholdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxCapacityInput">mirrorMaxCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxDelayInput">mirrorMaxDelayInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.npmPackageRequestsForwardingInput">npmPackageRequestsForwardingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.outboundLocalRequestsWhitelistInput">outboundLocalRequestsWhitelistInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.packageRegistryCleanupPoliciesWorkerCapacityInput">packageRegistryCleanupPoliciesWorkerCapacityInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pagesDomainVerificationEnabledInput">pagesDomainVerificationEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForGitInput">passwordAuthenticationEnabledForGitInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForWebInput">passwordAuthenticationEnabledForWebInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordLowercaseRequiredInput">passwordLowercaseRequiredInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordNumberRequiredInput">passwordNumberRequiredInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordSymbolRequiredInput">passwordSymbolRequiredInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordUppercaseRequiredInput">passwordUppercaseRequiredInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.performanceBarAllowedGroupPathInput">performanceBarAllowedGroupPathInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.personalAccessTokenPrefixInput">personalAccessTokenPrefixInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pipelineLimitPerProjectUserShaInput">pipelineLimitPerProjectUserShaInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.plantumlEnabledInput">plantumlEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.plantumlUrlInput">plantumlUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pollingIntervalMultiplierInput">pollingIntervalMultiplierInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.projectExportEnabledInput">projectExportEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.prometheusMetricsEnabledInput">prometheusMetricsEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.protectedCiVariablesInput">protectedCiVariablesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pushEventActivitiesLimitInput">pushEventActivitiesLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pushEventHooksLimitInput">pushEventHooksLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pypiPackageRequestsForwardingInput">pypiPackageRequestsForwardingInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.rateLimitingResponseTextInput">rateLimitingResponseTextInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.rawBlobRequestLimitInput">rawBlobRequestLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaEnabledInput">recaptchaEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaPrivateKeyInput">recaptchaPrivateKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaSiteKeyInput">recaptchaSiteKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.receiveMaxInputSizeInput">receiveMaxInputSizeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositoryChecksEnabledInput">repositoryChecksEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositorySizeLimitInput">repositorySizeLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStoragesInput">repositoryStoragesInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStoragesWeightedInput">repositoryStoragesWeightedInput</a></code> | <code>{[ key: string ]: number}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.requireAdminApprovalAfterUserSignupInput">requireAdminApprovalAfterUserSignupInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.requireTwoFactorAuthenticationInput">requireTwoFactorAuthenticationInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.restrictedVisibilityLevelsInput">restrictedVisibilityLevelsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.rsaKeyRestrictionInput">rsaKeyRestrictionInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimitInput">searchRateLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimitUnauthenticatedInput">searchRateLimitUnauthenticatedInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sendUserConfirmationEmailInput">sendUserConfirmationEmailInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sessionExpireDelayInput">sessionExpireDelayInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersEnabledInput">sharedRunnersEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersMinutesInput">sharedRunnersMinutesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersTextInput">sharedRunnersTextInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterCompressionThresholdBytesInput">sidekiqJobLimiterCompressionThresholdBytesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterLimitBytesInput">sidekiqJobLimiterLimitBytesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterModeInput">sidekiqJobLimiterModeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.signInTextInput">signInTextInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.signupEnabledInput">signupEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppEnabledInput">slackAppEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppIdInput">slackAppIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSecretInput">slackAppSecretInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSigningSecretInput">slackAppSigningSecretInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppVerificationTokenInput">slackAppVerificationTokenInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snippetSizeLimitInput">snippetSizeLimitInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowAppIdInput">snowplowAppIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCollectorHostnameInput">snowplowCollectorHostnameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCookieDomainInput">snowplowCookieDomainInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowEnabledInput">snowplowEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphEnabledInput">sourcegraphEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphPublicOnlyInput">sourcegraphPublicOnlyInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphUrlInput">sourcegraphUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckApiKeyInput">spamCheckApiKeyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointEnabledInput">spamCheckEndpointEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointUrlInput">spamCheckEndpointUrlInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.suggestPipelineEnabledInput">suggestPipelineEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.terminalMaxSessionTimeInput">terminalMaxSessionTimeInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.termsInput">termsInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiEnabledInput">throttleAuthenticatedApiEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiPeriodInSecondsInput">throttleAuthenticatedApiPeriodInSecondsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiRequestsPerPeriodInput">throttleAuthenticatedApiRequestsPerPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiEnabledInput">throttleAuthenticatedPackagesApiEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiPeriodInSecondsInput">throttleAuthenticatedPackagesApiPeriodInSecondsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiRequestsPerPeriodInput">throttleAuthenticatedPackagesApiRequestsPerPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebEnabledInput">throttleAuthenticatedWebEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebPeriodInSecondsInput">throttleAuthenticatedWebPeriodInSecondsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebRequestsPerPeriodInput">throttleAuthenticatedWebRequestsPerPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiEnabledInput">throttleUnauthenticatedApiEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiPeriodInSecondsInput">throttleUnauthenticatedApiPeriodInSecondsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiRequestsPerPeriodInput">throttleUnauthenticatedApiRequestsPerPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiEnabledInput">throttleUnauthenticatedPackagesApiEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiPeriodInSecondsInput">throttleUnauthenticatedPackagesApiPeriodInSecondsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiRequestsPerPeriodInput">throttleUnauthenticatedPackagesApiRequestsPerPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebEnabledInput">throttleUnauthenticatedWebEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebPeriodInSecondsInput">throttleUnauthenticatedWebPeriodInSecondsInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebRequestsPerPeriodInput">throttleUnauthenticatedWebRequestsPerPeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.timeTrackingLimitToHoursInput">timeTrackingLimitToHoursInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.twoFactorGracePeriodInput">twoFactorGracePeriodInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitEnabledInput">uniqueIpsLimitEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitPerUserInput">uniqueIpsLimitPerUserInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitTimeWindowInput">uniqueIpsLimitTimeWindowInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.usagePingEnabledInput">usagePingEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userDeactivationEmailsEnabledInput">userDeactivationEmailsEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultExternalInput">userDefaultExternalInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultInternalRegexInput">userDefaultInternalRegexInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userOauthApplicationsInput">userOauthApplicationsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userShowAddSshKeyMessageInput">userShowAddSshKeyMessageInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.versionCheckEnabledInput">versionCheckEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.webIdeClientsidePreviewEnabledInput">webIdeClientsidePreviewEnabledInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.whatsNewVariantInput">whatsNewVariantInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.wikiPageMaxContentBytesInput">wikiPageMaxContentBytesInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.abuseNotificationEmail">abuseNotificationEmail</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.adminMode">adminMode</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.afterSignOutPath">afterSignOutPath</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.afterSignUpText">afterSignUpText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.akismetApiKey">akismetApiKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.akismetEnabled">akismetEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.allowGroupOwnersToManageLdap">allowGroupOwnersToManageLdap</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromSystemHooks">allowLocalRequestsFromSystemHooks</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromWebHooksAndServices">allowLocalRequestsFromWebHooksAndServices</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.archiveBuildsInHumanReadable">archiveBuildsInHumanReadable</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyAllowlist">assetProxyAllowlist</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyEnabled">assetProxyEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxySecretKey">assetProxySecretKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyUrl">assetProxyUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.authorizedKeysEnabled">authorizedKeysEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsDomain">autoDevopsDomain</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsEnabled">autoDevopsEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.automaticPurchasedStorageAllocation">automaticPurchasedStorageAllocation</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.checkNamespacePlan">checkNamespacePlan</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.commitEmailHostname">commitEmailHostname</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerExpirationPoliciesEnableHistoricEntries">containerExpirationPoliciesEnableHistoricEntries</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryCleanupTagsServiceMaxListSize">containerRegistryCleanupTagsServiceMaxListSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryDeleteTagsServiceTimeout">containerRegistryDeleteTagsServiceTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesCaching">containerRegistryExpirationPoliciesCaching</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesWorkerCapacity">containerRegistryExpirationPoliciesWorkerCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryTokenExpireDelay">containerRegistryTokenExpireDelay</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.deactivateDormantUsers">deactivateDormantUsers</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultArtifactsExpireIn">defaultArtifactsExpireIn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchName">defaultBranchName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchProtection">defaultBranchProtection</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultCiConfigPath">defaultCiConfigPath</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultGroupVisibility">defaultGroupVisibility</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectCreation">defaultProjectCreation</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectsLimit">defaultProjectsLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectVisibility">defaultProjectVisibility</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.defaultSnippetVisibility">defaultSnippetVisibility</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.delayedGroupDeletion">delayedGroupDeletion</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.delayedProjectDeletion">delayedProjectDeletion</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.deleteInactiveProjects">deleteInactiveProjects</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.deletionAdjournedPeriod">deletionAdjournedPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxFiles">diffMaxFiles</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxLines">diffMaxLines</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxPatchBytes">diffMaxPatchBytes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.disabledOauthSignInSources">disabledOauthSignInSources</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.disableFeedToken">disableFeedToken</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.dnsRebindingProtectionEnabled">dnsRebindingProtectionEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.domainAllowlist">domainAllowlist</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylist">domainDenylist</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylistEnabled">domainDenylistEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.dsaKeyRestriction">dsaKeyRestriction</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaKeyRestriction">ecdsaKeyRestriction</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaSkKeyRestriction">ecdsaSkKeyRestriction</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ed25519KeyRestriction">ed25519KeyRestriction</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.ed25519SkKeyRestriction">ed25519SkKeyRestriction</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksAccessKeyId">eksAccessKeyId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksAccountId">eksAccountId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksIntegrationEnabled">eksIntegrationEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.eksSecretAccessKey">eksSecretAccessKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAws">elasticsearchAws</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsAccessKey">elasticsearchAwsAccessKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsRegion">elasticsearchAwsRegion</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsSecretAccessKey">elasticsearchAwsSecretAccessKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFieldLengthLimit">elasticsearchIndexedFieldLengthLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFileSizeLimitKb">elasticsearchIndexedFileSizeLimitKb</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexing">elasticsearchIndexing</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchLimitIndexing">elasticsearchLimitIndexing</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkConcurrency">elasticsearchMaxBulkConcurrency</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkSizeMb">elasticsearchMaxBulkSizeMb</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchNamespaceIds">elasticsearchNamespaceIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchPassword">elasticsearchPassword</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchProjectIds">elasticsearchProjectIds</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchSearch">elasticsearchSearch</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUrl">elasticsearchUrl</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUsername">elasticsearchUsername</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.emailAdditionalText">emailAdditionalText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.emailAuthorInBody">emailAuthorInBody</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.enabledGitAccessProtocol">enabledGitAccessProtocol</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.enforceNamespaceStorageLimit">enforceNamespaceStorageLimit</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.enforceTerms">enforceTerms</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientCert">externalAuthClientCert</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKey">externalAuthClientKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKeyPass">externalAuthClientKeyPass</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceDefaultLabel">externalAuthorizationServiceDefaultLabel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceEnabled">externalAuthorizationServiceEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceTimeout">externalAuthorizationServiceTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceUrl">externalAuthorizationServiceUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceTimeout">externalPipelineValidationServiceTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceToken">externalPipelineValidationServiceToken</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceUrl">externalPipelineValidationServiceUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.fileTemplateProjectId">fileTemplateProjectId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.firstDayOfWeek">firstDayOfWeek</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.geoNodeAllowedIps">geoNodeAllowedIps</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.geoStatusTimeout">geoStatusTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutDefault">gitalyTimeoutDefault</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutFast">gitalyTimeoutFast</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutMedium">gitalyTimeoutMedium</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitRateLimitUsersAllowlist">gitRateLimitUsersAllowlist</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gitTwoFactorSessionExpiry">gitTwoFactorSessionExpiry</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.grafanaEnabled">grafanaEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.grafanaUrl">grafanaUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.gravatarEnabled">gravatarEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.hashedStorageEnabled">hashedStorageEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpPageHideCommercialContent">helpPageHideCommercialContent</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpPageSupportUrl">helpPageSupportUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpPageText">helpPageText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.helpText">helpText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.hideThirdPartyOffers">hideThirdPartyOffers</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.homePageUrl">homePageUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingEnabled">housekeepingEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingFullRepackPeriod">housekeepingFullRepackPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingGcPeriod">housekeepingGcPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingIncrementalRepackPeriod">housekeepingIncrementalRepackPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.htmlEmailsEnabled">htmlEmailsEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.importSources">importSources</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsDeleteAfterMonths">inactiveProjectsDeleteAfterMonths</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsMinSizeMb">inactiveProjectsMinSizeMb</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsSendWarningEmailAfterMonths">inactiveProjectsSendWarningEmailAfterMonths</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.inProductMarketingEmailsEnabled">inProductMarketingEmailsEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.invisibleCaptchaEnabled">invisibleCaptchaEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.issuesCreateLimit">issuesCreateLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.keepLatestArtifact">keepLatestArtifact</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.localMarkdownVersion">localMarkdownVersion</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mailgunEventsEnabled">mailgunEventsEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mailgunSigningKey">mailgunSigningKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceMode">maintenanceMode</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceModeMessage">maintenanceModeMessage</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxArtifactsSize">maxArtifactsSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxAttachmentSize">maxAttachmentSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxExportSize">maxExportSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxImportSize">maxImportSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloads">maxNumberOfRepositoryDownloads</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloadsWithinTimePeriod">maxNumberOfRepositoryDownloadsWithinTimePeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxPagesSize">maxPagesSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxPersonalAccessTokenLifetime">maxPersonalAccessTokenLifetime</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.maxSshKeyLifetime">maxSshKeyLifetime</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.metricsMethodCallThreshold">metricsMethodCallThreshold</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorAvailable">mirrorAvailable</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorCapacityThreshold">mirrorCapacityThreshold</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxCapacity">mirrorMaxCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxDelay">mirrorMaxDelay</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.npmPackageRequestsForwarding">npmPackageRequestsForwarding</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.outboundLocalRequestsWhitelist">outboundLocalRequestsWhitelist</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.packageRegistryCleanupPoliciesWorkerCapacity">packageRegistryCleanupPoliciesWorkerCapacity</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pagesDomainVerificationEnabled">pagesDomainVerificationEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForGit">passwordAuthenticationEnabledForGit</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForWeb">passwordAuthenticationEnabledForWeb</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordLowercaseRequired">passwordLowercaseRequired</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordNumberRequired">passwordNumberRequired</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordSymbolRequired">passwordSymbolRequired</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.passwordUppercaseRequired">passwordUppercaseRequired</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.performanceBarAllowedGroupPath">performanceBarAllowedGroupPath</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.personalAccessTokenPrefix">personalAccessTokenPrefix</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pipelineLimitPerProjectUserSha">pipelineLimitPerProjectUserSha</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.plantumlEnabled">plantumlEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.plantumlUrl">plantumlUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pollingIntervalMultiplier">pollingIntervalMultiplier</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.projectExportEnabled">projectExportEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.prometheusMetricsEnabled">prometheusMetricsEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.protectedCiVariables">protectedCiVariables</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pushEventActivitiesLimit">pushEventActivitiesLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pushEventHooksLimit">pushEventHooksLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.pypiPackageRequestsForwarding">pypiPackageRequestsForwarding</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.rateLimitingResponseText">rateLimitingResponseText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.rawBlobRequestLimit">rawBlobRequestLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaEnabled">recaptchaEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaPrivateKey">recaptchaPrivateKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaSiteKey">recaptchaSiteKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.receiveMaxInputSize">receiveMaxInputSize</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositoryChecksEnabled">repositoryChecksEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositorySizeLimit">repositorySizeLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStorages">repositoryStorages</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStoragesWeighted">repositoryStoragesWeighted</a></code> | <code>{[ key: string ]: number}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.requireAdminApprovalAfterUserSignup">requireAdminApprovalAfterUserSignup</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.requireTwoFactorAuthentication">requireTwoFactorAuthentication</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.restrictedVisibilityLevels">restrictedVisibilityLevels</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.rsaKeyRestriction">rsaKeyRestriction</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimit">searchRateLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimitUnauthenticated">searchRateLimitUnauthenticated</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sendUserConfirmationEmail">sendUserConfirmationEmail</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sessionExpireDelay">sessionExpireDelay</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersEnabled">sharedRunnersEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersMinutes">sharedRunnersMinutes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersText">sharedRunnersText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterCompressionThresholdBytes">sidekiqJobLimiterCompressionThresholdBytes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterLimitBytes">sidekiqJobLimiterLimitBytes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterMode">sidekiqJobLimiterMode</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.signInText">signInText</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.signupEnabled">signupEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppEnabled">slackAppEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppId">slackAppId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSecret">slackAppSecret</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSigningSecret">slackAppSigningSecret</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.slackAppVerificationToken">slackAppVerificationToken</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snippetSizeLimit">snippetSizeLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowAppId">snowplowAppId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCollectorHostname">snowplowCollectorHostname</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCookieDomain">snowplowCookieDomain</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.snowplowEnabled">snowplowEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphEnabled">sourcegraphEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphPublicOnly">sourcegraphPublicOnly</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphUrl">sourcegraphUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckApiKey">spamCheckApiKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointEnabled">spamCheckEndpointEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointUrl">spamCheckEndpointUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.suggestPipelineEnabled">suggestPipelineEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.terminalMaxSessionTime">terminalMaxSessionTime</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.terms">terms</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiEnabled">throttleAuthenticatedApiEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiPeriodInSeconds">throttleAuthenticatedApiPeriodInSeconds</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiRequestsPerPeriod">throttleAuthenticatedApiRequestsPerPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiEnabled">throttleAuthenticatedPackagesApiEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiPeriodInSeconds">throttleAuthenticatedPackagesApiPeriodInSeconds</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiRequestsPerPeriod">throttleAuthenticatedPackagesApiRequestsPerPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebEnabled">throttleAuthenticatedWebEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebPeriodInSeconds">throttleAuthenticatedWebPeriodInSeconds</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebRequestsPerPeriod">throttleAuthenticatedWebRequestsPerPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiEnabled">throttleUnauthenticatedApiEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiPeriodInSeconds">throttleUnauthenticatedApiPeriodInSeconds</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiRequestsPerPeriod">throttleUnauthenticatedApiRequestsPerPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiEnabled">throttleUnauthenticatedPackagesApiEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiPeriodInSeconds">throttleUnauthenticatedPackagesApiPeriodInSeconds</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiRequestsPerPeriod">throttleUnauthenticatedPackagesApiRequestsPerPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebEnabled">throttleUnauthenticatedWebEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebPeriodInSeconds">throttleUnauthenticatedWebPeriodInSeconds</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebRequestsPerPeriod">throttleUnauthenticatedWebRequestsPerPeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.timeTrackingLimitToHours">timeTrackingLimitToHours</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.twoFactorGracePeriod">twoFactorGracePeriod</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitEnabled">uniqueIpsLimitEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitPerUser">uniqueIpsLimitPerUser</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitTimeWindow">uniqueIpsLimitTimeWindow</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.usagePingEnabled">usagePingEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userDeactivationEmailsEnabled">userDeactivationEmailsEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultExternal">userDefaultExternal</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultInternalRegex">userDefaultInternalRegex</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userOauthApplications">userOauthApplications</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.userShowAddSshKeyMessage">userShowAddSshKeyMessage</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.versionCheckEnabled">versionCheckEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.webIdeClientsidePreviewEnabled">webIdeClientsidePreviewEnabled</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.whatsNewVariant">whatsNewVariant</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.wikiPageMaxContentBytes">wikiPageMaxContentBytes</a></code> | <code>number</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.ApplicationSettings.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.ApplicationSettings.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.ApplicationSettings.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.ApplicationSettings.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.ApplicationSettings.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.ApplicationSettings.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.ApplicationSettings.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-gitlab.ApplicationSettings.property.connection"></a>

```typescript
public readonly connection: SSHProvisionerConnection | WinrmProvisionerConnection;
```

- *Type:* cdktf.SSHProvisionerConnection | cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.ApplicationSettings.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.ApplicationSettings.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.ApplicationSettings.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.ApplicationSettings.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.ApplicationSettings.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-gitlab.ApplicationSettings.property.provisioners"></a>

```typescript
public readonly provisioners: FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner[];
```

- *Type:* cdktf.FileProvisioner | cdktf.LocalExecProvisioner | cdktf.RemoteExecProvisioner[]

---

##### `abuseNotificationEmailInput`<sup>Optional</sup> <a name="abuseNotificationEmailInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.abuseNotificationEmailInput"></a>

```typescript
public readonly abuseNotificationEmailInput: string;
```

- *Type:* string

---

##### `adminModeInput`<sup>Optional</sup> <a name="adminModeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.adminModeInput"></a>

```typescript
public readonly adminModeInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `afterSignOutPathInput`<sup>Optional</sup> <a name="afterSignOutPathInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.afterSignOutPathInput"></a>

```typescript
public readonly afterSignOutPathInput: string;
```

- *Type:* string

---

##### `afterSignUpTextInput`<sup>Optional</sup> <a name="afterSignUpTextInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.afterSignUpTextInput"></a>

```typescript
public readonly afterSignUpTextInput: string;
```

- *Type:* string

---

##### `akismetApiKeyInput`<sup>Optional</sup> <a name="akismetApiKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.akismetApiKeyInput"></a>

```typescript
public readonly akismetApiKeyInput: string;
```

- *Type:* string

---

##### `akismetEnabledInput`<sup>Optional</sup> <a name="akismetEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.akismetEnabledInput"></a>

```typescript
public readonly akismetEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `allowGroupOwnersToManageLdapInput`<sup>Optional</sup> <a name="allowGroupOwnersToManageLdapInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.allowGroupOwnersToManageLdapInput"></a>

```typescript
public readonly allowGroupOwnersToManageLdapInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `allowLocalRequestsFromSystemHooksInput`<sup>Optional</sup> <a name="allowLocalRequestsFromSystemHooksInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromSystemHooksInput"></a>

```typescript
public readonly allowLocalRequestsFromSystemHooksInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `allowLocalRequestsFromWebHooksAndServicesInput`<sup>Optional</sup> <a name="allowLocalRequestsFromWebHooksAndServicesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromWebHooksAndServicesInput"></a>

```typescript
public readonly allowLocalRequestsFromWebHooksAndServicesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `archiveBuildsInHumanReadableInput`<sup>Optional</sup> <a name="archiveBuildsInHumanReadableInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.archiveBuildsInHumanReadableInput"></a>

```typescript
public readonly archiveBuildsInHumanReadableInput: string;
```

- *Type:* string

---

##### `assetProxyAllowlistInput`<sup>Optional</sup> <a name="assetProxyAllowlistInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyAllowlistInput"></a>

```typescript
public readonly assetProxyAllowlistInput: string[];
```

- *Type:* string[]

---

##### `assetProxyEnabledInput`<sup>Optional</sup> <a name="assetProxyEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyEnabledInput"></a>

```typescript
public readonly assetProxyEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `assetProxySecretKeyInput`<sup>Optional</sup> <a name="assetProxySecretKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxySecretKeyInput"></a>

```typescript
public readonly assetProxySecretKeyInput: string;
```

- *Type:* string

---

##### `assetProxyUrlInput`<sup>Optional</sup> <a name="assetProxyUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyUrlInput"></a>

```typescript
public readonly assetProxyUrlInput: string;
```

- *Type:* string

---

##### `authorizedKeysEnabledInput`<sup>Optional</sup> <a name="authorizedKeysEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.authorizedKeysEnabledInput"></a>

```typescript
public readonly authorizedKeysEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `autoDevopsDomainInput`<sup>Optional</sup> <a name="autoDevopsDomainInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsDomainInput"></a>

```typescript
public readonly autoDevopsDomainInput: string;
```

- *Type:* string

---

##### `autoDevopsEnabledInput`<sup>Optional</sup> <a name="autoDevopsEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsEnabledInput"></a>

```typescript
public readonly autoDevopsEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `automaticPurchasedStorageAllocationInput`<sup>Optional</sup> <a name="automaticPurchasedStorageAllocationInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.automaticPurchasedStorageAllocationInput"></a>

```typescript
public readonly automaticPurchasedStorageAllocationInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `checkNamespacePlanInput`<sup>Optional</sup> <a name="checkNamespacePlanInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.checkNamespacePlanInput"></a>

```typescript
public readonly checkNamespacePlanInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `commitEmailHostnameInput`<sup>Optional</sup> <a name="commitEmailHostnameInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.commitEmailHostnameInput"></a>

```typescript
public readonly commitEmailHostnameInput: string;
```

- *Type:* string

---

##### `containerExpirationPoliciesEnableHistoricEntriesInput`<sup>Optional</sup> <a name="containerExpirationPoliciesEnableHistoricEntriesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerExpirationPoliciesEnableHistoricEntriesInput"></a>

```typescript
public readonly containerExpirationPoliciesEnableHistoricEntriesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `containerRegistryCleanupTagsServiceMaxListSizeInput`<sup>Optional</sup> <a name="containerRegistryCleanupTagsServiceMaxListSizeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryCleanupTagsServiceMaxListSizeInput"></a>

```typescript
public readonly containerRegistryCleanupTagsServiceMaxListSizeInput: number;
```

- *Type:* number

---

##### `containerRegistryDeleteTagsServiceTimeoutInput`<sup>Optional</sup> <a name="containerRegistryDeleteTagsServiceTimeoutInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryDeleteTagsServiceTimeoutInput"></a>

```typescript
public readonly containerRegistryDeleteTagsServiceTimeoutInput: number;
```

- *Type:* number

---

##### `containerRegistryExpirationPoliciesCachingInput`<sup>Optional</sup> <a name="containerRegistryExpirationPoliciesCachingInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesCachingInput"></a>

```typescript
public readonly containerRegistryExpirationPoliciesCachingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `containerRegistryExpirationPoliciesWorkerCapacityInput`<sup>Optional</sup> <a name="containerRegistryExpirationPoliciesWorkerCapacityInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesWorkerCapacityInput"></a>

```typescript
public readonly containerRegistryExpirationPoliciesWorkerCapacityInput: number;
```

- *Type:* number

---

##### `containerRegistryTokenExpireDelayInput`<sup>Optional</sup> <a name="containerRegistryTokenExpireDelayInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryTokenExpireDelayInput"></a>

```typescript
public readonly containerRegistryTokenExpireDelayInput: number;
```

- *Type:* number

---

##### `deactivateDormantUsersInput`<sup>Optional</sup> <a name="deactivateDormantUsersInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.deactivateDormantUsersInput"></a>

```typescript
public readonly deactivateDormantUsersInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `defaultArtifactsExpireInInput`<sup>Optional</sup> <a name="defaultArtifactsExpireInInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultArtifactsExpireInInput"></a>

```typescript
public readonly defaultArtifactsExpireInInput: string;
```

- *Type:* string

---

##### `defaultBranchNameInput`<sup>Optional</sup> <a name="defaultBranchNameInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchNameInput"></a>

```typescript
public readonly defaultBranchNameInput: string;
```

- *Type:* string

---

##### `defaultBranchProtectionInput`<sup>Optional</sup> <a name="defaultBranchProtectionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchProtectionInput"></a>

```typescript
public readonly defaultBranchProtectionInput: number;
```

- *Type:* number

---

##### `defaultCiConfigPathInput`<sup>Optional</sup> <a name="defaultCiConfigPathInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultCiConfigPathInput"></a>

```typescript
public readonly defaultCiConfigPathInput: string;
```

- *Type:* string

---

##### `defaultGroupVisibilityInput`<sup>Optional</sup> <a name="defaultGroupVisibilityInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultGroupVisibilityInput"></a>

```typescript
public readonly defaultGroupVisibilityInput: string;
```

- *Type:* string

---

##### `defaultProjectCreationInput`<sup>Optional</sup> <a name="defaultProjectCreationInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectCreationInput"></a>

```typescript
public readonly defaultProjectCreationInput: number;
```

- *Type:* number

---

##### `defaultProjectsLimitInput`<sup>Optional</sup> <a name="defaultProjectsLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectsLimitInput"></a>

```typescript
public readonly defaultProjectsLimitInput: number;
```

- *Type:* number

---

##### `defaultProjectVisibilityInput`<sup>Optional</sup> <a name="defaultProjectVisibilityInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectVisibilityInput"></a>

```typescript
public readonly defaultProjectVisibilityInput: string;
```

- *Type:* string

---

##### `defaultSnippetVisibilityInput`<sup>Optional</sup> <a name="defaultSnippetVisibilityInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultSnippetVisibilityInput"></a>

```typescript
public readonly defaultSnippetVisibilityInput: string;
```

- *Type:* string

---

##### `delayedGroupDeletionInput`<sup>Optional</sup> <a name="delayedGroupDeletionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.delayedGroupDeletionInput"></a>

```typescript
public readonly delayedGroupDeletionInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `delayedProjectDeletionInput`<sup>Optional</sup> <a name="delayedProjectDeletionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.delayedProjectDeletionInput"></a>

```typescript
public readonly delayedProjectDeletionInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `deleteInactiveProjectsInput`<sup>Optional</sup> <a name="deleteInactiveProjectsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.deleteInactiveProjectsInput"></a>

```typescript
public readonly deleteInactiveProjectsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `deletionAdjournedPeriodInput`<sup>Optional</sup> <a name="deletionAdjournedPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.deletionAdjournedPeriodInput"></a>

```typescript
public readonly deletionAdjournedPeriodInput: number;
```

- *Type:* number

---

##### `diffMaxFilesInput`<sup>Optional</sup> <a name="diffMaxFilesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxFilesInput"></a>

```typescript
public readonly diffMaxFilesInput: number;
```

- *Type:* number

---

##### `diffMaxLinesInput`<sup>Optional</sup> <a name="diffMaxLinesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxLinesInput"></a>

```typescript
public readonly diffMaxLinesInput: number;
```

- *Type:* number

---

##### `diffMaxPatchBytesInput`<sup>Optional</sup> <a name="diffMaxPatchBytesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxPatchBytesInput"></a>

```typescript
public readonly diffMaxPatchBytesInput: number;
```

- *Type:* number

---

##### `disabledOauthSignInSourcesInput`<sup>Optional</sup> <a name="disabledOauthSignInSourcesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.disabledOauthSignInSourcesInput"></a>

```typescript
public readonly disabledOauthSignInSourcesInput: string[];
```

- *Type:* string[]

---

##### `disableFeedTokenInput`<sup>Optional</sup> <a name="disableFeedTokenInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.disableFeedTokenInput"></a>

```typescript
public readonly disableFeedTokenInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `dnsRebindingProtectionEnabledInput`<sup>Optional</sup> <a name="dnsRebindingProtectionEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.dnsRebindingProtectionEnabledInput"></a>

```typescript
public readonly dnsRebindingProtectionEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `domainAllowlistInput`<sup>Optional</sup> <a name="domainAllowlistInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.domainAllowlistInput"></a>

```typescript
public readonly domainAllowlistInput: string[];
```

- *Type:* string[]

---

##### `domainDenylistEnabledInput`<sup>Optional</sup> <a name="domainDenylistEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylistEnabledInput"></a>

```typescript
public readonly domainDenylistEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `domainDenylistInput`<sup>Optional</sup> <a name="domainDenylistInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylistInput"></a>

```typescript
public readonly domainDenylistInput: string[];
```

- *Type:* string[]

---

##### `dsaKeyRestrictionInput`<sup>Optional</sup> <a name="dsaKeyRestrictionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.dsaKeyRestrictionInput"></a>

```typescript
public readonly dsaKeyRestrictionInput: number;
```

- *Type:* number

---

##### `ecdsaKeyRestrictionInput`<sup>Optional</sup> <a name="ecdsaKeyRestrictionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaKeyRestrictionInput"></a>

```typescript
public readonly ecdsaKeyRestrictionInput: number;
```

- *Type:* number

---

##### `ecdsaSkKeyRestrictionInput`<sup>Optional</sup> <a name="ecdsaSkKeyRestrictionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaSkKeyRestrictionInput"></a>

```typescript
public readonly ecdsaSkKeyRestrictionInput: number;
```

- *Type:* number

---

##### `ed25519KeyRestrictionInput`<sup>Optional</sup> <a name="ed25519KeyRestrictionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.ed25519KeyRestrictionInput"></a>

```typescript
public readonly ed25519KeyRestrictionInput: number;
```

- *Type:* number

---

##### `ed25519SkKeyRestrictionInput`<sup>Optional</sup> <a name="ed25519SkKeyRestrictionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.ed25519SkKeyRestrictionInput"></a>

```typescript
public readonly ed25519SkKeyRestrictionInput: number;
```

- *Type:* number

---

##### `eksAccessKeyIdInput`<sup>Optional</sup> <a name="eksAccessKeyIdInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksAccessKeyIdInput"></a>

```typescript
public readonly eksAccessKeyIdInput: string;
```

- *Type:* string

---

##### `eksAccountIdInput`<sup>Optional</sup> <a name="eksAccountIdInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksAccountIdInput"></a>

```typescript
public readonly eksAccountIdInput: string;
```

- *Type:* string

---

##### `eksIntegrationEnabledInput`<sup>Optional</sup> <a name="eksIntegrationEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksIntegrationEnabledInput"></a>

```typescript
public readonly eksIntegrationEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `eksSecretAccessKeyInput`<sup>Optional</sup> <a name="eksSecretAccessKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksSecretAccessKeyInput"></a>

```typescript
public readonly eksSecretAccessKeyInput: string;
```

- *Type:* string

---

##### `elasticsearchAwsAccessKeyInput`<sup>Optional</sup> <a name="elasticsearchAwsAccessKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsAccessKeyInput"></a>

```typescript
public readonly elasticsearchAwsAccessKeyInput: string;
```

- *Type:* string

---

##### `elasticsearchAwsInput`<sup>Optional</sup> <a name="elasticsearchAwsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsInput"></a>

```typescript
public readonly elasticsearchAwsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchAwsRegionInput`<sup>Optional</sup> <a name="elasticsearchAwsRegionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsRegionInput"></a>

```typescript
public readonly elasticsearchAwsRegionInput: string;
```

- *Type:* string

---

##### `elasticsearchAwsSecretAccessKeyInput`<sup>Optional</sup> <a name="elasticsearchAwsSecretAccessKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsSecretAccessKeyInput"></a>

```typescript
public readonly elasticsearchAwsSecretAccessKeyInput: string;
```

- *Type:* string

---

##### `elasticsearchIndexedFieldLengthLimitInput`<sup>Optional</sup> <a name="elasticsearchIndexedFieldLengthLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFieldLengthLimitInput"></a>

```typescript
public readonly elasticsearchIndexedFieldLengthLimitInput: number;
```

- *Type:* number

---

##### `elasticsearchIndexedFileSizeLimitKbInput`<sup>Optional</sup> <a name="elasticsearchIndexedFileSizeLimitKbInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFileSizeLimitKbInput"></a>

```typescript
public readonly elasticsearchIndexedFileSizeLimitKbInput: number;
```

- *Type:* number

---

##### `elasticsearchIndexingInput`<sup>Optional</sup> <a name="elasticsearchIndexingInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexingInput"></a>

```typescript
public readonly elasticsearchIndexingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchLimitIndexingInput`<sup>Optional</sup> <a name="elasticsearchLimitIndexingInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchLimitIndexingInput"></a>

```typescript
public readonly elasticsearchLimitIndexingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchMaxBulkConcurrencyInput`<sup>Optional</sup> <a name="elasticsearchMaxBulkConcurrencyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkConcurrencyInput"></a>

```typescript
public readonly elasticsearchMaxBulkConcurrencyInput: number;
```

- *Type:* number

---

##### `elasticsearchMaxBulkSizeMbInput`<sup>Optional</sup> <a name="elasticsearchMaxBulkSizeMbInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkSizeMbInput"></a>

```typescript
public readonly elasticsearchMaxBulkSizeMbInput: number;
```

- *Type:* number

---

##### `elasticsearchNamespaceIdsInput`<sup>Optional</sup> <a name="elasticsearchNamespaceIdsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchNamespaceIdsInput"></a>

```typescript
public readonly elasticsearchNamespaceIdsInput: string[];
```

- *Type:* string[]

---

##### `elasticsearchPasswordInput`<sup>Optional</sup> <a name="elasticsearchPasswordInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchPasswordInput"></a>

```typescript
public readonly elasticsearchPasswordInput: string;
```

- *Type:* string

---

##### `elasticsearchProjectIdsInput`<sup>Optional</sup> <a name="elasticsearchProjectIdsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchProjectIdsInput"></a>

```typescript
public readonly elasticsearchProjectIdsInput: string[];
```

- *Type:* string[]

---

##### `elasticsearchSearchInput`<sup>Optional</sup> <a name="elasticsearchSearchInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchSearchInput"></a>

```typescript
public readonly elasticsearchSearchInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchUrlInput`<sup>Optional</sup> <a name="elasticsearchUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUrlInput"></a>

```typescript
public readonly elasticsearchUrlInput: string[];
```

- *Type:* string[]

---

##### `elasticsearchUsernameInput`<sup>Optional</sup> <a name="elasticsearchUsernameInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUsernameInput"></a>

```typescript
public readonly elasticsearchUsernameInput: string;
```

- *Type:* string

---

##### `emailAdditionalTextInput`<sup>Optional</sup> <a name="emailAdditionalTextInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.emailAdditionalTextInput"></a>

```typescript
public readonly emailAdditionalTextInput: string;
```

- *Type:* string

---

##### `emailAuthorInBodyInput`<sup>Optional</sup> <a name="emailAuthorInBodyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.emailAuthorInBodyInput"></a>

```typescript
public readonly emailAuthorInBodyInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `enabledGitAccessProtocolInput`<sup>Optional</sup> <a name="enabledGitAccessProtocolInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.enabledGitAccessProtocolInput"></a>

```typescript
public readonly enabledGitAccessProtocolInput: string;
```

- *Type:* string

---

##### `enforceNamespaceStorageLimitInput`<sup>Optional</sup> <a name="enforceNamespaceStorageLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.enforceNamespaceStorageLimitInput"></a>

```typescript
public readonly enforceNamespaceStorageLimitInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `enforceTermsInput`<sup>Optional</sup> <a name="enforceTermsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.enforceTermsInput"></a>

```typescript
public readonly enforceTermsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `externalAuthClientCertInput`<sup>Optional</sup> <a name="externalAuthClientCertInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientCertInput"></a>

```typescript
public readonly externalAuthClientCertInput: string;
```

- *Type:* string

---

##### `externalAuthClientKeyInput`<sup>Optional</sup> <a name="externalAuthClientKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKeyInput"></a>

```typescript
public readonly externalAuthClientKeyInput: string;
```

- *Type:* string

---

##### `externalAuthClientKeyPassInput`<sup>Optional</sup> <a name="externalAuthClientKeyPassInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKeyPassInput"></a>

```typescript
public readonly externalAuthClientKeyPassInput: string;
```

- *Type:* string

---

##### `externalAuthorizationServiceDefaultLabelInput`<sup>Optional</sup> <a name="externalAuthorizationServiceDefaultLabelInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceDefaultLabelInput"></a>

```typescript
public readonly externalAuthorizationServiceDefaultLabelInput: string;
```

- *Type:* string

---

##### `externalAuthorizationServiceEnabledInput`<sup>Optional</sup> <a name="externalAuthorizationServiceEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceEnabledInput"></a>

```typescript
public readonly externalAuthorizationServiceEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `externalAuthorizationServiceTimeoutInput`<sup>Optional</sup> <a name="externalAuthorizationServiceTimeoutInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceTimeoutInput"></a>

```typescript
public readonly externalAuthorizationServiceTimeoutInput: number;
```

- *Type:* number

---

##### `externalAuthorizationServiceUrlInput`<sup>Optional</sup> <a name="externalAuthorizationServiceUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceUrlInput"></a>

```typescript
public readonly externalAuthorizationServiceUrlInput: string;
```

- *Type:* string

---

##### `externalPipelineValidationServiceTimeoutInput`<sup>Optional</sup> <a name="externalPipelineValidationServiceTimeoutInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceTimeoutInput"></a>

```typescript
public readonly externalPipelineValidationServiceTimeoutInput: number;
```

- *Type:* number

---

##### `externalPipelineValidationServiceTokenInput`<sup>Optional</sup> <a name="externalPipelineValidationServiceTokenInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceTokenInput"></a>

```typescript
public readonly externalPipelineValidationServiceTokenInput: string;
```

- *Type:* string

---

##### `externalPipelineValidationServiceUrlInput`<sup>Optional</sup> <a name="externalPipelineValidationServiceUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceUrlInput"></a>

```typescript
public readonly externalPipelineValidationServiceUrlInput: string;
```

- *Type:* string

---

##### `fileTemplateProjectIdInput`<sup>Optional</sup> <a name="fileTemplateProjectIdInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.fileTemplateProjectIdInput"></a>

```typescript
public readonly fileTemplateProjectIdInput: number;
```

- *Type:* number

---

##### `firstDayOfWeekInput`<sup>Optional</sup> <a name="firstDayOfWeekInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.firstDayOfWeekInput"></a>

```typescript
public readonly firstDayOfWeekInput: number;
```

- *Type:* number

---

##### `geoNodeAllowedIpsInput`<sup>Optional</sup> <a name="geoNodeAllowedIpsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.geoNodeAllowedIpsInput"></a>

```typescript
public readonly geoNodeAllowedIpsInput: string;
```

- *Type:* string

---

##### `geoStatusTimeoutInput`<sup>Optional</sup> <a name="geoStatusTimeoutInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.geoStatusTimeoutInput"></a>

```typescript
public readonly geoStatusTimeoutInput: number;
```

- *Type:* number

---

##### `gitalyTimeoutDefaultInput`<sup>Optional</sup> <a name="gitalyTimeoutDefaultInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutDefaultInput"></a>

```typescript
public readonly gitalyTimeoutDefaultInput: number;
```

- *Type:* number

---

##### `gitalyTimeoutFastInput`<sup>Optional</sup> <a name="gitalyTimeoutFastInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutFastInput"></a>

```typescript
public readonly gitalyTimeoutFastInput: number;
```

- *Type:* number

---

##### `gitalyTimeoutMediumInput`<sup>Optional</sup> <a name="gitalyTimeoutMediumInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutMediumInput"></a>

```typescript
public readonly gitalyTimeoutMediumInput: number;
```

- *Type:* number

---

##### `gitRateLimitUsersAllowlistInput`<sup>Optional</sup> <a name="gitRateLimitUsersAllowlistInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitRateLimitUsersAllowlistInput"></a>

```typescript
public readonly gitRateLimitUsersAllowlistInput: string[];
```

- *Type:* string[]

---

##### `gitTwoFactorSessionExpiryInput`<sup>Optional</sup> <a name="gitTwoFactorSessionExpiryInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitTwoFactorSessionExpiryInput"></a>

```typescript
public readonly gitTwoFactorSessionExpiryInput: number;
```

- *Type:* number

---

##### `grafanaEnabledInput`<sup>Optional</sup> <a name="grafanaEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.grafanaEnabledInput"></a>

```typescript
public readonly grafanaEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `grafanaUrlInput`<sup>Optional</sup> <a name="grafanaUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.grafanaUrlInput"></a>

```typescript
public readonly grafanaUrlInput: string;
```

- *Type:* string

---

##### `gravatarEnabledInput`<sup>Optional</sup> <a name="gravatarEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.gravatarEnabledInput"></a>

```typescript
public readonly gravatarEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `hashedStorageEnabledInput`<sup>Optional</sup> <a name="hashedStorageEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.hashedStorageEnabledInput"></a>

```typescript
public readonly hashedStorageEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `helpPageHideCommercialContentInput`<sup>Optional</sup> <a name="helpPageHideCommercialContentInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpPageHideCommercialContentInput"></a>

```typescript
public readonly helpPageHideCommercialContentInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `helpPageSupportUrlInput`<sup>Optional</sup> <a name="helpPageSupportUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpPageSupportUrlInput"></a>

```typescript
public readonly helpPageSupportUrlInput: string;
```

- *Type:* string

---

##### `helpPageTextInput`<sup>Optional</sup> <a name="helpPageTextInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpPageTextInput"></a>

```typescript
public readonly helpPageTextInput: string;
```

- *Type:* string

---

##### `helpTextInput`<sup>Optional</sup> <a name="helpTextInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpTextInput"></a>

```typescript
public readonly helpTextInput: string;
```

- *Type:* string

---

##### `hideThirdPartyOffersInput`<sup>Optional</sup> <a name="hideThirdPartyOffersInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.hideThirdPartyOffersInput"></a>

```typescript
public readonly hideThirdPartyOffersInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `homePageUrlInput`<sup>Optional</sup> <a name="homePageUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.homePageUrlInput"></a>

```typescript
public readonly homePageUrlInput: string;
```

- *Type:* string

---

##### `housekeepingEnabledInput`<sup>Optional</sup> <a name="housekeepingEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingEnabledInput"></a>

```typescript
public readonly housekeepingEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `housekeepingFullRepackPeriodInput`<sup>Optional</sup> <a name="housekeepingFullRepackPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingFullRepackPeriodInput"></a>

```typescript
public readonly housekeepingFullRepackPeriodInput: number;
```

- *Type:* number

---

##### `housekeepingGcPeriodInput`<sup>Optional</sup> <a name="housekeepingGcPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingGcPeriodInput"></a>

```typescript
public readonly housekeepingGcPeriodInput: number;
```

- *Type:* number

---

##### `housekeepingIncrementalRepackPeriodInput`<sup>Optional</sup> <a name="housekeepingIncrementalRepackPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingIncrementalRepackPeriodInput"></a>

```typescript
public readonly housekeepingIncrementalRepackPeriodInput: number;
```

- *Type:* number

---

##### `htmlEmailsEnabledInput`<sup>Optional</sup> <a name="htmlEmailsEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.htmlEmailsEnabledInput"></a>

```typescript
public readonly htmlEmailsEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `importSourcesInput`<sup>Optional</sup> <a name="importSourcesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.importSourcesInput"></a>

```typescript
public readonly importSourcesInput: string[];
```

- *Type:* string[]

---

##### `inactiveProjectsDeleteAfterMonthsInput`<sup>Optional</sup> <a name="inactiveProjectsDeleteAfterMonthsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsDeleteAfterMonthsInput"></a>

```typescript
public readonly inactiveProjectsDeleteAfterMonthsInput: number;
```

- *Type:* number

---

##### `inactiveProjectsMinSizeMbInput`<sup>Optional</sup> <a name="inactiveProjectsMinSizeMbInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsMinSizeMbInput"></a>

```typescript
public readonly inactiveProjectsMinSizeMbInput: number;
```

- *Type:* number

---

##### `inactiveProjectsSendWarningEmailAfterMonthsInput`<sup>Optional</sup> <a name="inactiveProjectsSendWarningEmailAfterMonthsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsSendWarningEmailAfterMonthsInput"></a>

```typescript
public readonly inactiveProjectsSendWarningEmailAfterMonthsInput: number;
```

- *Type:* number

---

##### `inProductMarketingEmailsEnabledInput`<sup>Optional</sup> <a name="inProductMarketingEmailsEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.inProductMarketingEmailsEnabledInput"></a>

```typescript
public readonly inProductMarketingEmailsEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `invisibleCaptchaEnabledInput`<sup>Optional</sup> <a name="invisibleCaptchaEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.invisibleCaptchaEnabledInput"></a>

```typescript
public readonly invisibleCaptchaEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `issuesCreateLimitInput`<sup>Optional</sup> <a name="issuesCreateLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.issuesCreateLimitInput"></a>

```typescript
public readonly issuesCreateLimitInput: number;
```

- *Type:* number

---

##### `keepLatestArtifactInput`<sup>Optional</sup> <a name="keepLatestArtifactInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.keepLatestArtifactInput"></a>

```typescript
public readonly keepLatestArtifactInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `localMarkdownVersionInput`<sup>Optional</sup> <a name="localMarkdownVersionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.localMarkdownVersionInput"></a>

```typescript
public readonly localMarkdownVersionInput: number;
```

- *Type:* number

---

##### `mailgunEventsEnabledInput`<sup>Optional</sup> <a name="mailgunEventsEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.mailgunEventsEnabledInput"></a>

```typescript
public readonly mailgunEventsEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `mailgunSigningKeyInput`<sup>Optional</sup> <a name="mailgunSigningKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.mailgunSigningKeyInput"></a>

```typescript
public readonly mailgunSigningKeyInput: string;
```

- *Type:* string

---

##### `maintenanceModeInput`<sup>Optional</sup> <a name="maintenanceModeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceModeInput"></a>

```typescript
public readonly maintenanceModeInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `maintenanceModeMessageInput`<sup>Optional</sup> <a name="maintenanceModeMessageInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceModeMessageInput"></a>

```typescript
public readonly maintenanceModeMessageInput: string;
```

- *Type:* string

---

##### `maxArtifactsSizeInput`<sup>Optional</sup> <a name="maxArtifactsSizeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxArtifactsSizeInput"></a>

```typescript
public readonly maxArtifactsSizeInput: number;
```

- *Type:* number

---

##### `maxAttachmentSizeInput`<sup>Optional</sup> <a name="maxAttachmentSizeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxAttachmentSizeInput"></a>

```typescript
public readonly maxAttachmentSizeInput: number;
```

- *Type:* number

---

##### `maxExportSizeInput`<sup>Optional</sup> <a name="maxExportSizeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxExportSizeInput"></a>

```typescript
public readonly maxExportSizeInput: number;
```

- *Type:* number

---

##### `maxImportSizeInput`<sup>Optional</sup> <a name="maxImportSizeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxImportSizeInput"></a>

```typescript
public readonly maxImportSizeInput: number;
```

- *Type:* number

---

##### `maxNumberOfRepositoryDownloadsInput`<sup>Optional</sup> <a name="maxNumberOfRepositoryDownloadsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloadsInput"></a>

```typescript
public readonly maxNumberOfRepositoryDownloadsInput: number;
```

- *Type:* number

---

##### `maxNumberOfRepositoryDownloadsWithinTimePeriodInput`<sup>Optional</sup> <a name="maxNumberOfRepositoryDownloadsWithinTimePeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloadsWithinTimePeriodInput"></a>

```typescript
public readonly maxNumberOfRepositoryDownloadsWithinTimePeriodInput: number;
```

- *Type:* number

---

##### `maxPagesSizeInput`<sup>Optional</sup> <a name="maxPagesSizeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxPagesSizeInput"></a>

```typescript
public readonly maxPagesSizeInput: number;
```

- *Type:* number

---

##### `maxPersonalAccessTokenLifetimeInput`<sup>Optional</sup> <a name="maxPersonalAccessTokenLifetimeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxPersonalAccessTokenLifetimeInput"></a>

```typescript
public readonly maxPersonalAccessTokenLifetimeInput: number;
```

- *Type:* number

---

##### `maxSshKeyLifetimeInput`<sup>Optional</sup> <a name="maxSshKeyLifetimeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxSshKeyLifetimeInput"></a>

```typescript
public readonly maxSshKeyLifetimeInput: number;
```

- *Type:* number

---

##### `metricsMethodCallThresholdInput`<sup>Optional</sup> <a name="metricsMethodCallThresholdInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.metricsMethodCallThresholdInput"></a>

```typescript
public readonly metricsMethodCallThresholdInput: number;
```

- *Type:* number

---

##### `mirrorAvailableInput`<sup>Optional</sup> <a name="mirrorAvailableInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorAvailableInput"></a>

```typescript
public readonly mirrorAvailableInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `mirrorCapacityThresholdInput`<sup>Optional</sup> <a name="mirrorCapacityThresholdInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorCapacityThresholdInput"></a>

```typescript
public readonly mirrorCapacityThresholdInput: number;
```

- *Type:* number

---

##### `mirrorMaxCapacityInput`<sup>Optional</sup> <a name="mirrorMaxCapacityInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxCapacityInput"></a>

```typescript
public readonly mirrorMaxCapacityInput: number;
```

- *Type:* number

---

##### `mirrorMaxDelayInput`<sup>Optional</sup> <a name="mirrorMaxDelayInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxDelayInput"></a>

```typescript
public readonly mirrorMaxDelayInput: number;
```

- *Type:* number

---

##### `npmPackageRequestsForwardingInput`<sup>Optional</sup> <a name="npmPackageRequestsForwardingInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.npmPackageRequestsForwardingInput"></a>

```typescript
public readonly npmPackageRequestsForwardingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `outboundLocalRequestsWhitelistInput`<sup>Optional</sup> <a name="outboundLocalRequestsWhitelistInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.outboundLocalRequestsWhitelistInput"></a>

```typescript
public readonly outboundLocalRequestsWhitelistInput: string[];
```

- *Type:* string[]

---

##### `packageRegistryCleanupPoliciesWorkerCapacityInput`<sup>Optional</sup> <a name="packageRegistryCleanupPoliciesWorkerCapacityInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.packageRegistryCleanupPoliciesWorkerCapacityInput"></a>

```typescript
public readonly packageRegistryCleanupPoliciesWorkerCapacityInput: number;
```

- *Type:* number

---

##### `pagesDomainVerificationEnabledInput`<sup>Optional</sup> <a name="pagesDomainVerificationEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.pagesDomainVerificationEnabledInput"></a>

```typescript
public readonly pagesDomainVerificationEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordAuthenticationEnabledForGitInput`<sup>Optional</sup> <a name="passwordAuthenticationEnabledForGitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForGitInput"></a>

```typescript
public readonly passwordAuthenticationEnabledForGitInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordAuthenticationEnabledForWebInput`<sup>Optional</sup> <a name="passwordAuthenticationEnabledForWebInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForWebInput"></a>

```typescript
public readonly passwordAuthenticationEnabledForWebInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordLowercaseRequiredInput`<sup>Optional</sup> <a name="passwordLowercaseRequiredInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordLowercaseRequiredInput"></a>

```typescript
public readonly passwordLowercaseRequiredInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordNumberRequiredInput`<sup>Optional</sup> <a name="passwordNumberRequiredInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordNumberRequiredInput"></a>

```typescript
public readonly passwordNumberRequiredInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordSymbolRequiredInput`<sup>Optional</sup> <a name="passwordSymbolRequiredInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordSymbolRequiredInput"></a>

```typescript
public readonly passwordSymbolRequiredInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordUppercaseRequiredInput`<sup>Optional</sup> <a name="passwordUppercaseRequiredInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordUppercaseRequiredInput"></a>

```typescript
public readonly passwordUppercaseRequiredInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `performanceBarAllowedGroupPathInput`<sup>Optional</sup> <a name="performanceBarAllowedGroupPathInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.performanceBarAllowedGroupPathInput"></a>

```typescript
public readonly performanceBarAllowedGroupPathInput: string;
```

- *Type:* string

---

##### `personalAccessTokenPrefixInput`<sup>Optional</sup> <a name="personalAccessTokenPrefixInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.personalAccessTokenPrefixInput"></a>

```typescript
public readonly personalAccessTokenPrefixInput: string;
```

- *Type:* string

---

##### `pipelineLimitPerProjectUserShaInput`<sup>Optional</sup> <a name="pipelineLimitPerProjectUserShaInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.pipelineLimitPerProjectUserShaInput"></a>

```typescript
public readonly pipelineLimitPerProjectUserShaInput: number;
```

- *Type:* number

---

##### `plantumlEnabledInput`<sup>Optional</sup> <a name="plantumlEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.plantumlEnabledInput"></a>

```typescript
public readonly plantumlEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `plantumlUrlInput`<sup>Optional</sup> <a name="plantumlUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.plantumlUrlInput"></a>

```typescript
public readonly plantumlUrlInput: string;
```

- *Type:* string

---

##### `pollingIntervalMultiplierInput`<sup>Optional</sup> <a name="pollingIntervalMultiplierInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.pollingIntervalMultiplierInput"></a>

```typescript
public readonly pollingIntervalMultiplierInput: number;
```

- *Type:* number

---

##### `projectExportEnabledInput`<sup>Optional</sup> <a name="projectExportEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.projectExportEnabledInput"></a>

```typescript
public readonly projectExportEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `prometheusMetricsEnabledInput`<sup>Optional</sup> <a name="prometheusMetricsEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.prometheusMetricsEnabledInput"></a>

```typescript
public readonly prometheusMetricsEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `protectedCiVariablesInput`<sup>Optional</sup> <a name="protectedCiVariablesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.protectedCiVariablesInput"></a>

```typescript
public readonly protectedCiVariablesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `pushEventActivitiesLimitInput`<sup>Optional</sup> <a name="pushEventActivitiesLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.pushEventActivitiesLimitInput"></a>

```typescript
public readonly pushEventActivitiesLimitInput: number;
```

- *Type:* number

---

##### `pushEventHooksLimitInput`<sup>Optional</sup> <a name="pushEventHooksLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.pushEventHooksLimitInput"></a>

```typescript
public readonly pushEventHooksLimitInput: number;
```

- *Type:* number

---

##### `pypiPackageRequestsForwardingInput`<sup>Optional</sup> <a name="pypiPackageRequestsForwardingInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.pypiPackageRequestsForwardingInput"></a>

```typescript
public readonly pypiPackageRequestsForwardingInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `rateLimitingResponseTextInput`<sup>Optional</sup> <a name="rateLimitingResponseTextInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.rateLimitingResponseTextInput"></a>

```typescript
public readonly rateLimitingResponseTextInput: string;
```

- *Type:* string

---

##### `rawBlobRequestLimitInput`<sup>Optional</sup> <a name="rawBlobRequestLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.rawBlobRequestLimitInput"></a>

```typescript
public readonly rawBlobRequestLimitInput: number;
```

- *Type:* number

---

##### `recaptchaEnabledInput`<sup>Optional</sup> <a name="recaptchaEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaEnabledInput"></a>

```typescript
public readonly recaptchaEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `recaptchaPrivateKeyInput`<sup>Optional</sup> <a name="recaptchaPrivateKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaPrivateKeyInput"></a>

```typescript
public readonly recaptchaPrivateKeyInput: string;
```

- *Type:* string

---

##### `recaptchaSiteKeyInput`<sup>Optional</sup> <a name="recaptchaSiteKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaSiteKeyInput"></a>

```typescript
public readonly recaptchaSiteKeyInput: string;
```

- *Type:* string

---

##### `receiveMaxInputSizeInput`<sup>Optional</sup> <a name="receiveMaxInputSizeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.receiveMaxInputSizeInput"></a>

```typescript
public readonly receiveMaxInputSizeInput: number;
```

- *Type:* number

---

##### `repositoryChecksEnabledInput`<sup>Optional</sup> <a name="repositoryChecksEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositoryChecksEnabledInput"></a>

```typescript
public readonly repositoryChecksEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `repositorySizeLimitInput`<sup>Optional</sup> <a name="repositorySizeLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositorySizeLimitInput"></a>

```typescript
public readonly repositorySizeLimitInput: number;
```

- *Type:* number

---

##### `repositoryStoragesInput`<sup>Optional</sup> <a name="repositoryStoragesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStoragesInput"></a>

```typescript
public readonly repositoryStoragesInput: string[];
```

- *Type:* string[]

---

##### `repositoryStoragesWeightedInput`<sup>Optional</sup> <a name="repositoryStoragesWeightedInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStoragesWeightedInput"></a>

```typescript
public readonly repositoryStoragesWeightedInput: {[ key: string ]: number};
```

- *Type:* {[ key: string ]: number}

---

##### `requireAdminApprovalAfterUserSignupInput`<sup>Optional</sup> <a name="requireAdminApprovalAfterUserSignupInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.requireAdminApprovalAfterUserSignupInput"></a>

```typescript
public readonly requireAdminApprovalAfterUserSignupInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `requireTwoFactorAuthenticationInput`<sup>Optional</sup> <a name="requireTwoFactorAuthenticationInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.requireTwoFactorAuthenticationInput"></a>

```typescript
public readonly requireTwoFactorAuthenticationInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `restrictedVisibilityLevelsInput`<sup>Optional</sup> <a name="restrictedVisibilityLevelsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.restrictedVisibilityLevelsInput"></a>

```typescript
public readonly restrictedVisibilityLevelsInput: string[];
```

- *Type:* string[]

---

##### `rsaKeyRestrictionInput`<sup>Optional</sup> <a name="rsaKeyRestrictionInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.rsaKeyRestrictionInput"></a>

```typescript
public readonly rsaKeyRestrictionInput: number;
```

- *Type:* number

---

##### `searchRateLimitInput`<sup>Optional</sup> <a name="searchRateLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimitInput"></a>

```typescript
public readonly searchRateLimitInput: number;
```

- *Type:* number

---

##### `searchRateLimitUnauthenticatedInput`<sup>Optional</sup> <a name="searchRateLimitUnauthenticatedInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimitUnauthenticatedInput"></a>

```typescript
public readonly searchRateLimitUnauthenticatedInput: number;
```

- *Type:* number

---

##### `sendUserConfirmationEmailInput`<sup>Optional</sup> <a name="sendUserConfirmationEmailInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sendUserConfirmationEmailInput"></a>

```typescript
public readonly sendUserConfirmationEmailInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sessionExpireDelayInput`<sup>Optional</sup> <a name="sessionExpireDelayInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sessionExpireDelayInput"></a>

```typescript
public readonly sessionExpireDelayInput: number;
```

- *Type:* number

---

##### `sharedRunnersEnabledInput`<sup>Optional</sup> <a name="sharedRunnersEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersEnabledInput"></a>

```typescript
public readonly sharedRunnersEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sharedRunnersMinutesInput`<sup>Optional</sup> <a name="sharedRunnersMinutesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersMinutesInput"></a>

```typescript
public readonly sharedRunnersMinutesInput: number;
```

- *Type:* number

---

##### `sharedRunnersTextInput`<sup>Optional</sup> <a name="sharedRunnersTextInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersTextInput"></a>

```typescript
public readonly sharedRunnersTextInput: string;
```

- *Type:* string

---

##### `sidekiqJobLimiterCompressionThresholdBytesInput`<sup>Optional</sup> <a name="sidekiqJobLimiterCompressionThresholdBytesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterCompressionThresholdBytesInput"></a>

```typescript
public readonly sidekiqJobLimiterCompressionThresholdBytesInput: number;
```

- *Type:* number

---

##### `sidekiqJobLimiterLimitBytesInput`<sup>Optional</sup> <a name="sidekiqJobLimiterLimitBytesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterLimitBytesInput"></a>

```typescript
public readonly sidekiqJobLimiterLimitBytesInput: number;
```

- *Type:* number

---

##### `sidekiqJobLimiterModeInput`<sup>Optional</sup> <a name="sidekiqJobLimiterModeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterModeInput"></a>

```typescript
public readonly sidekiqJobLimiterModeInput: string;
```

- *Type:* string

---

##### `signInTextInput`<sup>Optional</sup> <a name="signInTextInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.signInTextInput"></a>

```typescript
public readonly signInTextInput: string;
```

- *Type:* string

---

##### `signupEnabledInput`<sup>Optional</sup> <a name="signupEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.signupEnabledInput"></a>

```typescript
public readonly signupEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `slackAppEnabledInput`<sup>Optional</sup> <a name="slackAppEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppEnabledInput"></a>

```typescript
public readonly slackAppEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `slackAppIdInput`<sup>Optional</sup> <a name="slackAppIdInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppIdInput"></a>

```typescript
public readonly slackAppIdInput: string;
```

- *Type:* string

---

##### `slackAppSecretInput`<sup>Optional</sup> <a name="slackAppSecretInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSecretInput"></a>

```typescript
public readonly slackAppSecretInput: string;
```

- *Type:* string

---

##### `slackAppSigningSecretInput`<sup>Optional</sup> <a name="slackAppSigningSecretInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSigningSecretInput"></a>

```typescript
public readonly slackAppSigningSecretInput: string;
```

- *Type:* string

---

##### `slackAppVerificationTokenInput`<sup>Optional</sup> <a name="slackAppVerificationTokenInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppVerificationTokenInput"></a>

```typescript
public readonly slackAppVerificationTokenInput: string;
```

- *Type:* string

---

##### `snippetSizeLimitInput`<sup>Optional</sup> <a name="snippetSizeLimitInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.snippetSizeLimitInput"></a>

```typescript
public readonly snippetSizeLimitInput: number;
```

- *Type:* number

---

##### `snowplowAppIdInput`<sup>Optional</sup> <a name="snowplowAppIdInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowAppIdInput"></a>

```typescript
public readonly snowplowAppIdInput: string;
```

- *Type:* string

---

##### `snowplowCollectorHostnameInput`<sup>Optional</sup> <a name="snowplowCollectorHostnameInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCollectorHostnameInput"></a>

```typescript
public readonly snowplowCollectorHostnameInput: string;
```

- *Type:* string

---

##### `snowplowCookieDomainInput`<sup>Optional</sup> <a name="snowplowCookieDomainInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCookieDomainInput"></a>

```typescript
public readonly snowplowCookieDomainInput: string;
```

- *Type:* string

---

##### `snowplowEnabledInput`<sup>Optional</sup> <a name="snowplowEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowEnabledInput"></a>

```typescript
public readonly snowplowEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sourcegraphEnabledInput`<sup>Optional</sup> <a name="sourcegraphEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphEnabledInput"></a>

```typescript
public readonly sourcegraphEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sourcegraphPublicOnlyInput`<sup>Optional</sup> <a name="sourcegraphPublicOnlyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphPublicOnlyInput"></a>

```typescript
public readonly sourcegraphPublicOnlyInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sourcegraphUrlInput`<sup>Optional</sup> <a name="sourcegraphUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphUrlInput"></a>

```typescript
public readonly sourcegraphUrlInput: string;
```

- *Type:* string

---

##### `spamCheckApiKeyInput`<sup>Optional</sup> <a name="spamCheckApiKeyInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckApiKeyInput"></a>

```typescript
public readonly spamCheckApiKeyInput: string;
```

- *Type:* string

---

##### `spamCheckEndpointEnabledInput`<sup>Optional</sup> <a name="spamCheckEndpointEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointEnabledInput"></a>

```typescript
public readonly spamCheckEndpointEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `spamCheckEndpointUrlInput`<sup>Optional</sup> <a name="spamCheckEndpointUrlInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointUrlInput"></a>

```typescript
public readonly spamCheckEndpointUrlInput: string;
```

- *Type:* string

---

##### `suggestPipelineEnabledInput`<sup>Optional</sup> <a name="suggestPipelineEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.suggestPipelineEnabledInput"></a>

```typescript
public readonly suggestPipelineEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `terminalMaxSessionTimeInput`<sup>Optional</sup> <a name="terminalMaxSessionTimeInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.terminalMaxSessionTimeInput"></a>

```typescript
public readonly terminalMaxSessionTimeInput: number;
```

- *Type:* number

---

##### `termsInput`<sup>Optional</sup> <a name="termsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.termsInput"></a>

```typescript
public readonly termsInput: string;
```

- *Type:* string

---

##### `throttleAuthenticatedApiEnabledInput`<sup>Optional</sup> <a name="throttleAuthenticatedApiEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiEnabledInput"></a>

```typescript
public readonly throttleAuthenticatedApiEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleAuthenticatedApiPeriodInSecondsInput`<sup>Optional</sup> <a name="throttleAuthenticatedApiPeriodInSecondsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiPeriodInSecondsInput"></a>

```typescript
public readonly throttleAuthenticatedApiPeriodInSecondsInput: number;
```

- *Type:* number

---

##### `throttleAuthenticatedApiRequestsPerPeriodInput`<sup>Optional</sup> <a name="throttleAuthenticatedApiRequestsPerPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiRequestsPerPeriodInput"></a>

```typescript
public readonly throttleAuthenticatedApiRequestsPerPeriodInput: number;
```

- *Type:* number

---

##### `throttleAuthenticatedPackagesApiEnabledInput`<sup>Optional</sup> <a name="throttleAuthenticatedPackagesApiEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiEnabledInput"></a>

```typescript
public readonly throttleAuthenticatedPackagesApiEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleAuthenticatedPackagesApiPeriodInSecondsInput`<sup>Optional</sup> <a name="throttleAuthenticatedPackagesApiPeriodInSecondsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiPeriodInSecondsInput"></a>

```typescript
public readonly throttleAuthenticatedPackagesApiPeriodInSecondsInput: number;
```

- *Type:* number

---

##### `throttleAuthenticatedPackagesApiRequestsPerPeriodInput`<sup>Optional</sup> <a name="throttleAuthenticatedPackagesApiRequestsPerPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiRequestsPerPeriodInput"></a>

```typescript
public readonly throttleAuthenticatedPackagesApiRequestsPerPeriodInput: number;
```

- *Type:* number

---

##### `throttleAuthenticatedWebEnabledInput`<sup>Optional</sup> <a name="throttleAuthenticatedWebEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebEnabledInput"></a>

```typescript
public readonly throttleAuthenticatedWebEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleAuthenticatedWebPeriodInSecondsInput`<sup>Optional</sup> <a name="throttleAuthenticatedWebPeriodInSecondsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebPeriodInSecondsInput"></a>

```typescript
public readonly throttleAuthenticatedWebPeriodInSecondsInput: number;
```

- *Type:* number

---

##### `throttleAuthenticatedWebRequestsPerPeriodInput`<sup>Optional</sup> <a name="throttleAuthenticatedWebRequestsPerPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebRequestsPerPeriodInput"></a>

```typescript
public readonly throttleAuthenticatedWebRequestsPerPeriodInput: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedApiEnabledInput`<sup>Optional</sup> <a name="throttleUnauthenticatedApiEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiEnabledInput"></a>

```typescript
public readonly throttleUnauthenticatedApiEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleUnauthenticatedApiPeriodInSecondsInput`<sup>Optional</sup> <a name="throttleUnauthenticatedApiPeriodInSecondsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiPeriodInSecondsInput"></a>

```typescript
public readonly throttleUnauthenticatedApiPeriodInSecondsInput: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedApiRequestsPerPeriodInput`<sup>Optional</sup> <a name="throttleUnauthenticatedApiRequestsPerPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiRequestsPerPeriodInput"></a>

```typescript
public readonly throttleUnauthenticatedApiRequestsPerPeriodInput: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedPackagesApiEnabledInput`<sup>Optional</sup> <a name="throttleUnauthenticatedPackagesApiEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiEnabledInput"></a>

```typescript
public readonly throttleUnauthenticatedPackagesApiEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleUnauthenticatedPackagesApiPeriodInSecondsInput`<sup>Optional</sup> <a name="throttleUnauthenticatedPackagesApiPeriodInSecondsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiPeriodInSecondsInput"></a>

```typescript
public readonly throttleUnauthenticatedPackagesApiPeriodInSecondsInput: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedPackagesApiRequestsPerPeriodInput`<sup>Optional</sup> <a name="throttleUnauthenticatedPackagesApiRequestsPerPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiRequestsPerPeriodInput"></a>

```typescript
public readonly throttleUnauthenticatedPackagesApiRequestsPerPeriodInput: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedWebEnabledInput`<sup>Optional</sup> <a name="throttleUnauthenticatedWebEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebEnabledInput"></a>

```typescript
public readonly throttleUnauthenticatedWebEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleUnauthenticatedWebPeriodInSecondsInput`<sup>Optional</sup> <a name="throttleUnauthenticatedWebPeriodInSecondsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebPeriodInSecondsInput"></a>

```typescript
public readonly throttleUnauthenticatedWebPeriodInSecondsInput: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedWebRequestsPerPeriodInput`<sup>Optional</sup> <a name="throttleUnauthenticatedWebRequestsPerPeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebRequestsPerPeriodInput"></a>

```typescript
public readonly throttleUnauthenticatedWebRequestsPerPeriodInput: number;
```

- *Type:* number

---

##### `timeTrackingLimitToHoursInput`<sup>Optional</sup> <a name="timeTrackingLimitToHoursInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.timeTrackingLimitToHoursInput"></a>

```typescript
public readonly timeTrackingLimitToHoursInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `twoFactorGracePeriodInput`<sup>Optional</sup> <a name="twoFactorGracePeriodInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.twoFactorGracePeriodInput"></a>

```typescript
public readonly twoFactorGracePeriodInput: number;
```

- *Type:* number

---

##### `uniqueIpsLimitEnabledInput`<sup>Optional</sup> <a name="uniqueIpsLimitEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitEnabledInput"></a>

```typescript
public readonly uniqueIpsLimitEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `uniqueIpsLimitPerUserInput`<sup>Optional</sup> <a name="uniqueIpsLimitPerUserInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitPerUserInput"></a>

```typescript
public readonly uniqueIpsLimitPerUserInput: number;
```

- *Type:* number

---

##### `uniqueIpsLimitTimeWindowInput`<sup>Optional</sup> <a name="uniqueIpsLimitTimeWindowInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitTimeWindowInput"></a>

```typescript
public readonly uniqueIpsLimitTimeWindowInput: number;
```

- *Type:* number

---

##### `usagePingEnabledInput`<sup>Optional</sup> <a name="usagePingEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.usagePingEnabledInput"></a>

```typescript
public readonly usagePingEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userDeactivationEmailsEnabledInput`<sup>Optional</sup> <a name="userDeactivationEmailsEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.userDeactivationEmailsEnabledInput"></a>

```typescript
public readonly userDeactivationEmailsEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userDefaultExternalInput`<sup>Optional</sup> <a name="userDefaultExternalInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultExternalInput"></a>

```typescript
public readonly userDefaultExternalInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userDefaultInternalRegexInput`<sup>Optional</sup> <a name="userDefaultInternalRegexInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultInternalRegexInput"></a>

```typescript
public readonly userDefaultInternalRegexInput: string;
```

- *Type:* string

---

##### `userOauthApplicationsInput`<sup>Optional</sup> <a name="userOauthApplicationsInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.userOauthApplicationsInput"></a>

```typescript
public readonly userOauthApplicationsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userShowAddSshKeyMessageInput`<sup>Optional</sup> <a name="userShowAddSshKeyMessageInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.userShowAddSshKeyMessageInput"></a>

```typescript
public readonly userShowAddSshKeyMessageInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `versionCheckEnabledInput`<sup>Optional</sup> <a name="versionCheckEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.versionCheckEnabledInput"></a>

```typescript
public readonly versionCheckEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `webIdeClientsidePreviewEnabledInput`<sup>Optional</sup> <a name="webIdeClientsidePreviewEnabledInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.webIdeClientsidePreviewEnabledInput"></a>

```typescript
public readonly webIdeClientsidePreviewEnabledInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `whatsNewVariantInput`<sup>Optional</sup> <a name="whatsNewVariantInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.whatsNewVariantInput"></a>

```typescript
public readonly whatsNewVariantInput: string;
```

- *Type:* string

---

##### `wikiPageMaxContentBytesInput`<sup>Optional</sup> <a name="wikiPageMaxContentBytesInput" id="@cdktf/provider-gitlab.ApplicationSettings.property.wikiPageMaxContentBytesInput"></a>

```typescript
public readonly wikiPageMaxContentBytesInput: number;
```

- *Type:* number

---

##### `abuseNotificationEmail`<sup>Required</sup> <a name="abuseNotificationEmail" id="@cdktf/provider-gitlab.ApplicationSettings.property.abuseNotificationEmail"></a>

```typescript
public readonly abuseNotificationEmail: string;
```

- *Type:* string

---

##### `adminMode`<sup>Required</sup> <a name="adminMode" id="@cdktf/provider-gitlab.ApplicationSettings.property.adminMode"></a>

```typescript
public readonly adminMode: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `afterSignOutPath`<sup>Required</sup> <a name="afterSignOutPath" id="@cdktf/provider-gitlab.ApplicationSettings.property.afterSignOutPath"></a>

```typescript
public readonly afterSignOutPath: string;
```

- *Type:* string

---

##### `afterSignUpText`<sup>Required</sup> <a name="afterSignUpText" id="@cdktf/provider-gitlab.ApplicationSettings.property.afterSignUpText"></a>

```typescript
public readonly afterSignUpText: string;
```

- *Type:* string

---

##### `akismetApiKey`<sup>Required</sup> <a name="akismetApiKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.akismetApiKey"></a>

```typescript
public readonly akismetApiKey: string;
```

- *Type:* string

---

##### `akismetEnabled`<sup>Required</sup> <a name="akismetEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.akismetEnabled"></a>

```typescript
public readonly akismetEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `allowGroupOwnersToManageLdap`<sup>Required</sup> <a name="allowGroupOwnersToManageLdap" id="@cdktf/provider-gitlab.ApplicationSettings.property.allowGroupOwnersToManageLdap"></a>

```typescript
public readonly allowGroupOwnersToManageLdap: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `allowLocalRequestsFromSystemHooks`<sup>Required</sup> <a name="allowLocalRequestsFromSystemHooks" id="@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromSystemHooks"></a>

```typescript
public readonly allowLocalRequestsFromSystemHooks: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `allowLocalRequestsFromWebHooksAndServices`<sup>Required</sup> <a name="allowLocalRequestsFromWebHooksAndServices" id="@cdktf/provider-gitlab.ApplicationSettings.property.allowLocalRequestsFromWebHooksAndServices"></a>

```typescript
public readonly allowLocalRequestsFromWebHooksAndServices: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `archiveBuildsInHumanReadable`<sup>Required</sup> <a name="archiveBuildsInHumanReadable" id="@cdktf/provider-gitlab.ApplicationSettings.property.archiveBuildsInHumanReadable"></a>

```typescript
public readonly archiveBuildsInHumanReadable: string;
```

- *Type:* string

---

##### `assetProxyAllowlist`<sup>Required</sup> <a name="assetProxyAllowlist" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyAllowlist"></a>

```typescript
public readonly assetProxyAllowlist: string[];
```

- *Type:* string[]

---

##### `assetProxyEnabled`<sup>Required</sup> <a name="assetProxyEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyEnabled"></a>

```typescript
public readonly assetProxyEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `assetProxySecretKey`<sup>Required</sup> <a name="assetProxySecretKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxySecretKey"></a>

```typescript
public readonly assetProxySecretKey: string;
```

- *Type:* string

---

##### `assetProxyUrl`<sup>Required</sup> <a name="assetProxyUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.assetProxyUrl"></a>

```typescript
public readonly assetProxyUrl: string;
```

- *Type:* string

---

##### `authorizedKeysEnabled`<sup>Required</sup> <a name="authorizedKeysEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.authorizedKeysEnabled"></a>

```typescript
public readonly authorizedKeysEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `autoDevopsDomain`<sup>Required</sup> <a name="autoDevopsDomain" id="@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsDomain"></a>

```typescript
public readonly autoDevopsDomain: string;
```

- *Type:* string

---

##### `autoDevopsEnabled`<sup>Required</sup> <a name="autoDevopsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.autoDevopsEnabled"></a>

```typescript
public readonly autoDevopsEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `automaticPurchasedStorageAllocation`<sup>Required</sup> <a name="automaticPurchasedStorageAllocation" id="@cdktf/provider-gitlab.ApplicationSettings.property.automaticPurchasedStorageAllocation"></a>

```typescript
public readonly automaticPurchasedStorageAllocation: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `checkNamespacePlan`<sup>Required</sup> <a name="checkNamespacePlan" id="@cdktf/provider-gitlab.ApplicationSettings.property.checkNamespacePlan"></a>

```typescript
public readonly checkNamespacePlan: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `commitEmailHostname`<sup>Required</sup> <a name="commitEmailHostname" id="@cdktf/provider-gitlab.ApplicationSettings.property.commitEmailHostname"></a>

```typescript
public readonly commitEmailHostname: string;
```

- *Type:* string

---

##### `containerExpirationPoliciesEnableHistoricEntries`<sup>Required</sup> <a name="containerExpirationPoliciesEnableHistoricEntries" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerExpirationPoliciesEnableHistoricEntries"></a>

```typescript
public readonly containerExpirationPoliciesEnableHistoricEntries: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `containerRegistryCleanupTagsServiceMaxListSize`<sup>Required</sup> <a name="containerRegistryCleanupTagsServiceMaxListSize" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryCleanupTagsServiceMaxListSize"></a>

```typescript
public readonly containerRegistryCleanupTagsServiceMaxListSize: number;
```

- *Type:* number

---

##### `containerRegistryDeleteTagsServiceTimeout`<sup>Required</sup> <a name="containerRegistryDeleteTagsServiceTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryDeleteTagsServiceTimeout"></a>

```typescript
public readonly containerRegistryDeleteTagsServiceTimeout: number;
```

- *Type:* number

---

##### `containerRegistryExpirationPoliciesCaching`<sup>Required</sup> <a name="containerRegistryExpirationPoliciesCaching" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesCaching"></a>

```typescript
public readonly containerRegistryExpirationPoliciesCaching: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `containerRegistryExpirationPoliciesWorkerCapacity`<sup>Required</sup> <a name="containerRegistryExpirationPoliciesWorkerCapacity" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryExpirationPoliciesWorkerCapacity"></a>

```typescript
public readonly containerRegistryExpirationPoliciesWorkerCapacity: number;
```

- *Type:* number

---

##### `containerRegistryTokenExpireDelay`<sup>Required</sup> <a name="containerRegistryTokenExpireDelay" id="@cdktf/provider-gitlab.ApplicationSettings.property.containerRegistryTokenExpireDelay"></a>

```typescript
public readonly containerRegistryTokenExpireDelay: number;
```

- *Type:* number

---

##### `deactivateDormantUsers`<sup>Required</sup> <a name="deactivateDormantUsers" id="@cdktf/provider-gitlab.ApplicationSettings.property.deactivateDormantUsers"></a>

```typescript
public readonly deactivateDormantUsers: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `defaultArtifactsExpireIn`<sup>Required</sup> <a name="defaultArtifactsExpireIn" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultArtifactsExpireIn"></a>

```typescript
public readonly defaultArtifactsExpireIn: string;
```

- *Type:* string

---

##### `defaultBranchName`<sup>Required</sup> <a name="defaultBranchName" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchName"></a>

```typescript
public readonly defaultBranchName: string;
```

- *Type:* string

---

##### `defaultBranchProtection`<sup>Required</sup> <a name="defaultBranchProtection" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultBranchProtection"></a>

```typescript
public readonly defaultBranchProtection: number;
```

- *Type:* number

---

##### `defaultCiConfigPath`<sup>Required</sup> <a name="defaultCiConfigPath" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultCiConfigPath"></a>

```typescript
public readonly defaultCiConfigPath: string;
```

- *Type:* string

---

##### `defaultGroupVisibility`<sup>Required</sup> <a name="defaultGroupVisibility" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultGroupVisibility"></a>

```typescript
public readonly defaultGroupVisibility: string;
```

- *Type:* string

---

##### `defaultProjectCreation`<sup>Required</sup> <a name="defaultProjectCreation" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectCreation"></a>

```typescript
public readonly defaultProjectCreation: number;
```

- *Type:* number

---

##### `defaultProjectsLimit`<sup>Required</sup> <a name="defaultProjectsLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectsLimit"></a>

```typescript
public readonly defaultProjectsLimit: number;
```

- *Type:* number

---

##### `defaultProjectVisibility`<sup>Required</sup> <a name="defaultProjectVisibility" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultProjectVisibility"></a>

```typescript
public readonly defaultProjectVisibility: string;
```

- *Type:* string

---

##### `defaultSnippetVisibility`<sup>Required</sup> <a name="defaultSnippetVisibility" id="@cdktf/provider-gitlab.ApplicationSettings.property.defaultSnippetVisibility"></a>

```typescript
public readonly defaultSnippetVisibility: string;
```

- *Type:* string

---

##### `delayedGroupDeletion`<sup>Required</sup> <a name="delayedGroupDeletion" id="@cdktf/provider-gitlab.ApplicationSettings.property.delayedGroupDeletion"></a>

```typescript
public readonly delayedGroupDeletion: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `delayedProjectDeletion`<sup>Required</sup> <a name="delayedProjectDeletion" id="@cdktf/provider-gitlab.ApplicationSettings.property.delayedProjectDeletion"></a>

```typescript
public readonly delayedProjectDeletion: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `deleteInactiveProjects`<sup>Required</sup> <a name="deleteInactiveProjects" id="@cdktf/provider-gitlab.ApplicationSettings.property.deleteInactiveProjects"></a>

```typescript
public readonly deleteInactiveProjects: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `deletionAdjournedPeriod`<sup>Required</sup> <a name="deletionAdjournedPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.deletionAdjournedPeriod"></a>

```typescript
public readonly deletionAdjournedPeriod: number;
```

- *Type:* number

---

##### `diffMaxFiles`<sup>Required</sup> <a name="diffMaxFiles" id="@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxFiles"></a>

```typescript
public readonly diffMaxFiles: number;
```

- *Type:* number

---

##### `diffMaxLines`<sup>Required</sup> <a name="diffMaxLines" id="@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxLines"></a>

```typescript
public readonly diffMaxLines: number;
```

- *Type:* number

---

##### `diffMaxPatchBytes`<sup>Required</sup> <a name="diffMaxPatchBytes" id="@cdktf/provider-gitlab.ApplicationSettings.property.diffMaxPatchBytes"></a>

```typescript
public readonly diffMaxPatchBytes: number;
```

- *Type:* number

---

##### `disabledOauthSignInSources`<sup>Required</sup> <a name="disabledOauthSignInSources" id="@cdktf/provider-gitlab.ApplicationSettings.property.disabledOauthSignInSources"></a>

```typescript
public readonly disabledOauthSignInSources: string[];
```

- *Type:* string[]

---

##### `disableFeedToken`<sup>Required</sup> <a name="disableFeedToken" id="@cdktf/provider-gitlab.ApplicationSettings.property.disableFeedToken"></a>

```typescript
public readonly disableFeedToken: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `dnsRebindingProtectionEnabled`<sup>Required</sup> <a name="dnsRebindingProtectionEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.dnsRebindingProtectionEnabled"></a>

```typescript
public readonly dnsRebindingProtectionEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `domainAllowlist`<sup>Required</sup> <a name="domainAllowlist" id="@cdktf/provider-gitlab.ApplicationSettings.property.domainAllowlist"></a>

```typescript
public readonly domainAllowlist: string[];
```

- *Type:* string[]

---

##### `domainDenylist`<sup>Required</sup> <a name="domainDenylist" id="@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylist"></a>

```typescript
public readonly domainDenylist: string[];
```

- *Type:* string[]

---

##### `domainDenylistEnabled`<sup>Required</sup> <a name="domainDenylistEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.domainDenylistEnabled"></a>

```typescript
public readonly domainDenylistEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `dsaKeyRestriction`<sup>Required</sup> <a name="dsaKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.property.dsaKeyRestriction"></a>

```typescript
public readonly dsaKeyRestriction: number;
```

- *Type:* number

---

##### `ecdsaKeyRestriction`<sup>Required</sup> <a name="ecdsaKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaKeyRestriction"></a>

```typescript
public readonly ecdsaKeyRestriction: number;
```

- *Type:* number

---

##### `ecdsaSkKeyRestriction`<sup>Required</sup> <a name="ecdsaSkKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.property.ecdsaSkKeyRestriction"></a>

```typescript
public readonly ecdsaSkKeyRestriction: number;
```

- *Type:* number

---

##### `ed25519KeyRestriction`<sup>Required</sup> <a name="ed25519KeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.property.ed25519KeyRestriction"></a>

```typescript
public readonly ed25519KeyRestriction: number;
```

- *Type:* number

---

##### `ed25519SkKeyRestriction`<sup>Required</sup> <a name="ed25519SkKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.property.ed25519SkKeyRestriction"></a>

```typescript
public readonly ed25519SkKeyRestriction: number;
```

- *Type:* number

---

##### `eksAccessKeyId`<sup>Required</sup> <a name="eksAccessKeyId" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksAccessKeyId"></a>

```typescript
public readonly eksAccessKeyId: string;
```

- *Type:* string

---

##### `eksAccountId`<sup>Required</sup> <a name="eksAccountId" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksAccountId"></a>

```typescript
public readonly eksAccountId: string;
```

- *Type:* string

---

##### `eksIntegrationEnabled`<sup>Required</sup> <a name="eksIntegrationEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksIntegrationEnabled"></a>

```typescript
public readonly eksIntegrationEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `eksSecretAccessKey`<sup>Required</sup> <a name="eksSecretAccessKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.eksSecretAccessKey"></a>

```typescript
public readonly eksSecretAccessKey: string;
```

- *Type:* string

---

##### `elasticsearchAws`<sup>Required</sup> <a name="elasticsearchAws" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAws"></a>

```typescript
public readonly elasticsearchAws: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchAwsAccessKey`<sup>Required</sup> <a name="elasticsearchAwsAccessKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsAccessKey"></a>

```typescript
public readonly elasticsearchAwsAccessKey: string;
```

- *Type:* string

---

##### `elasticsearchAwsRegion`<sup>Required</sup> <a name="elasticsearchAwsRegion" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsRegion"></a>

```typescript
public readonly elasticsearchAwsRegion: string;
```

- *Type:* string

---

##### `elasticsearchAwsSecretAccessKey`<sup>Required</sup> <a name="elasticsearchAwsSecretAccessKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchAwsSecretAccessKey"></a>

```typescript
public readonly elasticsearchAwsSecretAccessKey: string;
```

- *Type:* string

---

##### `elasticsearchIndexedFieldLengthLimit`<sup>Required</sup> <a name="elasticsearchIndexedFieldLengthLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFieldLengthLimit"></a>

```typescript
public readonly elasticsearchIndexedFieldLengthLimit: number;
```

- *Type:* number

---

##### `elasticsearchIndexedFileSizeLimitKb`<sup>Required</sup> <a name="elasticsearchIndexedFileSizeLimitKb" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexedFileSizeLimitKb"></a>

```typescript
public readonly elasticsearchIndexedFileSizeLimitKb: number;
```

- *Type:* number

---

##### `elasticsearchIndexing`<sup>Required</sup> <a name="elasticsearchIndexing" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchIndexing"></a>

```typescript
public readonly elasticsearchIndexing: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchLimitIndexing`<sup>Required</sup> <a name="elasticsearchLimitIndexing" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchLimitIndexing"></a>

```typescript
public readonly elasticsearchLimitIndexing: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchMaxBulkConcurrency`<sup>Required</sup> <a name="elasticsearchMaxBulkConcurrency" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkConcurrency"></a>

```typescript
public readonly elasticsearchMaxBulkConcurrency: number;
```

- *Type:* number

---

##### `elasticsearchMaxBulkSizeMb`<sup>Required</sup> <a name="elasticsearchMaxBulkSizeMb" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchMaxBulkSizeMb"></a>

```typescript
public readonly elasticsearchMaxBulkSizeMb: number;
```

- *Type:* number

---

##### `elasticsearchNamespaceIds`<sup>Required</sup> <a name="elasticsearchNamespaceIds" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchNamespaceIds"></a>

```typescript
public readonly elasticsearchNamespaceIds: string[];
```

- *Type:* string[]

---

##### `elasticsearchPassword`<sup>Required</sup> <a name="elasticsearchPassword" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchPassword"></a>

```typescript
public readonly elasticsearchPassword: string;
```

- *Type:* string

---

##### `elasticsearchProjectIds`<sup>Required</sup> <a name="elasticsearchProjectIds" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchProjectIds"></a>

```typescript
public readonly elasticsearchProjectIds: string[];
```

- *Type:* string[]

---

##### `elasticsearchSearch`<sup>Required</sup> <a name="elasticsearchSearch" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchSearch"></a>

```typescript
public readonly elasticsearchSearch: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `elasticsearchUrl`<sup>Required</sup> <a name="elasticsearchUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUrl"></a>

```typescript
public readonly elasticsearchUrl: string[];
```

- *Type:* string[]

---

##### `elasticsearchUsername`<sup>Required</sup> <a name="elasticsearchUsername" id="@cdktf/provider-gitlab.ApplicationSettings.property.elasticsearchUsername"></a>

```typescript
public readonly elasticsearchUsername: string;
```

- *Type:* string

---

##### `emailAdditionalText`<sup>Required</sup> <a name="emailAdditionalText" id="@cdktf/provider-gitlab.ApplicationSettings.property.emailAdditionalText"></a>

```typescript
public readonly emailAdditionalText: string;
```

- *Type:* string

---

##### `emailAuthorInBody`<sup>Required</sup> <a name="emailAuthorInBody" id="@cdktf/provider-gitlab.ApplicationSettings.property.emailAuthorInBody"></a>

```typescript
public readonly emailAuthorInBody: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `enabledGitAccessProtocol`<sup>Required</sup> <a name="enabledGitAccessProtocol" id="@cdktf/provider-gitlab.ApplicationSettings.property.enabledGitAccessProtocol"></a>

```typescript
public readonly enabledGitAccessProtocol: string;
```

- *Type:* string

---

##### `enforceNamespaceStorageLimit`<sup>Required</sup> <a name="enforceNamespaceStorageLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.enforceNamespaceStorageLimit"></a>

```typescript
public readonly enforceNamespaceStorageLimit: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `enforceTerms`<sup>Required</sup> <a name="enforceTerms" id="@cdktf/provider-gitlab.ApplicationSettings.property.enforceTerms"></a>

```typescript
public readonly enforceTerms: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `externalAuthClientCert`<sup>Required</sup> <a name="externalAuthClientCert" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientCert"></a>

```typescript
public readonly externalAuthClientCert: string;
```

- *Type:* string

---

##### `externalAuthClientKey`<sup>Required</sup> <a name="externalAuthClientKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKey"></a>

```typescript
public readonly externalAuthClientKey: string;
```

- *Type:* string

---

##### `externalAuthClientKeyPass`<sup>Required</sup> <a name="externalAuthClientKeyPass" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthClientKeyPass"></a>

```typescript
public readonly externalAuthClientKeyPass: string;
```

- *Type:* string

---

##### `externalAuthorizationServiceDefaultLabel`<sup>Required</sup> <a name="externalAuthorizationServiceDefaultLabel" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceDefaultLabel"></a>

```typescript
public readonly externalAuthorizationServiceDefaultLabel: string;
```

- *Type:* string

---

##### `externalAuthorizationServiceEnabled`<sup>Required</sup> <a name="externalAuthorizationServiceEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceEnabled"></a>

```typescript
public readonly externalAuthorizationServiceEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `externalAuthorizationServiceTimeout`<sup>Required</sup> <a name="externalAuthorizationServiceTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceTimeout"></a>

```typescript
public readonly externalAuthorizationServiceTimeout: number;
```

- *Type:* number

---

##### `externalAuthorizationServiceUrl`<sup>Required</sup> <a name="externalAuthorizationServiceUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalAuthorizationServiceUrl"></a>

```typescript
public readonly externalAuthorizationServiceUrl: string;
```

- *Type:* string

---

##### `externalPipelineValidationServiceTimeout`<sup>Required</sup> <a name="externalPipelineValidationServiceTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceTimeout"></a>

```typescript
public readonly externalPipelineValidationServiceTimeout: number;
```

- *Type:* number

---

##### `externalPipelineValidationServiceToken`<sup>Required</sup> <a name="externalPipelineValidationServiceToken" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceToken"></a>

```typescript
public readonly externalPipelineValidationServiceToken: string;
```

- *Type:* string

---

##### `externalPipelineValidationServiceUrl`<sup>Required</sup> <a name="externalPipelineValidationServiceUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.externalPipelineValidationServiceUrl"></a>

```typescript
public readonly externalPipelineValidationServiceUrl: string;
```

- *Type:* string

---

##### `fileTemplateProjectId`<sup>Required</sup> <a name="fileTemplateProjectId" id="@cdktf/provider-gitlab.ApplicationSettings.property.fileTemplateProjectId"></a>

```typescript
public readonly fileTemplateProjectId: number;
```

- *Type:* number

---

##### `firstDayOfWeek`<sup>Required</sup> <a name="firstDayOfWeek" id="@cdktf/provider-gitlab.ApplicationSettings.property.firstDayOfWeek"></a>

```typescript
public readonly firstDayOfWeek: number;
```

- *Type:* number

---

##### `geoNodeAllowedIps`<sup>Required</sup> <a name="geoNodeAllowedIps" id="@cdktf/provider-gitlab.ApplicationSettings.property.geoNodeAllowedIps"></a>

```typescript
public readonly geoNodeAllowedIps: string;
```

- *Type:* string

---

##### `geoStatusTimeout`<sup>Required</sup> <a name="geoStatusTimeout" id="@cdktf/provider-gitlab.ApplicationSettings.property.geoStatusTimeout"></a>

```typescript
public readonly geoStatusTimeout: number;
```

- *Type:* number

---

##### `gitalyTimeoutDefault`<sup>Required</sup> <a name="gitalyTimeoutDefault" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutDefault"></a>

```typescript
public readonly gitalyTimeoutDefault: number;
```

- *Type:* number

---

##### `gitalyTimeoutFast`<sup>Required</sup> <a name="gitalyTimeoutFast" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutFast"></a>

```typescript
public readonly gitalyTimeoutFast: number;
```

- *Type:* number

---

##### `gitalyTimeoutMedium`<sup>Required</sup> <a name="gitalyTimeoutMedium" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitalyTimeoutMedium"></a>

```typescript
public readonly gitalyTimeoutMedium: number;
```

- *Type:* number

---

##### `gitRateLimitUsersAllowlist`<sup>Required</sup> <a name="gitRateLimitUsersAllowlist" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitRateLimitUsersAllowlist"></a>

```typescript
public readonly gitRateLimitUsersAllowlist: string[];
```

- *Type:* string[]

---

##### `gitTwoFactorSessionExpiry`<sup>Required</sup> <a name="gitTwoFactorSessionExpiry" id="@cdktf/provider-gitlab.ApplicationSettings.property.gitTwoFactorSessionExpiry"></a>

```typescript
public readonly gitTwoFactorSessionExpiry: number;
```

- *Type:* number

---

##### `grafanaEnabled`<sup>Required</sup> <a name="grafanaEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.grafanaEnabled"></a>

```typescript
public readonly grafanaEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `grafanaUrl`<sup>Required</sup> <a name="grafanaUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.grafanaUrl"></a>

```typescript
public readonly grafanaUrl: string;
```

- *Type:* string

---

##### `gravatarEnabled`<sup>Required</sup> <a name="gravatarEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.gravatarEnabled"></a>

```typescript
public readonly gravatarEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `hashedStorageEnabled`<sup>Required</sup> <a name="hashedStorageEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.hashedStorageEnabled"></a>

```typescript
public readonly hashedStorageEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `helpPageHideCommercialContent`<sup>Required</sup> <a name="helpPageHideCommercialContent" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpPageHideCommercialContent"></a>

```typescript
public readonly helpPageHideCommercialContent: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `helpPageSupportUrl`<sup>Required</sup> <a name="helpPageSupportUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpPageSupportUrl"></a>

```typescript
public readonly helpPageSupportUrl: string;
```

- *Type:* string

---

##### `helpPageText`<sup>Required</sup> <a name="helpPageText" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpPageText"></a>

```typescript
public readonly helpPageText: string;
```

- *Type:* string

---

##### `helpText`<sup>Required</sup> <a name="helpText" id="@cdktf/provider-gitlab.ApplicationSettings.property.helpText"></a>

```typescript
public readonly helpText: string;
```

- *Type:* string

---

##### `hideThirdPartyOffers`<sup>Required</sup> <a name="hideThirdPartyOffers" id="@cdktf/provider-gitlab.ApplicationSettings.property.hideThirdPartyOffers"></a>

```typescript
public readonly hideThirdPartyOffers: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `homePageUrl`<sup>Required</sup> <a name="homePageUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.homePageUrl"></a>

```typescript
public readonly homePageUrl: string;
```

- *Type:* string

---

##### `housekeepingEnabled`<sup>Required</sup> <a name="housekeepingEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingEnabled"></a>

```typescript
public readonly housekeepingEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `housekeepingFullRepackPeriod`<sup>Required</sup> <a name="housekeepingFullRepackPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingFullRepackPeriod"></a>

```typescript
public readonly housekeepingFullRepackPeriod: number;
```

- *Type:* number

---

##### `housekeepingGcPeriod`<sup>Required</sup> <a name="housekeepingGcPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingGcPeriod"></a>

```typescript
public readonly housekeepingGcPeriod: number;
```

- *Type:* number

---

##### `housekeepingIncrementalRepackPeriod`<sup>Required</sup> <a name="housekeepingIncrementalRepackPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.housekeepingIncrementalRepackPeriod"></a>

```typescript
public readonly housekeepingIncrementalRepackPeriod: number;
```

- *Type:* number

---

##### `htmlEmailsEnabled`<sup>Required</sup> <a name="htmlEmailsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.htmlEmailsEnabled"></a>

```typescript
public readonly htmlEmailsEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.ApplicationSettings.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `importSources`<sup>Required</sup> <a name="importSources" id="@cdktf/provider-gitlab.ApplicationSettings.property.importSources"></a>

```typescript
public readonly importSources: string[];
```

- *Type:* string[]

---

##### `inactiveProjectsDeleteAfterMonths`<sup>Required</sup> <a name="inactiveProjectsDeleteAfterMonths" id="@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsDeleteAfterMonths"></a>

```typescript
public readonly inactiveProjectsDeleteAfterMonths: number;
```

- *Type:* number

---

##### `inactiveProjectsMinSizeMb`<sup>Required</sup> <a name="inactiveProjectsMinSizeMb" id="@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsMinSizeMb"></a>

```typescript
public readonly inactiveProjectsMinSizeMb: number;
```

- *Type:* number

---

##### `inactiveProjectsSendWarningEmailAfterMonths`<sup>Required</sup> <a name="inactiveProjectsSendWarningEmailAfterMonths" id="@cdktf/provider-gitlab.ApplicationSettings.property.inactiveProjectsSendWarningEmailAfterMonths"></a>

```typescript
public readonly inactiveProjectsSendWarningEmailAfterMonths: number;
```

- *Type:* number

---

##### `inProductMarketingEmailsEnabled`<sup>Required</sup> <a name="inProductMarketingEmailsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.inProductMarketingEmailsEnabled"></a>

```typescript
public readonly inProductMarketingEmailsEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `invisibleCaptchaEnabled`<sup>Required</sup> <a name="invisibleCaptchaEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.invisibleCaptchaEnabled"></a>

```typescript
public readonly invisibleCaptchaEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `issuesCreateLimit`<sup>Required</sup> <a name="issuesCreateLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.issuesCreateLimit"></a>

```typescript
public readonly issuesCreateLimit: number;
```

- *Type:* number

---

##### `keepLatestArtifact`<sup>Required</sup> <a name="keepLatestArtifact" id="@cdktf/provider-gitlab.ApplicationSettings.property.keepLatestArtifact"></a>

```typescript
public readonly keepLatestArtifact: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `localMarkdownVersion`<sup>Required</sup> <a name="localMarkdownVersion" id="@cdktf/provider-gitlab.ApplicationSettings.property.localMarkdownVersion"></a>

```typescript
public readonly localMarkdownVersion: number;
```

- *Type:* number

---

##### `mailgunEventsEnabled`<sup>Required</sup> <a name="mailgunEventsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.mailgunEventsEnabled"></a>

```typescript
public readonly mailgunEventsEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `mailgunSigningKey`<sup>Required</sup> <a name="mailgunSigningKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.mailgunSigningKey"></a>

```typescript
public readonly mailgunSigningKey: string;
```

- *Type:* string

---

##### `maintenanceMode`<sup>Required</sup> <a name="maintenanceMode" id="@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceMode"></a>

```typescript
public readonly maintenanceMode: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `maintenanceModeMessage`<sup>Required</sup> <a name="maintenanceModeMessage" id="@cdktf/provider-gitlab.ApplicationSettings.property.maintenanceModeMessage"></a>

```typescript
public readonly maintenanceModeMessage: string;
```

- *Type:* string

---

##### `maxArtifactsSize`<sup>Required</sup> <a name="maxArtifactsSize" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxArtifactsSize"></a>

```typescript
public readonly maxArtifactsSize: number;
```

- *Type:* number

---

##### `maxAttachmentSize`<sup>Required</sup> <a name="maxAttachmentSize" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxAttachmentSize"></a>

```typescript
public readonly maxAttachmentSize: number;
```

- *Type:* number

---

##### `maxExportSize`<sup>Required</sup> <a name="maxExportSize" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxExportSize"></a>

```typescript
public readonly maxExportSize: number;
```

- *Type:* number

---

##### `maxImportSize`<sup>Required</sup> <a name="maxImportSize" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxImportSize"></a>

```typescript
public readonly maxImportSize: number;
```

- *Type:* number

---

##### `maxNumberOfRepositoryDownloads`<sup>Required</sup> <a name="maxNumberOfRepositoryDownloads" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloads"></a>

```typescript
public readonly maxNumberOfRepositoryDownloads: number;
```

- *Type:* number

---

##### `maxNumberOfRepositoryDownloadsWithinTimePeriod`<sup>Required</sup> <a name="maxNumberOfRepositoryDownloadsWithinTimePeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxNumberOfRepositoryDownloadsWithinTimePeriod"></a>

```typescript
public readonly maxNumberOfRepositoryDownloadsWithinTimePeriod: number;
```

- *Type:* number

---

##### `maxPagesSize`<sup>Required</sup> <a name="maxPagesSize" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxPagesSize"></a>

```typescript
public readonly maxPagesSize: number;
```

- *Type:* number

---

##### `maxPersonalAccessTokenLifetime`<sup>Required</sup> <a name="maxPersonalAccessTokenLifetime" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxPersonalAccessTokenLifetime"></a>

```typescript
public readonly maxPersonalAccessTokenLifetime: number;
```

- *Type:* number

---

##### `maxSshKeyLifetime`<sup>Required</sup> <a name="maxSshKeyLifetime" id="@cdktf/provider-gitlab.ApplicationSettings.property.maxSshKeyLifetime"></a>

```typescript
public readonly maxSshKeyLifetime: number;
```

- *Type:* number

---

##### `metricsMethodCallThreshold`<sup>Required</sup> <a name="metricsMethodCallThreshold" id="@cdktf/provider-gitlab.ApplicationSettings.property.metricsMethodCallThreshold"></a>

```typescript
public readonly metricsMethodCallThreshold: number;
```

- *Type:* number

---

##### `mirrorAvailable`<sup>Required</sup> <a name="mirrorAvailable" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorAvailable"></a>

```typescript
public readonly mirrorAvailable: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `mirrorCapacityThreshold`<sup>Required</sup> <a name="mirrorCapacityThreshold" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorCapacityThreshold"></a>

```typescript
public readonly mirrorCapacityThreshold: number;
```

- *Type:* number

---

##### `mirrorMaxCapacity`<sup>Required</sup> <a name="mirrorMaxCapacity" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxCapacity"></a>

```typescript
public readonly mirrorMaxCapacity: number;
```

- *Type:* number

---

##### `mirrorMaxDelay`<sup>Required</sup> <a name="mirrorMaxDelay" id="@cdktf/provider-gitlab.ApplicationSettings.property.mirrorMaxDelay"></a>

```typescript
public readonly mirrorMaxDelay: number;
```

- *Type:* number

---

##### `npmPackageRequestsForwarding`<sup>Required</sup> <a name="npmPackageRequestsForwarding" id="@cdktf/provider-gitlab.ApplicationSettings.property.npmPackageRequestsForwarding"></a>

```typescript
public readonly npmPackageRequestsForwarding: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `outboundLocalRequestsWhitelist`<sup>Required</sup> <a name="outboundLocalRequestsWhitelist" id="@cdktf/provider-gitlab.ApplicationSettings.property.outboundLocalRequestsWhitelist"></a>

```typescript
public readonly outboundLocalRequestsWhitelist: string[];
```

- *Type:* string[]

---

##### `packageRegistryCleanupPoliciesWorkerCapacity`<sup>Required</sup> <a name="packageRegistryCleanupPoliciesWorkerCapacity" id="@cdktf/provider-gitlab.ApplicationSettings.property.packageRegistryCleanupPoliciesWorkerCapacity"></a>

```typescript
public readonly packageRegistryCleanupPoliciesWorkerCapacity: number;
```

- *Type:* number

---

##### `pagesDomainVerificationEnabled`<sup>Required</sup> <a name="pagesDomainVerificationEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.pagesDomainVerificationEnabled"></a>

```typescript
public readonly pagesDomainVerificationEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordAuthenticationEnabledForGit`<sup>Required</sup> <a name="passwordAuthenticationEnabledForGit" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForGit"></a>

```typescript
public readonly passwordAuthenticationEnabledForGit: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordAuthenticationEnabledForWeb`<sup>Required</sup> <a name="passwordAuthenticationEnabledForWeb" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordAuthenticationEnabledForWeb"></a>

```typescript
public readonly passwordAuthenticationEnabledForWeb: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordLowercaseRequired`<sup>Required</sup> <a name="passwordLowercaseRequired" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordLowercaseRequired"></a>

```typescript
public readonly passwordLowercaseRequired: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordNumberRequired`<sup>Required</sup> <a name="passwordNumberRequired" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordNumberRequired"></a>

```typescript
public readonly passwordNumberRequired: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordSymbolRequired`<sup>Required</sup> <a name="passwordSymbolRequired" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordSymbolRequired"></a>

```typescript
public readonly passwordSymbolRequired: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `passwordUppercaseRequired`<sup>Required</sup> <a name="passwordUppercaseRequired" id="@cdktf/provider-gitlab.ApplicationSettings.property.passwordUppercaseRequired"></a>

```typescript
public readonly passwordUppercaseRequired: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `performanceBarAllowedGroupPath`<sup>Required</sup> <a name="performanceBarAllowedGroupPath" id="@cdktf/provider-gitlab.ApplicationSettings.property.performanceBarAllowedGroupPath"></a>

```typescript
public readonly performanceBarAllowedGroupPath: string;
```

- *Type:* string

---

##### `personalAccessTokenPrefix`<sup>Required</sup> <a name="personalAccessTokenPrefix" id="@cdktf/provider-gitlab.ApplicationSettings.property.personalAccessTokenPrefix"></a>

```typescript
public readonly personalAccessTokenPrefix: string;
```

- *Type:* string

---

##### `pipelineLimitPerProjectUserSha`<sup>Required</sup> <a name="pipelineLimitPerProjectUserSha" id="@cdktf/provider-gitlab.ApplicationSettings.property.pipelineLimitPerProjectUserSha"></a>

```typescript
public readonly pipelineLimitPerProjectUserSha: number;
```

- *Type:* number

---

##### `plantumlEnabled`<sup>Required</sup> <a name="plantumlEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.plantumlEnabled"></a>

```typescript
public readonly plantumlEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `plantumlUrl`<sup>Required</sup> <a name="plantumlUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.plantumlUrl"></a>

```typescript
public readonly plantumlUrl: string;
```

- *Type:* string

---

##### `pollingIntervalMultiplier`<sup>Required</sup> <a name="pollingIntervalMultiplier" id="@cdktf/provider-gitlab.ApplicationSettings.property.pollingIntervalMultiplier"></a>

```typescript
public readonly pollingIntervalMultiplier: number;
```

- *Type:* number

---

##### `projectExportEnabled`<sup>Required</sup> <a name="projectExportEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.projectExportEnabled"></a>

```typescript
public readonly projectExportEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `prometheusMetricsEnabled`<sup>Required</sup> <a name="prometheusMetricsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.prometheusMetricsEnabled"></a>

```typescript
public readonly prometheusMetricsEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `protectedCiVariables`<sup>Required</sup> <a name="protectedCiVariables" id="@cdktf/provider-gitlab.ApplicationSettings.property.protectedCiVariables"></a>

```typescript
public readonly protectedCiVariables: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `pushEventActivitiesLimit`<sup>Required</sup> <a name="pushEventActivitiesLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.pushEventActivitiesLimit"></a>

```typescript
public readonly pushEventActivitiesLimit: number;
```

- *Type:* number

---

##### `pushEventHooksLimit`<sup>Required</sup> <a name="pushEventHooksLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.pushEventHooksLimit"></a>

```typescript
public readonly pushEventHooksLimit: number;
```

- *Type:* number

---

##### `pypiPackageRequestsForwarding`<sup>Required</sup> <a name="pypiPackageRequestsForwarding" id="@cdktf/provider-gitlab.ApplicationSettings.property.pypiPackageRequestsForwarding"></a>

```typescript
public readonly pypiPackageRequestsForwarding: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `rateLimitingResponseText`<sup>Required</sup> <a name="rateLimitingResponseText" id="@cdktf/provider-gitlab.ApplicationSettings.property.rateLimitingResponseText"></a>

```typescript
public readonly rateLimitingResponseText: string;
```

- *Type:* string

---

##### `rawBlobRequestLimit`<sup>Required</sup> <a name="rawBlobRequestLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.rawBlobRequestLimit"></a>

```typescript
public readonly rawBlobRequestLimit: number;
```

- *Type:* number

---

##### `recaptchaEnabled`<sup>Required</sup> <a name="recaptchaEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaEnabled"></a>

```typescript
public readonly recaptchaEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `recaptchaPrivateKey`<sup>Required</sup> <a name="recaptchaPrivateKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaPrivateKey"></a>

```typescript
public readonly recaptchaPrivateKey: string;
```

- *Type:* string

---

##### `recaptchaSiteKey`<sup>Required</sup> <a name="recaptchaSiteKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.recaptchaSiteKey"></a>

```typescript
public readonly recaptchaSiteKey: string;
```

- *Type:* string

---

##### `receiveMaxInputSize`<sup>Required</sup> <a name="receiveMaxInputSize" id="@cdktf/provider-gitlab.ApplicationSettings.property.receiveMaxInputSize"></a>

```typescript
public readonly receiveMaxInputSize: number;
```

- *Type:* number

---

##### `repositoryChecksEnabled`<sup>Required</sup> <a name="repositoryChecksEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositoryChecksEnabled"></a>

```typescript
public readonly repositoryChecksEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `repositorySizeLimit`<sup>Required</sup> <a name="repositorySizeLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositorySizeLimit"></a>

```typescript
public readonly repositorySizeLimit: number;
```

- *Type:* number

---

##### `repositoryStorages`<sup>Required</sup> <a name="repositoryStorages" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStorages"></a>

```typescript
public readonly repositoryStorages: string[];
```

- *Type:* string[]

---

##### `repositoryStoragesWeighted`<sup>Required</sup> <a name="repositoryStoragesWeighted" id="@cdktf/provider-gitlab.ApplicationSettings.property.repositoryStoragesWeighted"></a>

```typescript
public readonly repositoryStoragesWeighted: {[ key: string ]: number};
```

- *Type:* {[ key: string ]: number}

---

##### `requireAdminApprovalAfterUserSignup`<sup>Required</sup> <a name="requireAdminApprovalAfterUserSignup" id="@cdktf/provider-gitlab.ApplicationSettings.property.requireAdminApprovalAfterUserSignup"></a>

```typescript
public readonly requireAdminApprovalAfterUserSignup: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `requireTwoFactorAuthentication`<sup>Required</sup> <a name="requireTwoFactorAuthentication" id="@cdktf/provider-gitlab.ApplicationSettings.property.requireTwoFactorAuthentication"></a>

```typescript
public readonly requireTwoFactorAuthentication: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `restrictedVisibilityLevels`<sup>Required</sup> <a name="restrictedVisibilityLevels" id="@cdktf/provider-gitlab.ApplicationSettings.property.restrictedVisibilityLevels"></a>

```typescript
public readonly restrictedVisibilityLevels: string[];
```

- *Type:* string[]

---

##### `rsaKeyRestriction`<sup>Required</sup> <a name="rsaKeyRestriction" id="@cdktf/provider-gitlab.ApplicationSettings.property.rsaKeyRestriction"></a>

```typescript
public readonly rsaKeyRestriction: number;
```

- *Type:* number

---

##### `searchRateLimit`<sup>Required</sup> <a name="searchRateLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimit"></a>

```typescript
public readonly searchRateLimit: number;
```

- *Type:* number

---

##### `searchRateLimitUnauthenticated`<sup>Required</sup> <a name="searchRateLimitUnauthenticated" id="@cdktf/provider-gitlab.ApplicationSettings.property.searchRateLimitUnauthenticated"></a>

```typescript
public readonly searchRateLimitUnauthenticated: number;
```

- *Type:* number

---

##### `sendUserConfirmationEmail`<sup>Required</sup> <a name="sendUserConfirmationEmail" id="@cdktf/provider-gitlab.ApplicationSettings.property.sendUserConfirmationEmail"></a>

```typescript
public readonly sendUserConfirmationEmail: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sessionExpireDelay`<sup>Required</sup> <a name="sessionExpireDelay" id="@cdktf/provider-gitlab.ApplicationSettings.property.sessionExpireDelay"></a>

```typescript
public readonly sessionExpireDelay: number;
```

- *Type:* number

---

##### `sharedRunnersEnabled`<sup>Required</sup> <a name="sharedRunnersEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersEnabled"></a>

```typescript
public readonly sharedRunnersEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sharedRunnersMinutes`<sup>Required</sup> <a name="sharedRunnersMinutes" id="@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersMinutes"></a>

```typescript
public readonly sharedRunnersMinutes: number;
```

- *Type:* number

---

##### `sharedRunnersText`<sup>Required</sup> <a name="sharedRunnersText" id="@cdktf/provider-gitlab.ApplicationSettings.property.sharedRunnersText"></a>

```typescript
public readonly sharedRunnersText: string;
```

- *Type:* string

---

##### `sidekiqJobLimiterCompressionThresholdBytes`<sup>Required</sup> <a name="sidekiqJobLimiterCompressionThresholdBytes" id="@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterCompressionThresholdBytes"></a>

```typescript
public readonly sidekiqJobLimiterCompressionThresholdBytes: number;
```

- *Type:* number

---

##### `sidekiqJobLimiterLimitBytes`<sup>Required</sup> <a name="sidekiqJobLimiterLimitBytes" id="@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterLimitBytes"></a>

```typescript
public readonly sidekiqJobLimiterLimitBytes: number;
```

- *Type:* number

---

##### `sidekiqJobLimiterMode`<sup>Required</sup> <a name="sidekiqJobLimiterMode" id="@cdktf/provider-gitlab.ApplicationSettings.property.sidekiqJobLimiterMode"></a>

```typescript
public readonly sidekiqJobLimiterMode: string;
```

- *Type:* string

---

##### `signInText`<sup>Required</sup> <a name="signInText" id="@cdktf/provider-gitlab.ApplicationSettings.property.signInText"></a>

```typescript
public readonly signInText: string;
```

- *Type:* string

---

##### `signupEnabled`<sup>Required</sup> <a name="signupEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.signupEnabled"></a>

```typescript
public readonly signupEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `slackAppEnabled`<sup>Required</sup> <a name="slackAppEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppEnabled"></a>

```typescript
public readonly slackAppEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `slackAppId`<sup>Required</sup> <a name="slackAppId" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppId"></a>

```typescript
public readonly slackAppId: string;
```

- *Type:* string

---

##### `slackAppSecret`<sup>Required</sup> <a name="slackAppSecret" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSecret"></a>

```typescript
public readonly slackAppSecret: string;
```

- *Type:* string

---

##### `slackAppSigningSecret`<sup>Required</sup> <a name="slackAppSigningSecret" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppSigningSecret"></a>

```typescript
public readonly slackAppSigningSecret: string;
```

- *Type:* string

---

##### `slackAppVerificationToken`<sup>Required</sup> <a name="slackAppVerificationToken" id="@cdktf/provider-gitlab.ApplicationSettings.property.slackAppVerificationToken"></a>

```typescript
public readonly slackAppVerificationToken: string;
```

- *Type:* string

---

##### `snippetSizeLimit`<sup>Required</sup> <a name="snippetSizeLimit" id="@cdktf/provider-gitlab.ApplicationSettings.property.snippetSizeLimit"></a>

```typescript
public readonly snippetSizeLimit: number;
```

- *Type:* number

---

##### `snowplowAppId`<sup>Required</sup> <a name="snowplowAppId" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowAppId"></a>

```typescript
public readonly snowplowAppId: string;
```

- *Type:* string

---

##### `snowplowCollectorHostname`<sup>Required</sup> <a name="snowplowCollectorHostname" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCollectorHostname"></a>

```typescript
public readonly snowplowCollectorHostname: string;
```

- *Type:* string

---

##### `snowplowCookieDomain`<sup>Required</sup> <a name="snowplowCookieDomain" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowCookieDomain"></a>

```typescript
public readonly snowplowCookieDomain: string;
```

- *Type:* string

---

##### `snowplowEnabled`<sup>Required</sup> <a name="snowplowEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.snowplowEnabled"></a>

```typescript
public readonly snowplowEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sourcegraphEnabled`<sup>Required</sup> <a name="sourcegraphEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphEnabled"></a>

```typescript
public readonly sourcegraphEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sourcegraphPublicOnly`<sup>Required</sup> <a name="sourcegraphPublicOnly" id="@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphPublicOnly"></a>

```typescript
public readonly sourcegraphPublicOnly: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `sourcegraphUrl`<sup>Required</sup> <a name="sourcegraphUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.sourcegraphUrl"></a>

```typescript
public readonly sourcegraphUrl: string;
```

- *Type:* string

---

##### `spamCheckApiKey`<sup>Required</sup> <a name="spamCheckApiKey" id="@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckApiKey"></a>

```typescript
public readonly spamCheckApiKey: string;
```

- *Type:* string

---

##### `spamCheckEndpointEnabled`<sup>Required</sup> <a name="spamCheckEndpointEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointEnabled"></a>

```typescript
public readonly spamCheckEndpointEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `spamCheckEndpointUrl`<sup>Required</sup> <a name="spamCheckEndpointUrl" id="@cdktf/provider-gitlab.ApplicationSettings.property.spamCheckEndpointUrl"></a>

```typescript
public readonly spamCheckEndpointUrl: string;
```

- *Type:* string

---

##### `suggestPipelineEnabled`<sup>Required</sup> <a name="suggestPipelineEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.suggestPipelineEnabled"></a>

```typescript
public readonly suggestPipelineEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `terminalMaxSessionTime`<sup>Required</sup> <a name="terminalMaxSessionTime" id="@cdktf/provider-gitlab.ApplicationSettings.property.terminalMaxSessionTime"></a>

```typescript
public readonly terminalMaxSessionTime: number;
```

- *Type:* number

---

##### `terms`<sup>Required</sup> <a name="terms" id="@cdktf/provider-gitlab.ApplicationSettings.property.terms"></a>

```typescript
public readonly terms: string;
```

- *Type:* string

---

##### `throttleAuthenticatedApiEnabled`<sup>Required</sup> <a name="throttleAuthenticatedApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiEnabled"></a>

```typescript
public readonly throttleAuthenticatedApiEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleAuthenticatedApiPeriodInSeconds`<sup>Required</sup> <a name="throttleAuthenticatedApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiPeriodInSeconds"></a>

```typescript
public readonly throttleAuthenticatedApiPeriodInSeconds: number;
```

- *Type:* number

---

##### `throttleAuthenticatedApiRequestsPerPeriod`<sup>Required</sup> <a name="throttleAuthenticatedApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedApiRequestsPerPeriod"></a>

```typescript
public readonly throttleAuthenticatedApiRequestsPerPeriod: number;
```

- *Type:* number

---

##### `throttleAuthenticatedPackagesApiEnabled`<sup>Required</sup> <a name="throttleAuthenticatedPackagesApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiEnabled"></a>

```typescript
public readonly throttleAuthenticatedPackagesApiEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleAuthenticatedPackagesApiPeriodInSeconds`<sup>Required</sup> <a name="throttleAuthenticatedPackagesApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiPeriodInSeconds"></a>

```typescript
public readonly throttleAuthenticatedPackagesApiPeriodInSeconds: number;
```

- *Type:* number

---

##### `throttleAuthenticatedPackagesApiRequestsPerPeriod`<sup>Required</sup> <a name="throttleAuthenticatedPackagesApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedPackagesApiRequestsPerPeriod"></a>

```typescript
public readonly throttleAuthenticatedPackagesApiRequestsPerPeriod: number;
```

- *Type:* number

---

##### `throttleAuthenticatedWebEnabled`<sup>Required</sup> <a name="throttleAuthenticatedWebEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebEnabled"></a>

```typescript
public readonly throttleAuthenticatedWebEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleAuthenticatedWebPeriodInSeconds`<sup>Required</sup> <a name="throttleAuthenticatedWebPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebPeriodInSeconds"></a>

```typescript
public readonly throttleAuthenticatedWebPeriodInSeconds: number;
```

- *Type:* number

---

##### `throttleAuthenticatedWebRequestsPerPeriod`<sup>Required</sup> <a name="throttleAuthenticatedWebRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleAuthenticatedWebRequestsPerPeriod"></a>

```typescript
public readonly throttleAuthenticatedWebRequestsPerPeriod: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedApiEnabled`<sup>Required</sup> <a name="throttleUnauthenticatedApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiEnabled"></a>

```typescript
public readonly throttleUnauthenticatedApiEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleUnauthenticatedApiPeriodInSeconds`<sup>Required</sup> <a name="throttleUnauthenticatedApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiPeriodInSeconds"></a>

```typescript
public readonly throttleUnauthenticatedApiPeriodInSeconds: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedApiRequestsPerPeriod`<sup>Required</sup> <a name="throttleUnauthenticatedApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedApiRequestsPerPeriod"></a>

```typescript
public readonly throttleUnauthenticatedApiRequestsPerPeriod: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedPackagesApiEnabled`<sup>Required</sup> <a name="throttleUnauthenticatedPackagesApiEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiEnabled"></a>

```typescript
public readonly throttleUnauthenticatedPackagesApiEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleUnauthenticatedPackagesApiPeriodInSeconds`<sup>Required</sup> <a name="throttleUnauthenticatedPackagesApiPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiPeriodInSeconds"></a>

```typescript
public readonly throttleUnauthenticatedPackagesApiPeriodInSeconds: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedPackagesApiRequestsPerPeriod`<sup>Required</sup> <a name="throttleUnauthenticatedPackagesApiRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedPackagesApiRequestsPerPeriod"></a>

```typescript
public readonly throttleUnauthenticatedPackagesApiRequestsPerPeriod: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedWebEnabled`<sup>Required</sup> <a name="throttleUnauthenticatedWebEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebEnabled"></a>

```typescript
public readonly throttleUnauthenticatedWebEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `throttleUnauthenticatedWebPeriodInSeconds`<sup>Required</sup> <a name="throttleUnauthenticatedWebPeriodInSeconds" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebPeriodInSeconds"></a>

```typescript
public readonly throttleUnauthenticatedWebPeriodInSeconds: number;
```

- *Type:* number

---

##### `throttleUnauthenticatedWebRequestsPerPeriod`<sup>Required</sup> <a name="throttleUnauthenticatedWebRequestsPerPeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.throttleUnauthenticatedWebRequestsPerPeriod"></a>

```typescript
public readonly throttleUnauthenticatedWebRequestsPerPeriod: number;
```

- *Type:* number

---

##### `timeTrackingLimitToHours`<sup>Required</sup> <a name="timeTrackingLimitToHours" id="@cdktf/provider-gitlab.ApplicationSettings.property.timeTrackingLimitToHours"></a>

```typescript
public readonly timeTrackingLimitToHours: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `twoFactorGracePeriod`<sup>Required</sup> <a name="twoFactorGracePeriod" id="@cdktf/provider-gitlab.ApplicationSettings.property.twoFactorGracePeriod"></a>

```typescript
public readonly twoFactorGracePeriod: number;
```

- *Type:* number

---

##### `uniqueIpsLimitEnabled`<sup>Required</sup> <a name="uniqueIpsLimitEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitEnabled"></a>

```typescript
public readonly uniqueIpsLimitEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `uniqueIpsLimitPerUser`<sup>Required</sup> <a name="uniqueIpsLimitPerUser" id="@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitPerUser"></a>

```typescript
public readonly uniqueIpsLimitPerUser: number;
```

- *Type:* number

---

##### `uniqueIpsLimitTimeWindow`<sup>Required</sup> <a name="uniqueIpsLimitTimeWindow" id="@cdktf/provider-gitlab.ApplicationSettings.property.uniqueIpsLimitTimeWindow"></a>

```typescript
public readonly uniqueIpsLimitTimeWindow: number;
```

- *Type:* number

---

##### `usagePingEnabled`<sup>Required</sup> <a name="usagePingEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.usagePingEnabled"></a>

```typescript
public readonly usagePingEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userDeactivationEmailsEnabled`<sup>Required</sup> <a name="userDeactivationEmailsEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.userDeactivationEmailsEnabled"></a>

```typescript
public readonly userDeactivationEmailsEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userDefaultExternal`<sup>Required</sup> <a name="userDefaultExternal" id="@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultExternal"></a>

```typescript
public readonly userDefaultExternal: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userDefaultInternalRegex`<sup>Required</sup> <a name="userDefaultInternalRegex" id="@cdktf/provider-gitlab.ApplicationSettings.property.userDefaultInternalRegex"></a>

```typescript
public readonly userDefaultInternalRegex: string;
```

- *Type:* string

---

##### `userOauthApplications`<sup>Required</sup> <a name="userOauthApplications" id="@cdktf/provider-gitlab.ApplicationSettings.property.userOauthApplications"></a>

```typescript
public readonly userOauthApplications: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `userShowAddSshKeyMessage`<sup>Required</sup> <a name="userShowAddSshKeyMessage" id="@cdktf/provider-gitlab.ApplicationSettings.property.userShowAddSshKeyMessage"></a>

```typescript
public readonly userShowAddSshKeyMessage: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `versionCheckEnabled`<sup>Required</sup> <a name="versionCheckEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.versionCheckEnabled"></a>

```typescript
public readonly versionCheckEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `webIdeClientsidePreviewEnabled`<sup>Required</sup> <a name="webIdeClientsidePreviewEnabled" id="@cdktf/provider-gitlab.ApplicationSettings.property.webIdeClientsidePreviewEnabled"></a>

```typescript
public readonly webIdeClientsidePreviewEnabled: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `whatsNewVariant`<sup>Required</sup> <a name="whatsNewVariant" id="@cdktf/provider-gitlab.ApplicationSettings.property.whatsNewVariant"></a>

```typescript
public readonly whatsNewVariant: string;
```

- *Type:* string

---

##### `wikiPageMaxContentBytes`<sup>Required</sup> <a name="wikiPageMaxContentBytes" id="@cdktf/provider-gitlab.ApplicationSettings.property.wikiPageMaxContentBytes"></a>

```typescript
public readonly wikiPageMaxContentBytes: number;
```

- *Type:* number

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ApplicationSettings.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.ApplicationSettings.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### Branch <a name="Branch" id="@cdktf/provider-gitlab.Branch"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/branch gitlab_branch}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.Branch.Initializer"></a>

```typescript
import { Branch } from '@cdktf/provider-gitlab'

new Branch(scope: Construct, id: string, config: BranchConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.Branch.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.Branch.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.Branch.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.BranchConfig">BranchConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.Branch.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.Branch.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.Branch.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.BranchConfig">BranchConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.Branch.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.Branch.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.Branch.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.Branch.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.Branch.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.Branch.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.Branch.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.Branch.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.Branch.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.Branch.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.Branch.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.Branch.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.Branch.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.Branch.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.Branch.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.Branch.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.Branch.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.Branch.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.Branch.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.Branch.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.Branch.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.Branch.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.Branch.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.Branch.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.Branch.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.Branch.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.Branch.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.Branch.isConstruct"></a>

```typescript
import { Branch } from '@cdktf/provider-gitlab'

Branch.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.Branch.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.connection">connection</a></code> | <code>cdktf.SSHProvisionerConnection \| cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.provisioners">provisioners</a></code> | <code>cdktf.FileProvisioner \| cdktf.LocalExecProvisioner \| cdktf.RemoteExecProvisioner[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.canPush">canPush</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.commit">commit</a></code> | <code><a href="#@cdktf/provider-gitlab.BranchCommitList">BranchCommitList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.default">default</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.developerCanMerge">developerCanMerge</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.developerCanPush">developerCanPush</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.merged">merged</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.protected">protected</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.webUrl">webUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.refInput">refInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.project">project</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.ref">ref</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.Branch.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.Branch.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.Branch.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.Branch.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.Branch.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.Branch.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.Branch.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-gitlab.Branch.property.connection"></a>

```typescript
public readonly connection: SSHProvisionerConnection | WinrmProvisionerConnection;
```

- *Type:* cdktf.SSHProvisionerConnection | cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.Branch.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.Branch.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.Branch.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.Branch.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.Branch.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-gitlab.Branch.property.provisioners"></a>

```typescript
public readonly provisioners: FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner[];
```

- *Type:* cdktf.FileProvisioner | cdktf.LocalExecProvisioner | cdktf.RemoteExecProvisioner[]

---

##### `canPush`<sup>Required</sup> <a name="canPush" id="@cdktf/provider-gitlab.Branch.property.canPush"></a>

```typescript
public readonly canPush: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `commit`<sup>Required</sup> <a name="commit" id="@cdktf/provider-gitlab.Branch.property.commit"></a>

```typescript
public readonly commit: BranchCommitList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.BranchCommitList">BranchCommitList</a>

---

##### `default`<sup>Required</sup> <a name="default" id="@cdktf/provider-gitlab.Branch.property.default"></a>

```typescript
public readonly default: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `developerCanMerge`<sup>Required</sup> <a name="developerCanMerge" id="@cdktf/provider-gitlab.Branch.property.developerCanMerge"></a>

```typescript
public readonly developerCanMerge: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `developerCanPush`<sup>Required</sup> <a name="developerCanPush" id="@cdktf/provider-gitlab.Branch.property.developerCanPush"></a>

```typescript
public readonly developerCanPush: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `merged`<sup>Required</sup> <a name="merged" id="@cdktf/provider-gitlab.Branch.property.merged"></a>

```typescript
public readonly merged: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `protected`<sup>Required</sup> <a name="protected" id="@cdktf/provider-gitlab.Branch.property.protected"></a>

```typescript
public readonly protected: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `webUrl`<sup>Required</sup> <a name="webUrl" id="@cdktf/provider-gitlab.Branch.property.webUrl"></a>

```typescript
public readonly webUrl: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.Branch.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-gitlab.Branch.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.Branch.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `refInput`<sup>Optional</sup> <a name="refInput" id="@cdktf/provider-gitlab.Branch.property.refInput"></a>

```typescript
public readonly refInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.Branch.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.Branch.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.Branch.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

##### `ref`<sup>Required</sup> <a name="ref" id="@cdktf/provider-gitlab.Branch.property.ref"></a>

```typescript
public readonly ref: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.Branch.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.Branch.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### BranchProtection <a name="BranchProtection" id="@cdktf/provider-gitlab.BranchProtection"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/branch_protection gitlab_branch_protection}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.BranchProtection.Initializer"></a>

```typescript
import { BranchProtection } from '@cdktf/provider-gitlab'

new BranchProtection(scope: Construct, id: string, config: BranchProtectionConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.BranchProtectionConfig">BranchProtectionConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.BranchProtection.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.BranchProtection.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.BranchProtection.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.BranchProtectionConfig">BranchProtectionConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.putAllowedToMerge">putAllowedToMerge</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.putAllowedToPush">putAllowedToPush</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.putAllowedToUnprotect">putAllowedToUnprotect</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetAllowedToMerge">resetAllowedToMerge</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetAllowedToPush">resetAllowedToPush</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetAllowedToUnprotect">resetAllowedToUnprotect</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetAllowForcePush">resetAllowForcePush</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetCodeOwnerApprovalRequired">resetCodeOwnerApprovalRequired</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetMergeAccessLevel">resetMergeAccessLevel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetPushAccessLevel">resetPushAccessLevel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.resetUnprotectAccessLevel">resetUnprotectAccessLevel</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.BranchProtection.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.BranchProtection.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.BranchProtection.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.BranchProtection.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.BranchProtection.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.BranchProtection.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.BranchProtection.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.BranchProtection.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.BranchProtection.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.BranchProtection.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.BranchProtection.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.BranchProtection.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.BranchProtection.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.BranchProtection.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.BranchProtection.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.BranchProtection.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.BranchProtection.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.BranchProtection.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.BranchProtection.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.BranchProtection.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `putAllowedToMerge` <a name="putAllowedToMerge" id="@cdktf/provider-gitlab.BranchProtection.putAllowedToMerge"></a>

```typescript
public putAllowedToMerge(value: IResolvable | BranchProtectionAllowedToMerge[]): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.BranchProtection.putAllowedToMerge.parameter.value"></a>

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToMerge">BranchProtectionAllowedToMerge</a>[]

---

##### `putAllowedToPush` <a name="putAllowedToPush" id="@cdktf/provider-gitlab.BranchProtection.putAllowedToPush"></a>

```typescript
public putAllowedToPush(value: IResolvable | BranchProtectionAllowedToPush[]): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.BranchProtection.putAllowedToPush.parameter.value"></a>

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToPush">BranchProtectionAllowedToPush</a>[]

---

##### `putAllowedToUnprotect` <a name="putAllowedToUnprotect" id="@cdktf/provider-gitlab.BranchProtection.putAllowedToUnprotect"></a>

```typescript
public putAllowedToUnprotect(value: IResolvable | BranchProtectionAllowedToUnprotect[]): void
```

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.BranchProtection.putAllowedToUnprotect.parameter.value"></a>

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToUnprotect">BranchProtectionAllowedToUnprotect</a>[]

---

##### `resetAllowedToMerge` <a name="resetAllowedToMerge" id="@cdktf/provider-gitlab.BranchProtection.resetAllowedToMerge"></a>

```typescript
public resetAllowedToMerge(): void
```

##### `resetAllowedToPush` <a name="resetAllowedToPush" id="@cdktf/provider-gitlab.BranchProtection.resetAllowedToPush"></a>

```typescript
public resetAllowedToPush(): void
```

##### `resetAllowedToUnprotect` <a name="resetAllowedToUnprotect" id="@cdktf/provider-gitlab.BranchProtection.resetAllowedToUnprotect"></a>

```typescript
public resetAllowedToUnprotect(): void
```

##### `resetAllowForcePush` <a name="resetAllowForcePush" id="@cdktf/provider-gitlab.BranchProtection.resetAllowForcePush"></a>

```typescript
public resetAllowForcePush(): void
```

##### `resetCodeOwnerApprovalRequired` <a name="resetCodeOwnerApprovalRequired" id="@cdktf/provider-gitlab.BranchProtection.resetCodeOwnerApprovalRequired"></a>

```typescript
public resetCodeOwnerApprovalRequired(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.BranchProtection.resetId"></a>

```typescript
public resetId(): void
```

##### `resetMergeAccessLevel` <a name="resetMergeAccessLevel" id="@cdktf/provider-gitlab.BranchProtection.resetMergeAccessLevel"></a>

```typescript
public resetMergeAccessLevel(): void
```

##### `resetPushAccessLevel` <a name="resetPushAccessLevel" id="@cdktf/provider-gitlab.BranchProtection.resetPushAccessLevel"></a>

```typescript
public resetPushAccessLevel(): void
```

##### `resetUnprotectAccessLevel` <a name="resetUnprotectAccessLevel" id="@cdktf/provider-gitlab.BranchProtection.resetUnprotectAccessLevel"></a>

```typescript
public resetUnprotectAccessLevel(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.BranchProtection.isConstruct"></a>

```typescript
import { BranchProtection } from '@cdktf/provider-gitlab'

BranchProtection.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.BranchProtection.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.connection">connection</a></code> | <code>cdktf.SSHProvisionerConnection \| cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.provisioners">provisioners</a></code> | <code>cdktf.FileProvisioner \| cdktf.LocalExecProvisioner \| cdktf.RemoteExecProvisioner[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowedToMerge">allowedToMerge</a></code> | <code><a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToMergeList">BranchProtectionAllowedToMergeList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowedToPush">allowedToPush</a></code> | <code><a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToPushList">BranchProtectionAllowedToPushList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowedToUnprotect">allowedToUnprotect</a></code> | <code><a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToUnprotectList">BranchProtectionAllowedToUnprotectList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.branchProtectionId">branchProtectionId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowedToMergeInput">allowedToMergeInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToMerge">BranchProtectionAllowedToMerge</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowedToPushInput">allowedToPushInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToPush">BranchProtectionAllowedToPush</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowedToUnprotectInput">allowedToUnprotectInput</a></code> | <code>cdktf.IResolvable \| <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToUnprotect">BranchProtectionAllowedToUnprotect</a>[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowForcePushInput">allowForcePushInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.branchInput">branchInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.codeOwnerApprovalRequiredInput">codeOwnerApprovalRequiredInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.mergeAccessLevelInput">mergeAccessLevelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.pushAccessLevelInput">pushAccessLevelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.unprotectAccessLevelInput">unprotectAccessLevelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.allowForcePush">allowForcePush</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.branch">branch</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.codeOwnerApprovalRequired">codeOwnerApprovalRequired</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.mergeAccessLevel">mergeAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.project">project</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.pushAccessLevel">pushAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.unprotectAccessLevel">unprotectAccessLevel</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.BranchProtection.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.BranchProtection.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.BranchProtection.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.BranchProtection.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.BranchProtection.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.BranchProtection.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.BranchProtection.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-gitlab.BranchProtection.property.connection"></a>

```typescript
public readonly connection: SSHProvisionerConnection | WinrmProvisionerConnection;
```

- *Type:* cdktf.SSHProvisionerConnection | cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.BranchProtection.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.BranchProtection.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.BranchProtection.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.BranchProtection.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.BranchProtection.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-gitlab.BranchProtection.property.provisioners"></a>

```typescript
public readonly provisioners: FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner[];
```

- *Type:* cdktf.FileProvisioner | cdktf.LocalExecProvisioner | cdktf.RemoteExecProvisioner[]

---

##### `allowedToMerge`<sup>Required</sup> <a name="allowedToMerge" id="@cdktf/provider-gitlab.BranchProtection.property.allowedToMerge"></a>

```typescript
public readonly allowedToMerge: BranchProtectionAllowedToMergeList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToMergeList">BranchProtectionAllowedToMergeList</a>

---

##### `allowedToPush`<sup>Required</sup> <a name="allowedToPush" id="@cdktf/provider-gitlab.BranchProtection.property.allowedToPush"></a>

```typescript
public readonly allowedToPush: BranchProtectionAllowedToPushList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToPushList">BranchProtectionAllowedToPushList</a>

---

##### `allowedToUnprotect`<sup>Required</sup> <a name="allowedToUnprotect" id="@cdktf/provider-gitlab.BranchProtection.property.allowedToUnprotect"></a>

```typescript
public readonly allowedToUnprotect: BranchProtectionAllowedToUnprotectList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToUnprotectList">BranchProtectionAllowedToUnprotectList</a>

---

##### `branchProtectionId`<sup>Required</sup> <a name="branchProtectionId" id="@cdktf/provider-gitlab.BranchProtection.property.branchProtectionId"></a>

```typescript
public readonly branchProtectionId: number;
```

- *Type:* number

---

##### `allowedToMergeInput`<sup>Optional</sup> <a name="allowedToMergeInput" id="@cdktf/provider-gitlab.BranchProtection.property.allowedToMergeInput"></a>

```typescript
public readonly allowedToMergeInput: IResolvable | BranchProtectionAllowedToMerge[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToMerge">BranchProtectionAllowedToMerge</a>[]

---

##### `allowedToPushInput`<sup>Optional</sup> <a name="allowedToPushInput" id="@cdktf/provider-gitlab.BranchProtection.property.allowedToPushInput"></a>

```typescript
public readonly allowedToPushInput: IResolvable | BranchProtectionAllowedToPush[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToPush">BranchProtectionAllowedToPush</a>[]

---

##### `allowedToUnprotectInput`<sup>Optional</sup> <a name="allowedToUnprotectInput" id="@cdktf/provider-gitlab.BranchProtection.property.allowedToUnprotectInput"></a>

```typescript
public readonly allowedToUnprotectInput: IResolvable | BranchProtectionAllowedToUnprotect[];
```

- *Type:* cdktf.IResolvable | <a href="#@cdktf/provider-gitlab.BranchProtectionAllowedToUnprotect">BranchProtectionAllowedToUnprotect</a>[]

---

##### `allowForcePushInput`<sup>Optional</sup> <a name="allowForcePushInput" id="@cdktf/provider-gitlab.BranchProtection.property.allowForcePushInput"></a>

```typescript
public readonly allowForcePushInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `branchInput`<sup>Optional</sup> <a name="branchInput" id="@cdktf/provider-gitlab.BranchProtection.property.branchInput"></a>

```typescript
public readonly branchInput: string;
```

- *Type:* string

---

##### `codeOwnerApprovalRequiredInput`<sup>Optional</sup> <a name="codeOwnerApprovalRequiredInput" id="@cdktf/provider-gitlab.BranchProtection.property.codeOwnerApprovalRequiredInput"></a>

```typescript
public readonly codeOwnerApprovalRequiredInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.BranchProtection.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `mergeAccessLevelInput`<sup>Optional</sup> <a name="mergeAccessLevelInput" id="@cdktf/provider-gitlab.BranchProtection.property.mergeAccessLevelInput"></a>

```typescript
public readonly mergeAccessLevelInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.BranchProtection.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `pushAccessLevelInput`<sup>Optional</sup> <a name="pushAccessLevelInput" id="@cdktf/provider-gitlab.BranchProtection.property.pushAccessLevelInput"></a>

```typescript
public readonly pushAccessLevelInput: string;
```

- *Type:* string

---

##### `unprotectAccessLevelInput`<sup>Optional</sup> <a name="unprotectAccessLevelInput" id="@cdktf/provider-gitlab.BranchProtection.property.unprotectAccessLevelInput"></a>

```typescript
public readonly unprotectAccessLevelInput: string;
```

- *Type:* string

---

##### `allowForcePush`<sup>Required</sup> <a name="allowForcePush" id="@cdktf/provider-gitlab.BranchProtection.property.allowForcePush"></a>

```typescript
public readonly allowForcePush: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `branch`<sup>Required</sup> <a name="branch" id="@cdktf/provider-gitlab.BranchProtection.property.branch"></a>

```typescript
public readonly branch: string;
```

- *Type:* string

---

##### `codeOwnerApprovalRequired`<sup>Required</sup> <a name="codeOwnerApprovalRequired" id="@cdktf/provider-gitlab.BranchProtection.property.codeOwnerApprovalRequired"></a>

```typescript
public readonly codeOwnerApprovalRequired: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.BranchProtection.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `mergeAccessLevel`<sup>Required</sup> <a name="mergeAccessLevel" id="@cdktf/provider-gitlab.BranchProtection.property.mergeAccessLevel"></a>

```typescript
public readonly mergeAccessLevel: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.BranchProtection.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

##### `pushAccessLevel`<sup>Required</sup> <a name="pushAccessLevel" id="@cdktf/provider-gitlab.BranchProtection.property.pushAccessLevel"></a>

```typescript
public readonly pushAccessLevel: string;
```

- *Type:* string

---

##### `unprotectAccessLevel`<sup>Required</sup> <a name="unprotectAccessLevel" id="@cdktf/provider-gitlab.BranchProtection.property.unprotectAccessLevel"></a>

```typescript
public readonly unprotectAccessLevel: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.BranchProtection.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.BranchProtection.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ClusterAgent <a name="ClusterAgent" id="@cdktf/provider-gitlab.ClusterAgent"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/cluster_agent gitlab_cluster_agent}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.ClusterAgent.Initializer"></a>

```typescript
import { ClusterAgent } from '@cdktf/provider-gitlab'

new ClusterAgent(scope: Construct, id: string, config: ClusterAgentConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.ClusterAgentConfig">ClusterAgentConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.ClusterAgent.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.ClusterAgent.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.ClusterAgent.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.ClusterAgentConfig">ClusterAgentConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.ClusterAgent.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.ClusterAgent.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.ClusterAgent.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.ClusterAgent.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.ClusterAgent.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.ClusterAgent.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.ClusterAgent.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.ClusterAgent.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.ClusterAgent.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.ClusterAgent.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgent.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.ClusterAgent.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.ClusterAgent.isConstruct"></a>

```typescript
import { ClusterAgent } from '@cdktf/provider-gitlab'

ClusterAgent.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.ClusterAgent.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.connection">connection</a></code> | <code>cdktf.SSHProvisionerConnection \| cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.provisioners">provisioners</a></code> | <code>cdktf.FileProvisioner \| cdktf.LocalExecProvisioner \| cdktf.RemoteExecProvisioner[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.agentId">agentId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.createdAt">createdAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.createdByUserId">createdByUserId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.ClusterAgent.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.ClusterAgent.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.ClusterAgent.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.ClusterAgent.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.ClusterAgent.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.ClusterAgent.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.ClusterAgent.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-gitlab.ClusterAgent.property.connection"></a>

```typescript
public readonly connection: SSHProvisionerConnection | WinrmProvisionerConnection;
```

- *Type:* cdktf.SSHProvisionerConnection | cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.ClusterAgent.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.ClusterAgent.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.ClusterAgent.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.ClusterAgent.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.ClusterAgent.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-gitlab.ClusterAgent.property.provisioners"></a>

```typescript
public readonly provisioners: FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner[];
```

- *Type:* cdktf.FileProvisioner | cdktf.LocalExecProvisioner | cdktf.RemoteExecProvisioner[]

---

##### `agentId`<sup>Required</sup> <a name="agentId" id="@cdktf/provider-gitlab.ClusterAgent.property.agentId"></a>

```typescript
public readonly agentId: number;
```

- *Type:* number

---

##### `createdAt`<sup>Required</sup> <a name="createdAt" id="@cdktf/provider-gitlab.ClusterAgent.property.createdAt"></a>

```typescript
public readonly createdAt: string;
```

- *Type:* string

---

##### `createdByUserId`<sup>Required</sup> <a name="createdByUserId" id="@cdktf/provider-gitlab.ClusterAgent.property.createdByUserId"></a>

```typescript
public readonly createdByUserId: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.ClusterAgent.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-gitlab.ClusterAgent.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.ClusterAgent.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.ClusterAgent.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.ClusterAgent.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.ClusterAgent.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgent.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.ClusterAgent.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### ClusterAgentToken <a name="ClusterAgentToken" id="@cdktf/provider-gitlab.ClusterAgentToken"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/cluster_agent_token gitlab_cluster_agent_token}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.ClusterAgentToken.Initializer"></a>

```typescript
import { ClusterAgentToken } from '@cdktf/provider-gitlab'

new ClusterAgentToken(scope: Construct, id: string, config: ClusterAgentTokenConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.ClusterAgentTokenConfig">ClusterAgentTokenConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.ClusterAgentToken.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.ClusterAgentToken.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.ClusterAgentToken.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.ClusterAgentTokenConfig">ClusterAgentTokenConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.resetDescription">resetDescription</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.ClusterAgentToken.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.ClusterAgentToken.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.ClusterAgentToken.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.ClusterAgentToken.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.ClusterAgentToken.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.ClusterAgentToken.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.ClusterAgentToken.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.ClusterAgentToken.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.ClusterAgentToken.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.ClusterAgentToken.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetDescription` <a name="resetDescription" id="@cdktf/provider-gitlab.ClusterAgentToken.resetDescription"></a>

```typescript
public resetDescription(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.ClusterAgentToken.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.ClusterAgentToken.isConstruct"></a>

```typescript
import { ClusterAgentToken } from '@cdktf/provider-gitlab'

ClusterAgentToken.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.ClusterAgentToken.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.connection">connection</a></code> | <code>cdktf.SSHProvisionerConnection \| cdktf.WinrmProvisionerConnection</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.provisioners">provisioners</a></code> | <code>cdktf.FileProvisioner \| cdktf.LocalExecProvisioner \| cdktf.RemoteExecProvisioner[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.createdAt">createdAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.createdByUserId">createdByUserId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.lastUsedAt">lastUsedAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.status">status</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.token">token</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.tokenId">tokenId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.agentIdInput">agentIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.descriptionInput">descriptionInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.agentId">agentId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.ClusterAgentToken.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.ClusterAgentToken.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.ClusterAgentToken.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.ClusterAgentToken.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.ClusterAgentToken.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.ClusterAgentToken.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.ClusterAgentToken.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `connection`<sup>Optional</sup> <a name="connection" id="@cdktf/provider-gitlab.ClusterAgentToken.property.connection"></a>

```typescript
public readonly connection: SSHProvisionerConnection | WinrmProvisionerConnection;
```

- *Type:* cdktf.SSHProvisionerConnection | cdktf.WinrmProvisionerConnection

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.ClusterAgentToken.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.ClusterAgentToken.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.ClusterAgentToken.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.ClusterAgentToken.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.ClusterAgentToken.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `provisioners`<sup>Optional</sup> <a name="provisioners" id="@cdktf/provider-gitlab.ClusterAgentToken.property.provisioners"></a>

```typescript
public readonly provisioners: FileProvisioner | LocalExecProvisioner | RemoteExecProvisioner[];
```

- *Type:* cdktf.FileProvisioner | cdktf.LocalExecProvisioner | cdktf.RemoteExecProvisioner[]

---

##### `createdAt`<sup>Required</sup> <a name="createdAt" id="@cdktf/provider-gitlab.ClusterAgentToken.property.createdAt"></a>

```typescript
public readonly createdAt: string;
```

- *Type:* string

---

##### `createdByUserId`<sup>Required</sup> <a name="createdByUserId" id="@cdktf/provider-gitlab.ClusterAgentToken.property.createdByUserId"></a>

```typescript
public readonly createdByUserId: number;
```

- *Type:* number

---

##### `lastUsedAt`<sup>Required</sup> <a name="lastUsedAt" id="@cdktf/provider-gitlab.ClusterAgentToken.property.lastUsedAt"></a>

```typescript
public readonly lastUsedAt: string;
```

- *Type:* string

---

##### `status`<sup>Required</sup> <a name="status" id="@cdktf/provider-gitlab.ClusterAgentToken.property.status"></a>

```typescript
public readonly status: string;
```

- *Type:* string

---

##### `token`<sup>Required</sup> <a name="token" id="@cdktf/provider-gitlab.ClusterAgentToken.property.token"></a>

```typescript
public readonly token: string;
```

- *Type:* string

---

##### `tokenId`<sup>Required</sup> <a name="tokenId" id="@cdktf/provider-gitlab.ClusterAgentToken.property.tokenId"></a>

```typescript
public readonly tokenId: number;
```

- *Type:* number

---

##### `agentIdInput`<sup>Optional</sup> <a name="agentIdInput" id="@cdktf/provider-gitlab.ClusterAgentToken.property.agentIdInput"></a>

```typescript
public readonly agentIdInput: number;
```

- *Type:* number

---

##### `descriptionInput`<sup>Optional</sup> <a name="descriptionInput" id="@cdktf/provider-gitlab.ClusterAgentToken.property.descriptionInput"></a>

```typescript
public readonly descriptionInput: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.ClusterAgentToken.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-gitlab.ClusterAgentToken.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.ClusterAgentToken.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `agentId`<sup>Required</sup> <a name="agentId" id="@cdktf/provider-gitlab.ClusterAgentToken.property.agentId"></a>

```typescript
public readonly agentId: number;
```

- *Type:* number

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-gitlab.ClusterAgentToken.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.ClusterAgentToken.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.ClusterAgentToken.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.ClusterAgentToken.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.ClusterAgentToken.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.ClusterAgentToken.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabBranch <a name="DataGitlabBranch" id="@cdktf/provider-gitlab.DataGitlabBranch"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/branch gitlab_branch}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabBranch.Initializer"></a>

```typescript
import { DataGitlabBranch } from '@cdktf/provider-gitlab'

new DataGitlabBranch(scope: Construct, id: string, config: DataGitlabBranchConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabBranchConfig">DataGitlabBranchConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabBranch.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabBranch.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabBranch.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabBranchConfig">DataGitlabBranchConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabBranch.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabBranch.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabBranch.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabBranch.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabBranch.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabBranch.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabBranch.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabBranch.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabBranch.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabBranch.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabBranch.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabBranch.isConstruct"></a>

```typescript
import { DataGitlabBranch } from '@cdktf/provider-gitlab'

DataGitlabBranch.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabBranch.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.canPush">canPush</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.commit">commit</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabBranchCommitList">DataGitlabBranchCommitList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.default">default</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.developerCanMerge">developerCanMerge</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.developerCanPush">developerCanPush</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.merged">merged</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.protected">protected</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.webUrl">webUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabBranch.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabBranch.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabBranch.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabBranch.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabBranch.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabBranch.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabBranch.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabBranch.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabBranch.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabBranch.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabBranch.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabBranch.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `canPush`<sup>Required</sup> <a name="canPush" id="@cdktf/provider-gitlab.DataGitlabBranch.property.canPush"></a>

```typescript
public readonly canPush: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `commit`<sup>Required</sup> <a name="commit" id="@cdktf/provider-gitlab.DataGitlabBranch.property.commit"></a>

```typescript
public readonly commit: DataGitlabBranchCommitList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabBranchCommitList">DataGitlabBranchCommitList</a>

---

##### `default`<sup>Required</sup> <a name="default" id="@cdktf/provider-gitlab.DataGitlabBranch.property.default"></a>

```typescript
public readonly default: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `developerCanMerge`<sup>Required</sup> <a name="developerCanMerge" id="@cdktf/provider-gitlab.DataGitlabBranch.property.developerCanMerge"></a>

```typescript
public readonly developerCanMerge: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `developerCanPush`<sup>Required</sup> <a name="developerCanPush" id="@cdktf/provider-gitlab.DataGitlabBranch.property.developerCanPush"></a>

```typescript
public readonly developerCanPush: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `merged`<sup>Required</sup> <a name="merged" id="@cdktf/provider-gitlab.DataGitlabBranch.property.merged"></a>

```typescript
public readonly merged: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `protected`<sup>Required</sup> <a name="protected" id="@cdktf/provider-gitlab.DataGitlabBranch.property.protected"></a>

```typescript
public readonly protected: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `webUrl`<sup>Required</sup> <a name="webUrl" id="@cdktf/provider-gitlab.DataGitlabBranch.property.webUrl"></a>

```typescript
public readonly webUrl: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabBranch.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-gitlab.DataGitlabBranch.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabBranch.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabBranch.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.DataGitlabBranch.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabBranch.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabBranch.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabBranch.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabClusterAgent <a name="DataGitlabClusterAgent" id="@cdktf/provider-gitlab.DataGitlabClusterAgent"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/cluster_agent gitlab_cluster_agent}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.Initializer"></a>

```typescript
import { DataGitlabClusterAgent } from '@cdktf/provider-gitlab'

new DataGitlabClusterAgent(scope: Construct, id: string, config: DataGitlabClusterAgentConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgentConfig">DataGitlabClusterAgentConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabClusterAgentConfig">DataGitlabClusterAgentConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.isConstruct"></a>

```typescript
import { DataGitlabClusterAgent } from '@cdktf/provider-gitlab'

DataGitlabClusterAgent.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.createdAt">createdAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.createdByUserId">createdByUserId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.agentIdInput">agentIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.agentId">agentId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `createdAt`<sup>Required</sup> <a name="createdAt" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.createdAt"></a>

```typescript
public readonly createdAt: string;
```

- *Type:* string

---

##### `createdByUserId`<sup>Required</sup> <a name="createdByUserId" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.createdByUserId"></a>

```typescript
public readonly createdByUserId: number;
```

- *Type:* number

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `agentIdInput`<sup>Optional</sup> <a name="agentIdInput" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.agentIdInput"></a>

```typescript
public readonly agentIdInput: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `agentId`<sup>Required</sup> <a name="agentId" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.agentId"></a>

```typescript
public readonly agentId: number;
```

- *Type:* number

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgent.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabClusterAgent.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabClusterAgents <a name="DataGitlabClusterAgents" id="@cdktf/provider-gitlab.DataGitlabClusterAgents"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/cluster_agents gitlab_cluster_agents}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.Initializer"></a>

```typescript
import { DataGitlabClusterAgents } from '@cdktf/provider-gitlab'

new DataGitlabClusterAgents(scope: Construct, id: string, config: DataGitlabClusterAgentsConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgentsConfig">DataGitlabClusterAgentsConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabClusterAgentsConfig">DataGitlabClusterAgentsConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.isConstruct"></a>

```typescript
import { DataGitlabClusterAgents } from '@cdktf/provider-gitlab'

DataGitlabClusterAgents.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.clusterAgents">clusterAgents</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgentsClusterAgentsList">DataGitlabClusterAgentsClusterAgentsList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `clusterAgents`<sup>Required</sup> <a name="clusterAgents" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.clusterAgents"></a>

```typescript
public readonly clusterAgents: DataGitlabClusterAgentsClusterAgentsList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabClusterAgentsClusterAgentsList">DataGitlabClusterAgentsClusterAgentsList</a>

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabClusterAgents.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabClusterAgents.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabCurrentUser <a name="DataGitlabCurrentUser" id="@cdktf/provider-gitlab.DataGitlabCurrentUser"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/current_user gitlab_current_user}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.Initializer"></a>

```typescript
import { DataGitlabCurrentUser } from '@cdktf/provider-gitlab'

new DataGitlabCurrentUser(scope: Construct, id: string, config?: DataGitlabCurrentUserConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUserConfig">DataGitlabCurrentUserConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabCurrentUserConfig">DataGitlabCurrentUserConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.isConstruct"></a>

```typescript
import { DataGitlabCurrentUser } from '@cdktf/provider-gitlab'

DataGitlabCurrentUser.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.bot">bot</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.globalId">globalId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.globalNamespaceId">globalNamespaceId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.groupCount">groupCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.namespaceId">namespaceId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.publicEmail">publicEmail</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.username">username</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `bot`<sup>Required</sup> <a name="bot" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.bot"></a>

```typescript
public readonly bot: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `globalId`<sup>Required</sup> <a name="globalId" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.globalId"></a>

```typescript
public readonly globalId: string;
```

- *Type:* string

---

##### `globalNamespaceId`<sup>Required</sup> <a name="globalNamespaceId" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.globalNamespaceId"></a>

```typescript
public readonly globalNamespaceId: string;
```

- *Type:* string

---

##### `groupCount`<sup>Required</sup> <a name="groupCount" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.groupCount"></a>

```typescript
public readonly groupCount: number;
```

- *Type:* number

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `namespaceId`<sup>Required</sup> <a name="namespaceId" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.namespaceId"></a>

```typescript
public readonly namespaceId: string;
```

- *Type:* string

---

##### `publicEmail`<sup>Required</sup> <a name="publicEmail" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.publicEmail"></a>

```typescript
public readonly publicEmail: string;
```

- *Type:* string

---

##### `username`<sup>Required</sup> <a name="username" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.username"></a>

```typescript
public readonly username: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabCurrentUser.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabCurrentUser.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabGroup <a name="DataGitlabGroup" id="@cdktf/provider-gitlab.DataGitlabGroup"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group gitlab_group}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabGroup.Initializer"></a>

```typescript
import { DataGitlabGroup } from '@cdktf/provider-gitlab'

new DataGitlabGroup(scope: Construct, id: string, config?: DataGitlabGroupConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupConfig">DataGitlabGroupConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabGroup.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroup.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabGroup.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupConfig">DataGitlabGroupConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.resetFullPath">resetFullPath</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.resetGroupId">resetGroupId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabGroup.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabGroup.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabGroup.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabGroup.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroup.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroup.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroup.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabGroup.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabGroup.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroup.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetFullPath` <a name="resetFullPath" id="@cdktf/provider-gitlab.DataGitlabGroup.resetFullPath"></a>

```typescript
public resetFullPath(): void
```

##### `resetGroupId` <a name="resetGroupId" id="@cdktf/provider-gitlab.DataGitlabGroup.resetGroupId"></a>

```typescript
public resetGroupId(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabGroup.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabGroup.isConstruct"></a>

```typescript
import { DataGitlabGroup } from '@cdktf/provider-gitlab'

DataGitlabGroup.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabGroup.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.defaultBranchProtection">defaultBranchProtection</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.fullName">fullName</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.lfsEnabled">lfsEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.parentId">parentId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.path">path</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.preventForkingOutsideGroup">preventForkingOutsideGroup</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.requestAccessEnabled">requestAccessEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.runnersToken">runnersToken</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.visibilityLevel">visibilityLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.webUrl">webUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.fullPathInput">fullPathInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.groupIdInput">groupIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.fullPath">fullPath</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.groupId">groupId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabGroup.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabGroup.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabGroup.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabGroup.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabGroup.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabGroup.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabGroup.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabGroup.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabGroup.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabGroup.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabGroup.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabGroup.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `defaultBranchProtection`<sup>Required</sup> <a name="defaultBranchProtection" id="@cdktf/provider-gitlab.DataGitlabGroup.property.defaultBranchProtection"></a>

```typescript
public readonly defaultBranchProtection: number;
```

- *Type:* number

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-gitlab.DataGitlabGroup.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `fullName`<sup>Required</sup> <a name="fullName" id="@cdktf/provider-gitlab.DataGitlabGroup.property.fullName"></a>

```typescript
public readonly fullName: string;
```

- *Type:* string

---

##### `lfsEnabled`<sup>Required</sup> <a name="lfsEnabled" id="@cdktf/provider-gitlab.DataGitlabGroup.property.lfsEnabled"></a>

```typescript
public readonly lfsEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.DataGitlabGroup.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `parentId`<sup>Required</sup> <a name="parentId" id="@cdktf/provider-gitlab.DataGitlabGroup.property.parentId"></a>

```typescript
public readonly parentId: number;
```

- *Type:* number

---

##### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabGroup.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

---

##### `preventForkingOutsideGroup`<sup>Required</sup> <a name="preventForkingOutsideGroup" id="@cdktf/provider-gitlab.DataGitlabGroup.property.preventForkingOutsideGroup"></a>

```typescript
public readonly preventForkingOutsideGroup: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `requestAccessEnabled`<sup>Required</sup> <a name="requestAccessEnabled" id="@cdktf/provider-gitlab.DataGitlabGroup.property.requestAccessEnabled"></a>

```typescript
public readonly requestAccessEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `runnersToken`<sup>Required</sup> <a name="runnersToken" id="@cdktf/provider-gitlab.DataGitlabGroup.property.runnersToken"></a>

```typescript
public readonly runnersToken: string;
```

- *Type:* string

---

##### `visibilityLevel`<sup>Required</sup> <a name="visibilityLevel" id="@cdktf/provider-gitlab.DataGitlabGroup.property.visibilityLevel"></a>

```typescript
public readonly visibilityLevel: string;
```

- *Type:* string

---

##### `webUrl`<sup>Required</sup> <a name="webUrl" id="@cdktf/provider-gitlab.DataGitlabGroup.property.webUrl"></a>

```typescript
public readonly webUrl: string;
```

- *Type:* string

---

##### `fullPathInput`<sup>Optional</sup> <a name="fullPathInput" id="@cdktf/provider-gitlab.DataGitlabGroup.property.fullPathInput"></a>

```typescript
public readonly fullPathInput: string;
```

- *Type:* string

---

##### `groupIdInput`<sup>Optional</sup> <a name="groupIdInput" id="@cdktf/provider-gitlab.DataGitlabGroup.property.groupIdInput"></a>

```typescript
public readonly groupIdInput: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabGroup.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `fullPath`<sup>Required</sup> <a name="fullPath" id="@cdktf/provider-gitlab.DataGitlabGroup.property.fullPath"></a>

```typescript
public readonly fullPath: string;
```

- *Type:* string

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@cdktf/provider-gitlab.DataGitlabGroup.property.groupId"></a>

```typescript
public readonly groupId: number;
```

- *Type:* number

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroup.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroup.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabGroup.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabGroupHook <a name="DataGitlabGroupHook" id="@cdktf/provider-gitlab.DataGitlabGroupHook"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_hook gitlab_group_hook}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabGroupHook.Initializer"></a>

```typescript
import { DataGitlabGroupHook } from '@cdktf/provider-gitlab'

new DataGitlabGroupHook(scope: Construct, id: string, config: DataGitlabGroupHookConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHookConfig">DataGitlabGroupHookConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabGroupHook.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupHook.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabGroupHook.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupHookConfig">DataGitlabGroupHookConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabGroupHook.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabGroupHook.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabGroupHook.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabGroupHook.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupHook.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupHook.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupHook.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupHook.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabGroupHook.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHook.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabGroupHook.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabGroupHook.isConstruct"></a>

```typescript
import { DataGitlabGroupHook } from '@cdktf/provider-gitlab'

DataGitlabGroupHook.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabGroupHook.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.confidentialIssuesEvents">confidentialIssuesEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.confidentialNoteEvents">confidentialNoteEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.deploymentEvents">deploymentEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.enableSslVerification">enableSslVerification</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.groupId">groupId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.issuesEvents">issuesEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.jobEvents">jobEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.mergeRequestsEvents">mergeRequestsEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.noteEvents">noteEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.pipelineEvents">pipelineEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.pushEvents">pushEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.pushEventsBranchFilter">pushEventsBranchFilter</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.releasesEvents">releasesEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.subgroupEvents">subgroupEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.tagPushEvents">tagPushEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.token">token</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.url">url</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.wikiPageEvents">wikiPageEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.groupInput">groupInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.hookIdInput">hookIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.group">group</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.hookId">hookId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `confidentialIssuesEvents`<sup>Required</sup> <a name="confidentialIssuesEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.confidentialIssuesEvents"></a>

```typescript
public readonly confidentialIssuesEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `confidentialNoteEvents`<sup>Required</sup> <a name="confidentialNoteEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.confidentialNoteEvents"></a>

```typescript
public readonly confidentialNoteEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `deploymentEvents`<sup>Required</sup> <a name="deploymentEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.deploymentEvents"></a>

```typescript
public readonly deploymentEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `enableSslVerification`<sup>Required</sup> <a name="enableSslVerification" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.enableSslVerification"></a>

```typescript
public readonly enableSslVerification: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.groupId"></a>

```typescript
public readonly groupId: number;
```

- *Type:* number

---

##### `issuesEvents`<sup>Required</sup> <a name="issuesEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.issuesEvents"></a>

```typescript
public readonly issuesEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `jobEvents`<sup>Required</sup> <a name="jobEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.jobEvents"></a>

```typescript
public readonly jobEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `mergeRequestsEvents`<sup>Required</sup> <a name="mergeRequestsEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.mergeRequestsEvents"></a>

```typescript
public readonly mergeRequestsEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `noteEvents`<sup>Required</sup> <a name="noteEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.noteEvents"></a>

```typescript
public readonly noteEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `pipelineEvents`<sup>Required</sup> <a name="pipelineEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.pipelineEvents"></a>

```typescript
public readonly pipelineEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `pushEvents`<sup>Required</sup> <a name="pushEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.pushEvents"></a>

```typescript
public readonly pushEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `pushEventsBranchFilter`<sup>Required</sup> <a name="pushEventsBranchFilter" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.pushEventsBranchFilter"></a>

```typescript
public readonly pushEventsBranchFilter: string;
```

- *Type:* string

---

##### `releasesEvents`<sup>Required</sup> <a name="releasesEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.releasesEvents"></a>

```typescript
public readonly releasesEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `subgroupEvents`<sup>Required</sup> <a name="subgroupEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.subgroupEvents"></a>

```typescript
public readonly subgroupEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `tagPushEvents`<sup>Required</sup> <a name="tagPushEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.tagPushEvents"></a>

```typescript
public readonly tagPushEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `token`<sup>Required</sup> <a name="token" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.token"></a>

```typescript
public readonly token: string;
```

- *Type:* string

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.url"></a>

```typescript
public readonly url: string;
```

- *Type:* string

---

##### `wikiPageEvents`<sup>Required</sup> <a name="wikiPageEvents" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.wikiPageEvents"></a>

```typescript
public readonly wikiPageEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `groupInput`<sup>Optional</sup> <a name="groupInput" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.groupInput"></a>

```typescript
public readonly groupInput: string;
```

- *Type:* string

---

##### `hookIdInput`<sup>Optional</sup> <a name="hookIdInput" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.hookIdInput"></a>

```typescript
public readonly hookIdInput: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `group`<sup>Required</sup> <a name="group" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.group"></a>

```typescript
public readonly group: string;
```

- *Type:* string

---

##### `hookId`<sup>Required</sup> <a name="hookId" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.hookId"></a>

```typescript
public readonly hookId: number;
```

- *Type:* number

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHook.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupHook.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabGroupHooks <a name="DataGitlabGroupHooks" id="@cdktf/provider-gitlab.DataGitlabGroupHooks"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_hooks gitlab_group_hooks}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.Initializer"></a>

```typescript
import { DataGitlabGroupHooks } from '@cdktf/provider-gitlab'

new DataGitlabGroupHooks(scope: Construct, id: string, config: DataGitlabGroupHooksConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooksConfig">DataGitlabGroupHooksConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupHooksConfig">DataGitlabGroupHooksConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.isConstruct"></a>

```typescript
import { DataGitlabGroupHooks } from '@cdktf/provider-gitlab'

DataGitlabGroupHooks.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.hooks">hooks</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooksHooksList">DataGitlabGroupHooksHooksList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.groupInput">groupInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.group">group</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `hooks`<sup>Required</sup> <a name="hooks" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.hooks"></a>

```typescript
public readonly hooks: DataGitlabGroupHooksHooksList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupHooksHooksList">DataGitlabGroupHooksHooksList</a>

---

##### `groupInput`<sup>Optional</sup> <a name="groupInput" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.groupInput"></a>

```typescript
public readonly groupInput: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `group`<sup>Required</sup> <a name="group" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.group"></a>

```typescript
public readonly group: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupHooks.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupHooks.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabGroupMembership <a name="DataGitlabGroupMembership" id="@cdktf/provider-gitlab.DataGitlabGroupMembership"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_membership gitlab_group_membership}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.Initializer"></a>

```typescript
import { DataGitlabGroupMembership } from '@cdktf/provider-gitlab'

new DataGitlabGroupMembership(scope: Construct, id: string, config?: DataGitlabGroupMembershipConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembershipConfig">DataGitlabGroupMembershipConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupMembershipConfig">DataGitlabGroupMembershipConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.resetAccessLevel">resetAccessLevel</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.resetFullPath">resetFullPath</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.resetGroupId">resetGroupId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetAccessLevel` <a name="resetAccessLevel" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.resetAccessLevel"></a>

```typescript
public resetAccessLevel(): void
```

##### `resetFullPath` <a name="resetFullPath" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.resetFullPath"></a>

```typescript
public resetFullPath(): void
```

##### `resetGroupId` <a name="resetGroupId" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.resetGroupId"></a>

```typescript
public resetGroupId(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.isConstruct"></a>

```typescript
import { DataGitlabGroupMembership } from '@cdktf/provider-gitlab'

DataGitlabGroupMembership.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.members">members</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembershipMembersList">DataGitlabGroupMembershipMembersList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.accessLevelInput">accessLevelInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.fullPathInput">fullPathInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.groupIdInput">groupIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.accessLevel">accessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.fullPath">fullPath</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.groupId">groupId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `members`<sup>Required</sup> <a name="members" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.members"></a>

```typescript
public readonly members: DataGitlabGroupMembershipMembersList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupMembershipMembersList">DataGitlabGroupMembershipMembersList</a>

---

##### `accessLevelInput`<sup>Optional</sup> <a name="accessLevelInput" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.accessLevelInput"></a>

```typescript
public readonly accessLevelInput: string;
```

- *Type:* string

---

##### `fullPathInput`<sup>Optional</sup> <a name="fullPathInput" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.fullPathInput"></a>

```typescript
public readonly fullPathInput: string;
```

- *Type:* string

---

##### `groupIdInput`<sup>Optional</sup> <a name="groupIdInput" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.groupIdInput"></a>

```typescript
public readonly groupIdInput: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `accessLevel`<sup>Required</sup> <a name="accessLevel" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.accessLevel"></a>

```typescript
public readonly accessLevel: string;
```

- *Type:* string

---

##### `fullPath`<sup>Required</sup> <a name="fullPath" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.fullPath"></a>

```typescript
public readonly fullPath: string;
```

- *Type:* string

---

##### `groupId`<sup>Required</sup> <a name="groupId" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.groupId"></a>

```typescript
public readonly groupId: number;
```

- *Type:* number

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupMembership.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupMembership.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabGroupVariable <a name="DataGitlabGroupVariable" id="@cdktf/provider-gitlab.DataGitlabGroupVariable"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_variable gitlab_group_variable}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.Initializer"></a>

```typescript
import { DataGitlabGroupVariable } from '@cdktf/provider-gitlab'

new DataGitlabGroupVariable(scope: Construct, id: string, config: DataGitlabGroupVariableConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariableConfig">DataGitlabGroupVariableConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupVariableConfig">DataGitlabGroupVariableConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.resetEnvironmentScope">resetEnvironmentScope</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetEnvironmentScope` <a name="resetEnvironmentScope" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.resetEnvironmentScope"></a>

```typescript
public resetEnvironmentScope(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.isConstruct"></a>

```typescript
import { DataGitlabGroupVariable } from '@cdktf/provider-gitlab'

DataGitlabGroupVariable.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.masked">masked</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.protected">protected</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.value">value</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.variableType">variableType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.environmentScopeInput">environmentScopeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.groupInput">groupInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.keyInput">keyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.environmentScope">environmentScope</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.group">group</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.key">key</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `masked`<sup>Required</sup> <a name="masked" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.masked"></a>

```typescript
public readonly masked: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `protected`<sup>Required</sup> <a name="protected" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.protected"></a>

```typescript
public readonly protected: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.value"></a>

```typescript
public readonly value: string;
```

- *Type:* string

---

##### `variableType`<sup>Required</sup> <a name="variableType" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.variableType"></a>

```typescript
public readonly variableType: string;
```

- *Type:* string

---

##### `environmentScopeInput`<sup>Optional</sup> <a name="environmentScopeInput" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.environmentScopeInput"></a>

```typescript
public readonly environmentScopeInput: string;
```

- *Type:* string

---

##### `groupInput`<sup>Optional</sup> <a name="groupInput" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.groupInput"></a>

```typescript
public readonly groupInput: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `keyInput`<sup>Optional</sup> <a name="keyInput" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.keyInput"></a>

```typescript
public readonly keyInput: string;
```

- *Type:* string

---

##### `environmentScope`<sup>Required</sup> <a name="environmentScope" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.environmentScope"></a>

```typescript
public readonly environmentScope: string;
```

- *Type:* string

---

##### `group`<sup>Required</sup> <a name="group" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.group"></a>

```typescript
public readonly group: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `key`<sup>Required</sup> <a name="key" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.key"></a>

```typescript
public readonly key: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariable.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupVariable.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabGroupVariables <a name="DataGitlabGroupVariables" id="@cdktf/provider-gitlab.DataGitlabGroupVariables"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_variables gitlab_group_variables}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.Initializer"></a>

```typescript
import { DataGitlabGroupVariables } from '@cdktf/provider-gitlab'

new DataGitlabGroupVariables(scope: Construct, id: string, config: DataGitlabGroupVariablesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariablesConfig">DataGitlabGroupVariablesConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupVariablesConfig">DataGitlabGroupVariablesConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.resetEnvironmentScope">resetEnvironmentScope</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetEnvironmentScope` <a name="resetEnvironmentScope" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.resetEnvironmentScope"></a>

```typescript
public resetEnvironmentScope(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.isConstruct"></a>

```typescript
import { DataGitlabGroupVariables } from '@cdktf/provider-gitlab'

DataGitlabGroupVariables.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.variables">variables</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariablesVariablesList">DataGitlabGroupVariablesVariablesList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.environmentScopeInput">environmentScopeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.groupInput">groupInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.environmentScope">environmentScope</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.group">group</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `variables`<sup>Required</sup> <a name="variables" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.variables"></a>

```typescript
public readonly variables: DataGitlabGroupVariablesVariablesList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabGroupVariablesVariablesList">DataGitlabGroupVariablesVariablesList</a>

---

##### `environmentScopeInput`<sup>Optional</sup> <a name="environmentScopeInput" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.environmentScopeInput"></a>

```typescript
public readonly environmentScopeInput: string;
```

- *Type:* string

---

##### `groupInput`<sup>Optional</sup> <a name="groupInput" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.groupInput"></a>

```typescript
public readonly groupInput: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `environmentScope`<sup>Required</sup> <a name="environmentScope" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.environmentScope"></a>

```typescript
public readonly environmentScope: string;
```

- *Type:* string

---

##### `group`<sup>Required</sup> <a name="group" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.group"></a>

```typescript
public readonly group: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabGroupVariables.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabGroupVariables.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabInstanceDeployKeys <a name="DataGitlabInstanceDeployKeys" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/instance_deploy_keys gitlab_instance_deploy_keys}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.Initializer"></a>

```typescript
import { DataGitlabInstanceDeployKeys } from '@cdktf/provider-gitlab'

new DataGitlabInstanceDeployKeys(scope: Construct, id: string, config?: DataGitlabInstanceDeployKeysConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeysConfig">DataGitlabInstanceDeployKeysConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeysConfig">DataGitlabInstanceDeployKeysConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.resetPublic">resetPublic</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.resetId"></a>

```typescript
public resetId(): void
```

##### `resetPublic` <a name="resetPublic" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.resetPublic"></a>

```typescript
public resetPublic(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.isConstruct"></a>

```typescript
import { DataGitlabInstanceDeployKeys } from '@cdktf/provider-gitlab'

DataGitlabInstanceDeployKeys.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.deployKeys">deployKeys</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeysDeployKeysList">DataGitlabInstanceDeployKeysDeployKeysList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.publicInput">publicInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.public">public</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `deployKeys`<sup>Required</sup> <a name="deployKeys" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.deployKeys"></a>

```typescript
public readonly deployKeys: DataGitlabInstanceDeployKeysDeployKeysList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeysDeployKeysList">DataGitlabInstanceDeployKeysDeployKeysList</a>

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `publicInput`<sup>Optional</sup> <a name="publicInput" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.publicInput"></a>

```typescript
public readonly publicInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `public`<sup>Required</sup> <a name="public" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.public"></a>

```typescript
public readonly public: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabInstanceDeployKeys.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabInstanceVariable <a name="DataGitlabInstanceVariable" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variable gitlab_instance_variable}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.Initializer"></a>

```typescript
import { DataGitlabInstanceVariable } from '@cdktf/provider-gitlab'

new DataGitlabInstanceVariable(scope: Construct, id: string, config: DataGitlabInstanceVariableConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariableConfig">DataGitlabInstanceVariableConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariableConfig">DataGitlabInstanceVariableConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.isConstruct"></a>

```typescript
import { DataGitlabInstanceVariable } from '@cdktf/provider-gitlab'

DataGitlabInstanceVariable.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.masked">masked</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.protected">protected</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.value">value</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.variableType">variableType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.keyInput">keyInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.key">key</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `masked`<sup>Required</sup> <a name="masked" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.masked"></a>

```typescript
public readonly masked: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `protected`<sup>Required</sup> <a name="protected" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.protected"></a>

```typescript
public readonly protected: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.value"></a>

```typescript
public readonly value: string;
```

- *Type:* string

---

##### `variableType`<sup>Required</sup> <a name="variableType" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.variableType"></a>

```typescript
public readonly variableType: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `keyInput`<sup>Optional</sup> <a name="keyInput" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.keyInput"></a>

```typescript
public readonly keyInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `key`<sup>Required</sup> <a name="key" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.key"></a>

```typescript
public readonly key: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabInstanceVariable.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabInstanceVariables <a name="DataGitlabInstanceVariables" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/instance_variables gitlab_instance_variables}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.Initializer"></a>

```typescript
import { DataGitlabInstanceVariables } from '@cdktf/provider-gitlab'

new DataGitlabInstanceVariables(scope: Construct, id: string, config?: DataGitlabInstanceVariablesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariablesConfig">DataGitlabInstanceVariablesConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariablesConfig">DataGitlabInstanceVariablesConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.isConstruct"></a>

```typescript
import { DataGitlabInstanceVariables } from '@cdktf/provider-gitlab'

DataGitlabInstanceVariables.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.variables">variables</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariablesVariablesList">DataGitlabInstanceVariablesVariablesList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `variables`<sup>Required</sup> <a name="variables" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.variables"></a>

```typescript
public readonly variables: DataGitlabInstanceVariablesVariablesList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariablesVariablesList">DataGitlabInstanceVariablesVariablesList</a>

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabInstanceVariables.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProject <a name="DataGitlabProject" id="@cdktf/provider-gitlab.DataGitlabProject"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project gitlab_project}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProject.Initializer"></a>

```typescript
import { DataGitlabProject } from '@cdktf/provider-gitlab'

new DataGitlabProject(scope: Construct, id: string, config?: DataGitlabProjectConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectConfig">DataGitlabProjectConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProject.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProject.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProject.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectConfig">DataGitlabProjectConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.resetCiDefaultGitDepth">resetCiDefaultGitDepth</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.resetPathWithNamespace">resetPathWithNamespace</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.resetPublicBuilds">resetPublicBuilds</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProject.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProject.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProject.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProject.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProject.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProject.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProject.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProject.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProject.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProject.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetCiDefaultGitDepth` <a name="resetCiDefaultGitDepth" id="@cdktf/provider-gitlab.DataGitlabProject.resetCiDefaultGitDepth"></a>

```typescript
public resetCiDefaultGitDepth(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProject.resetId"></a>

```typescript
public resetId(): void
```

##### `resetPathWithNamespace` <a name="resetPathWithNamespace" id="@cdktf/provider-gitlab.DataGitlabProject.resetPathWithNamespace"></a>

```typescript
public resetPathWithNamespace(): void
```

##### `resetPublicBuilds` <a name="resetPublicBuilds" id="@cdktf/provider-gitlab.DataGitlabProject.resetPublicBuilds"></a>

```typescript
public resetPublicBuilds(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProject.isConstruct"></a>

```typescript
import { DataGitlabProject } from '@cdktf/provider-gitlab'

DataGitlabProject.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProject.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.analyticsAccessLevel">analyticsAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.archived">archived</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.autoCancelPendingPipelines">autoCancelPendingPipelines</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.autocloseReferencedIssues">autocloseReferencedIssues</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.autoDevopsDeployStrategy">autoDevopsDeployStrategy</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.autoDevopsEnabled">autoDevopsEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.buildGitStrategy">buildGitStrategy</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.buildsAccessLevel">buildsAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.buildTimeout">buildTimeout</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.containerExpirationPolicy">containerExpirationPolicy</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectContainerExpirationPolicyList">DataGitlabProjectContainerExpirationPolicyList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.containerRegistryAccessLevel">containerRegistryAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.defaultBranch">defaultBranch</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.emailsDisabled">emailsDisabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.externalAuthorizationClassificationLabel">externalAuthorizationClassificationLabel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.forkingAccessLevel">forkingAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.httpUrlToRepo">httpUrlToRepo</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.issuesAccessLevel">issuesAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.issuesEnabled">issuesEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.lfsEnabled">lfsEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.mergeCommitTemplate">mergeCommitTemplate</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.mergePipelinesEnabled">mergePipelinesEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.mergeRequestsAccessLevel">mergeRequestsAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.mergeRequestsEnabled">mergeRequestsEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.mergeTrainsEnabled">mergeTrainsEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.namespaceId">namespaceId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.operationsAccessLevel">operationsAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.path">path</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.pipelinesEnabled">pipelinesEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.printingMergeRequestLinkEnabled">printingMergeRequestLinkEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.pushRules">pushRules</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectPushRulesList">DataGitlabProjectPushRulesList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.removeSourceBranchAfterMerge">removeSourceBranchAfterMerge</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.repositoryAccessLevel">repositoryAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.repositoryStorage">repositoryStorage</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.requestAccessEnabled">requestAccessEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.requirementsAccessLevel">requirementsAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.resolveOutdatedDiffDiscussions">resolveOutdatedDiffDiscussions</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.runnersToken">runnersToken</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.securityAndComplianceAccessLevel">securityAndComplianceAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.snippetsAccessLevel">snippetsAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.snippetsEnabled">snippetsEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.squashCommitTemplate">squashCommitTemplate</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.sshUrlToRepo">sshUrlToRepo</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.topics">topics</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.visibilityLevel">visibilityLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.webUrl">webUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.wikiAccessLevel">wikiAccessLevel</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.wikiEnabled">wikiEnabled</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.ciDefaultGitDepthInput">ciDefaultGitDepthInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.pathWithNamespaceInput">pathWithNamespaceInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.publicBuildsInput">publicBuildsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.ciDefaultGitDepth">ciDefaultGitDepth</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.pathWithNamespace">pathWithNamespace</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.publicBuilds">publicBuilds</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProject.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProject.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProject.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProject.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProject.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProject.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProject.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProject.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProject.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProject.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProject.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProject.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `analyticsAccessLevel`<sup>Required</sup> <a name="analyticsAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.analyticsAccessLevel"></a>

```typescript
public readonly analyticsAccessLevel: string;
```

- *Type:* string

---

##### `archived`<sup>Required</sup> <a name="archived" id="@cdktf/provider-gitlab.DataGitlabProject.property.archived"></a>

```typescript
public readonly archived: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `autoCancelPendingPipelines`<sup>Required</sup> <a name="autoCancelPendingPipelines" id="@cdktf/provider-gitlab.DataGitlabProject.property.autoCancelPendingPipelines"></a>

```typescript
public readonly autoCancelPendingPipelines: string;
```

- *Type:* string

---

##### `autocloseReferencedIssues`<sup>Required</sup> <a name="autocloseReferencedIssues" id="@cdktf/provider-gitlab.DataGitlabProject.property.autocloseReferencedIssues"></a>

```typescript
public readonly autocloseReferencedIssues: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `autoDevopsDeployStrategy`<sup>Required</sup> <a name="autoDevopsDeployStrategy" id="@cdktf/provider-gitlab.DataGitlabProject.property.autoDevopsDeployStrategy"></a>

```typescript
public readonly autoDevopsDeployStrategy: string;
```

- *Type:* string

---

##### `autoDevopsEnabled`<sup>Required</sup> <a name="autoDevopsEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.autoDevopsEnabled"></a>

```typescript
public readonly autoDevopsEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `buildGitStrategy`<sup>Required</sup> <a name="buildGitStrategy" id="@cdktf/provider-gitlab.DataGitlabProject.property.buildGitStrategy"></a>

```typescript
public readonly buildGitStrategy: string;
```

- *Type:* string

---

##### `buildsAccessLevel`<sup>Required</sup> <a name="buildsAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.buildsAccessLevel"></a>

```typescript
public readonly buildsAccessLevel: string;
```

- *Type:* string

---

##### `buildTimeout`<sup>Required</sup> <a name="buildTimeout" id="@cdktf/provider-gitlab.DataGitlabProject.property.buildTimeout"></a>

```typescript
public readonly buildTimeout: number;
```

- *Type:* number

---

##### `containerExpirationPolicy`<sup>Required</sup> <a name="containerExpirationPolicy" id="@cdktf/provider-gitlab.DataGitlabProject.property.containerExpirationPolicy"></a>

```typescript
public readonly containerExpirationPolicy: DataGitlabProjectContainerExpirationPolicyList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectContainerExpirationPolicyList">DataGitlabProjectContainerExpirationPolicyList</a>

---

##### `containerRegistryAccessLevel`<sup>Required</sup> <a name="containerRegistryAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.containerRegistryAccessLevel"></a>

```typescript
public readonly containerRegistryAccessLevel: string;
```

- *Type:* string

---

##### `defaultBranch`<sup>Required</sup> <a name="defaultBranch" id="@cdktf/provider-gitlab.DataGitlabProject.property.defaultBranch"></a>

```typescript
public readonly defaultBranch: string;
```

- *Type:* string

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-gitlab.DataGitlabProject.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `emailsDisabled`<sup>Required</sup> <a name="emailsDisabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.emailsDisabled"></a>

```typescript
public readonly emailsDisabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `externalAuthorizationClassificationLabel`<sup>Required</sup> <a name="externalAuthorizationClassificationLabel" id="@cdktf/provider-gitlab.DataGitlabProject.property.externalAuthorizationClassificationLabel"></a>

```typescript
public readonly externalAuthorizationClassificationLabel: string;
```

- *Type:* string

---

##### `forkingAccessLevel`<sup>Required</sup> <a name="forkingAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.forkingAccessLevel"></a>

```typescript
public readonly forkingAccessLevel: string;
```

- *Type:* string

---

##### `httpUrlToRepo`<sup>Required</sup> <a name="httpUrlToRepo" id="@cdktf/provider-gitlab.DataGitlabProject.property.httpUrlToRepo"></a>

```typescript
public readonly httpUrlToRepo: string;
```

- *Type:* string

---

##### `issuesAccessLevel`<sup>Required</sup> <a name="issuesAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.issuesAccessLevel"></a>

```typescript
public readonly issuesAccessLevel: string;
```

- *Type:* string

---

##### `issuesEnabled`<sup>Required</sup> <a name="issuesEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.issuesEnabled"></a>

```typescript
public readonly issuesEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `lfsEnabled`<sup>Required</sup> <a name="lfsEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.lfsEnabled"></a>

```typescript
public readonly lfsEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `mergeCommitTemplate`<sup>Required</sup> <a name="mergeCommitTemplate" id="@cdktf/provider-gitlab.DataGitlabProject.property.mergeCommitTemplate"></a>

```typescript
public readonly mergeCommitTemplate: string;
```

- *Type:* string

---

##### `mergePipelinesEnabled`<sup>Required</sup> <a name="mergePipelinesEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.mergePipelinesEnabled"></a>

```typescript
public readonly mergePipelinesEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `mergeRequestsAccessLevel`<sup>Required</sup> <a name="mergeRequestsAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.mergeRequestsAccessLevel"></a>

```typescript
public readonly mergeRequestsAccessLevel: string;
```

- *Type:* string

---

##### `mergeRequestsEnabled`<sup>Required</sup> <a name="mergeRequestsEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.mergeRequestsEnabled"></a>

```typescript
public readonly mergeRequestsEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `mergeTrainsEnabled`<sup>Required</sup> <a name="mergeTrainsEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.mergeTrainsEnabled"></a>

```typescript
public readonly mergeTrainsEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.DataGitlabProject.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `namespaceId`<sup>Required</sup> <a name="namespaceId" id="@cdktf/provider-gitlab.DataGitlabProject.property.namespaceId"></a>

```typescript
public readonly namespaceId: number;
```

- *Type:* number

---

##### `operationsAccessLevel`<sup>Required</sup> <a name="operationsAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.operationsAccessLevel"></a>

```typescript
public readonly operationsAccessLevel: string;
```

- *Type:* string

---

##### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProject.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

---

##### `pipelinesEnabled`<sup>Required</sup> <a name="pipelinesEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.pipelinesEnabled"></a>

```typescript
public readonly pipelinesEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `printingMergeRequestLinkEnabled`<sup>Required</sup> <a name="printingMergeRequestLinkEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.printingMergeRequestLinkEnabled"></a>

```typescript
public readonly printingMergeRequestLinkEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `pushRules`<sup>Required</sup> <a name="pushRules" id="@cdktf/provider-gitlab.DataGitlabProject.property.pushRules"></a>

```typescript
public readonly pushRules: DataGitlabProjectPushRulesList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectPushRulesList">DataGitlabProjectPushRulesList</a>

---

##### `removeSourceBranchAfterMerge`<sup>Required</sup> <a name="removeSourceBranchAfterMerge" id="@cdktf/provider-gitlab.DataGitlabProject.property.removeSourceBranchAfterMerge"></a>

```typescript
public readonly removeSourceBranchAfterMerge: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `repositoryAccessLevel`<sup>Required</sup> <a name="repositoryAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.repositoryAccessLevel"></a>

```typescript
public readonly repositoryAccessLevel: string;
```

- *Type:* string

---

##### `repositoryStorage`<sup>Required</sup> <a name="repositoryStorage" id="@cdktf/provider-gitlab.DataGitlabProject.property.repositoryStorage"></a>

```typescript
public readonly repositoryStorage: string;
```

- *Type:* string

---

##### `requestAccessEnabled`<sup>Required</sup> <a name="requestAccessEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.requestAccessEnabled"></a>

```typescript
public readonly requestAccessEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `requirementsAccessLevel`<sup>Required</sup> <a name="requirementsAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.requirementsAccessLevel"></a>

```typescript
public readonly requirementsAccessLevel: string;
```

- *Type:* string

---

##### `resolveOutdatedDiffDiscussions`<sup>Required</sup> <a name="resolveOutdatedDiffDiscussions" id="@cdktf/provider-gitlab.DataGitlabProject.property.resolveOutdatedDiffDiscussions"></a>

```typescript
public readonly resolveOutdatedDiffDiscussions: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `runnersToken`<sup>Required</sup> <a name="runnersToken" id="@cdktf/provider-gitlab.DataGitlabProject.property.runnersToken"></a>

```typescript
public readonly runnersToken: string;
```

- *Type:* string

---

##### `securityAndComplianceAccessLevel`<sup>Required</sup> <a name="securityAndComplianceAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.securityAndComplianceAccessLevel"></a>

```typescript
public readonly securityAndComplianceAccessLevel: string;
```

- *Type:* string

---

##### `snippetsAccessLevel`<sup>Required</sup> <a name="snippetsAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.snippetsAccessLevel"></a>

```typescript
public readonly snippetsAccessLevel: string;
```

- *Type:* string

---

##### `snippetsEnabled`<sup>Required</sup> <a name="snippetsEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.snippetsEnabled"></a>

```typescript
public readonly snippetsEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `squashCommitTemplate`<sup>Required</sup> <a name="squashCommitTemplate" id="@cdktf/provider-gitlab.DataGitlabProject.property.squashCommitTemplate"></a>

```typescript
public readonly squashCommitTemplate: string;
```

- *Type:* string

---

##### `sshUrlToRepo`<sup>Required</sup> <a name="sshUrlToRepo" id="@cdktf/provider-gitlab.DataGitlabProject.property.sshUrlToRepo"></a>

```typescript
public readonly sshUrlToRepo: string;
```

- *Type:* string

---

##### `topics`<sup>Required</sup> <a name="topics" id="@cdktf/provider-gitlab.DataGitlabProject.property.topics"></a>

```typescript
public readonly topics: string[];
```

- *Type:* string[]

---

##### `visibilityLevel`<sup>Required</sup> <a name="visibilityLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.visibilityLevel"></a>

```typescript
public readonly visibilityLevel: string;
```

- *Type:* string

---

##### `webUrl`<sup>Required</sup> <a name="webUrl" id="@cdktf/provider-gitlab.DataGitlabProject.property.webUrl"></a>

```typescript
public readonly webUrl: string;
```

- *Type:* string

---

##### `wikiAccessLevel`<sup>Required</sup> <a name="wikiAccessLevel" id="@cdktf/provider-gitlab.DataGitlabProject.property.wikiAccessLevel"></a>

```typescript
public readonly wikiAccessLevel: string;
```

- *Type:* string

---

##### `wikiEnabled`<sup>Required</sup> <a name="wikiEnabled" id="@cdktf/provider-gitlab.DataGitlabProject.property.wikiEnabled"></a>

```typescript
public readonly wikiEnabled: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `ciDefaultGitDepthInput`<sup>Optional</sup> <a name="ciDefaultGitDepthInput" id="@cdktf/provider-gitlab.DataGitlabProject.property.ciDefaultGitDepthInput"></a>

```typescript
public readonly ciDefaultGitDepthInput: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProject.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `pathWithNamespaceInput`<sup>Optional</sup> <a name="pathWithNamespaceInput" id="@cdktf/provider-gitlab.DataGitlabProject.property.pathWithNamespaceInput"></a>

```typescript
public readonly pathWithNamespaceInput: string;
```

- *Type:* string

---

##### `publicBuildsInput`<sup>Optional</sup> <a name="publicBuildsInput" id="@cdktf/provider-gitlab.DataGitlabProject.property.publicBuildsInput"></a>

```typescript
public readonly publicBuildsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `ciDefaultGitDepth`<sup>Required</sup> <a name="ciDefaultGitDepth" id="@cdktf/provider-gitlab.DataGitlabProject.property.ciDefaultGitDepth"></a>

```typescript
public readonly ciDefaultGitDepth: number;
```

- *Type:* number

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProject.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `pathWithNamespace`<sup>Required</sup> <a name="pathWithNamespace" id="@cdktf/provider-gitlab.DataGitlabProject.property.pathWithNamespace"></a>

```typescript
public readonly pathWithNamespace: string;
```

- *Type:* string

---

##### `publicBuilds`<sup>Required</sup> <a name="publicBuilds" id="@cdktf/provider-gitlab.DataGitlabProject.property.publicBuilds"></a>

```typescript
public readonly publicBuilds: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProject.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProject.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectHook <a name="DataGitlabProjectHook" id="@cdktf/provider-gitlab.DataGitlabProjectHook"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_hook gitlab_project_hook}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectHook.Initializer"></a>

```typescript
import { DataGitlabProjectHook } from '@cdktf/provider-gitlab'

new DataGitlabProjectHook(scope: Construct, id: string, config: DataGitlabProjectHookConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHookConfig">DataGitlabProjectHookConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectHook.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectHook.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectHook.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectHookConfig">DataGitlabProjectHookConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectHook.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectHook.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectHook.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectHook.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectHook.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectHook.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectHook.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectHook.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectHook.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHook.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectHook.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectHook.isConstruct"></a>

```typescript
import { DataGitlabProjectHook } from '@cdktf/provider-gitlab'

DataGitlabProjectHook.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectHook.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.confidentialIssuesEvents">confidentialIssuesEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.confidentialNoteEvents">confidentialNoteEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.deploymentEvents">deploymentEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.enableSslVerification">enableSslVerification</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.issuesEvents">issuesEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.jobEvents">jobEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.mergeRequestsEvents">mergeRequestsEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.noteEvents">noteEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.pipelineEvents">pipelineEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.projectId">projectId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.pushEvents">pushEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.pushEventsBranchFilter">pushEventsBranchFilter</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.releasesEvents">releasesEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.tagPushEvents">tagPushEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.token">token</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.url">url</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.wikiPageEvents">wikiPageEvents</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.hookIdInput">hookIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.hookId">hookId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `confidentialIssuesEvents`<sup>Required</sup> <a name="confidentialIssuesEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.confidentialIssuesEvents"></a>

```typescript
public readonly confidentialIssuesEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `confidentialNoteEvents`<sup>Required</sup> <a name="confidentialNoteEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.confidentialNoteEvents"></a>

```typescript
public readonly confidentialNoteEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `deploymentEvents`<sup>Required</sup> <a name="deploymentEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.deploymentEvents"></a>

```typescript
public readonly deploymentEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `enableSslVerification`<sup>Required</sup> <a name="enableSslVerification" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.enableSslVerification"></a>

```typescript
public readonly enableSslVerification: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `issuesEvents`<sup>Required</sup> <a name="issuesEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.issuesEvents"></a>

```typescript
public readonly issuesEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `jobEvents`<sup>Required</sup> <a name="jobEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.jobEvents"></a>

```typescript
public readonly jobEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `mergeRequestsEvents`<sup>Required</sup> <a name="mergeRequestsEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.mergeRequestsEvents"></a>

```typescript
public readonly mergeRequestsEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `noteEvents`<sup>Required</sup> <a name="noteEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.noteEvents"></a>

```typescript
public readonly noteEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `pipelineEvents`<sup>Required</sup> <a name="pipelineEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.pipelineEvents"></a>

```typescript
public readonly pipelineEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `projectId`<sup>Required</sup> <a name="projectId" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.projectId"></a>

```typescript
public readonly projectId: number;
```

- *Type:* number

---

##### `pushEvents`<sup>Required</sup> <a name="pushEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.pushEvents"></a>

```typescript
public readonly pushEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `pushEventsBranchFilter`<sup>Required</sup> <a name="pushEventsBranchFilter" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.pushEventsBranchFilter"></a>

```typescript
public readonly pushEventsBranchFilter: string;
```

- *Type:* string

---

##### `releasesEvents`<sup>Required</sup> <a name="releasesEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.releasesEvents"></a>

```typescript
public readonly releasesEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `tagPushEvents`<sup>Required</sup> <a name="tagPushEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.tagPushEvents"></a>

```typescript
public readonly tagPushEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `token`<sup>Required</sup> <a name="token" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.token"></a>

```typescript
public readonly token: string;
```

- *Type:* string

---

##### `url`<sup>Required</sup> <a name="url" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.url"></a>

```typescript
public readonly url: string;
```

- *Type:* string

---

##### `wikiPageEvents`<sup>Required</sup> <a name="wikiPageEvents" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.wikiPageEvents"></a>

```typescript
public readonly wikiPageEvents: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `hookIdInput`<sup>Optional</sup> <a name="hookIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.hookIdInput"></a>

```typescript
public readonly hookIdInput: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `hookId`<sup>Required</sup> <a name="hookId" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.hookId"></a>

```typescript
public readonly hookId: number;
```

- *Type:* number

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHook.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectHook.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectHooks <a name="DataGitlabProjectHooks" id="@cdktf/provider-gitlab.DataGitlabProjectHooks"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_hooks gitlab_project_hooks}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.Initializer"></a>

```typescript
import { DataGitlabProjectHooks } from '@cdktf/provider-gitlab'

new DataGitlabProjectHooks(scope: Construct, id: string, config: DataGitlabProjectHooksConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooksConfig">DataGitlabProjectHooksConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectHooksConfig">DataGitlabProjectHooksConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.isConstruct"></a>

```typescript
import { DataGitlabProjectHooks } from '@cdktf/provider-gitlab'

DataGitlabProjectHooks.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.hooks">hooks</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooksHooksList">DataGitlabProjectHooksHooksList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `hooks`<sup>Required</sup> <a name="hooks" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.hooks"></a>

```typescript
public readonly hooks: DataGitlabProjectHooksHooksList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectHooksHooksList">DataGitlabProjectHooksHooksList</a>

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectHooks.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectHooks.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectIssue <a name="DataGitlabProjectIssue" id="@cdktf/provider-gitlab.DataGitlabProjectIssue"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_issue gitlab_project_issue}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.Initializer"></a>

```typescript
import { DataGitlabProjectIssue } from '@cdktf/provider-gitlab'

new DataGitlabProjectIssue(scope: Construct, id: string, config: DataGitlabProjectIssueConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssueConfig">DataGitlabProjectIssueConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectIssueConfig">DataGitlabProjectIssueConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.isConstruct"></a>

```typescript
import { DataGitlabProjectIssue } from '@cdktf/provider-gitlab'

DataGitlabProjectIssue.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.assigneeIds">assigneeIds</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.authorId">authorId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.closedAt">closedAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.closedByUserId">closedByUserId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.confidential">confidential</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.createdAt">createdAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.discussionLocked">discussionLocked</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.discussionToResolve">discussionToResolve</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.downvotes">downvotes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.dueDate">dueDate</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.epicId">epicId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.epicIssueId">epicIssueId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.externalId">externalId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.humanTimeEstimate">humanTimeEstimate</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.humanTotalTimeSpent">humanTotalTimeSpent</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.issueId">issueId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.issueLinkId">issueLinkId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.issueType">issueType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.labels">labels</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.links">links</a></code> | <code>cdktf.StringMap</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.mergeRequestsCount">mergeRequestsCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.mergeRequestToResolveDiscussionsOf">mergeRequestToResolveDiscussionsOf</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.milestoneId">milestoneId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.movedToId">movedToId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.references">references</a></code> | <code>cdktf.StringMap</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.state">state</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.subscribed">subscribed</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.taskCompletionStatus">taskCompletionStatus</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssueTaskCompletionStatusList">DataGitlabProjectIssueTaskCompletionStatusList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.timeEstimate">timeEstimate</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.title">title</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.totalTimeSpent">totalTimeSpent</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.updatedAt">updatedAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.upvotes">upvotes</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.userNotesCount">userNotesCount</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.webUrl">webUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.weight">weight</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.iidInput">iidInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.iid">iid</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `assigneeIds`<sup>Required</sup> <a name="assigneeIds" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.assigneeIds"></a>

```typescript
public readonly assigneeIds: number[];
```

- *Type:* number[]

---

##### `authorId`<sup>Required</sup> <a name="authorId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.authorId"></a>

```typescript
public readonly authorId: number;
```

- *Type:* number

---

##### `closedAt`<sup>Required</sup> <a name="closedAt" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.closedAt"></a>

```typescript
public readonly closedAt: string;
```

- *Type:* string

---

##### `closedByUserId`<sup>Required</sup> <a name="closedByUserId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.closedByUserId"></a>

```typescript
public readonly closedByUserId: number;
```

- *Type:* number

---

##### `confidential`<sup>Required</sup> <a name="confidential" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.confidential"></a>

```typescript
public readonly confidential: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `createdAt`<sup>Required</sup> <a name="createdAt" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.createdAt"></a>

```typescript
public readonly createdAt: string;
```

- *Type:* string

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `discussionLocked`<sup>Required</sup> <a name="discussionLocked" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.discussionLocked"></a>

```typescript
public readonly discussionLocked: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `discussionToResolve`<sup>Required</sup> <a name="discussionToResolve" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.discussionToResolve"></a>

```typescript
public readonly discussionToResolve: string;
```

- *Type:* string

---

##### `downvotes`<sup>Required</sup> <a name="downvotes" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.downvotes"></a>

```typescript
public readonly downvotes: number;
```

- *Type:* number

---

##### `dueDate`<sup>Required</sup> <a name="dueDate" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.dueDate"></a>

```typescript
public readonly dueDate: string;
```

- *Type:* string

---

##### `epicId`<sup>Required</sup> <a name="epicId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.epicId"></a>

```typescript
public readonly epicId: number;
```

- *Type:* number

---

##### `epicIssueId`<sup>Required</sup> <a name="epicIssueId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.epicIssueId"></a>

```typescript
public readonly epicIssueId: number;
```

- *Type:* number

---

##### `externalId`<sup>Required</sup> <a name="externalId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.externalId"></a>

```typescript
public readonly externalId: string;
```

- *Type:* string

---

##### `humanTimeEstimate`<sup>Required</sup> <a name="humanTimeEstimate" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.humanTimeEstimate"></a>

```typescript
public readonly humanTimeEstimate: string;
```

- *Type:* string

---

##### `humanTotalTimeSpent`<sup>Required</sup> <a name="humanTotalTimeSpent" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.humanTotalTimeSpent"></a>

```typescript
public readonly humanTotalTimeSpent: string;
```

- *Type:* string

---

##### `issueId`<sup>Required</sup> <a name="issueId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.issueId"></a>

```typescript
public readonly issueId: number;
```

- *Type:* number

---

##### `issueLinkId`<sup>Required</sup> <a name="issueLinkId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.issueLinkId"></a>

```typescript
public readonly issueLinkId: number;
```

- *Type:* number

---

##### `issueType`<sup>Required</sup> <a name="issueType" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.issueType"></a>

```typescript
public readonly issueType: string;
```

- *Type:* string

---

##### `labels`<sup>Required</sup> <a name="labels" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.labels"></a>

```typescript
public readonly labels: string[];
```

- *Type:* string[]

---

##### `links`<sup>Required</sup> <a name="links" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.links"></a>

```typescript
public readonly links: StringMap;
```

- *Type:* cdktf.StringMap

---

##### `mergeRequestsCount`<sup>Required</sup> <a name="mergeRequestsCount" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.mergeRequestsCount"></a>

```typescript
public readonly mergeRequestsCount: number;
```

- *Type:* number

---

##### `mergeRequestToResolveDiscussionsOf`<sup>Required</sup> <a name="mergeRequestToResolveDiscussionsOf" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.mergeRequestToResolveDiscussionsOf"></a>

```typescript
public readonly mergeRequestToResolveDiscussionsOf: number;
```

- *Type:* number

---

##### `milestoneId`<sup>Required</sup> <a name="milestoneId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.milestoneId"></a>

```typescript
public readonly milestoneId: number;
```

- *Type:* number

---

##### `movedToId`<sup>Required</sup> <a name="movedToId" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.movedToId"></a>

```typescript
public readonly movedToId: number;
```

- *Type:* number

---

##### `references`<sup>Required</sup> <a name="references" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.references"></a>

```typescript
public readonly references: StringMap;
```

- *Type:* cdktf.StringMap

---

##### `state`<sup>Required</sup> <a name="state" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.state"></a>

```typescript
public readonly state: string;
```

- *Type:* string

---

##### `subscribed`<sup>Required</sup> <a name="subscribed" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.subscribed"></a>

```typescript
public readonly subscribed: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `taskCompletionStatus`<sup>Required</sup> <a name="taskCompletionStatus" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.taskCompletionStatus"></a>

```typescript
public readonly taskCompletionStatus: DataGitlabProjectIssueTaskCompletionStatusList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectIssueTaskCompletionStatusList">DataGitlabProjectIssueTaskCompletionStatusList</a>

---

##### `timeEstimate`<sup>Required</sup> <a name="timeEstimate" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.timeEstimate"></a>

```typescript
public readonly timeEstimate: number;
```

- *Type:* number

---

##### `title`<sup>Required</sup> <a name="title" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string

---

##### `totalTimeSpent`<sup>Required</sup> <a name="totalTimeSpent" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.totalTimeSpent"></a>

```typescript
public readonly totalTimeSpent: number;
```

- *Type:* number

---

##### `updatedAt`<sup>Required</sup> <a name="updatedAt" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.updatedAt"></a>

```typescript
public readonly updatedAt: string;
```

- *Type:* string

---

##### `upvotes`<sup>Required</sup> <a name="upvotes" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.upvotes"></a>

```typescript
public readonly upvotes: number;
```

- *Type:* number

---

##### `userNotesCount`<sup>Required</sup> <a name="userNotesCount" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.userNotesCount"></a>

```typescript
public readonly userNotesCount: number;
```

- *Type:* number

---

##### `webUrl`<sup>Required</sup> <a name="webUrl" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.webUrl"></a>

```typescript
public readonly webUrl: string;
```

- *Type:* string

---

##### `weight`<sup>Required</sup> <a name="weight" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.weight"></a>

```typescript
public readonly weight: number;
```

- *Type:* number

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `iidInput`<sup>Optional</sup> <a name="iidInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.iidInput"></a>

```typescript
public readonly iidInput: number;
```

- *Type:* number

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `iid`<sup>Required</sup> <a name="iid" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.iid"></a>

```typescript
public readonly iid: number;
```

- *Type:* number

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssue.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectIssue.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectIssues <a name="DataGitlabProjectIssues" id="@cdktf/provider-gitlab.DataGitlabProjectIssues"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_issues gitlab_project_issues}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.Initializer"></a>

```typescript
import { DataGitlabProjectIssues } from '@cdktf/provider-gitlab'

new DataGitlabProjectIssues(scope: Construct, id: string, config: DataGitlabProjectIssuesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssuesConfig">DataGitlabProjectIssuesConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectIssuesConfig">DataGitlabProjectIssuesConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetAssigneeId">resetAssigneeId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetAssigneeUsername">resetAssigneeUsername</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetAuthorId">resetAuthorId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetConfidential">resetConfidential</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetCreatedAfter">resetCreatedAfter</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetCreatedBefore">resetCreatedBefore</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetDueDate">resetDueDate</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetIids">resetIids</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetIssueType">resetIssueType</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetLabels">resetLabels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetMilestone">resetMilestone</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetMyReactionEmoji">resetMyReactionEmoji</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotAssigneeId">resetNotAssigneeId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotAuthorId">resetNotAuthorId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotLabels">resetNotLabels</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotMilestone">resetNotMilestone</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotMyReactionEmoji">resetNotMyReactionEmoji</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetOrderBy">resetOrderBy</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetScope">resetScope</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetSearch">resetSearch</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetSort">resetSort</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetUpdatedAfter">resetUpdatedAfter</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetUpdatedBefore">resetUpdatedBefore</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetWeight">resetWeight</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.resetWithLabelsDetails">resetWithLabelsDetails</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetAssigneeId` <a name="resetAssigneeId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetAssigneeId"></a>

```typescript
public resetAssigneeId(): void
```

##### `resetAssigneeUsername` <a name="resetAssigneeUsername" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetAssigneeUsername"></a>

```typescript
public resetAssigneeUsername(): void
```

##### `resetAuthorId` <a name="resetAuthorId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetAuthorId"></a>

```typescript
public resetAuthorId(): void
```

##### `resetConfidential` <a name="resetConfidential" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetConfidential"></a>

```typescript
public resetConfidential(): void
```

##### `resetCreatedAfter` <a name="resetCreatedAfter" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetCreatedAfter"></a>

```typescript
public resetCreatedAfter(): void
```

##### `resetCreatedBefore` <a name="resetCreatedBefore" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetCreatedBefore"></a>

```typescript
public resetCreatedBefore(): void
```

##### `resetDueDate` <a name="resetDueDate" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetDueDate"></a>

```typescript
public resetDueDate(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetId"></a>

```typescript
public resetId(): void
```

##### `resetIids` <a name="resetIids" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetIids"></a>

```typescript
public resetIids(): void
```

##### `resetIssueType` <a name="resetIssueType" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetIssueType"></a>

```typescript
public resetIssueType(): void
```

##### `resetLabels` <a name="resetLabels" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetLabels"></a>

```typescript
public resetLabels(): void
```

##### `resetMilestone` <a name="resetMilestone" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetMilestone"></a>

```typescript
public resetMilestone(): void
```

##### `resetMyReactionEmoji` <a name="resetMyReactionEmoji" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetMyReactionEmoji"></a>

```typescript
public resetMyReactionEmoji(): void
```

##### `resetNotAssigneeId` <a name="resetNotAssigneeId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotAssigneeId"></a>

```typescript
public resetNotAssigneeId(): void
```

##### `resetNotAuthorId` <a name="resetNotAuthorId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotAuthorId"></a>

```typescript
public resetNotAuthorId(): void
```

##### `resetNotLabels` <a name="resetNotLabels" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotLabels"></a>

```typescript
public resetNotLabels(): void
```

##### `resetNotMilestone` <a name="resetNotMilestone" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotMilestone"></a>

```typescript
public resetNotMilestone(): void
```

##### `resetNotMyReactionEmoji` <a name="resetNotMyReactionEmoji" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetNotMyReactionEmoji"></a>

```typescript
public resetNotMyReactionEmoji(): void
```

##### `resetOrderBy` <a name="resetOrderBy" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetOrderBy"></a>

```typescript
public resetOrderBy(): void
```

##### `resetScope` <a name="resetScope" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetScope"></a>

```typescript
public resetScope(): void
```

##### `resetSearch` <a name="resetSearch" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetSearch"></a>

```typescript
public resetSearch(): void
```

##### `resetSort` <a name="resetSort" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetSort"></a>

```typescript
public resetSort(): void
```

##### `resetUpdatedAfter` <a name="resetUpdatedAfter" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetUpdatedAfter"></a>

```typescript
public resetUpdatedAfter(): void
```

##### `resetUpdatedBefore` <a name="resetUpdatedBefore" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetUpdatedBefore"></a>

```typescript
public resetUpdatedBefore(): void
```

##### `resetWeight` <a name="resetWeight" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetWeight"></a>

```typescript
public resetWeight(): void
```

##### `resetWithLabelsDetails` <a name="resetWithLabelsDetails" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.resetWithLabelsDetails"></a>

```typescript
public resetWithLabelsDetails(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.isConstruct"></a>

```typescript
import { DataGitlabProjectIssues } from '@cdktf/provider-gitlab'

DataGitlabProjectIssues.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.issues">issues</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssuesIssuesList">DataGitlabProjectIssuesIssuesList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeIdInput">assigneeIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeUsernameInput">assigneeUsernameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.authorIdInput">authorIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.confidentialInput">confidentialInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdAfterInput">createdAfterInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdBeforeInput">createdBeforeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.dueDateInput">dueDateInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.iidsInput">iidsInput</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.issueTypeInput">issueTypeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.labelsInput">labelsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.milestoneInput">milestoneInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.myReactionEmojiInput">myReactionEmojiInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAssigneeIdInput">notAssigneeIdInput</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAuthorIdInput">notAuthorIdInput</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notLabelsInput">notLabelsInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMilestoneInput">notMilestoneInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMyReactionEmojiInput">notMyReactionEmojiInput</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.orderByInput">orderByInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.scopeInput">scopeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.searchInput">searchInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.sortInput">sortInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedAfterInput">updatedAfterInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedBeforeInput">updatedBeforeInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.weightInput">weightInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.withLabelsDetailsInput">withLabelsDetailsInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeId">assigneeId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeUsername">assigneeUsername</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.authorId">authorId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.confidential">confidential</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdAfter">createdAfter</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdBefore">createdBefore</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.dueDate">dueDate</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.iids">iids</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.issueType">issueType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.labels">labels</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.milestone">milestone</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.myReactionEmoji">myReactionEmoji</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAssigneeId">notAssigneeId</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAuthorId">notAuthorId</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notLabels">notLabels</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMilestone">notMilestone</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMyReactionEmoji">notMyReactionEmoji</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.orderBy">orderBy</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.project">project</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.scope">scope</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.search">search</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.sort">sort</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedAfter">updatedAfter</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedBefore">updatedBefore</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.weight">weight</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.withLabelsDetails">withLabelsDetails</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `issues`<sup>Required</sup> <a name="issues" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.issues"></a>

```typescript
public readonly issues: DataGitlabProjectIssuesIssuesList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectIssuesIssuesList">DataGitlabProjectIssuesIssuesList</a>

---

##### `assigneeIdInput`<sup>Optional</sup> <a name="assigneeIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeIdInput"></a>

```typescript
public readonly assigneeIdInput: number;
```

- *Type:* number

---

##### `assigneeUsernameInput`<sup>Optional</sup> <a name="assigneeUsernameInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeUsernameInput"></a>

```typescript
public readonly assigneeUsernameInput: string;
```

- *Type:* string

---

##### `authorIdInput`<sup>Optional</sup> <a name="authorIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.authorIdInput"></a>

```typescript
public readonly authorIdInput: number;
```

- *Type:* number

---

##### `confidentialInput`<sup>Optional</sup> <a name="confidentialInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.confidentialInput"></a>

```typescript
public readonly confidentialInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `createdAfterInput`<sup>Optional</sup> <a name="createdAfterInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdAfterInput"></a>

```typescript
public readonly createdAfterInput: string;
```

- *Type:* string

---

##### `createdBeforeInput`<sup>Optional</sup> <a name="createdBeforeInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdBeforeInput"></a>

```typescript
public readonly createdBeforeInput: string;
```

- *Type:* string

---

##### `dueDateInput`<sup>Optional</sup> <a name="dueDateInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.dueDateInput"></a>

```typescript
public readonly dueDateInput: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `iidsInput`<sup>Optional</sup> <a name="iidsInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.iidsInput"></a>

```typescript
public readonly iidsInput: number[];
```

- *Type:* number[]

---

##### `issueTypeInput`<sup>Optional</sup> <a name="issueTypeInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.issueTypeInput"></a>

```typescript
public readonly issueTypeInput: string;
```

- *Type:* string

---

##### `labelsInput`<sup>Optional</sup> <a name="labelsInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.labelsInput"></a>

```typescript
public readonly labelsInput: string[];
```

- *Type:* string[]

---

##### `milestoneInput`<sup>Optional</sup> <a name="milestoneInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.milestoneInput"></a>

```typescript
public readonly milestoneInput: string;
```

- *Type:* string

---

##### `myReactionEmojiInput`<sup>Optional</sup> <a name="myReactionEmojiInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.myReactionEmojiInput"></a>

```typescript
public readonly myReactionEmojiInput: string;
```

- *Type:* string

---

##### `notAssigneeIdInput`<sup>Optional</sup> <a name="notAssigneeIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAssigneeIdInput"></a>

```typescript
public readonly notAssigneeIdInput: number[];
```

- *Type:* number[]

---

##### `notAuthorIdInput`<sup>Optional</sup> <a name="notAuthorIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAuthorIdInput"></a>

```typescript
public readonly notAuthorIdInput: number[];
```

- *Type:* number[]

---

##### `notLabelsInput`<sup>Optional</sup> <a name="notLabelsInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notLabelsInput"></a>

```typescript
public readonly notLabelsInput: string[];
```

- *Type:* string[]

---

##### `notMilestoneInput`<sup>Optional</sup> <a name="notMilestoneInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMilestoneInput"></a>

```typescript
public readonly notMilestoneInput: string;
```

- *Type:* string

---

##### `notMyReactionEmojiInput`<sup>Optional</sup> <a name="notMyReactionEmojiInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMyReactionEmojiInput"></a>

```typescript
public readonly notMyReactionEmojiInput: string[];
```

- *Type:* string[]

---

##### `orderByInput`<sup>Optional</sup> <a name="orderByInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.orderByInput"></a>

```typescript
public readonly orderByInput: string;
```

- *Type:* string

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `scopeInput`<sup>Optional</sup> <a name="scopeInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.scopeInput"></a>

```typescript
public readonly scopeInput: string;
```

- *Type:* string

---

##### `searchInput`<sup>Optional</sup> <a name="searchInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.searchInput"></a>

```typescript
public readonly searchInput: string;
```

- *Type:* string

---

##### `sortInput`<sup>Optional</sup> <a name="sortInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.sortInput"></a>

```typescript
public readonly sortInput: string;
```

- *Type:* string

---

##### `updatedAfterInput`<sup>Optional</sup> <a name="updatedAfterInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedAfterInput"></a>

```typescript
public readonly updatedAfterInput: string;
```

- *Type:* string

---

##### `updatedBeforeInput`<sup>Optional</sup> <a name="updatedBeforeInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedBeforeInput"></a>

```typescript
public readonly updatedBeforeInput: string;
```

- *Type:* string

---

##### `weightInput`<sup>Optional</sup> <a name="weightInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.weightInput"></a>

```typescript
public readonly weightInput: number;
```

- *Type:* number

---

##### `withLabelsDetailsInput`<sup>Optional</sup> <a name="withLabelsDetailsInput" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.withLabelsDetailsInput"></a>

```typescript
public readonly withLabelsDetailsInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `assigneeId`<sup>Required</sup> <a name="assigneeId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeId"></a>

```typescript
public readonly assigneeId: number;
```

- *Type:* number

---

##### `assigneeUsername`<sup>Required</sup> <a name="assigneeUsername" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.assigneeUsername"></a>

```typescript
public readonly assigneeUsername: string;
```

- *Type:* string

---

##### `authorId`<sup>Required</sup> <a name="authorId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.authorId"></a>

```typescript
public readonly authorId: number;
```

- *Type:* number

---

##### `confidential`<sup>Required</sup> <a name="confidential" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.confidential"></a>

```typescript
public readonly confidential: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `createdAfter`<sup>Required</sup> <a name="createdAfter" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdAfter"></a>

```typescript
public readonly createdAfter: string;
```

- *Type:* string

---

##### `createdBefore`<sup>Required</sup> <a name="createdBefore" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.createdBefore"></a>

```typescript
public readonly createdBefore: string;
```

- *Type:* string

---

##### `dueDate`<sup>Required</sup> <a name="dueDate" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.dueDate"></a>

```typescript
public readonly dueDate: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `iids`<sup>Required</sup> <a name="iids" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.iids"></a>

```typescript
public readonly iids: number[];
```

- *Type:* number[]

---

##### `issueType`<sup>Required</sup> <a name="issueType" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.issueType"></a>

```typescript
public readonly issueType: string;
```

- *Type:* string

---

##### `labels`<sup>Required</sup> <a name="labels" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.labels"></a>

```typescript
public readonly labels: string[];
```

- *Type:* string[]

---

##### `milestone`<sup>Required</sup> <a name="milestone" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.milestone"></a>

```typescript
public readonly milestone: string;
```

- *Type:* string

---

##### `myReactionEmoji`<sup>Required</sup> <a name="myReactionEmoji" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.myReactionEmoji"></a>

```typescript
public readonly myReactionEmoji: string;
```

- *Type:* string

---

##### `notAssigneeId`<sup>Required</sup> <a name="notAssigneeId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAssigneeId"></a>

```typescript
public readonly notAssigneeId: number[];
```

- *Type:* number[]

---

##### `notAuthorId`<sup>Required</sup> <a name="notAuthorId" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notAuthorId"></a>

```typescript
public readonly notAuthorId: number[];
```

- *Type:* number[]

---

##### `notLabels`<sup>Required</sup> <a name="notLabels" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notLabels"></a>

```typescript
public readonly notLabels: string[];
```

- *Type:* string[]

---

##### `notMilestone`<sup>Required</sup> <a name="notMilestone" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMilestone"></a>

```typescript
public readonly notMilestone: string;
```

- *Type:* string

---

##### `notMyReactionEmoji`<sup>Required</sup> <a name="notMyReactionEmoji" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.notMyReactionEmoji"></a>

```typescript
public readonly notMyReactionEmoji: string[];
```

- *Type:* string[]

---

##### `orderBy`<sup>Required</sup> <a name="orderBy" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.orderBy"></a>

```typescript
public readonly orderBy: string;
```

- *Type:* string

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.scope"></a>

```typescript
public readonly scope: string;
```

- *Type:* string

---

##### `search`<sup>Required</sup> <a name="search" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.search"></a>

```typescript
public readonly search: string;
```

- *Type:* string

---

##### `sort`<sup>Required</sup> <a name="sort" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.sort"></a>

```typescript
public readonly sort: string;
```

- *Type:* string

---

##### `updatedAfter`<sup>Required</sup> <a name="updatedAfter" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedAfter"></a>

```typescript
public readonly updatedAfter: string;
```

- *Type:* string

---

##### `updatedBefore`<sup>Required</sup> <a name="updatedBefore" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.updatedBefore"></a>

```typescript
public readonly updatedBefore: string;
```

- *Type:* string

---

##### `weight`<sup>Required</sup> <a name="weight" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.weight"></a>

```typescript
public readonly weight: number;
```

- *Type:* number

---

##### `withLabelsDetails`<sup>Required</sup> <a name="withLabelsDetails" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.withLabelsDetails"></a>

```typescript
public readonly withLabelsDetails: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectIssues.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectIssues.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectMembership <a name="DataGitlabProjectMembership" id="@cdktf/provider-gitlab.DataGitlabProjectMembership"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_membership gitlab_project_membership}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.Initializer"></a>

```typescript
import { DataGitlabProjectMembership } from '@cdktf/provider-gitlab'

new DataGitlabProjectMembership(scope: Construct, id: string, config?: DataGitlabProjectMembershipConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembershipConfig">DataGitlabProjectMembershipConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Optional</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectMembershipConfig">DataGitlabProjectMembershipConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.resetFullPath">resetFullPath</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.resetInherited">resetInherited</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.resetProjectId">resetProjectId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.resetQuery">resetQuery</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetFullPath` <a name="resetFullPath" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.resetFullPath"></a>

```typescript
public resetFullPath(): void
```

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.resetId"></a>

```typescript
public resetId(): void
```

##### `resetInherited` <a name="resetInherited" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.resetInherited"></a>

```typescript
public resetInherited(): void
```

##### `resetProjectId` <a name="resetProjectId" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.resetProjectId"></a>

```typescript
public resetProjectId(): void
```

##### `resetQuery` <a name="resetQuery" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.resetQuery"></a>

```typescript
public resetQuery(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.isConstruct"></a>

```typescript
import { DataGitlabProjectMembership } from '@cdktf/provider-gitlab'

DataGitlabProjectMembership.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.members">members</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembershipMembersList">DataGitlabProjectMembershipMembersList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.fullPathInput">fullPathInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.inheritedInput">inheritedInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.projectIdInput">projectIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.queryInput">queryInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.fullPath">fullPath</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.inherited">inherited</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.projectId">projectId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.query">query</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `members`<sup>Required</sup> <a name="members" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.members"></a>

```typescript
public readonly members: DataGitlabProjectMembershipMembersList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectMembershipMembersList">DataGitlabProjectMembershipMembersList</a>

---

##### `fullPathInput`<sup>Optional</sup> <a name="fullPathInput" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.fullPathInput"></a>

```typescript
public readonly fullPathInput: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `inheritedInput`<sup>Optional</sup> <a name="inheritedInput" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.inheritedInput"></a>

```typescript
public readonly inheritedInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `projectIdInput`<sup>Optional</sup> <a name="projectIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.projectIdInput"></a>

```typescript
public readonly projectIdInput: number;
```

- *Type:* number

---

##### `queryInput`<sup>Optional</sup> <a name="queryInput" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.queryInput"></a>

```typescript
public readonly queryInput: string;
```

- *Type:* string

---

##### `fullPath`<sup>Required</sup> <a name="fullPath" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.fullPath"></a>

```typescript
public readonly fullPath: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `inherited`<sup>Required</sup> <a name="inherited" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.inherited"></a>

```typescript
public readonly inherited: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `projectId`<sup>Required</sup> <a name="projectId" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.projectId"></a>

```typescript
public readonly projectId: number;
```

- *Type:* number

---

##### `query`<sup>Required</sup> <a name="query" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.query"></a>

```typescript
public readonly query: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMembership.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectMembership.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectMilestone <a name="DataGitlabProjectMilestone" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestone gitlab_project_milestone}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.Initializer"></a>

```typescript
import { DataGitlabProjectMilestone } from '@cdktf/provider-gitlab'

new DataGitlabProjectMilestone(scope: Construct, id: string, config: DataGitlabProjectMilestoneConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestoneConfig">DataGitlabProjectMilestoneConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestoneConfig">DataGitlabProjectMilestoneConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.isConstruct"></a>

```typescript
import { DataGitlabProjectMilestone } from '@cdktf/provider-gitlab'

DataGitlabProjectMilestone.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.createdAt">createdAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.description">description</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.dueDate">dueDate</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.expired">expired</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.iid">iid</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.projectId">projectId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.startDate">startDate</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.state">state</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.title">title</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.updatedAt">updatedAt</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.webUrl">webUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.milestoneIdInput">milestoneIdInput</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.milestoneId">milestoneId</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.project">project</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `createdAt`<sup>Required</sup> <a name="createdAt" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.createdAt"></a>

```typescript
public readonly createdAt: string;
```

- *Type:* string

---

##### `description`<sup>Required</sup> <a name="description" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.description"></a>

```typescript
public readonly description: string;
```

- *Type:* string

---

##### `dueDate`<sup>Required</sup> <a name="dueDate" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.dueDate"></a>

```typescript
public readonly dueDate: string;
```

- *Type:* string

---

##### `expired`<sup>Required</sup> <a name="expired" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.expired"></a>

```typescript
public readonly expired: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `iid`<sup>Required</sup> <a name="iid" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.iid"></a>

```typescript
public readonly iid: number;
```

- *Type:* number

---

##### `projectId`<sup>Required</sup> <a name="projectId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.projectId"></a>

```typescript
public readonly projectId: number;
```

- *Type:* number

---

##### `startDate`<sup>Required</sup> <a name="startDate" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.startDate"></a>

```typescript
public readonly startDate: string;
```

- *Type:* string

---

##### `state`<sup>Required</sup> <a name="state" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.state"></a>

```typescript
public readonly state: string;
```

- *Type:* string

---

##### `title`<sup>Required</sup> <a name="title" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string

---

##### `updatedAt`<sup>Required</sup> <a name="updatedAt" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.updatedAt"></a>

```typescript
public readonly updatedAt: string;
```

- *Type:* string

---

##### `webUrl`<sup>Required</sup> <a name="webUrl" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.webUrl"></a>

```typescript
public readonly webUrl: string;
```

- *Type:* string

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `milestoneIdInput`<sup>Optional</sup> <a name="milestoneIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.milestoneIdInput"></a>

```typescript
public readonly milestoneIdInput: number;
```

- *Type:* number

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `milestoneId`<sup>Required</sup> <a name="milestoneId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.milestoneId"></a>

```typescript
public readonly milestoneId: number;
```

- *Type:* number

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectMilestone.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectMilestones <a name="DataGitlabProjectMilestones" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_milestones gitlab_project_milestones}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.Initializer"></a>

```typescript
import { DataGitlabProjectMilestones } from '@cdktf/provider-gitlab'

new DataGitlabProjectMilestones(scope: Construct, id: string, config: DataGitlabProjectMilestonesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestonesConfig">DataGitlabProjectMilestonesConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestonesConfig">DataGitlabProjectMilestonesConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetId">resetId</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetIids">resetIids</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetIncludeParentMilestones">resetIncludeParentMilestones</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetSearch">resetSearch</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetState">resetState</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetTitle">resetTitle</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetId"></a>

```typescript
public resetId(): void
```

##### `resetIids` <a name="resetIids" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetIids"></a>

```typescript
public resetIids(): void
```

##### `resetIncludeParentMilestones` <a name="resetIncludeParentMilestones" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetIncludeParentMilestones"></a>

```typescript
public resetIncludeParentMilestones(): void
```

##### `resetSearch` <a name="resetSearch" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetSearch"></a>

```typescript
public resetSearch(): void
```

##### `resetState` <a name="resetState" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetState"></a>

```typescript
public resetState(): void
```

##### `resetTitle` <a name="resetTitle" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.resetTitle"></a>

```typescript
public resetTitle(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.isConstruct"></a>

```typescript
import { DataGitlabProjectMilestones } from '@cdktf/provider-gitlab'

DataGitlabProjectMilestones.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.milestones">milestones</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestonesMilestonesList">DataGitlabProjectMilestonesMilestonesList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.idInput">idInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.iidsInput">iidsInput</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.includeParentMilestonesInput">includeParentMilestonesInput</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.projectInput">projectInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.searchInput">searchInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.stateInput">stateInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.titleInput">titleInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.iids">iids</a></code> | <code>number[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.includeParentMilestones">includeParentMilestones</a></code> | <code>boolean \| cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.project">project</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.search">search</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.state">state</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.title">title</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `milestones`<sup>Required</sup> <a name="milestones" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.milestones"></a>

```typescript
public readonly milestones: DataGitlabProjectMilestonesMilestonesList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestonesMilestonesList">DataGitlabProjectMilestonesMilestonesList</a>

---

##### `idInput`<sup>Optional</sup> <a name="idInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.idInput"></a>

```typescript
public readonly idInput: string;
```

- *Type:* string

---

##### `iidsInput`<sup>Optional</sup> <a name="iidsInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.iidsInput"></a>

```typescript
public readonly iidsInput: number[];
```

- *Type:* number[]

---

##### `includeParentMilestonesInput`<sup>Optional</sup> <a name="includeParentMilestonesInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.includeParentMilestonesInput"></a>

```typescript
public readonly includeParentMilestonesInput: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `projectInput`<sup>Optional</sup> <a name="projectInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.projectInput"></a>

```typescript
public readonly projectInput: string;
```

- *Type:* string

---

##### `searchInput`<sup>Optional</sup> <a name="searchInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.searchInput"></a>

```typescript
public readonly searchInput: string;
```

- *Type:* string

---

##### `stateInput`<sup>Optional</sup> <a name="stateInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.stateInput"></a>

```typescript
public readonly stateInput: string;
```

- *Type:* string

---

##### `titleInput`<sup>Optional</sup> <a name="titleInput" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.titleInput"></a>

```typescript
public readonly titleInput: string;
```

- *Type:* string

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `iids`<sup>Required</sup> <a name="iids" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.iids"></a>

```typescript
public readonly iids: number[];
```

- *Type:* number[]

---

##### `includeParentMilestones`<sup>Required</sup> <a name="includeParentMilestones" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.includeParentMilestones"></a>

```typescript
public readonly includeParentMilestones: boolean | IResolvable;
```

- *Type:* boolean | cdktf.IResolvable

---

##### `project`<sup>Required</sup> <a name="project" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.project"></a>

```typescript
public readonly project: string;
```

- *Type:* string

---

##### `search`<sup>Required</sup> <a name="search" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.search"></a>

```typescript
public readonly search: string;
```

- *Type:* string

---

##### `state`<sup>Required</sup> <a name="state" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.state"></a>

```typescript
public readonly state: string;
```

- *Type:* string

---

##### `title`<sup>Required</sup> <a name="title" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.title"></a>

```typescript
public readonly title: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectMilestones.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectProtectedBranch <a name="DataGitlabProjectProtectedBranch" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branch gitlab_project_protected_branch}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.Initializer"></a>

```typescript
import { DataGitlabProjectProtectedBranch } from '@cdktf/provider-gitlab'

new DataGitlabProjectProtectedBranch(scope: Construct, id: string, config: DataGitlabProjectProtectedBranchConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchConfig">DataGitlabProjectProtectedBranchConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchConfig">DataGitlabProjectProtectedBranchConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### `isConstruct` <a name="isConstruct" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.isConstruct"></a>

```typescript
import { DataGitlabProjectProtectedBranch } from '@cdktf/provider-gitlab'

DataGitlabProjectProtectedBranch.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.cdktfStack">cdktfStack</a></code> | <code>cdktf.TerraformStack</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.fqn">fqn</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.friendlyUniqueId">friendlyUniqueId</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.terraformMetaArguments">terraformMetaArguments</a></code> | <code>{[ key: string ]: any}</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.terraformResourceType">terraformResourceType</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.terraformGeneratorMetadata">terraformGeneratorMetadata</a></code> | <code>cdktf.TerraformProviderGeneratorMetadata</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.count">count</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.dependsOn">dependsOn</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.forEach">forEach</a></code> | <code>cdktf.ITerraformIterator</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.lifecycle">lifecycle</a></code> | <code>cdktf.TerraformResourceLifecycle</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.provider">provider</a></code> | <code>cdktf.TerraformProvider</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.allowForcePush">allowForcePush</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.codeOwnerApprovalRequired">codeOwnerApprovalRequired</a></code> | <code>cdktf.IResolvable</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.id">id</a></code> | <code>number</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.mergeAccessLevels">mergeAccessLevels</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchMergeAccessLevelsList">DataGitlabProjectProtectedBranchMergeAccessLevelsList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.pushAccessLevels">pushAccessLevels</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchPushAccessLevelsList">DataGitlabProjectProtectedBranchPushAccessLevelsList</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.nameInput">nameInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.projectIdInput">projectIdInput</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.name">name</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.projectId">projectId</a></code> | <code>string</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `cdktfStack`<sup>Required</sup> <a name="cdktfStack" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.cdktfStack"></a>

```typescript
public readonly cdktfStack: TerraformStack;
```

- *Type:* cdktf.TerraformStack

---

##### `fqn`<sup>Required</sup> <a name="fqn" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.fqn"></a>

```typescript
public readonly fqn: string;
```

- *Type:* string

---

##### `friendlyUniqueId`<sup>Required</sup> <a name="friendlyUniqueId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.friendlyUniqueId"></a>

```typescript
public readonly friendlyUniqueId: string;
```

- *Type:* string

---

##### `terraformMetaArguments`<sup>Required</sup> <a name="terraformMetaArguments" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.terraformMetaArguments"></a>

```typescript
public readonly terraformMetaArguments: {[ key: string ]: any};
```

- *Type:* {[ key: string ]: any}

---

##### `terraformResourceType`<sup>Required</sup> <a name="terraformResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.terraformResourceType"></a>

```typescript
public readonly terraformResourceType: string;
```

- *Type:* string

---

##### `terraformGeneratorMetadata`<sup>Optional</sup> <a name="terraformGeneratorMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.terraformGeneratorMetadata"></a>

```typescript
public readonly terraformGeneratorMetadata: TerraformProviderGeneratorMetadata;
```

- *Type:* cdktf.TerraformProviderGeneratorMetadata

---

##### `count`<sup>Optional</sup> <a name="count" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.count"></a>

```typescript
public readonly count: number;
```

- *Type:* number

---

##### `dependsOn`<sup>Optional</sup> <a name="dependsOn" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.dependsOn"></a>

```typescript
public readonly dependsOn: string[];
```

- *Type:* string[]

---

##### `forEach`<sup>Optional</sup> <a name="forEach" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.forEach"></a>

```typescript
public readonly forEach: ITerraformIterator;
```

- *Type:* cdktf.ITerraformIterator

---

##### `lifecycle`<sup>Optional</sup> <a name="lifecycle" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.lifecycle"></a>

```typescript
public readonly lifecycle: TerraformResourceLifecycle;
```

- *Type:* cdktf.TerraformResourceLifecycle

---

##### `provider`<sup>Optional</sup> <a name="provider" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.provider"></a>

```typescript
public readonly provider: TerraformProvider;
```

- *Type:* cdktf.TerraformProvider

---

##### `allowForcePush`<sup>Required</sup> <a name="allowForcePush" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.allowForcePush"></a>

```typescript
public readonly allowForcePush: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `codeOwnerApprovalRequired`<sup>Required</sup> <a name="codeOwnerApprovalRequired" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.codeOwnerApprovalRequired"></a>

```typescript
public readonly codeOwnerApprovalRequired: IResolvable;
```

- *Type:* cdktf.IResolvable

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.id"></a>

```typescript
public readonly id: number;
```

- *Type:* number

---

##### `mergeAccessLevels`<sup>Required</sup> <a name="mergeAccessLevels" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.mergeAccessLevels"></a>

```typescript
public readonly mergeAccessLevels: DataGitlabProjectProtectedBranchMergeAccessLevelsList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchMergeAccessLevelsList">DataGitlabProjectProtectedBranchMergeAccessLevelsList</a>

---

##### `pushAccessLevels`<sup>Required</sup> <a name="pushAccessLevels" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.pushAccessLevels"></a>

```typescript
public readonly pushAccessLevels: DataGitlabProjectProtectedBranchPushAccessLevelsList;
```

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchPushAccessLevelsList">DataGitlabProjectProtectedBranchPushAccessLevelsList</a>

---

##### `nameInput`<sup>Optional</sup> <a name="nameInput" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.nameInput"></a>

```typescript
public readonly nameInput: string;
```

- *Type:* string

---

##### `projectIdInput`<sup>Optional</sup> <a name="projectIdInput" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.projectIdInput"></a>

```typescript
public readonly projectIdInput: string;
```

- *Type:* string

---

##### `name`<sup>Required</sup> <a name="name" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

---

##### `projectId`<sup>Required</sup> <a name="projectId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.projectId"></a>

```typescript
public readonly projectId: string;
```

- *Type:* string

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.tfResourceType">tfResourceType</a></code> | <code>string</code> | *No description.* |

---

##### `tfResourceType`<sup>Required</sup> <a name="tfResourceType" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranch.property.tfResourceType"></a>

```typescript
public readonly tfResourceType: string;
```

- *Type:* string

---

### DataGitlabProjectProtectedBranches <a name="DataGitlabProjectProtectedBranches" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches"></a>

Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branches gitlab_project_protected_branches}.

#### Initializers <a name="Initializers" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.Initializer"></a>

```typescript
import { DataGitlabProjectProtectedBranches } from '@cdktf/provider-gitlab'

new DataGitlabProjectProtectedBranches(scope: Construct, id: string, config: DataGitlabProjectProtectedBranchesConfig)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | The scope in which to define this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.Initializer.parameter.id">id</a></code> | <code>string</code> | The scoped construct ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.Initializer.parameter.config">config</a></code> | <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchesConfig">DataGitlabProjectProtectedBranchesConfig</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

The scope in which to define this construct.

---

##### `id`<sup>Required</sup> <a name="id" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.Initializer.parameter.id"></a>

- *Type:* string

The scoped construct ID.

Must be unique amongst siblings in the same scope

---

##### `config`<sup>Required</sup> <a name="config" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.Initializer.parameter.config"></a>

- *Type:* <a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranchesConfig">DataGitlabProjectProtectedBranchesConfig</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.addOverride">addOverride</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.overrideLogicalId">overrideLogicalId</a></code> | Overrides the auto-generated logical ID with a specific ID. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.resetOverrideLogicalId">resetOverrideLogicalId</a></code> | Resets a previously passed logical Id to use the auto-generated logical id again. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.toMetadata">toMetadata</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.toTerraform">toTerraform</a></code> | Adds this resource to the terraform JSON output. |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getAnyMapAttribute">getAnyMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getBooleanAttribute">getBooleanAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getBooleanMapAttribute">getBooleanMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getListAttribute">getListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberAttribute">getNumberAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberListAttribute">getNumberListAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberMapAttribute">getNumberMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getStringAttribute">getStringAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getStringMapAttribute">getStringMapAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.interpolationForAttribute">interpolationForAttribute</a></code> | *No description.* |
| <code><a href="#@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.resetId">resetId</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addOverride` <a name="addOverride" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.addOverride"></a>

```typescript
public addOverride(path: string, value: any): void
```

###### `path`<sup>Required</sup> <a name="path" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.addOverride.parameter.path"></a>

- *Type:* string

---

###### `value`<sup>Required</sup> <a name="value" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.addOverride.parameter.value"></a>

- *Type:* any

---

##### `overrideLogicalId` <a name="overrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.overrideLogicalId"></a>

```typescript
public overrideLogicalId(newLogicalId: string): void
```

Overrides the auto-generated logical ID with a specific ID.

###### `newLogicalId`<sup>Required</sup> <a name="newLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.overrideLogicalId.parameter.newLogicalId"></a>

- *Type:* string

The new logical ID to use for this stack element.

---

##### `resetOverrideLogicalId` <a name="resetOverrideLogicalId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.resetOverrideLogicalId"></a>

```typescript
public resetOverrideLogicalId(): void
```

Resets a previously passed logical Id to use the auto-generated logical id again.

##### `toMetadata` <a name="toMetadata" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.toMetadata"></a>

```typescript
public toMetadata(): any
```

##### `toTerraform` <a name="toTerraform" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.toTerraform"></a>

```typescript
public toTerraform(): any
```

Adds this resource to the terraform JSON output.

##### `getAnyMapAttribute` <a name="getAnyMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getAnyMapAttribute"></a>

```typescript
public getAnyMapAttribute(terraformAttribute: string): {[ key: string ]: any}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getAnyMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanAttribute` <a name="getBooleanAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getBooleanAttribute"></a>

```typescript
public getBooleanAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getBooleanAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getBooleanMapAttribute` <a name="getBooleanMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getBooleanMapAttribute"></a>

```typescript
public getBooleanMapAttribute(terraformAttribute: string): {[ key: string ]: boolean}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getBooleanMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getListAttribute` <a name="getListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getListAttribute"></a>

```typescript
public getListAttribute(terraformAttribute: string): string[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberAttribute` <a name="getNumberAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberAttribute"></a>

```typescript
public getNumberAttribute(terraformAttribute: string): number
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberListAttribute` <a name="getNumberListAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberListAttribute"></a>

```typescript
public getNumberListAttribute(terraformAttribute: string): number[]
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberListAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getNumberMapAttribute` <a name="getNumberMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberMapAttribute"></a>

```typescript
public getNumberMapAttribute(terraformAttribute: string): {[ key: string ]: number}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getNumberMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringAttribute` <a name="getStringAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getStringAttribute"></a>

```typescript
public getStringAttribute(terraformAttribute: string): string
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getStringAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `getStringMapAttribute` <a name="getStringMapAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getStringMapAttribute"></a>

```typescript
public getStringMapAttribute(terraformAttribute: string): {[ key: string ]: string}
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.getStringMapAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `interpolationForAttribute` <a name="interpolationForAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.interpolationForAttribute"></a>

```typescript
public interpolationForAttribute(terraformAttribute: string): IResolvable
```

###### `terraformAttribute`<sup>Required</sup> <a name="terraformAttribute" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.interpolationForAttribute.parameter.terraformAttribute"></a>

- *Type:* string

---

##### `resetId` <a name="resetId" id="@cdktf/provider-gitlab.DataGitlabProjectProtectedBranches.resetId"></a>

```typescript
public resetId(): void
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@cdktf/provider-gitlab.Da