import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectProtectedBranchesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branches#id DataGitlabProjectProtectedBranches#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The integer or path with namespace that uniquely identifies the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branches#project_id DataGitlabProjectProtectedBranches#project_id}
    */
    readonly projectId: string;
}
export interface DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevels {
}
export declare function dataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevelsToTerraform(struct?: DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevels): any;
export declare class DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevels | undefined;
    set internalValue(value: DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevels | undefined);
    get accessLevel(): string;
    get accessLevelDescription(): string;
    get groupId(): number;
    get userId(): number;
}
export declare class DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevelsOutputReference;
}
export interface DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevels {
}
export declare function dataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevelsToTerraform(struct?: DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevels): any;
export declare class DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevels | undefined;
    set internalValue(value: DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevels | undefined);
    get accessLevel(): string;
    get accessLevelDescription(): string;
    get groupId(): number;
    get userId(): number;
}
export declare class DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevelsOutputReference;
}
export interface DataGitlabProjectProtectedBranchesProtectedBranches {
}
export declare function dataGitlabProjectProtectedBranchesProtectedBranchesToTerraform(struct?: DataGitlabProjectProtectedBranchesProtectedBranches): any;
export declare class DataGitlabProjectProtectedBranchesProtectedBranchesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectProtectedBranchesProtectedBranches | undefined;
    set internalValue(value: DataGitlabProjectProtectedBranchesProtectedBranches | undefined);
    get allowForcePush(): cdktf.IResolvable;
    get codeOwnerApprovalRequired(): cdktf.IResolvable;
    get id(): number;
    private _mergeAccessLevels;
    get mergeAccessLevels(): DataGitlabProjectProtectedBranchesProtectedBranchesMergeAccessLevelsList;
    get name(): string;
    private _pushAccessLevels;
    get pushAccessLevels(): DataGitlabProjectProtectedBranchesProtectedBranchesPushAccessLevelsList;
}
export declare class DataGitlabProjectProtectedBranchesProtectedBranchesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectProtectedBranchesProtectedBranchesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branches gitlab_project_protected_branches}
*/
export declare class DataGitlabProjectProtectedBranches extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_protected_branches";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_protected_branches gitlab_project_protected_branches} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectProtectedBranchesConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectProtectedBranchesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _protectedBranches;
    get protectedBranches(): DataGitlabProjectProtectedBranchesProtectedBranchesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
