import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectTagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_tags#id DataGitlabProjectTags#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Return tags ordered by `name` or `updated` fields. Default is `updated`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_tags#order_by DataGitlabProjectTags#order_by}
    */
    readonly orderBy?: string;
    /**
    * The ID or URL-encoded path of the project owned by the authenticated user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_tags#project DataGitlabProjectTags#project}
    */
    readonly project: string;
    /**
    * Return list of tags matching the search criteria. You can use `^term` and `term$` to find tags that begin and end with `term` respectively. No other regular expressions are supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_tags#search DataGitlabProjectTags#search}
    */
    readonly search?: string;
    /**
    * Return tags sorted in `asc` or `desc` order. Default is `desc`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_tags#sort DataGitlabProjectTags#sort}
    */
    readonly sort?: string;
}
export interface DataGitlabProjectTagsTagsCommit {
}
export declare function dataGitlabProjectTagsTagsCommitToTerraform(struct?: DataGitlabProjectTagsTagsCommit): any;
export declare class DataGitlabProjectTagsTagsCommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectTagsTagsCommit | undefined;
    set internalValue(value: DataGitlabProjectTagsTagsCommit | undefined);
    get authorEmail(): string;
    get authorName(): string;
    get authoredDate(): string;
    get committedDate(): string;
    get committerEmail(): string;
    get committerName(): string;
    get id(): string;
    get message(): string;
    get parentIds(): string[];
    get shortId(): string;
    get title(): string;
}
export declare class DataGitlabProjectTagsTagsCommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectTagsTagsCommitOutputReference;
}
export interface DataGitlabProjectTagsTagsRelease {
}
export declare function dataGitlabProjectTagsTagsReleaseToTerraform(struct?: DataGitlabProjectTagsTagsRelease): any;
export declare class DataGitlabProjectTagsTagsReleaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectTagsTagsRelease | undefined;
    set internalValue(value: DataGitlabProjectTagsTagsRelease | undefined);
    get description(): string;
    get tagName(): string;
}
export declare class DataGitlabProjectTagsTagsReleaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectTagsTagsReleaseOutputReference;
}
export interface DataGitlabProjectTagsTags {
}
export declare function dataGitlabProjectTagsTagsToTerraform(struct?: DataGitlabProjectTagsTags): any;
export declare class DataGitlabProjectTagsTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGitlabProjectTagsTags | undefined;
    set internalValue(value: DataGitlabProjectTagsTags | undefined);
    private _commit;
    get commit(): DataGitlabProjectTagsTagsCommitList;
    get message(): string;
    get name(): string;
    get protected(): cdktf.IResolvable;
    private _release;
    get release(): DataGitlabProjectTagsTagsReleaseList;
    get target(): string;
}
export declare class DataGitlabProjectTagsTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGitlabProjectTagsTagsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_tags gitlab_project_tags}
*/
export declare class DataGitlabProjectTags extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_tags";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_tags gitlab_project_tags} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectTagsConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectTagsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _orderBy?;
    get orderBy(): string;
    set orderBy(value: string);
    resetOrderBy(): void;
    get orderByInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _sort?;
    get sort(): string;
    set sort(value: string);
    resetSort(): void;
    get sortInput(): string | undefined;
    private _tags;
    get tags(): DataGitlabProjectTagsTagsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
