import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserGpgkeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user_gpgkey#id UserGpgkey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The armored GPG public key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user_gpgkey#key UserGpgkey#key}
    */
    readonly key: string;
    /**
    * The ID of the user to add the GPG key to. If this field is omitted, this resource manages a GPG key for the current user. Otherwise, this resource manages a GPG key for the speicifed user, and an admin token is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/user_gpgkey#user_id UserGpgkey#user_id}
    */
    readonly userId?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/user_gpgkey gitlab_user_gpgkey}
*/
export declare class UserGpgkey extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_user_gpgkey";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/user_gpgkey gitlab_user_gpgkey} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserGpgkeyConfig
    */
    constructor(scope: Construct, id: string, config: UserGpgkeyConfig);
    get createdAt(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get keyId(): number;
    private _userId?;
    get userId(): number;
    set userId(value: number);
    resetUserId(): void;
    get userIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
