import * as cdk from 'aws-cdk-lib';
import { CustomResource } from 'aws-cdk-lib';
import * as lambda from 'aws-cdk-lib/aws-lambda';
import { AwsCustomResource } from 'aws-cdk-lib/custom-resources';
import { Construct } from 'constructs';
export interface ChimeResourceProps extends cdk.ResourceProps {
    readonly properties: {
        [propname: string]: any;
    };
    readonly resourceType: 'PhoneNumber' | 'VoiceConnector' | 'SMA' | 'SMARule' | 'PhoneAssociation';
    readonly uid: string;
}
export declare class ChimeResources extends Construct {
    readonly lambda: lambda.IFunction;
    readonly chimeCustomResource: CustomResource;
    constructor(scope: Construct, id: string, props: ChimeResourceProps);
    private ensureLambda;
}
export interface PhoneAssociationProps extends cdk.ResourceProps {
    readonly voiceConnectorId: string;
    readonly e164PhoneNumber: string;
}
export declare class PhoneAssociation extends Construct {
    readonly phoneAssociationResource: AwsCustomResource;
    constructor(scope: Construct, id: string, props: PhoneAssociationProps);
}
